import{s as ot,o as Mt,n as mt}from"../chunks/scheduler.182ea377.js";import{S as ft,i as yt,g as i,s as n,p as u,A as jt,h as r,f as s,c as a,j as y,q as h,m as p,k as c,v as d,a as t,r as o,d as M,t as m,u as f}from"../chunks/index.008d68e4.js";import{T as bt}from"../chunks/Tip.4f096367.js";import{I as Le}from"../chunks/IconCopyLink.96bbb92b.js";import{C as w}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as wt}from"../chunks/DocNotebookDropdown.bb388256.js";function Zt(Oe){let j,A="The following Flax schedulers are <em>not yet compatible</em> with the Flax Stable Diffusion Pipeline:",g,Z,G="<li><code>FlaxLMSDiscreteScheduler</code></li> <li><code>FlaxDDPMScheduler</code></li>";return{c(){j=i("p"),j.innerHTML=A,g=n(),Z=i("ul"),Z.innerHTML=G},l(b){j=r(b,"P",{"data-svelte-h":!0}),p(j)!=="svelte-18uc691"&&(j.innerHTML=A),g=a(b),Z=r(b,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-pfgls0"&&(Z.innerHTML=G)},m(b,R){t(b,j,R),t(b,g,R),t(b,Z,R)},p:mt,d(b){b&&(s(j),s(g),s(Z))}}}function gt(Oe){let j,A,g,Z,G,b,R,Ae,ms="Schedulers",el,H,ll,D,fs=`Diffusion pipelines are inherently a collection of diffusion models and schedulers that are partly independent from each other. This means that one is able to switch out parts of the pipeline to better customize
a pipeline to one’s use case. The best example of this is the <a href="../api/schedulers/overview">Schedulers</a>.`,sl,F,ys=`Whereas diffusion models usually simply define the forward pass from noise to a less noisy sample,
schedulers define the whole denoising process, <em>i.e.</em>:`,tl,z,js="<li>How many denoising steps?</li> <li>Stochastic or deterministic?</li> <li>What algorithm to use to find the denoised sample?</li>",nl,L,bs=`They can be quite complex and often define a trade-off between <strong>denoising speed</strong> and <strong>denoising quality</strong>.
It is extremely difficult to measure quantitatively which scheduler works best for a given diffusion pipeline, so it is often recommended to simply try out which works best.`,al,Q,ws="The following paragraphs show how to do so with the 🧨 Diffusers library.",il,J,_,Qe,Y,us,Re,Zs="Load pipeline",rl,P,gs='Let’s start by loading the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model in the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',pl,q,cl,K,Js="Next, we move it to GPU:",ul,O,hl,T,V,Ye,ee,hs,He,Ts="Access the scheduler",dl,le,Us=`The scheduler is always one of the components of the pipeline and is usually called <code>&quot;scheduler&quot;</code>.
So it can be accessed via the <code>&quot;scheduler&quot;</code> property.`,ol,se,Ml,te,vs="<strong>Output</strong>:",ml,ne,fl,ae,ks=`We can see that the scheduler is of type <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.
Cool, now let’s compare the scheduler in its performance to other schedulers.
First we define a prompt on which we will test all the different schedulers:`,yl,ie,jl,re,Gs="Next, we create a generator from a random seed that will ensure that we can generate similar images as well as run the pipeline:",bl,pe,wl,x,_s='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_pndm.png" width="400"/> <br/>',Zl,U,S,Pe,ce,ds,De,Vs="Changing the scheduler",gl,ue,xs=`Now we show how easy it is to change the scheduler of a pipeline. Every scheduler has a property <code>compatibles</code>
which defines all compatible schedulers. You can take a look at all available, compatible schedulers for the Stable Diffusion pipeline as follows.`,Jl,he,Tl,de,Ss="<strong>Output</strong>:",Ul,oe,vl,Me,Ws="Cool, lots of schedulers to look at. Feel free to have a look at their respective class definitions:",kl,me,$s='<li><a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/heun#diffusers.HeunDiscreteScheduler">HeunDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/deis#diffusers.DEISMultistepScheduler">DEISMultistepScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/dpm_discrete#diffusers.KDPM2DiscreteScheduler">KDPM2DiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/singlestep_dpm_solver#diffusers.DPMSolverSinglestepScheduler">DPMSolverSinglestepScheduler</a>,</li> <li><a href="/docs/diffusers/main/en/api/schedulers/dpm_discrete_ancestral#diffusers.KDPM2AncestralDiscreteScheduler">KDPM2AncestralDiscreteScheduler</a>.</li>',Gl,fe,Cs=`We will now compare the input prompt with all other schedulers. To change the scheduler of the pipeline you can make use of the
convenient <code>config</code> property in combination with the <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> function.`,_l,ye,Vl,je,Ns="returns a dictionary of the configuration of the scheduler:",xl,be,Is="<strong>Output</strong>:",Sl,we,Wl,Ze,Xs=`This configuration can then be used to instantiate a scheduler
of a different class that is compatible with the pipeline. Here,
we change the scheduler to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>.`,$l,ge,Cl,Je,Bs="Cool, now we can run the pipeline again to compare the generation quality.",Nl,Te,Il,W,Es='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_ddim.png" width="400"/> <br/>',Xl,Ue,As='If you are a JAX/Flax user, please check <a href="#changing-the-scheduler-in-flax">this section</a> instead.',Bl,v,$,qe,ve,os,Fe,Rs="Compare schedulers",El,ke,Hs=`So far we have tried running the stable diffusion pipeline with two schedulers: <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> and <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>.
A number of better schedulers have been released that can be run with much fewer steps; let’s compare them here:`,Al,Ge,Ds='<a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a> usually leads to better results:',Rl,_e,Hl,C,Fs='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_lms.png" width="400"/> <br/>',Dl,Ve,zs='<a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> and <a href="/docs/diffusers/main/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a> can generate high quality results with as little as 30 steps.',Fl,xe,zl,N,Ls='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_euler_discrete.png" width="400"/> <br/>',Ll,Se,Qs="and:",Ql,We,Yl,I,Ys='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_euler_ancestral.png" width="400"/> <br/>',Pl,$e,Ps='<a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> gives a reasonable speed/quality trade-off and can be run with as little as 20 steps.',ql,Ce,Kl,X,qs='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_dpm.png" width="400"/> <br/>',Ol,Ne,Ks=`As you can see, most images look very similar and are arguably of very similar quality. It often really depends on the specific use case which scheduler to choose. A good approach is always to run multiple different
schedulers to compare results.`,es,k,B,Ke,Ie,Ms,ze,Os="Changing the Scheduler in Flax",ls,Xe,et='If you are a JAX/Flax user, you can also change the default pipeline scheduler. This is a complete example of how to run inference using the Flax Stable Diffusion pipeline and the super-fast <a href="../api/schedulers/multistep_dpm_solver">DPM-Solver++ scheduler</a>:',ss,Be,ts,E,ns;return b=new Le({}),H=new wt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"}]}}),Y=new Le({}),q=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFsb2dpbigpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

login()

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`}}),O=new w({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)'}}),ee=new Le({}),se=new w({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVy",highlighted:"pipeline.scheduler"}}),ne=new w({props:{code:"UE5ETVNjaGVkdWxlciUyMCU3QiUwQSUyMCUyMCUyMl9jbGFzc19uYW1lJTIyJTNBJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuMjEuNCUyMiUyQyUwQSUyMCUyMCUyMmJldGFfZW5kJTIyJTNBJTIwMC4wMTIlMkMlMEElMjAlMjAlMjJiZXRhX3NjaGVkdWxlJTIyJTNBJTIwJTIyc2NhbGVkX2xpbmVhciUyMiUyQyUwQSUyMCUyMCUyMmJldGFfc3RhcnQlMjIlM0ElMjAwLjAwMDg1JTJDJTBBJTIwJTIwJTIyY2xpcF9zYW1wbGUlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMm51bV90cmFpbl90aW1lc3RlcHMlMjIlM0ElMjAxMDAwJTJDJTBBJTIwJTIwJTIyc2V0X2FscGhhX3RvX29uZSUyMiUzQSUyMGZhbHNlJTJDJTBBJTIwJTIwJTIyc2tpcF9wcmtfc3RlcHMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIyc3RlcHNfb2Zmc2V0JTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMnRpbWVzdGVwX3NwYWNpbmclMjIlM0ElMjAlMjJsZWFkaW5nJTIyJTJDJTBBJTIwJTIwJTIydHJhaW5lZF9iZXRhcyUyMiUzQSUyMG51bGwlMEElN0Q=",highlighted:`PNDMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;PNDMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.21.4&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.012</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;scaled_linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.00085</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: <span class="hljs-literal">false</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;set_alpha_to_one&quot;</span>: <span class="hljs-literal">false</span>,
  <span class="hljs-string">&quot;skip_prk_steps&quot;</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-string">&quot;steps_offset&quot;</span>: <span class="hljs-number">1</span>,
  <span class="hljs-string">&quot;timestep_spacing&quot;</span>: <span class="hljs-string">&quot;leading&quot;</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: <span class="hljs-literal">null</span>
}`}}),ie=new w({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBNYXJzJTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBoaWdoJTIwZGVmaW5pdGlvbi4lMjI=",highlighted:'prompt = <span class="hljs-string">&quot;A photograph of an astronaut riding a horse on Mars, high resolution, high definition.&quot;</span>'}}),pe=new w({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`}}),ce=new Le({}),he=new w({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVz",highlighted:"pipeline.scheduler.compatibles"}}),oe=new w({props:{code:"JTVCZGlmZnVzZXJzLnV0aWxzLmR1bW15X3RvcmNoX2FuZF90b3JjaHNkZV9vYmplY3RzLkRQTVNvbHZlclNERVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZXVsZXJfZGlzY3JldGUuRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfbG1zX2Rpc2NyZXRlLkxNU0Rpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZGltLkRESU1TY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RkcG0uRERQTVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfaGV1bl9kaXNjcmV0ZS5IZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RwbXNvbHZlcl9tdWx0aXN0ZXAuRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19wbmRtLlBORE1TY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2V1bGVyX2FuY2VzdHJhbF9kaXNjcmV0ZS5FdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ191bmlwY19tdWx0aXN0ZXAuVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2tfZHBtXzJfZGlzY3JldGUuS0RQTTJEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZHBtc29sdmVyX3NpbmdsZXN0ZXAuRFBNU29sdmVyU2luZ2xlc3RlcFNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9hbmNlc3RyYWxfZGlzY3JldGUuS0RQTTJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciU1RA==",highlighted:`[<span class="hljs-keyword">diffusers.utils.dummy_torch_and_torchsde_objects.DPMSolverSDEScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_ddim.DDIMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_pndm.PNDMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler]</span>`}}),ye=new w({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZw==",highlighted:"pipeline.scheduler.config"}}),we=new w({props:{code:"RnJvemVuRGljdCglNUIoJ251bV90cmFpbl90aW1lc3RlcHMnJTJDJTIwMTAwMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2JldGFfc3RhcnQnJTJDJTIwMC4wMDA4NSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2JldGFfZW5kJyUyQyUyMDAuMDEyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnYmV0YV9zY2hlZHVsZSclMkMlMjAnc2NhbGVkX2xpbmVhcicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCd0cmFpbmVkX2JldGFzJyUyQyUyME5vbmUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCdza2lwX3Bya19zdGVwcyclMkMlMjBUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnc2V0X2FscGhhX3RvX29uZSclMkMlMjBGYWxzZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ3ByZWRpY3Rpb25fdHlwZSclMkMlMjAnZXBzaWxvbicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCd0aW1lc3RlcF9zcGFjaW5nJyUyQyUyMCdsZWFkaW5nJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ3N0ZXBzX29mZnNldCclMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnX3VzZV9kZWZhdWx0X3ZhbHVlcyclMkMlMjAlNUIndGltZXN0ZXBfc3BhY2luZyclMkMlMjAncHJlZGljdGlvbl90eXBlJyU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ19jbGFzc19uYW1lJyUyQyUyMCdQTkRNU2NoZWR1bGVyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ19kaWZmdXNlcnNfdmVyc2lvbiclMkMlMjAnMC4yMS40JyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2NsaXBfc2FtcGxlJyUyQyUyMEZhbHNlKSU1RCk=",highlighted:`FrozenDict([(<span class="hljs-string">&#x27;num_train_timesteps&#x27;</span>, <span class="hljs-number">1000</span>),
            (<span class="hljs-string">&#x27;beta_start&#x27;</span>, <span class="hljs-number">0.00085</span>),
            (<span class="hljs-string">&#x27;beta_end&#x27;</span>, <span class="hljs-number">0.012</span>),
            (<span class="hljs-string">&#x27;beta_schedule&#x27;</span>, <span class="hljs-string">&#x27;scaled_linear&#x27;</span>),
            (<span class="hljs-string">&#x27;trained_betas&#x27;</span>, <span class="hljs-literal">None</span>),
            (<span class="hljs-string">&#x27;skip_prk_steps&#x27;</span>, <span class="hljs-literal">True</span>),
            (<span class="hljs-string">&#x27;set_alpha_to_one&#x27;</span>, <span class="hljs-literal">False</span>),
            (<span class="hljs-string">&#x27;prediction_type&#x27;</span>, <span class="hljs-string">&#x27;epsilon&#x27;</span>),
            (<span class="hljs-string">&#x27;timestep_spacing&#x27;</span>, <span class="hljs-string">&#x27;leading&#x27;</span>),
            (<span class="hljs-string">&#x27;steps_offset&#x27;</span>, <span class="hljs-number">1</span>),
            (<span class="hljs-string">&#x27;_use_default_values&#x27;</span>, [<span class="hljs-string">&#x27;timestep_spacing&#x27;</span>, <span class="hljs-string">&#x27;prediction_type&#x27;</span>]),
            (<span class="hljs-string">&#x27;_class_name&#x27;</span>, <span class="hljs-string">&#x27;PNDMScheduler&#x27;</span>),
            (<span class="hljs-string">&#x27;_diffusers_version&#x27;</span>, <span class="hljs-string">&#x27;0.21.4&#x27;</span>),
            (<span class="hljs-string">&#x27;clip_sample&#x27;</span>, <span class="hljs-literal">False</span>)])`}}),ge=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)`}}),Te=new w({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`}}),ve=new Le({}),_e=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTBBJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwTE1TRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoOCklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

pipeline.scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`}}),xe=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image`}}),We=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerAncestralDiscreteScheduler

pipeline.scheduler = EulerAncestralDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image`}}),Ce=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg4KSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`}}),Ie=new Le({}),Be=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline, FlaxDPMSolverMultistepScheduler

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
scheduler, scheduler_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>
)
pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
    model_id,
    scheduler=scheduler,
    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
    dtype=jax.numpy.bfloat16,
)
params[<span class="hljs-string">&quot;scheduler&quot;</span>] = scheduler_state

<span class="hljs-comment"># Generate 1 image per parallel device (8 on TPUv2-8 or TPUv3-8)</span>
prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
num_samples = jax.device_count()
prompt_ids = pipeline.prepare_inputs([prompt] * num_samples)

prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
num_inference_steps = <span class="hljs-number">25</span>

<span class="hljs-comment"># shard inputs and rng</span>
params = replicate(params)
prng_seed = jax.random.split(prng_seed, jax.device_count())
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`}}),E=new bt({props:{warning:!0,$$slots:{default:[Zt]},$$scope:{ctx:Oe}}}),{c(){j=i("meta"),A=n(),g=i("h1"),Z=i("a"),G=i("span"),u(b.$$.fragment),R=n(),Ae=i("span"),Ae.textContent=ms,el=n(),u(H.$$.fragment),ll=n(),D=i("p"),D.innerHTML=fs,sl=n(),F=i("p"),F.innerHTML=ys,tl=n(),z=i("ul"),z.innerHTML=js,nl=n(),L=i("p"),L.innerHTML=bs,al=n(),Q=i("p"),Q.textContent=ws,il=n(),J=i("h2"),_=i("a"),Qe=i("span"),u(Y.$$.fragment),us=n(),Re=i("span"),Re.textContent=Zs,rl=n(),P=i("p"),P.innerHTML=gs,pl=n(),u(q.$$.fragment),cl=n(),K=i("p"),K.textContent=Js,ul=n(),u(O.$$.fragment),hl=n(),T=i("h2"),V=i("a"),Ye=i("span"),u(ee.$$.fragment),hs=n(),He=i("span"),He.textContent=Ts,dl=n(),le=i("p"),le.innerHTML=Us,ol=n(),u(se.$$.fragment),Ml=n(),te=i("p"),te.innerHTML=vs,ml=n(),u(ne.$$.fragment),fl=n(),ae=i("p"),ae.innerHTML=ks,yl=n(),u(ie.$$.fragment),jl=n(),re=i("p"),re.textContent=Gs,bl=n(),u(pe.$$.fragment),wl=n(),x=i("p"),x.innerHTML=_s,Zl=n(),U=i("h2"),S=i("a"),Pe=i("span"),u(ce.$$.fragment),ds=n(),De=i("span"),De.textContent=Vs,gl=n(),ue=i("p"),ue.innerHTML=xs,Jl=n(),u(he.$$.fragment),Tl=n(),de=i("p"),de.innerHTML=Ss,Ul=n(),u(oe.$$.fragment),vl=n(),Me=i("p"),Me.textContent=Ws,kl=n(),me=i("ul"),me.innerHTML=$s,Gl=n(),fe=i("p"),fe.innerHTML=Cs,_l=n(),u(ye.$$.fragment),Vl=n(),je=i("p"),je.textContent=Ns,xl=n(),be=i("p"),be.innerHTML=Is,Sl=n(),u(we.$$.fragment),Wl=n(),Ze=i("p"),Ze.innerHTML=Xs,$l=n(),u(ge.$$.fragment),Cl=n(),Je=i("p"),Je.textContent=Bs,Nl=n(),u(Te.$$.fragment),Il=n(),W=i("p"),W.innerHTML=Es,Xl=n(),Ue=i("p"),Ue.innerHTML=As,Bl=n(),v=i("h2"),$=i("a"),qe=i("span"),u(ve.$$.fragment),os=n(),Fe=i("span"),Fe.textContent=Rs,El=n(),ke=i("p"),ke.innerHTML=Hs,Al=n(),Ge=i("p"),Ge.innerHTML=Ds,Rl=n(),u(_e.$$.fragment),Hl=n(),C=i("p"),C.innerHTML=Fs,Dl=n(),Ve=i("p"),Ve.innerHTML=zs,Fl=n(),u(xe.$$.fragment),zl=n(),N=i("p"),N.innerHTML=Ls,Ll=n(),Se=i("p"),Se.textContent=Qs,Ql=n(),u(We.$$.fragment),Yl=n(),I=i("p"),I.innerHTML=Ys,Pl=n(),$e=i("p"),$e.innerHTML=Ps,ql=n(),u(Ce.$$.fragment),Kl=n(),X=i("p"),X.innerHTML=qs,Ol=n(),Ne=i("p"),Ne.textContent=Ks,es=n(),k=i("h2"),B=i("a"),Ke=i("span"),u(Ie.$$.fragment),Ms=n(),ze=i("span"),ze.textContent=Os,ls=n(),Xe=i("p"),Xe.innerHTML=et,ss=n(),u(Be.$$.fragment),ts=n(),u(E.$$.fragment),this.h()},l(e){const l=jt("svelte-1phssyn",document.head);j=r(l,"META",{name:!0,content:!0}),l.forEach(s),A=a(e),g=r(e,"H1",{class:!0});var Ee=y(g);Z=r(Ee,"A",{id:!0,class:!0,href:!0});var lt=y(Z);G=r(lt,"SPAN",{});var st=y(G);h(b.$$.fragment,st),st.forEach(s),lt.forEach(s),R=a(Ee),Ae=r(Ee,"SPAN",{"data-svelte-h":!0}),p(Ae)!=="svelte-1mh2qlv"&&(Ae.textContent=ms),Ee.forEach(s),el=a(e),h(H.$$.fragment,e),ll=a(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1xyod4r"&&(D.innerHTML=fs),sl=a(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-pj1fnh"&&(F.innerHTML=ys),tl=a(e),z=r(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1387f55"&&(z.innerHTML=js),nl=a(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-7vywvj"&&(L.innerHTML=bs),al=a(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1h9ag03"&&(Q.textContent=ws),il=a(e),J=r(e,"H2",{class:!0});var as=y(J);_=r(as,"A",{id:!0,class:!0,href:!0});var tt=y(_);Qe=r(tt,"SPAN",{});var nt=y(Qe);h(Y.$$.fragment,nt),nt.forEach(s),tt.forEach(s),us=a(as),Re=r(as,"SPAN",{"data-svelte-h":!0}),p(Re)!=="svelte-15vpfd"&&(Re.textContent=Zs),as.forEach(s),rl=a(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1pkuhgi"&&(P.innerHTML=gs),pl=a(e),h(q.$$.fragment,e),cl=a(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1pntiyw"&&(K.textContent=Js),ul=a(e),h(O.$$.fragment,e),hl=a(e),T=r(e,"H2",{class:!0});var is=y(T);V=r(is,"A",{id:!0,class:!0,href:!0});var at=y(V);Ye=r(at,"SPAN",{});var it=y(Ye);h(ee.$$.fragment,it),it.forEach(s),at.forEach(s),hs=a(is),He=r(is,"SPAN",{"data-svelte-h":!0}),p(He)!=="svelte-oxb2rp"&&(He.textContent=Ts),is.forEach(s),dl=a(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-ifniwj"&&(le.innerHTML=Us),ol=a(e),h(se.$$.fragment,e),Ml=a(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-jl1fz0"&&(te.innerHTML=vs),ml=a(e),h(ne.$$.fragment,e),fl=a(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-hpwiea"&&(ae.innerHTML=ks),yl=a(e),h(ie.$$.fragment,e),jl=a(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1crup8"&&(re.textContent=Gs),bl=a(e),h(pe.$$.fragment,e),wl=a(e),x=r(e,"P",{align:!0,"data-svelte-h":!0}),p(x)!=="svelte-4ve60e"&&(x.innerHTML=_s),Zl=a(e),U=r(e,"H2",{class:!0});var rs=y(U);S=r(rs,"A",{id:!0,class:!0,href:!0});var rt=y(S);Pe=r(rt,"SPAN",{});var pt=y(Pe);h(ce.$$.fragment,pt),pt.forEach(s),rt.forEach(s),ds=a(rs),De=r(rs,"SPAN",{"data-svelte-h":!0}),p(De)!=="svelte-ld4zt6"&&(De.textContent=Vs),rs.forEach(s),gl=a(e),ue=r(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-tey2p6"&&(ue.innerHTML=xs),Jl=a(e),h(he.$$.fragment,e),Tl=a(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-jl1fz0"&&(de.innerHTML=Ss),Ul=a(e),h(oe.$$.fragment,e),vl=a(e),Me=r(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1km1sb3"&&(Me.textContent=Ws),kl=a(e),me=r(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-1tu9dgy"&&(me.innerHTML=$s),Gl=a(e),fe=r(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-hjmddp"&&(fe.innerHTML=Cs),_l=a(e),h(ye.$$.fragment,e),Vl=a(e),je=r(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-sih4ln"&&(je.textContent=Ns),xl=a(e),be=r(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-jl1fz0"&&(be.innerHTML=Is),Sl=a(e),h(we.$$.fragment,e),Wl=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1dvqgs9"&&(Ze.innerHTML=Xs),$l=a(e),h(ge.$$.fragment,e),Cl=a(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-zqrmvv"&&(Je.textContent=Bs),Nl=a(e),h(Te.$$.fragment,e),Il=a(e),W=r(e,"P",{align:!0,"data-svelte-h":!0}),p(W)!=="svelte-cbz2yl"&&(W.innerHTML=Es),Xl=a(e),Ue=r(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1g5sqb9"&&(Ue.innerHTML=As),Bl=a(e),v=r(e,"H2",{class:!0});var ps=y(v);$=r(ps,"A",{id:!0,class:!0,href:!0});var ct=y($);qe=r(ct,"SPAN",{});var ut=y(qe);h(ve.$$.fragment,ut),ut.forEach(s),ct.forEach(s),os=a(ps),Fe=r(ps,"SPAN",{"data-svelte-h":!0}),p(Fe)!=="svelte-17kte7g"&&(Fe.textContent=Rs),ps.forEach(s),El=a(e),ke=r(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1ic8jtg"&&(ke.innerHTML=Hs),Al=a(e),Ge=r(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1wgmwzp"&&(Ge.innerHTML=Ds),Rl=a(e),h(_e.$$.fragment,e),Hl=a(e),C=r(e,"P",{align:!0,"data-svelte-h":!0}),p(C)!=="svelte-1grq2s7"&&(C.innerHTML=Fs),Dl=a(e),Ve=r(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-qncfah"&&(Ve.innerHTML=zs),Fl=a(e),h(xe.$$.fragment,e),zl=a(e),N=r(e,"P",{align:!0,"data-svelte-h":!0}),p(N)!=="svelte-49gzme"&&(N.innerHTML=Ls),Ll=a(e),Se=r(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1x72rsv"&&(Se.textContent=Qs),Ql=a(e),h(We.$$.fragment,e),Yl=a(e),I=r(e,"P",{align:!0,"data-svelte-h":!0}),p(I)!=="svelte-14z2yp4"&&(I.innerHTML=Ys),Pl=a(e),$e=r(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-8u6v6j"&&($e.innerHTML=Ps),ql=a(e),h(Ce.$$.fragment,e),Kl=a(e),X=r(e,"P",{align:!0,"data-svelte-h":!0}),p(X)!=="svelte-y1ydb2"&&(X.innerHTML=qs),Ol=a(e),Ne=r(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-im52jk"&&(Ne.textContent=Ks),es=a(e),k=r(e,"H2",{class:!0});var cs=y(k);B=r(cs,"A",{id:!0,class:!0,href:!0});var ht=y(B);Ke=r(ht,"SPAN",{});var dt=y(Ke);h(Ie.$$.fragment,dt),dt.forEach(s),ht.forEach(s),Ms=a(cs),ze=r(cs,"SPAN",{"data-svelte-h":!0}),p(ze)!=="svelte-1opo2gg"&&(ze.textContent=Os),cs.forEach(s),ls=a(e),Xe=r(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-141dnef"&&(Xe.innerHTML=et),ss=a(e),h(Be.$$.fragment,e),ts=a(e),h(E.$$.fragment,e),this.h()},h(){c(j,"name","hf:doc:metadata"),c(j,"content",JSON.stringify(Jt)),c(Z,"id","schedulers"),c(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Z,"href","#schedulers"),c(g,"class","relative group"),c(_,"id","load-pipeline"),c(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(_,"href","#load-pipeline"),c(J,"class","relative group"),c(V,"id","access-the-scheduler"),c(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(V,"href","#access-the-scheduler"),c(T,"class","relative group"),c(x,"align","center"),c(S,"id","changing-the-scheduler"),c(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(S,"href","#changing-the-scheduler"),c(U,"class","relative group"),c(W,"align","center"),c($,"id","compare-schedulers"),c($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c($,"href","#compare-schedulers"),c(v,"class","relative group"),c(C,"align","center"),c(N,"align","center"),c(I,"align","center"),c(X,"align","center"),c(B,"id","changing-the-scheduler-in-flax"),c(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(B,"href","#changing-the-scheduler-in-flax"),c(k,"class","relative group")},m(e,l){d(document.head,j),t(e,A,l),t(e,g,l),d(g,Z),d(Z,G),o(b,G,null),d(g,R),d(g,Ae),t(e,el,l),o(H,e,l),t(e,ll,l),t(e,D,l),t(e,sl,l),t(e,F,l),t(e,tl,l),t(e,z,l),t(e,nl,l),t(e,L,l),t(e,al,l),t(e,Q,l),t(e,il,l),t(e,J,l),d(J,_),d(_,Qe),o(Y,Qe,null),d(J,us),d(J,Re),t(e,rl,l),t(e,P,l),t(e,pl,l),o(q,e,l),t(e,cl,l),t(e,K,l),t(e,ul,l),o(O,e,l),t(e,hl,l),t(e,T,l),d(T,V),d(V,Ye),o(ee,Ye,null),d(T,hs),d(T,He),t(e,dl,l),t(e,le,l),t(e,ol,l),o(se,e,l),t(e,Ml,l),t(e,te,l),t(e,ml,l),o(ne,e,l),t(e,fl,l),t(e,ae,l),t(e,yl,l),o(ie,e,l),t(e,jl,l),t(e,re,l),t(e,bl,l),o(pe,e,l),t(e,wl,l),t(e,x,l),t(e,Zl,l),t(e,U,l),d(U,S),d(S,Pe),o(ce,Pe,null),d(U,ds),d(U,De),t(e,gl,l),t(e,ue,l),t(e,Jl,l),o(he,e,l),t(e,Tl,l),t(e,de,l),t(e,Ul,l),o(oe,e,l),t(e,vl,l),t(e,Me,l),t(e,kl,l),t(e,me,l),t(e,Gl,l),t(e,fe,l),t(e,_l,l),o(ye,e,l),t(e,Vl,l),t(e,je,l),t(e,xl,l),t(e,be,l),t(e,Sl,l),o(we,e,l),t(e,Wl,l),t(e,Ze,l),t(e,$l,l),o(ge,e,l),t(e,Cl,l),t(e,Je,l),t(e,Nl,l),o(Te,e,l),t(e,Il,l),t(e,W,l),t(e,Xl,l),t(e,Ue,l),t(e,Bl,l),t(e,v,l),d(v,$),d($,qe),o(ve,qe,null),d(v,os),d(v,Fe),t(e,El,l),t(e,ke,l),t(e,Al,l),t(e,Ge,l),t(e,Rl,l),o(_e,e,l),t(e,Hl,l),t(e,C,l),t(e,Dl,l),t(e,Ve,l),t(e,Fl,l),o(xe,e,l),t(e,zl,l),t(e,N,l),t(e,Ll,l),t(e,Se,l),t(e,Ql,l),o(We,e,l),t(e,Yl,l),t(e,I,l),t(e,Pl,l),t(e,$e,l),t(e,ql,l),o(Ce,e,l),t(e,Kl,l),t(e,X,l),t(e,Ol,l),t(e,Ne,l),t(e,es,l),t(e,k,l),d(k,B),d(B,Ke),o(Ie,Ke,null),d(k,Ms),d(k,ze),t(e,ls,l),t(e,Xe,l),t(e,ss,l),o(Be,e,l),t(e,ts,l),o(E,e,l),ns=!0},p(e,[l]){const Ee={};l&2&&(Ee.$$scope={dirty:l,ctx:e}),E.$set(Ee)},i(e){ns||(M(b.$$.fragment,e),M(H.$$.fragment,e),M(Y.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(pe.$$.fragment,e),M(ce.$$.fragment,e),M(he.$$.fragment,e),M(oe.$$.fragment,e),M(ye.$$.fragment,e),M(we.$$.fragment,e),M(ge.$$.fragment,e),M(Te.$$.fragment,e),M(ve.$$.fragment,e),M(_e.$$.fragment,e),M(xe.$$.fragment,e),M(We.$$.fragment,e),M(Ce.$$.fragment,e),M(Ie.$$.fragment,e),M(Be.$$.fragment,e),M(E.$$.fragment,e),ns=!0)},o(e){m(b.$$.fragment,e),m(H.$$.fragment,e),m(Y.$$.fragment,e),m(q.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),m(oe.$$.fragment,e),m(ye.$$.fragment,e),m(we.$$.fragment,e),m(ge.$$.fragment,e),m(Te.$$.fragment,e),m(ve.$$.fragment,e),m(_e.$$.fragment,e),m(xe.$$.fragment,e),m(We.$$.fragment,e),m(Ce.$$.fragment,e),m(Ie.$$.fragment,e),m(Be.$$.fragment,e),m(E.$$.fragment,e),ns=!1},d(e){e&&(s(A),s(g),s(el),s(ll),s(D),s(sl),s(F),s(tl),s(z),s(nl),s(L),s(al),s(Q),s(il),s(J),s(rl),s(P),s(pl),s(cl),s(K),s(ul),s(hl),s(T),s(dl),s(le),s(ol),s(Ml),s(te),s(ml),s(fl),s(ae),s(yl),s(jl),s(re),s(bl),s(wl),s(x),s(Zl),s(U),s(gl),s(ue),s(Jl),s(Tl),s(de),s(Ul),s(vl),s(Me),s(kl),s(me),s(Gl),s(fe),s(_l),s(Vl),s(je),s(xl),s(be),s(Sl),s(Wl),s(Ze),s($l),s(Cl),s(Je),s(Nl),s(Il),s(W),s(Xl),s(Ue),s(Bl),s(v),s(El),s(ke),s(Al),s(Ge),s(Rl),s(Hl),s(C),s(Dl),s(Ve),s(Fl),s(zl),s(N),s(Ll),s(Se),s(Ql),s(Yl),s(I),s(Pl),s($e),s(ql),s(Kl),s(X),s(Ol),s(Ne),s(es),s(k),s(ls),s(Xe),s(ss),s(ts)),s(j),f(b),f(H,e),f(Y),f(q,e),f(O,e),f(ee),f(se,e),f(ne,e),f(ie,e),f(pe,e),f(ce),f(he,e),f(oe,e),f(ye,e),f(we,e),f(ge,e),f(Te,e),f(ve),f(_e,e),f(xe,e),f(We,e),f(Ce,e),f(Ie),f(Be,e),f(E,e)}}}const Jt={local:"schedulers",sections:[{local:"load-pipeline",title:"Load pipeline"},{local:"access-the-scheduler",title:"Access the scheduler"},{local:"changing-the-scheduler",title:"Changing the scheduler"},{local:"compare-schedulers",title:"Compare schedulers"},{local:"changing-the-scheduler-in-flax",title:"Changing the Scheduler in Flax"}],title:"Schedulers"};function Tt(Oe){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends ft{constructor(j){super(),yt(this,j,Tt,gt,ot,{})}}export{xt as component};
