import{s as Lt,o as Dt,n as ft}from"../chunks/scheduler.182ea377.js";import{S as At,i as Kt,g as l,s as i,p as y,A as Ot,h as a,f as t,c as o,j as f,q as b,m as p,k as u,v as d,a as n,r as M,d as w,t as g,u as j}from"../chunks/index.008d68e4.js";import{T as yt}from"../chunks/Tip.4f096367.js";import{I as Ze}from"../chunks/IconCopyLink.96bbb92b.js";import{C as we}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as es}from"../chunks/DocNotebookDropdown.bb388256.js";function ts(W){let r,J='💡 We strongly recommend reading PyTorch’s <a href="https://pytorch.org/docs/stable/notes/randomness.html" rel="nofollow">statement about reproducibility</a>:',c,m,B="<p>Completely reproducible results are not guaranteed across PyTorch releases, individual commits, or different platforms. Furthermore, results may not be reproducible between CPU and GPU executions, even when using identical seeds.</p>";return{c(){r=l("p"),r.innerHTML=J,c=i(),m=l("blockquote"),m.innerHTML=B},l(h){r=a(h,"P",{"data-svelte-h":!0}),p(r)!=="svelte-mk56g"&&(r.innerHTML=J),c=o(h),m=a(h,"BLOCKQUOTE",{"data-svelte-h":!0}),p(m)!=="svelte-16ppwuq"&&(m.innerHTML=B)},m(h,x){n(h,r,x),n(h,c,x),n(h,m,x)},p:ft,d(h){h&&(t(r),t(c),t(m))}}}function ss(W){let r,J=`💡 It might be a bit unintuitive at first to pass <code>Generator</code> objects to the pipeline instead of
just integer values representing the seed, but this is the recommended design when dealing with
probabilistic models in PyTorch, as <code>Generator</code>s are <em>random states</em> that can be
passed to multiple pipelines in a sequence.`;return{c(){r=l("p"),r.innerHTML=J},l(c){r=a(c,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1whzuej"&&(r.innerHTML=J)},m(c,m){n(c,r,m)},p:ft,d(c){c&&t(r)}}}function ns(W){let r,J=`💡 If reproducibility is important, we recommend always passing a CPU generator.
The performance loss is often neglectable, and you’ll generate much more similar
values than if the pipeline had been run on a GPU.`;return{c(){r=l("p"),r.textContent=J},l(c){r=a(c,"P",{"data-svelte-h":!0}),p(r)!=="svelte-6qqsvj"&&(r.textContent=J)},m(c,m){n(c,r,m)},p:ft,d(c){c&&t(r)}}}function ls(W){let r,J,c,m,B,h,x,he,bt="Create reproducible pipelines",We,R,Be,E,Mt='Reproducibility is important for testing, replicating results, and can even be used to <a href="reusing_seeds">improve image quality</a>. However, the randomness in diffusion models is a desired property because it allows the pipeline to generate different images every time it is run. While you can’t expect to get the exact same results across platforms, you can expect results to be reproducible across releases and platforms within a certain tolerance range. Even then, tolerance varies depending on the diffusion pipeline and checkpoint.',_e,H,wt="This is why it’s important to understand how to control sources of randomness in diffusion models or use deterministic algorithms.",Ce,_,$e,T,C,ge,X,ut,ye,gt="Control randomness",ke,P,jt=`During inference, pipelines rely heavily on random sampling operations which include creating the
Gaussian noise tensors to denoise and adding noise to the scheduling step.`,Ie,S,Jt='Take a look at the tensor values in the <a href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.DDIMPipeline">DDIMPipeline</a> after two inference steps:',Ge,N,Ve,Q,Tt="Running the code above prints one value, but if you run it again you get a different value. What is going on here?",xe,z,vt='Every time the pipeline is run, <a href="https://pytorch.org/docs/stable/generated/torch.randn.html" rel="nofollow"><code>torch.randn</code></a> uses a different random seed to create Gaussian noise which is denoised stepwise. This leads to a different result each time it is run, which is great for diffusion pipelines since it generates a different random image each time.',Re,F,Ut="But if you need to reliably generate the same image, that’ll depend on whether you’re running the pipeline on a CPU or GPU.",Ee,v,$,je,q,dt,fe,Zt="CPU",He,Y,Wt='To generate reproducible results on a CPU, you’ll need to use a PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a> and set a seed:',Xe,L,Pe,D,Bt="Now when you run the code above, it always prints a value of <code>1491.1711</code> no matter what because the <code>Generator</code> object with the seed is passed to all the random functions of the pipeline.",Se,A,_t="If you run this code example on your specific hardware and PyTorch version, you should get a similar, if not the same, result.",Ne,k,Qe,U,I,Je,K,mt,be,Ct="GPU",ze,O,$t="Writing a reproducible pipeline on a GPU is a bit trickier, and full reproducibility across different hardware is not guaranteed because matrix multiplication - which diffusion pipelines require a lot of - is less deterministic on a GPU than a CPU. For example, if you run the same code example above on a GPU:",Fe,ee,qe,te,kt="The result is not the same even though you’re using an identical seed because the GPU uses a different random number generator than the CPU.",Ye,se,It="To circumvent this problem, 🧨 Diffusers has a <code>randn_tensor()</code> function for creating random noise on the CPU, and then moving the tensor to a GPU if necessary. The <code>randn_tensor</code> function is used everywhere inside the pipeline, allowing the user to <strong>always</strong> pass a CPU <code>Generator</code> even if the pipeline is run on a GPU.",Le,ne,Gt="You’ll see the results are much closer now!",De,le,Ae,G,Ke,ae,Vt=`Finally, for more complex pipelines such as <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.UnCLIPPipeline">UnCLIPPipeline</a>, these are often extremely
susceptible to precision error propagation. Don’t expect similar results across
different GPU hardware or PyTorch versions. In this case, you’ll need to run
exactly the same hardware and PyTorch version for full reproducibility.`,Oe,Z,V,Te,ie,ht,Me,xt="Deterministic algorithms",et,oe,Rt="You can also configure PyTorch to use deterministic algorithms to create a reproducible pipeline. However, you should be aware that deterministic algorithms may be slower than nondeterministic ones and you may observe a decrease in performance. But if reproducibility is important to you, then this is the way to go!",tt,re,Et='Nondeterministic behavior occurs when operations are launched in more than one CUDA stream. To avoid this, set the environment variable <a href="https://docs.nvidia.com/cuda/cublas/index.html#results-reproducibility" rel="nofollow"><code>CUBLAS_WORKSPACE_CONFIG</code></a> to <code>:16:8</code> to only use one buffer size during runtime.',st,pe,Ht='PyTorch typically benchmarks multiple algorithms to select the fastest one, but if you want reproducibility, you should disable this feature because the benchmark may select different algorithms each time. Lastly, pass <code>True</code> to <a href="https://pytorch.org/docs/stable/generated/torch.use_deterministic_algorithms.html" rel="nofollow"><code>torch.use_deterministic_algorithms</code></a> to enable deterministic algorithms.',nt,ce,lt,ue,Xt="Now when you run the same pipeline twice, you’ll get identical results.",at,de,it;return h=new Ze({}),R=new es({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/reproducibility.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/reproducibility.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/reproducibility.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/reproducibility.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/reproducibility.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/reproducibility.ipynb"}]}}),_=new yt({props:{$$slots:{default:[ts]},$$scope:{ctx:W}}}),X=new Ze({}),N=new we({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1QaXBlbGluZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUwQSUyMyUyMHJ1biUyMHBpcGVsaW5lJTIwZm9yJTIwanVzdCUyMHR3byUyMHN0ZXBzJTIwYW5kJTIwcmV0dXJuJTIwbnVtcHklMjB0ZW5zb3IlMEFpbWFnZSUyMCUzRCUyMGRkaW0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDIlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyKS5pbWFnZXMlMEFwcmludChucC5hYnMoaW1hZ2UpLnN1bSgpKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`}}),q=new Ze({}),L=new we({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTBBJTIzJTIwY3JlYXRlJTIwYSUyMGdlbmVyYXRvciUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBJTIzJTIwcnVuJTIwcGlwZWxpbmUlMjBmb3IlMjBqdXN0JTIwdHdvJTIwc3RlcHMlMjBhbmQlMjByZXR1cm4lMjBudW1weSUyMHRlbnNvciUwQWltYWdlJTIwJTNEJTIwZGRpbShudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyUwQXByaW50KG5wLmFicyhpbWFnZSkuc3VtKCkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># create a generator for reproducibility</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`}}),k=new yt({props:{$$slots:{default:[ss]},$$scope:{ctx:W}}}),K=new Ze({}),ee=new we({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBZGRpbS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMGElMjBnZW5lcmF0b3IlMjBmb3IlMjByZXByb2R1Y2liaWxpdHklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEElMEElMjMlMjBydW4lMjBwaXBlbGluZSUyMGZvciUyMGp1c3QlMjB0d28lMjBzdGVwcyUyMGFuZCUyMHJldHVybiUyMG51bXB5JTIwdGVuc29yJTBBaW1hZ2UlMjAlM0QlMjBkZGltKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMiUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTBBcHJpbnQobnAuYWJzKGltYWdlKS5zdW0oKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># create a generator for reproducibility</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`}}),le=new we({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBZGRpbS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMGElMjBnZW5lcmF0b3IlMjBmb3IlMjByZXByb2R1Y2liaWxpdHklM0IlMjBub3RpY2UlMjB5b3UlMjBkb24ndCUyMHBsYWNlJTIwaXQlMjBvbiUyMHRoZSUyMEdQVSElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQSUyMyUyMHJ1biUyMHBpcGVsaW5lJTIwZm9yJTIwanVzdCUyMHR3byUyMHN0ZXBzJTIwYW5kJTIwcmV0dXJuJTIwbnVtcHklMjB0ZW5zb3IlMEFpbWFnZSUyMCUzRCUyMGRkaW0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDIlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlMEFwcmludChucC5hYnMoaW1hZ2UpLnN1bSgpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># create a generator for reproducibility; notice you don&#x27;t place it on the GPU!</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`}}),G=new yt({props:{$$slots:{default:[ns]},$$scope:{ctx:W}}}),ie=new Ze({}),ce=new we({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW9zLmVudmlyb24lNUIlMjJDVUJMQVNfV09SS1NQQUNFX0NPTkZJRyUyMiU1RCUyMCUzRCUyMCUyMiUzQTE2JTNBOCUyMiUwQSUwQXRvcmNoLmJhY2tlbmRzLmN1ZG5uLmJlbmNobWFyayUyMCUzRCUyMEZhbHNlJTBBdG9yY2gudXNlX2RldGVybWluaXN0aWNfYWxnb3JpdGhtcyhUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch

os.environ[<span class="hljs-string">&quot;CUBLAS_WORKSPACE_CONFIG&quot;</span>] = <span class="hljs-string">&quot;:16:8&quot;</span>

torch.backends.cudnn.benchmark = <span class="hljs-literal">False</span>
torch.use_deterministic_algorithms(<span class="hljs-literal">True</span>)`}}),de=new we({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBZyUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBiZWFyJTIwaXMlMjBwbGF5aW5nJTIwYSUyMGd1aXRhciUyMG9uJTIwVGltZXMlMjBTcXVhcmUlMjIlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MiUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFwcmludCglMjJMX2luZiUyMGRpc3QlMjAlM0QlMjIlMkMlMjBhYnMocmVzdWx0MSUyMC0lMjByZXN1bHQyKS5tYXgoKSklMEElMjJMX2luZiUyMGRpc3QlMjAlM0QlMjB0ZW5zb3IoMC4lMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnKSUyMg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, StableDiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
g = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A bear is playing a guitar on Times Square&quot;</span>

g.manual_seed(<span class="hljs-number">0</span>)
result1 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

g.manual_seed(<span class="hljs-number">0</span>)
result2 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L_inf dist =&quot;</span>, <span class="hljs-built_in">abs</span>(result1 - result2).<span class="hljs-built_in">max</span>())
<span class="hljs-string">&quot;L_inf dist = tensor(0., device=&#x27;cuda:0&#x27;)&quot;</span>`}}),{c(){r=l("meta"),J=i(),c=l("h1"),m=l("a"),B=l("span"),y(h.$$.fragment),x=i(),he=l("span"),he.textContent=bt,We=i(),y(R.$$.fragment),Be=i(),E=l("p"),E.innerHTML=Mt,_e=i(),H=l("p"),H.textContent=wt,Ce=i(),y(_.$$.fragment),$e=i(),T=l("h2"),C=l("a"),ge=l("span"),y(X.$$.fragment),ut=i(),ye=l("span"),ye.textContent=gt,ke=i(),P=l("p"),P.textContent=jt,Ie=i(),S=l("p"),S.innerHTML=Jt,Ge=i(),y(N.$$.fragment),Ve=i(),Q=l("p"),Q.textContent=Tt,xe=i(),z=l("p"),z.innerHTML=vt,Re=i(),F=l("p"),F.textContent=Ut,Ee=i(),v=l("h3"),$=l("a"),je=l("span"),y(q.$$.fragment),dt=i(),fe=l("span"),fe.textContent=Zt,He=i(),Y=l("p"),Y.innerHTML=Wt,Xe=i(),y(L.$$.fragment),Pe=i(),D=l("p"),D.innerHTML=Bt,Se=i(),A=l("p"),A.textContent=_t,Ne=i(),y(k.$$.fragment),Qe=i(),U=l("h3"),I=l("a"),Je=l("span"),y(K.$$.fragment),mt=i(),be=l("span"),be.textContent=Ct,ze=i(),O=l("p"),O.textContent=$t,Fe=i(),y(ee.$$.fragment),qe=i(),te=l("p"),te.textContent=kt,Ye=i(),se=l("p"),se.innerHTML=It,Le=i(),ne=l("p"),ne.textContent=Gt,De=i(),y(le.$$.fragment),Ae=i(),y(G.$$.fragment),Ke=i(),ae=l("p"),ae.innerHTML=Vt,Oe=i(),Z=l("h2"),V=l("a"),Te=l("span"),y(ie.$$.fragment),ht=i(),Me=l("span"),Me.textContent=xt,et=i(),oe=l("p"),oe.textContent=Rt,tt=i(),re=l("p"),re.innerHTML=Et,st=i(),pe=l("p"),pe.innerHTML=Ht,nt=i(),y(ce.$$.fragment),lt=i(),ue=l("p"),ue.textContent=Xt,at=i(),y(de.$$.fragment),this.h()},l(e){const s=Ot("svelte-1phssyn",document.head);r=a(s,"META",{name:!0,content:!0}),s.forEach(t),J=o(e),c=a(e,"H1",{class:!0});var me=f(c);m=a(me,"A",{id:!0,class:!0,href:!0});var ve=f(m);B=a(ve,"SPAN",{});var Ue=f(B);b(h.$$.fragment,Ue),Ue.forEach(t),ve.forEach(t),x=o(me),he=a(me,"SPAN",{"data-svelte-h":!0}),p(he)!=="svelte-1nua4d8"&&(he.textContent=bt),me.forEach(t),We=o(e),b(R.$$.fragment,e),Be=o(e),E=a(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1sdj1n4"&&(E.innerHTML=Mt),_e=o(e),H=a(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-spyond"&&(H.textContent=wt),Ce=o(e),b(_.$$.fragment,e),$e=o(e),T=a(e,"H2",{class:!0});var ot=f(T);C=a(ot,"A",{id:!0,class:!0,href:!0});var Pt=f(C);ge=a(Pt,"SPAN",{});var St=f(ge);b(X.$$.fragment,St),St.forEach(t),Pt.forEach(t),ut=o(ot),ye=a(ot,"SPAN",{"data-svelte-h":!0}),p(ye)!=="svelte-10ngjj0"&&(ye.textContent=gt),ot.forEach(t),ke=o(e),P=a(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1tn5oba"&&(P.textContent=jt),Ie=o(e),S=a(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-uupr25"&&(S.innerHTML=Jt),Ge=o(e),b(N.$$.fragment,e),Ve=o(e),Q=a(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-6e7pfa"&&(Q.textContent=Tt),xe=o(e),z=a(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-mhfmil"&&(z.innerHTML=vt),Re=o(e),F=a(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-opovkl"&&(F.textContent=Ut),Ee=o(e),v=a(e,"H3",{class:!0});var rt=f(v);$=a(rt,"A",{id:!0,class:!0,href:!0});var Nt=f($);je=a(Nt,"SPAN",{});var Qt=f(je);b(q.$$.fragment,Qt),Qt.forEach(t),Nt.forEach(t),dt=o(rt),fe=a(rt,"SPAN",{"data-svelte-h":!0}),p(fe)!=="svelte-1xflp2p"&&(fe.textContent=Zt),rt.forEach(t),He=o(e),Y=a(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1kryd8j"&&(Y.innerHTML=Wt),Xe=o(e),b(L.$$.fragment,e),Pe=o(e),D=a(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-jf8pj"&&(D.innerHTML=Bt),Se=o(e),A=a(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1mz2u42"&&(A.textContent=_t),Ne=o(e),b(k.$$.fragment,e),Qe=o(e),U=a(e,"H3",{class:!0});var pt=f(U);I=a(pt,"A",{id:!0,class:!0,href:!0});var zt=f(I);Je=a(zt,"SPAN",{});var Ft=f(Je);b(K.$$.fragment,Ft),Ft.forEach(t),zt.forEach(t),mt=o(pt),be=a(pt,"SPAN",{"data-svelte-h":!0}),p(be)!=="svelte-1giv785"&&(be.textContent=Ct),pt.forEach(t),ze=o(e),O=a(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-vhxkpf"&&(O.textContent=$t),Fe=o(e),b(ee.$$.fragment,e),qe=o(e),te=a(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1tpavxr"&&(te.textContent=kt),Ye=o(e),se=a(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-oj1ygm"&&(se.innerHTML=It),Le=o(e),ne=a(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-v5oouu"&&(ne.textContent=Gt),De=o(e),b(le.$$.fragment,e),Ae=o(e),b(G.$$.fragment,e),Ke=o(e),ae=a(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-zwtlbi"&&(ae.innerHTML=Vt),Oe=o(e),Z=a(e,"H2",{class:!0});var ct=f(Z);V=a(ct,"A",{id:!0,class:!0,href:!0});var qt=f(V);Te=a(qt,"SPAN",{});var Yt=f(Te);b(ie.$$.fragment,Yt),Yt.forEach(t),qt.forEach(t),ht=o(ct),Me=a(ct,"SPAN",{"data-svelte-h":!0}),p(Me)!=="svelte-1jk9829"&&(Me.textContent=xt),ct.forEach(t),et=o(e),oe=a(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-j2780s"&&(oe.textContent=Rt),tt=o(e),re=a(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-10j1qq1"&&(re.innerHTML=Et),st=o(e),pe=a(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1ncc9dd"&&(pe.innerHTML=Ht),nt=o(e),b(ce.$$.fragment,e),lt=o(e),ue=a(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-b9yuf0"&&(ue.textContent=Xt),at=o(e),b(de.$$.fragment,e),this.h()},h(){u(r,"name","hf:doc:metadata"),u(r,"content",JSON.stringify(as)),u(m,"id","create-reproducible-pipelines"),u(m,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(m,"href","#create-reproducible-pipelines"),u(c,"class","relative group"),u(C,"id","control-randomness"),u(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(C,"href","#control-randomness"),u(T,"class","relative group"),u($,"id","cpu"),u($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u($,"href","#cpu"),u(v,"class","relative group"),u(I,"id","gpu"),u(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(I,"href","#gpu"),u(U,"class","relative group"),u(V,"id","deterministic-algorithms"),u(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(V,"href","#deterministic-algorithms"),u(Z,"class","relative group")},m(e,s){d(document.head,r),n(e,J,s),n(e,c,s),d(c,m),d(m,B),M(h,B,null),d(c,x),d(c,he),n(e,We,s),M(R,e,s),n(e,Be,s),n(e,E,s),n(e,_e,s),n(e,H,s),n(e,Ce,s),M(_,e,s),n(e,$e,s),n(e,T,s),d(T,C),d(C,ge),M(X,ge,null),d(T,ut),d(T,ye),n(e,ke,s),n(e,P,s),n(e,Ie,s),n(e,S,s),n(e,Ge,s),M(N,e,s),n(e,Ve,s),n(e,Q,s),n(e,xe,s),n(e,z,s),n(e,Re,s),n(e,F,s),n(e,Ee,s),n(e,v,s),d(v,$),d($,je),M(q,je,null),d(v,dt),d(v,fe),n(e,He,s),n(e,Y,s),n(e,Xe,s),M(L,e,s),n(e,Pe,s),n(e,D,s),n(e,Se,s),n(e,A,s),n(e,Ne,s),M(k,e,s),n(e,Qe,s),n(e,U,s),d(U,I),d(I,Je),M(K,Je,null),d(U,mt),d(U,be),n(e,ze,s),n(e,O,s),n(e,Fe,s),M(ee,e,s),n(e,qe,s),n(e,te,s),n(e,Ye,s),n(e,se,s),n(e,Le,s),n(e,ne,s),n(e,De,s),M(le,e,s),n(e,Ae,s),M(G,e,s),n(e,Ke,s),n(e,ae,s),n(e,Oe,s),n(e,Z,s),d(Z,V),d(V,Te),M(ie,Te,null),d(Z,ht),d(Z,Me),n(e,et,s),n(e,oe,s),n(e,tt,s),n(e,re,s),n(e,st,s),n(e,pe,s),n(e,nt,s),M(ce,e,s),n(e,lt,s),n(e,ue,s),n(e,at,s),M(de,e,s),it=!0},p(e,[s]){const me={};s&2&&(me.$$scope={dirty:s,ctx:e}),_.$set(me);const ve={};s&2&&(ve.$$scope={dirty:s,ctx:e}),k.$set(ve);const Ue={};s&2&&(Ue.$$scope={dirty:s,ctx:e}),G.$set(Ue)},i(e){it||(w(h.$$.fragment,e),w(R.$$.fragment,e),w(_.$$.fragment,e),w(X.$$.fragment,e),w(N.$$.fragment,e),w(q.$$.fragment,e),w(L.$$.fragment,e),w(k.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(le.$$.fragment,e),w(G.$$.fragment,e),w(ie.$$.fragment,e),w(ce.$$.fragment,e),w(de.$$.fragment,e),it=!0)},o(e){g(h.$$.fragment,e),g(R.$$.fragment,e),g(_.$$.fragment,e),g(X.$$.fragment,e),g(N.$$.fragment,e),g(q.$$.fragment,e),g(L.$$.fragment,e),g(k.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(G.$$.fragment,e),g(ie.$$.fragment,e),g(ce.$$.fragment,e),g(de.$$.fragment,e),it=!1},d(e){e&&(t(J),t(c),t(We),t(Be),t(E),t(_e),t(H),t(Ce),t($e),t(T),t(ke),t(P),t(Ie),t(S),t(Ge),t(Ve),t(Q),t(xe),t(z),t(Re),t(F),t(Ee),t(v),t(He),t(Y),t(Xe),t(Pe),t(D),t(Se),t(A),t(Ne),t(Qe),t(U),t(ze),t(O),t(Fe),t(qe),t(te),t(Ye),t(se),t(Le),t(ne),t(De),t(Ae),t(Ke),t(ae),t(Oe),t(Z),t(et),t(oe),t(tt),t(re),t(st),t(pe),t(nt),t(lt),t(ue),t(at)),t(r),j(h),j(R,e),j(_,e),j(X),j(N,e),j(q),j(L,e),j(k,e),j(K),j(ee,e),j(le,e),j(G,e),j(ie),j(ce,e),j(de,e)}}}const as={local:"create-reproducible-pipelines",sections:[{local:"control-randomness",sections:[{local:"cpu",title:"CPU"},{local:"gpu",title:"GPU"}],title:"Control randomness"},{local:"deterministic-algorithms",title:"Deterministic algorithms"}],title:"Create reproducible pipelines"};function is(W){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends At{constructor(r){super(),Kt(this,r,is,ls,Lt,{})}}export{ms as component};
