import{s as Hn,o as zn,n as An}from"../chunks/scheduler.182ea377.js";import{S as Dn,i as qn,g as i,s as n,p as u,A as Yn,h as o,f as s,c as a,j as y,q as f,m as p,k as r,v as c,a as t,r as d,d as h,t as M,u as m}from"../chunks/index.008d68e4.js";import{T as Sn}from"../chunks/Tip.4f096367.js";import{I as Z}from"../chunks/IconCopyLink.96bbb92b.js";import{C as U}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as Fn}from"../chunks/DocNotebookDropdown.bb388256.js";function Ln(dl){let J,b='💡 Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you are interested in learning in more detail about how the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){J=i("p"),J.innerHTML=b},l(T){J=o(T,"P",{"data-svelte-h":!0}),p(J)!=="svelte-164e214"&&(J.innerHTML=b)},m(T,w){t(T,J,w)},p:An,d(T){T&&s(J)}}}function Pn(dl){let J,b="💡 When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories instead of variations (for example, <code>stable-diffusion-v1-4</code> and <code>stable-diffusion-v1-5</code>).";return{c(){J=i("p"),J.innerHTML=b},l(T){J=o(T,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1bx6mv6"&&(J.innerHTML=b)},m(T,w){t(T,J,w)},p:An,d(T){T&&s(J)}}}function On(dl){let J,b,T,w,jl,H,ht,hl,jt="Load pipelines, models, and schedulers",Bl,z,Gl,D,vt='Having an easy way to use a diffusion system for inference is essential to 🧨 Diffusers. Diffusion systems often consist of multiple components like parameterized models, tokenizers, and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API, while remaining flexible enough to be adapted for other use cases, such as loading each component individually as building blocks to assemble your own diffusion system.',$l,q,Ct="Everything you need for inference or training is accessible with the <code>from_pretrained()</code> method.",xl,Y,gt="This guide will show you how to load:",Ql,F,It="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li> <li>models and schedulers</li>",El,j,R,vl,L,Mt,Ml,Vt="Diffusion Pipeline",Xl,_,Sl,P,kt='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is the simplest and most generic way to load the latest trending diffusion model from the <a href="https://huggingface.co/models?library=diffusers&amp;sort=trending" rel="nofollow">Hub</a>. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> method automatically detects the correct pipeline class from the checkpoint, downloads, and caches all the required configuration and weight files, and returns a pipeline instance ready for inference.',Al,O,Hl,K,Wt='You can also load a checkpoint with its specific pipeline class. The example above loaded a Stable Diffusion model; to get the same result, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class:',zl,ee,Dl,le,Nt='A checkpoint (such as <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow"><code>CompVis/stable-diffusion-v1-4</code></a> or <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) may also be used for more than one task, like text-to-image or image-to-image. To differentiate what task you want to use the checkpoint for, you have to load it directly with its corresponding task-specific pipeline class:',ql,se,Yl,v,B,Cl,te,mt,ml,Rt="Local pipeline",Fl,ne,_t='To load a diffusion pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow"><code>git-lfs</code></a> to manually download the checkpoint (in this case, <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) to your local disk. This creates a local folder, <code>./stable-diffusion-v1-5</code>, on your disk:',Ll,ae,Pl,ie,Bt='Then pass the local path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>:',Ol,oe,Kl,pe,Gt='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download any files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',es,C,G,gl,re,yt,yl,$t="Swap components in a pipeline",ls,ce,xt="You can customize the default components of any pipeline with another compatible component. Customization is important because:",ss,ue,Qt="<li>Changing the scheduler is important for exploring the trade-off between generation speed and quality.</li> <li>Different components of a model are typically trained independently and you can swap out a component with a better-performing one.</li> <li>During finetuning, usually only some components - like the UNet or text encoder - are trained.</li>",ts,fe,Et="To find out which schedulers are compatible for customization, you can use the <code>compatibles</code> method:",ns,de,as,he,Xt='Let’s use the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method to replace the default <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> with a more performant scheduler, <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>. The <code>subfolder=&quot;scheduler&quot;</code> argument is required to load the scheduler configuration from the correct <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.',is,Me,St='Then you can pass the new <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> instance to the <code>scheduler</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',os,me,ps,g,$,Il,ye,Jt,Jl,At="Safety checker",rs,Je,Ht='Diffusion models like Stable Diffusion can generate harmful content, which is why 🧨 Diffusers has a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> to check generated outputs against known hardcoded NSFW content. If you’d like to disable the safety checker for whatever reason, pass <code>None</code> to the <code>safety_checker</code> argument:',cs,Ue,us,I,x,Vl,Te,Ut,Ul,zt="Reuse components across pipelines",fs,we,Dt='You can also reuse the same components in multiple pipelines to avoid loading the weights into RAM twice. Use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.components">components</a> method to save the components:',ds,be,hs,Ze,qt="Then you can pass the <code>components</code> to another pipeline without reloading the weights into RAM:",Ms,je,ms,ve,Yt="You can also pass the components individually to the pipeline if you want more flexibility over which components to reuse or disable. For example, to reuse the same components in the text-to-image pipeline, except for the safety checker and feature extractor, in the image-to-image pipeline:",ys,Ce,Js,V,Q,kl,ge,Tt,Tl,Ft="Checkpoint variants",Us,Ie,Lt="A checkpoint variant is usually a checkpoint whose weights are:",Ts,Ve,Pt='<li>Stored in a different floating point type for lower precision and lower storage, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow"><code>torch.float16</code></a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights, which shouldn’t be used for inference. You should use these to continue fine-tuning a model.</li>',ws,E,bs,ke,Ot='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">Safetensors</a>), model structure, and weights that have identical tensor shapes.',Zs,We,Kt="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.bin</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.bin</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.bin</td> <td><code>variant</code></td></tr></tbody>",js,Ne,en="There are two important arguments to know for loading variants:",vs,Re,ln='<li><p><code>torch_dtype</code> defines the floating point precision of the loaded checkpoints. For example, if you want to save bandwidth by loading a <code>fp16</code> variant, you should specify <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to <code>fp16</code>. Otherwise, the <code>fp16</code> weights are converted to the default <code>fp32</code> precision. You can also load the original checkpoint without defining the <code>variant</code> argument, and convert it to <code>fp16</code> with <code>torch_dtype=torch.float16</code>. In this case, the default <code>fp32</code> weights are downloaded first, and then they’re converted to <code>fp16</code> after loading.</p></li> <li><p><code>variant</code> defines which files should be loaded from the repository. For example, if you want to load a <code>non_ema</code> variant from the <a href="https://huggingface.co/diffusers/stable-diffusion-variants/tree/main/unet" rel="nofollow"><code>diffusers/stable-diffusion-variants</code></a> repository, you should specify <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> files.</p></li>',Cs,_e,gs,Be,sn='To save a checkpoint stored in a different floating-point type or as a non-EMA variant, use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method and specify the <code>variant</code> argument. You should try and save a variant to the same folder as the original checkpoint, so you can load both from the same folder:',Is,Ge,Vs,$e,tn="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint:",ks,xe,Ws,k,X,Wl,Qe,wt,wl,nn="Models",Ns,Ee,an='Models are loaded from the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> method, which downloads and caches the latest version of the model weights and configurations. If the latest files are available in the local cache, <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> reuses files in the cache instead of re-downloading them.',Rs,Xe,on='Models can be loaded from a subfolder with the <code>subfolder</code> argument. For example, the model weights for <code>runwayml/stable-diffusion-v1-5</code> are stored in the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/unet" rel="nofollow"><code>unet</code></a> subfolder:',_s,Se,Bs,Ae,pn='Or directly from a repository’s <a href="https://huggingface.co/google/ddpm-cifar10-32/tree/main" rel="nofollow">directory</a>:',Gs,He,$s,ze,rn='You can also load and save model variants by specifying the <code>variant</code> argument in <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> and <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>:',xs,De,Qs,W,S,Nl,qe,bt,bl,cn="Schedulers",Es,Ye,un='Schedulers are loaded from the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method, and unlike models, schedulers are <strong>not parameterized</strong> or <strong>trained</strong>; they are defined by a configuration file.',Xs,Fe,fn=`Loading schedulers does not consume any significant amount of memory and the same configuration file can be used for a variety of different schedulers.
For example, the following schedulers are compatible with <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which means you can load the same scheduler configuration file in any of these classes:`,Ss,Le,As,N,A,Rl,Pe,Zt,Zl,dn="DiffusionPipeline explained",Hs,Oe,hn='As a class method, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',zs,Ke,Mn='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="../api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',Ds,el,mn='The pipelines’ underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>.',qs,ll,Ys,sl,yn='You’ll see pipeline is an instance of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',Fs,tl,Jn='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',Ls,nl,Ps,al,Un='Compare the components of the pipeline instance to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',Os,il,Ks,ol,Tn="You can access each of the components of the pipeline as an attribute to view its configuration:",et,pl,lt,rl,wn='Every pipeline expects a <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file that tells the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',st,cl,bn="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",tt,ul,nt;return H=new Z({}),z=new Fn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),L=new Z({}),_=new Sn({props:{$$slots:{default:[Ln]},$$scope:{ctx:dl}}}),O=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`}}),ee=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`}}),se=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionImg2ImgPipeline.from_pretrained(repo_id)`}}),te=new Z({}),ae=new U({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`}}),oe=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`}}),re=new Z({}),de=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFzdGFibGVfZGlmZnVzaW9uLnNjaGVkdWxlci5jb21wYXRpYmxlcw==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion.scheduler.compatibles`}}),me=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, EulerDiscreteScheduler

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
scheduler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, scheduler=scheduler, use_safetensors=<span class="hljs-literal">True</span>)`}}),ye=new Z({}),Ue=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMjIlMjIlMjIlMEFZb3UlMjBoYXZlJTIwZGlzYWJsZWQlMjB0aGUlMjBzYWZldHklMjBjaGVja2VyJTIwZm9yJTIwJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIwYnklMjBwYXNzaW5nJTIwJTYwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTYwLiUyMEVuc3VyZSUyMHRoYXQlMjB5b3UlMjBhYmlkZSUyMGJ5JTIwdGhlJTIwY29uZGl0aW9ucyUyMG9mJTIwdGhlJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTIwbGljZW5zZSUyMGFuZCUyMGRvJTIwbm90JTIwZXhwb3NlJTIwdW5maWx0ZXJlZCUyMHJlc3VsdHMlMjBpbiUyMHNlcnZpY2VzJTIwb3IlMjBhcHBsaWNhdGlvbnMlMjBvcGVuJTIwdG8lMjB0aGUlMjBwdWJsaWMuJTIwQm90aCUyMHRoZSUyMGRpZmZ1c2VycyUyMHRlYW0lMjBhbmQlMjBIdWdnaW5nJTIwRmFjZSUyMHN0cm9uZ2x5JTIwcmVjb21tZW5kJTIwa2VlcGluZyUyMHRoZSUyMHNhZmV0eSUyMGZpbHRlciUyMGVuYWJsZWQlMjBpbiUyMGFsbCUyMHB1YmxpYy1mYWNpbmclMjBjaXJjdW1zdGFuY2VzJTJDJTIwZGlzYWJsaW5nJTIwaXQlMjBvbmx5JTIwZm9yJTIwdXNlJTIwY2FzZXMlMjB0aGF0JTIwaW52b2x2ZSUyMGFuYWx5emluZyUyMG5ldHdvcmslMjBiZWhhdmlvciUyMG9yJTIwYXVkaXRpbmclMjBpdHMlMjByZXN1bHRzLiUyMEZvciUyMG1vcmUlMjBpbmZvcm1hdGlvbiUyQyUyMHBsZWFzZSUyMGhhdmUlMjBhJTIwbG9vayUyMGF0JTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMlMkZwdWxsJTJGMjU0JTIwLiUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`}}),Te=new Z({}),be=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5jb21wb25lbnRz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

components = stable_diffusion_txt2img.components`}}),je=new U({props:{code:"c3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqY29tcG9uZW50cyk=",highlighted:"stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(**components)"}}),Ce=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBc3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHZhZSUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy52YWUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHVuZXQlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudW5ldCUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5zY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(
    vae=stable_diffusion_txt2img.vae,
    text_encoder=stable_diffusion_txt2img.text_encoder,
    tokenizer=stable_diffusion_txt2img.tokenizer,
    unet=stable_diffusion_txt2img.unet,
    scheduler=stable_diffusion_txt2img.scheduler,
    safety_checker=<span class="hljs-literal">None</span>,
    feature_extractor=<span class="hljs-literal">None</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
)`}}),ge=new Z({}),E=new Sn({props:{$$slots:{default:[Pn]},$$scope:{ctx:dl}}}),_e=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBsb2FkJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMGxvYWQlMjBub25fZW1hJTIwdmFyaWFudCUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load fp16 variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># load non_ema variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`}}),Ge=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwc2F2ZSUyMGFzJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUyMyUyMHNhdmUlMjBhcyUyMG5vbi1lbWElMjB2YXJpYW50JTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># save as fp16 variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-comment"># save as non-ema variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`}}),xe=new U({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIzJTIwJUYwJTlGJTkxJThEJTIwdGhpcyUyMHdvcmtzJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`}}),Qe=new Z({}),Se=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
model = UNet2DConditionModel.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`}}),He=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

repo_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>
model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`}}),De=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbl9lbWElMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGbG9jYWwtdW5ldCUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
model.save_pretrained(<span class="hljs-string">&quot;./local-unet&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`}}),qe=new Z({}),Le=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRERJTVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMFBORE1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBKSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQWRkcG0lMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRkaW0lMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXBuZG0lMjAlM0QlMjBQTkRNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWxtcyUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWV1bGVyX2FuYyUyMCUzRCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBZXVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRwbSUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEElMjMlMjByZXBsYWNlJTIwJTYwZHBtJTYwJTIwd2l0aCUyMGFueSUyMG9mJTIwJTYwZGRwbSU2MCUyQyUyMCU2MGRkaW0lNjAlMkMlMjAlNjBwbmRtJTYwJTJDJTIwJTYwbG1zJTYwJTJDJTIwJTYwZXVsZXJfYW5jJTYwJTJDJTIwJTYwZXVsZXIlNjAlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEZHBtJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDPMScheduler,
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    EulerAncestralDiscreteScheduler,
    EulerDiscreteScheduler,
    DPMSolverMultistepScheduler,
)

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

ddpm = DDPMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
ddim = DDIMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
pndm = PNDMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
lms = LMSDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler_anc = EulerAncestralDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
dpm = DPMSolverMultistepScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

<span class="hljs-comment"># replace \`dpm\` with any of \`ddpm\`, \`ddim\`, \`pndm\`, \`lms\`, \`euler_anc\`, \`euler\`</span>
pipeline = StableDiffusionPipeline.from_pretrained(repo_id, scheduler=dpm, use_safetensors=<span class="hljs-literal">True</span>)`}}),Pe=new Z({}),ll=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcHJpbnQocGlwZWxpbmUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`}}),nl=new U({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`}}),il=new U({props:{code:"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",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.json
├── model_index.json
├── safety_checker
│   ├── config.json
|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   ├── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── scheduler
│   └── scheduler_config.json
├── text_encoder
│   ├── config.json
</span>|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   </span>|<span class="hljs-string">── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.json
│   ├── tokenizer_config.json
│   └── vocab.json
├── unet
│   ├── config.json
│   ├── diffusion_pytorch_model.bin
</span>|<span class="hljs-string">   </span>|<span class="hljs-string">── diffusion_pytorch_model.fp16.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.f16.safetensors
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.safetensors
│   └── diffusion_pytorch_model.safetensors
</span>|<span class="hljs-string">── vae
.   ├── config.json
.   ├── diffusion_pytorch_model.bin
    ├── diffusion_pytorch_model.fp16.bin
    ├── diffusion_pytorch_model.fp16.safetensors
    └── diffusion_pytorch_model.safetensors</span>`}}),pl=new U({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSUwQSk=",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
    clean_up_tokenization_spaces=<span class="hljs-literal">True</span>
)`}}),ul=new U({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`}}),{c(){J=i("meta"),b=n(),T=i("h1"),w=i("a"),jl=i("span"),u(H.$$.fragment),ht=n(),hl=i("span"),hl.textContent=jt,Bl=n(),u(z.$$.fragment),Gl=n(),D=i("p"),D.innerHTML=vt,$l=n(),q=i("p"),q.innerHTML=Ct,xl=n(),Y=i("p"),Y.textContent=gt,Ql=n(),F=i("ul"),F.innerHTML=It,El=n(),j=i("h2"),R=i("a"),vl=i("span"),u(L.$$.fragment),Mt=n(),Ml=i("span"),Ml.textContent=Vt,Xl=n(),u(_.$$.fragment),Sl=n(),P=i("p"),P.innerHTML=kt,Al=n(),u(O.$$.fragment),Hl=n(),K=i("p"),K.innerHTML=Wt,zl=n(),u(ee.$$.fragment),Dl=n(),le=i("p"),le.innerHTML=Nt,ql=n(),u(se.$$.fragment),Yl=n(),v=i("h3"),B=i("a"),Cl=i("span"),u(te.$$.fragment),mt=n(),ml=i("span"),ml.textContent=Rt,Fl=n(),ne=i("p"),ne.innerHTML=_t,Ll=n(),u(ae.$$.fragment),Pl=n(),ie=i("p"),ie.innerHTML=Bt,Ol=n(),u(oe.$$.fragment),Kl=n(),pe=i("p"),pe.innerHTML=Gt,es=n(),C=i("h3"),G=i("a"),gl=i("span"),u(re.$$.fragment),yt=n(),yl=i("span"),yl.textContent=$t,ls=n(),ce=i("p"),ce.textContent=xt,ss=n(),ue=i("ul"),ue.innerHTML=Qt,ts=n(),fe=i("p"),fe.innerHTML=Et,ns=n(),u(de.$$.fragment),as=n(),he=i("p"),he.innerHTML=Xt,is=n(),Me=i("p"),Me.innerHTML=St,os=n(),u(me.$$.fragment),ps=n(),g=i("h3"),$=i("a"),Il=i("span"),u(ye.$$.fragment),Jt=n(),Jl=i("span"),Jl.textContent=At,rs=n(),Je=i("p"),Je.innerHTML=Ht,cs=n(),u(Ue.$$.fragment),us=n(),I=i("h3"),x=i("a"),Vl=i("span"),u(Te.$$.fragment),Ut=n(),Ul=i("span"),Ul.textContent=zt,fs=n(),we=i("p"),we.innerHTML=Dt,ds=n(),u(be.$$.fragment),hs=n(),Ze=i("p"),Ze.innerHTML=qt,Ms=n(),u(je.$$.fragment),ms=n(),ve=i("p"),ve.textContent=Yt,ys=n(),u(Ce.$$.fragment),Js=n(),V=i("h2"),Q=i("a"),kl=i("span"),u(ge.$$.fragment),Tt=n(),Tl=i("span"),Tl.textContent=Ft,Us=n(),Ie=i("p"),Ie.textContent=Lt,Ts=n(),Ve=i("ul"),Ve.innerHTML=Pt,ws=n(),u(E.$$.fragment),bs=n(),ke=i("p"),ke.innerHTML=Ot,Zs=n(),We=i("table"),We.innerHTML=Kt,js=n(),Ne=i("p"),Ne.textContent=en,vs=n(),Re=i("ul"),Re.innerHTML=ln,Cs=n(),u(_e.$$.fragment),gs=n(),Be=i("p"),Be.innerHTML=sn,Is=n(),u(Ge.$$.fragment),Vs=n(),$e=i("p"),$e.innerHTML=tn,ks=n(),u(xe.$$.fragment),Ws=n(),k=i("h2"),X=i("a"),Wl=i("span"),u(Qe.$$.fragment),wt=n(),wl=i("span"),wl.textContent=nn,Ns=n(),Ee=i("p"),Ee.innerHTML=an,Rs=n(),Xe=i("p"),Xe.innerHTML=on,_s=n(),u(Se.$$.fragment),Bs=n(),Ae=i("p"),Ae.innerHTML=pn,Gs=n(),u(He.$$.fragment),$s=n(),ze=i("p"),ze.innerHTML=rn,xs=n(),u(De.$$.fragment),Qs=n(),W=i("h2"),S=i("a"),Nl=i("span"),u(qe.$$.fragment),bt=n(),bl=i("span"),bl.textContent=cn,Es=n(),Ye=i("p"),Ye.innerHTML=un,Xs=n(),Fe=i("p"),Fe.innerHTML=fn,Ss=n(),u(Le.$$.fragment),As=n(),N=i("h2"),A=i("a"),Rl=i("span"),u(Pe.$$.fragment),Zt=n(),Zl=i("span"),Zl.textContent=dn,Hs=n(),Oe=i("p"),Oe.innerHTML=hn,zs=n(),Ke=i("ul"),Ke.innerHTML=Mn,Ds=n(),el=i("p"),el.innerHTML=mn,qs=n(),u(ll.$$.fragment),Ys=n(),sl=i("p"),sl.innerHTML=yn,Fs=n(),tl=i("ul"),tl.innerHTML=Jn,Ls=n(),u(nl.$$.fragment),Ps=n(),al=i("p"),al.innerHTML=Un,Os=n(),u(il.$$.fragment),Ks=n(),ol=i("p"),ol.textContent=Tn,et=n(),u(pl.$$.fragment),lt=n(),rl=i("p"),rl.innerHTML=wn,st=n(),cl=i("ul"),cl.innerHTML=bn,tt=n(),u(ul.$$.fragment),this.h()},l(e){const l=Yn("svelte-1phssyn",document.head);J=o(l,"META",{name:!0,content:!0}),l.forEach(s),b=a(e),T=o(e,"H1",{class:!0});var fl=y(T);w=o(fl,"A",{id:!0,class:!0,href:!0});var _l=y(w);jl=o(_l,"SPAN",{});var Zn=y(jl);f(H.$$.fragment,Zn),Zn.forEach(s),_l.forEach(s),ht=a(fl),hl=o(fl,"SPAN",{"data-svelte-h":!0}),p(hl)!=="svelte-1n1tr21"&&(hl.textContent=jt),fl.forEach(s),Bl=a(e),f(z.$$.fragment,e),Gl=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-b825yc"&&(D.innerHTML=vt),$l=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1let6ok"&&(q.innerHTML=Ct),xl=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-b6mpdv"&&(Y.textContent=gt),Ql=a(e),F=o(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-19eqgr5"&&(F.innerHTML=It),El=a(e),j=o(e,"H2",{class:!0});var at=y(j);R=o(at,"A",{id:!0,class:!0,href:!0});var jn=y(R);vl=o(jn,"SPAN",{});var vn=y(vl);f(L.$$.fragment,vn),vn.forEach(s),jn.forEach(s),Mt=a(at),Ml=o(at,"SPAN",{"data-svelte-h":!0}),p(Ml)!=="svelte-dj456g"&&(Ml.textContent=Vt),at.forEach(s),Xl=a(e),f(_.$$.fragment,e),Sl=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1een31v"&&(P.innerHTML=kt),Al=a(e),f(O.$$.fragment,e),Hl=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-87p7"&&(K.innerHTML=Wt),zl=a(e),f(ee.$$.fragment,e),Dl=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1dc1tjj"&&(le.innerHTML=Nt),ql=a(e),f(se.$$.fragment,e),Yl=a(e),v=o(e,"H3",{class:!0});var it=y(v);B=o(it,"A",{id:!0,class:!0,href:!0});var Cn=y(B);Cl=o(Cn,"SPAN",{});var gn=y(Cl);f(te.$$.fragment,gn),gn.forEach(s),Cn.forEach(s),mt=a(it),ml=o(it,"SPAN",{"data-svelte-h":!0}),p(ml)!=="svelte-1ao47d4"&&(ml.textContent=Rt),it.forEach(s),Fl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-zzamd0"&&(ne.innerHTML=_t),Ll=a(e),f(ae.$$.fragment,e),Pl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-14lmk7e"&&(ie.innerHTML=Bt),Ol=a(e),f(oe.$$.fragment,e),Kl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-i8rr5s"&&(pe.innerHTML=Gt),es=a(e),C=o(e,"H3",{class:!0});var ot=y(C);G=o(ot,"A",{id:!0,class:!0,href:!0});var In=y(G);gl=o(In,"SPAN",{});var Vn=y(gl);f(re.$$.fragment,Vn),Vn.forEach(s),In.forEach(s),yt=a(ot),yl=o(ot,"SPAN",{"data-svelte-h":!0}),p(yl)!=="svelte-qbmn7c"&&(yl.textContent=$t),ot.forEach(s),ls=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1b4jg3u"&&(ce.textContent=xt),ss=a(e),ue=o(e,"UL",{"data-svelte-h":!0}),p(ue)!=="svelte-vp14rw"&&(ue.innerHTML=Qt),ts=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-s7xu2t"&&(fe.innerHTML=Et),ns=a(e),f(de.$$.fragment,e),as=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1llio5t"&&(he.innerHTML=Xt),is=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1cym4i4"&&(Me.innerHTML=St),os=a(e),f(me.$$.fragment,e),ps=a(e),g=o(e,"H3",{class:!0});var pt=y(g);$=o(pt,"A",{id:!0,class:!0,href:!0});var kn=y($);Il=o(kn,"SPAN",{});var Wn=y(Il);f(ye.$$.fragment,Wn),Wn.forEach(s),kn.forEach(s),Jt=a(pt),Jl=o(pt,"SPAN",{"data-svelte-h":!0}),p(Jl)!=="svelte-drpzte"&&(Jl.textContent=At),pt.forEach(s),rs=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-181junk"&&(Je.innerHTML=Ht),cs=a(e),f(Ue.$$.fragment,e),us=a(e),I=o(e,"H3",{class:!0});var rt=y(I);x=o(rt,"A",{id:!0,class:!0,href:!0});var Nn=y(x);Vl=o(Nn,"SPAN",{});var Rn=y(Vl);f(Te.$$.fragment,Rn),Rn.forEach(s),Nn.forEach(s),Ut=a(rt),Ul=o(rt,"SPAN",{"data-svelte-h":!0}),p(Ul)!=="svelte-8nqft"&&(Ul.textContent=zt),rt.forEach(s),fs=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-12c191q"&&(we.innerHTML=Dt),ds=a(e),f(be.$$.fragment,e),hs=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-jytaak"&&(Ze.innerHTML=qt),Ms=a(e),f(je.$$.fragment,e),ms=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1o7di1p"&&(ve.textContent=Yt),ys=a(e),f(Ce.$$.fragment,e),Js=a(e),V=o(e,"H2",{class:!0});var ct=y(V);Q=o(ct,"A",{id:!0,class:!0,href:!0});var _n=y(Q);kl=o(_n,"SPAN",{});var Bn=y(kl);f(ge.$$.fragment,Bn),Bn.forEach(s),_n.forEach(s),Tt=a(ct),Tl=o(ct,"SPAN",{"data-svelte-h":!0}),p(Tl)!=="svelte-hialsj"&&(Tl.textContent=Ft),ct.forEach(s),Us=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-144ljdh"&&(Ie.textContent=Lt),Ts=a(e),Ve=o(e,"UL",{"data-svelte-h":!0}),p(Ve)!=="svelte-1j7sdrg"&&(Ve.innerHTML=Pt),ws=a(e),f(E.$$.fragment,e),bs=a(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-q0e9bt"&&(ke.innerHTML=Ot),Zs=a(e),We=o(e,"TABLE",{"data-svelte-h":!0}),p(We)!=="svelte-1e3wdtx"&&(We.innerHTML=Kt),js=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-16brnlv"&&(Ne.textContent=en),vs=a(e),Re=o(e,"UL",{"data-svelte-h":!0}),p(Re)!=="svelte-11239e9"&&(Re.innerHTML=ln),Cs=a(e),f(_e.$$.fragment,e),gs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-utq62g"&&(Be.innerHTML=sn),Is=a(e),f(Ge.$$.fragment,e),Vs=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-ydb193"&&($e.innerHTML=tn),ks=a(e),f(xe.$$.fragment,e),Ws=a(e),k=o(e,"H2",{class:!0});var ut=y(k);X=o(ut,"A",{id:!0,class:!0,href:!0});var Gn=y(X);Wl=o(Gn,"SPAN",{});var $n=y(Wl);f(Qe.$$.fragment,$n),$n.forEach(s),Gn.forEach(s),wt=a(ut),wl=o(ut,"SPAN",{"data-svelte-h":!0}),p(wl)!=="svelte-14dxrcz"&&(wl.textContent=nn),ut.forEach(s),Ns=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1cl76mo"&&(Ee.innerHTML=an),Rs=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1y53na1"&&(Xe.innerHTML=on),_s=a(e),f(Se.$$.fragment,e),Bs=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-7x7c45"&&(Ae.innerHTML=pn),Gs=a(e),f(He.$$.fragment,e),$s=a(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-h4z70l"&&(ze.innerHTML=rn),xs=a(e),f(De.$$.fragment,e),Qs=a(e),W=o(e,"H2",{class:!0});var ft=y(W);S=o(ft,"A",{id:!0,class:!0,href:!0});var xn=y(S);Nl=o(xn,"SPAN",{});var Qn=y(Nl);f(qe.$$.fragment,Qn),Qn.forEach(s),xn.forEach(s),bt=a(ft),bl=o(ft,"SPAN",{"data-svelte-h":!0}),p(bl)!=="svelte-1mh2qlv"&&(bl.textContent=cn),ft.forEach(s),Es=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1xjd8d0"&&(Ye.innerHTML=un),Xs=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-ubdfig"&&(Fe.innerHTML=fn),Ss=a(e),f(Le.$$.fragment,e),As=a(e),N=o(e,"H2",{class:!0});var dt=y(N);A=o(dt,"A",{id:!0,class:!0,href:!0});var En=y(A);Rl=o(En,"SPAN",{});var Xn=y(Rl);f(Pe.$$.fragment,Xn),Xn.forEach(s),En.forEach(s),Zt=a(dt),Zl=o(dt,"SPAN",{"data-svelte-h":!0}),p(Zl)!=="svelte-1xeq2kc"&&(Zl.textContent=dn),dt.forEach(s),Hs=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-nr77qh"&&(Oe.innerHTML=hn),zs=a(e),Ke=o(e,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-17dcgvz"&&(Ke.innerHTML=Mn),Ds=a(e),el=o(e,"P",{"data-svelte-h":!0}),p(el)!=="svelte-jme5sm"&&(el.innerHTML=mn),qs=a(e),f(ll.$$.fragment,e),Ys=a(e),sl=o(e,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-102ytrs"&&(sl.innerHTML=yn),Fs=a(e),tl=o(e,"UL",{"data-svelte-h":!0}),p(tl)!=="svelte-1e5gxzy"&&(tl.innerHTML=Jn),Ls=a(e),f(nl.$$.fragment,e),Ps=a(e),al=o(e,"P",{"data-svelte-h":!0}),p(al)!=="svelte-173hqz7"&&(al.innerHTML=Un),Os=a(e),f(il.$$.fragment,e),Ks=a(e),ol=o(e,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-5jik9b"&&(ol.textContent=Tn),et=a(e),f(pl.$$.fragment,e),lt=a(e),rl=o(e,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-1uoxyh2"&&(rl.innerHTML=wn),st=a(e),cl=o(e,"UL",{"data-svelte-h":!0}),p(cl)!=="svelte-hr84vt"&&(cl.innerHTML=bn),tt=a(e),f(ul.$$.fragment,e),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",JSON.stringify(Kn)),r(w,"id","load-pipelines-models-and-schedulers"),r(w,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(w,"href","#load-pipelines-models-and-schedulers"),r(T,"class","relative group"),r(R,"id","diffusion-pipeline"),r(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(R,"href","#diffusion-pipeline"),r(j,"class","relative group"),r(B,"id","local-pipeline"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#local-pipeline"),r(v,"class","relative group"),r(G,"id","swap-components-in-a-pipeline"),r(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(G,"href","#swap-components-in-a-pipeline"),r(C,"class","relative group"),r($,"id","safety-checker"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#safety-checker"),r(g,"class","relative group"),r(x,"id","reuse-components-across-pipelines"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#reuse-components-across-pipelines"),r(I,"class","relative group"),r(Q,"id","checkpoint-variants"),r(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Q,"href","#checkpoint-variants"),r(V,"class","relative group"),r(X,"id","models"),r(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(X,"href","#models"),r(k,"class","relative group"),r(S,"id","schedulers"),r(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(S,"href","#schedulers"),r(W,"class","relative group"),r(A,"id","diffusionpipeline-explained"),r(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(A,"href","#diffusionpipeline-explained"),r(N,"class","relative group")},m(e,l){c(document.head,J),t(e,b,l),t(e,T,l),c(T,w),c(w,jl),d(H,jl,null),c(T,ht),c(T,hl),t(e,Bl,l),d(z,e,l),t(e,Gl,l),t(e,D,l),t(e,$l,l),t(e,q,l),t(e,xl,l),t(e,Y,l),t(e,Ql,l),t(e,F,l),t(e,El,l),t(e,j,l),c(j,R),c(R,vl),d(L,vl,null),c(j,Mt),c(j,Ml),t(e,Xl,l),d(_,e,l),t(e,Sl,l),t(e,P,l),t(e,Al,l),d(O,e,l),t(e,Hl,l),t(e,K,l),t(e,zl,l),d(ee,e,l),t(e,Dl,l),t(e,le,l),t(e,ql,l),d(se,e,l),t(e,Yl,l),t(e,v,l),c(v,B),c(B,Cl),d(te,Cl,null),c(v,mt),c(v,ml),t(e,Fl,l),t(e,ne,l),t(e,Ll,l),d(ae,e,l),t(e,Pl,l),t(e,ie,l),t(e,Ol,l),d(oe,e,l),t(e,Kl,l),t(e,pe,l),t(e,es,l),t(e,C,l),c(C,G),c(G,gl),d(re,gl,null),c(C,yt),c(C,yl),t(e,ls,l),t(e,ce,l),t(e,ss,l),t(e,ue,l),t(e,ts,l),t(e,fe,l),t(e,ns,l),d(de,e,l),t(e,as,l),t(e,he,l),t(e,is,l),t(e,Me,l),t(e,os,l),d(me,e,l),t(e,ps,l),t(e,g,l),c(g,$),c($,Il),d(ye,Il,null),c(g,Jt),c(g,Jl),t(e,rs,l),t(e,Je,l),t(e,cs,l),d(Ue,e,l),t(e,us,l),t(e,I,l),c(I,x),c(x,Vl),d(Te,Vl,null),c(I,Ut),c(I,Ul),t(e,fs,l),t(e,we,l),t(e,ds,l),d(be,e,l),t(e,hs,l),t(e,Ze,l),t(e,Ms,l),d(je,e,l),t(e,ms,l),t(e,ve,l),t(e,ys,l),d(Ce,e,l),t(e,Js,l),t(e,V,l),c(V,Q),c(Q,kl),d(ge,kl,null),c(V,Tt),c(V,Tl),t(e,Us,l),t(e,Ie,l),t(e,Ts,l),t(e,Ve,l),t(e,ws,l),d(E,e,l),t(e,bs,l),t(e,ke,l),t(e,Zs,l),t(e,We,l),t(e,js,l),t(e,Ne,l),t(e,vs,l),t(e,Re,l),t(e,Cs,l),d(_e,e,l),t(e,gs,l),t(e,Be,l),t(e,Is,l),d(Ge,e,l),t(e,Vs,l),t(e,$e,l),t(e,ks,l),d(xe,e,l),t(e,Ws,l),t(e,k,l),c(k,X),c(X,Wl),d(Qe,Wl,null),c(k,wt),c(k,wl),t(e,Ns,l),t(e,Ee,l),t(e,Rs,l),t(e,Xe,l),t(e,_s,l),d(Se,e,l),t(e,Bs,l),t(e,Ae,l),t(e,Gs,l),d(He,e,l),t(e,$s,l),t(e,ze,l),t(e,xs,l),d(De,e,l),t(e,Qs,l),t(e,W,l),c(W,S),c(S,Nl),d(qe,Nl,null),c(W,bt),c(W,bl),t(e,Es,l),t(e,Ye,l),t(e,Xs,l),t(e,Fe,l),t(e,Ss,l),d(Le,e,l),t(e,As,l),t(e,N,l),c(N,A),c(A,Rl),d(Pe,Rl,null),c(N,Zt),c(N,Zl),t(e,Hs,l),t(e,Oe,l),t(e,zs,l),t(e,Ke,l),t(e,Ds,l),t(e,el,l),t(e,qs,l),d(ll,e,l),t(e,Ys,l),t(e,sl,l),t(e,Fs,l),t(e,tl,l),t(e,Ls,l),d(nl,e,l),t(e,Ps,l),t(e,al,l),t(e,Os,l),d(il,e,l),t(e,Ks,l),t(e,ol,l),t(e,et,l),d(pl,e,l),t(e,lt,l),t(e,rl,l),t(e,st,l),t(e,cl,l),t(e,tt,l),d(ul,e,l),nt=!0},p(e,[l]){const fl={};l&2&&(fl.$$scope={dirty:l,ctx:e}),_.$set(fl);const _l={};l&2&&(_l.$$scope={dirty:l,ctx:e}),E.$set(_l)},i(e){nt||(h(H.$$.fragment,e),h(z.$$.fragment,e),h(L.$$.fragment,e),h(_.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(Ue.$$.fragment,e),h(Te.$$.fragment,e),h(be.$$.fragment,e),h(je.$$.fragment,e),h(Ce.$$.fragment,e),h(ge.$$.fragment,e),h(E.$$.fragment,e),h(_e.$$.fragment,e),h(Ge.$$.fragment,e),h(xe.$$.fragment,e),h(Qe.$$.fragment,e),h(Se.$$.fragment,e),h(He.$$.fragment,e),h(De.$$.fragment,e),h(qe.$$.fragment,e),h(Le.$$.fragment,e),h(Pe.$$.fragment,e),h(ll.$$.fragment,e),h(nl.$$.fragment,e),h(il.$$.fragment,e),h(pl.$$.fragment,e),h(ul.$$.fragment,e),nt=!0)},o(e){M(H.$$.fragment,e),M(z.$$.fragment,e),M(L.$$.fragment,e),M(_.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),M(Ue.$$.fragment,e),M(Te.$$.fragment,e),M(be.$$.fragment,e),M(je.$$.fragment,e),M(Ce.$$.fragment,e),M(ge.$$.fragment,e),M(E.$$.fragment,e),M(_e.$$.fragment,e),M(Ge.$$.fragment,e),M(xe.$$.fragment,e),M(Qe.$$.fragment,e),M(Se.$$.fragment,e),M(He.$$.fragment,e),M(De.$$.fragment,e),M(qe.$$.fragment,e),M(Le.$$.fragment,e),M(Pe.$$.fragment,e),M(ll.$$.fragment,e),M(nl.$$.fragment,e),M(il.$$.fragment,e),M(pl.$$.fragment,e),M(ul.$$.fragment,e),nt=!1},d(e){e&&(s(b),s(T),s(Bl),s(Gl),s(D),s($l),s(q),s(xl),s(Y),s(Ql),s(F),s(El),s(j),s(Xl),s(Sl),s(P),s(Al),s(Hl),s(K),s(zl),s(Dl),s(le),s(ql),s(Yl),s(v),s(Fl),s(ne),s(Ll),s(Pl),s(ie),s(Ol),s(Kl),s(pe),s(es),s(C),s(ls),s(ce),s(ss),s(ue),s(ts),s(fe),s(ns),s(as),s(he),s(is),s(Me),s(os),s(ps),s(g),s(rs),s(Je),s(cs),s(us),s(I),s(fs),s(we),s(ds),s(hs),s(Ze),s(Ms),s(ms),s(ve),s(ys),s(Js),s(V),s(Us),s(Ie),s(Ts),s(Ve),s(ws),s(bs),s(ke),s(Zs),s(We),s(js),s(Ne),s(vs),s(Re),s(Cs),s(gs),s(Be),s(Is),s(Vs),s($e),s(ks),s(Ws),s(k),s(Ns),s(Ee),s(Rs),s(Xe),s(_s),s(Bs),s(Ae),s(Gs),s($s),s(ze),s(xs),s(Qs),s(W),s(Es),s(Ye),s(Xs),s(Fe),s(Ss),s(As),s(N),s(Hs),s(Oe),s(zs),s(Ke),s(Ds),s(el),s(qs),s(Ys),s(sl),s(Fs),s(tl),s(Ls),s(Ps),s(al),s(Os),s(Ks),s(ol),s(et),s(lt),s(rl),s(st),s(cl),s(tt)),s(J),m(H),m(z,e),m(L),m(_,e),m(O,e),m(ee,e),m(se,e),m(te),m(ae,e),m(oe,e),m(re),m(de,e),m(me,e),m(ye),m(Ue,e),m(Te),m(be,e),m(je,e),m(Ce,e),m(ge),m(E,e),m(_e,e),m(Ge,e),m(xe,e),m(Qe),m(Se,e),m(He,e),m(De,e),m(qe),m(Le,e),m(Pe),m(ll,e),m(nl,e),m(il,e),m(pl,e),m(ul,e)}}}const Kn={local:"load-pipelines-models-and-schedulers",sections:[{local:"diffusion-pipeline",sections:[{local:"local-pipeline",title:"Local pipeline"},{local:"swap-components-in-a-pipeline",title:"Swap components in a pipeline"},{local:"safety-checker",title:"Safety checker"},{local:"reuse-components-across-pipelines",title:"Reuse components across pipelines"}],title:"Diffusion Pipeline"},{local:"checkpoint-variants",sections:[{local:"using-revision-to-load-pipeline-variants-is-deprecated",title:"Using `revision` to load pipeline variants is deprecated"}],title:"Checkpoint variants"},{local:"models",title:"Models"},{local:"schedulers",title:"Schedulers"},{local:"diffusionpipeline-explained",title:"DiffusionPipeline explained"}],title:"Load pipelines, models, and schedulers"};function ea(dl){return zn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Dn{constructor(J){super(),qn(this,J,ea,On,Hn,{})}}export{oa as component};
