import{s as It,o as Rt,n as Bt}from"../chunks/scheduler.182ea377.js";import{S as Et,i as Ht,g as s,s as i,p as d,A as Nt,h as a,f as l,c as o,j as v,q as u,m as r,k as c,v as b,a as n,r as f,d as h,t as y,u as M}from"../chunks/index.008d68e4.js";import{T as Gt}from"../chunks/Tip.4f096367.js";import{I as ot}from"../chunks/IconCopyLink.96bbb92b.js";import{C as T}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as Xt}from"../chunks/DocNotebookDropdown.bb388256.js";function St(me){let p,U="🔒 By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){p=s("p"),p.textContent=U},l(m){p=a(m,"P",{"data-svelte-h":!0}),r(p)!=="svelte-154jbq5"&&(p.textContent=U)},m(m,w){n(m,p,w)},p:Bt,d(m){m&&l(p)}}}function Qt(me){let p,U='In steps 4 and 5, the custom <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">UNet</a> and <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">pipeline</a> implementation must match the format shown in their files for this example to work.';return{c(){p=s("p"),p.innerHTML=U},l(m){p=a(m,"P",{"data-svelte-h":!0}),r(p)!=="svelte-ptu9pr"&&(p.innerHTML=U)},m(m,w){n(m,p,w)},p:Bt,d(m){m&&l(p)}}}function Ft(me){let p,U,m,w,fe,W,lt,ce,st="Load community pipelines and components",be,G,we,_,J,he,B,nt,de,at="Community pipelines",Ue,I,pt='Community pipelines are any <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original implementation as specified in their paper (for example, the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',Te,R,rt='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#speech-to-image" rel="nofollow">Speech to Image</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#composable-stable-diffusion" rel="nofollow">Composable Stable Diffusion</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',_e,E,mt='To load any community pipeline on the Hub, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow"><code>hf-internal-testing/diffusers-dummy-pipeline</code></a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a>:',ge,Z,ve,H,Je,N,ct='Loading an official community pipeline is similar, but you can mix loading weights from an official repository id and pass pipeline components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline, and you can pass the CLIP model components directly to it:',Ze,X,Ve,S,dt='For more information about community pipelines, take a look at the <a href="custom_pipeline_examples">Community pipelines</a> guide for how to use them and if you’re interested in adding a community pipeline check out the <a href="contribute_pipeline">How to contribute a community pipeline</a> guide!',je,g,V,ye,Q,it,ue,ut="Community components",Ce,F,ft="Community components allow users to build pipelines that may have customized components that are not a part of Diffusers. If your pipeline has custom components that Diffusers doesn’t already support, you need to provide their implementations as Python modules. These customized components could be a VAE, UNet, and scheduler. In most cases, the text encoder is imported from the Transformers library. The pipeline code itself can also be customized.",$e,L,ht="This section shows how users should use community components to build a community pipeline.",ke,z,yt='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example. So, let’s start loading the components:',xe,P,Mt="<li>Import and load the text encoder from Transformers:</li>",We,Y,Ge,j,bt="<li>Load a scheduler:</li>",Be,q,Ie,C,wt="<li>Load an image processor:</li>",Re,A,Ee,$,He,k,Ut='<li>Now you’ll load a <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">custom UNet</a>, which in this example, has already been implemented in the <code>showone_unet_3d_condition.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">script</a> for your convenience. You’ll notice the <code>UNet3DConditionModel</code> class name is changed to <code>ShowOneUNet3DConditionModel</code> because <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> already exists in Diffusers. Any components needed for the <code>ShowOneUNet3DConditionModel</code> class should be placed in the <code>showone_unet_3d_condition.py</code> script.</li>',Ne,D,Tt="Once this is done, you can initialize the UNet:",Xe,O,Se,x,_t='<li>Finally, you’ll load the custom pipeline code. For this example, it has already been created for you in the <code>pipeline_t2v_base_pixel.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/pipeline_t2v_base_pixel.py" rel="nofollow">script</a>. This script contains a custom <code>TextToVideoIFPipeline</code> class for generating videos from text. Just like the custom UNet, any code needed for the custom pipeline to work should go in the <code>pipeline_t2v_base_pixel.py</code> script.</li>',Qe,K,gt="Once everything is in place, you can initialize the <code>TextToVideoIFPipeline</code> with the <code>ShowOneUNet3DConditionModel</code>:",Fe,ee,Le,te,vt="Push the pipeline to the Hub to share with the community!",ze,le,Pe,ne,Jt="After the pipeline is successfully pushed, you need a couple of changes:",Ye,ie,Zt='<li>Change the <code>_class_name</code> attribute in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow"><code>model_index.json</code></a> to <code>&quot;pipeline_t2v_base_pixel&quot;</code> and <code>&quot;TextToVideoIFPipeline&quot;</code>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <code>unet</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline base <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li>',qe,oe,Vt="To run inference, simply add the <code>trust_remote_code</code> argument while initializing the pipeline to handle all the “magic” behind the scenes.",Ae,se,De,ae,jt='As an additional reference example, you can refer to the repository structure of <a href="https://huggingface.co/stabilityai/japanese-stable-diffusion-xl/" rel="nofollow">stabilityai/japanese-stable-diffusion-xl</a>, that makes use of the <code>trust_remote_code</code> feature:',Oe,pe,Ke;return W=new ot({}),G=new Xt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),B=new ot({}),Z=new Gt({props:{warning:!0,$$slots:{default:[St]},$$scope:{ctx:me}}}),H=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`}}),X=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`}}),Q=new ot({}),Y=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`}}),q=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`}}),A=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`}}),$=new Gt({props:{warning:!0,$$slots:{default:[Qt]},$$scope:{ctx:me}}}),O=new T({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`}}),ee=new T({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    scheduler=scheduler,
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`}}),le=new T({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)'}}),se=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`}}),pe=new T({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRmphcGFuZXNlLXN0YWJsZS1kaWZmdXNpb24teGwlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBpZiUyMHVzaW5nJTIwdG9yY2glMjAlM0MlMjAyLjAlMEElMjMlMjBwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiVFNiU5RiVCNCVFNyU4QSVBQyVFMyU4MCU4MSVFMyU4MiVBQiVFMyU4MyVBOSVFMyU4MyU5NSVFMyU4MyVBQiVFMyU4MiVBMiVFMyU4MyVCQyVFMyU4MyU4OCUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBB",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/japanese-stable-diffusion-xl&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># if using torch &lt; 2.0</span>
<span class="hljs-comment"># pipeline.enable_xformers_memory_efficient_attention()</span>

prompt = <span class="hljs-string">&quot;柴犬、カラフルアート&quot;</span>

image = pipeline(prompt=prompt).images[<span class="hljs-number">0</span>]
`}}),{c(){p=s("meta"),U=i(),m=s("h1"),w=s("a"),fe=s("span"),d(W.$$.fragment),lt=i(),ce=s("span"),ce.textContent=st,be=i(),d(G.$$.fragment),we=i(),_=s("h2"),J=s("a"),he=s("span"),d(B.$$.fragment),nt=i(),de=s("span"),de.textContent=at,Ue=i(),I=s("p"),I.innerHTML=pt,Te=i(),R=s("p"),R.innerHTML=rt,_e=i(),E=s("p"),E.innerHTML=mt,ge=i(),d(Z.$$.fragment),ve=i(),d(H.$$.fragment),Je=i(),N=s("p"),N.innerHTML=ct,Ze=i(),d(X.$$.fragment),Ve=i(),S=s("p"),S.innerHTML=dt,je=i(),g=s("h2"),V=s("a"),ye=s("span"),d(Q.$$.fragment),it=i(),ue=s("span"),ue.textContent=ut,Ce=i(),F=s("p"),F.textContent=ft,$e=i(),L=s("p"),L.textContent=ht,ke=i(),z=s("p"),z.innerHTML=yt,xe=i(),P=s("ol"),P.innerHTML=Mt,We=i(),d(Y.$$.fragment),Ge=i(),j=s("ol"),j.innerHTML=bt,Be=i(),d(q.$$.fragment),Ie=i(),C=s("ol"),C.innerHTML=wt,Re=i(),d(A.$$.fragment),Ee=i(),d($.$$.fragment),He=i(),k=s("ol"),k.innerHTML=Ut,Ne=i(),D=s("p"),D.textContent=Tt,Xe=i(),d(O.$$.fragment),Se=i(),x=s("ol"),x.innerHTML=_t,Qe=i(),K=s("p"),K.innerHTML=gt,Fe=i(),d(ee.$$.fragment),Le=i(),te=s("p"),te.textContent=vt,ze=i(),d(le.$$.fragment),Pe=i(),ne=s("p"),ne.textContent=Jt,Ye=i(),ie=s("ol"),ie.innerHTML=Zt,qe=i(),oe=s("p"),oe.innerHTML=Vt,Ae=i(),d(se.$$.fragment),De=i(),ae=s("p"),ae.innerHTML=jt,Oe=i(),d(pe.$$.fragment),this.h()},l(e){const t=Nt("svelte-1phssyn",document.head);p=a(t,"META",{name:!0,content:!0}),t.forEach(l),U=o(e),m=a(e,"H1",{class:!0});var re=v(m);w=a(re,"A",{id:!0,class:!0,href:!0});var Me=v(w);fe=a(Me,"SPAN",{});var Ct=v(fe);u(W.$$.fragment,Ct),Ct.forEach(l),Me.forEach(l),lt=o(re),ce=a(re,"SPAN",{"data-svelte-h":!0}),r(ce)!=="svelte-m4x936"&&(ce.textContent=st),re.forEach(l),be=o(e),u(G.$$.fragment,e),we=o(e),_=a(e,"H2",{class:!0});var et=v(_);J=a(et,"A",{id:!0,class:!0,href:!0});var $t=v(J);he=a($t,"SPAN",{});var kt=v(he);u(B.$$.fragment,kt),kt.forEach(l),$t.forEach(l),nt=o(et),de=a(et,"SPAN",{"data-svelte-h":!0}),r(de)!=="svelte-rxzxlh"&&(de.textContent=at),et.forEach(l),Ue=o(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1yn8qeb"&&(I.innerHTML=pt),Te=o(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-10en0rk"&&(R.innerHTML=rt),_e=o(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1mmnk2f"&&(E.innerHTML=mt),ge=o(e),u(Z.$$.fragment,e),ve=o(e),u(H.$$.fragment,e),Je=o(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1yyre8w"&&(N.innerHTML=ct),Ze=o(e),u(X.$$.fragment,e),Ve=o(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ho2g1z"&&(S.innerHTML=dt),je=o(e),g=a(e,"H2",{class:!0});var tt=v(g);V=a(tt,"A",{id:!0,class:!0,href:!0});var xt=v(V);ye=a(xt,"SPAN",{});var Wt=v(ye);u(Q.$$.fragment,Wt),Wt.forEach(l),xt.forEach(l),it=o(tt),ue=a(tt,"SPAN",{"data-svelte-h":!0}),r(ue)!=="svelte-1kthlj8"&&(ue.textContent=ut),tt.forEach(l),Ce=o(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1vh7uou"&&(F.textContent=ft),$e=o(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-phpvnj"&&(L.textContent=ht),ke=o(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-7sknw0"&&(z.innerHTML=yt),xe=o(e),P=a(e,"OL",{"data-svelte-h":!0}),r(P)!=="svelte-8ccbl9"&&(P.innerHTML=Mt),We=o(e),u(Y.$$.fragment,e),Ge=o(e),j=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-1rtkhjg"&&(j.innerHTML=bt),Be=o(e),u(q.$$.fragment,e),Ie=o(e),C=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(C)!=="svelte-o9t4x9"&&(C.innerHTML=wt),Re=o(e),u(A.$$.fragment,e),Ee=o(e),u($.$$.fragment,e),He=o(e),k=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(k)!=="svelte-2m7lmo"&&(k.innerHTML=Ut),Ne=o(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-4yol19"&&(D.textContent=Tt),Xe=o(e),u(O.$$.fragment,e),Se=o(e),x=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(x)!=="svelte-1m9qhhm"&&(x.innerHTML=_t),Qe=o(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1jpprmd"&&(K.innerHTML=gt),Fe=o(e),u(ee.$$.fragment,e),Le=o(e),te=a(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-14lz5yb"&&(te.textContent=vt),ze=o(e),u(le.$$.fragment,e),Pe=o(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-azdq2p"&&(ne.textContent=Jt),Ye=o(e),ie=a(e,"OL",{"data-svelte-h":!0}),r(ie)!=="svelte-7wsjmh"&&(ie.innerHTML=Zt),qe=o(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-xpz58c"&&(oe.innerHTML=Vt),Ae=o(e),u(se.$$.fragment,e),De=o(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1cmjoh5"&&(ae.innerHTML=jt),Oe=o(e),u(pe.$$.fragment,e),this.h()},h(){c(p,"name","hf:doc:metadata"),c(p,"content",JSON.stringify(Lt)),c(w,"id","load-community-pipelines-and-components"),c(w,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(w,"href","#load-community-pipelines-and-components"),c(m,"class","relative group"),c(J,"id","community-pipelines"),c(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(J,"href","#community-pipelines"),c(_,"class","relative group"),c(V,"id","community-components"),c(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(V,"href","#community-components"),c(g,"class","relative group"),c(j,"start","2"),c(C,"start","3"),c(k,"start","4"),c(x,"start","5")},m(e,t){b(document.head,p),n(e,U,t),n(e,m,t),b(m,w),b(w,fe),f(W,fe,null),b(m,lt),b(m,ce),n(e,be,t),f(G,e,t),n(e,we,t),n(e,_,t),b(_,J),b(J,he),f(B,he,null),b(_,nt),b(_,de),n(e,Ue,t),n(e,I,t),n(e,Te,t),n(e,R,t),n(e,_e,t),n(e,E,t),n(e,ge,t),f(Z,e,t),n(e,ve,t),f(H,e,t),n(e,Je,t),n(e,N,t),n(e,Ze,t),f(X,e,t),n(e,Ve,t),n(e,S,t),n(e,je,t),n(e,g,t),b(g,V),b(V,ye),f(Q,ye,null),b(g,it),b(g,ue),n(e,Ce,t),n(e,F,t),n(e,$e,t),n(e,L,t),n(e,ke,t),n(e,z,t),n(e,xe,t),n(e,P,t),n(e,We,t),f(Y,e,t),n(e,Ge,t),n(e,j,t),n(e,Be,t),f(q,e,t),n(e,Ie,t),n(e,C,t),n(e,Re,t),f(A,e,t),n(e,Ee,t),f($,e,t),n(e,He,t),n(e,k,t),n(e,Ne,t),n(e,D,t),n(e,Xe,t),f(O,e,t),n(e,Se,t),n(e,x,t),n(e,Qe,t),n(e,K,t),n(e,Fe,t),f(ee,e,t),n(e,Le,t),n(e,te,t),n(e,ze,t),f(le,e,t),n(e,Pe,t),n(e,ne,t),n(e,Ye,t),n(e,ie,t),n(e,qe,t),n(e,oe,t),n(e,Ae,t),f(se,e,t),n(e,De,t),n(e,ae,t),n(e,Oe,t),f(pe,e,t),Ke=!0},p(e,[t]){const re={};t&2&&(re.$$scope={dirty:t,ctx:e}),Z.$set(re);const Me={};t&2&&(Me.$$scope={dirty:t,ctx:e}),$.$set(Me)},i(e){Ke||(h(W.$$.fragment,e),h(G.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(H.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(q.$$.fragment,e),h(A.$$.fragment,e),h($.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(pe.$$.fragment,e),Ke=!0)},o(e){y(W.$$.fragment,e),y(G.$$.fragment,e),y(B.$$.fragment,e),y(Z.$$.fragment,e),y(H.$$.fragment,e),y(X.$$.fragment,e),y(Q.$$.fragment,e),y(Y.$$.fragment,e),y(q.$$.fragment,e),y(A.$$.fragment,e),y($.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(pe.$$.fragment,e),Ke=!1},d(e){e&&(l(U),l(m),l(be),l(we),l(_),l(Ue),l(I),l(Te),l(R),l(_e),l(E),l(ge),l(ve),l(Je),l(N),l(Ze),l(Ve),l(S),l(je),l(g),l(Ce),l(F),l($e),l(L),l(ke),l(z),l(xe),l(P),l(We),l(Ge),l(j),l(Be),l(Ie),l(C),l(Re),l(Ee),l(He),l(k),l(Ne),l(D),l(Xe),l(Se),l(x),l(Qe),l(K),l(Fe),l(Le),l(te),l(ze),l(Pe),l(ne),l(Ye),l(ie),l(qe),l(oe),l(Ae),l(De),l(ae),l(Oe)),l(p),M(W),M(G,e),M(B),M(Z,e),M(H,e),M(X,e),M(Q),M(Y,e),M(q,e),M(A,e),M($,e),M(O,e),M(ee,e),M(le,e),M(se,e),M(pe,e)}}}const Lt={local:"load-community-pipelines-and-components",sections:[{local:"community-pipelines",title:"Community pipelines"},{local:"community-components",title:"Community components"}],title:"Load community pipelines and components"};function zt(me){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Et{constructor(p){super(),Ht(this,p,zt,Ft,It,{})}}export{Kt as component};
