import{s as Mt,o as gt,n as bt}from"../chunks/scheduler.182ea377.js";import{S as Ut,i as Zt,g as a,s,p as f,A as wt,h as p,f as l,c as n,j as w,q as d,m as o,k as m,v as c,a as i,r as y,d as h,t as M,u as g}from"../chunks/index.008d68e4.js";import{T as Jt}from"../chunks/Tip.4f096367.js";import{I as Qe}from"../chunks/IconCopyLink.96bbb92b.js";import{C as _}from"../chunks/CodeBlock.5ed6eb7b.js";function jt(re){let r,k='Take a look at the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> reference to see which tasks are supported. Currently, it supports text-to-image, image-to-image, and inpainting.';return{c(){r=a("p"),r.innerHTML=k},l(u){r=p(u,"P",{"data-svelte-h":!0}),o(r)!=="svelte-14r7e5m"&&(r.innerHTML=k)},m(u,b){i(u,r,b)},p:bt,d(u){u&&l(r)}}}function Wt(re){let r,k,u,b,ae,B,Ye,ie,ze="AutoPipeline",me,I,Ae='🤗 Diffusers is able to complete many different tasks, and you can often reuse the same pretrained weights for multiple tasks such as text-to-image, image-to-image, and inpainting. If you’re new to the library and diffusion models though, it may be difficult to know which pipeline to use for a task. For example, if you’re using the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> checkpoint for text-to-image, you might not know that you could also use it for image-to-image and inpainting by loading the checkpoint with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a> classes respectively.',ue,V,Ne="The <code>AutoPipeline</code> class is designed to simplify the variety of pipelines in 🤗 Diffusers. It is a generic, <em>task-first</em> pipeline that lets you focus on the task. The <code>AutoPipeline</code> automatically detects the correct pipeline class to use, which makes it easier to load a checkpoint for a task without knowing the specific pipeline class name.",ce,J,fe,x,Pe="This tutorial shows you how to use an <code>AutoPipeline</code> to automatically infer the pipeline class to load for a specific task, given the pretrained weights.",de,U,j,pe,C,Ee,se,qe="Choose an AutoPipeline for your task",ye,R,Le='Start by picking a checkpoint. For example, if you’re interested in text-to-image with the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> checkpoint, use <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a>:',he,X,Me,W,De='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-text2img.png" alt="generated image of peasant fighting dragon in wood cutting style"/>',ge,F,Ke='Under the hood, <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a>:',be,S,Oe='<li>automatically detects a <code>&quot;stable-diffusion&quot;</code> class from the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file</li> <li>loads the corresponding text-to-image <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> based on the <code>&quot;stable-diffusion&quot;</code> class name</li>',Ue,$,et='Likewise, for image-to-image, <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> detects a <code>&quot;stable-diffusion&quot;</code> checkpoint from the <code>model_index.json</code> file and it’ll load the corresponding <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> behind the scenes. You can also pass any additional arguments specific to the pipeline class such as <code>strength</code>, which determines the amount of noise or variation added to an input image:',Ze,Y,we,G,tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-img2img.png" alt="generated image of a vermeer portrait of a dog wearing a pearl earring"/>',Je,E,lt='And if you want to do inpainting, then <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> loads the underlying <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a> class in the same way:',je,H,We,T,it='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-inpaint.png" alt="generated image of a tiger sitting on a bench"/>',Ge,Q,st="If you try to load an unsupported checkpoint, it’ll throw an error:",Te,z,ve,Z,v,oe,A,He,ne,nt="Use multiple pipelines",_e,N,at='For some workflows or if you’re loading many pipelines, it is more memory-efficient to reuse the same components from a checkpoint instead of reloading them which would unnecessarily consume additional memory. For example, if you’re using a checkpoint for text-to-image and you want to use it again for image-to-image, use the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method. This method creates a new pipeline from the components of a previously loaded pipeline at no additional memory cost.',ke,P,pt='The <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method detects the original pipeline class and maps it to the new pipeline class corresponding to the task you want to do. For example, if you load a <code>&quot;stable-diffusion&quot;</code> class pipeline for text-to-image:',Be,q,Ie,L,ot='Then <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> maps the original <code>&quot;stable-diffusion&quot;</code> pipeline class to <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a>:',Ve,D,xe,K,rt="If you passed an optional argument - like disabling the safety checker - to the original pipeline, this argument is also passed on to the new pipeline:",Ce,O,Re,ee,mt="You can overwrite any of the arguments and even configuration from the original pipeline if you want to change the behavior of the new pipeline. For example, to turn the safety checker back on and add the <code>strength</code> argument:",Xe,te,Fe;return B=new Qe({}),J=new Jt({props:{$$slots:{default:[jt]},$$scope:{ctx:re}}}),C=new Qe({}),X=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMnBlYXNhbnQlMjBhbmQlMjBkcmFnb24lMjBjb21iYXQlMkMlMjB3b29kJTIwY3V0dGluZyUyMHN0eWxlJTJDJTIwdmlraW5nJTIwZXJhJTJDJTIwYmV2ZWwlMjB3aXRoJTIwcnVuZSUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;peasant and dragon combat, wood cutting style, viking era, bevel with rune&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image`}}),Y=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBvcnRyYWl0JTIwb2YlMjBhJTIwZG9nJTIwd2VhcmluZyUyMGElMjBwZWFybCUyMGVhcnJpbmclMjIlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGMCUyRjBmJTJGMTY2NV9HaXJsX3dpdGhfYV9QZWFybF9FYXJyaW5nLmpwZyUyRjgwMHB4LTE2NjVfR2lybF93aXRoX2FfUGVhcmxfRWFycmluZy5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWltYWdlLnRodW1ibmFpbCgoNzY4JTJDJTIwNzY4KSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwMCUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMTAuNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a portrait of a dog wearing a pearl earring&quot;</span>

url = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/0/0f/1665_Girl_with_a_Pearl_Earring.jpg/800px-1665_Girl_with_a_Pearl_Earring.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipeline(prompt, image, num_inference_steps=<span class="hljs-number">200</span>, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
image`}}),H=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBtYWplc3RpYyUyMHRpZ2VyJTIwc2l0dGluZyUyMG9uJTIwYSUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMHN0cmVuZ3RoJTNEMC44MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
image = pipeline(prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">50</span>, strength=<span class="hljs-number">0.80</span>).images[<span class="hljs-number">0</span>]
image`}}),z=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZzaGFwLWUtaW1nMmltZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIyVmFsdWVFcnJvciUzQSUyMEF1dG9QaXBlbGluZSUyMGNhbid0JTIwZmluZCUyMGElMjBwaXBlbGluZSUyMGxpbmtlZCUyMHRvJTIwU2hhcEVJbWcySW1nUGlwZWxpbmUlMjBmb3IlMjBOb25lJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;openai/shap-e-img2img&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-string">&quot;ValueError: AutoPipeline can&#x27;t find a pipeline linked to ShapEImg2ImgPipeline for None&quot;</span>`}}),A=new Qe({}),q=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcHJpbnQodHlwZShwaXBlbGluZV90ZXh0MmltZykpJTBBJTIyJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_text2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt;&quot;</span>`}}),D=new _({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyklMEFwcmludCh0eXBlKHBpcGVsaW5lX2ltZzJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uX2ltZzJpbWcuU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJyUzRSUyMg==",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_img2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion_img2img.StableDiffusionImg2ImgPipeline&#x27;&gt;&quot;</span>`}}),O=new _({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lX2ltZzJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmVfdGV4dDJpbWcpJTBBcHJpbnQocGlwZWxpbmVfaW1nMmltZy5jb25maWcucmVxdWlyZXNfc2FmZXR5X2NoZWNrZXIpJTBBJTIyRmFsc2UlMjI=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;False&quot;</span>`}}),te=new _({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyUyQyUyMHJlcXVpcmVzX3NhZmV0eV9jaGVja2VyJTNEVHJ1ZSUyQyUyMHN0cmVuZ3RoJTNEMC4zKSUwQXByaW50KHBpcGVsaW5lX2ltZzJpbWcuY29uZmlnLnJlcXVpcmVzX3NhZmV0eV9jaGVja2VyKSUwQSUyMlRydWUlMjI=",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img, requires_safety_checker=<span class="hljs-literal">True</span>, strength=<span class="hljs-number">0.3</span>)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;True&quot;</span>`}}),{c(){r=a("meta"),k=s(),u=a("h1"),b=a("a"),ae=a("span"),f(B.$$.fragment),Ye=s(),ie=a("span"),ie.textContent=ze,me=s(),I=a("p"),I.innerHTML=Ae,ue=s(),V=a("p"),V.innerHTML=Ne,ce=s(),f(J.$$.fragment),fe=s(),x=a("p"),x.innerHTML=Pe,de=s(),U=a("h2"),j=a("a"),pe=a("span"),f(C.$$.fragment),Ee=s(),se=a("span"),se.textContent=qe,ye=s(),R=a("p"),R.innerHTML=Le,he=s(),f(X.$$.fragment),Me=s(),W=a("div"),W.innerHTML=De,ge=s(),F=a("p"),F.innerHTML=Ke,be=s(),S=a("ol"),S.innerHTML=Oe,Ue=s(),$=a("p"),$.innerHTML=et,Ze=s(),f(Y.$$.fragment),we=s(),G=a("div"),G.innerHTML=tt,Je=s(),E=a("p"),E.innerHTML=lt,je=s(),f(H.$$.fragment),We=s(),T=a("div"),T.innerHTML=it,Ge=s(),Q=a("p"),Q.textContent=st,Te=s(),f(z.$$.fragment),ve=s(),Z=a("h2"),v=a("a"),oe=a("span"),f(A.$$.fragment),He=s(),ne=a("span"),ne.textContent=nt,_e=s(),N=a("p"),N.innerHTML=at,ke=s(),P=a("p"),P.innerHTML=pt,Be=s(),f(q.$$.fragment),Ie=s(),L=a("p"),L.innerHTML=ot,Ve=s(),f(D.$$.fragment),xe=s(),K=a("p"),K.textContent=rt,Ce=s(),f(O.$$.fragment),Re=s(),ee=a("p"),ee.innerHTML=mt,Xe=s(),f(te.$$.fragment),this.h()},l(e){const t=wt("svelte-1phssyn",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(l),k=n(e),u=p(e,"H1",{class:!0});var le=w(u);b=p(le,"A",{id:!0,class:!0,href:!0});var ut=w(b);ae=p(ut,"SPAN",{});var ct=w(ae);d(B.$$.fragment,ct),ct.forEach(l),ut.forEach(l),Ye=n(le),ie=p(le,"SPAN",{"data-svelte-h":!0}),o(ie)!=="svelte-ypqhdq"&&(ie.textContent=ze),le.forEach(l),me=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1jx8tcc"&&(I.innerHTML=Ae),ue=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1unhzn0"&&(V.innerHTML=Ne),ce=n(e),d(J.$$.fragment,e),fe=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-wmnxi6"&&(x.innerHTML=Pe),de=n(e),U=p(e,"H2",{class:!0});var Se=w(U);j=p(Se,"A",{id:!0,class:!0,href:!0});var ft=w(j);pe=p(ft,"SPAN",{});var dt=w(pe);d(C.$$.fragment,dt),dt.forEach(l),ft.forEach(l),Ee=n(Se),se=p(Se,"SPAN",{"data-svelte-h":!0}),o(se)!=="svelte-gzyycz"&&(se.textContent=qe),Se.forEach(l),ye=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-uc6093"&&(R.innerHTML=Le),he=n(e),d(X.$$.fragment,e),Me=n(e),W=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(W)!=="svelte-1yzwly4"&&(W.innerHTML=De),ge=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1cqgod4"&&(F.innerHTML=Ke),be=n(e),S=p(e,"OL",{"data-svelte-h":!0}),o(S)!=="svelte-1efxqg6"&&(S.innerHTML=Oe),Ue=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-u38fag"&&($.innerHTML=et),Ze=n(e),d(Y.$$.fragment,e),we=n(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(G)!=="svelte-9fi2fw"&&(G.innerHTML=tt),Je=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1f7ebrk"&&(E.innerHTML=lt),je=n(e),d(H.$$.fragment,e),We=n(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1id5o5z"&&(T.innerHTML=it),Ge=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-77swfd"&&(Q.textContent=st),Te=n(e),d(z.$$.fragment,e),ve=n(e),Z=p(e,"H2",{class:!0});var $e=w(Z);v=p($e,"A",{id:!0,class:!0,href:!0});var yt=w(v);oe=p(yt,"SPAN",{});var ht=w(oe);d(A.$$.fragment,ht),ht.forEach(l),yt.forEach(l),He=n($e),ne=p($e,"SPAN",{"data-svelte-h":!0}),o(ne)!=="svelte-190xld3"&&(ne.textContent=nt),$e.forEach(l),_e=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1wvq10j"&&(N.innerHTML=at),ke=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-z6wdos"&&(P.innerHTML=pt),Be=n(e),d(q.$$.fragment,e),Ie=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1g07jwq"&&(L.innerHTML=ot),Ve=n(e),d(D.$$.fragment,e),xe=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-kxf2pi"&&(K.textContent=rt),Ce=n(e),d(O.$$.fragment,e),Re=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-wave52"&&(ee.innerHTML=mt),Xe=n(e),d(te.$$.fragment,e),this.h()},h(){m(r,"name","hf:doc:metadata"),m(r,"content",JSON.stringify(Gt)),m(b,"id","autopipeline"),m(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(b,"href","#autopipeline"),m(u,"class","relative group"),m(j,"id","choose-an-autopipeline-for-your-task"),m(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(j,"href","#choose-an-autopipeline-for-your-task"),m(U,"class","relative group"),m(W,"class","flex justify-center"),m(G,"class","flex justify-center"),m(T,"class","flex justify-center"),m(v,"id","use-multiple-pipelines"),m(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(v,"href","#use-multiple-pipelines"),m(Z,"class","relative group")},m(e,t){c(document.head,r),i(e,k,t),i(e,u,t),c(u,b),c(b,ae),y(B,ae,null),c(u,Ye),c(u,ie),i(e,me,t),i(e,I,t),i(e,ue,t),i(e,V,t),i(e,ce,t),y(J,e,t),i(e,fe,t),i(e,x,t),i(e,de,t),i(e,U,t),c(U,j),c(j,pe),y(C,pe,null),c(U,Ee),c(U,se),i(e,ye,t),i(e,R,t),i(e,he,t),y(X,e,t),i(e,Me,t),i(e,W,t),i(e,ge,t),i(e,F,t),i(e,be,t),i(e,S,t),i(e,Ue,t),i(e,$,t),i(e,Ze,t),y(Y,e,t),i(e,we,t),i(e,G,t),i(e,Je,t),i(e,E,t),i(e,je,t),y(H,e,t),i(e,We,t),i(e,T,t),i(e,Ge,t),i(e,Q,t),i(e,Te,t),y(z,e,t),i(e,ve,t),i(e,Z,t),c(Z,v),c(v,oe),y(A,oe,null),c(Z,He),c(Z,ne),i(e,_e,t),i(e,N,t),i(e,ke,t),i(e,P,t),i(e,Be,t),y(q,e,t),i(e,Ie,t),i(e,L,t),i(e,Ve,t),y(D,e,t),i(e,xe,t),i(e,K,t),i(e,Ce,t),y(O,e,t),i(e,Re,t),i(e,ee,t),i(e,Xe,t),y(te,e,t),Fe=!0},p(e,[t]){const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),J.$set(le)},i(e){Fe||(h(B.$$.fragment,e),h(J.$$.fragment,e),h(C.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(A.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),Fe=!0)},o(e){M(B.$$.fragment,e),M(J.$$.fragment,e),M(C.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),M(H.$$.fragment,e),M(z.$$.fragment,e),M(A.$$.fragment,e),M(q.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),Fe=!1},d(e){e&&(l(k),l(u),l(me),l(I),l(ue),l(V),l(ce),l(fe),l(x),l(de),l(U),l(ye),l(R),l(he),l(Me),l(W),l(ge),l(F),l(be),l(S),l(Ue),l($),l(Ze),l(we),l(G),l(Je),l(E),l(je),l(We),l(T),l(Ge),l(Q),l(Te),l(ve),l(Z),l(_e),l(N),l(ke),l(P),l(Be),l(Ie),l(L),l(Ve),l(xe),l(K),l(Ce),l(Re),l(ee),l(Xe)),l(r),g(B),g(J,e),g(C),g(X,e),g(Y,e),g(H,e),g(z,e),g(A),g(q,e),g(D,e),g(O,e),g(te,e)}}}const Gt={local:"autopipeline",sections:[{local:"choose-an-autopipeline-for-your-task",title:"Choose an AutoPipeline for your task"},{local:"use-multiple-pipelines",title:"Use multiple pipelines"}],title:"AutoPipeline"};function Tt(re){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Ut{constructor(r){super(),Zt(this,r,Tt,Wt,Mt,{})}}export{Vt as component};
