import{s as Nl,o as Ll,n as el}from"../chunks/scheduler.182ea377.js";import{S as Hl,i as Al,g as a,s,p as h,x as Z,A as Ql,h as i,f as l,c as o,j as w,q as u,m as r,y as j,k as M,v as b,a as n,r as d,d as m,t as f,u as y}from"../chunks/index.008d68e4.js";import{T as Ot}from"../chunks/Tip.4f096367.js";import{I as He}from"../chunks/IconCopyLink.96bbb92b.js";import{C as g}from"../chunks/CodeBlock.5ed6eb7b.js";function Sl($){let p,J='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){p=a("p"),p.innerHTML=J},l(c){p=i(c,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1qbiqsn"&&(p.innerHTML=J)},m(c,_){n(c,p,_)},p:el,d(c){c&&l(p)}}}function ql($){let p,J='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){p=a("p"),p.innerHTML=J},l(c){p=i(c,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1ayw4o7"&&(p.innerHTML=J)},m(c,_){n(c,p,_)},p:el,d(c){c&&l(p)}}}function Pl($){let p,J="A full training run takes ~1 hour on a single V100 GPU.";return{c(){p=a("p"),p.textContent=J},l(c){p=i(c,"P",{"data-svelte-h":!0}),r(p)!=="svelte-50nyqv"&&(p.textContent=J)},m(c,_){n(c,p,_)},p:el,d(c){c&&l(p)}}}function Dl($){let p,J,c,_,Ve,B,St,ke,tl="Textual Inversion",Ae,V,ll='<a href="https://hf.co/papers/2208.01618" rel="nofollow">Textual Inversion</a> is a training technique for personalizing image generation models with just a few example images of what you want it to learn. This technique works by learning and updating the text embeddings (the new embeddings are tied to a special word you must use in the prompt) to match the example images you provide.',Qe,F,nl='If you’re training on a GPU with limited vRAM, you should try enabling the <code>gradient_checkpointing</code> and <code>mixed_precision</code> parameters in the training command. You can also reduce your memory footprint by using memory-efficient attention with <a href="../optimization/xformers">xFormers</a>. JAX/Flax training is also supported for efficient training on TPUs and GPUs, but it doesn’t support gradient checkpointing or xFormers. With the same configuration and setup as PyTorch, the Flax training script should be at least ~70% faster!',Se,Y,al='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/textual_inversion/textual_inversion.py" rel="nofollow">textual_inversion.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',qe,E,il="Before running the script, make sure you install the library from source:",Pe,z,De,N,sl="Navigate to the example folder with the training script and install the required dependencies for the script you’re using:",Ke,L,Oe,H,et,W,tt,A,ol="Initialize an 🤗 Accelerate environment:",lt,Q,nt,S,rl="To setup a default 🤗 Accelerate environment without choosing any configurations:",at,q,it,P,pl="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",st,D,ot,K,cl='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',rt,C,pt,v,X,Fe,O,qt,Re,hl="Script parameters",ct,ee,ul='The training script has many parameters to help you tailor the training run to your needs. All of the parameters and their descriptions are listed in the <a href="https://github.com/huggingface/diffusers/blob/839c2a5ece0af4e75530cb520d77bc7ed8acf474/examples/textual_inversion/textual_inversion.py#L176" rel="nofollow"><code>parse_args()</code></a> function. Where applicable, Diffusers provides default values for each parameter such as the training batch size and learning rate, but feel free to change these values in the training command if you’d like.',ht,te,dl="For example, to increase the number of gradient accumulation steps above the default value of 1:",ut,le,dt,ne,ml="Some other basic and important parameters to specify include:",mt,ae,fl="<li><code>--pretrained_model_name_or_path</code>: the name of the model on the Hub or a local path to the pretrained model</li> <li><code>--train_data_dir</code>: path to a folder containing the training dataset (example images)</li> <li><code>--output_dir</code>: where to save the trained model</li> <li><code>--push_to_hub</code>: whether to push the trained model to the Hub</li> <li><code>--checkpointing_steps</code>: frequency of saving a checkpoint as the model trains; this is useful if for some reason training is interrupted, you can continue training from that checkpoint by adding <code>--resume_from_checkpoint</code> to your training command</li> <li><code>--num_vectors</code>: the number of vectors to learn the embeddings with; increasing this parameter helps the model learn better but it comes with increased training costs</li> <li><code>--placeholder_token</code>: the special word to tie the learned embeddings to (you must use the word in your prompt for inference)</li> <li><code>--initializer_token</code>: a single-word that roughly describes the object or style you’re trying to train on</li> <li><code>--learnable_property</code>: whether you’re training the model to learn a new “style” (for example, Van Gogh’s painting style) or “object” (for example, your dog)</li>",ft,T,k,Ye,ie,Pt,Ie,yl="Training script",yt,se,Ml='Unlike some of the other training scripts, textual_inversion.py has a custom dataset class, <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L487" rel="nofollow"><code>TextualInversionDataset</code></a> for creating a dataset. You can customize the image size, placeholder token, interpolation method, whether to crop the image, and more. If you need to change how the dataset is created, you can modify <code>TextualInversionDataset</code>.',Mt,oe,bl='Next, you’ll find the dataset preprocessing code and training loop in the <a href="https://github.com/huggingface/diffusers/blob/839c2a5ece0af4e75530cb520d77bc7ed8acf474/examples/textual_inversion/textual_inversion.py#L573" rel="nofollow"><code>main()</code></a> function.',bt,re,wl='The script starts by loading the <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L616" rel="nofollow">tokenizer</a>, <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L622" rel="nofollow">scheduler and model</a>:',wt,pe,gt,ce,gl='The special <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L632" rel="nofollow">placeholder token</a> is added next to the tokenizer, and the embedding is readjusted to account for the new token.',_t,he,_l='Then, the script <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L716" rel="nofollow">creates a dataset</a> from the <code>TextualInversionDataset</code>:',Jt,ue,vt,de,Jl='Finally, the <a href="https://github.com/huggingface/diffusers/blob/b81c69e489aad3a0ba73798c459a33990dc4379c/examples/textual_inversion/textual_inversion.py#L784" rel="nofollow">training loop</a> handles everything else from predicting the noisy residual to updating the embedding weights of the special placeholder token.',Tt,me,vl='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',Ut,U,R,Ee,fe,Dt,Ge,Tl="Launch the script",xt,ye,Ul="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",Zt,Me,xl='For this guide, you’ll download some images of a <a href="https://huggingface.co/datasets/diffusers/cat_toy_example" rel="nofollow">cat toy</a> and store them in a directory. But remember, you can create and use your own dataset if you want (see the <a href="create_dataset">Create a dataset for training</a> guide).',jt,be,$t,we,Zl="Set the environment variable <code>MODEL_NAME</code> to a model id on the Hub or a path to a local model, and <code>DATA_DIR</code>  to the path where you just downloaded the cat images to. The script creates and saves the following files to your repository:",Wt,ge,jl="<li><code>learned_embeds.bin</code>: the learned embedding vectors corresponding to your example images</li> <li><code>token_identifier.txt</code>: the special placeholder token</li> <li><code>type_of_concept.txt</code>: the type of concept you’re training on (either “object” or “style”)</li>",Ct,I,Xt,_e,$l="One more thing before you launch the script. If you’re interested in following along with the training process, you can periodically save generated images as training progresses. Add the following parameters to the training command:",kt,Je,Rt,ve,It,Te,Gt,Ue,Wl="After training is complete, you can use your newly trained model for inference like:",Bt,xe,Vt,Ze,Cl='Flax doesn’t support the <a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> method, but the textual_inversion_flax.py script <a href="https://github.com/huggingface/diffusers/blob/c0f058265161178f2a88849e92b37ffdc81f1dcc/examples/textual_inversion/textual_inversion_flax.py#L636C2-L636C2" rel="nofollow">saves</a> the learned embeddings as a part of the model after training. This means you can use the model for inference like any other Flax model:',Ft,je,Yt,x,G,ze,$e,Kt,Be,Xl="Next steps",Et,We,kl="Congratulations on training your own Textual Inversion model! 🎉 To learn more about how to use your new model, the following guides may be helpful:",zt,Ce,Rl='<li>Learn how to <a href="../using-diffusers/loading_adapters">load Textual Inversion embeddings</a> and also use them as negative embeddings.</li> <li>Learn how to use <a href="textual_inversion_inference">Textual Inversion</a> for inference with Stable Diffusion 1/2 and Stable Diffusion XL.</li>',Nt;return B=new He({}),z=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`}}),L=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRnRleHR1YWxfaW52ZXJzaW9uJTBBcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`<span class="hljs-built_in">cd</span> examples/textual_inversion
pip install -r requirements.txt`}}),H=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRnRleHR1YWxfaW52ZXJzaW9uJTBBcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzX2ZsYXgudHh0",highlighted:`<span class="hljs-built_in">cd</span> examples/textual_inversion
pip install -r requirements_flax.txt`}}),W=new Ot({props:{$$slots:{default:[Sl]},$$scope:{ctx:$}}}),Q=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),q=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default"}}),D=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`from accelerate.utils import write_basic_config

write_basic_config()`}}),C=new Ot({props:{$$slots:{default:[ql]},$$scope:{ctx:$}}}),O=new He({}),le=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRleHR1YWxfaW52ZXJzaW9uLnB5JTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0",highlighted:`accelerate launch textual_inversion.py \\
  --gradient_accumulation_steps=4`}}),ie=new He({}),pe=new g({props:{code:"JTIzJTIwTG9hZCUyMHRva2VuaXplciUwQWlmJTIwYXJncy50b2tlbml6ZXJfbmFtZSUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGFyZ3MudG9rZW5pemVyX25hbWUpJTBBZWxpZiUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlMjAlM0QlMjBDTElQVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIydG9rZW5pemVyJTIyKSUwQSUwQSUyMyUyMExvYWQlMjBzY2hlZHVsZXIlMjBhbmQlMjBtb2RlbHMlMEFub2lzZV9zY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMENMSVBUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIlMkMlMjByZXZpc2lvbiUzRGFyZ3MucmV2aXNpb24lMEEpJTBBdmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoYXJncy5wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHN1YmZvbGRlciUzRCUyMnZhZSUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy5yZXZpc2lvbiklMEF1bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwcmV2aXNpb24lM0RhcmdzLnJldmlzaW9uJTBBKQ==",highlighted:`<span class="hljs-comment"># Load tokenizer</span>
<span class="hljs-keyword">if</span> args.tokenizer_name:
    tokenizer = CLIPTokenizer.from_pretrained(args.tokenizer_name)
<span class="hljs-keyword">elif</span> args.pretrained_model_name_or_path:
    tokenizer = CLIPTokenizer.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)

<span class="hljs-comment"># Load scheduler and models</span>
noise_scheduler = DDPMScheduler.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
text_encoder = CLIPTextModel.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, revision=args.revision
)
vae = AutoencoderKL.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, revision=args.revision)
unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.revision
)`}}),ue=new g({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMFRleHR1YWxJbnZlcnNpb25EYXRhc2V0KCUwQSUyMCUyMCUyMCUyMGRhdGFfcm9vdCUzRGFyZ3MudHJhaW5fZGF0YV9kaXIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEYXJncy5yZXNvbHV0aW9uJTJDJTBBJTIwJTIwJTIwJTIwcGxhY2Vob2xkZXJfdG9rZW4lM0QoJTIyJTIwJTIyLmpvaW4odG9rZW5pemVyLmNvbnZlcnRfaWRzX3RvX3Rva2VucyhwbGFjZWhvbGRlcl90b2tlbl9pZHMpKSklMkMlMEElMjAlMjAlMjAlMjByZXBlYXRzJTNEYXJncy5yZXBlYXRzJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5hYmxlX3Byb3BlcnR5JTNEYXJncy5sZWFybmFibGVfcHJvcGVydHklMkMlMEElMjAlMjAlMjAlMjBjZW50ZXJfY3JvcCUzRGFyZ3MuY2VudGVyX2Nyb3AlMkMlMEElMjAlMjAlMjAlMjBzZXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKCUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTJDJTIwc2h1ZmZsZSUzRFRydWUlMkMlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUwQSk=",highlighted:`train_dataset = TextualInversionDataset(
    data_root=args.train_data_dir,
    tokenizer=tokenizer,
    size=args.resolution,
    placeholder_token=(<span class="hljs-string">&quot; &quot;</span>.join(tokenizer.convert_ids_to_tokens(placeholder_token_ids))),
    repeats=args.repeats,
    learnable_property=args.learnable_property,
    center_crop=args.center_crop,
    <span class="hljs-built_in">set</span>=<span class="hljs-string">&quot;train&quot;</span>,
)
train_dataloader = torch.utils.data.DataLoader(
    train_dataset, batch_size=args.train_batch_size, shuffle=<span class="hljs-literal">True</span>, num_workers=args.dataloader_num_workers
)`}}),fe=new He({}),be=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBbG9jYWxfZGlyJTIwJTNEJTIwJTIyLiUyRmNhdCUyMiUwQXNuYXBzaG90X2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNhdF90b3lfZXhhbXBsZSUyMiUyQyUyMGxvY2FsX2RpciUzRGxvY2FsX2RpciUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjIuZ2l0YXR0cmlidXRlcyUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

local_dir = <span class="hljs-string">&quot;./cat&quot;</span>
snapshot_download(
    <span class="hljs-string">&quot;diffusers/cat_toy_example&quot;</span>, local_dir=local_dir, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, ignore_patterns=<span class="hljs-string">&quot;.gitattributes&quot;</span>
)`}}),I=new Ot({props:{warning:!0,$$slots:{default:[Pl]},$$scope:{ctx:$}}}),Je=new g({props:{code:"LS12YWxpZGF0aW9uX3Byb21wdCUzRCUyMkElMjAlM0NjYXQtdG95JTNFJTIwdHJhaW4lMjIlMEEtLW51bV92YWxpZGF0aW9uX2ltYWdlcyUzRDQlMEEtLXZhbGlkYXRpb25fc3RlcHMlM0QxMDA=",highlighted:`--validation_prompt=<span class="hljs-string">&quot;A &lt;cat-toy&gt; train&quot;</span>
--num_validation_images=4
--validation_steps=100`}}),ve=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZXhwb3J0JTIwREFUQV9ESVIlM0QlMjIuJTJGY2F0JTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRleHR1YWxfaW52ZXJzaW9uLnB5JTIwJTVDJTBBJTIwJTIwLS1wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRCUyNE1PREVMX05BTUUlMjAlNUMlMEElMjAlMjAtLXRyYWluX2RhdGFfZGlyJTNEJTI0REFUQV9ESVIlMjAlNUMlMEElMjAlMjAtLWxlYXJuYWJsZV9wcm9wZXJ0eSUzRCUyMm9iamVjdCUyMiUyMCU1QyUwQSUyMCUyMC0tcGxhY2Vob2xkZXJfdG9rZW4lM0QlMjIlM0NjYXQtdG95JTNFJTIyJTIwJTVDJTBBJTIwJTIwLS1pbml0aWFsaXplcl90b2tlbiUzRCUyMnRveSUyMiUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDMwMDAlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0Q1LjBlLTA0JTIwJTVDJTBBJTIwJTIwLS1zY2FsZV9sciUyMCU1QyUwQSUyMCUyMC0tbHJfc2NoZWR1bGVyJTNEJTIyY29uc3RhbnQlMjIlMjAlNUMlMEElMjAlMjAtLWxyX3dhcm11cF9zdGVwcyUzRDAlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QlMjJ0ZXh0dWFsX2ludmVyc2lvbl9jYXQlMjIlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> DATA_DIR=<span class="hljs-string">&quot;./cat&quot;</span>

accelerate launch textual_inversion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --train_data_dir=<span class="hljs-variable">$DATA_DIR</span> \\
  --learnable_property=<span class="hljs-string">&quot;object&quot;</span> \\
  --placeholder_token=<span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span> \\
  --initializer_token=<span class="hljs-string">&quot;toy&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --max_train_steps=3000 \\
  --learning_rate=5.0e-04 \\
  --scale_lr \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --output_dir=<span class="hljs-string">&quot;textual_inversion_cat&quot;</span> \\
  --push_to_hub`}}),Te=new g({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMmR1b25nbmElMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQtZmxheCUyMiUwQWV4cG9ydCUyMERBVEFfRElSJTNEJTIyLiUyRmNhdCUyMiUwQSUwQXB5dGhvbiUyMHRleHR1YWxfaW52ZXJzaW9uX2ZsYXgucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fZGF0YV9kaXIlM0QlMjREQVRBX0RJUiUyMCU1QyUwQSUyMCUyMC0tbGVhcm5hYmxlX3Byb3BlcnR5JTNEJTIyb2JqZWN0JTIyJTIwJTVDJTBBJTIwJTIwLS1wbGFjZWhvbGRlcl90b2tlbiUzRCUyMiUzQ2NhdC10b3klM0UlMjIlMjAlNUMlMEElMjAlMjAtLWluaXRpYWxpemVyX3Rva2VuJTNEJTIydG95JTIyJTIwJTVDJTBBJTIwJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwJTVDJTBBJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMSUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMzAwMCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUzRDUuMGUtMDQlMjAlNUMlMEElMjAlMjAtLXNjYWxlX2xyJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTIydGV4dHVhbF9pbnZlcnNpb25fY2F0JTIyJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;duongna/stable-diffusion-v1-4-flax&quot;</span>
<span class="hljs-built_in">export</span> DATA_DIR=<span class="hljs-string">&quot;./cat&quot;</span>

python textual_inversion_flax.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --train_data_dir=<span class="hljs-variable">$DATA_DIR</span> \\
  --learnable_property=<span class="hljs-string">&quot;object&quot;</span> \\
  --placeholder_token=<span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span> \\
  --initializer_token=<span class="hljs-string">&quot;toy&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --max_train_steps=3000 \\
  --learning_rate=5.0e-04 \\
  --scale_lr \\
  --output_dir=<span class="hljs-string">&quot;textual_inversion_cat&quot;</span> \\
  --push_to_hub`}}),xe=new g({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMnNkLWNvbmNlcHRzLWxpYnJhcnklMkZjYXQtdG95JTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyQSUyMCUzQ2NhdC10b3klM0UlMjB0cmFpbiUyMiUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0LXRyYWluLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;A &lt;cat-toy&gt; train&quot;</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-train.png&quot;</span>)`}}),je=new g({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMCUyMnBhdGgtdG8teW91ci10cmFpbmVkLW1vZGVsJTIyJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX3BhdGglMkMlMjBkdHlwZSUzRGpheC5udW1weS5iZmxvYXQxNiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwJTNDY2F0LXRveSUzRSUyMHRyYWluJTIyJTBBcHJuZ19zZWVkJTIwJTNEJTIwamF4LnJhbmRvbS5QUk5HS2V5KDApJTBBbnVtX2luZmVyZW5jZV9zdGVwcyUyMCUzRCUyMDUwJTBBJTBBbnVtX3NhbXBsZXMlMjAlM0QlMjBqYXguZGV2aWNlX2NvdW50KCklMEFwcm9tcHQlMjAlM0QlMjBudW1fc2FtcGxlcyUyMColMjAlNUJwcm9tcHQlNUQlMEFwcm9tcHRfaWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pbnB1dHMocHJvbXB0KSUwQSUwQSUyMyUyMHNoYXJkJTIwaW5wdXRzJTIwYW5kJTIwcm5nJTBBcGFyYW1zJTIwJTNEJTIwcmVwbGljYXRlKHBhcmFtcyklMEFwcm5nX3NlZWQlMjAlM0QlMjBqYXgucmFuZG9tLnNwbGl0KHBybmdfc2VlZCUyQyUyMGpheC5kZXZpY2VfY291bnQoKSklMEFwcm9tcHRfaWRzJTIwJTNEJTIwc2hhcmQocHJvbXB0X2lkcyklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRfaWRzJTJDJTIwcGFyYW1zJTJDJTIwcHJuZ19zZWVkJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUyQyUyMGppdCUzRFRydWUpLmltYWdlcyUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChucC5hc2FycmF5KGltYWdlcy5yZXNoYXBlKChudW1fc2FtcGxlcyUyQyklMjAlMkIlMjBpbWFnZXMuc2hhcGUlNUItMyUzQSU1RCkpKSUwQWltYWdlLnNhdmUoJTIyY2F0LXRyYWluLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

model_path = <span class="hljs-string">&quot;path-to-your-trained-model&quot;</span>
pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(model_path, dtype=jax.numpy.bfloat16)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; train&quot;</span>
prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
num_inference_steps = <span class="hljs-number">50</span>

num_samples = jax.device_count()
prompt = num_samples * [prompt]
prompt_ids = pipeline.prepare_inputs(prompt)

<span class="hljs-comment"># shard inputs and rng</span>
params = replicate(params)
prng_seed = jax.random.split(prng_seed, jax.device_count())
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))
image.save(<span class="hljs-string">&quot;cat-train.png&quot;</span>)`}}),$e=new He({}),{c(){p=a("meta"),J=s(),c=a("h1"),_=a("a"),Ve=a("span"),h(B.$$.fragment),St=s(),ke=a("span"),ke.textContent=tl,Ae=s(),V=a("p"),V.innerHTML=ll,Qe=s(),F=a("p"),F.innerHTML=nl,Se=s(),Y=a("p"),Y.innerHTML=al,qe=s(),E=a("p"),E.textContent=il,Pe=s(),h(z.$$.fragment),De=s(),N=a("p"),N.textContent=sl,Ke=Z(`
<hfoptions id="installation">
<hfoption id="PyTorch">

	`),h(L.$$.fragment),Oe=Z(`
</hfoption>
<hfoption id="Flax">

	`),h(H.$$.fragment),et=Z(`
</hfoption>
</hfoptions>
`),h(W.$$.fragment),tt=s(),A=a("p"),A.textContent=ol,lt=s(),h(Q.$$.fragment),nt=s(),S=a("p"),S.textContent=rl,at=s(),h(q.$$.fragment),it=s(),P=a("p"),P.textContent=pl,st=s(),h(D.$$.fragment),ot=s(),K=a("p"),K.innerHTML=cl,rt=s(),h(C.$$.fragment),pt=s(),v=a("h2"),X=a("a"),Fe=a("span"),h(O.$$.fragment),qt=s(),Re=a("span"),Re.textContent=hl,ct=s(),ee=a("p"),ee.innerHTML=ul,ht=s(),te=a("p"),te.textContent=dl,ut=s(),h(le.$$.fragment),dt=s(),ne=a("p"),ne.textContent=ml,mt=s(),ae=a("ul"),ae.innerHTML=fl,ft=s(),T=a("h2"),k=a("a"),Ye=a("span"),h(ie.$$.fragment),Pt=s(),Ie=a("span"),Ie.textContent=yl,yt=s(),se=a("p"),se.innerHTML=Ml,Mt=s(),oe=a("p"),oe.innerHTML=bl,bt=s(),re=a("p"),re.innerHTML=wl,wt=s(),h(pe.$$.fragment),gt=s(),ce=a("p"),ce.innerHTML=gl,_t=s(),he=a("p"),he.innerHTML=_l,Jt=s(),h(ue.$$.fragment),vt=s(),de=a("p"),de.innerHTML=Jl,Tt=s(),me=a("p"),me.innerHTML=vl,Ut=s(),U=a("h2"),R=a("a"),Ee=a("span"),h(fe.$$.fragment),Dt=s(),Ge=a("span"),Ge.textContent=Tl,xt=s(),ye=a("p"),ye.textContent=Ul,Zt=s(),Me=a("p"),Me.innerHTML=xl,jt=s(),h(be.$$.fragment),$t=s(),we=a("p"),we.innerHTML=Zl,Wt=s(),ge=a("ul"),ge.innerHTML=jl,Ct=s(),h(I.$$.fragment),Xt=s(),_e=a("p"),_e.textContent=$l,kt=s(),h(Je.$$.fragment),Rt=Z(`
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),h(ve.$$.fragment),It=Z(`
</hfoption>
<hfoption id="Flax">

	`),h(Te.$$.fragment),Gt=Z(`
</hfoption>
</hfoptions>
`),Ue=a("p"),Ue.textContent=Wl,Bt=Z(`
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),h(xe.$$.fragment),Vt=Z(`
</hfoption>
<hfoption id="Flax">
`),Ze=a("p"),Ze.innerHTML=Cl,Ft=s(),h(je.$$.fragment),Yt=Z(`
</hfoption>
</hfoptions>
`),x=a("h2"),G=a("a"),ze=a("span"),h($e.$$.fragment),Kt=s(),Be=a("span"),Be.textContent=Xl,Et=s(),We=a("p"),We.textContent=kl,zt=s(),Ce=a("ul"),Ce.innerHTML=Rl,this.h()},l(e){const t=Ql("svelte-1phssyn",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),J=o(e),c=i(e,"H1",{class:!0});var Xe=w(c);_=i(Xe,"A",{id:!0,class:!0,href:!0});var Ne=w(_);Ve=i(Ne,"SPAN",{});var Le=w(Ve);u(B.$$.fragment,Le),Le.forEach(l),Ne.forEach(l),St=o(Xe),ke=i(Xe,"SPAN",{"data-svelte-h":!0}),r(ke)!=="svelte-t3rptd"&&(ke.textContent=tl),Xe.forEach(l),Ae=o(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-vnm0dn"&&(V.innerHTML=ll),Qe=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-19dvf8u"&&(F.innerHTML=nl),Se=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-vv5nfp"&&(Y.innerHTML=al),qe=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-l7dm2q"&&(E.textContent=il),Pe=o(e),u(z.$$.fragment,e),De=o(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1nancx8"&&(N.textContent=sl),Ke=j(e,`
<hfoptions id="installation">
<hfoption id="PyTorch">

	`),u(L.$$.fragment,e),Oe=j(e,`
</hfoption>
<hfoption id="Flax">

	`),u(H.$$.fragment,e),et=j(e,`
</hfoption>
</hfoptions>
`),u(W.$$.fragment,e),tt=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-60q53m"&&(A.textContent=ol),lt=o(e),u(Q.$$.fragment,e),nt=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-di6juu"&&(S.textContent=rl),at=o(e),u(q.$$.fragment,e),it=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-tsz4qp"&&(P.textContent=pl),st=o(e),u(D.$$.fragment,e),ot=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1fkfdql"&&(K.innerHTML=cl),rt=o(e),u(C.$$.fragment,e),pt=o(e),v=i(e,"H2",{class:!0});var Lt=w(v);X=i(Lt,"A",{id:!0,class:!0,href:!0});var Il=w(X);Fe=i(Il,"SPAN",{});var Gl=w(Fe);u(O.$$.fragment,Gl),Gl.forEach(l),Il.forEach(l),qt=o(Lt),Re=i(Lt,"SPAN",{"data-svelte-h":!0}),r(Re)!=="svelte-r00uw2"&&(Re.textContent=hl),Lt.forEach(l),ct=o(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1mhz0qu"&&(ee.innerHTML=ul),ht=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-g9gzy9"&&(te.textContent=dl),ut=o(e),u(le.$$.fragment,e),dt=o(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-tgclk5"&&(ne.textContent=ml),mt=o(e),ae=i(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-eyv1zk"&&(ae.innerHTML=fl),ft=o(e),T=i(e,"H2",{class:!0});var Ht=w(T);k=i(Ht,"A",{id:!0,class:!0,href:!0});var Bl=w(k);Ye=i(Bl,"SPAN",{});var Vl=w(Ye);u(ie.$$.fragment,Vl),Vl.forEach(l),Bl.forEach(l),Pt=o(Ht),Ie=i(Ht,"SPAN",{"data-svelte-h":!0}),r(Ie)!=="svelte-339bde"&&(Ie.textContent=yl),Ht.forEach(l),yt=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-qs703o"&&(se.innerHTML=Ml),Mt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-k3h2bp"&&(oe.innerHTML=bl),bt=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-4766ss"&&(re.innerHTML=wl),wt=o(e),u(pe.$$.fragment,e),gt=o(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-16cbi1f"&&(ce.innerHTML=gl),_t=o(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-70930c"&&(he.innerHTML=_l),Jt=o(e),u(ue.$$.fragment,e),vt=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1mc4ymd"&&(de.innerHTML=Jl),Tt=o(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-6gmbd2"&&(me.innerHTML=vl),Ut=o(e),U=i(e,"H2",{class:!0});var At=w(U);R=i(At,"A",{id:!0,class:!0,href:!0});var Fl=w(R);Ee=i(Fl,"SPAN",{});var Yl=w(Ee);u(fe.$$.fragment,Yl),Yl.forEach(l),Fl.forEach(l),Dt=o(At),Ge=i(At,"SPAN",{"data-svelte-h":!0}),r(Ge)!=="svelte-zp6p5k"&&(Ge.textContent=Tl),At.forEach(l),xt=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-9dei1q"&&(ye.textContent=Ul),Zt=o(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1gl7574"&&(Me.innerHTML=xl),jt=o(e),u(be.$$.fragment,e),$t=o(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-k1bp7z"&&(we.innerHTML=Zl),Wt=o(e),ge=i(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-17m22mk"&&(ge.innerHTML=jl),Ct=o(e),u(I.$$.fragment,e),Xt=o(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-iowxvh"&&(_e.textContent=$l),kt=o(e),u(Je.$$.fragment,e),Rt=j(e,`
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),u(ve.$$.fragment,e),It=j(e,`
</hfoption>
<hfoption id="Flax">

	`),u(Te.$$.fragment,e),Gt=j(e,`
</hfoption>
</hfoptions>
`),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1pqx2cy"&&(Ue.textContent=Wl),Bt=j(e,`
<hfoptions id="training-inference">
<hfoption id="PyTorch">

	`),u(xe.$$.fragment,e),Vt=j(e,`
</hfoption>
<hfoption id="Flax">
`),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-d6sexy"&&(Ze.innerHTML=Cl),Ft=o(e),u(je.$$.fragment,e),Yt=j(e,`
</hfoption>
</hfoptions>
`),x=i(e,"H2",{class:!0});var Qt=w(x);G=i(Qt,"A",{id:!0,class:!0,href:!0});var El=w(G);ze=i(El,"SPAN",{});var zl=w(ze);u($e.$$.fragment,zl),zl.forEach(l),El.forEach(l),Kt=o(Qt),Be=i(Qt,"SPAN",{"data-svelte-h":!0}),r(Be)!=="svelte-pr7lub"&&(Be.textContent=Xl),Qt.forEach(l),Et=o(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-18p6tri"&&(We.textContent=kl),zt=o(e),Ce=i(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-gq7brs"&&(Ce.innerHTML=Rl),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",JSON.stringify(Kl)),M(_,"id","textual-inversion"),M(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(_,"href","#textual-inversion"),M(c,"class","relative group"),M(X,"id","script-parameters"),M(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(X,"href","#script-parameters"),M(v,"class","relative group"),M(k,"id","training-script"),M(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(k,"href","#training-script"),M(T,"class","relative group"),M(R,"id","launch-the-script"),M(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(R,"href","#launch-the-script"),M(U,"class","relative group"),M(G,"id","next-steps"),M(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(G,"href","#next-steps"),M(x,"class","relative group")},m(e,t){b(document.head,p),n(e,J,t),n(e,c,t),b(c,_),b(_,Ve),d(B,Ve,null),b(c,St),b(c,ke),n(e,Ae,t),n(e,V,t),n(e,Qe,t),n(e,F,t),n(e,Se,t),n(e,Y,t),n(e,qe,t),n(e,E,t),n(e,Pe,t),d(z,e,t),n(e,De,t),n(e,N,t),n(e,Ke,t),d(L,e,t),n(e,Oe,t),d(H,e,t),n(e,et,t),d(W,e,t),n(e,tt,t),n(e,A,t),n(e,lt,t),d(Q,e,t),n(e,nt,t),n(e,S,t),n(e,at,t),d(q,e,t),n(e,it,t),n(e,P,t),n(e,st,t),d(D,e,t),n(e,ot,t),n(e,K,t),n(e,rt,t),d(C,e,t),n(e,pt,t),n(e,v,t),b(v,X),b(X,Fe),d(O,Fe,null),b(v,qt),b(v,Re),n(e,ct,t),n(e,ee,t),n(e,ht,t),n(e,te,t),n(e,ut,t),d(le,e,t),n(e,dt,t),n(e,ne,t),n(e,mt,t),n(e,ae,t),n(e,ft,t),n(e,T,t),b(T,k),b(k,Ye),d(ie,Ye,null),b(T,Pt),b(T,Ie),n(e,yt,t),n(e,se,t),n(e,Mt,t),n(e,oe,t),n(e,bt,t),n(e,re,t),n(e,wt,t),d(pe,e,t),n(e,gt,t),n(e,ce,t),n(e,_t,t),n(e,he,t),n(e,Jt,t),d(ue,e,t),n(e,vt,t),n(e,de,t),n(e,Tt,t),n(e,me,t),n(e,Ut,t),n(e,U,t),b(U,R),b(R,Ee),d(fe,Ee,null),b(U,Dt),b(U,Ge),n(e,xt,t),n(e,ye,t),n(e,Zt,t),n(e,Me,t),n(e,jt,t),d(be,e,t),n(e,$t,t),n(e,we,t),n(e,Wt,t),n(e,ge,t),n(e,Ct,t),d(I,e,t),n(e,Xt,t),n(e,_e,t),n(e,kt,t),d(Je,e,t),n(e,Rt,t),d(ve,e,t),n(e,It,t),d(Te,e,t),n(e,Gt,t),n(e,Ue,t),n(e,Bt,t),d(xe,e,t),n(e,Vt,t),n(e,Ze,t),n(e,Ft,t),d(je,e,t),n(e,Yt,t),n(e,x,t),b(x,G),b(G,ze),d($e,ze,null),b(x,Kt),b(x,Be),n(e,Et,t),n(e,We,t),n(e,zt,t),n(e,Ce,t),Nt=!0},p(e,[t]){const Xe={};t&2&&(Xe.$$scope={dirty:t,ctx:e}),W.$set(Xe);const Ne={};t&2&&(Ne.$$scope={dirty:t,ctx:e}),C.$set(Ne);const Le={};t&2&&(Le.$$scope={dirty:t,ctx:e}),I.$set(Le)},i(e){Nt||(m(B.$$.fragment,e),m(z.$$.fragment,e),m(L.$$.fragment,e),m(H.$$.fragment,e),m(W.$$.fragment,e),m(Q.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),m(C.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(I.$$.fragment,e),m(Je.$$.fragment,e),m(ve.$$.fragment,e),m(Te.$$.fragment,e),m(xe.$$.fragment,e),m(je.$$.fragment,e),m($e.$$.fragment,e),Nt=!0)},o(e){f(B.$$.fragment,e),f(z.$$.fragment,e),f(L.$$.fragment,e),f(H.$$.fragment,e),f(W.$$.fragment,e),f(Q.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(C.$$.fragment,e),f(O.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(be.$$.fragment,e),f(I.$$.fragment,e),f(Je.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(xe.$$.fragment,e),f(je.$$.fragment,e),f($e.$$.fragment,e),Nt=!1},d(e){e&&(l(J),l(c),l(Ae),l(V),l(Qe),l(F),l(Se),l(Y),l(qe),l(E),l(Pe),l(De),l(N),l(Ke),l(Oe),l(et),l(tt),l(A),l(lt),l(nt),l(S),l(at),l(it),l(P),l(st),l(ot),l(K),l(rt),l(pt),l(v),l(ct),l(ee),l(ht),l(te),l(ut),l(dt),l(ne),l(mt),l(ae),l(ft),l(T),l(yt),l(se),l(Mt),l(oe),l(bt),l(re),l(wt),l(gt),l(ce),l(_t),l(he),l(Jt),l(vt),l(de),l(Tt),l(me),l(Ut),l(U),l(xt),l(ye),l(Zt),l(Me),l(jt),l($t),l(we),l(Wt),l(ge),l(Ct),l(Xt),l(_e),l(kt),l(Rt),l(It),l(Gt),l(Ue),l(Bt),l(Vt),l(Ze),l(Ft),l(Yt),l(x),l(Et),l(We),l(zt),l(Ce)),l(p),y(B),y(z,e),y(L,e),y(H,e),y(W,e),y(Q,e),y(q,e),y(D,e),y(C,e),y(O),y(le,e),y(ie),y(pe,e),y(ue,e),y(fe),y(be,e),y(I,e),y(Je,e),y(ve,e),y(Te,e),y(xe,e),y(je,e),y($e)}}}const Kl={local:"textual-inversion",sections:[{local:"script-parameters",title:"Script parameters"},{local:"training-script",title:"Training script"},{local:"launch-the-script",title:"Launch the script"},{local:"next-steps",title:"Next steps"}],title:"Textual Inversion"};function Ol($){return Ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sn extends Hl{constructor(p){super(),Al(this,p,Ol,Dl,Nl,{})}}export{sn as component};
