import{s as Mp,z as fp,o as bp,n as yp}from"../chunks/scheduler.182ea377.js";import{S as Jp,i as Zp,g as n,s as i,p as d,x as fa,A as Wp,h as s,f as t,c as p,j as c,q as h,m,y as ba,k as o,v as r,a as l,r as g,d as u,t as y,u as M}from"../chunks/index.008d68e4.js";import{T as up}from"../chunks/Tip.4f096367.js";import{I as Z}from"../chunks/IconCopyLink.96bbb92b.js";import{C as f}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as wp}from"../chunks/DocNotebookDropdown.bb388256.js";function Tp(Ot){let b,w='You’ll notice throughout the guide, we use <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> and <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a>, to save memory and increase inference speed. If you’re using PyTorch 2.0, it’s not necessary to call <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.StableDiffusionUpscalePipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on your pipeline because it’ll already be using PyTorch 2.0’s native <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a>.';return{c(){b=n("p"),b.innerHTML=w},l(J){b=s(J,"P",{"data-svelte-h":!0}),m(b)!=="svelte-11fexon"&&(b.innerHTML=w)},m(J,W){l(J,b,W)},p:yp,d(J){J&&t(b)}}}function Up(Ot){let b,w='It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in latent space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE. For example, in the <a href="#text-to-image-to-inpaint">Text-to-image-to-inpaint</a> section, Kandinsky 2.2 uses a different VAE class than the Stable Diffusion model so it won’t work. But if you use Stable Diffusion v1.5 for both pipelines, then you can keep everything in latent space because they both use <a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.';return{c(){b=n("p"),b.innerHTML=w},l(J){b=s(J,"P",{"data-svelte-h":!0}),m(b)!=="svelte-13qjs3s"&&(b.innerHTML=w)},m(J,W){l(J,b,W)},p:yp,d(J){J&&t(b)}}}function jp(Ot){let b,w,J,W,Ja,be,Pn,ea,us="Inpainting",Na,Je,Ca,Ze,ys="Inpainting replaces or edits specific areas of an image. This makes it a useful tool for image restoration like removing defects and artifacts, or even replacing an image area with something entirely new. Inpainting relies on a mask to determine which regions of an image to fill in; the area to inpaint is represented by white pixels and the area to keep is represented by black pixels. The white pixels are filled in by the prompt.",Qa,We,Ms="With 🤗 Diffusers, here is how you can do inpainting:",Sa,we,fs='<li>Load an inpainting checkpoint with the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> class. This’ll automatically detect the appropriate pipeline class to load based on the checkpoint:</li>',Ea,Te,$a,S,Ha,E,bs="<li>Load the base and mask images:</li>",za,Ue,Aa,$,Js="<li>Create a prompt to inpaint the image with and pass it to the pipeline with the base and mask images:</li>",La,je,qa,H,Zs='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Da,U,z,Za,ve,Kn,ta,Ws="Create a mask image",Pa,Ge,ws="Throughout this guide, the mask image is provided in all of the code examples for convenience. You can inpaint on your own images, but you’ll need to create a mask image for it. Use the Space below to easily create a mask image.",Ka,ke,Ts="Upload a base image to inpaint on and use the sketch tool to draw a mask. Once you’re done, click <strong>Run</strong> to generate and download the mask image.",Oa,T,Us,el,j,A,Wa,Be,On,aa,js="Popular models",tl,Ie,vs='<a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">Stable Diffusion Inpainting</a>, <a href="https://huggingface.co/diffusers/stable-diffusion-xl-1.0-inpainting-0.1" rel="nofollow">Stable Diffusion XL (SDXL) Inpainting</a>, and <a href="https://huggingface.co/kandinsky-community/kandinsky-2-2-decoder-inpaint" rel="nofollow">Kandinsky 2.2 Inpainting</a> are among the most popular models for inpainting. SDXL typically produces higher resolution images than Stable Diffusion v1.5, and Kandinsky 2.2 is also capable of generating high-quality images.',al,v,L,wa,_e,es,la,Gs="Stable Diffusion Inpainting",ll,Xe,ks="Stable Diffusion Inpainting is a latent diffusion model finetuned on 512x512 images on inpainting. It is a good starting point because it is relatively fast and generates good quality images. To use this model for inpainting, you’ll need to pass a prompt, base and mask image to the pipeline:",nl,xe,sl,G,q,Ta,Ye,ts,na,Bs="Stable Diffusion XL (SDXL) Inpainting",il,Fe,Is='SDXL is a larger and more powerful version of Stable Diffusion v1.5. This model can follow a two-stage model process (though each model can also be used alone); the base model generates an image, and a refiner model takes that image and further enhances its details and quality. Take a look at the <a href="sdxl">SDXL</a> guide for a more comprehensive guide on how to use SDXL and configure it’s parameters.',pl,Ve,ol,k,D,Ua,Re,as,sa,_s="Kandinsky 2.2 Inpainting",ml,Ne,Xs='The Kandinsky model family is similar to SDXL because it uses two models as well; the image prior model creates image embeddings, and the diffusion model generates images from them. You can load the image prior and diffusion model separately, but the easiest way to use Kandinsky 2.2 is to load it into the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> class which uses the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22InpaintCombinedPipeline">KandinskyV22InpaintCombinedPipeline</a> under the hood.',rl,Ce,cl,P,xs='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-sdv1.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion Inpainting</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-sdxl.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion XL Inpainting</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-kandinsky.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Kandinsky 2.2 Inpainting</figcaption></div>',dl,B,K,ja,Qe,ls,ia,Ys="Non-inpaint specific checkpoints",hl,Se,Fs='So far, this guide has used inpaint specific checkpoints such as <a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">runwayml/stable-diffusion-inpainting</a>. But you can also use regular checkpoints like <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a>. Let’s compare the results of the two checkpoints.',gl,Ee,Vs="The image on the left is generated from a regular checkpoint, and the image on the right is from an inpaint checkpoint. You’ll immediately notice the image on the left is not as clean, and you can still see the outline of the area the model is supposed to inpaint. The image on the right is much cleaner and the inpainted area appears more natural.",ul,$e,yl,He,Ml,O,Rs='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-inpaint-specific.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">runwayml/stable-diffusion-v1-5</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-specific.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">runwayml/stable-diffusion-inpainting</figcaption></div>',fl,ze,Ns="However, for more basic tasks like erasing an object from an image (like the rocks in the road for example), a regular checkpoint yields pretty good results. There isn’t as noticeable of difference between the regular and inpaint checkpoint.",bl,Ae,Jl,Le,Zl,ee,Cs='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/regular-inpaint-basic.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">runwayml/stable-diffusion-v1-5</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/specific-inpaint-basic.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">runwayml/stable-diffusion-inpainting</figcaption></div>',Wl,qe,Qs="The trade-off of using a non-inpaint specific checkpoint is the overall image quality may be lower, but it generally tends to preserve the mask area (that is why you can see the mask outline). The inpaint specific checkpoints are intentionally trained to generate higher quality inpainted images, and that includes creating a more natural transition between the masked and unmasked areas. As a result, these checkpoints are more likely to change your unmasked area.",wl,De,Ss="If preserving the unmasked area is important for your task, you can use the code below to force the unmasked area of an image to remain the same at the expense of some more unnatural transitions between the masked and unmasked areas.",Tl,Pe,Ul,I,te,va,Ke,ns,pa,Es="Configure pipeline parameters",jl,Oe,$s="Image features - like quality and “creativity” - are dependent on pipeline parameters. Knowing what these parameters do is important for getting the results you want. Let’s take a look at the most important parameters and see how changing them affects the output.",vl,_,ae,Ga,et,ss,oa,Hs="Strength",Gl,tt,zs="<code>strength</code> is a measure of how much noise is added to the base image, which influences how similar the output is to the base image.",kl,at,As="<li>📈 a high <code>strength</code> value means more noise is added to an image and the denoising process takes longer, but you’ll get higher quality images that are more different from the base image</li> <li>📉 a low <code>strength</code> value means less noise is added to an image and the denoising process is faster, but the image quality may not be as great and the generated image resembles the base image more</li>",Bl,lt,Il,le,Ls='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-0.6.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.6</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.8</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-strength-1.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 1.0</figcaption></div>',_l,X,ne,ka,nt,is,ma,qs="Guidance scale",Xl,st,Ds="<code>guidance_scale</code> affects how aligned the text prompt and generated image are.",xl,it,Ps="<li>📈 a high <code>guidance_scale</code> value means the prompt and generated image are closely aligned, so the output is a stricter interpretation of the prompt</li> <li>📉 a low <code>guidance_scale</code> value means the prompt and generated image are more loosely aligned, so the output may be more varied from the prompt</li>",Yl,pt,Ks="You can use <code>strength</code> and <code>guidance_scale</code> together for more control over how expressive the model is. For example, a combination high <code>strength</code> and <code>guidance_scale</code> values gives the model the most creative freedom.",Fl,ot,Vl,se,Os='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-2.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 2.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-7.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 7.5</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-guidance-12.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 12.5</figcaption></div>',Rl,x,ie,Ba,mt,ps,ra,ei="Negative prompt",Nl,rt,ti="A negative prompt assumes the opposite role of a prompt; it guides the model away from generating certain things in an image. This is useful for quickly improving image quality and preventing the model from generating things you don’t want.",Cl,ct,Ql,pe,ai='<figure><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-negative.png"/> <figcaption class="text-center">negative_prompt = &quot;bad architecture, unstable, poor details, blurry&quot;</figcaption></figure>',Sl,Y,oe,Ia,dt,os,ca,li="Chained inpainting pipelines",El,ht,ni='<a href="/docs/diffusers/v0.25.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> can be chained with other 🤗 Diffusers pipelines to edit their outputs. This is often useful for improving the output quality from your other diffusion pipelines, and if you’re using multiple pipelines, it can be more memory-efficient to chain them together to keep the outputs in latent space and reuse the same pipeline components.',$l,F,me,_a,gt,ms,da,si="Text-to-image-to-inpaint",Hl,ut,ii="Chaining a text-to-image and inpainting pipeline allows you to inpaint the generated image, and you don’t have to provide a base image to begin with. This makes it convenient to edit your favorite text-to-image outputs without having to generate an entirely new image.",zl,yt,pi="Start with the text-to-image pipeline to create a castle:",Al,Mt,Ll,ft,oi="Load the mask image of the output from above:",ql,bt,Dl,Jt,mi="And let’s inpaint the masked area with a waterfall:",Pl,Zt,Kl,re,ri='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-text-chain.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">text-to-image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-text-chain-out.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">inpaint</figcaption></div>',Ol,V,ce,Xa,Wt,rs,ha,ci="Inpaint-to-image-to-image",en,wt,di="You can also chain an inpainting pipeline before another pipeline like image-to-image or an upscaler to improve the quality.",tn,Tt,hi="Begin by inpainting an image:",an,Ut,ln,jt,gi="Now let’s pass the image to another inpainting pipeline with SDXL’s refiner model to enhance the image details and quality:",nn,vt,sn,de,pn,Gt,ui='Finally, you can pass this image to an image-to-image pipeline to put the finishing touches on it. It is more efficient to use the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method to reuse the existing pipeline components, and avoid unnecessarily loading all the pipeline components into memory again.',on,kt,mn,he,yi='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-to-image-chain.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">inpaint</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-to-image-final.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image-to-image</figcaption></div>',rn,Bt,Mi="Image-to-image and inpainting are actually very similar tasks. Image-to-image generates a new image that resembles the existing provided image. Inpainting does the same thing, but it only transforms the image area defined by the mask and the rest of the image is unchanged. You can think of inpainting as a more precise tool for making specific changes and image-to-image has a broader scope for making more sweeping changes.",cn,R,ge,xa,It,cs,ga,fi="Control image generation",dn,_t,bi="Getting an image to look exactly the way you want is challenging because the denoising process is random. While you can control certain aspects of generation by configuring parameters like <code>negative_prompt</code>, there are better and more efficient methods for controlling image generation.",hn,N,ue,Ya,Xt,ds,ua,Ji="Prompt weighting",gn,xt,Zi='Prompt weighting provides a quantifiable way to scale the representation of concepts in a prompt. You can use it to increase or decrease the magnitude of the text embedding vector for each concept in the prompt, which subsequently determines how much of each concept is generated. The <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a> library offers an intuitive syntax for scaling the prompt weights and generating the embeddings. Learn how to create the embeddings in the <a href="../using-diffusers/weighted_prompts">Prompt weighting</a> guide.',un,Yt,Wi='Once you’ve generated the embeddings, pass them to the <code>prompt_embeds</code> (and <code>negative_prompt_embeds</code> if you’re using a negative prompt) parameter in the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a>. The embeddings replace the <code>prompt</code> parameter:',yn,Ft,Mn,C,ye,Fa,Vt,hs,ya,wi="ControlNet",fn,Rt,Ti="ControlNet models are used with other diffusion models like Stable Diffusion, and they provide an even more flexible and accurate way to control how an image is generated. A ControlNet accepts an additional conditioning image input that guides the diffusion model to preserve the features in it.",bn,Nt,Ui="For example, let’s condition an image with a ControlNet pretrained on inpaint images:",Jn,Ct,Zn,Qt,ji="Now generate an image from the base, mask and control images. You’ll notice features of the base image are strongly preserved in the generated image.",Wn,St,wn,Et,vi='You can take this a step further and chain it with an image-to-image pipeline to apply a new <a href="https://huggingface.co/nitrosocke/elden-ring-diffusion" rel="nofollow">style</a>:',Tn,$t,Un,Me,Gi='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ControlNet inpaint</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint-img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image-to-image</figcaption></div>',jn,Q,fe,Va,Ht,gs,Ma,ki="Optimize",vn,zt,Bi='It can be difficult and slow to run diffusion models if you’re resource constrained, but it doesn’t have to be with a few optimization tricks. One of the biggest (and easiest) optimizations you can enable is switching to memory-efficient attention. If you’re using PyTorch 2.0, <a href="../optimization/torch2.0#scaled-dot-product-attention">scaled-dot product attention</a> is automatically enabled and you don’t need to do anything else. For non-PyTorch 2.0 users, you can install and use <a href="../optimization/xformers">xFormers</a>’s implementation of memory-efficient attention. Both options reduce memory usage and accelerate inference.',Gn,At,Ii="You can also offload the model to the CPU to save even more memory:",kn,Lt,Bn,qt,_i='To speed-up your inference code even more, use <a href="../optimization/torch2.0#torchcompile"><code>torch_compile</code></a>. You should wrap <code>torch.compile</code> around the most intensive component in the pipeline which is typically the UNet:',In,Dt,_n,Pt,Xi='Learn more in the <a href="../optimization/memory">Reduce memory usage</a> and <a href="../optimization/torch2.0">Torch 2.0</a> guides.',Xn;return be=new Z({}),Je=new wp({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/inpaint.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inpaint.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inpaint.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/inpaint.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inpaint.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inpaint.ipynb"}]}}),Te=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`}}),S=new up({props:{$$slots:{default:[Tp]},$$scope:{ctx:Ot}}}),Ue=new f({props:{code:"aW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludC5wbmclMjIpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludF9tYXNrLnBuZyUyMik=",highlighted:`init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)`}}),je=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJsYWNrJTIwY2F0JTIwd2l0aCUyMGdsb3dpbmclMjBleWVzJTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwZGlzbmV5JTJDJTIwcGl4YXIlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyYmFkJTIwYW5hdG9teSUyQyUyMGRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMGRpc2ZpZ3VyZWQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QzKQ==",highlighted:`prompt = <span class="hljs-string">&quot;a black cat with glowing eyes, cute, adorable, disney, pixar, highly detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad anatomy, deformed, ugly, disfigured&quot;</span>
image = pipeline(prompt=prompt, negative_prompt=negative_prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),ve=new Z({}),Be=new Z({}),_e=new Z({}),xe=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg5MiklMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),Ye=new Z({}),Ve=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg5MiklMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),Re=new Z({}),Ce=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDkyKSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),Qe=new Z({}),$e=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg5MiklMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),He=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg5MiklMEFwcm9tcHQlMjAlM0QlMjAlMjJjb25jZXB0JTIwYXJ0JTIwZGlnaXRhbCUyMHBhaW50aW5nJTIwb2YlMjBhbiUyMGVsdmVuJTIwY2FzdGxlJTJDJTIwaW5zcGlyZWQlMjBieSUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">92</span>)
prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, generator=generator).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),Ae=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZyb2FkLW1hc2sucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEJTIycm9hZCUyMiUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/road-mask.png&quot;</span>)

image = pipeline(prompt=<span class="hljs-string">&quot;road&quot;</span>, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),Le=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZyb2FkLW1hc2sucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEJTIycm9hZCUyMiUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/road-mask.png&quot;</span>)

image = pipeline(prompt=<span class="hljs-string">&quot;road&quot;</span>, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),Pe=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

device = <span class="hljs-string">&quot;cuda&quot;</span>
pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>,
    torch_dtype=torch.float16,
)
pipeline = pipeline.to(device)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
repainted_image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
repainted_image.save(<span class="hljs-string">&quot;repainted_image.png&quot;</span>)

<span class="hljs-comment"># Convert mask to grayscale NumPy array</span>
mask_image_arr = np.array(mask_image.convert(<span class="hljs-string">&quot;L&quot;</span>))
<span class="hljs-comment"># Add a channel dimension to the end of the grayscale mask</span>
mask_image_arr = mask_image_arr[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-comment"># Binarize the mask: 1s correspond to the pixels which are repainted</span>
mask_image_arr = mask_image_arr.astype(np.float32) / <span class="hljs-number">255.0</span>
mask_image_arr[mask_image_arr &lt; <span class="hljs-number">0.5</span>] = <span class="hljs-number">0</span>
mask_image_arr[mask_image_arr &gt;= <span class="hljs-number">0.5</span>] = <span class="hljs-number">1</span>

<span class="hljs-comment"># Take the masked pixels from the repainted image and the unmasked pixels from the initial image</span>
unmasked_unchanged_image_arr = (<span class="hljs-number">1</span> - mask_image_arr) * init_image + mask_image_arr * repainted_image
unmasked_unchanged_image = PIL.Image.fromarray(unmasked_unchanged_image_arr.<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>))
unmasked_unchanged_image.save(<span class="hljs-string">&quot;force_unmasked_unchanged.png&quot;</span>)
make_image_grid([init_image, mask_image, repainted_image, unmasked_unchanged_image], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`}}),Ke=new Z({}),et=new Z({}),lt=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC42KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.6</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),nt=new Z({}),ot=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMi41KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, guidance_scale=<span class="hljs-number">2.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),mt=new Z({}),ct=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbG9hZCUyMGJhc2UlMjBhbmQlMjBtYXNrJTIwaW1hZ2UlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50LnBuZyUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnBhaW50X21hc2sucG5nJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNvbmNlcHQlMjBhcnQlMjBkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGFuJTIwZWx2ZW4lMjBjYXN0bGUlMkMlMjBpbnNwaXJlZCUyMGJ5JTIwbG9yZCUyMG9mJTIwdGhlJTIwcmluZ3MlMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyYmFkJTIwYXJjaGl0ZWN0dXJlJTJDJTIwdW5zdGFibGUlMkMlMjBwb29yJTIwZGV0YWlscyUyQyUyMGJsdXJyeSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;bad architecture, unstable, poor details, blurry&quot;</span>
image = pipeline(prompt=prompt, negative_prompt=negative_prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),dt=new Z({}),gt=new Z({}),Mt=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEF0ZXh0MmltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

text2image = pipeline(<span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>).images[<span class="hljs-number">0</span>]`}}),bt=new f({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wYWludF90ZXh0LWNoYWluLW1hc2sucG5nJTIyKQ==",highlighted:'mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_text-chain-mask.png&quot;</span>)'}}),Zt=new f({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyLWlucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJkaWdpdGFsJTIwcGFpbnRpbmclMjBvZiUyMGElMjBmYW50YXN5JTIwd2F0ZXJmYWxsJTJDJTIwY2xvdWR5JTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRHRleHQyaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJ0ZXh0MmltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;digital painting of a fantasy waterfall, cloudy&quot;</span>
image = pipeline(prompt=prompt, image=text2image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([text2image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),Wt=new Z({}),Ut=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUyQyUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMGFuZCUyMG1hc2slMjBpbWFnZSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZV9pbnBhaW50aW5nJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEElMEElMjMlMjByZXNpemUlMjBpbWFnZSUyMHRvJTIwMTAyNHgxMDI0JTIwZm9yJTIwU0RYTCUwQWltYWdlX2lucGFpbnRpbmclMjAlM0QlMjBpbWFnZV9pbnBhaW50aW5nLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting, AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image_inpainting = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># resize image to 1024x1024 for SDXL</span>
image_inpainting = image_inpainting.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))`}}),vt=new f({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZV9pbnBhaW50aW5nJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RA==",highlighted:`pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt=prompt, image=image_inpainting, mask_image=mask_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`}}),de=new up({props:{$$slots:{default:[Up]},$$scope:{ctx:Ot}}}),kt=new f({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmUpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTJDJTIwaW1hZ2VfaW5wYWludGluZyUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDIlMkMlMjBjb2xzJTNEMik=",highlighted:`pipeline = AutoPipelineForImage2Image.from_pipe(pipeline)
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt=prompt, image=image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image_inpainting, image], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`}}),It=new Z({}),Xt=new Z({}),Ft=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUyMCUyMyUyMGdlbmVyYXRlZCUyMGZyb20lMjBDb21wZWwlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfcHJvbXB0X2VtYmVkcyUyQyUyMCUyMyUyMGdlbmVyYXRlZCUyMGZyb20lMjBDb21wZWwlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, torch_dtype=torch.float16,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt_embeds=prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    negative_prompt_embeds=negative_prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    image=init_image,
    mask_image=mask_image
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),Vt=new Z({}),Ct=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionControlNetInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># load ControlNet</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

<span class="hljs-comment"># pass ControlNet to the pipeline</span>
pipeline = StableDiffusionControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># load base and mask image</span>
init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

<span class="hljs-comment"># prepare control image</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_inpaint_condition</span>(<span class="hljs-params">init_image, mask_image</span>):
    init_image = np.array(init_image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>
    mask_image = np.array(mask_image.convert(<span class="hljs-string">&quot;L&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>

    <span class="hljs-keyword">assert</span> init_image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>] == mask_image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>], <span class="hljs-string">&quot;image and image_mask must have the same image size&quot;</span>
    init_image[mask_image &gt; <span class="hljs-number">0.5</span>] = -<span class="hljs-number">1.0</span>  <span class="hljs-comment"># set as masked pixel</span>
    init_image = np.expand_dims(init_image, <span class="hljs-number">0</span>).transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    init_image = torch.from_numpy(init_image)
    <span class="hljs-keyword">return</span> init_image

control_image = make_inpaint_condition(init_image, mask_image)`}}),St=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBQSUwuSW1hZ2UuZnJvbWFycmF5KG5wLnVpbnQ4KGNvbnRyb2xfaW1hZ2UlNUIwJTVEJTVCMCU1RCkpLmNvbnZlcnQoJ1JHQicpJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMiUyQyUyMGNvbHMlM0QyKQ==",highlighted:`prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, control_image=control_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, PIL.Image.fromarray(np.uint8(control_image[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>])).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>), image], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`}}),$t=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybml0cm9zb2NrZSUyRmVsZGVuLXJpbmctZGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZWxkZW4lMjByaW5nJTIwc3R5bGUlMjBjYXN0bGUlMjIlMjAlMjMlMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJlbGRlbiUyMHJpbmclMjBzdHlsZSUyMiUyMGluJTIwdGhlJTIwcHJvbXB0JTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyYmFkJTIwYXJjaGl0ZWN0dXJlJTJDJTIwZGVmb3JtZWQlMkMlMjBkaXNmaWd1cmVkJTJDJTIwcG9vciUyMGRldGFpbHMlMjIlMEElMEFpbWFnZV9lbGRlbl9yaW5nJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2VfZWxkZW5fcmluZyU1RCUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;nitrosocke/elden-ring-diffusion&quot;</span>, torch_dtype=torch.float16,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;elden ring style castle&quot;</span> <span class="hljs-comment"># include the token &quot;elden ring style&quot; in the prompt</span>
negative_prompt = <span class="hljs-string">&quot;bad architecture, deformed, disfigured, poor details&quot;</span>

image_elden_ring = pipeline(prompt, negative_prompt=negative_prompt, image=image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image, image_elden_ring], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`}}),Ht=new Z({}),Lt=new f({props:{code:"JTJCJTIwcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMkIlMjBwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-addition">+ pipeline.enable_xformers_memory_efficient_attention()</span>
<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>`}}),Dt=new f({props:{code:"cGlwZWxpbmUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:'pipeline.unet = torch.<span class="hljs-built_in">compile</span>(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)'}}),{c(){b=n("meta"),w=i(),J=n("h1"),W=n("a"),Ja=n("span"),d(be.$$.fragment),Pn=i(),ea=n("span"),ea.textContent=us,Na=i(),d(Je.$$.fragment),Ca=i(),Ze=n("p"),Ze.textContent=ys,Qa=i(),We=n("p"),We.textContent=Ms,Sa=i(),we=n("ol"),we.innerHTML=fs,Ea=i(),d(Te.$$.fragment),$a=i(),d(S.$$.fragment),Ha=i(),E=n("ol"),E.innerHTML=bs,za=i(),d(Ue.$$.fragment),Aa=i(),$=n("ol"),$.innerHTML=Js,La=i(),d(je.$$.fragment),qa=i(),H=n("div"),H.innerHTML=Zs,Da=i(),U=n("h2"),z=n("a"),Za=n("span"),d(ve.$$.fragment),Kn=i(),ta=n("span"),ta.textContent=Ws,Pa=i(),Ge=n("p"),Ge.textContent=ws,Ka=i(),ke=n("p"),ke.innerHTML=Ts,Oa=i(),T=n("iframe"),el=i(),j=n("h2"),A=n("a"),Wa=n("span"),d(Be.$$.fragment),On=i(),aa=n("span"),aa.textContent=js,tl=i(),Ie=n("p"),Ie.innerHTML=vs,al=i(),v=n("h3"),L=n("a"),wa=n("span"),d(_e.$$.fragment),es=i(),la=n("span"),la.textContent=Gs,ll=i(),Xe=n("p"),Xe.textContent=ks,nl=i(),d(xe.$$.fragment),sl=i(),G=n("h3"),q=n("a"),Ta=n("span"),d(Ye.$$.fragment),ts=i(),na=n("span"),na.textContent=Bs,il=i(),Fe=n("p"),Fe.innerHTML=Is,pl=i(),d(Ve.$$.fragment),ol=i(),k=n("h3"),D=n("a"),Ua=n("span"),d(Re.$$.fragment),as=i(),sa=n("span"),sa.textContent=_s,ml=i(),Ne=n("p"),Ne.innerHTML=Xs,rl=i(),d(Ce.$$.fragment),cl=i(),P=n("div"),P.innerHTML=xs,dl=i(),B=n("h2"),K=n("a"),ja=n("span"),d(Qe.$$.fragment),ls=i(),ia=n("span"),ia.textContent=Ys,hl=i(),Se=n("p"),Se.innerHTML=Fs,gl=i(),Ee=n("p"),Ee.textContent=Vs,ul=fa(`
<hfoptions id="regular-specific">
<hfoption id="runwayml/stable-diffusion-v1-5">

	`),d($e.$$.fragment),yl=fa(`
</hfoption>
<hfoption id="runwayml/stable-diffusion-inpainting">

	`),d(He.$$.fragment),Ml=fa(`
</hfoption>
</hfoptions>
`),O=n("div"),O.innerHTML=Rs,fl=i(),ze=n("p"),ze.textContent=Ns,bl=fa(`
<hfoptions id="inpaint">
<hfoption id="runwayml/stable-diffusion-v1-5">

	`),d(Ae.$$.fragment),Jl=fa(`
</hfoption>
<hfoption id="runwayml/stable-diffusion-inpaint">

	`),d(Le.$$.fragment),Zl=fa(`
</hfoption>
</hfoptions>
`),ee=n("div"),ee.innerHTML=Cs,Wl=i(),qe=n("p"),qe.textContent=Qs,wl=i(),De=n("p"),De.textContent=Ss,Tl=i(),d(Pe.$$.fragment),Ul=i(),I=n("h2"),te=n("a"),va=n("span"),d(Ke.$$.fragment),ns=i(),pa=n("span"),pa.textContent=Es,jl=i(),Oe=n("p"),Oe.textContent=$s,vl=i(),_=n("h3"),ae=n("a"),Ga=n("span"),d(et.$$.fragment),ss=i(),oa=n("span"),oa.textContent=Hs,Gl=i(),tt=n("p"),tt.innerHTML=zs,kl=i(),at=n("ul"),at.innerHTML=As,Bl=i(),d(lt.$$.fragment),Il=i(),le=n("div"),le.innerHTML=Ls,_l=i(),X=n("h3"),ne=n("a"),ka=n("span"),d(nt.$$.fragment),is=i(),ma=n("span"),ma.textContent=qs,Xl=i(),st=n("p"),st.innerHTML=Ds,xl=i(),it=n("ul"),it.innerHTML=Ps,Yl=i(),pt=n("p"),pt.innerHTML=Ks,Fl=i(),d(ot.$$.fragment),Vl=i(),se=n("div"),se.innerHTML=Os,Rl=i(),x=n("h3"),ie=n("a"),Ba=n("span"),d(mt.$$.fragment),ps=i(),ra=n("span"),ra.textContent=ei,Nl=i(),rt=n("p"),rt.textContent=ti,Cl=i(),d(ct.$$.fragment),Ql=i(),pe=n("div"),pe.innerHTML=ai,Sl=i(),Y=n("h2"),oe=n("a"),Ia=n("span"),d(dt.$$.fragment),os=i(),ca=n("span"),ca.textContent=li,El=i(),ht=n("p"),ht.innerHTML=ni,$l=i(),F=n("h3"),me=n("a"),_a=n("span"),d(gt.$$.fragment),ms=i(),da=n("span"),da.textContent=si,Hl=i(),ut=n("p"),ut.textContent=ii,zl=i(),yt=n("p"),yt.textContent=pi,Al=i(),d(Mt.$$.fragment),Ll=i(),ft=n("p"),ft.textContent=oi,ql=i(),d(bt.$$.fragment),Dl=i(),Jt=n("p"),Jt.textContent=mi,Pl=i(),d(Zt.$$.fragment),Kl=i(),re=n("div"),re.innerHTML=ri,Ol=i(),V=n("h3"),ce=n("a"),Xa=n("span"),d(Wt.$$.fragment),rs=i(),ha=n("span"),ha.textContent=ci,en=i(),wt=n("p"),wt.textContent=di,tn=i(),Tt=n("p"),Tt.textContent=hi,an=i(),d(Ut.$$.fragment),ln=i(),jt=n("p"),jt.textContent=gi,nn=i(),d(vt.$$.fragment),sn=i(),d(de.$$.fragment),pn=i(),Gt=n("p"),Gt.innerHTML=ui,on=i(),d(kt.$$.fragment),mn=i(),he=n("div"),he.innerHTML=yi,rn=i(),Bt=n("p"),Bt.textContent=Mi,cn=i(),R=n("h2"),ge=n("a"),xa=n("span"),d(It.$$.fragment),cs=i(),ga=n("span"),ga.textContent=fi,dn=i(),_t=n("p"),_t.innerHTML=bi,hn=i(),N=n("h3"),ue=n("a"),Ya=n("span"),d(Xt.$$.fragment),ds=i(),ua=n("span"),ua.textContent=Ji,gn=i(),xt=n("p"),xt.innerHTML=Zi,un=i(),Yt=n("p"),Yt.innerHTML=Wi,yn=i(),d(Ft.$$.fragment),Mn=i(),C=n("h3"),ye=n("a"),Fa=n("span"),d(Vt.$$.fragment),hs=i(),ya=n("span"),ya.textContent=wi,fn=i(),Rt=n("p"),Rt.textContent=Ti,bn=i(),Nt=n("p"),Nt.textContent=Ui,Jn=i(),d(Ct.$$.fragment),Zn=i(),Qt=n("p"),Qt.textContent=ji,Wn=i(),d(St.$$.fragment),wn=i(),Et=n("p"),Et.innerHTML=vi,Tn=i(),d($t.$$.fragment),Un=i(),Me=n("div"),Me.innerHTML=Gi,jn=i(),Q=n("h2"),fe=n("a"),Va=n("span"),d(Ht.$$.fragment),gs=i(),Ma=n("span"),Ma.textContent=ki,vn=i(),zt=n("p"),zt.innerHTML=Bi,Gn=i(),At=n("p"),At.textContent=Ii,kn=i(),d(Lt.$$.fragment),Bn=i(),qt=n("p"),qt.innerHTML=_i,In=i(),d(Dt.$$.fragment),_n=i(),Pt=n("p"),Pt.innerHTML=Xi,this.h()},l(e){const a=Wp("svelte-1phssyn",document.head);b=s(a,"META",{name:!0,content:!0}),a.forEach(t),w=p(e),J=s(e,"H1",{class:!0});var Kt=c(J);W=s(Kt,"A",{id:!0,class:!0,href:!0});var Ra=c(W);Ja=s(Ra,"SPAN",{});var xi=c(Ja);h(be.$$.fragment,xi),xi.forEach(t),Ra.forEach(t),Pn=p(Kt),ea=s(Kt,"SPAN",{"data-svelte-h":!0}),m(ea)!=="svelte-1870h70"&&(ea.textContent=us),Kt.forEach(t),Na=p(e),h(Je.$$.fragment,e),Ca=p(e),Ze=s(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1vjeoqc"&&(Ze.textContent=ys),Qa=p(e),We=s(e,"P",{"data-svelte-h":!0}),m(We)!=="svelte-1t7j32f"&&(We.textContent=Ms),Sa=p(e),we=s(e,"OL",{"data-svelte-h":!0}),m(we)!=="svelte-4sg2b4"&&(we.innerHTML=fs),Ea=p(e),h(Te.$$.fragment,e),$a=p(e),h(S.$$.fragment,e),Ha=p(e),E=s(e,"OL",{start:!0,"data-svelte-h":!0}),m(E)!=="svelte-1jtpcib"&&(E.innerHTML=bs),za=p(e),h(Ue.$$.fragment,e),Aa=p(e),$=s(e,"OL",{start:!0,"data-svelte-h":!0}),m($)!=="svelte-1przvba"&&($.innerHTML=Js),La=p(e),h(je.$$.fragment,e),qa=p(e),H=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(H)!=="svelte-72kdzo"&&(H.innerHTML=Zs),Da=p(e),U=s(e,"H2",{class:!0});var xn=c(U);z=s(xn,"A",{id:!0,class:!0,href:!0});var Yi=c(z);Za=s(Yi,"SPAN",{});var Fi=c(Za);h(ve.$$.fragment,Fi),Fi.forEach(t),Yi.forEach(t),Kn=p(xn),ta=s(xn,"SPAN",{"data-svelte-h":!0}),m(ta)!=="svelte-df33ir"&&(ta.textContent=Ws),xn.forEach(t),Pa=p(e),Ge=s(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-ic55ez"&&(Ge.textContent=ws),Ka=p(e),ke=s(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-87gmw5"&&(ke.innerHTML=Ts),Oa=p(e),T=s(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),c(T).forEach(t),el=p(e),j=s(e,"H2",{class:!0});var Yn=c(j);A=s(Yn,"A",{id:!0,class:!0,href:!0});var Vi=c(A);Wa=s(Vi,"SPAN",{});var Ri=c(Wa);h(Be.$$.fragment,Ri),Ri.forEach(t),Vi.forEach(t),On=p(Yn),aa=s(Yn,"SPAN",{"data-svelte-h":!0}),m(aa)!=="svelte-wpbexu"&&(aa.textContent=js),Yn.forEach(t),tl=p(e),Ie=s(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-5vkfn3"&&(Ie.innerHTML=vs),al=p(e),v=s(e,"H3",{class:!0});var Fn=c(v);L=s(Fn,"A",{id:!0,class:!0,href:!0});var Ni=c(L);wa=s(Ni,"SPAN",{});var Ci=c(wa);h(_e.$$.fragment,Ci),Ci.forEach(t),Ni.forEach(t),es=p(Fn),la=s(Fn,"SPAN",{"data-svelte-h":!0}),m(la)!=="svelte-m1ecsg"&&(la.textContent=Gs),Fn.forEach(t),ll=p(e),Xe=s(e,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-siyv04"&&(Xe.textContent=ks),nl=p(e),h(xe.$$.fragment,e),sl=p(e),G=s(e,"H3",{class:!0});var Vn=c(G);q=s(Vn,"A",{id:!0,class:!0,href:!0});var Qi=c(q);Ta=s(Qi,"SPAN",{});var Si=c(Ta);h(Ye.$$.fragment,Si),Si.forEach(t),Qi.forEach(t),ts=p(Vn),na=s(Vn,"SPAN",{"data-svelte-h":!0}),m(na)!=="svelte-z7rc3i"&&(na.textContent=Bs),Vn.forEach(t),il=p(e),Fe=s(e,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-1grw9dr"&&(Fe.innerHTML=Is),pl=p(e),h(Ve.$$.fragment,e),ol=p(e),k=s(e,"H3",{class:!0});var Rn=c(k);D=s(Rn,"A",{id:!0,class:!0,href:!0});var Ei=c(D);Ua=s(Ei,"SPAN",{});var $i=c(Ua);h(Re.$$.fragment,$i),$i.forEach(t),Ei.forEach(t),as=p(Rn),sa=s(Rn,"SPAN",{"data-svelte-h":!0}),m(sa)!=="svelte-b3jluc"&&(sa.textContent=_s),Rn.forEach(t),ml=p(e),Ne=s(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-18cbn5s"&&(Ne.innerHTML=Xs),rl=p(e),h(Ce.$$.fragment,e),cl=p(e),P=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(P)!=="svelte-xc2o0t"&&(P.innerHTML=xs),dl=p(e),B=s(e,"H2",{class:!0});var Nn=c(B);K=s(Nn,"A",{id:!0,class:!0,href:!0});var Hi=c(K);ja=s(Hi,"SPAN",{});var zi=c(ja);h(Qe.$$.fragment,zi),zi.forEach(t),Hi.forEach(t),ls=p(Nn),ia=s(Nn,"SPAN",{"data-svelte-h":!0}),m(ia)!=="svelte-1nxenur"&&(ia.textContent=Ys),Nn.forEach(t),hl=p(e),Se=s(e,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-3ddggj"&&(Se.innerHTML=Fs),gl=p(e),Ee=s(e,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-wgq5zt"&&(Ee.textContent=Vs),ul=ba(e,`
<hfoptions id="regular-specific">
<hfoption id="runwayml/stable-diffusion-v1-5">

	`),h($e.$$.fragment,e),yl=ba(e,`
</hfoption>
<hfoption id="runwayml/stable-diffusion-inpainting">

	`),h(He.$$.fragment,e),Ml=ba(e,`
</hfoption>
</hfoptions>
`),O=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(O)!=="svelte-8vd7az"&&(O.innerHTML=Rs),fl=p(e),ze=s(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-2plak"&&(ze.textContent=Ns),bl=ba(e,`
<hfoptions id="inpaint">
<hfoption id="runwayml/stable-diffusion-v1-5">

	`),h(Ae.$$.fragment,e),Jl=ba(e,`
</hfoption>
<hfoption id="runwayml/stable-diffusion-inpaint">

	`),h(Le.$$.fragment,e),Zl=ba(e,`
</hfoption>
</hfoptions>
`),ee=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(ee)!=="svelte-ybt947"&&(ee.innerHTML=Cs),Wl=p(e),qe=s(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-duydyd"&&(qe.textContent=Qs),wl=p(e),De=s(e,"P",{"data-svelte-h":!0}),m(De)!=="svelte-i9dpe4"&&(De.textContent=Ss),Tl=p(e),h(Pe.$$.fragment,e),Ul=p(e),I=s(e,"H2",{class:!0});var Cn=c(I);te=s(Cn,"A",{id:!0,class:!0,href:!0});var Ai=c(te);va=s(Ai,"SPAN",{});var Li=c(va);h(Ke.$$.fragment,Li),Li.forEach(t),Ai.forEach(t),ns=p(Cn),pa=s(Cn,"SPAN",{"data-svelte-h":!0}),m(pa)!=="svelte-1i22l19"&&(pa.textContent=Es),Cn.forEach(t),jl=p(e),Oe=s(e,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-13ocbdc"&&(Oe.textContent=$s),vl=p(e),_=s(e,"H3",{class:!0});var Qn=c(_);ae=s(Qn,"A",{id:!0,class:!0,href:!0});var qi=c(ae);Ga=s(qi,"SPAN",{});var Di=c(Ga);h(et.$$.fragment,Di),Di.forEach(t),qi.forEach(t),ss=p(Qn),oa=s(Qn,"SPAN",{"data-svelte-h":!0}),m(oa)!=="svelte-ml19a"&&(oa.textContent=Hs),Qn.forEach(t),Gl=p(e),tt=s(e,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-qcb5md"&&(tt.innerHTML=zs),kl=p(e),at=s(e,"UL",{"data-svelte-h":!0}),m(at)!=="svelte-vvcg88"&&(at.innerHTML=As),Bl=p(e),h(lt.$$.fragment,e),Il=p(e),le=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(le)!=="svelte-1vmqp5s"&&(le.innerHTML=Ls),_l=p(e),X=s(e,"H3",{class:!0});var Sn=c(X);ne=s(Sn,"A",{id:!0,class:!0,href:!0});var Pi=c(ne);ka=s(Pi,"SPAN",{});var Ki=c(ka);h(nt.$$.fragment,Ki),Ki.forEach(t),Pi.forEach(t),is=p(Sn),ma=s(Sn,"SPAN",{"data-svelte-h":!0}),m(ma)!=="svelte-1lk39j5"&&(ma.textContent=qs),Sn.forEach(t),Xl=p(e),st=s(e,"P",{"data-svelte-h":!0}),m(st)!=="svelte-zcb81p"&&(st.innerHTML=Ds),xl=p(e),it=s(e,"UL",{"data-svelte-h":!0}),m(it)!=="svelte-cnggx4"&&(it.innerHTML=Ps),Yl=p(e),pt=s(e,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-196id8d"&&(pt.innerHTML=Ks),Fl=p(e),h(ot.$$.fragment,e),Vl=p(e),se=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(se)!=="svelte-1cwhpu7"&&(se.innerHTML=Os),Rl=p(e),x=s(e,"H3",{class:!0});var En=c(x);ie=s(En,"A",{id:!0,class:!0,href:!0});var Oi=c(ie);Ba=s(Oi,"SPAN",{});var ep=c(Ba);h(mt.$$.fragment,ep),ep.forEach(t),Oi.forEach(t),ps=p(En),ra=s(En,"SPAN",{"data-svelte-h":!0}),m(ra)!=="svelte-1g2y2v4"&&(ra.textContent=ei),En.forEach(t),Nl=p(e),rt=s(e,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-1ru9kar"&&(rt.textContent=ti),Cl=p(e),h(ct.$$.fragment,e),Ql=p(e),pe=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(pe)!=="svelte-15bd4ta"&&(pe.innerHTML=ai),Sl=p(e),Y=s(e,"H2",{class:!0});var $n=c(Y);oe=s($n,"A",{id:!0,class:!0,href:!0});var tp=c(oe);Ia=s(tp,"SPAN",{});var ap=c(Ia);h(dt.$$.fragment,ap),ap.forEach(t),tp.forEach(t),os=p($n),ca=s($n,"SPAN",{"data-svelte-h":!0}),m(ca)!=="svelte-tggx0h"&&(ca.textContent=li),$n.forEach(t),El=p(e),ht=s(e,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-156qrxc"&&(ht.innerHTML=ni),$l=p(e),F=s(e,"H3",{class:!0});var Hn=c(F);me=s(Hn,"A",{id:!0,class:!0,href:!0});var lp=c(me);_a=s(lp,"SPAN",{});var np=c(_a);h(gt.$$.fragment,np),np.forEach(t),lp.forEach(t),ms=p(Hn),da=s(Hn,"SPAN",{"data-svelte-h":!0}),m(da)!=="svelte-11p38jo"&&(da.textContent=si),Hn.forEach(t),Hl=p(e),ut=s(e,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-1uqw6jr"&&(ut.textContent=ii),zl=p(e),yt=s(e,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-1kzp8f0"&&(yt.textContent=pi),Al=p(e),h(Mt.$$.fragment,e),Ll=p(e),ft=s(e,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-yqefj6"&&(ft.textContent=oi),ql=p(e),h(bt.$$.fragment,e),Dl=p(e),Jt=s(e,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-ua49j1"&&(Jt.textContent=mi),Pl=p(e),h(Zt.$$.fragment,e),Kl=p(e),re=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(re)!=="svelte-15ens2s"&&(re.innerHTML=ri),Ol=p(e),V=s(e,"H3",{class:!0});var zn=c(V);ce=s(zn,"A",{id:!0,class:!0,href:!0});var sp=c(ce);Xa=s(sp,"SPAN",{});var ip=c(Xa);h(Wt.$$.fragment,ip),ip.forEach(t),sp.forEach(t),rs=p(zn),ha=s(zn,"SPAN",{"data-svelte-h":!0}),m(ha)!=="svelte-1jxh17m"&&(ha.textContent=ci),zn.forEach(t),en=p(e),wt=s(e,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-16qmg1v"&&(wt.textContent=di),tn=p(e),Tt=s(e,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-1du3njh"&&(Tt.textContent=hi),an=p(e),h(Ut.$$.fragment,e),ln=p(e),jt=s(e,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-j4alid"&&(jt.textContent=gi),nn=p(e),h(vt.$$.fragment,e),sn=p(e),h(de.$$.fragment,e),pn=p(e),Gt=s(e,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-zvrdpc"&&(Gt.innerHTML=ui),on=p(e),h(kt.$$.fragment,e),mn=p(e),he=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(he)!=="svelte-1lbnv8n"&&(he.innerHTML=yi),rn=p(e),Bt=s(e,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-1fd5b22"&&(Bt.textContent=Mi),cn=p(e),R=s(e,"H2",{class:!0});var An=c(R);ge=s(An,"A",{id:!0,class:!0,href:!0});var pp=c(ge);xa=s(pp,"SPAN",{});var op=c(xa);h(It.$$.fragment,op),op.forEach(t),pp.forEach(t),cs=p(An),ga=s(An,"SPAN",{"data-svelte-h":!0}),m(ga)!=="svelte-qv3glj"&&(ga.textContent=fi),An.forEach(t),dn=p(e),_t=s(e,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-1gc804h"&&(_t.innerHTML=bi),hn=p(e),N=s(e,"H3",{class:!0});var Ln=c(N);ue=s(Ln,"A",{id:!0,class:!0,href:!0});var mp=c(ue);Ya=s(mp,"SPAN",{});var rp=c(Ya);h(Xt.$$.fragment,rp),rp.forEach(t),mp.forEach(t),ds=p(Ln),ua=s(Ln,"SPAN",{"data-svelte-h":!0}),m(ua)!=="svelte-ni1uk3"&&(ua.textContent=Ji),Ln.forEach(t),gn=p(e),xt=s(e,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-6zcpc0"&&(xt.innerHTML=Zi),un=p(e),Yt=s(e,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-nq4hf"&&(Yt.innerHTML=Wi),yn=p(e),h(Ft.$$.fragment,e),Mn=p(e),C=s(e,"H3",{class:!0});var qn=c(C);ye=s(qn,"A",{id:!0,class:!0,href:!0});var cp=c(ye);Fa=s(cp,"SPAN",{});var dp=c(Fa);h(Vt.$$.fragment,dp),dp.forEach(t),cp.forEach(t),hs=p(qn),ya=s(qn,"SPAN",{"data-svelte-h":!0}),m(ya)!=="svelte-1147sj1"&&(ya.textContent=wi),qn.forEach(t),fn=p(e),Rt=s(e,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-3rypf9"&&(Rt.textContent=Ti),bn=p(e),Nt=s(e,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-1x7ee8u"&&(Nt.textContent=Ui),Jn=p(e),h(Ct.$$.fragment,e),Zn=p(e),Qt=s(e,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-db3ja"&&(Qt.textContent=ji),Wn=p(e),h(St.$$.fragment,e),wn=p(e),Et=s(e,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-iaoixt"&&(Et.innerHTML=vi),Tn=p(e),h($t.$$.fragment,e),Un=p(e),Me=s(e,"DIV",{class:!0,"data-svelte-h":!0}),m(Me)!=="svelte-9rfwwm"&&(Me.innerHTML=Gi),jn=p(e),Q=s(e,"H2",{class:!0});var Dn=c(Q);fe=s(Dn,"A",{id:!0,class:!0,href:!0});var hp=c(fe);Va=s(hp,"SPAN",{});var gp=c(Va);h(Ht.$$.fragment,gp),gp.forEach(t),hp.forEach(t),gs=p(Dn),Ma=s(Dn,"SPAN",{"data-svelte-h":!0}),m(Ma)!=="svelte-1ugjw4w"&&(Ma.textContent=ki),Dn.forEach(t),vn=p(e),zt=s(e,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-1f04pnr"&&(zt.innerHTML=Bi),Gn=p(e),At=s(e,"P",{"data-svelte-h":!0}),m(At)!=="svelte-1eqbc05"&&(At.textContent=Ii),kn=p(e),h(Lt.$$.fragment,e),Bn=p(e),qt=s(e,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-c3yozi"&&(qt.innerHTML=_i),In=p(e),h(Dt.$$.fragment,e),_n=p(e),Pt=s(e,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-ve8eie"&&(Pt.innerHTML=Xi),this.h()},h(){o(b,"name","hf:doc:metadata"),o(b,"content",JSON.stringify(vp)),o(W,"id","inpainting"),o(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(W,"href","#inpainting"),o(J,"class","relative group"),o(E,"start","2"),o($,"start","3"),o(H,"class","flex gap-4"),o(z,"id","create-a-mask-image"),o(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(z,"href","#create-a-mask-image"),o(U,"class","relative group"),fp(T.src,Us="https://stevhliu-inpaint-mask-maker.hf.space")||o(T,"src",Us),o(T,"frameborder","0"),o(T,"width","850"),o(T,"height","450"),o(A,"id","popular-models"),o(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(A,"href","#popular-models"),o(j,"class","relative group"),o(L,"id","stable-diffusion-inpainting"),o(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(L,"href","#stable-diffusion-inpainting"),o(v,"class","relative group"),o(q,"id","stable-diffusion-xl-sdxl-inpainting"),o(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(q,"href","#stable-diffusion-xl-sdxl-inpainting"),o(G,"class","relative group"),o(D,"id","kandinsky-22-inpainting"),o(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(D,"href","#kandinsky-22-inpainting"),o(k,"class","relative group"),o(P,"class","flex flex-row gap-4"),o(K,"id","noninpaint-specific-checkpoints"),o(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(K,"href","#noninpaint-specific-checkpoints"),o(B,"class","relative group"),o(O,"class","flex gap-4"),o(ee,"class","flex gap-4"),o(te,"id","configure-pipeline-parameters"),o(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(te,"href","#configure-pipeline-parameters"),o(I,"class","relative group"),o(ae,"id","strength"),o(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ae,"href","#strength"),o(_,"class","relative group"),o(le,"class","flex flex-row gap-4"),o(ne,"id","guidance-scale"),o(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ne,"href","#guidance-scale"),o(X,"class","relative group"),o(se,"class","flex flex-row gap-4"),o(ie,"id","negative-prompt"),o(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ie,"href","#negative-prompt"),o(x,"class","relative group"),o(pe,"class","flex justify-center"),o(oe,"id","chained-inpainting-pipelines"),o(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(oe,"href","#chained-inpainting-pipelines"),o(Y,"class","relative group"),o(me,"id","texttoimagetoinpaint"),o(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(me,"href","#texttoimagetoinpaint"),o(F,"class","relative group"),o(re,"class","flex flex-row gap-4"),o(ce,"id","inpainttoimagetoimage"),o(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ce,"href","#inpainttoimagetoimage"),o(V,"class","relative group"),o(he,"class","flex flex-row gap-4"),o(ge,"id","control-image-generation"),o(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ge,"href","#control-image-generation"),o(R,"class","relative group"),o(ue,"id","prompt-weighting"),o(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ue,"href","#prompt-weighting"),o(N,"class","relative group"),o(ye,"id","controlnet"),o(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ye,"href","#controlnet"),o(C,"class","relative group"),o(Me,"class","flex flex-row gap-4"),o(fe,"id","optimize"),o(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(fe,"href","#optimize"),o(Q,"class","relative group")},m(e,a){r(document.head,b),l(e,w,a),l(e,J,a),r(J,W),r(W,Ja),g(be,Ja,null),r(J,Pn),r(J,ea),l(e,Na,a),g(Je,e,a),l(e,Ca,a),l(e,Ze,a),l(e,Qa,a),l(e,We,a),l(e,Sa,a),l(e,we,a),l(e,Ea,a),g(Te,e,a),l(e,$a,a),g(S,e,a),l(e,Ha,a),l(e,E,a),l(e,za,a),g(Ue,e,a),l(e,Aa,a),l(e,$,a),l(e,La,a),g(je,e,a),l(e,qa,a),l(e,H,a),l(e,Da,a),l(e,U,a),r(U,z),r(z,Za),g(ve,Za,null),r(U,Kn),r(U,ta),l(e,Pa,a),l(e,Ge,a),l(e,Ka,a),l(e,ke,a),l(e,Oa,a),l(e,T,a),l(e,el,a),l(e,j,a),r(j,A),r(A,Wa),g(Be,Wa,null),r(j,On),r(j,aa),l(e,tl,a),l(e,Ie,a),l(e,al,a),l(e,v,a),r(v,L),r(L,wa),g(_e,wa,null),r(v,es),r(v,la),l(e,ll,a),l(e,Xe,a),l(e,nl,a),g(xe,e,a),l(e,sl,a),l(e,G,a),r(G,q),r(q,Ta),g(Ye,Ta,null),r(G,ts),r(G,na),l(e,il,a),l(e,Fe,a),l(e,pl,a),g(Ve,e,a),l(e,ol,a),l(e,k,a),r(k,D),r(D,Ua),g(Re,Ua,null),r(k,as),r(k,sa),l(e,ml,a),l(e,Ne,a),l(e,rl,a),g(Ce,e,a),l(e,cl,a),l(e,P,a),l(e,dl,a),l(e,B,a),r(B,K),r(K,ja),g(Qe,ja,null),r(B,ls),r(B,ia),l(e,hl,a),l(e,Se,a),l(e,gl,a),l(e,Ee,a),l(e,ul,a),g($e,e,a),l(e,yl,a),g(He,e,a),l(e,Ml,a),l(e,O,a),l(e,fl,a),l(e,ze,a),l(e,bl,a),g(Ae,e,a),l(e,Jl,a),g(Le,e,a),l(e,Zl,a),l(e,ee,a),l(e,Wl,a),l(e,qe,a),l(e,wl,a),l(e,De,a),l(e,Tl,a),g(Pe,e,a),l(e,Ul,a),l(e,I,a),r(I,te),r(te,va),g(Ke,va,null),r(I,ns),r(I,pa),l(e,jl,a),l(e,Oe,a),l(e,vl,a),l(e,_,a),r(_,ae),r(ae,Ga),g(et,Ga,null),r(_,ss),r(_,oa),l(e,Gl,a),l(e,tt,a),l(e,kl,a),l(e,at,a),l(e,Bl,a),g(lt,e,a),l(e,Il,a),l(e,le,a),l(e,_l,a),l(e,X,a),r(X,ne),r(ne,ka),g(nt,ka,null),r(X,is),r(X,ma),l(e,Xl,a),l(e,st,a),l(e,xl,a),l(e,it,a),l(e,Yl,a),l(e,pt,a),l(e,Fl,a),g(ot,e,a),l(e,Vl,a),l(e,se,a),l(e,Rl,a),l(e,x,a),r(x,ie),r(ie,Ba),g(mt,Ba,null),r(x,ps),r(x,ra),l(e,Nl,a),l(e,rt,a),l(e,Cl,a),g(ct,e,a),l(e,Ql,a),l(e,pe,a),l(e,Sl,a),l(e,Y,a),r(Y,oe),r(oe,Ia),g(dt,Ia,null),r(Y,os),r(Y,ca),l(e,El,a),l(e,ht,a),l(e,$l,a),l(e,F,a),r(F,me),r(me,_a),g(gt,_a,null),r(F,ms),r(F,da),l(e,Hl,a),l(e,ut,a),l(e,zl,a),l(e,yt,a),l(e,Al,a),g(Mt,e,a),l(e,Ll,a),l(e,ft,a),l(e,ql,a),g(bt,e,a),l(e,Dl,a),l(e,Jt,a),l(e,Pl,a),g(Zt,e,a),l(e,Kl,a),l(e,re,a),l(e,Ol,a),l(e,V,a),r(V,ce),r(ce,Xa),g(Wt,Xa,null),r(V,rs),r(V,ha),l(e,en,a),l(e,wt,a),l(e,tn,a),l(e,Tt,a),l(e,an,a),g(Ut,e,a),l(e,ln,a),l(e,jt,a),l(e,nn,a),g(vt,e,a),l(e,sn,a),g(de,e,a),l(e,pn,a),l(e,Gt,a),l(e,on,a),g(kt,e,a),l(e,mn,a),l(e,he,a),l(e,rn,a),l(e,Bt,a),l(e,cn,a),l(e,R,a),r(R,ge),r(ge,xa),g(It,xa,null),r(R,cs),r(R,ga),l(e,dn,a),l(e,_t,a),l(e,hn,a),l(e,N,a),r(N,ue),r(ue,Ya),g(Xt,Ya,null),r(N,ds),r(N,ua),l(e,gn,a),l(e,xt,a),l(e,un,a),l(e,Yt,a),l(e,yn,a),g(Ft,e,a),l(e,Mn,a),l(e,C,a),r(C,ye),r(ye,Fa),g(Vt,Fa,null),r(C,hs),r(C,ya),l(e,fn,a),l(e,Rt,a),l(e,bn,a),l(e,Nt,a),l(e,Jn,a),g(Ct,e,a),l(e,Zn,a),l(e,Qt,a),l(e,Wn,a),g(St,e,a),l(e,wn,a),l(e,Et,a),l(e,Tn,a),g($t,e,a),l(e,Un,a),l(e,Me,a),l(e,jn,a),l(e,Q,a),r(Q,fe),r(fe,Va),g(Ht,Va,null),r(Q,gs),r(Q,Ma),l(e,vn,a),l(e,zt,a),l(e,Gn,a),l(e,At,a),l(e,kn,a),g(Lt,e,a),l(e,Bn,a),l(e,qt,a),l(e,In,a),g(Dt,e,a),l(e,_n,a),l(e,Pt,a),Xn=!0},p(e,[a]){const Kt={};a&2&&(Kt.$$scope={dirty:a,ctx:e}),S.$set(Kt);const Ra={};a&2&&(Ra.$$scope={dirty:a,ctx:e}),de.$set(Ra)},i(e){Xn||(u(be.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(S.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(ve.$$.fragment,e),u(Be.$$.fragment,e),u(_e.$$.fragment,e),u(xe.$$.fragment,e),u(Ye.$$.fragment,e),u(Ve.$$.fragment,e),u(Re.$$.fragment,e),u(Ce.$$.fragment,e),u(Qe.$$.fragment,e),u($e.$$.fragment,e),u(He.$$.fragment,e),u(Ae.$$.fragment,e),u(Le.$$.fragment,e),u(Pe.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(lt.$$.fragment,e),u(nt.$$.fragment,e),u(ot.$$.fragment,e),u(mt.$$.fragment,e),u(ct.$$.fragment,e),u(dt.$$.fragment,e),u(gt.$$.fragment,e),u(Mt.$$.fragment,e),u(bt.$$.fragment,e),u(Zt.$$.fragment,e),u(Wt.$$.fragment,e),u(Ut.$$.fragment,e),u(vt.$$.fragment,e),u(de.$$.fragment,e),u(kt.$$.fragment,e),u(It.$$.fragment,e),u(Xt.$$.fragment,e),u(Ft.$$.fragment,e),u(Vt.$$.fragment,e),u(Ct.$$.fragment,e),u(St.$$.fragment,e),u($t.$$.fragment,e),u(Ht.$$.fragment,e),u(Lt.$$.fragment,e),u(Dt.$$.fragment,e),Xn=!0)},o(e){y(be.$$.fragment,e),y(Je.$$.fragment,e),y(Te.$$.fragment,e),y(S.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(ve.$$.fragment,e),y(Be.$$.fragment,e),y(_e.$$.fragment,e),y(xe.$$.fragment,e),y(Ye.$$.fragment,e),y(Ve.$$.fragment,e),y(Re.$$.fragment,e),y(Ce.$$.fragment,e),y(Qe.$$.fragment,e),y($e.$$.fragment,e),y(He.$$.fragment,e),y(Ae.$$.fragment,e),y(Le.$$.fragment,e),y(Pe.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(lt.$$.fragment,e),y(nt.$$.fragment,e),y(ot.$$.fragment,e),y(mt.$$.fragment,e),y(ct.$$.fragment,e),y(dt.$$.fragment,e),y(gt.$$.fragment,e),y(Mt.$$.fragment,e),y(bt.$$.fragment,e),y(Zt.$$.fragment,e),y(Wt.$$.fragment,e),y(Ut.$$.fragment,e),y(vt.$$.fragment,e),y(de.$$.fragment,e),y(kt.$$.fragment,e),y(It.$$.fragment,e),y(Xt.$$.fragment,e),y(Ft.$$.fragment,e),y(Vt.$$.fragment,e),y(Ct.$$.fragment,e),y(St.$$.fragment,e),y($t.$$.fragment,e),y(Ht.$$.fragment,e),y(Lt.$$.fragment,e),y(Dt.$$.fragment,e),Xn=!1},d(e){e&&(t(w),t(J),t(Na),t(Ca),t(Ze),t(Qa),t(We),t(Sa),t(we),t(Ea),t($a),t(Ha),t(E),t(za),t(Aa),t($),t(La),t(qa),t(H),t(Da),t(U),t(Pa),t(Ge),t(Ka),t(ke),t(Oa),t(T),t(el),t(j),t(tl),t(Ie),t(al),t(v),t(ll),t(Xe),t(nl),t(sl),t(G),t(il),t(Fe),t(pl),t(ol),t(k),t(ml),t(Ne),t(rl),t(cl),t(P),t(dl),t(B),t(hl),t(Se),t(gl),t(Ee),t(ul),t(yl),t(Ml),t(O),t(fl),t(ze),t(bl),t(Jl),t(Zl),t(ee),t(Wl),t(qe),t(wl),t(De),t(Tl),t(Ul),t(I),t(jl),t(Oe),t(vl),t(_),t(Gl),t(tt),t(kl),t(at),t(Bl),t(Il),t(le),t(_l),t(X),t(Xl),t(st),t(xl),t(it),t(Yl),t(pt),t(Fl),t(Vl),t(se),t(Rl),t(x),t(Nl),t(rt),t(Cl),t(Ql),t(pe),t(Sl),t(Y),t(El),t(ht),t($l),t(F),t(Hl),t(ut),t(zl),t(yt),t(Al),t(Ll),t(ft),t(ql),t(Dl),t(Jt),t(Pl),t(Kl),t(re),t(Ol),t(V),t(en),t(wt),t(tn),t(Tt),t(an),t(ln),t(jt),t(nn),t(sn),t(pn),t(Gt),t(on),t(mn),t(he),t(rn),t(Bt),t(cn),t(R),t(dn),t(_t),t(hn),t(N),t(gn),t(xt),t(un),t(Yt),t(yn),t(Mn),t(C),t(fn),t(Rt),t(bn),t(Nt),t(Jn),t(Zn),t(Qt),t(Wn),t(wn),t(Et),t(Tn),t(Un),t(Me),t(jn),t(Q),t(vn),t(zt),t(Gn),t(At),t(kn),t(Bn),t(qt),t(In),t(_n),t(Pt)),t(b),M(be),M(Je,e),M(Te,e),M(S,e),M(Ue,e),M(je,e),M(ve),M(Be),M(_e),M(xe,e),M(Ye),M(Ve,e),M(Re),M(Ce,e),M(Qe),M($e,e),M(He,e),M(Ae,e),M(Le,e),M(Pe,e),M(Ke),M(et),M(lt,e),M(nt),M(ot,e),M(mt),M(ct,e),M(dt),M(gt),M(Mt,e),M(bt,e),M(Zt,e),M(Wt),M(Ut,e),M(vt,e),M(de,e),M(kt,e),M(It),M(Xt),M(Ft,e),M(Vt),M(Ct,e),M(St,e),M($t,e),M(Ht),M(Lt,e),M(Dt,e)}}}const vp={local:"inpainting",sections:[{local:"create-a-mask-image",title:"Create a mask image"},{local:"popular-models",sections:[{local:"stable-diffusion-inpainting",title:"Stable Diffusion Inpainting"},{local:"stable-diffusion-xl-sdxl-inpainting",title:"Stable Diffusion XL (SDXL) Inpainting"},{local:"kandinsky-22-inpainting",title:"Kandinsky 2.2 Inpainting"}],title:"Popular models"},{local:"noninpaint-specific-checkpoints",title:"Non-inpaint specific checkpoints"},{local:"configure-pipeline-parameters",sections:[{local:"strength",title:"Strength"},{local:"guidance-scale",title:"Guidance scale"},{local:"negative-prompt",title:"Negative prompt"}],title:"Configure pipeline parameters"},{local:"chained-inpainting-pipelines",sections:[{local:"texttoimagetoinpaint",title:"Text-to-image-to-inpaint"},{local:"inpainttoimagetoimage",title:"Inpaint-to-image-to-image"}],title:"Chained inpainting pipelines"},{local:"control-image-generation",sections:[{local:"prompt-weighting",title:"Prompt weighting"},{local:"controlnet",title:"ControlNet"}],title:"Control image generation"},{local:"optimize",title:"Optimize"}],title:"Inpainting"};function Gp(Ot){return bp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yp extends Jp{constructor(b){super(),Zp(this,b,Gp,jp,Mp,{})}}export{Yp as component};
