import{s as En,o as qn,n as Ae}from"../chunks/scheduler.b108d059.js";import{S as Hn,i as Xn,g as d,s as l,r as o,A as Ln,h as p,f as n,c as a,j as An,u as c,x as m,k as Nn,y as Yn,a as s,v as g,d as u,t as f,w as h}from"../chunks/index.008de539.js";import{H as w,g as Qn}from"../chunks/Heading.97e31253.js";import{T as Be}from"../chunks/Tip.aeb15ab7.js";import{C as M}from"../chunks/CodeBlock.3968c746.js";function Rn(j){let i,b='<code>InferenceClient</code> ist ein Python-Client, der HTTP-Anfragen an unsere APIs stellt. Wenn Sie die HTTP-Anfragen direkt mit Ihrem bevorzugten Tool (curl, postman,…) durchführen möchten, lesen Sie bitte die Dokumentationsseiten der <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inferenz API</a> oder der <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inferenz Endpunkte</a>.',r,y,Z='Für die Webentwicklung wurde ein <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS-Client</a> veröffentlicht. Wenn Sie sich für die Spieleentwicklung interessieren, sollten Sie einen Blick auf unser <a href="https://github.com/huggingface/unity-api" rel="nofollow">C#-Projekt</a> werfen.';return{c(){i=d("p"),i.innerHTML=b,r=l(),y=d("p"),y.innerHTML=Z},l($){i=p($,"P",{"data-svelte-h":!0}),m(i)!=="svelte-12n1cm4"&&(i.innerHTML=b),r=a($),y=p($,"P",{"data-svelte-h":!0}),m(y)!=="svelte-l5ey1v"&&(y.innerHTML=Z)},m($,U){s($,i,U),s($,r,U),s($,y,U)},p:Ae,d($){$&&(n(i),n(r),n(y))}}}function Pn(j){let i,b='Die API ist darauf ausgelegt, einfach zu sein. Nicht alle Parameter und Optionen sind für den Endbenutzer verfügbar oder beschrieben. Schauen Sie auf <a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">dieser Seite</a> nach, wenn Sie mehr über alle verfügbaren Parameter für jede Aufgabe erfahren möchten.';return{c(){i=d("p"),i.innerHTML=b},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1cacupf"&&(i.innerHTML=b)},m(r,y){s(r,i,y)},p:Ae,d(r){r&&n(i)}}}function Fn(j){let i,b='Es gibt mehr als 200k Modelle im Hugging Face Hub! Jede Aufgabe im <code>InferenceClient</code> kommt mit einem empfohlenen Modell. Beachten Sie, dass die HF-Empfehlung sich im Laufe der Zeit ohne vorherige Ankündigung ändern kann. Daher ist es am besten, ein Modell explizit festzulegen, sobald Sie sich entschieden haben. In den meisten Fällen werden Sie daran interessiert sein, ein Modell zu finden, das speziell auf <em>Ihre</em> Bedürfnisse zugeschnitten ist. Besuchen Sie die <a href="https://huggingface.co/models" rel="nofollow">Modelle</a>-Seite im Hub, um Ihre Möglichkeiten zu erkunden.';return{c(){i=d("p"),i.innerHTML=b},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fhuoal"&&(i.innerHTML=b)},m(r,y){s(r,i,y)},p:Ae,d(r){r&&n(i)}}}function Dn(j){let i,b="Die Authentifizierung ist NICHT zwingend erforderlich, wenn Sie die Inferenz API verwenden. Authentifizierte Benutzer erhalten jedoch ein höheres kostenloses Kontingent, um mit dem Service zu arbeiten. Ein Token ist auch zwingend erforderlich, wenn Sie Inferenz auf Ihren privaten Modellen oder auf privaten Endpunkten ausführen möchten.";return{c(){i=d("p"),i.textContent=b},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-f5dg6j"&&(i.textContent=b)},m(r,y){s(r,i,y)},p:Ae,d(r){r&&n(i)}}}function Kn(j){let i,b='Schauen Sie sich die <a href="https://huggingface.co/tasks" rel="nofollow">Aufgaben</a>-Seite an, um mehr über jede Aufgabe zu erfahren, wie man sie verwendet und die beliebtesten Modelle für jede Aufgabe.';return{c(){i=d("p"),i.innerHTML=b},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-81fkx7"&&(i.innerHTML=b)},m(r,y){s(r,i,y)},p:Ae,d(r){r&&n(i)}}}function On(j){let i,b="Dies ist der empfohlene Weg, um Ihren Code an <code>InferenceClient</code> anzupassen. Dadurch können Sie von den aufgabenspezifischen Methoden wie <code>feature_extraction</code> profitieren.";return{c(){i=d("p"),i.innerHTML=b},l(r){i=p(r,"P",{"data-svelte-h":!0}),m(i)!=="svelte-c34r9i"&&(i.innerHTML=b)},m(r,y){s(r,i,y)},p:Ae,d(r){r&&n(i)}}}function es(j){let i,b,r,y,Z,$,U,nn="Inferenz ist der Prozess, bei dem ein trainiertes Modell verwendet wird, um Vorhersagen für neue Daten zu treffen. Da dieser Prozess rechenintensiv sein kann, kann die Ausführung auf einem dedizierten Server eine interessante Option sein. Die <code>huggingface_hub</code> Bibliothek bietet eine einfache Möglichkeit, einen Dienst aufzurufen, der die Inferenz für gehostete Modelle durchführt. Es gibt mehrere Dienste, mit denen Sie sich verbinden können:",Ee,v,sn='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inferenz API</a>: ein Service, der Ihnen ermöglicht, beschleunigte Inferenz auf der Infrastruktur von Hugging Face kostenlos auszuführen. Dieser Service ist eine schnelle Möglichkeit, um anzufangen, verschiedene Modelle zu testen und AI-Produkte zu prototypisieren.</li> <li><a href="https://huggingface.co/inference-endpoints/index" rel="nofollow">Inferenz Endpunkte</a>: ein Produkt zur einfachen Bereitstellung von Modellen im Produktivbetrieb. Die Inferenz wird von Hugging Face in einer dedizierten, vollständig verwalteten Infrastruktur auf einem Cloud-Anbieter Ihrer Wahl durchgeführt.</li>',qe,J,ln='Diese Dienste können mit dem <code>InferenceClient</code> Objekt aufgerufen werden. Dieser fungiert als Ersatz für den älteren <code>InferenceApi</code> Client und fügt spezielle Unterstützung für Aufgaben und das Ausführen von Inferenz hinzu, sowohl auf <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inferenz API</a> als auch auf <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inferenz Endpunkten</a>. Im Abschnitt <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> erfahren Sie, wie Sie zum neuen Client migrieren können.',He,C,Xe,x,Le,S,an="Los geht’s mit einer Text-zu-Bild-Aufgabe:",Ye,G,Qe,_,rn='Wir haben einen <code>InferenceClient</code> mit den Standardparametern initialisiert. Das Einzige, was Sie wissen müssen, ist die <a href="#unterst%C3%BCtzte-aufgaben">Aufgabe</a>, die Sie ausführen möchten. Standardmäßig wird der Client sich mit der Inferenz API verbinden und ein Modell auswählen, um die Aufgabe abzuschließen. In unserem Beispiel haben wir ein Bild aus einem Textprompt generiert. Der zurückgegebene Wert ist ein <code>PIL.Image</code>-Objekt, das in eine Datei gespeichert werden kann.',Re,I,Pe,V,Fe,B,dn="Was ist, wenn Sie ein bestimmtes Modell verwenden möchten? Sie können es entweder als Parameter angeben oder direkt auf Instanzebene spezifizieren:",De,A,Ke,k,Oe,N,et,E,pn='Die oben gesehenen Beispiele nutzen die kostenfrei gehostete Inferenz API. Dies erweist sich als sehr nützlich für Prototyping und schnelles Testen. Wenn Sie bereit sind, Ihr Modell in die Produktion zu übernehmen, müssen Sie eine dedizierte Infrastruktur verwenden. Hier kommen <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inferenz Endpunkte</a> ins Spiel. Es ermöglicht Ihnen, jedes Modell zu implementieren und als private API freizugeben. Nach der Implementierung erhalten Sie eine URL, zu der Sie mit genau dem gleichen Code wie zuvor eine Verbindung herstellen können, wobei nur der <code>Modell</code>-Parameter geändert wird:',tt,q,nt,H,st,X,on='Aufrufe, die mit dem <code>InferenceClient</code> gemacht werden, können mit einem <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a> authentifiziert werden. Standardmäßig wird das auf Ihrem Computer gespeicherte Token verwendet, wenn Sie angemeldet sind (sehen Sie hier, <a href="https://huggingface.co/docs/huggingface_hub/quick-start#login" rel="nofollow">wie Sie sich anmelden können</a>). Wenn Sie nicht angemeldet sind, können Sie Ihr Token als Instanzparameter übergeben:',lt,L,at,T,it,Y,rt,Q,cn="Das Ziel von <code>InferenceClient</code> ist es, die einfachste Schnittstelle zum Ausführen von Inferenzen auf Hugging Face-Modellen bereitzustellen. Es verfügt über eine einfache API, die die gebräuchlichsten Aufgaben unterstützt. Hier ist eine Liste der derzeit unterstützten Aufgaben:",dt,R,gn='<thead><tr><th>Domäne</th> <th>Aufgabe</th> <th>Unterstützt</th> <th>Dokumentation</th></tr></thead> <tbody><tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td>✅</td> <td><code>audio_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td>✅</td> <td><code>automatic_speech_recognition()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td>✅</td> <td><code>text_to_speech()</code></td></tr> <tr><td>Computer Vision</td> <td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td>✅</td> <td><code>image_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td>✅</td> <td><code>image_segmentation()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td>✅</td> <td><code>image_to_image()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td>✅</td> <td><code>image_to_text()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td>✅</td> <td><code>object_detection()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td>✅</td> <td><code>text_to_image()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot-Image-Classification</a></td> <td>✅</td> <td><code>zero_shot_image_classification()</code></td></tr> <tr><td>Multimodal</td> <td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Documentation Question Answering</a></td> <td>✅</td> <td><code>document_question_answering()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td>✅</td> <td><code>visual_question_answering()</code></td></tr> <tr><td>NLP</td> <td><a href="https://huggingface.co/tasks/conversational" rel="nofollow">Conversational</a></td> <td>✅</td> <td><code>conversational()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td>✅</td> <td><code>feature_extraction()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill Mask</a></td> <td>✅</td> <td><code>fill_mask()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td>✅</td> <td><code>question_answering()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td>✅</td> <td><code>sentence_similarity()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td>✅</td> <td><code>summarization()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td>✅</td> <td><code>table_question_answering()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td>✅</td> <td><code>text_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Text Generation</a></td> <td>✅</td> <td><code>text_generation()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td>✅</td> <td><code>token_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td>✅</td> <td><code>translation()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero Shot Classification</a></td> <td>✅</td> <td><code>zero_shot_classification()</code></td></tr> <tr><td>Tabular</td> <td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>✅</td> <td><code>tabular_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>✅</td> <td><code>tabular_regression()</code></td></tr></tbody>',pt,z,ot,P,ct,F,un="Es ist jedoch nicht immer möglich, alle Anwendungsfälle abzudecken. Für benutzerdefinierte Anfragen bietet die <code>InferenceClient.post()</code> Methode Ihnen die Flexibilität, jede Anfrage an die Inferenz API zu senden. Zum Beispiel können Sie angeben, wie die Eingaben und Ausgaben geparst werden sollen. Im folgenden Beispiel wird das generierte Bild als Roh-Bytes zurückgegeben, anstatt es als <code>PIL Image</code> zu parsen. Dies kann hilfreich sein, wenn Sie <code>Pillow</code> in Ihrer Einrichtung nicht installiert haben und Ihnen nur die Binärinhalt des Bildes wichtig ist. <code>InferenceClient.post()</code> ist auch nützlich, um Aufgaben zu behandeln, die noch nicht offiziell unterstützt werden.",gt,D,ut,K,ft,O,fn="Eine asynchrone Version des Clients wird ebenfalls bereitgestellt, basierend auf <code>asyncio</code> und <code>aiohttp</code>. Sie können entweder <code>aiohttp</code> direkt installieren oder das <code>[inference]</code> Extra verwenden:",ht,ee,mt,te,hn="Nach der Installation sind alle asynchronen API-Endpunkte über <code>AsyncInferenceClient</code> verfügbar. Seine Initialisierung und APIs sind genau gleich wie die synchronisierte Version.",bt,ne,yt,se,mn='Für weitere Informationen zum <code>asyncio</code>-Modul konsultieren Sie bitte die <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">offizielle Dokumentation</a>.',Mt,le,wt,ae,bn="Im obigen Abschnitt haben wir die Hauptaspekte von <code>InferenceClient</code> betrachtet. Lassen Sie uns in einige fortgeschrittene Tipps eintauchen.",jt,ie,$t,re,yn="Bei der Inferenz gibt es zwei Hauptursachen für eine Zeitüberschreitung:",Ut,de,Mn="<li>Der Inferenzprozess dauert lange, um abgeschlossen zu werden.</li> <li>Das Modell ist nicht verfügbar, beispielsweise wenn die Inferenz API es zum ersten Mal lädt.</li>",Zt,pe,wn="Der <code>InferenceClient</code> verfügt über einen globalen Zeitüberschreitungsparameter (<code>timeout</code>), um diese beiden Aspekte zu behandeln. Standardmäßig ist er auf <code>None</code> gesetzt, was bedeutet, dass der Client unendlich lange auf den Abschluss der Inferenz warten wird. Wenn Sie mehr Kontrolle in Ihrem Arbeitsablauf wünschen, können Sie ihn auf einen bestimmten Wert in Sekunden setzen. Wenn die Zeitüberschreitungsverzögerung abläuft, wird ein <code>InferenceTimeoutError</code> ausgelöst. Sie können diesen Fehler abfangen und in Ihrem Code behandeln:",Ct,oe,It,ce,kt,ge,jn="Einige Aufgaben erfordern binäre Eingaben, zum Beispiel bei der Arbeit mit Bildern oder Audiodateien. In diesem Fall versucht der [`InferenceClient] so permissiv wie möglich zu sein und akzeptiert verschiedene Typen:",Tt,ue,$n="<li>rohe <code>Bytes</code></li> <li>ein Datei-ähnliches Objekt, geöffnet als Binär (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>ein Pfad (<code>str</code> oder <code>Path</code>) zu einer lokalen Datei</li> <li>eine URL (<code>str</code>) zu einer entfernten Datei (z.B. <code>https://...</code>). In diesem Fall wird die Datei lokal heruntergeladen, bevor sie an die Inferenz API gesendet wird.</li>",zt,fe,Wt,he,vt,me,Un='Der <code>InferenceClient</code> dient als Ersatz für den veralteten <code>InferenceApi</code>-Client. Er bietet spezifische Unterstützung für Aufgaben und behandelt Inferenz sowohl auf der <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inferenz API</a> als auch auf den <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inferenz Endpunkten</a>.',Jt,be,Zn="Hier finden Sie eine kurze Anleitung, die Ihnen hilft, von <code>InferenceApi</code> zu <code>InferenceClient</code> zu migrieren.",xt,ye,St,Me,Cn="Ändern Sie von",Gt,we,_t,je,In="zu",Vt,$e,Bt,Ue,At,Ze,kn="Ändern Sie von",Nt,Ce,Et,Ie,Tn="zu",qt,ke,Ht,W,Xt,Te,Lt,ze,zn="Ändern Sie von",Yt,We,Qt,ve,Wn="zu",Rt,Je,Pt,xe,Ft,Se,vn="Ändern Sie von",Dt,Ge,Kt,_e,Jn="zu",Ot,Ve,en,Ne,tn;return Z=new w({props:{title:"Inferenz auf Servern ausführen",local:"inferenz-auf-servern-ausführen",headingTag:"h1"}}),C=new Be({props:{$$slots:{default:[Rn]},$$scope:{ctx:j}}}),x=new w({props:{title:"Erste Schritte",local:"erste-schritte",headingTag:"h2"}}),G=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),I=new Be({props:{warning:!0,$$slots:{default:[Pn]},$$scope:{ctx:j}}}),V=new w({props:{title:"Verwendung eines spezifischen Modells",local:"verwendung-eines-spezifischen-modells",headingTag:"h3"}}),A=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Client für ein spezifisches Modell initialisieren</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Oder nutzen Sie einen generischen Client, geben aber Ihr Modell als Argument an</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`,wrap:!1}}),k=new Be({props:{$$slots:{default:[Fn]},$$scope:{ctx:j}}}),N=new w({props:{title:"Verwendung einer spezifischen URL",local:"verwendung-einer-spezifischen-url",headingTag:"h3"}}),q=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># oder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),H=new w({props:{title:"Authentifizierung",local:"authentifizierung",headingTag:"h3"}}),L=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`,wrap:!1}}),T=new Be({props:{$$slots:{default:[Dn]},$$scope:{ctx:j}}}),Y=new w({props:{title:"Unterstützte Aufgaben",local:"unterstützte-aufgaben",headingTag:"h2"}}),z=new Be({props:{$$slots:{default:[Kn]},$$scope:{ctx:j}}}),P=new w({props:{title:"Benutzerdefinierte Anfragen",local:"benutzerdefinierte-anfragen",headingTag:"h2"}}),D=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTdEJTJDJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyKSUwQXJlc3BvbnNlLmNvbnRlbnQlMjAlMjMlMjByYXclMjBieXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>}, model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes</span>
<span class="hljs-string">b&#x27;...&#x27;</span>`,wrap:!1}}),K=new w({props:{title:"Asynchroner Client",local:"asynchroner-client",headingTag:"h2"}}),ee=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFpb2h0dHAlMEElMjMlMjBvZGVyJTBBcGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RA==",highlighted:`pip install aiohttp
<span class="hljs-comment"># oder</span>
pip install --upgrade huggingface_hub[inference]`,wrap:!1}}),ne=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Der Code muss in einem asyncio-konkurrenten Kontext ausgeführt werden.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),le=new w({props:{title:"Fortgeschrittene Tipps",local:"fortgeschrittene-tipps",headingTag:"h2"}}),ie=new w({props:{title:"Zeitüberschreitung",local:"zeitüberschreitung",headingTag:"h3"}}),oe=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),ce=new w({props:{title:"Binäre Eingaben",local:"binäre-eingaben",headingTag:"h3"}}),fe=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),he=new w({props:{title:"Legacy InferenceAPI client",local:"legacy-inferenceapi-client",headingTag:"h2"}}),ye=new w({props:{title:"Initialisierung",local:"initialisierung",headingTag:"h3"}}),we=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjB0b2tlbiUzREFQSV9UT0tFTik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),$e=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwdG9rZW4lM0RBUElfVE9LRU4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Ue=new w({props:{title:"Ausführen einer bestimmten Aufgabe",local:"ausführen-einer-bestimmten-aufgabe",headingTag:"h3"}}),Ce=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIycGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjElMjIlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQWluZmVyZW5jZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(...)`,wrap:!1}}),ke=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5mZXJlbmNlLmZlYXR1cmVfZXh0cmFjdGlvbiguLi4lMkMlMjBtb2RlbCUzRCUyMnBhcmFwaHJhc2UteGxtLXItbXVsdGlsaW5ndWFsLXYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inference.feature_extraction(..., model=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>)`,wrap:!1}}),W=new Be({props:{$$slots:{default:[On]},$$scope:{ctx:j}}}),Te=new w({props:{title:"Eigene Anfragen ausführen",local:"eigene-anfragen-ausführen",headingTag:"h3"}}),We=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBaW5mZXJlbmNlKGlucHV0cyUzRCUyMlRoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMCU1Qk1BU0slNUQuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),Je=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlN0QlMkMlMjBtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXJlc3BvbnNlLmpzb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>}, model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),xe=new w({props:{title:"Mit Parametern ausführen",local:"mit-parametern-ausführen",headingTag:"h3"}}),Ge=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIydHlwZWZvcm0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQWlucHV0cyUyMCUzRCUyMCUyMkhpJTJDJTIwSSUyMHJlY2VudGx5JTIwYm91Z2h0JTIwYSUyMGRldmljZSUyMGZyb20lMjB5b3VyJTIwY29tcGFueSUyMGJ1dCUyMGl0JTIwaXMlMjBub3QlMjB3b3JraW5nJTIwYXMlMjBhZHZlcnRpc2VkJTIwYW5kJTIwSSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwZ2V0JTIwcmVpbWJ1cnNlZCElMjIlMEFwYXJhbXMlMjAlM0QlMjAlN0IlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlN0QlMEFpbmZlcmVuY2UoaW5wdXRzJTJDJTIwcGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),Ve=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5wdXRzJTIwJTNEJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUwQXBhcmFtcyUyMCUzRCUyMCU3QiUyMmNhbmRpZGF0ZV9sYWJlbHMlMjIlM0ElNUIlMjJyZWZ1bmQlMjIlMkMlMjAlMjJsZWdhbCUyMiUyQyUyMCUyMmZhcSUyMiU1RCU3RCUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGlucHV0cyUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjBwYXJhbXMlN0QlMkMlMjBtb2RlbCUzRCUyMnR5cGVmb3JtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtbW5saSUyMiklMEFyZXNwb25zZS5qc29uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: inputs, <span class="hljs-string">&quot;parameters&quot;</span>: params}, model=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),{c(){i=d("meta"),b=l(),r=d("p"),y=l(),o(Z.$$.fragment),$=l(),U=d("p"),U.innerHTML=nn,Ee=l(),v=d("ul"),v.innerHTML=sn,qe=l(),J=d("p"),J.innerHTML=ln,He=l(),o(C.$$.fragment),Xe=l(),o(x.$$.fragment),Le=l(),S=d("p"),S.textContent=an,Ye=l(),o(G.$$.fragment),Qe=l(),_=d("p"),_.innerHTML=rn,Re=l(),o(I.$$.fragment),Pe=l(),o(V.$$.fragment),Fe=l(),B=d("p"),B.textContent=dn,De=l(),o(A.$$.fragment),Ke=l(),o(k.$$.fragment),Oe=l(),o(N.$$.fragment),et=l(),E=d("p"),E.innerHTML=pn,tt=l(),o(q.$$.fragment),nt=l(),o(H.$$.fragment),st=l(),X=d("p"),X.innerHTML=on,lt=l(),o(L.$$.fragment),at=l(),o(T.$$.fragment),it=l(),o(Y.$$.fragment),rt=l(),Q=d("p"),Q.innerHTML=cn,dt=l(),R=d("table"),R.innerHTML=gn,pt=l(),o(z.$$.fragment),ot=l(),o(P.$$.fragment),ct=l(),F=d("p"),F.innerHTML=un,gt=l(),o(D.$$.fragment),ut=l(),o(K.$$.fragment),ft=l(),O=d("p"),O.innerHTML=fn,ht=l(),o(ee.$$.fragment),mt=l(),te=d("p"),te.innerHTML=hn,bt=l(),o(ne.$$.fragment),yt=l(),se=d("p"),se.innerHTML=mn,Mt=l(),o(le.$$.fragment),wt=l(),ae=d("p"),ae.innerHTML=bn,jt=l(),o(ie.$$.fragment),$t=l(),re=d("p"),re.textContent=yn,Ut=l(),de=d("ul"),de.innerHTML=Mn,Zt=l(),pe=d("p"),pe.innerHTML=wn,Ct=l(),o(oe.$$.fragment),It=l(),o(ce.$$.fragment),kt=l(),ge=d("p"),ge.textContent=jn,Tt=l(),ue=d("ul"),ue.innerHTML=$n,zt=l(),o(fe.$$.fragment),Wt=l(),o(he.$$.fragment),vt=l(),me=d("p"),me.innerHTML=Un,Jt=l(),be=d("p"),be.innerHTML=Zn,xt=l(),o(ye.$$.fragment),St=l(),Me=d("p"),Me.textContent=Cn,Gt=l(),o(we.$$.fragment),_t=l(),je=d("p"),je.textContent=In,Vt=l(),o($e.$$.fragment),Bt=l(),o(Ue.$$.fragment),At=l(),Ze=d("p"),Ze.textContent=kn,Nt=l(),o(Ce.$$.fragment),Et=l(),Ie=d("p"),Ie.textContent=Tn,qt=l(),o(ke.$$.fragment),Ht=l(),o(W.$$.fragment),Xt=l(),o(Te.$$.fragment),Lt=l(),ze=d("p"),ze.textContent=zn,Yt=l(),o(We.$$.fragment),Qt=l(),ve=d("p"),ve.textContent=Wn,Rt=l(),o(Je.$$.fragment),Pt=l(),o(xe.$$.fragment),Ft=l(),Se=d("p"),Se.textContent=vn,Dt=l(),o(Ge.$$.fragment),Kt=l(),_e=d("p"),_e.textContent=Jn,Ot=l(),o(Ve.$$.fragment),en=l(),Ne=d("p"),this.h()},l(e){const t=Ln("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(n),b=a(e),r=p(e,"P",{}),An(r).forEach(n),y=a(e),c(Z.$$.fragment,e),$=a(e),U=p(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1bojokl"&&(U.innerHTML=nn),Ee=a(e),v=p(e,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-84e5ix"&&(v.innerHTML=sn),qe=a(e),J=p(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1w2f91d"&&(J.innerHTML=ln),He=a(e),c(C.$$.fragment,e),Xe=a(e),c(x.$$.fragment,e),Le=a(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1gpybzo"&&(S.textContent=an),Ye=a(e),c(G.$$.fragment,e),Qe=a(e),_=p(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1b1prmn"&&(_.innerHTML=rn),Re=a(e),c(I.$$.fragment,e),Pe=a(e),c(V.$$.fragment,e),Fe=a(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1g51yx8"&&(B.textContent=dn),De=a(e),c(A.$$.fragment,e),Ke=a(e),c(k.$$.fragment,e),Oe=a(e),c(N.$$.fragment,e),et=a(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1hopevd"&&(E.innerHTML=pn),tt=a(e),c(q.$$.fragment,e),nt=a(e),c(H.$$.fragment,e),st=a(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-vhl0ai"&&(X.innerHTML=on),lt=a(e),c(L.$$.fragment,e),at=a(e),c(T.$$.fragment,e),it=a(e),c(Y.$$.fragment,e),rt=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-phq0nn"&&(Q.innerHTML=cn),dt=a(e),R=p(e,"TABLE",{"data-svelte-h":!0}),m(R)!=="svelte-1sqr09d"&&(R.innerHTML=gn),pt=a(e),c(z.$$.fragment,e),ot=a(e),c(P.$$.fragment,e),ct=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-mf6bjz"&&(F.innerHTML=un),gt=a(e),c(D.$$.fragment,e),ut=a(e),c(K.$$.fragment,e),ft=a(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-gx6vyx"&&(O.innerHTML=fn),ht=a(e),c(ee.$$.fragment,e),mt=a(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1wz2uft"&&(te.innerHTML=hn),bt=a(e),c(ne.$$.fragment,e),yt=a(e),se=p(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-fcvx1r"&&(se.innerHTML=mn),Mt=a(e),c(le.$$.fragment,e),wt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1ezsyvc"&&(ae.innerHTML=bn),jt=a(e),c(ie.$$.fragment,e),$t=a(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-ixt41k"&&(re.textContent=yn),Ut=a(e),de=p(e,"UL",{"data-svelte-h":!0}),m(de)!=="svelte-im1zdg"&&(de.innerHTML=Mn),Zt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1ughh2"&&(pe.innerHTML=wn),Ct=a(e),c(oe.$$.fragment,e),It=a(e),c(ce.$$.fragment,e),kt=a(e),ge=p(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1m17crh"&&(ge.textContent=jn),Tt=a(e),ue=p(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-tga9hr"&&(ue.innerHTML=$n),zt=a(e),c(fe.$$.fragment,e),Wt=a(e),c(he.$$.fragment,e),vt=a(e),me=p(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-1pcxrp1"&&(me.innerHTML=Un),Jt=a(e),be=p(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1ktj5eb"&&(be.innerHTML=Zn),xt=a(e),c(ye.$$.fragment,e),St=a(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-20mqhv"&&(Me.textContent=Cn),Gt=a(e),c(we.$$.fragment,e),_t=a(e),je=p(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-94rsl7"&&(je.textContent=In),Vt=a(e),c($e.$$.fragment,e),Bt=a(e),c(Ue.$$.fragment,e),At=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-20mqhv"&&(Ze.textContent=kn),Nt=a(e),c(Ce.$$.fragment,e),Et=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-94rsl7"&&(Ie.textContent=Tn),qt=a(e),c(ke.$$.fragment,e),Ht=a(e),c(W.$$.fragment,e),Xt=a(e),c(Te.$$.fragment,e),Lt=a(e),ze=p(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-20mqhv"&&(ze.textContent=zn),Yt=a(e),c(We.$$.fragment,e),Qt=a(e),ve=p(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-94rsl7"&&(ve.textContent=Wn),Rt=a(e),c(Je.$$.fragment,e),Pt=a(e),c(xe.$$.fragment,e),Ft=a(e),Se=p(e,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-20mqhv"&&(Se.textContent=vn),Dt=a(e),c(Ge.$$.fragment,e),Kt=a(e),_e=p(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-94rsl7"&&(_e.textContent=Jn),Ot=a(e),c(Ve.$$.fragment,e),en=a(e),Ne=p(e,"P",{}),An(Ne).forEach(n),this.h()},h(){Nn(i,"name","hf:doc:metadata"),Nn(i,"content",ts)},m(e,t){Yn(document.head,i),s(e,b,t),s(e,r,t),s(e,y,t),g(Z,e,t),s(e,$,t),s(e,U,t),s(e,Ee,t),s(e,v,t),s(e,qe,t),s(e,J,t),s(e,He,t),g(C,e,t),s(e,Xe,t),g(x,e,t),s(e,Le,t),s(e,S,t),s(e,Ye,t),g(G,e,t),s(e,Qe,t),s(e,_,t),s(e,Re,t),g(I,e,t),s(e,Pe,t),g(V,e,t),s(e,Fe,t),s(e,B,t),s(e,De,t),g(A,e,t),s(e,Ke,t),g(k,e,t),s(e,Oe,t),g(N,e,t),s(e,et,t),s(e,E,t),s(e,tt,t),g(q,e,t),s(e,nt,t),g(H,e,t),s(e,st,t),s(e,X,t),s(e,lt,t),g(L,e,t),s(e,at,t),g(T,e,t),s(e,it,t),g(Y,e,t),s(e,rt,t),s(e,Q,t),s(e,dt,t),s(e,R,t),s(e,pt,t),g(z,e,t),s(e,ot,t),g(P,e,t),s(e,ct,t),s(e,F,t),s(e,gt,t),g(D,e,t),s(e,ut,t),g(K,e,t),s(e,ft,t),s(e,O,t),s(e,ht,t),g(ee,e,t),s(e,mt,t),s(e,te,t),s(e,bt,t),g(ne,e,t),s(e,yt,t),s(e,se,t),s(e,Mt,t),g(le,e,t),s(e,wt,t),s(e,ae,t),s(e,jt,t),g(ie,e,t),s(e,$t,t),s(e,re,t),s(e,Ut,t),s(e,de,t),s(e,Zt,t),s(e,pe,t),s(e,Ct,t),g(oe,e,t),s(e,It,t),g(ce,e,t),s(e,kt,t),s(e,ge,t),s(e,Tt,t),s(e,ue,t),s(e,zt,t),g(fe,e,t),s(e,Wt,t),g(he,e,t),s(e,vt,t),s(e,me,t),s(e,Jt,t),s(e,be,t),s(e,xt,t),g(ye,e,t),s(e,St,t),s(e,Me,t),s(e,Gt,t),g(we,e,t),s(e,_t,t),s(e,je,t),s(e,Vt,t),g($e,e,t),s(e,Bt,t),g(Ue,e,t),s(e,At,t),s(e,Ze,t),s(e,Nt,t),g(Ce,e,t),s(e,Et,t),s(e,Ie,t),s(e,qt,t),g(ke,e,t),s(e,Ht,t),g(W,e,t),s(e,Xt,t),g(Te,e,t),s(e,Lt,t),s(e,ze,t),s(e,Yt,t),g(We,e,t),s(e,Qt,t),s(e,ve,t),s(e,Rt,t),g(Je,e,t),s(e,Pt,t),g(xe,e,t),s(e,Ft,t),s(e,Se,t),s(e,Dt,t),g(Ge,e,t),s(e,Kt,t),s(e,_e,t),s(e,Ot,t),g(Ve,e,t),s(e,en,t),s(e,Ne,t),tn=!0},p(e,[t]){const xn={};t&2&&(xn.$$scope={dirty:t,ctx:e}),C.$set(xn);const Sn={};t&2&&(Sn.$$scope={dirty:t,ctx:e}),I.$set(Sn);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),k.$set(Gn);const _n={};t&2&&(_n.$$scope={dirty:t,ctx:e}),T.$set(_n);const Vn={};t&2&&(Vn.$$scope={dirty:t,ctx:e}),z.$set(Vn);const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),W.$set(Bn)},i(e){tn||(u(Z.$$.fragment,e),u(C.$$.fragment,e),u(x.$$.fragment,e),u(G.$$.fragment,e),u(I.$$.fragment,e),u(V.$$.fragment,e),u(A.$$.fragment,e),u(k.$$.fragment,e),u(N.$$.fragment,e),u(q.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),u(T.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u($e.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(W.$$.fragment,e),u(Te.$$.fragment,e),u(We.$$.fragment,e),u(Je.$$.fragment,e),u(xe.$$.fragment,e),u(Ge.$$.fragment,e),u(Ve.$$.fragment,e),tn=!0)},o(e){f(Z.$$.fragment,e),f(C.$$.fragment,e),f(x.$$.fragment,e),f(G.$$.fragment,e),f(I.$$.fragment,e),f(V.$$.fragment,e),f(A.$$.fragment,e),f(k.$$.fragment,e),f(N.$$.fragment,e),f(q.$$.fragment,e),f(H.$$.fragment,e),f(L.$$.fragment,e),f(T.$$.fragment,e),f(Y.$$.fragment,e),f(z.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(ce.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f($e.$$.fragment,e),f(Ue.$$.fragment,e),f(Ce.$$.fragment,e),f(ke.$$.fragment,e),f(W.$$.fragment,e),f(Te.$$.fragment,e),f(We.$$.fragment,e),f(Je.$$.fragment,e),f(xe.$$.fragment,e),f(Ge.$$.fragment,e),f(Ve.$$.fragment,e),tn=!1},d(e){e&&(n(b),n(r),n(y),n($),n(U),n(Ee),n(v),n(qe),n(J),n(He),n(Xe),n(Le),n(S),n(Ye),n(Qe),n(_),n(Re),n(Pe),n(Fe),n(B),n(De),n(Ke),n(Oe),n(et),n(E),n(tt),n(nt),n(st),n(X),n(lt),n(at),n(it),n(rt),n(Q),n(dt),n(R),n(pt),n(ot),n(ct),n(F),n(gt),n(ut),n(ft),n(O),n(ht),n(mt),n(te),n(bt),n(yt),n(se),n(Mt),n(wt),n(ae),n(jt),n($t),n(re),n(Ut),n(de),n(Zt),n(pe),n(Ct),n(It),n(kt),n(ge),n(Tt),n(ue),n(zt),n(Wt),n(vt),n(me),n(Jt),n(be),n(xt),n(St),n(Me),n(Gt),n(_t),n(je),n(Vt),n(Bt),n(At),n(Ze),n(Nt),n(Et),n(Ie),n(qt),n(Ht),n(Xt),n(Lt),n(ze),n(Yt),n(Qt),n(ve),n(Rt),n(Pt),n(Ft),n(Se),n(Dt),n(Kt),n(_e),n(Ot),n(en),n(Ne)),n(i),h(Z,e),h(C,e),h(x,e),h(G,e),h(I,e),h(V,e),h(A,e),h(k,e),h(N,e),h(q,e),h(H,e),h(L,e),h(T,e),h(Y,e),h(z,e),h(P,e),h(D,e),h(K,e),h(ee,e),h(ne,e),h(le,e),h(ie,e),h(oe,e),h(ce,e),h(fe,e),h(he,e),h(ye,e),h(we,e),h($e,e),h(Ue,e),h(Ce,e),h(ke,e),h(W,e),h(Te,e),h(We,e),h(Je,e),h(xe,e),h(Ge,e),h(Ve,e)}}}const ts='{"title":"Inferenz auf Servern ausführen","local":"inferenz-auf-servern-ausführen","sections":[{"title":"Erste Schritte","local":"erste-schritte","sections":[{"title":"Verwendung eines spezifischen Modells","local":"verwendung-eines-spezifischen-modells","sections":[],"depth":3},{"title":"Verwendung einer spezifischen URL","local":"verwendung-einer-spezifischen-url","sections":[],"depth":3},{"title":"Authentifizierung","local":"authentifizierung","sections":[],"depth":3}],"depth":2},{"title":"Unterstützte Aufgaben","local":"unterstützte-aufgaben","sections":[],"depth":2},{"title":"Benutzerdefinierte Anfragen","local":"benutzerdefinierte-anfragen","sections":[],"depth":2},{"title":"Asynchroner Client","local":"asynchroner-client","sections":[],"depth":2},{"title":"Fortgeschrittene Tipps","local":"fortgeschrittene-tipps","sections":[{"title":"Zeitüberschreitung","local":"zeitüberschreitung","sections":[],"depth":3},{"title":"Binäre Eingaben","local":"binäre-eingaben","sections":[],"depth":3}],"depth":2},{"title":"Legacy InferenceAPI client","local":"legacy-inferenceapi-client","sections":[{"title":"Initialisierung","local":"initialisierung","sections":[],"depth":3},{"title":"Ausführen einer bestimmten Aufgabe","local":"ausführen-einer-bestimmten-aufgabe","sections":[],"depth":3},{"title":"Eigene Anfragen ausführen","local":"eigene-anfragen-ausführen","sections":[],"depth":3},{"title":"Mit Parametern ausführen","local":"mit-parametern-ausführen","sections":[],"depth":3}],"depth":2}],"depth":1}';function ns(j){return qn(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Qn}),[]}class ds extends Hn{constructor(i){super(),Xn(this,i,ns,es,En,{})}}export{ds as component};
