import{s as kl,o as Nl}from"../chunks/scheduler.f7e1785c.js";import{S as Zl,i as Gl,g as a,s as M,r as i,A as Wl,h as p,f as e,c as n,j as gl,u as J,x as C,k as al,y as vl,a as s,v as U,d as y,t as j,w as m,m as Xl,n as Yl}from"../chunks/index.9f8f0838.js";import{T as zl}from"../chunks/Tip.4575d9cf.js";import{C as T}from"../chunks/CodeBlock.b3510e34.js";import{H as nl}from"../chunks/Heading.6643a2f7.js";function Hl(Ut){let u;return{c(){u=Xl(`💡 Некоторые сведения о передискретизации: Если аудиосигнал дискретизирован с частотой 8 кГц, т. е. имеет 8000 выборок в
секунду, то мы знаем, что он не содержит частот выше 4 кГц. Это гарантируется теоремой Найквиста 
о дискретизации. Благодаря этому мы можем быть уверены, что между точками дискретизации исходный непрерывный сигнал всегда
имеет плавную кривую. Повышение частоты дискретизации до более высокой сводится к вычислению дополнительных значений выборки, которые находятся между
существующими, путем аппроксимации этой кривой. Однако понижающая дискретизация требует, чтобы мы сначала отфильтровали все частоты,
которые будут выше нового предела Найквиста, прежде чем оценивать новые точки дискретизации. Другими словами, нельзя
понизить дискретизацию в 2 раза, просто отбрасывая каждый второй сэмпл - это приведет к появлению искажений в сигнале, называемых
наложениями. Корректная передискретизация - дело непростое, и его лучше доверить проверенным библиотекам, таким как librosa или 🤗 Datasets.`)},l(r){u=Yl(r,`💡 Некоторые сведения о передискретизации: Если аудиосигнал дискретизирован с частотой 8 кГц, т. е. имеет 8000 выборок в
секунду, то мы знаем, что он не содержит частот выше 4 кГц. Это гарантируется теоремой Найквиста 
о дискретизации. Благодаря этому мы можем быть уверены, что между точками дискретизации исходный непрерывный сигнал всегда
имеет плавную кривую. Повышение частоты дискретизации до более высокой сводится к вычислению дополнительных значений выборки, которые находятся между
существующими, путем аппроксимации этой кривой. Однако понижающая дискретизация требует, чтобы мы сначала отфильтровали все частоты,
которые будут выше нового предела Найквиста, прежде чем оценивать новые точки дискретизации. Другими словами, нельзя
понизить дискретизацию в 2 раза, просто отбрасывая каждый второй сэмпл - это приведет к появлению искажений в сигнале, называемых
наложениями. Корректная передискретизация - дело непростое, и его лучше доверить проверенным библиотекам, таким как librosa или 🤗 Datasets.`)},m(r,w){s(r,u,w)},d(r){r&&e(u)}}}function ql(Ut){let u,r,w,yt,o,jt,f,pl=`Загрузка набора данных с помощью 🤗 Datasets - это только половина удовольствия. Если вы планируете использовать его либо для обучения модели, либо для выполнения
инференса, необходимо предварительно обработать данные. В общем случае это включает в себя следующие шаги:`,mt,h,Cl="<li>Передискретизация аудиоданных</li> <li>Фильтрация набора данных</li> <li>Преобразование аудиоданных в ожидаемый моделью формат входных данных</li>",ut,d,Tt,I,il=`Функция <code>load_dataset</code> загружает аудиопримеры с той частотой дискретизации, с которой они были опубликованы. Это не
всегда та частота дискретизации, которая ожидается моделью, которую вы планируете обучать или использовать для инференса. Если есть расхождение между
частотой дискретизации, можно передискретизировать звук до ожидаемой моделью частоты дискретизации.`,rt,E,Jl=`Большинство имеющихся предварительно обученных моделей были обучены на аудиоданных с частотой дискретизации 16 кГц.
Когда мы исследовали набор данных MINDS-14, вы могли заметить, что он сэмплирован с частотой 8 кГц, что означает, что нам, скорее всего, потребуется
увеличить частоту дискретизации.`,ct,A,Ul=`Чтобы сделать это, используйте метод 🤗 Datasets <code>cast_column</code>. Эта операция не изменяет звук непосредственно в наборе данных (in-place), а дает сигнал
datasets для передискретизации аудиопримеров “на лету” при их загрузке. Следующий код установит частоту дискретизации
равной 16 кГц:`,Vt,$,wt,b,yl="Перезагрузим первый аудиопример из набора данных MINDS-14 и проверим, что он был передискретизирован до нужной <code>sampling rate</code>:",ot,Q,ft,x,jl="<strong>Output:</strong>",ht,_,dt,R,ml=`Вы можете заметить, что значения массива теперь также отличаются. Это связано с тем, что теперь для
каждого значения амплитуды мы имеем в два раза больше значений чем раньше.`,It,c,Et,S,At,B,ul=`Возможно, потребуется отфильтровать данные по каким-либо критериям. Одним из распространенных случаев является ограничение аудиопримеров
определенной продолжительности. Например, для предотвращения ошибок, связанных с выходом за пределы доступного обьёма памяти,
необходимо отфильтровать все примеры длительностью более 20 секунд при обучении модели.`,$t,g,Tl=`Мы можем сделать это, используя метод 🤗 Datasets <code>filter</code> и передать ему функцию с логикой фильтрации. Начнем с того, что напишем функцию
которая определяет, какие примеры следует оставить, а какие отбросить. Эта функция, <code>is_audio_length_in_range</code>,
возвращает <code>True</code>, если длина образца меньше 20 с, и <code>False</code>, если больше 20 с.`,bt,k,Qt,N,rl=`Функция фильтрации может быть применена к столбцу набора данных, но в данном наборе столбец с длительностью звуковой дорожки отсутствует.
Однако мы можем его создать, отфильтровать по значениям в этом столбце, а затем удалить.`,xt,Z,_t,G,cl="<strong>Output:</strong>",Rt,W,St,v,Vl="Мы можем убедиться, что набор данных был отфильтрован с 654 примеров до 624.",Bt,X,gt,Y,wl=`Одним из наиболее сложных аспектов работы с наборами аудиоданных является подготовка данных в нужном для обучения модели
формате. Как вы видели, исходные аудиоданные поступают в виде массива значений образцов. Однако предварительно обученные модели, независимо от того, используете ли вы их
для инференса или для дообучения под вашу задачу, ожидают, что сырые данные будут преобразованы во входные признаки. Требования
к входным признакам могут быть различными для разных моделей - они зависят от архитектуры модели и данных, на которых она была
предварительно обучена. Хорошей новостью является то, что для каждой поддерживаемой аудиомодели 🤗 Transformers предлагает класс feature extractor
который может преобразовать сырые аудиоданные во входные признаки, ожидаемые моделью.`,kt,z,ol=`Что же делает экстрактор признаков с исходными аудиоданными? Давайте посмотрим на экстрактор признаков в <a href="https://huggingface.co/papers/2212.04356" rel="nofollow">Whisper</a>,
чтобы понять некоторые общие преобразования извлечения признаков. Whisper - это предварительно обученная модель для
автоматического распознавания речи (ASR), опубликованная в сентябре 2022 года Алеком Рэдфордом и другими из OpenAI.`,Nt,H,fl=`Сначала экстрактор признаков Whisper дополняет/обрезает батч аудиопримеров таким образом, что все образцы
имеют длительность входного сигнала 30 секунд. Примеры короче этого значения дополняются до 30 секунд путем добавления нулей в конец
последовательности (нули в аудиосигнале соответствуют отсутствию сигнала или тишине). Примеры длиной более 30 секунд усекаются до 30 секунд.
Поскольку все элементы в батче дополняются/обрезаются до максимальной длины во входном пространстве, необходимость в использованрии маски внимания
отпадает. Whisper уникален в этом отношении, большинству других аудиомоделей требуется маска внимания, которая подробно описывает,
где последовательности были дополненны, и, следовательно, где они должны быть проигнорированы в механизме самовнимания. Whisper
обучен работать без маски внимания и непосредственно по речевым сигналам определять, где следует игнорировать входные сигналы.`,Zt,q,hl=`Второй операцией, которую выполняет экстрактор признаков Whisper, является преобразование дополненных звуковых массивов в лог-мел спектрограммы.
Как вы помните, эти спектрограммы описывают, как изменяются частоты сигнала с течением времени, выраженные в шкале мел
и измеряются в децибелах (логарифмическая часть), чтобы сделать частоты и амплитуды более репрезентативными для человеческого слуха.`,Gt,F,dl=`Все эти преобразования могут быть применены к необработанным аудиоданным с помощью пары строк кода. Давайте загрузим
экстрактор признаков из предварительно обученной контрольной точки Whisper, чтобы получить готовые аудиоданные:`,Wt,L,vt,D,Il="Далее можно написать функцию для предварительной обработки одного аудиопримера, передавая его в <code>feature_extractor</code>.",Xt,P,Yt,O,El="Мы можем применить функцию подготовки данных ко всем нашим обучающим примерам, используя метод 🤗 Datasets’ map:",zt,K,Ht,tt,Al="<strong>Output:</strong>",qt,lt,Ft,et,$l="Вот так просто мы получили лог-мел спектрограммы в качестве <code>input_features</code> в наборе данных.",Lt,st,bl="Визуализируем ее для одного из примеров в наборе данных <code>minds</code>:",Dt,Mt,Pt,V,Ql='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',Ot,nt,xl="Теперь вы можете увидеть, как выглядит входной аудиосигнал для модели Whisper после препроцессинга.",Kt,at,_l=`Класс модели feature extractor занимается преобразованием сырых аудиоданных в формат, ожидаемый моделью. Однако,
многие задачи с использованием звука являются мультимодальными, например, распознавание речи.
В таких случаях 🤗 Transformers также предлагает специфичные для конкретной модели
токенизаторы для обработки текстовых данных. Для более глубокого изучения токенизаторов обратитесь к нашему <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">курсу по NLP</a>.`,tl,pt,Rl=`Вы можете загрузить экстрактор признаков и токенизатор для Whisper и других мультимодальных моделей отдельно, либо загрузить их через
так называемый процессор. Чтобы еще больше упростить задачу, используйте <code>AutoProcessor</code> для загрузки экстрактора признаков и процессора модели из контрольной точки,
например, так:`,ll,Ct,el,it,Sl=`Здесь мы проиллюстрировали основные этапы подготовки данных. Конечно, пользовательские данные могут потребовать более сложного препроцессинга.
В этом случае можно расширить функцию <code>prepare_dataset</code> для выполнения любых преобразований пользовательских данных. С 🤗 Datasets,
если вы можете записать процес подготовки данных как функцию Python, вы можете <a href="https://huggingface.co/docs/datasets/audio_process" rel="nofollow">применить его</a> к вашему набору данных!`,sl,Jt,Ml;return o=new nl({props:{title:"Препроцессинг набора аудиоданных",local:"препроцессинг-набора-аудиоданных",headingTag:"h1"}}),d=new nl({props:{title:"Передискретизация аудиоданных",local:"передискретизация-аудиоданных",headingTag:"h2"}}),$=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),Q=new T({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),_=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`,wrap:!1}}),c=new zl({props:{$$slots:{default:[Hl]},$$scope:{ctx:Ut}}}),S=new nl({props:{title:"Фильтрация набора данных",local:"фильтрация-набора-данных",headingTag:"h2"}}),k=new T({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),Z=new T({props:{code:"JTIzJTIwJUQwJUI4JUQxJTgxJUQwJUJGJUQwJUJFJUQwJUJCJUQxJThDJUQwJUI3JUQxJTgzJUQwJUI1JUQwJUJDJTIwbGlicm9zYSUyMCVEMCVCNCVEMCVCQiVEMSU4RiUyMCVEMCVCRiVEMCVCRSVEMCVCQiVEMSU4MyVEMSU4NyVEMCVCNSVEMCVCRCVEMCVCOCVEMSU4RiUyMCVEMCVCNCVEMCVCQiVEMCVCOCVEMSU4MiVEMCVCNSVEMCVCQiVEMSU4QyVEMCVCRCVEMCVCRSVEMSU4MSVEMSU4MiVEMCVCOCUyMCVEMSU4NCVEMSU4MCVEMCVCMCVEMCVCMyVEMCVCQyVEMCVCNSVEMCVCRCVEMSU4MiVEMCVCMCUyMCVEMCVCOCVEMCVCNyUyMCVEMCVCMCVEMSU4MyVEMCVCNCVEMCVCOCVEMCVCRSVEMSU4NCVEMCVCMCVEMCVCOSVEMCVCQiVEMCVCMCUwQW5ld19jb2x1bW4lMjAlM0QlMjAlNUJsaWJyb3NhLmdldF9kdXJhdGlvbihwYXRoJTNEeCklMjBmb3IlMjB4JTIwaW4lMjBtaW5kcyU1QiUyMnBhdGglMjIlNUQlNUQlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmFkZF9jb2x1bW4oJTIyZHVyYXRpb24lMjIlMkMlMjBuZXdfY29sdW1uKSUwQSUwQSUyMyUyMCVEMCVCOCVEMSU4MSVEMCVCRiVEMCVCRSVEMCVCQiVEMSU4QyVEMCVCNyVEMSU4MyVEMCVCNSVEMCVCQyUyMCVEMCVCQyVEMCVCNSVEMSU4MiVEMCVCRSVEMCVCNCUyMCVGMCU5RiVBNCU5NyUyMERhdGFzZXRzJTIwJTYwZmlsdGVyJTYwJTIwJUQwJUI0JUQwJUJCJUQxJThGJTIwJUQwJUJGJUQxJTgwJUQwJUI4JUQwJUJDJUQwJUI1JUQwJUJEJUQwJUI1JUQwJUJEJUQwJUI4JUQxJThGJTIwJUQxJTg0JUQxJTgzJUQwJUJEJUQwJUJBJUQxJTg2JUQwJUI4JUQwJUI4JTIwJUQxJTg0JUQwJUI4JUQwJUJCJUQxJThDJUQxJTgyJUQxJTgwJUQwJUIwJUQxJTg2JUQwJUI4JUQwJUI4JTBBbWluZHMlMjAlM0QlMjBtaW5kcy5maWx0ZXIoaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlJTJDJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQSUwQSUyMyUyMCVEMSU4MyVEMCVCNCVEMCVCMCVEMCVCQiVEMCVCOCVEMCVCQyUyMCVEMCVCMiVEMSU4MCVEMCVCNSVEMCVCQyVEMCVCNSVEMCVCRCVEMCVCRCVEMSU4QiVEMCVCOSUyMCVEMCVCMiVEMSU4MSVEMCVCRiVEMCVCRSVEMCVCQyVEMCVCRSVEMCVCMyVEMCVCMCVEMSU4MiVEMCVCNSVEMCVCQiVEMSU4QyVEMCVCRCVEMSU4QiVEMCVCOSUyMCVEMSU4MSVEMSU4MiVEMCVCRSVEMCVCQiVEMCVCMSVEMCVCNSVEMSU4NiUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># используем librosa для получения длительности фрагмента из аудиофайла</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># используем метод 🤗 Datasets \`filter\` для применения функции фильтрации</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># удалим временный вспомогательный столбец</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),W=new T({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),X=new nl({props:{title:"Препроцессинг аудиоданных",local:"препроцессинг-аудиоданных",headingTag:"h2"}}),L=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),P=new T({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),K=new T({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),lt=new T({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),Mt=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),Ct=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),{c(){u=a("meta"),r=M(),w=a("p"),yt=M(),i(o.$$.fragment),jt=M(),f=a("p"),f.textContent=pl,mt=M(),h=a("ul"),h.innerHTML=Cl,ut=M(),i(d.$$.fragment),Tt=M(),I=a("p"),I.innerHTML=il,rt=M(),E=a("p"),E.textContent=Jl,ct=M(),A=a("p"),A.innerHTML=Ul,Vt=M(),i($.$$.fragment),wt=M(),b=a("p"),b.innerHTML=yl,ot=M(),i(Q.$$.fragment),ft=M(),x=a("p"),x.innerHTML=jl,ht=M(),i(_.$$.fragment),dt=M(),R=a("p"),R.textContent=ml,It=M(),i(c.$$.fragment),Et=M(),i(S.$$.fragment),At=M(),B=a("p"),B.textContent=ul,$t=M(),g=a("p"),g.innerHTML=Tl,bt=M(),i(k.$$.fragment),Qt=M(),N=a("p"),N.textContent=rl,xt=M(),i(Z.$$.fragment),_t=M(),G=a("p"),G.innerHTML=cl,Rt=M(),i(W.$$.fragment),St=M(),v=a("p"),v.textContent=Vl,Bt=M(),i(X.$$.fragment),gt=M(),Y=a("p"),Y.textContent=wl,kt=M(),z=a("p"),z.innerHTML=ol,Nt=M(),H=a("p"),H.textContent=fl,Zt=M(),q=a("p"),q.textContent=hl,Gt=M(),F=a("p"),F.textContent=dl,Wt=M(),i(L.$$.fragment),vt=M(),D=a("p"),D.innerHTML=Il,Xt=M(),i(P.$$.fragment),Yt=M(),O=a("p"),O.textContent=El,zt=M(),i(K.$$.fragment),Ht=M(),tt=a("p"),tt.innerHTML=Al,qt=M(),i(lt.$$.fragment),Ft=M(),et=a("p"),et.innerHTML=$l,Lt=M(),st=a("p"),st.innerHTML=bl,Dt=M(),i(Mt.$$.fragment),Pt=M(),V=a("div"),V.innerHTML=Ql,Ot=M(),nt=a("p"),nt.textContent=xl,Kt=M(),at=a("p"),at.innerHTML=_l,tl=M(),pt=a("p"),pt.innerHTML=Rl,ll=M(),i(Ct.$$.fragment),el=M(),it=a("p"),it.innerHTML=Sl,sl=M(),Jt=a("p"),this.h()},l(t){const l=Wl("svelte-u9bgzb",document.head);u=p(l,"META",{name:!0,content:!0}),l.forEach(e),r=n(t),w=p(t,"P",{}),gl(w).forEach(e),yt=n(t),J(o.$$.fragment,t),jt=n(t),f=p(t,"P",{"data-svelte-h":!0}),C(f)!=="svelte-10nfixp"&&(f.textContent=pl),mt=n(t),h=p(t,"UL",{"data-svelte-h":!0}),C(h)!=="svelte-gaket1"&&(h.innerHTML=Cl),ut=n(t),J(d.$$.fragment,t),Tt=n(t),I=p(t,"P",{"data-svelte-h":!0}),C(I)!=="svelte-1u3hqdm"&&(I.innerHTML=il),rt=n(t),E=p(t,"P",{"data-svelte-h":!0}),C(E)!=="svelte-utis1t"&&(E.textContent=Jl),ct=n(t),A=p(t,"P",{"data-svelte-h":!0}),C(A)!=="svelte-1qhr4wx"&&(A.innerHTML=Ul),Vt=n(t),J($.$$.fragment,t),wt=n(t),b=p(t,"P",{"data-svelte-h":!0}),C(b)!=="svelte-new4zc"&&(b.innerHTML=yl),ot=n(t),J(Q.$$.fragment,t),ft=n(t),x=p(t,"P",{"data-svelte-h":!0}),C(x)!=="svelte-1mvdyro"&&(x.innerHTML=jl),ht=n(t),J(_.$$.fragment,t),dt=n(t),R=p(t,"P",{"data-svelte-h":!0}),C(R)!=="svelte-d4ablr"&&(R.textContent=ml),It=n(t),J(c.$$.fragment,t),Et=n(t),J(S.$$.fragment,t),At=n(t),B=p(t,"P",{"data-svelte-h":!0}),C(B)!=="svelte-o9zdbx"&&(B.textContent=ul),$t=n(t),g=p(t,"P",{"data-svelte-h":!0}),C(g)!=="svelte-17nji5x"&&(g.innerHTML=Tl),bt=n(t),J(k.$$.fragment,t),Qt=n(t),N=p(t,"P",{"data-svelte-h":!0}),C(N)!=="svelte-1ah2h6"&&(N.textContent=rl),xt=n(t),J(Z.$$.fragment,t),_t=n(t),G=p(t,"P",{"data-svelte-h":!0}),C(G)!=="svelte-1mvdyro"&&(G.innerHTML=cl),Rt=n(t),J(W.$$.fragment,t),St=n(t),v=p(t,"P",{"data-svelte-h":!0}),C(v)!=="svelte-3fx3vp"&&(v.textContent=Vl),Bt=n(t),J(X.$$.fragment,t),gt=n(t),Y=p(t,"P",{"data-svelte-h":!0}),C(Y)!=="svelte-15dsp1i"&&(Y.textContent=wl),kt=n(t),z=p(t,"P",{"data-svelte-h":!0}),C(z)!=="svelte-1q04il0"&&(z.innerHTML=ol),Nt=n(t),H=p(t,"P",{"data-svelte-h":!0}),C(H)!=="svelte-jyd83b"&&(H.textContent=fl),Zt=n(t),q=p(t,"P",{"data-svelte-h":!0}),C(q)!=="svelte-286khs"&&(q.textContent=hl),Gt=n(t),F=p(t,"P",{"data-svelte-h":!0}),C(F)!=="svelte-1jgugqe"&&(F.textContent=dl),Wt=n(t),J(L.$$.fragment,t),vt=n(t),D=p(t,"P",{"data-svelte-h":!0}),C(D)!=="svelte-15btkdu"&&(D.innerHTML=Il),Xt=n(t),J(P.$$.fragment,t),Yt=n(t),O=p(t,"P",{"data-svelte-h":!0}),C(O)!=="svelte-1s04r42"&&(O.textContent=El),zt=n(t),J(K.$$.fragment,t),Ht=n(t),tt=p(t,"P",{"data-svelte-h":!0}),C(tt)!=="svelte-1mvdyro"&&(tt.innerHTML=Al),qt=n(t),J(lt.$$.fragment,t),Ft=n(t),et=p(t,"P",{"data-svelte-h":!0}),C(et)!=="svelte-1nzea2k"&&(et.innerHTML=$l),Lt=n(t),st=p(t,"P",{"data-svelte-h":!0}),C(st)!=="svelte-s4tkjs"&&(st.innerHTML=bl),Dt=n(t),J(Mt.$$.fragment,t),Pt=n(t),V=p(t,"DIV",{class:!0,"data-svelte-h":!0}),C(V)!=="svelte-csckl"&&(V.innerHTML=Ql),Ot=n(t),nt=p(t,"P",{"data-svelte-h":!0}),C(nt)!=="svelte-cjxb98"&&(nt.textContent=xl),Kt=n(t),at=p(t,"P",{"data-svelte-h":!0}),C(at)!=="svelte-1idzxfc"&&(at.innerHTML=_l),tl=n(t),pt=p(t,"P",{"data-svelte-h":!0}),C(pt)!=="svelte-10ki5ki"&&(pt.innerHTML=Rl),ll=n(t),J(Ct.$$.fragment,t),el=n(t),it=p(t,"P",{"data-svelte-h":!0}),C(it)!=="svelte-2dkbcs"&&(it.innerHTML=Sl),sl=n(t),Jt=p(t,"P",{}),gl(Jt).forEach(e),this.h()},h(){al(u,"name","hf:doc:metadata"),al(u,"content",Fl),al(V,"class","flex justify-center")},m(t,l){vl(document.head,u),s(t,r,l),s(t,w,l),s(t,yt,l),U(o,t,l),s(t,jt,l),s(t,f,l),s(t,mt,l),s(t,h,l),s(t,ut,l),U(d,t,l),s(t,Tt,l),s(t,I,l),s(t,rt,l),s(t,E,l),s(t,ct,l),s(t,A,l),s(t,Vt,l),U($,t,l),s(t,wt,l),s(t,b,l),s(t,ot,l),U(Q,t,l),s(t,ft,l),s(t,x,l),s(t,ht,l),U(_,t,l),s(t,dt,l),s(t,R,l),s(t,It,l),U(c,t,l),s(t,Et,l),U(S,t,l),s(t,At,l),s(t,B,l),s(t,$t,l),s(t,g,l),s(t,bt,l),U(k,t,l),s(t,Qt,l),s(t,N,l),s(t,xt,l),U(Z,t,l),s(t,_t,l),s(t,G,l),s(t,Rt,l),U(W,t,l),s(t,St,l),s(t,v,l),s(t,Bt,l),U(X,t,l),s(t,gt,l),s(t,Y,l),s(t,kt,l),s(t,z,l),s(t,Nt,l),s(t,H,l),s(t,Zt,l),s(t,q,l),s(t,Gt,l),s(t,F,l),s(t,Wt,l),U(L,t,l),s(t,vt,l),s(t,D,l),s(t,Xt,l),U(P,t,l),s(t,Yt,l),s(t,O,l),s(t,zt,l),U(K,t,l),s(t,Ht,l),s(t,tt,l),s(t,qt,l),U(lt,t,l),s(t,Ft,l),s(t,et,l),s(t,Lt,l),s(t,st,l),s(t,Dt,l),U(Mt,t,l),s(t,Pt,l),s(t,V,l),s(t,Ot,l),s(t,nt,l),s(t,Kt,l),s(t,at,l),s(t,tl,l),s(t,pt,l),s(t,ll,l),U(Ct,t,l),s(t,el,l),s(t,it,l),s(t,sl,l),s(t,Jt,l),Ml=!0},p(t,[l]){const Bl={};l&2&&(Bl.$$scope={dirty:l,ctx:t}),c.$set(Bl)},i(t){Ml||(y(o.$$.fragment,t),y(d.$$.fragment,t),y($.$$.fragment,t),y(Q.$$.fragment,t),y(_.$$.fragment,t),y(c.$$.fragment,t),y(S.$$.fragment,t),y(k.$$.fragment,t),y(Z.$$.fragment,t),y(W.$$.fragment,t),y(X.$$.fragment,t),y(L.$$.fragment,t),y(P.$$.fragment,t),y(K.$$.fragment,t),y(lt.$$.fragment,t),y(Mt.$$.fragment,t),y(Ct.$$.fragment,t),Ml=!0)},o(t){j(o.$$.fragment,t),j(d.$$.fragment,t),j($.$$.fragment,t),j(Q.$$.fragment,t),j(_.$$.fragment,t),j(c.$$.fragment,t),j(S.$$.fragment,t),j(k.$$.fragment,t),j(Z.$$.fragment,t),j(W.$$.fragment,t),j(X.$$.fragment,t),j(L.$$.fragment,t),j(P.$$.fragment,t),j(K.$$.fragment,t),j(lt.$$.fragment,t),j(Mt.$$.fragment,t),j(Ct.$$.fragment,t),Ml=!1},d(t){t&&(e(r),e(w),e(yt),e(jt),e(f),e(mt),e(h),e(ut),e(Tt),e(I),e(rt),e(E),e(ct),e(A),e(Vt),e(wt),e(b),e(ot),e(ft),e(x),e(ht),e(dt),e(R),e(It),e(Et),e(At),e(B),e($t),e(g),e(bt),e(Qt),e(N),e(xt),e(_t),e(G),e(Rt),e(St),e(v),e(Bt),e(gt),e(Y),e(kt),e(z),e(Nt),e(H),e(Zt),e(q),e(Gt),e(F),e(Wt),e(vt),e(D),e(Xt),e(Yt),e(O),e(zt),e(Ht),e(tt),e(qt),e(Ft),e(et),e(Lt),e(st),e(Dt),e(Pt),e(V),e(Ot),e(nt),e(Kt),e(at),e(tl),e(pt),e(ll),e(el),e(it),e(sl),e(Jt)),e(u),m(o,t),m(d,t),m($,t),m(Q,t),m(_,t),m(c,t),m(S,t),m(k,t),m(Z,t),m(W,t),m(X,t),m(L,t),m(P,t),m(K,t),m(lt,t),m(Mt,t),m(Ct,t)}}}const Fl='{"title":"Препроцессинг набора аудиоданных","local":"препроцессинг-набора-аудиоданных","sections":[{"title":"Передискретизация аудиоданных","local":"передискретизация-аудиоданных","sections":[],"depth":2},{"title":"Фильтрация набора данных","local":"фильтрация-набора-данных","sections":[],"depth":2},{"title":"Препроцессинг аудиоданных","local":"препроцессинг-аудиоданных","sections":[],"depth":2}],"depth":1}';function Ll(Ut){return Nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class le extends Zl{constructor(u){super(),Gl(this,u,Ll,ql,kl,{})}}export{le as component};
