import{s as we,n as je,o as be}from"../chunks/scheduler.f7e1785c.js";import{S as ge,i as Ue,g as i,s as l,r as c,A as $e,h as o,f as s,c as n,j as Te,u,x as p,k as Je,y as Ie,a,v as m,d,t as h,w as M}from"../chunks/index.9f8f0838.js";import{C as W}from"../chunks/CodeBlock.b3510e34.js";import{H as qe}from"../chunks/Heading.6643a2f7.js";function Ce(ie){let r,G,N,Q,y,E,f,oe=`Audio classification involves assigning one or more labels to an audio recording based on its content. The labels
could correspond to different sound categories, such as music, speech, or noise, or more specific categories like
bird song or car engine sounds.`,F,T,pe=`Before diving into details on how the most popular audio transformers work, and before fine-tuning a custom model, let’s
see how you can use an off-the-shelf pre-trained model for audio classification with only a few lines of code with 🤗 Transformers.`,B,J,re=`Let’s go ahead and use the same <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> dataset that you have explored
in the previous unit. If you recall, MINDS-14 contains recordings of people asking an e-banking system questions in several
languages and dialects, and has the <code>intent_class</code> for each recording. We can classify the recordings by intent of the call.`,R,w,ce=`Just as before, let’s start by loading the <code>en-AU</code> subset of the data to try out the pipeline, and upsample it to 16kHz
sampling rate which is what most speech models require.`,L,j,H,b,ue=`To classify an audio recording into a set of classes, we can use the <code>audio-classification</code> pipeline from 🤗 Transformers.
In our case, we need a model that’s been fine-tuned for intent classification, and specifically on
the MINDS-14 dataset. Luckily for us, the Hub has a model that does just that! Let’s load it by using the <code>pipeline()</code> function:`,D,g,S,U,me=`This pipeline expects the audio data as a NumPy array. All the preprocessing of the raw audio data will be conveniently
handled for us by the pipeline. Let’s pick an example to try it out:`,P,$,V,I,de=`If you recall the structure of the dataset, the raw audio data is stored in a NumPy array under <code>[&quot;audio&quot;][&quot;array&quot;]</code>, let’s
pass it straight to the <code>classifier</code>:`,X,q,Y,C,he="<strong>Output:</strong>",O,k,K,x,Me=`The model is very confident that the caller intended to learn about paying their bill. Let’s see what the actual label for
this example is:`,ee,v,te,_,ye="<strong>Output:</strong>",se,z,ae,A,fe=`Hooray! The predicted label was correct! Here we were lucky to find a model that can classify the exact labels that we need.
A lot of the times, when dealing with a classification task, a pre-trained model’s set of classes is not exactly the same
as the classes you need the model to distinguish. In this case, you can fine-tune a pre-trained model to “calibrate” it to
your exact set of class labels. We’ll learn how to do this in the upcoming units. Now, let’s take a look at another very
common task in speech processing, <em>automatic speech recognition</em>.`,le,Z,ne;return y=new qe({props:{title:"Audio classification with a pipeline",local:"audio-classification-with-a-pipeline",headingTag:"h1"}}),j=new W({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLUFVJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),g=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`,wrap:!1}}),$=new W({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RA==",highlighted:'example = minds[<span class="hljs-number">0</span>]',wrap:!1}}),q=new W({props:{code:"Y2xhc3NpZmllcihleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:'classifier(example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])',wrap:!1}}),k=new W({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`,wrap:!1}}),v=new W({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),z=new W({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),{c(){r=i("meta"),G=l(),N=i("p"),Q=l(),c(y.$$.fragment),E=l(),f=i("p"),f.textContent=oe,F=l(),T=i("p"),T.textContent=pe,B=l(),J=i("p"),J.innerHTML=re,R=l(),w=i("p"),w.innerHTML=ce,L=l(),c(j.$$.fragment),H=l(),b=i("p"),b.innerHTML=ue,D=l(),c(g.$$.fragment),S=l(),U=i("p"),U.textContent=me,P=l(),c($.$$.fragment),V=l(),I=i("p"),I.innerHTML=de,X=l(),c(q.$$.fragment),Y=l(),C=i("p"),C.innerHTML=he,O=l(),c(k.$$.fragment),K=l(),x=i("p"),x.textContent=Me,ee=l(),c(v.$$.fragment),te=l(),_=i("p"),_.innerHTML=ye,se=l(),c(z.$$.fragment),ae=l(),A=i("p"),A.innerHTML=fe,le=l(),Z=i("p"),this.h()},l(e){const t=$e("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(s),G=n(e),N=o(e,"P",{}),Te(N).forEach(s),Q=n(e),u(y.$$.fragment,e),E=n(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-j9r3i6"&&(f.textContent=oe),F=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-dub6at"&&(T.textContent=pe),B=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1jsn8wa"&&(J.innerHTML=re),R=n(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-15x65jw"&&(w.innerHTML=ce),L=n(e),u(j.$$.fragment,e),H=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1gi5ja6"&&(b.innerHTML=ue),D=n(e),u(g.$$.fragment,e),S=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-h7hari"&&(U.textContent=me),P=n(e),u($.$$.fragment,e),V=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-nl73ko"&&(I.innerHTML=de),X=n(e),u(q.$$.fragment,e),Y=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1mvdyro"&&(C.innerHTML=he),O=n(e),u(k.$$.fragment,e),K=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1xhxyyp"&&(x.textContent=Me),ee=n(e),u(v.$$.fragment,e),te=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1mvdyro"&&(_.innerHTML=ye),se=n(e),u(z.$$.fragment,e),ae=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-66lxjm"&&(A.innerHTML=fe),le=n(e),Z=o(e,"P",{}),Te(Z).forEach(s),this.h()},h(){Je(r,"name","hf:doc:metadata"),Je(r,"content",ke)},m(e,t){Ie(document.head,r),a(e,G,t),a(e,N,t),a(e,Q,t),m(y,e,t),a(e,E,t),a(e,f,t),a(e,F,t),a(e,T,t),a(e,B,t),a(e,J,t),a(e,R,t),a(e,w,t),a(e,L,t),m(j,e,t),a(e,H,t),a(e,b,t),a(e,D,t),m(g,e,t),a(e,S,t),a(e,U,t),a(e,P,t),m($,e,t),a(e,V,t),a(e,I,t),a(e,X,t),m(q,e,t),a(e,Y,t),a(e,C,t),a(e,O,t),m(k,e,t),a(e,K,t),a(e,x,t),a(e,ee,t),m(v,e,t),a(e,te,t),a(e,_,t),a(e,se,t),m(z,e,t),a(e,ae,t),a(e,A,t),a(e,le,t),a(e,Z,t),ne=!0},p:je,i(e){ne||(d(y.$$.fragment,e),d(j.$$.fragment,e),d(g.$$.fragment,e),d($.$$.fragment,e),d(q.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(z.$$.fragment,e),ne=!0)},o(e){h(y.$$.fragment,e),h(j.$$.fragment,e),h(g.$$.fragment,e),h($.$$.fragment,e),h(q.$$.fragment,e),h(k.$$.fragment,e),h(v.$$.fragment,e),h(z.$$.fragment,e),ne=!1},d(e){e&&(s(G),s(N),s(Q),s(E),s(f),s(F),s(T),s(B),s(J),s(R),s(w),s(L),s(H),s(b),s(D),s(S),s(U),s(P),s(V),s(I),s(X),s(Y),s(C),s(O),s(K),s(x),s(ee),s(te),s(_),s(se),s(ae),s(A),s(le),s(Z)),s(r),M(y,e),M(j,e),M(g,e),M($,e),M(q,e),M(k,e),M(v,e),M(z,e)}}}const ke='{"title":"Audio classification with a pipeline","local":"audio-classification-with-a-pipeline","sections":[],"depth":1}';function xe(ie){return be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends ge{constructor(r){super(),Ue(this,r,xe,Ce,we,{})}}export{We as component};
