import{s as Xt,n as Yt,o as At}from"../chunks/scheduler.f7e1785c.js";import{S as Qt,i as Dt,g as i,s as n,r,A as Ot,h as o,f as s,c as a,j as Et,u as m,x as p,k as Pt,y as Kt,a as l,v as u,d as y,t as c,w as f}from"../chunks/index.9f8f0838.js";import{C as d}from"../chunks/CodeBlock.b3510e34.js";import{H as te}from"../chunks/Heading.6643a2f7.js";function ee(Jt){let h,Y,P,A,M,Q,w,xt=`Automatic Speech Recognition (ASR) is a task that involves transcribing speech audio recording into text.
This task has numerous practical applications, from creating closed captions for videos to enabling voice commands
for virtual assistants like Siri and Alexa.`,D,U,jt=`In this section, we’ll use the <code>automatic-speech-recognition</code> pipeline to transcribe an audio recording of a person
asking a question about paying a bill using the same MINDS-14 dataset as before.`,O,g,kt=`To get started, load the dataset and upsample it to 16kHz as described in <a href="audio_classification_pipeline">Audio classification with a pipeline</a>,
if you haven’t done that yet.`,K,T,It=`To transcribe an audio recording, we can use the <code>automatic-speech-recognition</code> pipeline from 🤗 Transformers. Let’s
instantiate the pipeline:`,tt,$,et,b,Gt="Next, we’ll take an example from the dataset and pass its raw data to the pipeline:",st,v,lt,C,Zt="<strong>Output:</strong>",nt,J,at,x,Wt="Let’s compare this output to what the actual transcription for this example is:",it,j,ot,k,qt="<strong>Output:</strong>",pt,I,rt,G,St=`The model seems to have done a pretty good job at transcribing the audio! It only got one word wrong (“card”) compared
to the original transcription, which is pretty good considering the speaker has an Australian accent, where the letter “r”
is often silent. Having said that, I wouldn’t recommend trying to pay your next electricity bill with a fish!`,mt,Z,Rt=`By default, this pipeline uses a model trained for automatic speech recognition for English language, which is fine in
this example. If you’d like to try transcribing other subsets of MINDS-14 in different language, you can find a pre-trained
ASR model <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;language=fr&amp;sort=downloads" rel="nofollow">on the 🤗 Hub</a>.
You can filter the models list by task first, then by language. Once you have found the model you like, pass it’s name as
the <code>model</code> argument to the pipeline.`,ut,W,_t="Let’s try this for the German split of the MINDS-14. Load the “de-DE” subset:",yt,q,ct,S,Bt="Get an example and see what the transcription is supposed to be:",ft,R,dt,_,Ht="<strong>Output:</strong>",ht,B,Mt,H,Vt="Find a pre-trained ASR model for German language on the 🤗 Hub, instantiate a pipeline, and transcribe the example:",wt,V,Ut,L,Lt="<strong>Output:</strong>",gt,F,Tt,N,Ft="Also, stimmt’s!",$t,z,Nt=`When working on solving your own task, starting with a simple pipeline like the ones we’ve shown in this unit is a valuable
tool that offers several benefits:`,bt,E,zt=`<li>a pre-trained model may exist that already solves your task really well, saving you plenty of time</li> <li>pipeline() takes care of all the pre/post-processing for you, so you don’t have to worry about getting the data into
the right format for a model</li> <li>if the result isn’t ideal, this still gives you a quick baseline for future fine-tuning</li> <li>once you fine-tune a model on your custom data and share it on Hub, the whole community will be able to use it quickly
and effortlessly via the <code>pipeline()</code> method making AI more accessible.</li>`,vt,X,Ct;return M=new te({props:{title:"Automatic speech recognition with a pipeline",local:"automatic-speech-recognition-with-a-pipeline",headingTag:"h1"}}),$=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXNyJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

asr = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`,wrap:!1}}),v=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWFzcihleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`example = minds[<span class="hljs-number">0</span>]
asr(example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),J=new d({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkklMjBXT1VMRCUyMExJS0UlMjBUTyUyMFBBWSUyME1ZJTIwRUxFQ1RSSUNJVFklMjBCSUxMJTIwVVNJTkclMjBNWSUyMENPRCUyMENBTiUyMFlPVSUyMFBMRUFTRSUyMEFTU0lTVCUyMiU3RA==",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;I WOULD LIKE TO PAY MY ELECTRICITY BILL USING MY COD CAN YOU PLEASE ASSIST&quot;}</span>',wrap:!1}}),j=new d({props:{code:"ZXhhbXBsZSU1QiUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiU1RA==",highlighted:'example[<span class="hljs-string">&quot;english_transcription&quot;</span>]',wrap:!1}}),I=new d({props:{code:"JTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMg==",highlighted:'<span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>',wrap:!1}}),q=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmRlLURFJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;de-DE&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),R=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGUlNUIlMjJ0cmFuc2NyaXB0aW9uJTIyJTVE",highlighted:`example = minds[<span class="hljs-number">0</span>]
example[<span class="hljs-string">&quot;transcription&quot;</span>]`,wrap:!1}}),B=new d({props:{code:"JTIyaWNoJTIwbSVDMyVCNmNodGUlMjBnZXJuZSUyMEdlbGQlMjBhdWYlMjBtZWluJTIwS29udG8lMjBlaW56YWhsZW4lMjI=",highlighted:'<span class="hljs-comment">&quot;ich möchte gerne Geld auf mein Konto einzahlen&quot;</span>',wrap:!1}}),V=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXNyJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybWF4aWRsJTJGd2F2MnZlYzItbGFyZ2UteGxzci1nZXJtYW4lMjIpJTBBYXNyKGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

asr = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;maxidl/wav2vec2-large-xlsr-german&quot;</span>)
asr(example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),F=new d({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMmljaCUyMG0lQzMlQjZjaHRlJTIwZ2VybmUlMjBnZWxkJTIwYXVmJTIwbWVpbiUyMGtvbnRvJTIwZWluemFsbGVuJTIyJTdE",highlighted:'{<span class="hljs-comment">&quot;text&quot;</span>: <span class="hljs-comment">&quot;ich möchte gerne geld auf mein konto einzallen&quot;</span>}',wrap:!1}}),{c(){h=i("meta"),Y=n(),P=i("p"),A=n(),r(M.$$.fragment),Q=n(),w=i("p"),w.textContent=xt,D=n(),U=i("p"),U.innerHTML=jt,O=n(),g=i("p"),g.innerHTML=kt,K=n(),T=i("p"),T.innerHTML=It,tt=n(),r($.$$.fragment),et=n(),b=i("p"),b.textContent=Gt,st=n(),r(v.$$.fragment),lt=n(),C=i("p"),C.innerHTML=Zt,nt=n(),r(J.$$.fragment),at=n(),x=i("p"),x.textContent=Wt,it=n(),r(j.$$.fragment),ot=n(),k=i("p"),k.innerHTML=qt,pt=n(),r(I.$$.fragment),rt=n(),G=i("p"),G.textContent=St,mt=n(),Z=i("p"),Z.innerHTML=Rt,ut=n(),W=i("p"),W.textContent=_t,yt=n(),r(q.$$.fragment),ct=n(),S=i("p"),S.textContent=Bt,ft=n(),r(R.$$.fragment),dt=n(),_=i("p"),_.innerHTML=Ht,ht=n(),r(B.$$.fragment),Mt=n(),H=i("p"),H.textContent=Vt,wt=n(),r(V.$$.fragment),Ut=n(),L=i("p"),L.innerHTML=Lt,gt=n(),r(F.$$.fragment),Tt=n(),N=i("p"),N.textContent=Ft,$t=n(),z=i("p"),z.textContent=Nt,bt=n(),E=i("ul"),E.innerHTML=zt,vt=n(),X=i("p"),this.h()},l(t){const e=Ot("svelte-u9bgzb",document.head);h=o(e,"META",{name:!0,content:!0}),e.forEach(s),Y=a(t),P=o(t,"P",{}),Et(P).forEach(s),A=a(t),m(M.$$.fragment,t),Q=a(t),w=o(t,"P",{"data-svelte-h":!0}),p(w)!=="svelte-15e8vhg"&&(w.textContent=xt),D=a(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1idfyxz"&&(U.innerHTML=jt),O=a(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-quk603"&&(g.innerHTML=kt),K=a(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1eb02q"&&(T.innerHTML=It),tt=a(t),m($.$$.fragment,t),et=a(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-stg8a5"&&(b.textContent=Gt),st=a(t),m(v.$$.fragment,t),lt=a(t),C=o(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1mvdyro"&&(C.innerHTML=Zt),nt=a(t),m(J.$$.fragment,t),at=a(t),x=o(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-9775ou"&&(x.textContent=Wt),it=a(t),m(j.$$.fragment,t),ot=a(t),k=o(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1mvdyro"&&(k.innerHTML=qt),pt=a(t),m(I.$$.fragment,t),rt=a(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1svug7g"&&(G.textContent=St),mt=a(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1mg2emn"&&(Z.innerHTML=Rt),ut=a(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-nvy5i8"&&(W.textContent=_t),yt=a(t),m(q.$$.fragment,t),ct=a(t),S=o(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-173pifj"&&(S.textContent=Bt),ft=a(t),m(R.$$.fragment,t),dt=a(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1mvdyro"&&(_.innerHTML=Ht),ht=a(t),m(B.$$.fragment,t),Mt=a(t),H=o(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1903dzv"&&(H.textContent=Vt),wt=a(t),m(V.$$.fragment,t),Ut=a(t),L=o(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1mvdyro"&&(L.innerHTML=Lt),gt=a(t),m(F.$$.fragment,t),Tt=a(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-4aj2v6"&&(N.textContent=Ft),$t=a(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-18ll1qj"&&(z.textContent=Nt),bt=a(t),E=o(t,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-1kd9vrj"&&(E.innerHTML=zt),vt=a(t),X=o(t,"P",{}),Et(X).forEach(s),this.h()},h(){Pt(h,"name","hf:doc:metadata"),Pt(h,"content",se)},m(t,e){Kt(document.head,h),l(t,Y,e),l(t,P,e),l(t,A,e),u(M,t,e),l(t,Q,e),l(t,w,e),l(t,D,e),l(t,U,e),l(t,O,e),l(t,g,e),l(t,K,e),l(t,T,e),l(t,tt,e),u($,t,e),l(t,et,e),l(t,b,e),l(t,st,e),u(v,t,e),l(t,lt,e),l(t,C,e),l(t,nt,e),u(J,t,e),l(t,at,e),l(t,x,e),l(t,it,e),u(j,t,e),l(t,ot,e),l(t,k,e),l(t,pt,e),u(I,t,e),l(t,rt,e),l(t,G,e),l(t,mt,e),l(t,Z,e),l(t,ut,e),l(t,W,e),l(t,yt,e),u(q,t,e),l(t,ct,e),l(t,S,e),l(t,ft,e),u(R,t,e),l(t,dt,e),l(t,_,e),l(t,ht,e),u(B,t,e),l(t,Mt,e),l(t,H,e),l(t,wt,e),u(V,t,e),l(t,Ut,e),l(t,L,e),l(t,gt,e),u(F,t,e),l(t,Tt,e),l(t,N,e),l(t,$t,e),l(t,z,e),l(t,bt,e),l(t,E,e),l(t,vt,e),l(t,X,e),Ct=!0},p:Yt,i(t){Ct||(y(M.$$.fragment,t),y($.$$.fragment,t),y(v.$$.fragment,t),y(J.$$.fragment,t),y(j.$$.fragment,t),y(I.$$.fragment,t),y(q.$$.fragment,t),y(R.$$.fragment,t),y(B.$$.fragment,t),y(V.$$.fragment,t),y(F.$$.fragment,t),Ct=!0)},o(t){c(M.$$.fragment,t),c($.$$.fragment,t),c(v.$$.fragment,t),c(J.$$.fragment,t),c(j.$$.fragment,t),c(I.$$.fragment,t),c(q.$$.fragment,t),c(R.$$.fragment,t),c(B.$$.fragment,t),c(V.$$.fragment,t),c(F.$$.fragment,t),Ct=!1},d(t){t&&(s(Y),s(P),s(A),s(Q),s(w),s(D),s(U),s(O),s(g),s(K),s(T),s(tt),s(et),s(b),s(st),s(lt),s(C),s(nt),s(at),s(x),s(it),s(ot),s(k),s(pt),s(rt),s(G),s(mt),s(Z),s(ut),s(W),s(yt),s(ct),s(S),s(ft),s(dt),s(_),s(ht),s(Mt),s(H),s(wt),s(Ut),s(L),s(gt),s(Tt),s(N),s($t),s(z),s(bt),s(E),s(vt),s(X)),s(h),f(M,t),f($,t),f(v,t),f(J,t),f(j,t),f(I,t),f(q,t),f(R,t),f(B,t),f(V,t),f(F,t)}}}const se='{"title":"Automatic speech recognition with a pipeline","local":"automatic-speech-recognition-with-a-pipeline","sections":[],"depth":1}';function le(Jt){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pe extends Qt{constructor(h){super(),Dt(this,h,le,ee,Xt,{})}}export{pe as component};
