import{s as de,n as ye,o as ue}from"../chunks/scheduler.85c25b89.js";import{S as je,i as Te,g as a,s as p,u as c,A as ge,h as n,f as e,c as i,j as h,v as M,y as m,k as o,o as r,a as l,w as J,d as w,t as d,x as y}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function fe(Ht){let u,ht,st,mt,j,U,lt,Z,_t,L,Xt="ResNet",ct,x,zt='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',Mt,T,I,at,E,Qt,q,Ft="How do I use this model on an image?",Jt,W,Dt="To load a pretrained model:",wt,$,dt,A,Pt="To load and preprocess the image:",yt,N,ut,B,Lt="To get the model predictions:",jt,R,Tt,G,qt="To get the top-5 predictions class names:",gt,_,ft,Q,Kt="Replace the model name with the variant you want to use, e.g. <code>resnet18</code>. You can find the IDs in the model summaries at the top of this page.",bt,S,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ut,g,v,nt,V,St,K,te="How do I finetune this model?",It,Y,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",vt,H,Ct,X,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,f,C,pt,z,Vt,O,le="How do I train this model?",Zt,F,ae='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',xt,b,k,it,D,Yt,tt,ne="Citation",Et,P,Wt,ot,$t;return Z=new rt({}),E=new rt({}),$=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),N=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),R=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),_=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new rt({}),H=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0MTgnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),D=new rt({}),P=new et({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIZVpSUzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCS2FpbWluZyUyMEhlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWGlhbmd5dSUyMFpoYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2hhb3FpbmclMjBSZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBKaWFuJTIwU3VuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JEZWVwJTIwUmVzaWR1YWwlMjBMZWFybmluZyUyMGZvciUyMEltYWdlJTIwUmVjb2duaXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE1MTIuMDMzODUlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNSU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNTEyLjAzMzg1JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTUxMi4wMzM4NSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QldlZCUyQyUyMDE3JTIwQXByJTIwMjAxOSUyMDE3JTNBMjMlM0E0NSUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSGVaUlMxNS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HeZRS15,
  author    = {Kaiming He and
               Xiangyu Zhang and
               Shaoqing Ren and
               Jian Sun},
  title     = {Deep Residual Learning <span class="hljs-keyword">for</span> Image Recognition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.03385</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.03385</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.03385</span>},
  timestamp = {Wed, <span class="hljs-number">17</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">17</span>:<span class="hljs-number">23</span>:<span class="hljs-number">45</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HeZRS15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`}}),{c(){u=a("meta"),ht=p(),st=a("p"),mt=p(),j=a("h1"),U=a("a"),lt=a("span"),c(Z.$$.fragment),_t=p(),L=a("span"),L.textContent=Xt,ct=p(),x=a("p"),x.innerHTML=zt,Mt=p(),T=a("h2"),I=a("a"),at=a("span"),c(E.$$.fragment),Qt=p(),q=a("span"),q.textContent=Ft,Jt=p(),W=a("p"),W.textContent=Dt,wt=p(),c($.$$.fragment),dt=p(),A=a("p"),A.textContent=Pt,yt=p(),c(N.$$.fragment),ut=p(),B=a("p"),B.textContent=Lt,jt=p(),c(R.$$.fragment),Tt=p(),G=a("p"),G.textContent=qt,gt=p(),c(_.$$.fragment),ft=p(),Q=a("p"),Q.innerHTML=Kt,bt=p(),S=a("p"),S.innerHTML=Ot,Ut=p(),g=a("h2"),v=a("a"),nt=a("span"),c(V.$$.fragment),St=p(),K=a("span"),K.textContent=te,It=p(),Y=a("p"),Y.textContent=ee,vt=p(),c(H.$$.fragment),Ct=p(),X=a("p"),X.innerHTML=se,kt=p(),f=a("h2"),C=a("a"),pt=a("span"),c(z.$$.fragment),Vt=p(),O=a("span"),O.textContent=le,Zt=p(),F=a("p"),F.innerHTML=ae,xt=p(),b=a("h2"),k=a("a"),it=a("span"),c(D.$$.fragment),Yt=p(),tt=a("span"),tt.textContent=ne,Et=p(),c(P.$$.fragment),Wt=p(),ot=a("p"),this.h()},l(t){const s=ge("svelte-1phssyn",document.head);u=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=i(t),st=n(t,"P",{}),h(st).forEach(e),mt=i(t),j=n(t,"H1",{class:!0});var At=h(j);U=n(At,"A",{id:!0,class:!0,href:!0});var pe=h(U);lt=n(pe,"SPAN",{});var ie=h(lt);M(Z.$$.fragment,ie),ie.forEach(e),pe.forEach(e),_t=i(At),L=n(At,"SPAN",{"data-svelte-h":!0}),m(L)!=="svelte-ww93ci"&&(L.textContent=Xt),At.forEach(e),ct=i(t),x=n(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-p6ybkz"&&(x.innerHTML=zt),Mt=i(t),T=n(t,"H2",{class:!0});var Nt=h(T);I=n(Nt,"A",{id:!0,class:!0,href:!0});var oe=h(I);at=n(oe,"SPAN",{});var re=h(at);M(E.$$.fragment,re),re.forEach(e),oe.forEach(e),Qt=i(Nt),q=n(Nt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=Ft),Nt.forEach(e),Jt=i(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-18ywhxh"&&(W.textContent=Dt),wt=i(t),M($.$$.fragment,t),dt=i(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1c2ipa8"&&(A.textContent=Pt),yt=i(t),M(N.$$.fragment,t),ut=i(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1n9qsq1"&&(B.textContent=Lt),jt=i(t),M(R.$$.fragment,t),Tt=i(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-19cnvx1"&&(G.textContent=qt),gt=i(t),M(_.$$.fragment,t),ft=i(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-f9b41k"&&(Q.innerHTML=Kt),bt=i(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1wmi3ea"&&(S.innerHTML=Ot),Ut=i(t),g=n(t,"H2",{class:!0});var Bt=h(g);v=n(Bt,"A",{id:!0,class:!0,href:!0});var he=h(v);nt=n(he,"SPAN",{});var me=h(nt);M(V.$$.fragment,me),me.forEach(e),he.forEach(e),St=i(Bt),K=n(Bt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Bt.forEach(e),It=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ee),vt=i(t),M(H.$$.fragment,t),Ct=i(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1kguc51"&&(X.innerHTML=se),kt=i(t),f=n(t,"H2",{class:!0});var Rt=h(f);C=n(Rt,"A",{id:!0,class:!0,href:!0});var ce=h(C);pt=n(ce,"SPAN",{});var Me=h(pt);M(z.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Vt=i(Rt),O=n(Rt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=le),Rt.forEach(e),Zt=i(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=ae),xt=i(t),b=n(t,"H2",{class:!0});var Gt=h(b);k=n(Gt,"A",{id:!0,class:!0,href:!0});var Je=h(k);it=n(Je,"SPAN",{});var we=h(it);M(D.$$.fragment,we),we.forEach(e),Je.forEach(e),Yt=i(Gt),tt=n(Gt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Gt.forEach(e),Et=i(t),M(P.$$.fragment,t),Wt=i(t),ot=n(t,"P",{}),h(ot).forEach(e),this.h()},h(){o(u,"name","hf:doc:metadata"),o(u,"content",JSON.stringify(be)),o(U,"id","resnet"),o(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(U,"href","#resnet"),o(j,"class","relative group"),o(I,"id","how-do-i-use-this-model-on-an-image"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-use-this-model-on-an-image"),o(T,"class","relative group"),o(v,"id","how-do-i-finetune-this-model"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#how-do-i-finetune-this-model"),o(g,"class","relative group"),o(C,"id","how-do-i-train-this-model"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#how-do-i-train-this-model"),o(f,"class","relative group"),o(k,"id","citation"),o(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(k,"href","#citation"),o(b,"class","relative group")},m(t,s){r(document.head,u),l(t,ht,s),l(t,st,s),l(t,mt,s),l(t,j,s),r(j,U),r(U,lt),J(Z,lt,null),r(j,_t),r(j,L),l(t,ct,s),l(t,x,s),l(t,Mt,s),l(t,T,s),r(T,I),r(I,at),J(E,at,null),r(T,Qt),r(T,q),l(t,Jt,s),l(t,W,s),l(t,wt,s),J($,t,s),l(t,dt,s),l(t,A,s),l(t,yt,s),J(N,t,s),l(t,ut,s),l(t,B,s),l(t,jt,s),J(R,t,s),l(t,Tt,s),l(t,G,s),l(t,gt,s),J(_,t,s),l(t,ft,s),l(t,Q,s),l(t,bt,s),l(t,S,s),l(t,Ut,s),l(t,g,s),r(g,v),r(v,nt),J(V,nt,null),r(g,St),r(g,K),l(t,It,s),l(t,Y,s),l(t,vt,s),J(H,t,s),l(t,Ct,s),l(t,X,s),l(t,kt,s),l(t,f,s),r(f,C),r(C,pt),J(z,pt,null),r(f,Vt),r(f,O),l(t,Zt,s),l(t,F,s),l(t,xt,s),l(t,b,s),r(b,k),r(k,it),J(D,it,null),r(b,Yt),r(b,tt),l(t,Et,s),J(P,t,s),l(t,Wt,s),l(t,ot,s),$t=!0},p:ye,i(t){$t||(w(Z.$$.fragment,t),w(E.$$.fragment,t),w($.$$.fragment,t),w(N.$$.fragment,t),w(R.$$.fragment,t),w(_.$$.fragment,t),w(V.$$.fragment,t),w(H.$$.fragment,t),w(z.$$.fragment,t),w(D.$$.fragment,t),w(P.$$.fragment,t),$t=!0)},o(t){d(Z.$$.fragment,t),d(E.$$.fragment,t),d($.$$.fragment,t),d(N.$$.fragment,t),d(R.$$.fragment,t),d(_.$$.fragment,t),d(V.$$.fragment,t),d(H.$$.fragment,t),d(z.$$.fragment,t),d(D.$$.fragment,t),d(P.$$.fragment,t),$t=!1},d(t){t&&(e(ht),e(st),e(mt),e(j),e(ct),e(x),e(Mt),e(T),e(Jt),e(W),e(wt),e(dt),e(A),e(yt),e(ut),e(B),e(jt),e(Tt),e(G),e(gt),e(ft),e(Q),e(bt),e(S),e(Ut),e(g),e(It),e(Y),e(vt),e(Ct),e(X),e(kt),e(f),e(Zt),e(F),e(xt),e(b),e(Et),e(Wt),e(ot)),e(u),y(Z),y(E),y($,t),y(N,t),y(R,t),y(_,t),y(V),y(H,t),y(z),y(D),y(P,t)}}}const be={local:"resnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"ResNet"};function Ue(Ht){return ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends je{constructor(u){super(),Te(this,u,Ue,fe,de,{})}}export{Ze as component};
