import{s as xs,n as Cs,o as ks}from"../chunks/scheduler.85c25b89.js";import{S as Is,i as _s,g as l,s as i,u as c,H as Ns,A as Ws,h as n,f as s,c as p,j as r,v as g,y as h,E as Zs,k as m,o,a as e,w as d,d as y,t as w,x as u}from"../chunks/index.9633332f.js";import{I as ct}from"../chunks/IconCopyLink.a4acffac.js";import{C as lt}from"../chunks/CodeBlock.00597c71.js";function Es(Dt){let M,gt,nt,dt,j,v,it,k,Xt,K,Kt="RegNetY",yt,I,Ot="<strong>RegNetY</strong> is a convolutional network design space with simple, regular models with parameters: depth $d$, initial width $w_{0} &gt; 0$, and slope $w_{a} &gt; 0$, and generates a different block width $u_{j}$ for each block $j &lt; d$. The key restriction for the RegNet types of model is that there is a linear parameterisation of block widths (the design space only contains models with this linear structure):",wt,O,ut,$s='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>j</mi><mo>=</mo><mi>w</mi><mi mathvariant="normal">_</mi><mn>0</mn><mo>+</mo><mi>w</mi><mi mathvariant="normal">_</mi><mi>a</mi><mo>⋅</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> u\\_{j} = w\\_{0} + w\\_{a}\\cdot{j} </annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9695em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9544em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord">0</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7545em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal">a</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">⋅</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span></span></span>',Mt,_,ts="For <strong>RegNetX</strong> authors have additional restrictions: we set $b = 1$ (the bottleneck ratio), $12 \\leq d \\leq 28$, and $w_{m} \\geq 2$ (the width multiplier).",jt,N,ss='For <strong>RegNetY</strong> authors make one change, which is to include <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">Squeeze-and-Excitation blocks</a>.',Jt,J,U,pt,W,Ft,tt,as="How do I use this model on an image?",ft,Z,es="To load a pretrained model:",Tt,E,bt,B,ls="To load and preprocess the image:",vt,G,Ut,Q,ns="To get the model predictions:",$t,R,xt,S,is="To get the top-5 predictions class names:",Ct,Y,kt,A,ps="Replace the model name with the variant you want to use, e.g. <code>regnety_002</code>. You can find the IDs in the model summaries at the top of this page.",It,V,ms='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',_t,f,$,mt,H,Pt,st,os="How do I finetune this model?",Nt,z,rs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Wt,X,Zt,F,hs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Et,T,x,ot,P,Lt,at,cs="How do I train this model?",Bt,L,gs='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Gt,b,C,rt,q,qt,et,ds="Citation",Qt,D,Rt,ht,St;return k=new ct({}),W=new ct({}),E=new lt({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlZ25ldHlfMDAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnety_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),G=new lt({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),R=new lt({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Y=new lt({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),H=new ct({}),X=new lt({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVnbmV0eV8wMDInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnety_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),P=new ct({}),q=new ct({}),D=new lt({props:{code:"JTQwbWlzYyU3QnJhZG9zYXZvdmljMjAyMGRlc2lnbmluZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRGVzaWduaW5nJTIwTmV0d29yayUyMERlc2lnbiUyMFNwYWNlcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QklsaWphJTIwUmFkb3Nhdm92aWMlMjBhbmQlMjBSYWolMjBQcmF0ZWVrJTIwS29zYXJhanUlMjBhbmQlMjBSb3NzJTIwR2lyc2hpY2slMjBhbmQlMjBLYWltaW5nJTIwSGUlMjBhbmQlMjBQaW90ciUyMERvbGwlQzMlQTFyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjc4JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{radosavovic2020designing,
      title={Designing Network Design Spaces}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Ilija Radosavovic and Raj Prateek Kosaraju and Ross Girshick and Kaiming He and Piotr Dollár}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2003.13678}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){M=l("meta"),gt=i(),nt=l("p"),dt=i(),j=l("h1"),v=l("a"),it=l("span"),c(k.$$.fragment),Xt=i(),K=l("span"),K.textContent=Kt,yt=i(),I=l("p"),I.innerHTML=Ot,wt=i(),O=l("p"),ut=new Ns(!1),Mt=i(),_=l("p"),_.innerHTML=ts,jt=i(),N=l("p"),N.innerHTML=ss,Jt=i(),J=l("h2"),U=l("a"),pt=l("span"),c(W.$$.fragment),Ft=i(),tt=l("span"),tt.textContent=as,ft=i(),Z=l("p"),Z.textContent=es,Tt=i(),c(E.$$.fragment),bt=i(),B=l("p"),B.textContent=ls,vt=i(),c(G.$$.fragment),Ut=i(),Q=l("p"),Q.textContent=ns,$t=i(),c(R.$$.fragment),xt=i(),S=l("p"),S.textContent=is,Ct=i(),c(Y.$$.fragment),kt=i(),A=l("p"),A.innerHTML=ps,It=i(),V=l("p"),V.innerHTML=ms,_t=i(),f=l("h2"),$=l("a"),mt=l("span"),c(H.$$.fragment),Pt=i(),st=l("span"),st.textContent=os,Nt=i(),z=l("p"),z.textContent=rs,Wt=i(),c(X.$$.fragment),Zt=i(),F=l("p"),F.innerHTML=hs,Et=i(),T=l("h2"),x=l("a"),ot=l("span"),c(P.$$.fragment),Lt=i(),at=l("span"),at.textContent=cs,Bt=i(),L=l("p"),L.innerHTML=gs,Gt=i(),b=l("h2"),C=l("a"),rt=l("span"),c(q.$$.fragment),qt=i(),et=l("span"),et.textContent=ds,Qt=i(),c(D.$$.fragment),Rt=i(),ht=l("p"),this.h()},l(t){const a=Ws("svelte-1phssyn",document.head);M=n(a,"META",{name:!0,content:!0}),a.forEach(s),gt=p(t),nt=n(t,"P",{}),r(nt).forEach(s),dt=p(t),j=n(t,"H1",{class:!0});var Yt=r(j);v=n(Yt,"A",{id:!0,class:!0,href:!0});var ys=r(v);it=n(ys,"SPAN",{});var ws=r(it);g(k.$$.fragment,ws),ws.forEach(s),ys.forEach(s),Xt=p(Yt),K=n(Yt,"SPAN",{"data-svelte-h":!0}),h(K)!=="svelte-6j3p7r"&&(K.textContent=Kt),Yt.forEach(s),yt=p(t),I=n(t,"P",{"data-svelte-h":!0}),h(I)!=="svelte-11eu1tk"&&(I.innerHTML=Ot),wt=p(t),O=n(t,"P",{});var us=r(O);ut=Zs(us,!1),us.forEach(s),Mt=p(t),_=n(t,"P",{"data-svelte-h":!0}),h(_)!=="svelte-h18xod"&&(_.innerHTML=ts),jt=p(t),N=n(t,"P",{"data-svelte-h":!0}),h(N)!=="svelte-q463eg"&&(N.innerHTML=ss),Jt=p(t),J=n(t,"H2",{class:!0});var At=r(J);U=n(At,"A",{id:!0,class:!0,href:!0});var Ms=r(U);pt=n(Ms,"SPAN",{});var js=r(pt);g(W.$$.fragment,js),js.forEach(s),Ms.forEach(s),Ft=p(At),tt=n(At,"SPAN",{"data-svelte-h":!0}),h(tt)!=="svelte-1c1hspn"&&(tt.textContent=as),At.forEach(s),ft=p(t),Z=n(t,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-18ywhxh"&&(Z.textContent=es),Tt=p(t),g(E.$$.fragment,t),bt=p(t),B=n(t,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1c2ipa8"&&(B.textContent=ls),vt=p(t),g(G.$$.fragment,t),Ut=p(t),Q=n(t,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1n9qsq1"&&(Q.textContent=ns),$t=p(t),g(R.$$.fragment,t),xt=p(t),S=n(t,"P",{"data-svelte-h":!0}),h(S)!=="svelte-19cnvx1"&&(S.textContent=is),Ct=p(t),g(Y.$$.fragment,t),kt=p(t),A=n(t,"P",{"data-svelte-h":!0}),h(A)!=="svelte-157wccv"&&(A.innerHTML=ps),It=p(t),V=n(t,"P",{"data-svelte-h":!0}),h(V)!=="svelte-1wmi3ea"&&(V.innerHTML=ms),_t=p(t),f=n(t,"H2",{class:!0});var Vt=r(f);$=n(Vt,"A",{id:!0,class:!0,href:!0});var Js=r($);mt=n(Js,"SPAN",{});var fs=r(mt);g(H.$$.fragment,fs),fs.forEach(s),Js.forEach(s),Pt=p(Vt),st=n(Vt,"SPAN",{"data-svelte-h":!0}),h(st)!=="svelte-1viv4qv"&&(st.textContent=os),Vt.forEach(s),Nt=p(t),z=n(t,"P",{"data-svelte-h":!0}),h(z)!=="svelte-9sr7nh"&&(z.textContent=rs),Wt=p(t),g(X.$$.fragment,t),Zt=p(t),F=n(t,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1kguc51"&&(F.innerHTML=hs),Et=p(t),T=n(t,"H2",{class:!0});var Ht=r(T);x=n(Ht,"A",{id:!0,class:!0,href:!0});var Ts=r(x);ot=n(Ts,"SPAN",{});var bs=r(ot);g(P.$$.fragment,bs),bs.forEach(s),Ts.forEach(s),Lt=p(Ht),at=n(Ht,"SPAN",{"data-svelte-h":!0}),h(at)!=="svelte-1ce591d"&&(at.textContent=cs),Ht.forEach(s),Bt=p(t),L=n(t,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1n0coha"&&(L.innerHTML=gs),Gt=p(t),b=n(t,"H2",{class:!0});var zt=r(b);C=n(zt,"A",{id:!0,class:!0,href:!0});var vs=r(C);rt=n(vs,"SPAN",{});var Us=r(rt);g(q.$$.fragment,Us),Us.forEach(s),vs.forEach(s),qt=p(zt),et=n(zt,"SPAN",{"data-svelte-h":!0}),h(et)!=="svelte-15mb3gy"&&(et.textContent=ds),zt.forEach(s),Qt=p(t),g(D.$$.fragment,t),Rt=p(t),ht=n(t,"P",{}),r(ht).forEach(s),this.h()},h(){m(M,"name","hf:doc:metadata"),m(M,"content",JSON.stringify(Bs)),m(v,"id","regnety"),m(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(v,"href","#regnety"),m(j,"class","relative group"),ut.a=null,m(U,"id","how-do-i-use-this-model-on-an-image"),m(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(U,"href","#how-do-i-use-this-model-on-an-image"),m(J,"class","relative group"),m($,"id","how-do-i-finetune-this-model"),m($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m($,"href","#how-do-i-finetune-this-model"),m(f,"class","relative group"),m(x,"id","how-do-i-train-this-model"),m(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(x,"href","#how-do-i-train-this-model"),m(T,"class","relative group"),m(C,"id","citation"),m(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(C,"href","#citation"),m(b,"class","relative group")},m(t,a){o(document.head,M),e(t,gt,a),e(t,nt,a),e(t,dt,a),e(t,j,a),o(j,v),o(v,it),d(k,it,null),o(j,Xt),o(j,K),e(t,yt,a),e(t,I,a),e(t,wt,a),e(t,O,a),ut.m($s,O),e(t,Mt,a),e(t,_,a),e(t,jt,a),e(t,N,a),e(t,Jt,a),e(t,J,a),o(J,U),o(U,pt),d(W,pt,null),o(J,Ft),o(J,tt),e(t,ft,a),e(t,Z,a),e(t,Tt,a),d(E,t,a),e(t,bt,a),e(t,B,a),e(t,vt,a),d(G,t,a),e(t,Ut,a),e(t,Q,a),e(t,$t,a),d(R,t,a),e(t,xt,a),e(t,S,a),e(t,Ct,a),d(Y,t,a),e(t,kt,a),e(t,A,a),e(t,It,a),e(t,V,a),e(t,_t,a),e(t,f,a),o(f,$),o($,mt),d(H,mt,null),o(f,Pt),o(f,st),e(t,Nt,a),e(t,z,a),e(t,Wt,a),d(X,t,a),e(t,Zt,a),e(t,F,a),e(t,Et,a),e(t,T,a),o(T,x),o(x,ot),d(P,ot,null),o(T,Lt),o(T,at),e(t,Bt,a),e(t,L,a),e(t,Gt,a),e(t,b,a),o(b,C),o(C,rt),d(q,rt,null),o(b,qt),o(b,et),e(t,Qt,a),d(D,t,a),e(t,Rt,a),e(t,ht,a),St=!0},p:Cs,i(t){St||(y(k.$$.fragment,t),y(W.$$.fragment,t),y(E.$$.fragment,t),y(G.$$.fragment,t),y(R.$$.fragment,t),y(Y.$$.fragment,t),y(H.$$.fragment,t),y(X.$$.fragment,t),y(P.$$.fragment,t),y(q.$$.fragment,t),y(D.$$.fragment,t),St=!0)},o(t){w(k.$$.fragment,t),w(W.$$.fragment,t),w(E.$$.fragment,t),w(G.$$.fragment,t),w(R.$$.fragment,t),w(Y.$$.fragment,t),w(H.$$.fragment,t),w(X.$$.fragment,t),w(P.$$.fragment,t),w(q.$$.fragment,t),w(D.$$.fragment,t),St=!1},d(t){t&&(s(gt),s(nt),s(dt),s(j),s(yt),s(I),s(wt),s(O),s(Mt),s(_),s(jt),s(N),s(Jt),s(J),s(ft),s(Z),s(Tt),s(bt),s(B),s(vt),s(Ut),s(Q),s($t),s(xt),s(S),s(Ct),s(kt),s(A),s(It),s(V),s(_t),s(f),s(Nt),s(z),s(Wt),s(Zt),s(F),s(Et),s(T),s(Bt),s(L),s(Gt),s(b),s(Qt),s(Rt),s(ht)),s(M),u(k),u(W),u(E,t),u(G,t),u(R,t),u(Y,t),u(H),u(X,t),u(P),u(q),u(D,t)}}}const Bs={local:"regnety",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"RegNetY"};function Gs(Dt){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends Is{constructor(M){super(),_s(this,M,Gs,Es,xs,{})}}export{As as component};
