import{s as Ue,n as xe,o as Ce}from"../chunks/scheduler.85c25b89.js";import{S as ke,i as Ie,g as l,s as i,u as c,A as Ze,h as n,f as e,c as o,j as h,v as d,y as m,k as p,o as r,a,w as u,d as M,t as g,x as f}from"../chunks/index.9633332f.js";import{I as ct}from"../chunks/IconCopyLink.a4acffac.js";import{C as lt}from"../chunks/CodeBlock.00597c71.js";function $e(qt){let j,dt,nt,ut,y,v,it,I,Ht,O,Dt="Noisy Student (EfficientNet)",Mt,Z,Kt=`<strong>Noisy Student Training</strong> is a semi-supervised learning approach. It extends the idea of self-training
and distillation with the use of equal-or-larger student models and noise added to the student during learning. It has three main steps:`,gt,$,Ot="<li>train a teacher model on labeled images</li> <li>use the teacher to generate pseudo labels on unlabeled images</li> <li>train a student model on the combination of labeled images and pseudo labeled images.</li>",ft,N,te="The algorithm is iterated a few times by treating the student as a teacher to relabel the unlabeled data and training a new student.",jt,_,ee="Noisy Student Training seeks to improve on self-training and distillation in two ways. First, it makes the student larger than, or at least equal to, the teacher so the student can better learn from a larger dataset. Second, it adds noise to the student so the noised student is forced to learn harder from the pseudo labels. To noise the student, it uses input noise such as RandAugment data augmentation, and model noise such as dropout and stochastic depth during training.",yt,w,U,ot,W,zt,tt,se="How do I use this model on an image?",wt,E,ae="To load a pretrained model:",Jt,B,bt,A,le="To load and preprocess the image:",Tt,G,vt,Q,ne="To get the model predictions:",Ut,X,xt,R,ie="To get the top-5 predictions class names:",Ct,S,kt,V,oe="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0_ns</code>. You can find the IDs in the model summaries at the top of this page.",It,Y,pe='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Zt,J,x,pt,H,Ft,et,re="How do I finetune this model?",$t,z,me="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Nt,F,_t,L,he=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Wt,b,C,rt,P,Lt,st,ce="How do I train this model?",Et,q,de='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Bt,T,k,mt,D,Pt,at,ue="Citation",At,K,Gt,ht,Qt;return I=new ct({}),W=new ct({}),B=new lt({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMF9ucyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ns&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),G=new lt({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),X=new lt({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),S=new lt({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),H=new ct({}),F=new lt({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwX25zJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ns&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),P=new ct({}),D=new ct({}),K=new lt({props:{code:"JTQwbWlzYyU3QnhpZTIwMjBzZWxmdHJhaW5pbmclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlNlbGYtdHJhaW5pbmclMjB3aXRoJTIwTm9pc3klMjBTdHVkZW50JTIwaW1wcm92ZXMlMjBJbWFnZU5ldCUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCUWl6aGUlMjBYaWUlMjBhbmQlMjBNaW5oLVRoYW5nJTIwTHVvbmclMjBhbmQlMjBFZHVhcmQlMjBIb3Z5JTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MTEuMDQyNTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5MRyU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{xie2020selftraining,
      title={Self-training with Noisy Student improves ImageNet classification}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Qizhe Xie and Minh-Thang Luong and Eduard Hovy and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1911.04252}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`}}),{c(){j=l("meta"),dt=i(),nt=l("p"),ut=i(),y=l("h1"),v=l("a"),it=l("span"),c(I.$$.fragment),Ht=i(),O=l("span"),O.textContent=Dt,Mt=i(),Z=l("p"),Z.innerHTML=Kt,gt=i(),$=l("ol"),$.innerHTML=Ot,ft=i(),N=l("p"),N.textContent=te,jt=i(),_=l("p"),_.textContent=ee,yt=i(),w=l("h2"),U=l("a"),ot=l("span"),c(W.$$.fragment),zt=i(),tt=l("span"),tt.textContent=se,wt=i(),E=l("p"),E.textContent=ae,Jt=i(),c(B.$$.fragment),bt=i(),A=l("p"),A.textContent=le,Tt=i(),c(G.$$.fragment),vt=i(),Q=l("p"),Q.textContent=ne,Ut=i(),c(X.$$.fragment),xt=i(),R=l("p"),R.textContent=ie,Ct=i(),c(S.$$.fragment),kt=i(),V=l("p"),V.innerHTML=oe,It=i(),Y=l("p"),Y.innerHTML=pe,Zt=i(),J=l("h2"),x=l("a"),pt=l("span"),c(H.$$.fragment),Ft=i(),et=l("span"),et.textContent=re,$t=i(),z=l("p"),z.textContent=me,Nt=i(),c(F.$$.fragment),_t=i(),L=l("p"),L.innerHTML=he,Wt=i(),b=l("h2"),C=l("a"),rt=l("span"),c(P.$$.fragment),Lt=i(),st=l("span"),st.textContent=ce,Et=i(),q=l("p"),q.innerHTML=de,Bt=i(),T=l("h2"),k=l("a"),mt=l("span"),c(D.$$.fragment),Pt=i(),at=l("span"),at.textContent=ue,At=i(),c(K.$$.fragment),Gt=i(),ht=l("p"),this.h()},l(t){const s=Ze("svelte-1phssyn",document.head);j=n(s,"META",{name:!0,content:!0}),s.forEach(e),dt=o(t),nt=n(t,"P",{}),h(nt).forEach(e),ut=o(t),y=n(t,"H1",{class:!0});var Xt=h(y);v=n(Xt,"A",{id:!0,class:!0,href:!0});var Me=h(v);it=n(Me,"SPAN",{});var ge=h(it);d(I.$$.fragment,ge),ge.forEach(e),Me.forEach(e),Ht=o(Xt),O=n(Xt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1376l0r"&&(O.textContent=Dt),Xt.forEach(e),Mt=o(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-zn3ycx"&&(Z.innerHTML=Kt),gt=o(t),$=n(t,"OL",{"data-svelte-h":!0}),m($)!=="svelte-1nvijn1"&&($.innerHTML=Ot),ft=o(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-5ws6hn"&&(N.textContent=te),jt=o(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1w0q41v"&&(_.textContent=ee),yt=o(t),w=n(t,"H2",{class:!0});var Rt=h(w);U=n(Rt,"A",{id:!0,class:!0,href:!0});var fe=h(U);ot=n(fe,"SPAN",{});var je=h(ot);d(W.$$.fragment,je),je.forEach(e),fe.forEach(e),zt=o(Rt),tt=n(Rt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1c1hspn"&&(tt.textContent=se),Rt.forEach(e),wt=o(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-18ywhxh"&&(E.textContent=ae),Jt=o(t),d(B.$$.fragment,t),bt=o(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1c2ipa8"&&(A.textContent=le),Tt=o(t),d(G.$$.fragment,t),vt=o(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1n9qsq1"&&(Q.textContent=ne),Ut=o(t),d(X.$$.fragment,t),xt=o(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-19cnvx1"&&(R.textContent=ie),Ct=o(t),d(S.$$.fragment,t),kt=o(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-12tmaxg"&&(V.innerHTML=oe),It=o(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1wmi3ea"&&(Y.innerHTML=pe),Zt=o(t),J=n(t,"H2",{class:!0});var St=h(J);x=n(St,"A",{id:!0,class:!0,href:!0});var ye=h(x);pt=n(ye,"SPAN",{});var we=h(pt);d(H.$$.fragment,we),we.forEach(e),ye.forEach(e),Ft=o(St),et=n(St,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-1viv4qv"&&(et.textContent=re),St.forEach(e),$t=o(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-9sr7nh"&&(z.textContent=me),Nt=o(t),d(F.$$.fragment,t),_t=o(t),L=n(t,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1kguc51"&&(L.innerHTML=he),Wt=o(t),b=n(t,"H2",{class:!0});var Vt=h(b);C=n(Vt,"A",{id:!0,class:!0,href:!0});var Je=h(C);rt=n(Je,"SPAN",{});var be=h(rt);d(P.$$.fragment,be),be.forEach(e),Je.forEach(e),Lt=o(Vt),st=n(Vt,"SPAN",{"data-svelte-h":!0}),m(st)!=="svelte-1ce591d"&&(st.textContent=ce),Vt.forEach(e),Et=o(t),q=n(t,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1n0coha"&&(q.innerHTML=de),Bt=o(t),T=n(t,"H2",{class:!0});var Yt=h(T);k=n(Yt,"A",{id:!0,class:!0,href:!0});var Te=h(k);mt=n(Te,"SPAN",{});var ve=h(mt);d(D.$$.fragment,ve),ve.forEach(e),Te.forEach(e),Pt=o(Yt),at=n(Yt,"SPAN",{"data-svelte-h":!0}),m(at)!=="svelte-15mb3gy"&&(at.textContent=ue),Yt.forEach(e),At=o(t),d(K.$$.fragment,t),Gt=o(t),ht=n(t,"P",{}),h(ht).forEach(e),this.h()},h(){p(j,"name","hf:doc:metadata"),p(j,"content",JSON.stringify(Ne)),p(v,"id","noisy-student-efficientnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#noisy-student-efficientnet"),p(y,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(w,"class","relative group"),p(x,"id","how-do-i-finetune-this-model"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#how-do-i-finetune-this-model"),p(J,"class","relative group"),p(C,"id","how-do-i-train-this-model"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#how-do-i-train-this-model"),p(b,"class","relative group"),p(k,"id","citation"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#citation"),p(T,"class","relative group")},m(t,s){r(document.head,j),a(t,dt,s),a(t,nt,s),a(t,ut,s),a(t,y,s),r(y,v),r(v,it),u(I,it,null),r(y,Ht),r(y,O),a(t,Mt,s),a(t,Z,s),a(t,gt,s),a(t,$,s),a(t,ft,s),a(t,N,s),a(t,jt,s),a(t,_,s),a(t,yt,s),a(t,w,s),r(w,U),r(U,ot),u(W,ot,null),r(w,zt),r(w,tt),a(t,wt,s),a(t,E,s),a(t,Jt,s),u(B,t,s),a(t,bt,s),a(t,A,s),a(t,Tt,s),u(G,t,s),a(t,vt,s),a(t,Q,s),a(t,Ut,s),u(X,t,s),a(t,xt,s),a(t,R,s),a(t,Ct,s),u(S,t,s),a(t,kt,s),a(t,V,s),a(t,It,s),a(t,Y,s),a(t,Zt,s),a(t,J,s),r(J,x),r(x,pt),u(H,pt,null),r(J,Ft),r(J,et),a(t,$t,s),a(t,z,s),a(t,Nt,s),u(F,t,s),a(t,_t,s),a(t,L,s),a(t,Wt,s),a(t,b,s),r(b,C),r(C,rt),u(P,rt,null),r(b,Lt),r(b,st),a(t,Et,s),a(t,q,s),a(t,Bt,s),a(t,T,s),r(T,k),r(k,mt),u(D,mt,null),r(T,Pt),r(T,at),a(t,At,s),u(K,t,s),a(t,Gt,s),a(t,ht,s),Qt=!0},p:xe,i(t){Qt||(M(I.$$.fragment,t),M(W.$$.fragment,t),M(B.$$.fragment,t),M(G.$$.fragment,t),M(X.$$.fragment,t),M(S.$$.fragment,t),M(H.$$.fragment,t),M(F.$$.fragment,t),M(P.$$.fragment,t),M(D.$$.fragment,t),M(K.$$.fragment,t),Qt=!0)},o(t){g(I.$$.fragment,t),g(W.$$.fragment,t),g(B.$$.fragment,t),g(G.$$.fragment,t),g(X.$$.fragment,t),g(S.$$.fragment,t),g(H.$$.fragment,t),g(F.$$.fragment,t),g(P.$$.fragment,t),g(D.$$.fragment,t),g(K.$$.fragment,t),Qt=!1},d(t){t&&(e(dt),e(nt),e(ut),e(y),e(Mt),e(Z),e(gt),e($),e(ft),e(N),e(jt),e(_),e(yt),e(w),e(wt),e(E),e(Jt),e(bt),e(A),e(Tt),e(vt),e(Q),e(Ut),e(xt),e(R),e(Ct),e(kt),e(V),e(It),e(Y),e(Zt),e(J),e($t),e(z),e(Nt),e(_t),e(L),e(Wt),e(b),e(Et),e(q),e(Bt),e(T),e(At),e(Gt),e(ht)),e(j),f(I),f(W),f(B,t),f(G,t),f(X,t),f(S,t),f(H),f(F,t),f(P),f(D),f(K,t)}}}const Ne={local:"noisy-student-efficientnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Noisy Student (EfficientNet)"};function _e(qt){return Ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ge extends ke{constructor(j){super(),Ie(this,j,_e,$e,Ue,{})}}export{Ge as component};
