import{s as on,o as pn,n as Xt}from"../chunks/scheduler.6062bdaf.js";import{S as rn,i as cn,g as o,s,r as c,A as hn,h as i,f as a,c as n,j as At,u as h,x as p,k as Vl,y as _,a as l,v as u,d as m,t as d,w as f}from"../chunks/index.4bca734e.js";import{H as b,g as un}from"../chunks/Heading.ca8c53ae.js";import{T as Bt}from"../chunks/Tip.b9ac1f03.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";function mn(T){let r,M=`Background jobs are queued when using <code>run_as_future=True</code>. This means that you are guaranteed that the jobs will be
executed in the correct order.`;return{c(){r=o("p"),r.innerHTML=M},l(g){r=i(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-wv2oxh"&&(r.innerHTML=M)},m(g,w){l(g,r,w)},p:Xt,d(g){g&&a(r)}}}function dn(T){let r,M=`<code>multi_commits</code> is still an experimental feature. Its API and behavior is subject to change in the future without prior
notice.`;return{c(){r=o("p"),r.innerHTML=M},l(g){r=i(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1hgg4xz"&&(r.innerHTML=M)},m(g,w){l(g,r,w)},p:Xt,d(g){g&&a(r)}}}function fn(T){let r,M=`For more examples of custom schedulers, check out our <a href="https://huggingface.co/spaces/Wauplin/space_to_dataset_saver" rel="nofollow">demo Space</a>
containing different implementations depending on your use cases.`;return{c(){r=o("p"),r.innerHTML=M},l(g){r=i(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-ndh47j"&&(r.innerHTML=M)},m(g,w){l(g,r,w)},p:Xt,d(g){g&&a(r)}}}function gn(T){let r,M=`This is a power-user method. Directly using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> instead of handling
the low-level logic of pre-uploading files is the way to go in the vast majority of cases. The main caveat of
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> is that until the commit is actually made, the upload files are not accessible on the repo on
the Hub. If you have a question, feel free to ping us on our Discord or in a GitHub issue.`;return{c(){r=o("p"),r.innerHTML=M},l(g){r=i(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-14lfur6"&&(r.innerHTML=M)},m(g,w){l(g,r,w)},p:Xt,d(g){g&&a(r)}}}function yn(T){let r,M="Progress bars are supported in <code>hf_transfer</code> starting from version <code>0.1.4</code>. Consider upgrading (<code>pip install -U hf-transfer</code>) if you plan to enable faster uploads.";return{c(){r=o("p"),r.innerHTML=M},l(g){r=i(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-5b8q7v"&&(r.innerHTML=M)},m(g,w){l(g,r,w)},p:Xt,d(g){g&&a(r)}}}function Mn(T){let r,M=`Although <a href="/docs/huggingface_hub/main/en/package_reference/repository#huggingface_hub.Repository">Repository()</a> is not formally deprecated, we recommend using the HTTP-based methods described above instead.
For more details about this recommendation, please have a look at <a href="../concepts/git_vs_http">this guide</a> explaining the
core differences between HTTP-based and Git-based approaches.`;return{c(){r=o("p"),r.innerHTML=M},l(g){r=i(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-nlyh1r"&&(r.innerHTML=M)},m(g,w){l(g,r,w)},p:Xt,d(g){g&&a(r)}}}function wn(T){let r,M,g,w,H,Wt,B,El="Sharing your files and work is an important aspect of the Hub. The <code>huggingface_hub</code> offers several options for uploading your files to the Hub. You can use these functions independently or integrate them into your library, making it more convenient for your users to interact with the Hub. This guide will show you how to push files:",Rt,X,Nl='<li>without using Git.</li> <li>that are very large with <a href="https://git-lfs.github.com/" rel="nofollow">Git LFS</a>.</li> <li>with the <code>commit</code> context manager.</li> <li>with the <code>push_to_hub()</code> function.</li>',St,x,ql="Whenever you want to upload files to the Hub, you need to log in to your Hugging Face account:",Lt,U,A,Ct,Ql="Log in to your Hugging Face account with the following command:",Rl,W,Sl,j,Zt,zl='Alternatively, you can programmatically login using <a href="/docs/huggingface_hub/main/en/package_reference/login#huggingface_hub.login">login()</a> in a notebook or a script:',Ll,R,Yl,Gt,Pl=`If ran in a Jupyter or Colaboratory notebook, <a href="/docs/huggingface_hub/main/en/package_reference/login#huggingface_hub.login">login()</a> will launch a widget from
which you can enter your Hugging Face access token. Otherwise, a message will be
prompted in the terminal.`,Fl,Ht,Dl=`It is also possible to login programmatically without the widget by directly passing
the token to <a href="/docs/huggingface_hub/main/en/package_reference/login#huggingface_hub.login">login()</a>. If you do so, be careful when sharing your notebook. It is
best practice to load the token from a secure vault instead of saving it in plain in
your Colaboratory notebook.`,Yt,S,Ft,L,Kl='Once you’ve created a repository with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>, you can upload a file to your repository using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>.',Vt,Y,Ol="Specify the path of the file to upload, where you want to upload the file to in the repository, and the name of the repository you want to add the file to. Depending on your repository type, you can optionally set the repository type as a <code>dataset</code>, <code>model</code>, or <code>space</code>.",Et,F,Nt,V,qt,E,es=`Use the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> function to upload a local folder to an existing repository. Specify the path of the local folder
to upload, where you want to upload the folder to in the repository, and the name of the repository you want to add the
folder to. Depending on your repository type, you can optionally set the repository type as a <code>dataset</code>, <code>model</code>, or <code>space</code>.`,Qt,N,zt,q,ts=`Use the <code>allow_patterns</code> and <code>ignore_patterns</code> arguments to specify which files to upload. These parameters accept either a single pattern or a list of patterns.
Patterns are Standard Wildcards (globbing patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>.
If both <code>allow_patterns</code> and <code>ignore_patterns</code> are provided, both constraints apply. By default, all files from the folder are uploaded.`,Pt,Q,as=`Any <code>.git/</code> folder present in any subdirectory will be ignored. However, please be aware that the <code>.gitignore</code> file is not taken into account.
This means you must use <code>allow_patterns</code> and <code>ignore_patterns</code> to specify which files to upload instead.`,Dt,z,Kt,P,ls=`You can also use the <code>delete_patterns</code> argument to specify files you want to delete from the repo in the same commit.
This can prove useful if you want to clean a remote folder before pushing files in it and you don’t know which files
already exists.`,Ot,D,ss=`The example below uploads the local <code>./logs</code> folder to the remote <code>/experiment/logs/</code> folder. Only txt files are uploaded
but before that, all previous logs on the repo on deleted. All of this in a single commit.`,ea,K,ta,O,aa,ee,ns='You can use the <code>huggingface-cli upload</code> command from the terminal to directly upload files to the Hub. Internally it uses the same <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> helpers described above.',la,te,os="You can either upload a single file or an entire folder:",sa,ae,na,le,is=`<code>local_path</code> and <code>path_in_repo</code> are optional and can be implicitly inferred. If <code>local_path</code> is not set, the tool will
check if a local folder or file has the same name as the <code>repo_id</code>. If that’s the case, its content will be uploaded.
Otherwise, an exception is raised asking the user to explicitly set <code>local_path</code>. In any case, if <code>path_in_repo</code> is not
set, files are uploaded at the root of the repo.`,oa,se,ps='For more details about the CLI upload command, please refer to the <a href="./cli#huggingface-cli-upload">CLI guide</a>.',ia,ne,pa,oe,rs=`In most cases, you won’t need more than <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> to upload your files to the Hub.
However, <code>huggingface_hub</code> has more advanced features to make things easier. Let’s have a look at them!`,ra,ie,ca,pe,cs=`In some cases, you want to push data without blocking your main thread. This is particularly useful to upload logs and
artifacts while continuing a training. To do so, you can use the <code>run_as_future</code> argument in both <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>. This will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow"><code>concurrent.futures.Future</code></a>
object that you can use to check the status of the upload.`,ha,re,ua,$,ma,ce,hs=`Even though background jobs are mostly useful to upload data/create commits, you can queue any method you like using
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_as_future">run_as_future()</a>. For instance, you can use it to create a repo and then upload data to it in the background. The
built-in <code>run_as_future</code> argument in upload methods is just an alias around it.`,da,he,fa,ue,ga,me,us=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> makes it easy to upload an entire folder to the Hub. However, for large folders (thousands of files or
hundreds of GB), it can still be challenging. If you have a folder with a lot of files, you might want to upload
it in several commits. If you experience an error or a connection issue during the upload, you would not have to resume
the process from the beginning.`,ya,de,ms=`To upload a folder in multiple commits, just pass <code>multi_commits=True</code> as argument. Under the hood, <code>huggingface_hub</code>
will list the files to upload/delete and split them in several commits. The “strategy” (i.e. how to split the commits)
is based on the number and size of the files to upload. A PR is open on the Hub to push all the commits. Once the PR is
ready, the commits are squashed into a single commit. If the process is interrupted before completing, you can rerun
your script to resume the upload. The created PR will be automatically detected and the upload will resume from where
it stopped. It is recommended to pass <code>multi_commits_verbose=True</code> to get a better understanding of the upload and its
progress.`,Ma,fe,ds=`The example below will upload the checkpoints folder to a dataset in multiple commits. A PR will be created on the Hub
and merged automatically once the upload is complete. If you prefer the PR to stay open and review it manually, you can
pass <code>create_pr=True</code>.`,wa,ge,ba,ye,fs=`If you want a better control on the upload strategy (i.e. the commits that are created), you can have a look at the
low-level <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.plan_multi_commits">plan_multi_commits()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commits_on_pr">create_commits_on_pr()</a> methods.`,Ta,v,_a,Me,ja,we,gs=`The Hugging Face Hub makes it easy to save and version data. However, there are some limitations when updating the same file thousands of times. For instance, you might want to save logs of a training process or user
feedback on a deployed Space. In these cases, uploading the data as a dataset on the Hub makes sense, but it can be hard to do properly. The main reason is that you don’t want to version every update of your data because it’ll make the git repository unusable. The <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> class offers a solution to this problem.`,Ja,be,ys=`The idea is to run a background job that regularly pushes a local folder to the Hub. Let’s assume you have a
Gradio Space that takes as input some text and generates two translations of it. Then, the user can select their preferred translation. For each run, you want to save the input, output, and user preference to analyze the results. This is a
perfect use case for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>; you want to save data to the Hub (potentially millions of user feedback), but
you don’t <em>need</em> to save in real-time each user’s input. Instead, you can save the data locally in a JSON file and
upload it every 10 minutes. For example:`,Ua,Te,$a,_e,Ms=`And that’s it! User input/outputs and feedback will be available as a dataset on the Hub. By using a unique JSON file name, you are guaranteed you won’t overwrite data from a previous run or data from another
Spaces/replicas pushing concurrently to the same repository.`,va,je,ws='For more details about the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>, here is what you need to know:',ka,Je,bs=`<li><strong>append-only:</strong>
It is assumed that you will only add content to the folder. You must only append data to existing files or create
new files. Deleting or overwriting a file might corrupt your repository.</li> <li><strong>git history</strong>:
The scheduler will commit the folder every <code>every</code> minutes. To avoid polluting the git repository too much, it is
recommended to set a minimal value of 5 minutes. Besides, the scheduler is designed to avoid empty commits. If no
new content is detected in the folder, the scheduled commit is dropped.</li> <li><strong>errors:</strong>
The scheduler run as background thread. It is started when you instantiate the class and never stops. In particular,
if an error occurs during the upload (example: connection issue), the scheduler will silently ignore it and retry
at the next scheduled commit.</li> <li><strong>thread-safety:</strong>
In most cases it is safe to assume that you can write to a file without having to worry about a lock file. The
scheduler will not crash or be corrupted if you write content to the folder while it’s uploading. In practice,
<em>it is possible</em> that concurrency issues happen for heavy-loaded apps. In this case, we advice to use the
<code>scheduler.lock</code> lock to ensure thread-safety. The lock is blocked only when the scheduler scans the folder for
changes, not when it uploads data. You can safely assume that it will not affect the user experience on your Space.</li>`,Ia,Ue,Ca,$e,Ts=`Persisting data from a Space to a Dataset on the Hub is the main use case for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>. Depending on the use
case, you might want to structure your data differently. The structure has to be robust to concurrent users and
restarts which often implies generating UUIDs. Besides robustness, you should upload data in a format readable by the 🤗 Datasets library for later reuse. We created a <a href="https://huggingface.co/spaces/Wauplin/space_to_dataset_saver" rel="nofollow">Space</a>
that demonstrates how to save several different data formats (you may need to adapt it for your own specific needs).`,Za,ve,Ga,ke,_s=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> assumes your data is append-only and should be uploading “as is”. However, you
might want to customize the way data is uploaded. You can do that by creating a class inheriting from <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>
and overwrite the <code>push_to_hub</code> method (feel free to overwrite it any way you want). You are guaranteed it will
be called every <code>every</code> minutes in a background thread. You don’t have to worry about concurrency and errors but you
must be careful about other aspects, such as pushing empty commits or duplicated data.`,Ha,Ie,js=`In the (simplified) example below, we overwrite <code>push_to_hub</code> to zip all PNG files in a single archive to avoid
overloading the repo on the Hub:`,Ba,Ce,Xa,Ze,Js='When you overwrite <code>push_to_hub</code>, you have access to the attributes of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> and especially:',xa,Ge,Us='<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> client: <code>api</code></li> <li>Folder parameters: <code>folder_path</code> and <code>path_in_repo</code></li> <li>Repo parameters: <code>repo_id</code>, <code>repo_type</code>, <code>revision</code></li> <li>The thread lock: <code>lock</code></li>',Aa,k,Wa,He,Ra,Be,$s=`The <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> functions are high-level APIs that are generally convenient to use. We recommend
trying these functions first if you don’t need to work at a lower level. However, if you want to work at a commit-level,
you can use the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> function directly.`,Sa,Xe,vs='There are three types of operations supported by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>:',La,xe,ks='<li><p><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> uploads a file to the Hub. If the file already exists, the file contents are overwritten. This operation accepts two arguments:</p> <ul><li><code>path_in_repo</code>: the repository path to upload a file to.</li> <li><code>path_or_fileobj</code>: either a path to a file on your filesystem or a file-like object. This is the content of the file to upload to the Hub.</li></ul></li> <li><p><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> removes a file or a folder from a repository. This operation accepts <code>path_in_repo</code> as an argument.</p></li> <li><p><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> copies a file within a repository. This operation accepts three arguments:</p> <ul><li><code>src_path_in_repo</code>: the repository path of the file to copy.</li> <li><code>path_in_repo</code>: the repository path where the file should be copied.</li> <li><code>src_revision</code>: optional - the revision of the file to copy if your want to copy a file from a different branch/revision.</li></ul></li>',Ya,Ae,Is="For example, if you want to upload two files and delete a file in a Hub repository:",Fa,We,Cs="<li>Use the appropriate <code>CommitOperation</code> to add or delete a file and to delete a folder:</li>",Va,Re,Ea,I,Zs='<li>Pass your operations to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>:</li>',Na,Se,qa,Le,Gs='In addition to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>, the following functions also use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> under the hood:',Qa,Ye,Hs='<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a> deletes a single file from a repository on the Hub.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a> deletes an entire folder from a repository on the Hub.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.metadata_update">metadata_update()</a> updates a repository’s metadata.</li>',za,Fe,Bs='For more detailed information, take a look at the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> reference.',Pa,Ve,Da,Ee,Xs=`In some cases, you might want to upload huge files to S3 <strong>before</strong> making the commit call. For example, if you are
committing a dataset in several shards that are generated in-memory, you would need to upload the shards one by one
to avoid an out-of-memory issue. A solution is to upload each shard as a separate commit on the repo. While being
perfectly valid, this solution has the drawback of potentially messing the git history by generating tens of commits.
To overcome this issue, you can upload your files one by one to S3 and then create a single commit at the end. This
is possible using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> in combination with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>.`,Ka,C,Oa,Ne,xs="Here is a simple example illustrating how to pre-upload files:",el,qe,tl,Qe,As=`First, we create the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> objects one by one. In a real-world example, those would contain the
generated shards. Each file is uploaded before generating the next one. During the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> step, <strong>the
<code>CommitOperationAdd</code> object is mutated</strong>. You should only use it to pass it directly to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. The main
update of the object is that <strong>the binary content is removed</strong> from it, meaning that it will be garbage-collected if
you don’t store another reference to it. This is expected as we don’t want to keep in memory the content that is
already uploaded. Finally we create the commit by passing all the operations to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. You can pass
additional operations (add, delete or copy) that have not been processed yet and they will be handled correctly.`,al,ze,ll,Pe,Ws=`There are some limitations to be aware of when dealing with a large amount of data in your repo. Given the time it takes to stream the data,
getting an upload/push to fail at the end of the process or encountering a degraded experience, be it on hf.co or when working locally, can be very annoying.`,sl,De,Rs='Check out our <a href="https://huggingface.co/docs/hub/repositories-recommendations" rel="nofollow">Repository limitations and recommendations</a> guide for best practices on how to structure your repositories on the Hub. Next, let’s move on with some practical tips to make your upload process as smooth as possible.',nl,Ke,Ss=`<li><strong>Start small</strong>: We recommend starting with a small amount of data to test your upload script. It’s easier to iterate
on a script when failing takes only a little time.</li> <li><strong>Expect failures</strong>: Streaming large amounts of data is challenging. You don’t know what can happen, but it’s always
best to consider that something will fail at least once -no matter if it’s due to your machine, your connection, or our
servers. For example, if you plan to upload a large number of files, it’s best to keep track locally of which files you
already uploaded before uploading the next batch. You are ensured that an LFS file that is already committed will never
be re-uploaded twice but checking it client-side can still save some time.</li> <li><strong>Use <code>hf_transfer</code></strong>: this is a Rust-based <a href="https://github.com/huggingface/hf_transfer" rel="nofollow">library</a> meant to speed up
uploads on machines with very high bandwidth. To use it, you must install it (<code>pip install hf_transfer</code>) and enable it
by setting <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> as an environment variable. You can then use <code>huggingface_hub</code> normally.
Disclaimer: this is a power user tool. It is tested and production-ready but lacks user-friendly features like advanced error handling or proxies. For more details, please refer to this <a href="https://huggingface.co/docs/huggingface_hub/hf_transfer" rel="nofollow">section</a>.</li>`,ol,Z,il,Oe,pl,et,Ls=`All the methods described above use the Hub’s API to upload files. This is the recommended way to upload files to the Hub.
However, we also provide <a href="/docs/huggingface_hub/main/en/package_reference/repository#huggingface_hub.Repository">Repository()</a>, a wrapper around the git tool to manage a local repository.`,rl,G,cl,tt,Ys="Git LFS automatically handles files larger than 10MB. But for very large files (>5GB), you need to install a custom transfer agent for Git LFS:",hl,at,ul,lt,Fs="You should install this for each repository that has a very large file. Once installed, you’ll be able to push files larger than 5GB.",ml,st,dl,nt,Vs="The <code>commit</code> context manager handles four of the most common Git commands: pull, add, commit, and push. <code>git-lfs</code> automatically tracks any file larger than 10MB. In the following example, the <code>commit</code> context manager:",fl,ot,Es="<li>Pulls from the <code>text-files</code> repository.</li> <li>Adds a change made to <code>file.txt</code>.</li> <li>Commits the change.</li> <li>Pushes the change to the <code>text-files</code> repository.</li>",gl,it,yl,pt,Ns="Here is another example of how to use the <code>commit</code> context manager to save and upload a file to a repository:",Ml,rt,wl,ct,qs="Set <code>blocking=False</code> if you would like to push your commits asynchronously. Non-blocking behavior is helpful when you want to continue running your script while your commits are being pushed.",bl,ht,Tl,ut,Qs="You can check the status of your push with the <code>command_queue</code> method:",_l,mt,jl,dt,zs="Refer to the table below for the possible statuses:",Jl,ft,Ps="<thead><tr><th>Status</th> <th>Description</th></tr></thead> <tbody><tr><td>-1</td> <td>The push is ongoing.</td></tr> <tr><td>0</td> <td>The push has completed successfully.</td></tr> <tr><td>Non-zero</td> <td>An error has occurred.</td></tr></tbody>",Ul,gt,Ds="When <code>blocking=False</code>, commands are tracked, and your script will only exit when all pushes are completed, even if other errors occur in your script. Some additional useful commands for checking the status of a push include:",$l,yt,vl,Mt,kl,wt,Ks='The <a href="/docs/huggingface_hub/main/en/package_reference/repository#huggingface_hub.Repository">Repository()</a> class has a <code>push_to_hub()</code> function to add files, make a commit, and push them to a repository. Unlike the <code>commit</code> context manager, you’ll need to pull from a repository first before calling <code>push_to_hub()</code>.',Il,bt,Os="For example, if you’ve already cloned a repository from the Hub, then you can initialize the <code>repo</code> from the local directory:",Cl,Tt,Zl,_t,en="Update your local clone with <code>git_pull()</code> and then push your file to the Hub:",Gl,jt,Hl,Jt,tn="However, if you aren’t ready to push a file yet, you can use <code>git_add()</code> and <code>git_commit()</code> to only add and commit your file:",Bl,Ut,Xl,$t,an="When you’re ready, push the file to your repository with <code>git_push()</code>:",xl,vt,Al,xt,Wl;return H=new b({props:{title:"Upload files to the Hub",local:"upload-files-to-the-hub",headingTag:"h1"}}),W=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMEElMjMlMjBvciUyMHVzaW5nJTIwYW4lMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTBBaHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMjAtLXRva2VuJTIwJTI0SFVHR0lOR0ZBQ0VfVE9LRU4=",highlighted:`huggingface-cli login
<span class="hljs-comment"># or using an environment variable</span>
huggingface-cli login --token <span class="hljs-variable">$HUGGINGFACE_TOKEN</span>`,wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-meta">&gt;&gt;&gt; </span>login()`,wrap:!1}}),S=new b({props:{title:"Upload a file",local:"upload-a-file",headingTag:"h2"}}),F=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyRlJFQURNRS5tZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMlJFQURNRS5tZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnRlc3QtZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;/path/to/local/folder/README.md&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/test-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),V=new b({props:{title:"Upload a folder",local:"upload-a-folder",headingTag:"h2"}}),N=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyJTJGcGF0aCUyRnRvJTJGbG9jYWwlMkZzcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LWNvb2wtc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Upload all the content from the local folder to your remote Space.</span>
<span class="hljs-comment"># By default, files are uploaded at the root of the repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/space&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-cool-space&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),z=new y({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMm15LWRhdGFzZXQlMkZ0cmFpbiUyMiUyQyUyMCUyMyUyMFVwbG9hZCUyMHRvJTIwYSUyMHNwZWNpZmljJTIwZm9sZGVyJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGdGVzdC1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9wYXR0ZXJucyUzRCUyMioqJTJGbG9ncyUyRioudHh0JTIyJTJDJTIwJTIzJTIwSWdub3JlJTIwYWxsJTIwdGV4dCUyMGxvZ3MlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/folder&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;my-dataset/train&quot;</span>, <span class="hljs-comment"># Upload to a specific folder</span>
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/test-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>, <span class="hljs-comment"># Ignore all text logs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new y({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyRmxvZ3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZ0cmFpbmVkLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIyZXhwZXJpbWVudCUyRmxvZ3MlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19wYXR0ZXJucyUzRCUyMioudHh0JTIyJTJDJTIwJTIzJTIwVXBsb2FkJTIwYWxsJTIwbG9jYWwlMjB0ZXh0JTIwZmlsZXMlMEElMjAlMjAlMjAlMjBkZWxldGVfcGF0dGVybnMlM0QlMjIqLnR4dCUyMiUyQyUyMCUyMyUyMERlbGV0ZSUyMGFsbCUyMHJlbW90ZSUyMHRleHQlMjBmaWxlcyUyMGJlZm9yZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/folder/logs&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/trained-model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;experiment/logs/&quot;</span>,
<span class="hljs-meta">... </span>    allow_patterns=<span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-comment"># Upload all local text files</span>
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-comment"># Delete all remote text files before</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new b({props:{title:"Upload from the CLI",local:"upload-from-the-cli",headingTag:"h2"}}),ae=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwdXBsb2FkJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjAuJTJGbW9kZWxzJTJGbW9kZWwuc2FmZXRlbnNvcnMlMjBtb2RlbC5zYWZldGVuc29ycyUwQSUwQWh1Z2dpbmdmYWNlLWNsaSUyMHVwbG9hZCUyMFdhdXBsaW4lMkZteS1jb29sLW1vZGVsJTIwLiUyRm1vZGVscyUyMC4=",highlighted:`<span class="hljs-comment"># Usage:  huggingface-cli upload [repo_id] [local_path] [path_in_repo]</span>
&gt;&gt;&gt; huggingface-cli upload Wauplin/my-cool-model ./models/model.safetensors model.safetensors
https://huggingface.co/Wauplin/my-cool-model/blob/main/model.safetensors

&gt;&gt;&gt; huggingface-cli upload Wauplin/my-cool-model ./models .
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),ne=new b({props:{title:"Advanced features",local:"advanced-features",headingTag:"h2"}}),ie=new b({props:{title:"Non-blocking uploads",local:"non-blocking-uploads",headingTag:"h3"}}),re=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS51cGxvYWRfZm9sZGVyKCUyMCUyMyUyMFVwbG9hZCUyMGluJTIwdGhlJTIwYmFja2dyb3VuZCUyMChub24tYmxvY2tpbmclMjBhY3Rpb24pJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmNoZWNrcG9pbnRzLTAwMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJ1bl9hc19mdXR1cmUlM0RUcnVlJTJDJTBBKSUwQWZ1dHVyZSUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjBXYWl0JTIwZm9yJTIwdGhlJTIwdXBsb2FkJTIwdG8lMjBjb21wbGV0ZSUyMChibG9ja2luZyUyMGFjdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.upload_folder( <span class="hljs-comment"># Upload in the background (non-blocking action)</span>
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;checkpoints-001&quot;</span>,
<span class="hljs-meta">... </span>    run_as_future=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>future
Future(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># Wait for the upload to complete (blocking action)</span>
...`,wrap:!1}}),$=new Bt({props:{$$slots:{default:[mn]},$$scope:{ctx:T}}}),he=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5ydW5fYXNfZnV0dXJlKGFwaS5jcmVhdGVfcmVwbyUyQyUyMCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMjBleGlzdHNfb2slM0RUcnVlKSUwQWFwaS51cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMmZpbGUudHh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEYiUyMmZpbGUlMjBjb250ZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwcnVuX2FzX2Z1dHVyZSUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.run_as_future(api.create_repo, <span class="hljs-string">&quot;username/my-model&quot;</span>, exists_ok=<span class="hljs-literal">True</span>)
Future(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>,
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">b&quot;file content&quot;</span>,
<span class="hljs-meta">... </span>    run_as_future=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
Future(...)`,wrap:!1}}),ue=new b({props:{title:"Upload a folder by chunks",local:"upload-a-folder-by-chunks",headingTag:"h3"}}),ge=new y({props:{code:"dXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMG11bHRpX2NvbW1pdHMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbXVsdGlfY29tbWl0c192ZXJib3NlJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    multi_commits=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    multi_commits_verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),v=new Bt({props:{warning:!0,$$slots:{default:[dn]},$$scope:{ctx:T}}}),Me=new b({props:{title:"Scheduled uploads",local:"scheduled-uploads",headingTag:"h3"}}),Te=new y({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHV1aWQlMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWZlZWRiYWNrX2ZpbGUlMjAlM0QlMjBQYXRoKCUyMnVzZXJfZmVlZGJhY2slMkYlMjIpJTIwJTJGJTIwZiUyMmRhdGFfJTdCdXVpZC51dWlkNCgpJTdELmpzb24lMjIlMEFmZWVkYmFja19mb2xkZXIlMjAlM0QlMjBmZWVkYmFja19maWxlLnBhcmVudCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMENvbW1pdFNjaGVkdWxlciglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIycmVwb3J0LXRyYW5zbGF0aW9uLWZlZWRiYWNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEZmVlZGJhY2tfZm9sZGVyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIyZGF0YSUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2ZXJ5JTNEMTAlMkMlMEEpJTBBJTBBZGVmJTIwc2F2ZV9mZWVkYmFjayhpbnB1dF90ZXh0JTNBc3RyJTJDJTIwb3V0cHV0XzElM0ElMjBzdHIlMkMlMjBvdXRwdXRfMiUzQXN0ciUyQyUyMHVzZXJfY2hvaWNlJTNBJTIwaW50KSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQXBwZW5kJTIwaW5wdXQlMkZvdXRwdXRzJTIwYW5kJTIwdXNlciUyMGZlZWRiYWNrJTIwdG8lMjBhJTIwSlNPTiUyMExpbmVzJTIwZmlsZSUyMHVzaW5nJTIwYSUyMHRocmVhZCUyMGxvY2slMjB0byUyMGF2b2lkJTIwY29uY3VycmVudCUyMHdyaXRlcyUyMGZyb20lMjBkaWZmZXJlbnQlMjB1c2Vycy4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwc2NoZWR1bGVyLmxvY2slM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwZmVlZGJhY2tfZmlsZS5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKCU3QiUyMmlucHV0JTIyJTNBJTIwaW5wdXRfdGV4dCUyQyUyMCUyMm91dHB1dF8xJTIyJTNBJTIwb3V0cHV0XzElMkMlMjAlMjJvdXRwdXRfMiUyMiUzQSUyMG91dHB1dF8yJTJDJTIwJTIydXNlcl9jaG9pY2UlMjIlM0ElMjB1c2VyX2Nob2ljZSU3RCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZSglMjIlNUNuJTIyKSUwQSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwZGVtbyUzQSUwQSUyMCUyMCUyMCUyMC4uLiUyMCUyMyUyMGRlZmluZSUyMEdyYWRpbyUyMGRlbW8lMjAlMkIlMjB1c2UlMjAlNjBzYXZlX2ZlZWRiYWNrJTYwJTBBZGVtby5sYXVuY2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> uuid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Define the file where to save the data. Use UUID to make sure not to overwrite existing data from a previous run.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feedback_file = Path(<span class="hljs-string">&quot;user_feedback/&quot;</span>) / <span class="hljs-string">f&quot;data_<span class="hljs-subst">{uuid.uuid4()}</span>.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feedback_folder = feedback_file.parent

<span class="hljs-comment"># Schedule regular uploads. Remote repo and local folder are created if they don&#x27;t already exist.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = CommitScheduler(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;report-translation-feedback&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=feedback_folder,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;data&quot;</span>,
<span class="hljs-meta">... </span>    every=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Define the function that will be called when the user submits its feedback (to be called in Gradio)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_feedback</span>(<span class="hljs-params">input_text:<span class="hljs-built_in">str</span>, output_1: <span class="hljs-built_in">str</span>, output_2:<span class="hljs-built_in">str</span>, user_choice: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Append input/outputs and user feedback to a JSON Lines file using a thread lock to avoid concurrent writes from different users.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> scheduler.lock:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> feedback_file.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>            f.write(json.dumps({<span class="hljs-string">&quot;input&quot;</span>: input_text, <span class="hljs-string">&quot;output_1&quot;</span>: output_1, <span class="hljs-string">&quot;output_2&quot;</span>: output_2, <span class="hljs-string">&quot;user_choice&quot;</span>: user_choice}))
<span class="hljs-meta">... </span>            f.write(<span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-comment"># Start Gradio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
<span class="hljs-meta">&gt;&gt;&gt; </span>    ... <span class="hljs-comment"># define Gradio demo + use \`save_feedback\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>demo.launch()`,wrap:!1}}),Ue=new b({props:{title:"Space persistence demo",local:"space-persistence-demo",headingTag:"h4"}}),ve=new b({props:{title:"Custom uploads",local:"custom-uploads",headingTag:"h4"}}),Ce=new y({props:{code:"Y2xhc3MlMjBaaXBTY2hlZHVsZXIoQ29tbWl0U2NoZWR1bGVyKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHB1c2hfdG9faHViKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwMS4lMjBMaXN0JTIwUE5HJTIwZmlsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbmdfZmlsZXMlMjAlM0QlMjBsaXN0KHNlbGYuZm9sZGVyX3BhdGguZ2xvYiglMjIqLnBuZyUyMikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4ocG5nX2ZpbGVzKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTIwJTIwJTIzJTIwcmV0dXJuJTIwZWFybHklMjBpZiUyMG5vdGhpbmclMjB0byUyMGNvbW1pdCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDIuJTIwWmlwJTIwcG5nJTIwZmlsZXMlMjBpbiUyMGElMjBzaW5nbGUlMjBhcmNoaXZlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlX3BhdGglMjAlM0QlMjBQYXRoKHRtcGRpciklMjAlMkYlMjAlMjJ0cmFpbi56aXAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwemlwZmlsZS5aaXBGaWxlKGFyY2hpdmVfcGF0aCUyQyUyMCUyMnclMjIlMkMlMjB6aXBmaWxlLlpJUF9ERUZMQVRFRCklMjBhcyUyMHppcCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBuZ19maWxlJTIwaW4lMjBwbmdfZmlsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB6aXAud3JpdGUoZmlsZW5hbWUlM0RwbmdfZmlsZSUyQyUyMGFyY25hbWUlM0RwbmdfZmlsZS5uYW1lKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDMuJTIwVXBsb2FkJTIwYXJjaGl2ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYXBpLnVwbG9hZF9maWxlKC4uLiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGFyY2hpdmVfcGF0aCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjA0LiUyMERlbGV0ZSUyMGxvY2FsJTIwcG5nJTIwZmlsZXMlMjB0byUyMGF2b2lkJTIwcmUtdXBsb2FkaW5nJTIwdGhlbSUyMGxhdGVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwcG5nX2ZpbGUlMjBpbiUyMHBuZ19maWxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBuZ19maWxlLnVubGluaygp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ZipScheduler</span>(<span class="hljs-title class_ inherited__">CommitScheduler</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># 1. List PNG files</span>
          png_files = <span class="hljs-built_in">list</span>(self.folder_path.glob(<span class="hljs-string">&quot;*.png&quot;</span>))
          <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(png_files) == <span class="hljs-number">0</span>:
              <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>  <span class="hljs-comment"># return early if nothing to commit</span>

        <span class="hljs-comment"># 2. Zip png files in a single archive</span>
        <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
            archive_path = Path(tmpdir) / <span class="hljs-string">&quot;train.zip&quot;</span>
            <span class="hljs-keyword">with</span> zipfile.ZipFile(archive_path, <span class="hljs-string">&quot;w&quot;</span>, zipfile.ZIP_DEFLATED) <span class="hljs-keyword">as</span> <span class="hljs-built_in">zip</span>:
                <span class="hljs-keyword">for</span> png_file <span class="hljs-keyword">in</span> png_files:
                    <span class="hljs-built_in">zip</span>.write(filename=png_file, arcname=png_file.name)

            <span class="hljs-comment"># 3. Upload archive</span>
            self.api.upload_file(..., path_or_fileobj=archive_path)

        <span class="hljs-comment"># 4. Delete local png files to avoid re-uploading them later</span>
        <span class="hljs-keyword">for</span> png_file <span class="hljs-keyword">in</span> png_files:
            png_file.unlink()`,wrap:!1}}),k=new Bt({props:{$$slots:{default:[fn]},$$scope:{ctx:T}}}),He=new b({props:{title:"create_commit",local:"createcommit",headingTag:"h3"}}),Re=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwQ29tbWl0T3BlcmF0aW9uQWRkJTJDJTIwQ29tbWl0T3BlcmF0aW9uRGVsZXRlJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQW9wZXJhdGlvbnMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25BZGQocGF0aF9pbl9yZXBvJTNEJTIyTElDRU5TRS5tZCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRCUyMn4lMkZyZXBvJTJGTElDRU5TRS5tZCUyMiklMkMlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25BZGQocGF0aF9pbl9yZXBvJTNEJTIyd2VpZ2h0cy5oNSUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRCUyMn4lMkZyZXBvJTJGd2VpZ2h0cy1maW5hbC5oNSUyMiklMkMlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25EZWxldGUocGF0aF9pbl9yZXBvJTNEJTIyb2xkLXdlaWdodHMuaDUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwQ29tbWl0T3BlcmF0aW9uRGVsZXRlKHBhdGhfaW5fcmVwbyUzRCUyMmxvZ3MlMkYlMjIpJTJDJTBBJTIwJTIwJTIwJTIwQ29tbWl0T3BlcmF0aW9uQ29weShzcmNfcGF0aF9pbl9yZXBvJTNEJTIyaW1hZ2UucG5nJTIyJTJDJTIwcGF0aF9pbl9yZXBvJTNEJTIyZHVwbGljYXRlX2ltYWdlLnBuZyUyMiklMkMlMEElNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, CommitOperationAdd, CommitOperationDelete
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [
<span class="hljs-meta">... </span>    CommitOperationAdd(path_in_repo=<span class="hljs-string">&quot;LICENSE.md&quot;</span>, path_or_fileobj=<span class="hljs-string">&quot;~/repo/LICENSE.md&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationAdd(path_in_repo=<span class="hljs-string">&quot;weights.h5&quot;</span>, path_or_fileobj=<span class="hljs-string">&quot;~/repo/weights-final.h5&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationDelete(path_in_repo=<span class="hljs-string">&quot;old-weights.h5&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationDelete(path_in_repo=<span class="hljs-string">&quot;logs/&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationCopy(src_path_in_repo=<span class="hljs-string">&quot;image.png&quot;</span>, path_in_repo=<span class="hljs-string">&quot;duplicate_image.png&quot;</span>),
<span class="hljs-meta">... </span>]`,wrap:!1}}),Se=new y({props:{code:"YXBpLmNyZWF0ZV9jb21taXQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGdGVzdC1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJVcGxvYWQlMjBteSUyMG1vZGVsJTIwd2VpZ2h0cyUyMGFuZCUyMGxpY2Vuc2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_commit(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>,
<span class="hljs-meta">... </span>    operations=operations,
<span class="hljs-meta">... </span>    commit_message=<span class="hljs-string">&quot;Upload my model weights and license&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ve=new b({props:{title:"Preupload LFS files before commit",local:"preupload-lfs-files-before-commit",headingTag:"h3"}}),C=new Bt({props:{warning:!0,$$slots:{default:[gn]},$$scope:{ctx:T}}}),qe=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdE9wZXJhdGlvbkFkZCUyQyUyMHByZXVwbG9hZF9sZnNfZmlsZXMlMkMlMjBjcmVhdGVfY29tbWl0JTJDJTIwY3JlYXRlX3JlcG8lMEElMEFyZXBvX2lkJTIwJTNEJTIwY3JlYXRlX3JlcG8oJTIydGVzdF9wcmV1cGxvYWQlMjIpLnJlcG9faWQlMEElMEFvcGVyYXRpb25zJTIwJTNEJTIwJTVCJTVEJTIwJTIzJTIwTGlzdCUyMG9mJTIwYWxsJTIwJTYwQ29tbWl0T3BlcmF0aW9uQWRkJTYwJTIwb2JqZWN0cyUyMHRoYXQlMjB3aWxsJTIwYmUlMjBnZW5lcmF0ZWQlMEFmb3IlMjBpJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlMjAlM0QlMjAuLi4lMjAlMjMlMjBnZW5lcmF0ZSUyMGJpbmFyeSUyMGNvbnRlbnQlMEElMjAlMjAlMjAlMjBhZGRpdGlvbiUyMCUzRCUyMENvbW1pdE9wZXJhdGlvbkFkZChwYXRoX2luX3JlcG8lM0RmJTIyc2hhcmRfJTdCaSU3RF9vZl81LmJpbiUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGNvbnRlbnQpJTBBJTIwJTIwJTIwJTIwcHJldXBsb2FkX2xmc19maWxlcyhyZXBvX2lkJTJDJTIwYWRkaXRpb25zJTNEJTVCYWRkaXRpb24lNUQpJTBBJTIwJTIwJTIwJTIwb3BlcmF0aW9ucy5hcHBlbmQoYWRkaXRpb24pJTBBJTBBJTIzJTIwQ3JlYXRlJTIwY29tbWl0JTBBY3JlYXRlX2NvbW1pdChyZXBvX2lkJTJDJTIwb3BlcmF0aW9ucyUzRG9wZXJhdGlvbnMlMkMlMjBjb21taXRfbWVzc2FnZSUzRCUyMkNvbW1pdCUyMGFsbCUyMHNoYXJkcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd, preupload_lfs_files, create_commit, create_repo

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = create_repo(<span class="hljs-string">&quot;test_preupload&quot;</span>).repo_id

<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [] <span class="hljs-comment"># List of all \`CommitOperationAdd\` objects that will be generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
<span class="hljs-meta">... </span>    content = ... <span class="hljs-comment"># generate binary content</span>
<span class="hljs-meta">... </span>    addition = CommitOperationAdd(path_in_repo=<span class="hljs-string">f&quot;shard_<span class="hljs-subst">{i}</span>_of_5.bin&quot;</span>, path_or_fileobj=content)
<span class="hljs-meta">... </span>    preupload_lfs_files(repo_id, additions=[addition])
<span class="hljs-meta">... </span>    operations.append(addition)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_commit(repo_id, operations=operations, commit_message=<span class="hljs-string">&quot;Commit all shards&quot;</span>)`,wrap:!1}}),ze=new b({props:{title:"Tips and tricks for large uploads",local:"tips-and-tricks-for-large-uploads",headingTag:"h2"}}),Z=new Bt({props:{$$slots:{default:[yn]},$$scope:{ctx:T}}}),Oe=new b({props:{title:"(legacy) Upload files with Git LFS",local:"legacy-upload-files-with-git-lfs",headingTag:"h2"}}),G=new Bt({props:{warning:!0,$$slots:{default:[Mn]},$$scope:{ctx:T}}}),at=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbGZzLWVuYWJsZS1sYXJnZWZpbGVz",highlighted:"huggingface-cli lfs-enable-largefiles",wrap:!1}}),st=new b({props:{title:"commit context manager",local:"commit-context-manager",headingTag:"h3"}}),it=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEF3aXRoJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJ0ZXh0LWZpbGVzJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMiUzQ3VzZXIlM0UlMkZ0ZXh0LWZpbGVzJTIyKS5jb21taXQoY29tbWl0X21lc3NhZ2UlM0QlMjJNeSUyMGZpcnN0JTIwZmlsZSUyMCUzQSklMjIpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oJTIyZmlsZS50eHQlMjIlMkMlMjAlMjJ3JTJCJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYud3JpdGUoanNvbi5kdW1wcyglN0IlMjJoZXklMjIlM0ElMjA4JTdEKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(local_dir=<span class="hljs-string">&quot;text-files&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/text-files&quot;</span>).commit(commit_message=<span class="hljs-string">&quot;My first file :)&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;file.txt&quot;</span>, <span class="hljs-string">&quot;w+&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(json.dumps({<span class="hljs-string">&quot;hey&quot;</span>: <span class="hljs-number">8</span>}))`,wrap:!1}}),rt=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFtb2RlbCUyMCUzRCUyMHRvcmNoLm5uLlRyYW5zZm9ybWVyKCklMEF3aXRoJTIwUmVwb3NpdG9yeSglMjJ0b3JjaC1tb2RlbCUyMiUyQyUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGdG9yY2gtbW9kZWwlMjIlMkMlMjB0b2tlbiUzRFRydWUpLmNvbW1pdChjb21taXRfbWVzc2FnZSUzRCUyMk15JTIwY29vbCUyMG1vZGVsJTIwJTNBKSUyMiklM0ElMEElMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMm1vZGVsLnB0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.nn.Transformer()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(<span class="hljs-string">&quot;torch-model&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/torch-model&quot;</span>, token=<span class="hljs-literal">True</span>).commit(commit_message=<span class="hljs-string">&quot;My cool model :)&quot;</span>):
<span class="hljs-meta">... </span>    torch.save(model.state_dict(), <span class="hljs-string">&quot;model.pt&quot;</span>)`,wrap:!1}}),ht=new y({props:{code:"d2l0aCUyMHJlcG8uY29tbWl0KGNvbW1pdF9tZXNzYWdlJTNEJTIyTXklMjBjb29sJTIwbW9kZWwlMjAlM0EpJTIyJTJDJTIwYmxvY2tpbmclM0RGYWxzZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> repo.commit(commit_message=<span class="hljs-string">&quot;My cool model :)&quot;</span>, blocking=<span class="hljs-literal">False</span>)',wrap:!1}}),mt=new y({props:{code:"bGFzdF9jb21tYW5kJTIwJTNEJTIwcmVwby5jb21tYW5kX3F1ZXVlJTVCLTElNUQlMEFsYXN0X2NvbW1hbmQuc3RhdHVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>last_command = repo.command_queue[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.status`,wrap:!1}}),yt=new y({props:{code:"bGFzdF9jb21tYW5kLnN0ZGVyciUwQSUwQWxhc3RfY29tbWFuZC5pc19kb25lJTBBJTBBbGFzdF9jb21tYW5kLmZhaWxlZA==",highlighted:`<span class="hljs-comment"># Inspect an error.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.stderr

<span class="hljs-comment"># Check whether a push is completed or ongoing.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.is_done

<span class="hljs-comment"># Check whether a push command has errored.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.failed`,wrap:!1}}),Mt=new b({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),Tt=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJwYXRoJTJGdG8lMkZsb2NhbCUyRnJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;path/to/local/repo&quot;</span>)`,wrap:!1}}),jt=new y({props:{code:"cmVwby5naXRfcHVsbCgpJTBBcmVwby5wdXNoX3RvX2h1Yihjb21taXRfbWVzc2FnZSUzRCUyMkNvbW1pdCUyMG15LWF3ZXNvbWUtZmlsZSUyMHRvJTIwdGhlJTIwSHViJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull()
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.push_to_hub(commit_message=<span class="hljs-string">&quot;Commit my-awesome-file to the Hub&quot;</span>)`,wrap:!1}}),Ut=new y({props:{code:"cmVwby5naXRfYWRkKCUyMnBhdGglMkZ0byUyRmZpbGUlMjIpJTBBcmVwby5naXRfY29tbWl0KGNvbW1pdF9tZXNzYWdlJTNEJTIyYWRkJTIwbXklMjBmaXJzdCUyMG1vZGVsJTIwY29uZmlnJTIwZmlsZSUyMCUzQSklMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_add(<span class="hljs-string">&quot;path/to/file&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_commit(commit_message=<span class="hljs-string">&quot;add my first model config file :)&quot;</span>)`,wrap:!1}}),vt=new y({props:{code:"cmVwby5naXRfcHVzaCgp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_push()',wrap:!1}}),{c(){r=o("meta"),M=s(),g=o("p"),w=s(),c(H.$$.fragment),Wt=s(),B=o("p"),B.innerHTML=El,Rt=s(),X=o("ul"),X.innerHTML=Nl,St=s(),x=o("p"),x.textContent=ql,Lt=s(),U=o("ul"),A=o("li"),Ct=o("p"),Ct.textContent=Ql,Rl=s(),c(W.$$.fragment),Sl=s(),j=o("li"),Zt=o("p"),Zt.innerHTML=zl,Ll=s(),c(R.$$.fragment),Yl=s(),Gt=o("p"),Gt.innerHTML=Pl,Fl=s(),Ht=o("p"),Ht.innerHTML=Dl,Yt=s(),c(S.$$.fragment),Ft=s(),L=o("p"),L.innerHTML=Kl,Vt=s(),Y=o("p"),Y.innerHTML=Ol,Et=s(),c(F.$$.fragment),Nt=s(),c(V.$$.fragment),qt=s(),E=o("p"),E.innerHTML=es,Qt=s(),c(N.$$.fragment),zt=s(),q=o("p"),q.innerHTML=ts,Pt=s(),Q=o("p"),Q.innerHTML=as,Dt=s(),c(z.$$.fragment),Kt=s(),P=o("p"),P.innerHTML=ls,Ot=s(),D=o("p"),D.innerHTML=ss,ea=s(),c(K.$$.fragment),ta=s(),c(O.$$.fragment),aa=s(),ee=o("p"),ee.innerHTML=ns,la=s(),te=o("p"),te.textContent=os,sa=s(),c(ae.$$.fragment),na=s(),le=o("p"),le.innerHTML=is,oa=s(),se=o("p"),se.innerHTML=ps,ia=s(),c(ne.$$.fragment),pa=s(),oe=o("p"),oe.innerHTML=rs,ra=s(),c(ie.$$.fragment),ca=s(),pe=o("p"),pe.innerHTML=cs,ha=s(),c(re.$$.fragment),ua=s(),c($.$$.fragment),ma=s(),ce=o("p"),ce.innerHTML=hs,da=s(),c(he.$$.fragment),fa=s(),c(ue.$$.fragment),ga=s(),me=o("p"),me.innerHTML=us,ya=s(),de=o("p"),de.innerHTML=ms,Ma=s(),fe=o("p"),fe.innerHTML=ds,wa=s(),c(ge.$$.fragment),ba=s(),ye=o("p"),ye.innerHTML=fs,Ta=s(),c(v.$$.fragment),_a=s(),c(Me.$$.fragment),ja=s(),we=o("p"),we.innerHTML=gs,Ja=s(),be=o("p"),be.innerHTML=ys,Ua=s(),c(Te.$$.fragment),$a=s(),_e=o("p"),_e.textContent=Ms,va=s(),je=o("p"),je.innerHTML=ws,ka=s(),Je=o("ul"),Je.innerHTML=bs,Ia=s(),c(Ue.$$.fragment),Ca=s(),$e=o("p"),$e.innerHTML=Ts,Za=s(),c(ve.$$.fragment),Ga=s(),ke=o("p"),ke.innerHTML=_s,Ha=s(),Ie=o("p"),Ie.innerHTML=js,Ba=s(),c(Ce.$$.fragment),Xa=s(),Ze=o("p"),Ze.innerHTML=Js,xa=s(),Ge=o("ul"),Ge.innerHTML=Us,Aa=s(),c(k.$$.fragment),Wa=s(),c(He.$$.fragment),Ra=s(),Be=o("p"),Be.innerHTML=$s,Sa=s(),Xe=o("p"),Xe.innerHTML=vs,La=s(),xe=o("ul"),xe.innerHTML=ks,Ya=s(),Ae=o("p"),Ae.textContent=Is,Fa=s(),We=o("ol"),We.innerHTML=Cs,Va=s(),c(Re.$$.fragment),Ea=s(),I=o("ol"),I.innerHTML=Zs,Na=s(),c(Se.$$.fragment),qa=s(),Le=o("p"),Le.innerHTML=Gs,Qa=s(),Ye=o("ul"),Ye.innerHTML=Hs,za=s(),Fe=o("p"),Fe.innerHTML=Bs,Pa=s(),c(Ve.$$.fragment),Da=s(),Ee=o("p"),Ee.innerHTML=Xs,Ka=s(),c(C.$$.fragment),Oa=s(),Ne=o("p"),Ne.textContent=xs,el=s(),c(qe.$$.fragment),tl=s(),Qe=o("p"),Qe.innerHTML=As,al=s(),c(ze.$$.fragment),ll=s(),Pe=o("p"),Pe.textContent=Ws,sl=s(),De=o("p"),De.innerHTML=Rs,nl=s(),Ke=o("ul"),Ke.innerHTML=Ss,ol=s(),c(Z.$$.fragment),il=s(),c(Oe.$$.fragment),pl=s(),et=o("p"),et.innerHTML=Ls,rl=s(),c(G.$$.fragment),cl=s(),tt=o("p"),tt.textContent=Ys,hl=s(),c(at.$$.fragment),ul=s(),lt=o("p"),lt.textContent=Fs,ml=s(),c(st.$$.fragment),dl=s(),nt=o("p"),nt.innerHTML=Vs,fl=s(),ot=o("ol"),ot.innerHTML=Es,gl=s(),c(it.$$.fragment),yl=s(),pt=o("p"),pt.innerHTML=Ns,Ml=s(),c(rt.$$.fragment),wl=s(),ct=o("p"),ct.innerHTML=qs,bl=s(),c(ht.$$.fragment),Tl=s(),ut=o("p"),ut.innerHTML=Qs,_l=s(),c(mt.$$.fragment),jl=s(),dt=o("p"),dt.textContent=zs,Jl=s(),ft=o("table"),ft.innerHTML=Ps,Ul=s(),gt=o("p"),gt.innerHTML=Ds,$l=s(),c(yt.$$.fragment),vl=s(),c(Mt.$$.fragment),kl=s(),wt=o("p"),wt.innerHTML=Ks,Il=s(),bt=o("p"),bt.innerHTML=Os,Cl=s(),c(Tt.$$.fragment),Zl=s(),_t=o("p"),_t.innerHTML=en,Gl=s(),c(jt.$$.fragment),Hl=s(),Jt=o("p"),Jt.innerHTML=tn,Bl=s(),c(Ut.$$.fragment),Xl=s(),$t=o("p"),$t.innerHTML=an,xl=s(),c(vt.$$.fragment),Al=s(),xt=o("p"),this.h()},l(e){const t=hn("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(a),M=n(e),g=i(e,"P",{}),At(g).forEach(a),w=n(e),h(H.$$.fragment,e),Wt=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-uu6wb2"&&(B.innerHTML=El),Rt=n(e),X=i(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-6tlscw"&&(X.innerHTML=Nl),St=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-dy1t5h"&&(x.textContent=ql),Lt=n(e),U=i(e,"UL",{});var kt=At(U);A=i(kt,"LI",{});var It=At(A);Ct=i(It,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-w1rpkl"&&(Ct.textContent=Ql),Rl=n(It),h(W.$$.fragment,It),It.forEach(a),Sl=n(kt),j=i(kt,"LI",{});var J=At(j);Zt=i(J,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-7s9o13"&&(Zt.innerHTML=zl),Ll=n(J),h(R.$$.fragment,J),Yl=n(J),Gt=i(J,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-101icgb"&&(Gt.innerHTML=Pl),Fl=n(J),Ht=i(J,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-hkohcw"&&(Ht.innerHTML=Dl),J.forEach(a),kt.forEach(a),Yt=n(e),h(S.$$.fragment,e),Ft=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1vxvyei"&&(L.innerHTML=Kl),Vt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-weizha"&&(Y.innerHTML=Ol),Et=n(e),h(F.$$.fragment,e),Nt=n(e),h(V.$$.fragment,e),qt=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1cqxrmv"&&(E.innerHTML=es),Qt=n(e),h(N.$$.fragment,e),zt=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-sl7ozz"&&(q.innerHTML=ts),Pt=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1hekay4"&&(Q.innerHTML=as),Dt=n(e),h(z.$$.fragment,e),Kt=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1jdk3x1"&&(P.innerHTML=ls),Ot=n(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-j2fnkr"&&(D.innerHTML=ss),ea=n(e),h(K.$$.fragment,e),ta=n(e),h(O.$$.fragment,e),aa=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1e16dyq"&&(ee.innerHTML=ns),la=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-sxpkdv"&&(te.textContent=os),sa=n(e),h(ae.$$.fragment,e),na=n(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1whpdih"&&(le.innerHTML=is),oa=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-22tszs"&&(se.innerHTML=ps),ia=n(e),h(ne.$$.fragment,e),pa=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-6iufhk"&&(oe.innerHTML=rs),ra=n(e),h(ie.$$.fragment,e),ca=n(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-fskkzk"&&(pe.innerHTML=cs),ha=n(e),h(re.$$.fragment,e),ua=n(e),h($.$$.fragment,e),ma=n(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-2z3ua0"&&(ce.innerHTML=hs),da=n(e),h(he.$$.fragment,e),fa=n(e),h(ue.$$.fragment,e),ga=n(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1kxjmry"&&(me.innerHTML=us),ya=n(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-pwsrx3"&&(de.innerHTML=ms),Ma=n(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1kfhv6q"&&(fe.innerHTML=ds),wa=n(e),h(ge.$$.fragment,e),ba=n(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-t2cjhs"&&(ye.innerHTML=fs),Ta=n(e),h(v.$$.fragment,e),_a=n(e),h(Me.$$.fragment,e),ja=n(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-lk6dse"&&(we.innerHTML=gs),Ja=n(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-7pxeh0"&&(be.innerHTML=ys),Ua=n(e),h(Te.$$.fragment,e),$a=n(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-bk7nho"&&(_e.textContent=Ms),va=n(e),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1m9dg79"&&(je.innerHTML=ws),ka=n(e),Je=i(e,"UL",{"data-svelte-h":!0}),p(Je)!=="svelte-1md1dub"&&(Je.innerHTML=bs),Ia=n(e),h(Ue.$$.fragment,e),Ca=n(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1sxi3j0"&&($e.innerHTML=Ts),Za=n(e),h(ve.$$.fragment,e),Ga=n(e),ke=i(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-addoqn"&&(ke.innerHTML=_s),Ha=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-2fhb7l"&&(Ie.innerHTML=js),Ba=n(e),h(Ce.$$.fragment,e),Xa=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1334rbm"&&(Ze.innerHTML=Js),xa=n(e),Ge=i(e,"UL",{"data-svelte-h":!0}),p(Ge)!=="svelte-1r6n3gu"&&(Ge.innerHTML=Us),Aa=n(e),h(k.$$.fragment,e),Wa=n(e),h(He.$$.fragment,e),Ra=n(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1th5sp0"&&(Be.innerHTML=$s),Sa=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-5at25s"&&(Xe.innerHTML=vs),La=n(e),xe=i(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-rz04ky"&&(xe.innerHTML=ks),Ya=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-12aa4hm"&&(Ae.textContent=Is),Fa=n(e),We=i(e,"OL",{"data-svelte-h":!0}),p(We)!=="svelte-fvcpkg"&&(We.innerHTML=Cs),Va=n(e),h(Re.$$.fragment,e),Ea=n(e),I=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(I)!=="svelte-vqa2me"&&(I.innerHTML=Zs),Na=n(e),h(Se.$$.fragment,e),qa=n(e),Le=i(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-tghilk"&&(Le.innerHTML=Gs),Qa=n(e),Ye=i(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-v1ujs5"&&(Ye.innerHTML=Hs),za=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1nr3g7w"&&(Fe.innerHTML=Bs),Pa=n(e),h(Ve.$$.fragment,e),Da=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-xdqqo1"&&(Ee.innerHTML=Xs),Ka=n(e),h(C.$$.fragment,e),Oa=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1mshy2g"&&(Ne.textContent=xs),el=n(e),h(qe.$$.fragment,e),tl=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-e0yo9e"&&(Qe.innerHTML=As),al=n(e),h(ze.$$.fragment,e),ll=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-xzslhr"&&(Pe.textContent=Ws),sl=n(e),De=i(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-r0dbxq"&&(De.innerHTML=Rs),nl=n(e),Ke=i(e,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-re592n"&&(Ke.innerHTML=Ss),ol=n(e),h(Z.$$.fragment,e),il=n(e),h(Oe.$$.fragment,e),pl=n(e),et=i(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1g3heft"&&(et.innerHTML=Ls),rl=n(e),h(G.$$.fragment,e),cl=n(e),tt=i(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-ckpv1u"&&(tt.textContent=Ys),hl=n(e),h(at.$$.fragment,e),ul=n(e),lt=i(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1su1bae"&&(lt.textContent=Fs),ml=n(e),h(st.$$.fragment,e),dl=n(e),nt=i(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1euyrt0"&&(nt.innerHTML=Vs),fl=n(e),ot=i(e,"OL",{"data-svelte-h":!0}),p(ot)!=="svelte-jfle7b"&&(ot.innerHTML=Es),gl=n(e),h(it.$$.fragment,e),yl=n(e),pt=i(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1pjnw9q"&&(pt.innerHTML=Ns),Ml=n(e),h(rt.$$.fragment,e),wl=n(e),ct=i(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1t3cobo"&&(ct.innerHTML=qs),bl=n(e),h(ht.$$.fragment,e),Tl=n(e),ut=i(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-147hmo"&&(ut.innerHTML=Qs),_l=n(e),h(mt.$$.fragment,e),jl=n(e),dt=i(e,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-i7szos"&&(dt.textContent=zs),Jl=n(e),ft=i(e,"TABLE",{"data-svelte-h":!0}),p(ft)!=="svelte-13yxo7x"&&(ft.innerHTML=Ps),Ul=n(e),gt=i(e,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-1j9orlr"&&(gt.innerHTML=Ds),$l=n(e),h(yt.$$.fragment,e),vl=n(e),h(Mt.$$.fragment,e),kl=n(e),wt=i(e,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1jk6qwh"&&(wt.innerHTML=Ks),Il=n(e),bt=i(e,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-ou5qb0"&&(bt.innerHTML=Os),Cl=n(e),h(Tt.$$.fragment,e),Zl=n(e),_t=i(e,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-npjau"&&(_t.innerHTML=en),Gl=n(e),h(jt.$$.fragment,e),Hl=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-11qj302"&&(Jt.innerHTML=tn),Bl=n(e),h(Ut.$$.fragment,e),Xl=n(e),$t=i(e,"P",{"data-svelte-h":!0}),p($t)!=="svelte-10na6yy"&&($t.innerHTML=an),xl=n(e),h(vt.$$.fragment,e),Al=n(e),xt=i(e,"P",{}),At(xt).forEach(a),this.h()},h(){Vl(r,"name","hf:doc:metadata"),Vl(r,"content",bn),Vl(I,"start","2")},m(e,t){_(document.head,r),l(e,M,t),l(e,g,t),l(e,w,t),u(H,e,t),l(e,Wt,t),l(e,B,t),l(e,Rt,t),l(e,X,t),l(e,St,t),l(e,x,t),l(e,Lt,t),l(e,U,t),_(U,A),_(A,Ct),_(A,Rl),u(W,A,null),_(U,Sl),_(U,j),_(j,Zt),_(j,Ll),u(R,j,null),_(j,Yl),_(j,Gt),_(j,Fl),_(j,Ht),l(e,Yt,t),u(S,e,t),l(e,Ft,t),l(e,L,t),l(e,Vt,t),l(e,Y,t),l(e,Et,t),u(F,e,t),l(e,Nt,t),u(V,e,t),l(e,qt,t),l(e,E,t),l(e,Qt,t),u(N,e,t),l(e,zt,t),l(e,q,t),l(e,Pt,t),l(e,Q,t),l(e,Dt,t),u(z,e,t),l(e,Kt,t),l(e,P,t),l(e,Ot,t),l(e,D,t),l(e,ea,t),u(K,e,t),l(e,ta,t),u(O,e,t),l(e,aa,t),l(e,ee,t),l(e,la,t),l(e,te,t),l(e,sa,t),u(ae,e,t),l(e,na,t),l(e,le,t),l(e,oa,t),l(e,se,t),l(e,ia,t),u(ne,e,t),l(e,pa,t),l(e,oe,t),l(e,ra,t),u(ie,e,t),l(e,ca,t),l(e,pe,t),l(e,ha,t),u(re,e,t),l(e,ua,t),u($,e,t),l(e,ma,t),l(e,ce,t),l(e,da,t),u(he,e,t),l(e,fa,t),u(ue,e,t),l(e,ga,t),l(e,me,t),l(e,ya,t),l(e,de,t),l(e,Ma,t),l(e,fe,t),l(e,wa,t),u(ge,e,t),l(e,ba,t),l(e,ye,t),l(e,Ta,t),u(v,e,t),l(e,_a,t),u(Me,e,t),l(e,ja,t),l(e,we,t),l(e,Ja,t),l(e,be,t),l(e,Ua,t),u(Te,e,t),l(e,$a,t),l(e,_e,t),l(e,va,t),l(e,je,t),l(e,ka,t),l(e,Je,t),l(e,Ia,t),u(Ue,e,t),l(e,Ca,t),l(e,$e,t),l(e,Za,t),u(ve,e,t),l(e,Ga,t),l(e,ke,t),l(e,Ha,t),l(e,Ie,t),l(e,Ba,t),u(Ce,e,t),l(e,Xa,t),l(e,Ze,t),l(e,xa,t),l(e,Ge,t),l(e,Aa,t),u(k,e,t),l(e,Wa,t),u(He,e,t),l(e,Ra,t),l(e,Be,t),l(e,Sa,t),l(e,Xe,t),l(e,La,t),l(e,xe,t),l(e,Ya,t),l(e,Ae,t),l(e,Fa,t),l(e,We,t),l(e,Va,t),u(Re,e,t),l(e,Ea,t),l(e,I,t),l(e,Na,t),u(Se,e,t),l(e,qa,t),l(e,Le,t),l(e,Qa,t),l(e,Ye,t),l(e,za,t),l(e,Fe,t),l(e,Pa,t),u(Ve,e,t),l(e,Da,t),l(e,Ee,t),l(e,Ka,t),u(C,e,t),l(e,Oa,t),l(e,Ne,t),l(e,el,t),u(qe,e,t),l(e,tl,t),l(e,Qe,t),l(e,al,t),u(ze,e,t),l(e,ll,t),l(e,Pe,t),l(e,sl,t),l(e,De,t),l(e,nl,t),l(e,Ke,t),l(e,ol,t),u(Z,e,t),l(e,il,t),u(Oe,e,t),l(e,pl,t),l(e,et,t),l(e,rl,t),u(G,e,t),l(e,cl,t),l(e,tt,t),l(e,hl,t),u(at,e,t),l(e,ul,t),l(e,lt,t),l(e,ml,t),u(st,e,t),l(e,dl,t),l(e,nt,t),l(e,fl,t),l(e,ot,t),l(e,gl,t),u(it,e,t),l(e,yl,t),l(e,pt,t),l(e,Ml,t),u(rt,e,t),l(e,wl,t),l(e,ct,t),l(e,bl,t),u(ht,e,t),l(e,Tl,t),l(e,ut,t),l(e,_l,t),u(mt,e,t),l(e,jl,t),l(e,dt,t),l(e,Jl,t),l(e,ft,t),l(e,Ul,t),l(e,gt,t),l(e,$l,t),u(yt,e,t),l(e,vl,t),u(Mt,e,t),l(e,kl,t),l(e,wt,t),l(e,Il,t),l(e,bt,t),l(e,Cl,t),u(Tt,e,t),l(e,Zl,t),l(e,_t,t),l(e,Gl,t),u(jt,e,t),l(e,Hl,t),l(e,Jt,t),l(e,Bl,t),u(Ut,e,t),l(e,Xl,t),l(e,$t,t),l(e,xl,t),u(vt,e,t),l(e,Al,t),l(e,xt,t),Wl=!0},p(e,[t]){const kt={};t&2&&(kt.$$scope={dirty:t,ctx:e}),$.$set(kt);const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),v.$set(It);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),k.$set(J);const ln={};t&2&&(ln.$$scope={dirty:t,ctx:e}),C.$set(ln);const sn={};t&2&&(sn.$$scope={dirty:t,ctx:e}),Z.$set(sn);const nn={};t&2&&(nn.$$scope={dirty:t,ctx:e}),G.$set(nn)},i(e){Wl||(m(H.$$.fragment,e),m(W.$$.fragment,e),m(R.$$.fragment,e),m(S.$$.fragment,e),m(F.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(z.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m($.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),m(ge.$$.fragment,e),m(v.$$.fragment,e),m(Me.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(ve.$$.fragment,e),m(Ce.$$.fragment,e),m(k.$$.fragment,e),m(He.$$.fragment,e),m(Re.$$.fragment,e),m(Se.$$.fragment,e),m(Ve.$$.fragment,e),m(C.$$.fragment,e),m(qe.$$.fragment,e),m(ze.$$.fragment,e),m(Z.$$.fragment,e),m(Oe.$$.fragment,e),m(G.$$.fragment,e),m(at.$$.fragment,e),m(st.$$.fragment,e),m(it.$$.fragment,e),m(rt.$$.fragment,e),m(ht.$$.fragment,e),m(mt.$$.fragment,e),m(yt.$$.fragment,e),m(Mt.$$.fragment,e),m(Tt.$$.fragment,e),m(jt.$$.fragment,e),m(Ut.$$.fragment,e),m(vt.$$.fragment,e),Wl=!0)},o(e){d(H.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(S.$$.fragment,e),d(F.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(z.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d($.$$.fragment,e),d(he.$$.fragment,e),d(ue.$$.fragment,e),d(ge.$$.fragment,e),d(v.$$.fragment,e),d(Me.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d(ve.$$.fragment,e),d(Ce.$$.fragment,e),d(k.$$.fragment,e),d(He.$$.fragment,e),d(Re.$$.fragment,e),d(Se.$$.fragment,e),d(Ve.$$.fragment,e),d(C.$$.fragment,e),d(qe.$$.fragment,e),d(ze.$$.fragment,e),d(Z.$$.fragment,e),d(Oe.$$.fragment,e),d(G.$$.fragment,e),d(at.$$.fragment,e),d(st.$$.fragment,e),d(it.$$.fragment,e),d(rt.$$.fragment,e),d(ht.$$.fragment,e),d(mt.$$.fragment,e),d(yt.$$.fragment,e),d(Mt.$$.fragment,e),d(Tt.$$.fragment,e),d(jt.$$.fragment,e),d(Ut.$$.fragment,e),d(vt.$$.fragment,e),Wl=!1},d(e){e&&(a(M),a(g),a(w),a(Wt),a(B),a(Rt),a(X),a(St),a(x),a(Lt),a(U),a(Yt),a(Ft),a(L),a(Vt),a(Y),a(Et),a(Nt),a(qt),a(E),a(Qt),a(zt),a(q),a(Pt),a(Q),a(Dt),a(Kt),a(P),a(Ot),a(D),a(ea),a(ta),a(aa),a(ee),a(la),a(te),a(sa),a(na),a(le),a(oa),a(se),a(ia),a(pa),a(oe),a(ra),a(ca),a(pe),a(ha),a(ua),a(ma),a(ce),a(da),a(fa),a(ga),a(me),a(ya),a(de),a(Ma),a(fe),a(wa),a(ba),a(ye),a(Ta),a(_a),a(ja),a(we),a(Ja),a(be),a(Ua),a($a),a(_e),a(va),a(je),a(ka),a(Je),a(Ia),a(Ca),a($e),a(Za),a(Ga),a(ke),a(Ha),a(Ie),a(Ba),a(Xa),a(Ze),a(xa),a(Ge),a(Aa),a(Wa),a(Ra),a(Be),a(Sa),a(Xe),a(La),a(xe),a(Ya),a(Ae),a(Fa),a(We),a(Va),a(Ea),a(I),a(Na),a(qa),a(Le),a(Qa),a(Ye),a(za),a(Fe),a(Pa),a(Da),a(Ee),a(Ka),a(Oa),a(Ne),a(el),a(tl),a(Qe),a(al),a(ll),a(Pe),a(sl),a(De),a(nl),a(Ke),a(ol),a(il),a(pl),a(et),a(rl),a(cl),a(tt),a(hl),a(ul),a(lt),a(ml),a(dl),a(nt),a(fl),a(ot),a(gl),a(yl),a(pt),a(Ml),a(wl),a(ct),a(bl),a(Tl),a(ut),a(_l),a(jl),a(dt),a(Jl),a(ft),a(Ul),a(gt),a($l),a(vl),a(kl),a(wt),a(Il),a(bt),a(Cl),a(Zl),a(_t),a(Gl),a(Hl),a(Jt),a(Bl),a(Xl),a($t),a(xl),a(Al),a(xt)),a(r),f(H,e),f(W),f(R),f(S,e),f(F,e),f(V,e),f(N,e),f(z,e),f(K,e),f(O,e),f(ae,e),f(ne,e),f(ie,e),f(re,e),f($,e),f(he,e),f(ue,e),f(ge,e),f(v,e),f(Me,e),f(Te,e),f(Ue,e),f(ve,e),f(Ce,e),f(k,e),f(He,e),f(Re,e),f(Se,e),f(Ve,e),f(C,e),f(qe,e),f(ze,e),f(Z,e),f(Oe,e),f(G,e),f(at,e),f(st,e),f(it,e),f(rt,e),f(ht,e),f(mt,e),f(yt,e),f(Mt,e),f(Tt,e),f(jt,e),f(Ut,e),f(vt,e)}}}const bn='{"title":"Upload files to the Hub","local":"upload-files-to-the-hub","sections":[{"title":"Upload a file","local":"upload-a-file","sections":[],"depth":2},{"title":"Upload a folder","local":"upload-a-folder","sections":[],"depth":2},{"title":"Upload from the CLI","local":"upload-from-the-cli","sections":[],"depth":2},{"title":"Advanced features","local":"advanced-features","sections":[{"title":"Non-blocking uploads","local":"non-blocking-uploads","sections":[],"depth":3},{"title":"Upload a folder by chunks","local":"upload-a-folder-by-chunks","sections":[],"depth":3},{"title":"Scheduled uploads","local":"scheduled-uploads","sections":[{"title":"Space persistence demo","local":"space-persistence-demo","sections":[],"depth":4},{"title":"Custom uploads","local":"custom-uploads","sections":[],"depth":4}],"depth":3},{"title":"create_commit","local":"createcommit","sections":[],"depth":3},{"title":"Preupload LFS files before commit","local":"preupload-lfs-files-before-commit","sections":[],"depth":3}],"depth":2},{"title":"Tips and tricks for large uploads","local":"tips-and-tricks-for-large-uploads","sections":[],"depth":2},{"title":"(legacy) Upload files with Git LFS","local":"legacy-upload-files-with-git-lfs","sections":[{"title":"commit context manager","local":"commit-context-manager","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3}],"depth":2}],"depth":1}';function Tn(T){return pn(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=un}),[]}class vn extends rn{constructor(r){super(),cn(this,r,Tn,wn,on,{})}}export{vn as component};
