import{s as Wl,n as $l,o as Yl}from"../chunks/scheduler.6062bdaf.js";import{S as Rl,i as Xl,g as i,s,r,A as Vl,h as o,f as t,c as n,j as El,u as p,x as M,k as nl,y as Ql,a,v as d,d as c,t as h,w as m}from"../chunks/index.4bca734e.js";import{H as y,g as Sl}from"../chunks/Heading.ca8c53ae.js";import{C as Me}from"../chunks/CodeBlock.fa01571c.js";function Fl(il){let u,de,re,ce,J,he,b,ol=`The Hugging Face Hub makes hosting and sharing models with the community easy. It supports
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dozens of libraries</a> in the Open Source ecosystem. We are always
working on expanding this support to push collaborative Machine Learning forward. The <code>huggingface_hub</code> library plays a
key role in this process, allowing any Python script to easily push and load files.`,me,f,Ml="There are four main ways to integrate a library with the Hub:",ye,j,rl=`<li><strong>Push to Hub:</strong> implement a method to upload a model to the Hub. This includes the model weights, as well as
<a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">the model card</a> and any other relevant information
or data necessary to run the model (for example, training logs). This method is often called <code>push_to_hub()</code>.</li> <li><strong>Download from Hub:</strong> implement a method to load a model from the Hub. The method should download the model
configuration/weights and load the model. This method is often called <code>from_pretrained</code> or <code>load_from_hub()</code>.</li> <li><strong>Inference API:</strong> use our servers to run inference on models supported by your library for free.</li> <li><strong>Widgets:</strong> display a widget on the landing page of your models on the Hub. It allows users to quickly try a model
from the browser.</li>`,ue,U,pl=`In this guide, we will focus on the first two topics. We will present the two main approaches you can use to integrate
a library, with their advantages and drawbacks. Everything is summarized at the end of the guide to help you choose
between the two. Please keep in mind that these are only guidelines that you are free to adapt to you requirements.`,we,I,dl=`If you are interested in Inference and Widgets, you can follow <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">this guide</a>.
In both cases, you can reach out to us if you are integrating a library with the Hub and want to be listed
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in our docs</a>.`,Te,g,Je,C,cl=`The first approach to integrate a library to the Hub is to actually implement the <code>push_to_hub</code> and <code>from_pretrained</code>
methods by yourself. This gives you full flexibility on which files you need to upload/download and how to handle inputs
specific to your framework. You can refer to the two <a href="./upload">upload files</a> and <a href="./download">download files</a> guides
to learn more about how to do that. This is, for example how the FastAI integration is implemented (see <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.push_to_hub_fastai">push_to_hub_fastai()</a>
and <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.from_pretrained_fastai">from_pretrained_fastai()</a>).`,be,_,hl="Implementation can differ between libraries, but the workflow is often similar.",fe,k,je,B,ml="This is how a <code>from_pretrained</code> method usually look like:",Ue,v,Ie,A,ge,Z,yl=`The <code>push_to_hub</code> method often requires a bit more complexity to handle repo creation, generate the model card and save weights.
A common approach is to save all of these files in a temporary folder, upload it and then delete it.`,Ce,G,_e,x,ul=`This is of course only an example. If you are interested in more complex manipulations (delete remote files, upload
weights on the fly, persist weights locally, etc.) please refer to the <a href="./upload">upload files</a> guide.`,ke,H,Be,E,wl=`While being flexible, this approach has some drawbacks, especially in terms of maintenance. Hugging Face users are often
used to additional features when working with <code>huggingface_hub</code>. For example, when loading files from the Hub, it is
common to offer parameters like:`,ve,W,Tl="<li><code>token</code>: to download from a private repo</li> <li><code>revision</code>: to download from a specific branch</li> <li><code>cache_dir</code>: to cache files in a specific directory</li> <li><code>force_download</code>/<code>resume_download</code>/<code>local_files_only</code>: to reuse the cache or not</li> <li><code>api_endpoint</code>/<code>proxies</code>: configure HTTP session</li>",Ae,$,Jl="When pushing models, similar parameters are supported:",Ze,Y,bl="<li><code>commit_message</code>: custom commit message</li> <li><code>private</code>: create a private repo if missing</li> <li><code>create_pr</code>: create a PR instead of pushing to <code>main</code></li> <li><code>branch</code>: push to a branch instead of the <code>main</code> branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filter which files to upload</li> <li><code>token</code></li> <li><code>api_endpoint</code></li> <li>…</li>",Ge,R,fl=`All of these parameters can be added to the implementations we saw above and passed to the <code>huggingface_hub</code> methods.
However, if a parameter changes or a new feature is added, you will need to update your package. Supporting those
parameters also means more documentation to maintain on your side. To see how to mitigate these limitations, let’s jump
to our next section <strong>class inheritance</strong>.`,xe,X,He,V,jl=`As we saw above, there are two main methods to include in your library to integrate it with the Hub: upload files
(<code>push_to_hub</code>) and download files (<code>from_pretrained</code>). You can implement those methods by yourself but it comes with
caveats. To tackle this, <code>huggingface_hub</code> provides a tool that uses class inheritance. Let’s see how it works!`,Ee,Q,Ul=`In a lot of cases, a library already implements its model using a Python class. The class contains the properties of
the model and methods to load, run, train, and evaluate it. Our approach is to extend this class to include upload and
download features using mixins. A <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> is a class that is meant to extend an
existing class with a set of specific features using multiple inheritance. <code>huggingface_hub</code> provides its own mixin,
the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. The key here is to understand its behavior and how to customize it.`,We,S,Il=`The <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> class implements 3 <em>public</em> methods (<code>push_to_hub</code>, <code>save_pretrained</code> and <code>from_pretrained</code>). Those
are the methods that your users will call to load/save models with your library. <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also defines 2
<em>private</em> methods (<code>_save_pretrained</code> and <code>_from_pretrained</code>). Those are the ones you must implement. So to integrate
your library, you should:`,$e,F,gl=`<li>Make your Model class inherit from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.</li> <li>Implement the private methods:<ul><li><a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._save_pretrained">_save_pretrained()</a>: method taking as input a path to a directory and saving the model to it.
You must write all the logic to dump your model in this method: model card, model weights, configuration files,
training logs, and figures. Any relevant information for this model must be handled by this method.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> are particularly important to describe your model. Check
out <a href="./model-cards">our implementation guide</a> for more details.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a>: <strong>class method</strong> taking as input a <code>model_id</code> and returning an instantiated
model. The method must download the relevant files and load them.</li></ul></li> <li>You are done!</li>`,Ye,L,Cl=`The advantage of using <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> is that once you take care of the serialization/loading of the files, you
are ready to go. You don’t need to worry about stuff like repo creation, commits, PRs, or revisions. All
of this is handled by the mixin and is available to your users. The Mixin also ensures that public methods are well
documented and type annotated.`,Re,z,Xe,N,_l=`A good example of what we saw above is <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a>, our integration for the PyTorch framework. This is a
ready-to-use integration.`,Ve,q,Qe,P,kl="Here is how any user can load/save a PyTorch model from/to the Hub:",Se,K,Fe,D,Le,O,Bl='The implementation is actually very straightforward, and the full implementation can be found <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">here</a>.',ze,ee,vl="<li>First, inherit your class from <code>ModelHubMixin</code>:</li>",Ne,le,qe,w,Al="<li>Implement the <code>_save_pretrained</code> method:</li>",Pe,te,Ke,T,Zl="<li>Implement the <code>_from_pretrained</code> method:</li>",De,ae,Oe,se,Gl="And that’s it! Your library now enables users to upload and download files to and from the Hub.",el,ne,ll,ie,xl=`Let’s quickly sum up the two approaches we saw with their advantages and drawbacks. The table below is only indicative.
Your framework might have some specificities that you need to address. This guide is only here to give guidelines and
ideas on how to handle integration. In any case, feel free to contact us if you have any questions!`,tl,oe,Hl='<thead><tr><th align="center">Integration</th> <th align="center">Using helpers</th> <th align="center">Using <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a></th></tr></thead> <tbody><tr><td align="center">User experience</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibility</td> <td align="center">Very flexible.<br/>You fully control the implementation.</td> <td align="center">Less flexible.<br/>Your framework must have a model class.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">More maintenance to add support for configuration, and new features. Might also require fixing issues reported by users.</td> <td align="center">Less maintenance as most of the interactions with the Hub are implemented in <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Documentation / Type annotation</td> <td align="center">To be written manually.</td> <td align="center">Partially handled by <code>huggingface_hub</code>.</td></tr></tbody>',al,pe,sl;return J=new y({props:{title:"Integrate any ML framework with the Hub",local:"integrate-any-ml-framework-with-the-hub",headingTag:"h1"}}),g=new y({props:{title:"A flexible approach: helpers",local:"a-flexible-approach-helpers",headingTag:"h2"}}),k=new y({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),v=new Me({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwZnJvbSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwTG9hZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9hZF9tb2RlbChjYWNoZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Download model from Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Load model</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),A=new y({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),G=new Me({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwcmVwbyUyMGlmJTIwbm90JTIwZXhpc3RpbmclMjB5ZXQlMjBhbmQlMjBnZXQlMjB0aGUlMjBhc3NvY2lhdGVkJTIwcmVwb19pZCUwQSUyMCUyMCUyMHJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8ocmVwb19uYW1lJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdmUlMjBhbGwlMjBmaWxlcyUyMGluJTIwYSUyMHRlbXBvcmFyeSUyMGRpcmVjdG9yeSUyMGFuZCUyMHB1c2glMjB0aGVtJTIwaW4lMjBhJTIwc2luZ2xlJTIwY29tbWl0JTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwbG9ncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjBmaWd1cmVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMGV2YWx1YXRpb24lMjBtZXRyaWNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHVzaCUyMHRvJTIwaHViJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjBmb2xkZXJfcGF0aCUzRHRtcGRpcik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Create repo if not existing yet and get the associated repo_id</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Save all files in a temporary directory and push them in a single commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Save weights</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Generate model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Save logs</span>
      <span class="hljs-comment"># Save figures</span>
      <span class="hljs-comment"># Save evaluation metrics</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Push to hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),H=new y({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),X=new y({props:{title:"A more complex approach: class inheritance",local:"a-more-complex-approach-class-inheritance",headingTag:"h2"}}),z=new y({props:{title:"A concrete example: PyTorch",local:"a-concrete-example-pytorch",headingTag:"h3"}}),q=new y({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h4"}}),K=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTIwJTIzJTIwbXVsdGlwbGUlMjBpbmhlcml0YW5jZSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wYXJhbSUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKDMlMkMlMjA0KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxpbmVhciUyMCUzRCUyMG5uLkxpbmVhcig0JTJDJTIwNSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubGluZWFyKHglMjAlMkIlMjBzZWxmLnBhcmFtKSUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbCgpJTBBJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMEFtb2RlbCUyMCUzRCUyME15TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnVzZXJuYW1lJTJGbXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-comment"># 1. Define your Pytorch model exactly the same way you are used to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># multiple inheritance</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__() 
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(<span class="hljs-number">3</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()

<span class="hljs-comment"># 2. (optional) Save model to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Initialize model from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`,wrap:!1}}),D=new y({props:{title:"Implementation",local:"implementation",headingTag:"h4"}}),le=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),te=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2VuZXJhdGUlMjBNb2RlbCUyMENhcmQlMjBhbmQlMjBzYXZlJTIwd2VpZ2h0cyUyMGZyb20lMjBhJTIwUHl0b3JjaCUyMG1vZGVsJTIwdG8lMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnkuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfY2FyZCUyMCUzRCUyME1vZGVsQ2FyZC5mcm9tX3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRfZGF0YSUzRE1vZGVsQ2FyZERhdGEoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGljZW5zZSUzRCdtaXQnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9zdW1tYXJ5JTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfdHlwZSUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAoc2F2ZV9kaXJlY3RvcnklMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoc3RyKG1vZGVsKSklMEElMjAlMjAlMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG9iaiUzRHNlbGYubW9kdWxlLnN0YXRlX2RpY3QoKSUyQyUyMGYlM0RzYXZlX2RpcmVjdG9yeSUyMCUyRiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>):
      <span class="hljs-string">&quot;&quot;&quot;Generate Model Card and save weights from a Pytorch model to a local directory.&quot;&quot;&quot;</span>
      model_card = ModelCard.from_template(
         card_data=ModelCardData(
            license=<span class="hljs-string">&#x27;mit&#x27;</span>,
            library_name=<span class="hljs-string">&quot;pytorch&quot;</span>,
            ...
         ),
         model_summary=...,
         model_type=...,
         ...
      )
      (save_directory / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(<span class="hljs-built_in">str</span>(model))
      torch.save(obj=self.module.state_dict(), f=save_directory / <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),ae=new Me({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Must be a classmethod!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># additional argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># additional argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
      <span class="hljs-keyword">if</span> os.path.isdir(model_id): <span class="hljs-comment"># Can either be a local directory</span>
         <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
         model_file = os.path.join(model_id, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
      <span class="hljs-keyword">else</span>: <span class="hljs-comment"># Or a model on the Hub</span>
         model_file = hf_hub_download( <span class="hljs-comment"># Download from the hub, passing same input args</span>
            repo_id=model_id,
            filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
         )

      <span class="hljs-comment"># Load model and return - custom logic depending on your framework</span>
      model = cls(**model_kwargs)
      state_dict = torch.load(model_file, map_location=torch.device(map_location))
      model.load_state_dict(state_dict, strict=strict)
      model.<span class="hljs-built_in">eval</span>()
      <span class="hljs-keyword">return</span> model`,wrap:!1}}),ne=new y({props:{title:"Quick comparison",local:"quick-comparison",headingTag:"h2"}}),{c(){u=i("meta"),de=s(),re=i("p"),ce=s(),r(J.$$.fragment),he=s(),b=i("p"),b.innerHTML=ol,me=s(),f=i("p"),f.textContent=Ml,ye=s(),j=i("ol"),j.innerHTML=rl,ue=s(),U=i("p"),U.textContent=pl,we=s(),I=i("p"),I.innerHTML=dl,Te=s(),r(g.$$.fragment),Je=s(),C=i("p"),C.innerHTML=cl,be=s(),_=i("p"),_.textContent=hl,fe=s(),r(k.$$.fragment),je=s(),B=i("p"),B.innerHTML=ml,Ue=s(),r(v.$$.fragment),Ie=s(),r(A.$$.fragment),ge=s(),Z=i("p"),Z.innerHTML=yl,Ce=s(),r(G.$$.fragment),_e=s(),x=i("p"),x.innerHTML=ul,ke=s(),r(H.$$.fragment),Be=s(),E=i("p"),E.innerHTML=wl,ve=s(),W=i("ul"),W.innerHTML=Tl,Ae=s(),$=i("p"),$.textContent=Jl,Ze=s(),Y=i("ul"),Y.innerHTML=bl,Ge=s(),R=i("p"),R.innerHTML=fl,xe=s(),r(X.$$.fragment),He=s(),V=i("p"),V.innerHTML=jl,Ee=s(),Q=i("p"),Q.innerHTML=Ul,We=s(),S=i("p"),S.innerHTML=Il,$e=s(),F=i("ol"),F.innerHTML=gl,Ye=s(),L=i("p"),L.innerHTML=Cl,Re=s(),r(z.$$.fragment),Xe=s(),N=i("p"),N.innerHTML=_l,Ve=s(),r(q.$$.fragment),Qe=s(),P=i("p"),P.textContent=kl,Se=s(),r(K.$$.fragment),Fe=s(),r(D.$$.fragment),Le=s(),O=i("p"),O.innerHTML=Bl,ze=s(),ee=i("ol"),ee.innerHTML=vl,Ne=s(),r(le.$$.fragment),qe=s(),w=i("ol"),w.innerHTML=Al,Pe=s(),r(te.$$.fragment),Ke=s(),T=i("ol"),T.innerHTML=Zl,De=s(),r(ae.$$.fragment),Oe=s(),se=i("p"),se.textContent=Gl,el=s(),r(ne.$$.fragment),ll=s(),ie=i("p"),ie.textContent=xl,tl=s(),oe=i("table"),oe.innerHTML=Hl,al=s(),pe=i("p"),this.h()},l(e){const l=Vl("svelte-u9bgzb",document.head);u=o(l,"META",{name:!0,content:!0}),l.forEach(t),de=n(e),re=o(e,"P",{}),El(re).forEach(t),ce=n(e),p(J.$$.fragment,e),he=n(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-uvt37o"&&(b.innerHTML=ol),me=n(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-14vdlq5"&&(f.textContent=Ml),ye=n(e),j=o(e,"OL",{"data-svelte-h":!0}),M(j)!=="svelte-14btp4x"&&(j.innerHTML=rl),ue=n(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1tx4sul"&&(U.textContent=pl),we=n(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-10f3yyh"&&(I.innerHTML=dl),Te=n(e),p(g.$$.fragment,e),Je=n(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-r9ojoj"&&(C.innerHTML=cl),be=n(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1g2giur"&&(_.textContent=hl),fe=n(e),p(k.$$.fragment,e),je=n(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-bozc1x"&&(B.innerHTML=ml),Ue=n(e),p(v.$$.fragment,e),Ie=n(e),p(A.$$.fragment,e),ge=n(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-7bmo7d"&&(Z.innerHTML=yl),Ce=n(e),p(G.$$.fragment,e),_e=n(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-15vgu12"&&(x.innerHTML=ul),ke=n(e),p(H.$$.fragment,e),Be=n(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-tzwehq"&&(E.innerHTML=wl),ve=n(e),W=o(e,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-wxu08k"&&(W.innerHTML=Tl),Ae=n(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-3m9y73"&&($.textContent=Jl),Ze=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),M(Y)!=="svelte-zj5lmn"&&(Y.innerHTML=bl),Ge=n(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-p8rs76"&&(R.innerHTML=fl),xe=n(e),p(X.$$.fragment,e),He=n(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1uvlinw"&&(V.innerHTML=jl),Ee=n(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-qqd3b3"&&(Q.innerHTML=Ul),We=n(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1e60xo5"&&(S.innerHTML=Il),$e=n(e),F=o(e,"OL",{"data-svelte-h":!0}),M(F)!=="svelte-1czklek"&&(F.innerHTML=gl),Ye=n(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-15kbqb0"&&(L.innerHTML=Cl),Re=n(e),p(z.$$.fragment,e),Xe=n(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-av3gxt"&&(N.innerHTML=_l),Ve=n(e),p(q.$$.fragment,e),Qe=n(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-l2ktl8"&&(P.textContent=kl),Se=n(e),p(K.$$.fragment,e),Fe=n(e),p(D.$$.fragment,e),Le=n(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-l2iz9k"&&(O.innerHTML=Bl),ze=n(e),ee=o(e,"OL",{"data-svelte-h":!0}),M(ee)!=="svelte-1a9vqht"&&(ee.innerHTML=vl),Ne=n(e),p(le.$$.fragment,e),qe=n(e),w=o(e,"OL",{start:!0,"data-svelte-h":!0}),M(w)!=="svelte-mclxy5"&&(w.innerHTML=Al),Pe=n(e),p(te.$$.fragment,e),Ke=n(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),M(T)!=="svelte-1vfuaub"&&(T.innerHTML=Zl),De=n(e),p(ae.$$.fragment,e),Oe=n(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-zuw9zy"&&(se.textContent=Gl),el=n(e),p(ne.$$.fragment,e),ll=n(e),ie=o(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1qi11kl"&&(ie.textContent=xl),tl=n(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),M(oe)!=="svelte-icfkon"&&(oe.innerHTML=Hl),al=n(e),pe=o(e,"P",{}),El(pe).forEach(t),this.h()},h(){nl(u,"name","hf:doc:metadata"),nl(u,"content",Ll),nl(w,"start","2"),nl(T,"start","3")},m(e,l){Ql(document.head,u),a(e,de,l),a(e,re,l),a(e,ce,l),d(J,e,l),a(e,he,l),a(e,b,l),a(e,me,l),a(e,f,l),a(e,ye,l),a(e,j,l),a(e,ue,l),a(e,U,l),a(e,we,l),a(e,I,l),a(e,Te,l),d(g,e,l),a(e,Je,l),a(e,C,l),a(e,be,l),a(e,_,l),a(e,fe,l),d(k,e,l),a(e,je,l),a(e,B,l),a(e,Ue,l),d(v,e,l),a(e,Ie,l),d(A,e,l),a(e,ge,l),a(e,Z,l),a(e,Ce,l),d(G,e,l),a(e,_e,l),a(e,x,l),a(e,ke,l),d(H,e,l),a(e,Be,l),a(e,E,l),a(e,ve,l),a(e,W,l),a(e,Ae,l),a(e,$,l),a(e,Ze,l),a(e,Y,l),a(e,Ge,l),a(e,R,l),a(e,xe,l),d(X,e,l),a(e,He,l),a(e,V,l),a(e,Ee,l),a(e,Q,l),a(e,We,l),a(e,S,l),a(e,$e,l),a(e,F,l),a(e,Ye,l),a(e,L,l),a(e,Re,l),d(z,e,l),a(e,Xe,l),a(e,N,l),a(e,Ve,l),d(q,e,l),a(e,Qe,l),a(e,P,l),a(e,Se,l),d(K,e,l),a(e,Fe,l),d(D,e,l),a(e,Le,l),a(e,O,l),a(e,ze,l),a(e,ee,l),a(e,Ne,l),d(le,e,l),a(e,qe,l),a(e,w,l),a(e,Pe,l),d(te,e,l),a(e,Ke,l),a(e,T,l),a(e,De,l),d(ae,e,l),a(e,Oe,l),a(e,se,l),a(e,el,l),d(ne,e,l),a(e,ll,l),a(e,ie,l),a(e,tl,l),a(e,oe,l),a(e,al,l),a(e,pe,l),sl=!0},p:$l,i(e){sl||(c(J.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(A.$$.fragment,e),c(G.$$.fragment,e),c(H.$$.fragment,e),c(X.$$.fragment,e),c(z.$$.fragment,e),c(q.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(le.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(ne.$$.fragment,e),sl=!0)},o(e){h(J.$$.fragment,e),h(g.$$.fragment,e),h(k.$$.fragment,e),h(v.$$.fragment,e),h(A.$$.fragment,e),h(G.$$.fragment,e),h(H.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(D.$$.fragment,e),h(le.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),sl=!1},d(e){e&&(t(de),t(re),t(ce),t(he),t(b),t(me),t(f),t(ye),t(j),t(ue),t(U),t(we),t(I),t(Te),t(Je),t(C),t(be),t(_),t(fe),t(je),t(B),t(Ue),t(Ie),t(ge),t(Z),t(Ce),t(_e),t(x),t(ke),t(Be),t(E),t(ve),t(W),t(Ae),t($),t(Ze),t(Y),t(Ge),t(R),t(xe),t(He),t(V),t(Ee),t(Q),t(We),t(S),t($e),t(F),t(Ye),t(L),t(Re),t(Xe),t(N),t(Ve),t(Qe),t(P),t(Se),t(Fe),t(Le),t(O),t(ze),t(ee),t(Ne),t(qe),t(w),t(Pe),t(Ke),t(T),t(De),t(Oe),t(se),t(el),t(ll),t(ie),t(tl),t(oe),t(al),t(pe)),t(u),m(J,e),m(g,e),m(k,e),m(v,e),m(A,e),m(G,e),m(H,e),m(X,e),m(z,e),m(q,e),m(K,e),m(D,e),m(le,e),m(te,e),m(ae,e),m(ne,e)}}}const Ll='{"title":"Integrate any ML framework with the Hub","local":"integrate-any-ml-framework-with-the-hub","sections":[{"title":"A flexible approach: helpers","local":"a-flexible-approach-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"A more complex approach: class inheritance","local":"a-more-complex-approach-class-inheritance","sections":[{"title":"A concrete example: PyTorch","local":"a-concrete-example-pytorch","sections":[{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":4},{"title":"Implementation","local":"implementation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Quick comparison","local":"quick-comparison","sections":[],"depth":2}],"depth":1}';function zl(il){return Yl(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Sl}),[]}class Dl extends Rl{constructor(u){super(),Xl(this,u,zl,Fl,Wl,{})}}export{Dl as component};
