import{s as on,o as dn,n as Ve}from"../chunks/scheduler.b108d059.js";import{S as pn,i as hn,g as r,s as i,r as h,A as un,h as o,f as t,c as l,j as rn,u,x as p,k as He,y as mn,a as s,v as m,d as c,t as w,w as b}from"../chunks/index.008de539.js";import{H as K,g as cn}from"../chunks/Heading.a68af760.js";import{T as Ye}from"../chunks/Tip.aeb15ab7.js";import{C as ne}from"../chunks/CodeBlock.3968c746.js";function wn(y){let a,M='Um ein Beispiel eines laufenden Webhook-Servers zu sehen, werfen Sie einen Blick auf den <a href="https://huggingface.co/spaces/spaces-ci-bot/webhook" rel="nofollow">Spaces CI Bot</a>. Es handelt sich um einen Space, der kurzlebige Umgebungen startet, wenn ein PR in einem Space geöffnet wird.';return{c(){a=r("p"),a.innerHTML=M},l(d){a=o(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-w4ryxe"&&(a.innerHTML=M)},m(d,f){s(d,a,f)},p:Ve,d(d){d&&t(a)}}}function bn(y){let a,M='Dies ist ein <a href="../package_reference/environment_variables#hfhubdisableexperimentalwarning">experimentelles Feature</a>. Das bedeutet, dass wir noch daran arbeiten, die API zu verbessern. Es könnten in der Zukunft ohne vorherige Ankündigung Änderungen vorgenommen werden. Stellen Sie sicher, dass Sie die Version des <code>huggingface_hub</code> in Ihren Anforderungen festlegen.';return{c(){a=r("p"),a.innerHTML=M},l(d){a=o(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-qkpblx"&&(a.innerHTML=M)},m(d,f){s(d,a,f)},p:Ve,d(d){d&&t(a)}}}function Mn(y){let a,M="Standardmäßig wird der Server am Ende Ihres Skripts gestartet. Wenn Sie es in einem Notizbuch ausführen, können Sie den Server manuell starten, indem Sie <code>decorated_function.run()</code> aufrufen. Da ein einzigartiger Server verwendet wird, müssen Sie den Server nur einmal starten, auch wenn Sie mehrere Endpunkte haben.";return{c(){a=r("p"),a.innerHTML=M},l(d){a=o(d,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1w9mmrp"&&(a.innerHTML=M)},m(d,f){s(d,a,f)},p:Ve,d(d){d&&t(a)}}}function fn(y){let a,M,d,f,U,te,S,Ee='Webhooks sind ein Grundpfeiler für MLOps-bezogene Funktionen. Sie ermöglichen es Ihnen, auf neue Änderungen in bestimmten Repos oder auf alle Repos, die bestimmten Benutzern/Organisationen gehören, die Sie interessieren, zu hören. Dieser Leitfaden erklärt, wie Sie den <code>huggingface_hub</code> nutzen können, um einen Server zu erstellen, der auf Webhooks hört und ihn in einen Space zu implementieren. Es wird davon ausgegangen, dass Sie mit dem Konzept der Webhooks auf dem Huggingface Hub vertraut sind. Um mehr über Webhooks selbst zu erfahren, können Sie zuerst diesen <a href="https://huggingface.co/docs/hub/webhooks" rel="nofollow">Leitfaden</a> lesen.',se,j,_e="Die Basis-Klasse, die wir in diesem Leitfaden verwenden werden, ist der <code>WebhooksServer()</code>. Es handelt sich um eine Klasse, mit der sich ein Server leicht konfigurieren lässt, der Webhooks vom Huggingface Hub empfangen kann. Der Server basiert auf einer Gradio-App. Er verfügt über eine Benutzeroberfläche zur Anzeige von Anweisungen für Sie oder Ihre Benutzer und eine API zum Hören auf Webhooks.",ie,k,le,g,ae,W,re,I,Re="Das Implementieren eines Webhook-Endpunkts ist so einfach wie das Dekorieren einer Funktion. Lassen Sie uns ein erstes Beispiel betrachten, um die Hauptkonzepte zu erklären:",oe,v,de,B,Fe="Speichern Sie diesen Ausschnitt in einer Datei namens <code>&#39;app.py&#39;</code> und führen Sie ihn mit <code>&#39;python app.py&#39;</code> aus. Sie sollten eine Nachricht wie diese sehen:",pe,Z,he,z,Qe="Gute Arbeit! Sie haben gerade einen Webhook-Server gestartet! Lassen Sie uns genau aufschlüsseln, was passiert ist:",ue,$,Le='<li>Durch das Dekorieren einer Funktion mit <code>webhook_endpoint()</code> wurde im Hintergrund ein <code>WebhooksServer()</code>-Objekt erstellt. Wie Sie sehen können, handelt es sich bei diesem Server um eine Gradio-App, die unter <a href="http://127.0.0.1:7860" rel="nofollow">http://127.0.0.1:7860</a> läuft. Wenn Sie diese URL in Ihrem Browser öffnen, sehen Sie eine Landing Page mit Anweisungen zu den registrierten Webhooks.</li> <li>Eine Gradio-App ist im Kern ein FastAPI-Server. Eine neue POST-Route <code>/webhooks/trigger_training</code> wurde hinzugefügt. Dies ist die Route, die auf Webhooks hört und die Funktion <code>trigger_training</code> ausführt, wenn sie ausgelöst wird. FastAPI wird das Payload automatisch parsen und es der Funktion als <code>WebhookPayload</code>-Objekt übergeben. Dies ist ein <code>pydantisches</code> Objekt, das alle Informationen über das Ereignis enthält, das den Webhook ausgelöst hat.</li> <li>Die Gradio-App hat auch einen Tunnel geöffnet, um Anfragen aus dem Internet zu empfangen. Das Interessante daran ist: Sie können einen Webhook auf <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a> konfigurieren, der auf Ihren lokalen Rechner zeigt. Dies ist nützlich zum Debuggen Ihres Webhook-Servers und zum schnellen Iterieren, bevor Sie ihn in einem Space bereitstellen.</li> <li>Schließlich teilen Ihnen die Logs auch mit, dass Ihr Server derzeit nicht durch ein Geheimnis gesichert ist. Dies ist für das lokale Debuggen nicht problematisch, sollte aber für später berücksichtigt werden.</li>',me,J,ce,G,we,C,Xe=`Jetzt, da Sie einen Webhook-Server am Laufen haben, möchten Sie einen Webhook konfigurieren, um Nachrichten zu empfangen.
Gehen Sie zu <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a>, klicken Sie auf “Add a new webhook” und konfigurieren Sie Ihren Webhook. Legen Sie die Ziel-Repositories fest, die Sie beobachten möchten, und die Webhook-URL, hier <code>https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training</code>.`,be,T,Ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/configure_webhook.png"/>',Me,H,xe="Und das war’s! Sie können den Webhook jetzt auslösen, indem Sie das Ziel-Repository aktualisieren (z.B. einen Commit pushen). Überprüfen Sie den Aktivitäts-Tab Ihres Webhooks, um die ausgelösten Ereignisse zu sehen. Jetzt, wo Sie eine funktionierende Einrichtung haben, können Sie sie testen und schnell iterieren. Wenn Sie Ihren Code ändern und den Server neu starten, könnte sich Ihre öffentliche URL ändern. Stellen Sie sicher, dass Sie die Webhook-Konfiguration im Hub bei Bedarf aktualisieren.",fe,Y,ye,V,De='Jetzt, da Sie einen funktionierenden Webhook-Server haben, ist das Ziel, ihn in einem Space bereitzustellen. Gehen Sie zu <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>, um einen Space zu erstellen. Geben Sie ihm einen Namen, wählen Sie das Gradio SDK und klicken Sie auf “Create Space”. Laden Sie Ihren Code in den Space in einer Datei namens <code>app.py</code> hoch. Ihr Space wird automatisch gestartet! Für weitere Informationen zu Spaces lesen Sie bitte diesen <a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">Leitfaden</a>.',ke,E,Pe='Ihr Webhook-Server läuft nun auf einem öffentlichen Space. In den meisten Fällen möchten Sie ihn mit einem Geheimnis absichern. Gehen Sie zu Ihren Space-Einstellungen &gt; Abschnitt “Repository secrets” &gt; “Add a secret”. Setzen Sie die Umgebungsvariable <code>WEBHOOK_SECRET</code> auf den von Ihnen gewählten Wert. Gehen Sie zurück zu den <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Webhook-Einstellungen</a> und setzen Sie das Geheimnis in der Webhook-Konfiguration. Jetzt werden von Ihrem Server nur Anfragen mit dem korrekten Geheimnis akzeptiert.',ge,_,Ae='Und das war’s! Ihr Space ist nun bereit, Webhooks vom Hub zu empfangen. Bitte beachten Sie, dass wenn Sie den Space auf einer kostenlosen ‘cpu-basic’ Hardware ausführen, er nach 48 Stunden Inaktivität heruntergefahren wird. Wenn Sie einen permanenten Space benötigen, sollten Sie in Erwägung ziehen, auf eine <a href="https://huggingface.co/docs/hub/spaces-gpus#hardware-specs" rel="nofollow">upgraded hardware</a> umzustellen.',Je,R,Te,F,qe="Der obenstehende Leitfaden erklärte den schnellsten Weg, einen <code>WebhooksServer()</code> einzurichten. In diesem Abschnitt werden wir sehen, wie man ihn weiter anpassen kann.",Ue,Q,Se,L,Oe="Sie können mehrere Endpunkte auf demselben Server registrieren. Beispielsweise möchten Sie vielleicht einen Endpunkt haben, um einen Trainingsjob auszulösen und einen anderen, um eine Modellevaluierung auszulösen. Dies können Sie tun, indem Sie mehrere <code>@webhook_endpoint</code>-Dekorateure hinzufügen:",je,X,We,N,Ke="Dies wird zwei Endpunkte erstellen:",Ie,x,ve,D,Be,P,en='Um mehr Flexibilität zu erhalten, können Sie auch direkt ein <code>WebhooksServer()</code> Objekt erstellen. Dies ist nützlich, wenn Sie die Startseite Ihres Servers anpassen möchten. Sie können dies tun, indem Sie eine <a href="https://gradio.app/docs/#blocks" rel="nofollow">Gradio UI</a> übergeben, die die Standard-UI überschreibt. Zum Beispiel können Sie Anweisungen für Ihre Benutzer hinzufügen oder ein Formular zur manuellen Auslösung der Webhooks hinzufügen. Bei der Erstellung eines <code>WebhooksServer()</code> können Sie mit dem Dekorateur <code>add_webhook()</code> neue Webhooks registrieren.',Ze,A,nn="Hier ist ein vollständiges Beispiel:",ze,q,$e,O,tn="<li>Wir definieren eine benutzerdefinierte UI mit Gradio-Blöcken. Diese UI wird auf der Startseite des Servers angezeigt.</li> <li>Wir erstellen ein <code>WebhooksServer()</code>-Objekt mit einer benutzerdefinierten UI und einem Geheimnis. Das Geheimnis ist optional und kann mit der <code>WEBHOOK_SECRET</code> Umgebungsvariable gesetzt werden.</li> <li>Wir registrieren einen Webhook mit einem expliziten Namen. Dies wird einen Endpunkt unter <code>/webhooks/say_hello</code> erstellen.</li> <li>Wir registrieren einen Webhook mit einem impliziten Namen. Dies wird einen Endpunkt unter <code>/webhooks/goodbye</code> erstellen.</li> <li>Wir starten den Server. Dies ist optional, da Ihr Server automatisch am Ende des Skripts gestartet wird.</li>",Ge,ee,Ce;return U=new K({props:{title:"Webhooks Server",local:"webhooks-server",headingTag:"h1"}}),k=new Ye({props:{$$slots:{default:[wn]},$$scope:{ctx:y}}}),g=new Ye({props:{warning:!0,$$slots:{default:[bn]},$$scope:{ctx:y}}}),W=new K({props:{title:"Einen Endpunkt erstellen",local:"einen-endpunkt-erstellen",headingTag:"h2"}}),v=new ne({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEVpbmVuJTIwVHJhaW5pbmdzam9iJTIwYXVzbCVDMyVCNnNlbiUyQyUyMHdlbm4lMjBlaW4lMjBEYXRlbnNhdHolMjBha3R1YWxpc2llcnQlMjB3aXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Einen Trainingsjob auslösen, wenn ein Datensatz aktualisiert wird</span>
        ...`,wrap:!1}}),Z=new ne({props:{code:"V2ViaG9vayUyMHNlY3JldCUyMGlzJTIwbm90JTIwZGVmaW5lZC4lMjBUaGlzJTIwbWVhbnMlMjB5b3VyJTIwd2ViaG9vayUyMGVuZHBvaW50cyUyMHdpbGwlMjBiZSUyMG9wZW4lMjB0byUyMGV2ZXJ5b25lLiUwQVRvJTIwYWRkJTIwYSUyMHNlY3JldCUyQyUyMHNldCUyMCU2MFdFQkhPT0tfU0VDUkVUJTYwJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwb3IlMjBwYXNzJTIwaXQlMjBhdCUyMGluaXRpYWxpemF0aW9uJTNBJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTYwYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIod2ViaG9va19zZWNyZXQlM0QnbXlfc2VjcmV0JyUyQyUyMC4uLiklNjAlMEFGb3IlMjBtb3JlJTIwZGV0YWlscyUyMGFib3V0JTIwd2ViaG9vayUyMHNlY3JldHMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZ3ZWJob29rcyUyM3dlYmhvb2stc2VjcmV0LiUwQVJ1bm5pbmclMjBvbiUyMGxvY2FsJTIwVVJMJTNBJTIwJTIwaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTc4NjAlMEFSdW5uaW5nJTIwb24lMjBwdWJsaWMlMjBVUkwlM0ElMjBodHRwcyUzQSUyRiUyRjFmYWRiMGY1MmQ4YmY4MjVmYy5ncmFkaW8ubGl2ZSUwQSUwQVRoaXMlMjBzaGFyZSUyMGxpbmslMjBleHBpcmVzJTIwaW4lMjA3MiUyMGhvdXJzLiUyMEZvciUyMGZyZWUlMjBwZXJtYW5lbnQlMjBob3N0aW5nJTIwYW5kJTIwR1BVJTIwdXBncmFkZXMlMjAoTkVXISklMkMlMjBjaGVjayUyMG91dCUyMFNwYWNlcyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMEElMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEFHbyUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNldHRpbmdzJTJGd2ViaG9va3MlMjB0byUyMHNldHVwJTIweW91ciUyMHdlYmhvb2tzLg==",highlighted:`Webhook secret is not defined. This means your webhook endpoints will be open to everyone.
To add a secret, set \`WEBHOOK_SECRET\` as environment variable or pass it at initialization: 
        \`app = WebhooksServer(webhook_secret=&#x27;my_secret&#x27;, ...)\`
For more details about webhook secrets, please refer to https://huggingface.co/docs/hub/webhooks#webhook-secret.
Running on local URL:  http://127.0.0.1:7860
Running on public URL: https://1fadb0f52d8bf825fc.gradio.live

This share link expires in 72 hours. For free permanent hosting and GPU upgrades (NEW!), check out Spaces: https://huggingface.co/spaces

Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
Go to https://huggingface.co/settings/webhooks to setup your webhooks.`,wrap:!1}}),J=new Ye({props:{warning:!0,$$slots:{default:[Mn]},$$scope:{ctx:y}}}),G=new K({props:{title:"Konfigurieren eines Webhook",local:"konfigurieren-eines-webhook",headingTag:"h2"}}),Y=new K({props:{title:"Bereitstellung in einem Space",local:"bereitstellung-in-einem-space",headingTag:"h2"}}),R=new K({props:{title:"Erweiterte Nutzung",local:"erweiterte-nutzung",headingTag:"h2"}}),Q=new K({props:{title:"Mehrere Endpunkte",local:"mehrere-endpunkte",headingTag:"h3"}}),X=new ne({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEVpbmVuJTIwVHJhaW5pbmdzam9iJTIwYXVzbCVDMyVCNnNlbiUyQyUyMHdlbm4lMjBlaW4lMjBEYXRlbnNhdHolMjBha3R1YWxpc2llcnQlMjB3aXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTQwd2ViaG9va19lbmRwb2ludCUwQWFzeW5jJTIwZGVmJTIwdHJpZ2dlcl9ldmFsdWF0aW9uKHBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGF5bG9hZC5yZXBvLnR5cGUlMjAlM0QlM0QlMjAlMjJtb2RlbCUyMiUyMGFuZCUyMHBheWxvYWQuZXZlbnQuYWN0aW9uJTIwJTNEJTNEJTIwJTIydXBkYXRlJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRWluZW4lMjBFdmFsdWllcnVuZ3NhdWZ0cmFnJTIwYXVzbCVDMyVCNnNlbiUyQyUyMHdlbm4lMjBlaW4lMjBNb2RlbGwlMjBha3R1YWxpc2llcnQlMjB3aXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Einen Trainingsjob auslösen, wenn ein Datensatz aktualisiert wird</span>
        ...

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_evaluation</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;model&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Einen Evaluierungsauftrag auslösen, wenn ein Modell aktualisiert wird</span>
        ...`,wrap:!1}}),x=new ne({props:{code:"KC4uLiklMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEElMjAlMjAtJTIwUE9TVCUyMGh0dHBzJTNBJTJGJTJGMWZhZGIwZjUyZDhiZjgyNWZjLmdyYWRpby5saXZlJTJGd2ViaG9va3MlMkZ0cmlnZ2VyX2V2YWx1YXRpb24=",highlighted:`(...)
Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_evaluation`,wrap:!1}}),D=new K({props:{title:"Benutzerdefinierter Server",local:"benutzerdefinierter-server",headingTag:"h3"}}),q=new ne({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBXZWJob29rc1NlcnZlciUyQyUyMFdlYmhvb2tQYXlsb2FkJTBBJTBBJTIzJTIwMS4lMjBCZW51dHplcmRlZmluaWVydGUlMjBVSSUyMGRlZmluaWVyZW4lMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMHVpJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTIzJTIwMi4lMjBFcnN0ZWxsZW4lMjBlaW5lcyUyMFdlYmhvb2tzU2VydmVyJTIwbWl0JTIwYmVudXR6ZXJkZWZpbmllcnRlciUyMFVJJTIwdW5kJTIwR2VoZWltbmlzJTBBYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIodWklM0R1aSUyQyUyMHdlYmhvb2tfc2VjcmV0JTNEJTIybXlfc2VjcmV0X2tleSUyMiklMEElMEElMjMlMjAzLiUyMFdlYmhvb2slMjBtaXQlMjBleHBsaXppdGVtJTIwTmFtZW4lMjByZWdpc3RyaWVyZW4lMEElNDBhcHAuYWRkX3dlYmhvb2soJTIyJTJGc2F5X2hlbGxvJTIyKSUwQWFzeW5jJTIwZGVmJTIwaGVsbG8ocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJoZWxsbyUyMiU3RCUwQSUwQSUyMyUyMDQuJTIwV2ViaG9vayUyMG1pdCUyMGltcGxpeml0ZW0lMjBOYW1lbiUyMHJlZ2lzdHJpZXJlbmUlMEElNDBhcHAuYWRkX3dlYmhvb2slMEFhc3luYyUyMGRlZiUyMGdvb2RieWUocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJnb29kYnllJTIyJTdEJTBBJTBBJTIzJTIwNS4lMjBTZXJ2ZXIlMjBzdGFydGVuJTIwKG9wdGlvbmFsKSUwQWFwcC5ydW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> WebhooksServer, WebhookPayload

<span class="hljs-comment"># 1. Benutzerdefinierte UI definieren</span>
<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> ui:
    ...

<span class="hljs-comment"># 2. Erstellen eines WebhooksServer mit benutzerdefinierter UI und Geheimnis</span>
app = WebhooksServer(ui=ui, webhook_secret=<span class="hljs-string">&quot;my_secret_key&quot;</span>)

<span class="hljs-comment"># 3. Webhook mit explizitem Namen registrieren</span>
<span class="hljs-meta">@app.add_webhook(<span class="hljs-params"><span class="hljs-string">&quot;/say_hello&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">hello</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;hello&quot;</span>}

<span class="hljs-comment"># 4. Webhook mit implizitem Namen registrierene</span>
<span class="hljs-meta">@app.add_webhook</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">goodbye</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;goodbye&quot;</span>}

<span class="hljs-comment"># 5. Server starten (optional)</span>
app.run()`,wrap:!1}}),{c(){a=r("meta"),M=i(),d=r("p"),f=i(),h(U.$$.fragment),te=i(),S=r("p"),S.innerHTML=Ee,se=i(),j=r("p"),j.innerHTML=_e,ie=i(),h(k.$$.fragment),le=i(),h(g.$$.fragment),ae=i(),h(W.$$.fragment),re=i(),I=r("p"),I.textContent=Re,oe=i(),h(v.$$.fragment),de=i(),B=r("p"),B.innerHTML=Fe,pe=i(),h(Z.$$.fragment),he=i(),z=r("p"),z.textContent=Qe,ue=i(),$=r("ol"),$.innerHTML=Le,me=i(),h(J.$$.fragment),ce=i(),h(G.$$.fragment),we=i(),C=r("p"),C.innerHTML=Xe,be=i(),T=r("div"),T.innerHTML=Ne,Me=i(),H=r("p"),H.textContent=xe,fe=i(),h(Y.$$.fragment),ye=i(),V=r("p"),V.innerHTML=De,ke=i(),E=r("p"),E.innerHTML=Pe,ge=i(),_=r("p"),_.innerHTML=Ae,Je=i(),h(R.$$.fragment),Te=i(),F=r("p"),F.innerHTML=qe,Ue=i(),h(Q.$$.fragment),Se=i(),L=r("p"),L.innerHTML=Oe,je=i(),h(X.$$.fragment),We=i(),N=r("p"),N.textContent=Ke,Ie=i(),h(x.$$.fragment),ve=i(),h(D.$$.fragment),Be=i(),P=r("p"),P.innerHTML=en,Ze=i(),A=r("p"),A.textContent=nn,ze=i(),h(q.$$.fragment),$e=i(),O=r("ol"),O.innerHTML=tn,Ge=i(),ee=r("p"),this.h()},l(e){const n=un("svelte-u9bgzb",document.head);a=o(n,"META",{name:!0,content:!0}),n.forEach(t),M=l(e),d=o(e,"P",{}),rn(d).forEach(t),f=l(e),u(U.$$.fragment,e),te=l(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-syi17b"&&(S.innerHTML=Ee),se=l(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-16brqny"&&(j.innerHTML=_e),ie=l(e),u(k.$$.fragment,e),le=l(e),u(g.$$.fragment,e),ae=l(e),u(W.$$.fragment,e),re=l(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-dy9hz4"&&(I.textContent=Re),oe=l(e),u(v.$$.fragment,e),de=l(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1udi1nb"&&(B.innerHTML=Fe),pe=l(e),u(Z.$$.fragment,e),he=l(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1tlyxs6"&&(z.textContent=Qe),ue=l(e),$=o(e,"OL",{"data-svelte-h":!0}),p($)!=="svelte-wf7tf8"&&($.innerHTML=Le),me=l(e),u(J.$$.fragment,e),ce=l(e),u(G.$$.fragment,e),we=l(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1o96wi4"&&(C.innerHTML=Xe),be=l(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-9ld38f"&&(T.innerHTML=Ne),Me=l(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-l7w1xv"&&(H.textContent=xe),fe=l(e),u(Y.$$.fragment,e),ye=l(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ncmk3a"&&(V.innerHTML=De),ke=l(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1nxol3z"&&(E.innerHTML=Pe),ge=l(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1e7nrwh"&&(_.innerHTML=Ae),Je=l(e),u(R.$$.fragment,e),Te=l(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-8cnaqu"&&(F.innerHTML=qe),Ue=l(e),u(Q.$$.fragment,e),Se=l(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1kzmtha"&&(L.innerHTML=Oe),je=l(e),u(X.$$.fragment,e),We=l(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-biux1g"&&(N.textContent=Ke),Ie=l(e),u(x.$$.fragment,e),ve=l(e),u(D.$$.fragment,e),Be=l(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-5oiksx"&&(P.innerHTML=en),Ze=l(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-qjuq0f"&&(A.textContent=nn),ze=l(e),u(q.$$.fragment,e),$e=l(e),O=o(e,"OL",{"data-svelte-h":!0}),p(O)!=="svelte-styu22"&&(O.innerHTML=tn),Ge=l(e),ee=o(e,"P",{}),rn(ee).forEach(t),this.h()},h(){He(a,"name","hf:doc:metadata"),He(a,"content",yn),He(T,"class","flex justify-center")},m(e,n){mn(document.head,a),s(e,M,n),s(e,d,n),s(e,f,n),m(U,e,n),s(e,te,n),s(e,S,n),s(e,se,n),s(e,j,n),s(e,ie,n),m(k,e,n),s(e,le,n),m(g,e,n),s(e,ae,n),m(W,e,n),s(e,re,n),s(e,I,n),s(e,oe,n),m(v,e,n),s(e,de,n),s(e,B,n),s(e,pe,n),m(Z,e,n),s(e,he,n),s(e,z,n),s(e,ue,n),s(e,$,n),s(e,me,n),m(J,e,n),s(e,ce,n),m(G,e,n),s(e,we,n),s(e,C,n),s(e,be,n),s(e,T,n),s(e,Me,n),s(e,H,n),s(e,fe,n),m(Y,e,n),s(e,ye,n),s(e,V,n),s(e,ke,n),s(e,E,n),s(e,ge,n),s(e,_,n),s(e,Je,n),m(R,e,n),s(e,Te,n),s(e,F,n),s(e,Ue,n),m(Q,e,n),s(e,Se,n),s(e,L,n),s(e,je,n),m(X,e,n),s(e,We,n),s(e,N,n),s(e,Ie,n),m(x,e,n),s(e,ve,n),m(D,e,n),s(e,Be,n),s(e,P,n),s(e,Ze,n),s(e,A,n),s(e,ze,n),m(q,e,n),s(e,$e,n),s(e,O,n),s(e,Ge,n),s(e,ee,n),Ce=!0},p(e,[n]){const sn={};n&2&&(sn.$$scope={dirty:n,ctx:e}),k.$set(sn);const ln={};n&2&&(ln.$$scope={dirty:n,ctx:e}),g.$set(ln);const an={};n&2&&(an.$$scope={dirty:n,ctx:e}),J.$set(an)},i(e){Ce||(c(U.$$.fragment,e),c(k.$$.fragment,e),c(g.$$.fragment,e),c(W.$$.fragment,e),c(v.$$.fragment,e),c(Z.$$.fragment,e),c(J.$$.fragment,e),c(G.$$.fragment,e),c(Y.$$.fragment,e),c(R.$$.fragment,e),c(Q.$$.fragment,e),c(X.$$.fragment,e),c(x.$$.fragment,e),c(D.$$.fragment,e),c(q.$$.fragment,e),Ce=!0)},o(e){w(U.$$.fragment,e),w(k.$$.fragment,e),w(g.$$.fragment,e),w(W.$$.fragment,e),w(v.$$.fragment,e),w(Z.$$.fragment,e),w(J.$$.fragment,e),w(G.$$.fragment,e),w(Y.$$.fragment,e),w(R.$$.fragment,e),w(Q.$$.fragment,e),w(X.$$.fragment,e),w(x.$$.fragment,e),w(D.$$.fragment,e),w(q.$$.fragment,e),Ce=!1},d(e){e&&(t(M),t(d),t(f),t(te),t(S),t(se),t(j),t(ie),t(le),t(ae),t(re),t(I),t(oe),t(de),t(B),t(pe),t(he),t(z),t(ue),t($),t(me),t(ce),t(we),t(C),t(be),t(T),t(Me),t(H),t(fe),t(ye),t(V),t(ke),t(E),t(ge),t(_),t(Je),t(Te),t(F),t(Ue),t(Se),t(L),t(je),t(We),t(N),t(Ie),t(ve),t(Be),t(P),t(Ze),t(A),t(ze),t($e),t(O),t(Ge),t(ee)),t(a),b(U,e),b(k,e),b(g,e),b(W,e),b(v,e),b(Z,e),b(J,e),b(G,e),b(Y,e),b(R,e),b(Q,e),b(X,e),b(x,e),b(D,e),b(q,e)}}}const yn='{"title":"Webhooks Server","local":"webhooks-server","sections":[{"title":"Einen Endpunkt erstellen","local":"einen-endpunkt-erstellen","sections":[],"depth":2},{"title":"Konfigurieren eines Webhook","local":"konfigurieren-eines-webhook","sections":[],"depth":2},{"title":"Bereitstellung in einem Space","local":"bereitstellung-in-einem-space","sections":[],"depth":2},{"title":"Erweiterte Nutzung","local":"erweiterte-nutzung","sections":[{"title":"Mehrere Endpunkte","local":"mehrere-endpunkte","sections":[],"depth":3},{"title":"Benutzerdefinierter Server","local":"benutzerdefinierter-server","sections":[],"depth":3}],"depth":2}],"depth":1}';function kn(y){return dn(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=cn}),[]}class jn extends pn{constructor(a){super(),hn(this,a,kn,fn,on,{})}}export{jn as component};
