import{s as Gn,o as Zn,n as Un}from"../chunks/scheduler.b108d059.js";import{S as Sn,i as In,g as h,s as i,r as a,A as zn,h as g,f as n,c as l,j as Rn,u as r,x as u,k as _n,y as Hn,a as s,v as p,d as o,t as m,w as d}from"../chunks/index.008de539.js";import{H as f,g as Cn}from"../chunks/Heading.77003eeb.js";import{T as Xn}from"../chunks/Tip.aeb15ab7.js";import{C as y}from"../chunks/CodeBlock.3968c746.js";function xn(ze){let c,M='Wenn Sie es gewohnt sind, mit Plattformen wie GitLab/GitHub/Bitbucket zu arbeiten, könnte Ihr erster Instinkt sein, die <code>git</code> CLI zu verwenden, um Ihr Repo zu klonen (<code>git clone</code>), Änderungen zu übernehmen (<code>git add</code>, <code>git commit</code>) und diese hochzuladen (<code>git push</code>). Dies ist beim Verwenden des Hugging Face Hubs gültig. Softwareentwicklung und maschinelles Lernen haben jedoch nicht dieselben Anforderungen und Arbeitsabläufe. Modell-Repositories könnten große Modellgewichtsdateien für verschiedene Frameworks und Tools beinhalten, sodass das Klonen des Repositories dazu führen kann, dass Sie große lokale Ordner mit massiven Größen pflegen. Daher kann es effizienter sein, unsere benutzerdefinierten HTTP-Methoden zu verwenden. Sie können unsere <a href="../concepts/git_vs_http">Git vs HTTP Paradigma</a> Erklärungsseite für weitere Details lesen.';return{c(){c=h("p"),c.innerHTML=M},l($){c=g($,"P",{"data-svelte-h":!0}),u(c)!=="svelte-14ddv59"&&(c.innerHTML=M)},m($,Se){s($,c,Se)},p:Un,d($){$&&n(c)}}}function Bn(ze){let c,M,$,Se,w,He,v,Pt='Das Hugging Face Hub besteht aus einer Sammlung von Git-Repositories. <a href="https://git-scm.com/" rel="nofollow">Git</a> ist ein in der Softwareentwicklung weit verbreitetes Tool, um Projekte bei der Zusammenarbeit einfach zu versionieren. Dieser Leitfaden zeigt Ihnen, wie Sie mit den Repositories auf dem Hub interagieren, insbesondere:',Ce,T,Qt="<li>Ein Repository erstellen und löschen.</li> <li>Zweige (Branches) und Tags verwalten.</li> <li>Ihr Repository umbenennen.</li> <li>Die Sichtbarkeit Ihres Repositories aktualisieren.</li> <li>Eine lokale Kopie Ihres Repositories verwalten.</li>",Xe,b,xe,k,Dt='Wenn Sie ein Repository auf dem Hub erstellen und verwalten möchten, muss Ihr Computer angemeldet sein. Wenn Sie es nicht sind, beziehen Sie sich bitte auf <a href="../quick-start#login">diesen Abschnitt</a>. Im Rest dieses Leitfadens gehen wir davon aus, dass Ihr Computer angemeldet ist.',Be,j,Ye,J,At="Der erste Schritt besteht darin, zu wissen, wie man Repositories erstellt und löscht. Sie können nur Repositories verwalten, die Ihnen gehören (unter Ihrem Benutzernamensraum) oder von Organisationen, in denen Sie Schreibberechtigungen haben.",Le,R,qe,_,Kt="Erstellen Sie ein leeres Repository mit <code>create_repo()</code> und geben Sie ihm mit dem Parameter <code>repo_id</code> einen Namen. Die <code>repo_id</code> ist Ihr Namensraum gefolgt vom Repository-Namen: <code>username_or_org/repo_name</code>.",Fe,G,We,Z,Ot="Standardmäßig erstellt <code>create_repo()</code> ein Modellrepository. Sie können jedoch den Parameter <code>repo_type</code> verwenden, um einen anderen Repository-Typ anzugeben. Wenn Sie beispielsweise ein Dataset-Repository erstellen möchten:",Ne,U,Ve,S,en="Wenn Sie ein Repository erstellen, können Sie mit dem Parameter <code>private</code> die Sichtbarkeit Ihres Repositories festlegen.",Ee,I,Pe,z,tn="Wenn Sie die Sichtbarkeit des Repositories zu einem späteren Zeitpunkt ändern möchten, können Sie die Funktion <code>update_repo_visibility()</code> verwenden.",Qe,H,De,C,nn="Löschen Sie ein Repository mit <code>delete_repo()</code>. Stellen Sie sicher, dass Sie ein Repository löschen möchten, da dieser Vorgang unwiderruflich ist!",Ae,X,sn="Geben Sie die <code>repo_id</code> des Repositories an, das Sie löschen möchten:",Ke,x,Oe,B,et,Y,ln=`In einigen Fällen möchten Sie möglicherweise das Repo von jemand anderem kopieren, um es an Ihren Anwendungsfall anzupassen. Dies ist für Spaces mit der Methode <code>duplicate_space()</code> möglich. Es wird das gesamte Repository dupliziert.
Sie müssen jedoch noch Ihre eigenen Einstellungen konfigurieren (Hardware, Schlafzeit, Speicher, Variablen und Geheimnisse). Weitere Informationen finden Sie in unserem Leitfaden <a href="./manage-spaces">Verwalten Ihres Spaces</a>.`,tt,L,nt,q,st,F,an="Jetzt, wo Sie Ihr Repository erstellt haben, möchten Sie Änderungen daran vornehmen und Dateien daraus herunterladen.",it,W,rn='Diese 2 Themen verdienen ihre eigenen Leitfäden. Bitte beziehen Sie sich auf die <a href="./upload">Hochladen</a> und die <a href="./download">Herunterladen</a> Leitfäden, um zu erfahren, wie Sie Ihr Repository verwenden können.',lt,N,at,V,pn=`Git-Repositories verwenden oft Branches, um verschiedene Versionen eines gleichen Repositories zu speichern.
Tags können auch verwendet werden, um einen bestimmten Zustand Ihres Repositories zu kennzeichnen, z. B. bei der Veröffentlichung einer Version.
Allgemeiner gesagt, werden Branches und Tags als <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References" rel="nofollow">git-Referenzen</a> bezeichnet.`,rt,E,pt,P,on="Sie können neue Branches und Tags mit <code>create_branch()</code> und <code>create_tag()</code> erstellen:",ot,Q,mt,D,mn="Sie können die Funktionen <code>delete_branch()</code> und <code>delete_tag()</code> auf die gleiche Weise verwenden, um einen Branch oder einen Tag zu löschen.",dt,A,ht,K,dn="Sie können auch die vorhandenen git-Referenzen von einem Repository mit <code>list_repo_refs()</code> auflisten:",gt,O,ut,ee,ct,te,hn="Repositories verfügen über einige Einstellungen, die Sie konfigurieren können. Die meiste Zeit möchten Sie dies manuell auf der Repo-Einstellungsseite in Ihrem Browser tun. Sie müssen Schreibzugriff auf ein Repo haben, um es zu konfigurieren (entweder besitzen oder Teil einer Organisation sein). In diesem Abschnitt werden wir die Einstellungen sehen, die Sie auch programmgesteuert mit <code>huggingface_hub</code> konfigurieren können.",ft,ne,gn='Einige Einstellungen sind spezifisch für Spaces (Hardware, Umgebungsvariablen,…). Um diese zu konfigurieren, lesen Sie bitte unseren <a href="../guides/manage-spaces">Verwalten Ihres Spaces</a> Leitfaden.',yt,se,$t,ie,un="Ein Repository kann öffentlich oder privat sein. Ein privates Repository ist nur für Sie oder die Mitglieder der Organisation sichtbar, in der das Repository sich befindet. Ändern Sie ein Repository wie im Folgenden gezeigt in ein privates:",bt,le,Mt,ae,wt,re,cn='Sie können Ihr Repository auf dem Hub mit [`move_repo] umbenennen. Mit dieser Methode können Sie das Repo auch von einem Benutzer zu einer Organisation verschieben. Dabei gibt es <a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">einige Einschränkungen</a>, die Sie beachten sollten. Zum Beispiel können Sie Ihr Repo nicht an einen anderen Benutzer übertragen.',vt,pe,Tt,oe,kt,me,fn="Alle oben beschriebenen Aktionen können mit HTTP-Anfragen durchgeführt werden. In einigen Fällen möchten Sie jedoch vielleicht eine lokale Kopie Ihres Repositories haben und damit interagieren, indem Sie die Git-Befehle verwenden, die Sie kennen.",jt,de,yn='Die <code>Repository()</code> Klasse ermöglicht es Ihnen, mit Dateien und Repositories auf dem Hub mit Funktionen zu interagieren, die Git-Befehlen ähneln. Es ist ein Wrapper über Git und Git-LFS-Methoden, um die Git-Befehle zu verwenden, die Sie bereits kennen und lieben. Stellen Sie vor dem Start sicher, dass Sie Git-LFS installiert haben (siehe <a href="https://git-lfs.github.com/" rel="nofollow">hier</a> für Installationsanweisungen).',Jt,he,Rt,ge,$n="Instanziieren Sie ein <code>Repository()</code> Objekt mit einem Pfad zu einem lokalen Repository:",_t,ue,Gt,ce,Zt,fe,bn="Der <code>clone_from</code> Parameter klont ein Repository von einer Hugging Face Repository-ID in ein lokales Verzeichnis, das durch das Argument <code>local_dir</code> angegeben wird:",Ut,ye,St,$e,Mn="<code>clone_from</code> kann auch ein Repository mit einer URL klonen:",It,be,zt,Me,wn="Sie können den <code>clone_from</code> Parameter mit <code>create_repo()</code> kombinieren, um ein Repository zu erstellen und zu klonen:",Ht,we,Ct,ve,vn="Sie können auch einen Git-Benutzernamen und eine E-Mail zu einem geklonten Repository konfigurieren, indem Sie die Parameter <code>git_user</code> und <code>git_email</code> beim Klonen eines Repositories angeben. Wenn Benutzer Änderungen in diesem Repository committen, wird Git über den Autor des Commits informiert sein.",Xt,Te,xt,ke,Bt,je,Tn="Branches sind wichtig für die Zusammenarbeit und das Experimentieren, ohne Ihre aktuellen Dateien und Codes zu beeinflussen. Wechseln Sie zwischen den Branches mit <code>git_checkout()</code>. Wenn Sie beispielsweise von <code>branch1</code> zu <code>branch2</code> wechseln möchten:",Yt,Je,Lt,Re,qt,_e,kn="Mit <code>git_pull()</code> können Sie eine aktuelle lokale Branch mit Änderungen aus einem Remote-Repository aktualisieren:",Ft,Ge,Wt,Ze,jn="Setzen Sie <code>rebase=True</code>, wenn Sie möchten, dass Ihre lokalen Commits nach dem Aktualisieren Ihres Zweigs mit den neuen Commits aus dem Remote erfolgen:",Nt,Ue,Vt,Ie,Et;return w=new f({props:{title:"Ein Repository erstellen und verwalten",local:"ein-repository-erstellen-und-verwalten",headingTag:"h1"}}),b=new Xn({props:{warning:!0,$$slots:{default:[xn]},$$scope:{ctx:ze}}}),j=new f({props:{title:"Erstellung und Löschung von Repos",local:"erstellung-und-löschung-von-repos",headingTag:"h2"}}),R=new f({props:{title:"Ein Repository erstellen",local:"ein-repository-erstellen",headingTag:"h3"}}),G=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),U=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/datasets/lysandre/test-dataset&#x27;</span>`,wrap:!1}}),I=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-private&quot;</span>, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),H=new f({props:{title:"Ein Repository löschen",local:"ein-repository-löschen",headingTag:"h3"}}),x=new y({props:{code:"ZGVsZXRlX3JlcG8ocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGbXktY29ycnVwdGVkLWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>delete_repo(repo_id=<span class="hljs-string">&quot;lysandre/my-corrupted-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)',wrap:!1}}),B=new f({props:{title:"Ein Repository duplizieren (nur für Spaces)",local:"ein-repository-duplizieren-nur-für-spaces",headingTag:"h3"}}),L=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiUyQyUyMHByaXZhdGUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, private=<span class="hljs-literal">False</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)`,wrap:!1}}),q=new f({props:{title:"Dateien hochladen und herunterladen",local:"dateien-hochladen-und-herunterladen",headingTag:"h2"}}),N=new f({props:{title:"Branches und Tags",local:"branches-und-tags",headingTag:"h2"}}),E=new f({props:{title:"Branches und Tags erstellen",local:"branches-und-tags-erstellen",headingTag:"h3"}}),Q=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9icmFuY2glMkMlMjBjcmVhdGVfdGFnJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJNYXR0aGlqcyUyRnNwZWVjaHQ1LXR0cy1kZW1vJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjBicmFuY2glM0QlMjJoYW5kbGUtZG9nLXNwZWFrZXIlMjIpJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjAuMS1yZWxlYXNlJTIyJTJDJTIwdGFnJTNEJTIydjAuMS4xJTIyJTJDJTIwdGFnX21lc3NhZ2UlM0QlMjJCdW1wJTIwcmVsZWFzZSUyMHZlcnNpb24uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_branch, create_tag

<span class="hljs-comment"># Erstellen Sie einen Branch auf einem Space-Repo vom \`main\` Branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;Matthijs/speecht5-tts-demo&quot;</span>, repo_type=<span class="hljs-string">&quot;space&quot;</span>, branch=<span class="hljs-string">&quot;handle-dog-speaker&quot;</span>)

<span class="hljs-comment"># Erstellen Sie einen Tag auf einem Dataset-Repo vom \`v0.1-release\` Branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, revision=<span class="hljs-string">&quot;v0.1-release&quot;</span>, tag=<span class="hljs-string">&quot;v0.1.1&quot;</span>, tag_message=<span class="hljs-string">&quot;Bump release version.&quot;</span>)`,wrap:!1}}),A=new f({props:{title:"Alle Branches und Tags auflisten",local:"alle-branches-und-tags-auflisten",headingTag:"h3"}}),O=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb19yZWZzJTBBbGlzdF9yZXBvX3JlZnMoJTIyYmlnY29kZSUyRnRoZS1zdGFjayUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_refs
<span class="hljs-meta">&gt;&gt;&gt; </span>list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
GitRefs(
   branches=[
         GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
   ],
   converts=[],
   tags=[
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
   ]
)`,wrap:!1}}),ee=new f({props:{title:"Repository-Einstellungen ändern",local:"repository-einstellungen-ändern",headingTag:"h2"}}),se=new f({props:{title:"Sichtbarkeit aktualisieren",local:"sichtbarkeit-aktualisieren",headingTag:"h3"}}),le=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9yZXBvX3Zpc2liaWxpdHklMEF1cGRhdGVfcmVwb192aXNpYmlsaXR5KHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwcHJpdmF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_repo_visibility
<span class="hljs-meta">&gt;&gt;&gt; </span>update_repo_visibility(repo_id=repo_id, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),ae=new f({props:{title:"Benennen Sie Ihr Repository um",local:"benennen-sie-ihr-repository-um",headingTag:"h3"}}),pe=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1vdmVfcmVwbyUwQW1vdmVfcmVwbyhmcm9tX2lkJTNEJTIyV2F1cGxpbiUyRmNvb2wtbW9kZWwlMjIlMkMlMjB0b19pZCUzRCUyMmh1Z2dpbmdmYWNlJTJGY29vbC1tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> move_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>move_repo(from_id=<span class="hljs-string">&quot;Wauplin/cool-model&quot;</span>, to_id=<span class="hljs-string">&quot;huggingface/cool-model&quot;</span>)`,wrap:!1}}),oe=new f({props:{title:"Verwalten Sie eine lokale Kopie Ihres Repositories",local:"verwalten-sie-eine-lokale-kopie-ihres-repositories",headingTag:"h2"}}),he=new f({props:{title:"Verwenden eines lokalen Repositories",local:"verwenden-eines-lokalen-repositories",headingTag:"h3"}}),ue=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjIlM0NwYXRoJTNFJTJGJTNDdG8lM0UlMkYlM0Nmb2xkZXIlM0UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;&lt;path&gt;/&lt;to&gt;/&lt;folder&gt;&quot;</span>)`,wrap:!1}}),ce=new f({props:{title:"Klonen",local:"klonen",headingTag:"h3"}}),ye=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJ3MnYyJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItbGFyZ2UtOTYwaC1sdjYwJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;w2v2&quot;</span>, clone_from=<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)`,wrap:!1}}),be=new y({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkobG9jYWxfZGlyJTNEJTIyaHVnZ2luZ2ZhY2UtaHViJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;https://huggingface.co/facebook/wav2vec2-large-960h-lv60&quot;</span>)',wrap:!1}}),we=new y({props:{code:"cmVwb191cmwlMjAlM0QlMjBjcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIycmVwb19uYW1lJTIyKSUwQXJlcG8lMjAlM0QlMjBSZXBvc2l0b3J5KGxvY2FsX2RpciUzRCUyMnJlcG9fbG9jYWxfcGF0aCUyMiUyQyUyMGNsb25lX2Zyb20lM0RyZXBvX3VybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo_url = create_repo(repo_id=<span class="hljs-string">&quot;repo_name&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;repo_local_path&quot;</span>, clone_from=repo_url)`,wrap:!1}}),Te=new y({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIybXktZGF0YXNldCUyMiUyQyUwQSUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGJTNDZGF0YXNldF9pZCUzRSUyMiUyQyUwQSUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjBnaXRfdXNlciUzRCUyMk15TmFtZSUyMiUyQyUwQSUyMCUyMGdpdF9lbWFpbCUzRCUyMm1lJTQwY29vbC5tYWlsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;my-dataset&quot;</span>,
<span class="hljs-meta">... </span>  clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>,
<span class="hljs-meta">... </span>  token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>  git_user=<span class="hljs-string">&quot;MyName&quot;</span>,
<span class="hljs-meta">... </span>  git_email=<span class="hljs-string">&quot;me@cool.mail&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ke=new f({props:{title:"Branch",local:"branch",headingTag:"h3"}}),Je=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJodWdnaW5nZmFjZS1odWIlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRiUzQ2RhdGFzZXRfaWQlM0UlMjIlMkMlMjByZXZpc2lvbiUzRCdicmFuY2gxJyklMEFyZXBvLmdpdF9jaGVja291dCglMjJicmFuY2gyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>, revision=<span class="hljs-string">&#x27;branch1&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_checkout(<span class="hljs-string">&quot;branch2&quot;</span>)`,wrap:!1}}),Re=new f({props:{title:"Pull",local:"pull",headingTag:"h3"}}),Ge=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvLmdpdF9wdWxsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull()`,wrap:!1}}),Ue=new y({props:{code:"cmVwby5naXRfcHVsbChyZWJhc2UlM0RUcnVlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull(rebase=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){c=h("meta"),M=i(),$=h("p"),Se=i(),a(w.$$.fragment),He=i(),v=h("p"),v.innerHTML=Pt,Ce=i(),T=h("ul"),T.innerHTML=Qt,Xe=i(),a(b.$$.fragment),xe=i(),k=h("p"),k.innerHTML=Dt,Be=i(),a(j.$$.fragment),Ye=i(),J=h("p"),J.textContent=At,Le=i(),a(R.$$.fragment),qe=i(),_=h("p"),_.innerHTML=Kt,Fe=i(),a(G.$$.fragment),We=i(),Z=h("p"),Z.innerHTML=Ot,Ne=i(),a(U.$$.fragment),Ve=i(),S=h("p"),S.innerHTML=en,Ee=i(),a(I.$$.fragment),Pe=i(),z=h("p"),z.innerHTML=tn,Qe=i(),a(H.$$.fragment),De=i(),C=h("p"),C.innerHTML=nn,Ae=i(),X=h("p"),X.innerHTML=sn,Ke=i(),a(x.$$.fragment),Oe=i(),a(B.$$.fragment),et=i(),Y=h("p"),Y.innerHTML=ln,tt=i(),a(L.$$.fragment),nt=i(),a(q.$$.fragment),st=i(),F=h("p"),F.textContent=an,it=i(),W=h("p"),W.innerHTML=rn,lt=i(),a(N.$$.fragment),at=i(),V=h("p"),V.innerHTML=pn,rt=i(),a(E.$$.fragment),pt=i(),P=h("p"),P.innerHTML=on,ot=i(),a(Q.$$.fragment),mt=i(),D=h("p"),D.innerHTML=mn,dt=i(),a(A.$$.fragment),ht=i(),K=h("p"),K.innerHTML=dn,gt=i(),a(O.$$.fragment),ut=i(),a(ee.$$.fragment),ct=i(),te=h("p"),te.innerHTML=hn,ft=i(),ne=h("p"),ne.innerHTML=gn,yt=i(),a(se.$$.fragment),$t=i(),ie=h("p"),ie.textContent=un,bt=i(),a(le.$$.fragment),Mt=i(),a(ae.$$.fragment),wt=i(),re=h("p"),re.innerHTML=cn,vt=i(),a(pe.$$.fragment),Tt=i(),a(oe.$$.fragment),kt=i(),me=h("p"),me.textContent=fn,jt=i(),de=h("p"),de.innerHTML=yn,Jt=i(),a(he.$$.fragment),Rt=i(),ge=h("p"),ge.innerHTML=$n,_t=i(),a(ue.$$.fragment),Gt=i(),a(ce.$$.fragment),Zt=i(),fe=h("p"),fe.innerHTML=bn,Ut=i(),a(ye.$$.fragment),St=i(),$e=h("p"),$e.innerHTML=Mn,It=i(),a(be.$$.fragment),zt=i(),Me=h("p"),Me.innerHTML=wn,Ht=i(),a(we.$$.fragment),Ct=i(),ve=h("p"),ve.innerHTML=vn,Xt=i(),a(Te.$$.fragment),xt=i(),a(ke.$$.fragment),Bt=i(),je=h("p"),je.innerHTML=Tn,Yt=i(),a(Je.$$.fragment),Lt=i(),a(Re.$$.fragment),qt=i(),_e=h("p"),_e.innerHTML=kn,Ft=i(),a(Ge.$$.fragment),Wt=i(),Ze=h("p"),Ze.innerHTML=jn,Nt=i(),a(Ue.$$.fragment),Vt=i(),Ie=h("p"),this.h()},l(e){const t=zn("svelte-u9bgzb",document.head);c=g(t,"META",{name:!0,content:!0}),t.forEach(n),M=l(e),$=g(e,"P",{}),Rn($).forEach(n),Se=l(e),r(w.$$.fragment,e),He=l(e),v=g(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1yyzsag"&&(v.innerHTML=Pt),Ce=l(e),T=g(e,"UL",{"data-svelte-h":!0}),u(T)!=="svelte-sqn2sa"&&(T.innerHTML=Qt),Xe=l(e),r(b.$$.fragment,e),xe=l(e),k=g(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-rdzptl"&&(k.innerHTML=Dt),Be=l(e),r(j.$$.fragment,e),Ye=l(e),J=g(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-1z0tv5i"&&(J.textContent=At),Le=l(e),r(R.$$.fragment,e),qe=l(e),_=g(e,"P",{"data-svelte-h":!0}),u(_)!=="svelte-1hgmn6f"&&(_.innerHTML=Kt),Fe=l(e),r(G.$$.fragment,e),We=l(e),Z=g(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-fllp17"&&(Z.innerHTML=Ot),Ne=l(e),r(U.$$.fragment,e),Ve=l(e),S=g(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-5ihxzc"&&(S.innerHTML=en),Ee=l(e),r(I.$$.fragment,e),Pe=l(e),z=g(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-oj59gu"&&(z.innerHTML=tn),Qe=l(e),r(H.$$.fragment,e),De=l(e),C=g(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-me7cb9"&&(C.innerHTML=nn),Ae=l(e),X=g(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1g3j115"&&(X.innerHTML=sn),Ke=l(e),r(x.$$.fragment,e),Oe=l(e),r(B.$$.fragment,e),et=l(e),Y=g(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1pdw2g6"&&(Y.innerHTML=ln),tt=l(e),r(L.$$.fragment,e),nt=l(e),r(q.$$.fragment,e),st=l(e),F=g(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-qj5vha"&&(F.textContent=an),it=l(e),W=g(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-uqpnt2"&&(W.innerHTML=rn),lt=l(e),r(N.$$.fragment,e),at=l(e),V=g(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1hws6dh"&&(V.innerHTML=pn),rt=l(e),r(E.$$.fragment,e),pt=l(e),P=g(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-1didjjj"&&(P.innerHTML=on),ot=l(e),r(Q.$$.fragment,e),mt=l(e),D=g(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1p2asnn"&&(D.innerHTML=mn),dt=l(e),r(A.$$.fragment,e),ht=l(e),K=g(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-10sfcrj"&&(K.innerHTML=dn),gt=l(e),r(O.$$.fragment,e),ut=l(e),r(ee.$$.fragment,e),ct=l(e),te=g(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1brg7na"&&(te.innerHTML=hn),ft=l(e),ne=g(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1umobvh"&&(ne.innerHTML=gn),yt=l(e),r(se.$$.fragment,e),$t=l(e),ie=g(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-1moe27y"&&(ie.textContent=un),bt=l(e),r(le.$$.fragment,e),Mt=l(e),r(ae.$$.fragment,e),wt=l(e),re=g(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1gufg09"&&(re.innerHTML=cn),vt=l(e),r(pe.$$.fragment,e),Tt=l(e),r(oe.$$.fragment,e),kt=l(e),me=g(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-9eyag"&&(me.textContent=fn),jt=l(e),de=g(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-1y8t3is"&&(de.innerHTML=yn),Jt=l(e),r(he.$$.fragment,e),Rt=l(e),ge=g(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-1hcil2r"&&(ge.innerHTML=$n),_t=l(e),r(ue.$$.fragment,e),Gt=l(e),r(ce.$$.fragment,e),Zt=l(e),fe=g(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1aiqy6u"&&(fe.innerHTML=bn),Ut=l(e),r(ye.$$.fragment,e),St=l(e),$e=g(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-hm7kpl"&&($e.innerHTML=Mn),It=l(e),r(be.$$.fragment,e),zt=l(e),Me=g(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-19pfeu4"&&(Me.innerHTML=wn),Ht=l(e),r(we.$$.fragment,e),Ct=l(e),ve=g(e,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-dpqex0"&&(ve.innerHTML=vn),Xt=l(e),r(Te.$$.fragment,e),xt=l(e),r(ke.$$.fragment,e),Bt=l(e),je=g(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1u8befz"&&(je.innerHTML=Tn),Yt=l(e),r(Je.$$.fragment,e),Lt=l(e),r(Re.$$.fragment,e),qt=l(e),_e=g(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-mhatrk"&&(_e.innerHTML=kn),Ft=l(e),r(Ge.$$.fragment,e),Wt=l(e),Ze=g(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1kuf0pv"&&(Ze.innerHTML=jn),Nt=l(e),r(Ue.$$.fragment,e),Vt=l(e),Ie=g(e,"P",{}),Rn(Ie).forEach(n),this.h()},h(){_n(c,"name","hf:doc:metadata"),_n(c,"content",Yn)},m(e,t){Hn(document.head,c),s(e,M,t),s(e,$,t),s(e,Se,t),p(w,e,t),s(e,He,t),s(e,v,t),s(e,Ce,t),s(e,T,t),s(e,Xe,t),p(b,e,t),s(e,xe,t),s(e,k,t),s(e,Be,t),p(j,e,t),s(e,Ye,t),s(e,J,t),s(e,Le,t),p(R,e,t),s(e,qe,t),s(e,_,t),s(e,Fe,t),p(G,e,t),s(e,We,t),s(e,Z,t),s(e,Ne,t),p(U,e,t),s(e,Ve,t),s(e,S,t),s(e,Ee,t),p(I,e,t),s(e,Pe,t),s(e,z,t),s(e,Qe,t),p(H,e,t),s(e,De,t),s(e,C,t),s(e,Ae,t),s(e,X,t),s(e,Ke,t),p(x,e,t),s(e,Oe,t),p(B,e,t),s(e,et,t),s(e,Y,t),s(e,tt,t),p(L,e,t),s(e,nt,t),p(q,e,t),s(e,st,t),s(e,F,t),s(e,it,t),s(e,W,t),s(e,lt,t),p(N,e,t),s(e,at,t),s(e,V,t),s(e,rt,t),p(E,e,t),s(e,pt,t),s(e,P,t),s(e,ot,t),p(Q,e,t),s(e,mt,t),s(e,D,t),s(e,dt,t),p(A,e,t),s(e,ht,t),s(e,K,t),s(e,gt,t),p(O,e,t),s(e,ut,t),p(ee,e,t),s(e,ct,t),s(e,te,t),s(e,ft,t),s(e,ne,t),s(e,yt,t),p(se,e,t),s(e,$t,t),s(e,ie,t),s(e,bt,t),p(le,e,t),s(e,Mt,t),p(ae,e,t),s(e,wt,t),s(e,re,t),s(e,vt,t),p(pe,e,t),s(e,Tt,t),p(oe,e,t),s(e,kt,t),s(e,me,t),s(e,jt,t),s(e,de,t),s(e,Jt,t),p(he,e,t),s(e,Rt,t),s(e,ge,t),s(e,_t,t),p(ue,e,t),s(e,Gt,t),p(ce,e,t),s(e,Zt,t),s(e,fe,t),s(e,Ut,t),p(ye,e,t),s(e,St,t),s(e,$e,t),s(e,It,t),p(be,e,t),s(e,zt,t),s(e,Me,t),s(e,Ht,t),p(we,e,t),s(e,Ct,t),s(e,ve,t),s(e,Xt,t),p(Te,e,t),s(e,xt,t),p(ke,e,t),s(e,Bt,t),s(e,je,t),s(e,Yt,t),p(Je,e,t),s(e,Lt,t),p(Re,e,t),s(e,qt,t),s(e,_e,t),s(e,Ft,t),p(Ge,e,t),s(e,Wt,t),s(e,Ze,t),s(e,Nt,t),p(Ue,e,t),s(e,Vt,t),s(e,Ie,t),Et=!0},p(e,[t]){const Jn={};t&2&&(Jn.$$scope={dirty:t,ctx:e}),b.$set(Jn)},i(e){Et||(o(w.$$.fragment,e),o(b.$$.fragment,e),o(j.$$.fragment,e),o(R.$$.fragment,e),o(G.$$.fragment,e),o(U.$$.fragment,e),o(I.$$.fragment,e),o(H.$$.fragment,e),o(x.$$.fragment,e),o(B.$$.fragment,e),o(L.$$.fragment,e),o(q.$$.fragment,e),o(N.$$.fragment,e),o(E.$$.fragment,e),o(Q.$$.fragment,e),o(A.$$.fragment,e),o(O.$$.fragment,e),o(ee.$$.fragment,e),o(se.$$.fragment,e),o(le.$$.fragment,e),o(ae.$$.fragment,e),o(pe.$$.fragment,e),o(oe.$$.fragment,e),o(he.$$.fragment,e),o(ue.$$.fragment,e),o(ce.$$.fragment,e),o(ye.$$.fragment,e),o(be.$$.fragment,e),o(we.$$.fragment,e),o(Te.$$.fragment,e),o(ke.$$.fragment,e),o(Je.$$.fragment,e),o(Re.$$.fragment,e),o(Ge.$$.fragment,e),o(Ue.$$.fragment,e),Et=!0)},o(e){m(w.$$.fragment,e),m(b.$$.fragment,e),m(j.$$.fragment,e),m(R.$$.fragment,e),m(G.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(H.$$.fragment,e),m(x.$$.fragment,e),m(B.$$.fragment,e),m(L.$$.fragment,e),m(q.$$.fragment,e),m(N.$$.fragment,e),m(E.$$.fragment,e),m(Q.$$.fragment,e),m(A.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(oe.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),m(ce.$$.fragment,e),m(ye.$$.fragment,e),m(be.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(ke.$$.fragment,e),m(Je.$$.fragment,e),m(Re.$$.fragment,e),m(Ge.$$.fragment,e),m(Ue.$$.fragment,e),Et=!1},d(e){e&&(n(M),n($),n(Se),n(He),n(v),n(Ce),n(T),n(Xe),n(xe),n(k),n(Be),n(Ye),n(J),n(Le),n(qe),n(_),n(Fe),n(We),n(Z),n(Ne),n(Ve),n(S),n(Ee),n(Pe),n(z),n(Qe),n(De),n(C),n(Ae),n(X),n(Ke),n(Oe),n(et),n(Y),n(tt),n(nt),n(st),n(F),n(it),n(W),n(lt),n(at),n(V),n(rt),n(pt),n(P),n(ot),n(mt),n(D),n(dt),n(ht),n(K),n(gt),n(ut),n(ct),n(te),n(ft),n(ne),n(yt),n($t),n(ie),n(bt),n(Mt),n(wt),n(re),n(vt),n(Tt),n(kt),n(me),n(jt),n(de),n(Jt),n(Rt),n(ge),n(_t),n(Gt),n(Zt),n(fe),n(Ut),n(St),n($e),n(It),n(zt),n(Me),n(Ht),n(Ct),n(ve),n(Xt),n(xt),n(Bt),n(je),n(Yt),n(Lt),n(qt),n(_e),n(Ft),n(Wt),n(Ze),n(Nt),n(Vt),n(Ie)),n(c),d(w,e),d(b,e),d(j,e),d(R,e),d(G,e),d(U,e),d(I,e),d(H,e),d(x,e),d(B,e),d(L,e),d(q,e),d(N,e),d(E,e),d(Q,e),d(A,e),d(O,e),d(ee,e),d(se,e),d(le,e),d(ae,e),d(pe,e),d(oe,e),d(he,e),d(ue,e),d(ce,e),d(ye,e),d(be,e),d(we,e),d(Te,e),d(ke,e),d(Je,e),d(Re,e),d(Ge,e),d(Ue,e)}}}const Yn='{"title":"Ein Repository erstellen und verwalten","local":"ein-repository-erstellen-und-verwalten","sections":[{"title":"Erstellung und Löschung von Repos","local":"erstellung-und-löschung-von-repos","sections":[{"title":"Ein Repository erstellen","local":"ein-repository-erstellen","sections":[],"depth":3},{"title":"Ein Repository löschen","local":"ein-repository-löschen","sections":[],"depth":3},{"title":"Ein Repository duplizieren (nur für Spaces)","local":"ein-repository-duplizieren-nur-für-spaces","sections":[],"depth":3}],"depth":2},{"title":"Dateien hochladen und herunterladen","local":"dateien-hochladen-und-herunterladen","sections":[],"depth":2},{"title":"Branches und Tags","local":"branches-und-tags","sections":[{"title":"Branches und Tags erstellen","local":"branches-und-tags-erstellen","sections":[],"depth":3},{"title":"Alle Branches und Tags auflisten","local":"alle-branches-und-tags-auflisten","sections":[],"depth":3}],"depth":2},{"title":"Repository-Einstellungen ändern","local":"repository-einstellungen-ändern","sections":[{"title":"Sichtbarkeit aktualisieren","local":"sichtbarkeit-aktualisieren","sections":[],"depth":3},{"title":"Benennen Sie Ihr Repository um","local":"benennen-sie-ihr-repository-um","sections":[],"depth":3}],"depth":2},{"title":"Verwalten Sie eine lokale Kopie Ihres Repositories","local":"verwalten-sie-eine-lokale-kopie-ihres-repositories","sections":[{"title":"Verwenden eines lokalen Repositories","local":"verwenden-eines-lokalen-repositories","sections":[],"depth":3},{"title":"Klonen","local":"klonen","sections":[],"depth":3},{"title":"Branch","local":"branch","sections":[],"depth":3},{"title":"Pull","local":"pull","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ln(ze){return Zn(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Cn}),[]}class En extends Sn{constructor(c){super(),In(this,c,Ln,Bn,Gn,{})}}export{En as component};
