import{s as Tt,o as Ct,n as wt}from"../chunks/scheduler.6062bdaf.js";import{S as kt,i as Ht,g as i,s as t,r as l,A as Lt,h as o,f as a,c as r,j as E,u as h,x as p,k as I,y as n,a as s,v as u,d as m,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as Mt}from"../chunks/Tip.b9ac1f03.js";import{D as y}from"../chunks/Docstring.ed07512f.js";import{C as Pt}from"../chunks/CodeBlock.fa01571c.js";import{E as At}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as Oe}from"../chunks/Heading.723dceba.js";function jt(_e){let d,M='Check out the <a href="../guides/inference_endpoints">related guide</a> to learn how to use <code>huggingface_hub</code> to manage your Inference Endpoints programmatically.';return{c(){d=i("p"),d.innerHTML=M},l($){d=o($,"P",{"data-svelte-h":!0}),p(d)!=="svelte-tmb85g"&&(d.innerHTML=M)},m($,x){s($,d,x)},p:wt,d($){$&&a(d)}}}function qt(_e){let d,M="Example:",$,x,w;return x=new Pt({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiklMEElMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBZW5kcG9pbnQucmVzdW1lKCklMEFlbmRwb2ludC53YWl0KCklMEFlbmRwb2ludC5jbGllbnQudGV4dF90b19pbWFnZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)

<span class="hljs-comment"># Pause endpoint to save $$$</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()

<span class="hljs-comment"># ...</span>
<span class="hljs-comment"># Resume and wait for deployment</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){d=i("p"),d.textContent=M,$=t(),l(x.$$.fragment)},l(v){d=o(v,"P",{"data-svelte-h":!0}),p(d)!=="svelte-11lpom8"&&(d.textContent=M),$=r(v),h(x.$$.fragment,v)},m(v,L){s(v,d,L),s(v,$,L),u(x,v,L),w=!0},p:wt,i(v){w||(m(x.$$.fragment,v),w=!0)},o(v){_(x.$$.fragment,v),w=!1},d(v){v&&(a(d),a($)),b(x,v)}}}function zt(_e){let d,M,$,x,w,v,L,Yn='Inference Endpoints provides a secure production solution to easily deploy models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>. This page is a reference for <code>huggingface_hub</code>’s integration with Inference Endpoints. For more information about the Inference Endpoints product, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.',Ze,V,Ge,G,Xn='Inference Endpoints can be fully managed via API. The endpoints are documented with <a href="https://api.endpoints.huggingface.cloud/" rel="nofollow">Swagger</a>. The <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> class is a simple wrapper built on top on this API.',Be,B,Qe,Q,Jn='A subset of the Inference Endpoint features are implemented in <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>:',Ye,Y,Kn='<li><a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a> and <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to get information about your Inference Endpoints</li> <li><a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>, <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a> and <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a> to deploy and manage Inference Endpoints</li> <li><a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> and <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a> to pause and resume an Inference Endpoint</li> <li><a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a> to manually scale an Endpoint to 0 replicas</li>',Xe,X,Je,J,et='The main dataclass is <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>. It contains information about a deployed <code>InferenceEndpoint</code>, including its configuration and current state. Once deployed, you can run inference on the Endpoint using the  <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.client">InferenceEndpoint.client</a> and <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.async_client">InferenceEndpoint.async_client</a> properties that respectively return an <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> object.',Ke,g,K,un,be,nt="Contains information about a deployed Inference Endpoint.",mn,D,_n,N,ee,bn,ve,tt="Initialize object from raw dictionary.",vn,S,ne,$n,$e,rt="Returns a client to make predictions on this Inference Endpoint.",En,R,te,In,Ee,at="Returns a client to make predictions on this Inference Endpoint.",xn,T,re,yn,Ie,it="Delete the Inference Endpoint.",wn,xe,ot=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">InferenceEndpoint.pause()</a> or scale it to zero with <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.`,Tn,ye,ct='This is an alias for <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">HfApi.delete_inference_endpoint()</a>.',Cn,U,ae,kn,we,st="Fetch latest information about the Inference Endpoint.",Hn,C,ie,Ln,Te,gt="Pause the Inference Endpoint.",Mn,Ce,pt=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>, which
would be automatically restarted when a request is made to it.`,Pn,ke,ft=`This is an alias for <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">HfApi.pause_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,An,P,oe,jn,He,dt="Resume the Inference Endpoint.",qn,Le,lt=`This is an alias for <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">HfApi.resume_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,zn,k,ce,Vn,Me,ht="Scale Inference Endpoint to zero.",Dn,Pe,ut=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">InferenceEndpoint.pause()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.`,Nn,Ae,mt=`This is an alias for <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">HfApi.scale_to_zero_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,Sn,H,se,Rn,je,_t="Update the Inference Endpoint.",Un,qe,bt=`This method allows the update of either the compute configuration, the deployed model, or both. All arguments are
optional but at least one must be provided.`,Wn,ze,vt=`This is an alias for <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">HfApi.update_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,On,A,ge,Fn,Ve,$t="Wait for the Inference Endpoint to be deployed.",Zn,De,Et=`Information from the server will be fetched every 1s. If the Inference Endpoint is not deployed after <code>timeout</code>
seconds, a <code>InferenceEndpointTimeoutError</code> will be raised. The <a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> will be mutated in place with the latest
data.`,en,pe,nn,j,fe,Gn,Ne,It="An enumeration.",tn,de,rn,q,le,Bn,Se,xt="An enumeration.",an,he,on,z,ue,Qn,Re,yt="Generic exception when dealing with Inference Endpoints.",cn,Fe,sn;return w=new Oe({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),V=new Mt({props:{$$slots:{default:[jt]},$$scope:{ctx:_e}}}),B=new Oe({props:{title:"Methods",local:"methods",headingTag:"h2"}}),X=new Oe({props:{title:"InferenceEndpoint",local:"huggingface_hub.InferenceEndpoint",headingTag:"h2"}}),K=new y({props:{name:"class huggingface_hub.InferenceEndpoint",anchor:"huggingface_hub.InferenceEndpoint",parameters:[{name:"namespace",val:": str"},{name:"raw",val:": typing.Dict"},{name:"_token",val:": typing.Optional[str]"},{name:"_api",val:": HfApi"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name of the Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.InferenceEndpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>) &#x2014;
The namespace where the Inference Endpoint is located.`,name:"namespace"},{anchor:"huggingface_hub.InferenceEndpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository deployed on this Inference Endpoint.`,name:"repository"},{anchor:"huggingface_hub.InferenceEndpoint.status",description:`<strong>status</strong> (<a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>) &#x2014;
The current status of the Inference Endpoint.`,name:"status"},{anchor:"huggingface_hub.InferenceEndpoint.url",description:`<strong>url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The URL of the Inference Endpoint, if available. Only a deployed Inference Endpoint will have a URL.`,name:"url"},{anchor:"huggingface_hub.InferenceEndpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model.`,name:"framework"},{anchor:"huggingface_hub.InferenceEndpoint.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The specific model revision deployed on the Inference Endpoint.`,name:"revision"},{anchor:"huggingface_hub.InferenceEndpoint.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task associated with the deployed model.`,name:"task"},{anchor:"huggingface_hub.InferenceEndpoint.created_at",description:`<strong>created_at</strong> (<code>datetime.datetime</code>) &#x2014;
The timestamp when the Inference Endpoint was created.`,name:"created_at"},{anchor:"huggingface_hub.InferenceEndpoint.updated_at",description:`<strong>updated_at</strong> (<code>datetime.datetime</code>) &#x2014;
The timestamp of the last update of the Inference Endpoint.`,name:"updated_at"},{anchor:"huggingface_hub.InferenceEndpoint.type",description:`<strong>type</strong> (<a href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointType">InferenceEndpointType</a>) &#x2014;
The type of the Inference Endpoint (public, protected, private).`,name:"type"},{anchor:"huggingface_hub.InferenceEndpoint.raw",description:`<strong>raw</strong> (<code>Dict</code>) &#x2014;
The raw dictionary data returned from the API.`,name:"raw"},{anchor:"huggingface_hub.InferenceEndpoint.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Authentication token for the Inference Endpoint, if set when requesting the API.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L45"}}),D=new At({props:{anchor:"huggingface_hub.InferenceEndpoint.example",$$slots:{default:[qt]},$$scope:{ctx:_e}}}),ee=new y({props:{name:"from_raw",anchor:"huggingface_hub.InferenceEndpoint.from_raw",parameters:[{name:"raw",val:": typing.Dict"},{name:"namespace",val:": str"},{name:"token",val:": typing.Optional[str] = None"},{name:"api",val:": typing.Optional[ForwardRef('HfApi')] = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L126"}}),ne=new y({props:{name:"client",anchor:"huggingface_hub.InferenceEndpoint.client",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L145",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> — If the Inference Endpoint is not yet deployed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a></p>
`}}),te=new y({props:{name:"async_client",anchor:"huggingface_hub.InferenceEndpoint.async_client",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L159",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> — If the Inference Endpoint is not yet deployed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.19.0.rc0/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a></p>
`}}),re=new y({props:{name:"delete",anchor:"huggingface_hub.InferenceEndpoint.delete",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L321"}}),ae=new y({props:{name:"fetch",anchor:"huggingface_hub.InferenceEndpoint.fetch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L208"}}),ie=new y({props:{name:"pause",anchor:"huggingface_hub.InferenceEndpoint.pause",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L280"}}),oe=new y({props:{name:"resume",anchor:"huggingface_hub.InferenceEndpoint.resume",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L295"}}),ce=new y({props:{name:"scale_to_zero",anchor:"huggingface_hub.InferenceEndpoint.scale_to_zero",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L306"}}),se=new y({props:{name:"update",anchor:"huggingface_hub.InferenceEndpoint.update",parameters:[{name:"accelerator",val:": typing.Optional[str] = None"},{name:"instance_size",val:": typing.Optional[str] = None"},{name:"instance_type",val:": typing.Optional[str] = None"},{name:"min_replica",val:": typing.Optional[int] = None"},{name:"max_replica",val:": typing.Optional[int] = None"},{name:"repository",val:": typing.Optional[str] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"task",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.update.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.InferenceEndpoint.update.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;large&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.InferenceEndpoint.update.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;c6i&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.InferenceEndpoint.update.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.InferenceEndpoint.update.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.InferenceEndpoint.update.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.InferenceEndpoint.update.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.InferenceEndpoint.update.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.InferenceEndpoint.update.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L215"}}),ge=new y({props:{name:"wait",anchor:"huggingface_hub.InferenceEndpoint.wait",parameters:[{name:"timeout",val:": typing.Optional[int] = None"},{name:"refresh_every",val:": int = 5"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.wait.timeout",description:`<strong>timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum time to wait for the Inference Endpoint to be deployed, in seconds. If <code>None</code>, will wait
indefinitely.`,name:"timeout"},{anchor:"huggingface_hub.InferenceEndpoint.wait.refresh_every",description:`<strong>refresh_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The time to wait between each fetch of the Inference Endpoint status, in seconds. Defaults to 5s.`,name:"refresh_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L173"}}),pe=new Oe({props:{title:"InferenceEndpointStatus",local:"huggingface_hub.InferenceEndpointStatus",headingTag:"h2"}}),fe=new y({props:{name:"class huggingface_hub.InferenceEndpointStatus",anchor:"huggingface_hub.InferenceEndpointStatus",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L27"}}),de=new Oe({props:{title:"InferenceEndpointType",local:"huggingface_hub.InferenceEndpointType",headingTag:"h2"}}),le=new y({props:{name:"class huggingface_hub.InferenceEndpointType",anchor:"huggingface_hub.InferenceEndpointType",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L38"}}),he=new Oe({props:{title:"InferenceEndpointError",local:"huggingface_hub.InferenceEndpointError",headingTag:"h2"}}),ue=new y({props:{name:"class huggingface_hub.InferenceEndpointError",anchor:"huggingface_hub.InferenceEndpointError",parameters:"",source:"https://github.com/huggingface/huggingface_hub/blob/v0.19.0.rc0/src/huggingface_hub/_inference_endpoints.py#L19"}}),{c(){d=i("meta"),M=t(),$=i("p"),x=t(),l(w.$$.fragment),v=t(),L=i("p"),L.innerHTML=Yn,Ze=t(),l(V.$$.fragment),Ge=t(),G=i("p"),G.innerHTML=Xn,Be=t(),l(B.$$.fragment),Qe=t(),Q=i("p"),Q.innerHTML=Jn,Ye=t(),Y=i("ul"),Y.innerHTML=Kn,Xe=t(),l(X.$$.fragment),Je=t(),J=i("p"),J.innerHTML=et,Ke=t(),g=i("div"),l(K.$$.fragment),un=t(),be=i("p"),be.textContent=nt,mn=t(),l(D.$$.fragment),_n=t(),N=i("div"),l(ee.$$.fragment),bn=t(),ve=i("p"),ve.textContent=tt,vn=t(),S=i("div"),l(ne.$$.fragment),$n=t(),$e=i("p"),$e.textContent=rt,En=t(),R=i("div"),l(te.$$.fragment),In=t(),Ee=i("p"),Ee.textContent=at,xn=t(),T=i("div"),l(re.$$.fragment),yn=t(),Ie=i("p"),Ie.textContent=it,wn=t(),xe=i("p"),xe.innerHTML=ot,Tn=t(),ye=i("p"),ye.innerHTML=ct,Cn=t(),U=i("div"),l(ae.$$.fragment),kn=t(),we=i("p"),we.textContent=st,Hn=t(),C=i("div"),l(ie.$$.fragment),Ln=t(),Te=i("p"),Te.textContent=gt,Mn=t(),Ce=i("p"),Ce.innerHTML=pt,Pn=t(),ke=i("p"),ke.innerHTML=ft,An=t(),P=i("div"),l(oe.$$.fragment),jn=t(),He=i("p"),He.textContent=dt,qn=t(),Le=i("p"),Le.innerHTML=lt,zn=t(),k=i("div"),l(ce.$$.fragment),Vn=t(),Me=i("p"),Me.textContent=ht,Dn=t(),Pe=i("p"),Pe.innerHTML=ut,Nn=t(),Ae=i("p"),Ae.innerHTML=mt,Sn=t(),H=i("div"),l(se.$$.fragment),Rn=t(),je=i("p"),je.textContent=_t,Un=t(),qe=i("p"),qe.textContent=bt,Wn=t(),ze=i("p"),ze.innerHTML=vt,On=t(),A=i("div"),l(ge.$$.fragment),Fn=t(),Ve=i("p"),Ve.textContent=$t,Zn=t(),De=i("p"),De.innerHTML=Et,en=t(),l(pe.$$.fragment),nn=t(),j=i("div"),l(fe.$$.fragment),Gn=t(),Ne=i("p"),Ne.textContent=It,tn=t(),l(de.$$.fragment),rn=t(),q=i("div"),l(le.$$.fragment),Bn=t(),Se=i("p"),Se.textContent=xt,an=t(),l(he.$$.fragment),on=t(),z=i("div"),l(ue.$$.fragment),Qn=t(),Re=i("p"),Re.textContent=yt,cn=t(),Fe=i("p"),this.h()},l(e){const c=Lt("svelte-u9bgzb",document.head);d=o(c,"META",{name:!0,content:!0}),c.forEach(a),M=r(e),$=o(e,"P",{}),E($).forEach(a),x=r(e),h(w.$$.fragment,e),v=r(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1bwc3b2"&&(L.innerHTML=Yn),Ze=r(e),h(V.$$.fragment,e),Ge=r(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-9czcgj"&&(G.innerHTML=Xn),Be=r(e),h(B.$$.fragment,e),Qe=r(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-yksxzr"&&(Q.innerHTML=Jn),Ye=r(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-21dh3g"&&(Y.innerHTML=Kn),Xe=r(e),h(X.$$.fragment,e),Je=r(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1onra3s"&&(J.innerHTML=et),Ke=r(e),g=o(e,"DIV",{class:!0});var f=E(g);h(K.$$.fragment,f),un=r(f),be=o(f,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1bmjqnv"&&(be.textContent=nt),mn=r(f),h(D.$$.fragment,f),_n=r(f),N=o(f,"DIV",{class:!0});var me=E(N);h(ee.$$.fragment,me),bn=r(me),ve=o(me,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-gljdbx"&&(ve.textContent=tt),me.forEach(a),vn=r(f),S=o(f,"DIV",{class:!0});var gn=E(S);h(ne.$$.fragment,gn),$n=r(gn),$e=o(gn,"P",{"data-svelte-h":!0}),p($e)!=="svelte-jw5rtn"&&($e.textContent=rt),gn.forEach(a),En=r(f),R=o(f,"DIV",{class:!0});var pn=E(R);h(te.$$.fragment,pn),In=r(pn),Ee=o(pn,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-jw5rtn"&&(Ee.textContent=at),pn.forEach(a),xn=r(f),T=o(f,"DIV",{class:!0});var W=E(T);h(re.$$.fragment,W),yn=r(W),Ie=o(W,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1awp4uu"&&(Ie.textContent=it),wn=r(W),xe=o(W,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1hc94w7"&&(xe.innerHTML=ot),Tn=r(W),ye=o(W,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1nhcu73"&&(ye.innerHTML=ct),W.forEach(a),Cn=r(f),U=o(f,"DIV",{class:!0});var fn=E(U);h(ae.$$.fragment,fn),kn=r(fn),we=o(fn,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1dh96nb"&&(we.textContent=st),fn.forEach(a),Hn=r(f),C=o(f,"DIV",{class:!0});var O=E(C);h(ie.$$.fragment,O),Ln=r(O),Te=o(O,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1bfttgz"&&(Te.textContent=gt),Mn=r(O),Ce=o(O,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-104tzfg"&&(Ce.innerHTML=pt),Pn=r(O),ke=o(O,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-xz6l4s"&&(ke.innerHTML=ft),O.forEach(a),An=r(f),P=o(f,"DIV",{class:!0});var Ue=E(P);h(oe.$$.fragment,Ue),jn=r(Ue),He=o(Ue,"P",{"data-svelte-h":!0}),p(He)!=="svelte-akp3j2"&&(He.textContent=dt),qn=r(Ue),Le=o(Ue,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1rrqsl0"&&(Le.innerHTML=lt),Ue.forEach(a),zn=r(f),k=o(f,"DIV",{class:!0});var F=E(k);h(ce.$$.fragment,F),Vn=r(F),Me=o(F,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-6vx93v"&&(Me.textContent=ht),Dn=r(F),Pe=o(F,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-191s776"&&(Pe.innerHTML=ut),Nn=r(F),Ae=o(F,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-561sfq"&&(Ae.innerHTML=mt),F.forEach(a),Sn=r(f),H=o(f,"DIV",{class:!0});var Z=E(H);h(se.$$.fragment,Z),Rn=r(Z),je=o(Z,"P",{"data-svelte-h":!0}),p(je)!=="svelte-16hllis"&&(je.textContent=_t),Un=r(Z),qe=o(Z,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-llxqqu"&&(qe.textContent=bt),Wn=r(Z),ze=o(Z,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-131frcw"&&(ze.innerHTML=vt),Z.forEach(a),On=r(f),A=o(f,"DIV",{class:!0});var We=E(A);h(ge.$$.fragment,We),Fn=r(We),Ve=o(We,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-15saqtl"&&(Ve.textContent=$t),Zn=r(We),De=o(We,"P",{"data-svelte-h":!0}),p(De)!=="svelte-g1kzhq"&&(De.innerHTML=Et),We.forEach(a),f.forEach(a),en=r(e),h(pe.$$.fragment,e),nn=r(e),j=o(e,"DIV",{class:!0});var dn=E(j);h(fe.$$.fragment,dn),Gn=r(dn),Ne=o(dn,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-ofujqi"&&(Ne.textContent=It),dn.forEach(a),tn=r(e),h(de.$$.fragment,e),rn=r(e),q=o(e,"DIV",{class:!0});var ln=E(q);h(le.$$.fragment,ln),Bn=r(ln),Se=o(ln,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-ofujqi"&&(Se.textContent=xt),ln.forEach(a),an=r(e),h(he.$$.fragment,e),on=r(e),z=o(e,"DIV",{class:!0});var hn=E(z);h(ue.$$.fragment,hn),Qn=r(hn),Re=o(hn,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-dy4pdd"&&(Re.textContent=yt),hn.forEach(a),cn=r(e),Fe=o(e,"P",{}),E(Fe).forEach(a),this.h()},h(){I(d,"name","hf:doc:metadata"),I(d,"content",Vt),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,d),s(e,M,c),s(e,$,c),s(e,x,c),u(w,e,c),s(e,v,c),s(e,L,c),s(e,Ze,c),u(V,e,c),s(e,Ge,c),s(e,G,c),s(e,Be,c),u(B,e,c),s(e,Qe,c),s(e,Q,c),s(e,Ye,c),s(e,Y,c),s(e,Xe,c),u(X,e,c),s(e,Je,c),s(e,J,c),s(e,Ke,c),s(e,g,c),u(K,g,null),n(g,un),n(g,be),n(g,mn),u(D,g,null),n(g,_n),n(g,N),u(ee,N,null),n(N,bn),n(N,ve),n(g,vn),n(g,S),u(ne,S,null),n(S,$n),n(S,$e),n(g,En),n(g,R),u(te,R,null),n(R,In),n(R,Ee),n(g,xn),n(g,T),u(re,T,null),n(T,yn),n(T,Ie),n(T,wn),n(T,xe),n(T,Tn),n(T,ye),n(g,Cn),n(g,U),u(ae,U,null),n(U,kn),n(U,we),n(g,Hn),n(g,C),u(ie,C,null),n(C,Ln),n(C,Te),n(C,Mn),n(C,Ce),n(C,Pn),n(C,ke),n(g,An),n(g,P),u(oe,P,null),n(P,jn),n(P,He),n(P,qn),n(P,Le),n(g,zn),n(g,k),u(ce,k,null),n(k,Vn),n(k,Me),n(k,Dn),n(k,Pe),n(k,Nn),n(k,Ae),n(g,Sn),n(g,H),u(se,H,null),n(H,Rn),n(H,je),n(H,Un),n(H,qe),n(H,Wn),n(H,ze),n(g,On),n(g,A),u(ge,A,null),n(A,Fn),n(A,Ve),n(A,Zn),n(A,De),s(e,en,c),u(pe,e,c),s(e,nn,c),s(e,j,c),u(fe,j,null),n(j,Gn),n(j,Ne),s(e,tn,c),u(de,e,c),s(e,rn,c),s(e,q,c),u(le,q,null),n(q,Bn),n(q,Se),s(e,an,c),u(he,e,c),s(e,on,c),s(e,z,c),u(ue,z,null),n(z,Qn),n(z,Re),s(e,cn,c),s(e,Fe,c),sn=!0},p(e,[c]){const f={};c&2&&(f.$$scope={dirty:c,ctx:e}),V.$set(f);const me={};c&2&&(me.$$scope={dirty:c,ctx:e}),D.$set(me)},i(e){sn||(m(w.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(K.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(te.$$.fragment,e),m(re.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(se.$$.fragment,e),m(ge.$$.fragment,e),m(pe.$$.fragment,e),m(fe.$$.fragment,e),m(de.$$.fragment,e),m(le.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),sn=!0)},o(e){_(w.$$.fragment,e),_(V.$$.fragment,e),_(B.$$.fragment,e),_(X.$$.fragment,e),_(K.$$.fragment,e),_(D.$$.fragment,e),_(ee.$$.fragment,e),_(ne.$$.fragment,e),_(te.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(oe.$$.fragment,e),_(ce.$$.fragment,e),_(se.$$.fragment,e),_(ge.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(de.$$.fragment,e),_(le.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),sn=!1},d(e){e&&(a(M),a($),a(x),a(v),a(L),a(Ze),a(Ge),a(G),a(Be),a(Qe),a(Q),a(Ye),a(Y),a(Xe),a(Je),a(J),a(Ke),a(g),a(en),a(nn),a(j),a(tn),a(rn),a(q),a(an),a(on),a(z),a(cn),a(Fe)),a(d),b(w,e),b(V,e),b(B,e),b(X,e),b(K),b(D),b(ee),b(ne),b(te),b(re),b(ae),b(ie),b(oe),b(ce),b(se),b(ge),b(pe,e),b(fe),b(de,e),b(le),b(he,e),b(ue)}}}const Vt='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Methods","local":"methods","sections":[],"depth":2},{"title":"InferenceEndpoint","local":"huggingface_hub.InferenceEndpoint","sections":[],"depth":2},{"title":"InferenceEndpointStatus","local":"huggingface_hub.InferenceEndpointStatus","sections":[],"depth":2},{"title":"InferenceEndpointType","local":"huggingface_hub.InferenceEndpointType","sections":[],"depth":2},{"title":"InferenceEndpointError","local":"huggingface_hub.InferenceEndpointError","sections":[],"depth":2}],"depth":1}';function Dt(_e){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends kt{constructor(d){super(),Ht(this,d,Dt,zt,Tt,{})}}export{Zt as component};
