import{s as In,n as jn,o as kn}from"../chunks/scheduler.9bc65507.js";import{S as Rn,i as Jn,g as l,s as r,r as g,A as En,h as d,f as n,c as a,j as wn,u as o,x as c,k as Ne,y as _n,a as i,v as s,d as m,t as h,w as f}from"../chunks/index.707bf1b6.js";import{C as De}from"../chunks/CodeBlock.54a9f38d.js";import{H as p,E as Bn}from"../chunks/EditOnGithub.922df6ba.js";function Un(He){let b,kt,It,Rt,u,Jt,y,We='This guide aims to provide a benchmark on the inference speed-ups introduced with <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile()</code></a> for <a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers&amp;sort=trending" rel="nofollow">computer vision models in 🤗 Transformers</a>.',Et,v,_t,$,Oe="Depending on the model and the GPU, <code>torch.compile()</code> yields up to 30% speed-up during inference. To use <code>torch.compile()</code>, simply install any version of <code>torch</code> above 2.0.",Bt,C,xe=`Compiling a model takes time, so it’s useful if you are compiling the model only once instead of every time you infer.
To compile any computer vision model of your choice, call <code>torch.compile()</code> on the model as shown below:`,Ut,w,Zt,I,Ve='<code>compile()</code> comes with multiple modes for compiling, which essentially differ in compilation time and inference overhead. <code>max-autotune</code> takes longer than <code>reduce-overhead</code> but results in faster inference. Default mode is fastest for compilation but is not as efficient compared to <code>reduce-overhead</code> for inference time. In this guide, we used the default mode. You can learn more about it <a href="https://pytorch.org/get-started/pytorch-2.0/#user-experience" rel="nofollow">here</a>.',St,j,Xe="We benchmarked <code>torch.compile</code> with different computer vision models, tasks, types of hardware, and batch sizes on <code>torch</code> version 2.0.1.",Lt,k,zt,R,Ge="Below you can find the benchmarking code for each task. We warm up the GPU before inference and take the mean time of 300 inferences, using the same image each time.",Nt,J,Dt,E,Ht,_,Wt,B,Ot,U,xt,Z,Vt,S,Ae="Below you can find the list of the models we benchmarked.",Xt,L,Fe="<strong>Image Classification</strong>",Gt,z,Ye='<li><a href="https://huggingface.co/google/vit-base-patch16-224" rel="nofollow">google/vit-base-patch16-224</a></li> <li><a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k-ft22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k-ft22k</a></li> <li><a href="https://huggingface.co/facebook/convnext-large-224" rel="nofollow">facebook/convnext-large-224</a></li> <li><a href="https://huggingface.co/" rel="nofollow">microsoft/resnet-50</a></li>',At,N,qe="<strong>Image Segmentation</strong>",Ft,D,Pe='<li><a href="https://huggingface.co/nvidia/segformer-b0-finetuned-ade-512-512" rel="nofollow">nvidia/segformer-b0-finetuned-ade-512-512</a></li> <li><a href="https://huggingface.co/facebook/mask2former-swin-tiny-coco-panoptic" rel="nofollow">facebook/mask2former-swin-tiny-coco-panoptic</a></li> <li><a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a></li> <li><a href="https://huggingface.co/google/deeplabv3_mobilenet_v2_1.0_513" rel="nofollow">google/deeplabv3_mobilenet_v2_1.0_513</a></li>',Yt,H,Qe="<strong>Object Detection</strong>",qt,W,Ke='<li><a href="https://huggingface.co/google/owlvit-base-patch32" rel="nofollow">google/owlvit-base-patch32</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-101" rel="nofollow">facebook/detr-resnet-101</a></li> <li><a href="https://huggingface.co/microsoft/conditional-detr-resnet-50" rel="nofollow">microsoft/conditional-detr-resnet-50</a></li>',Pt,O,tn="Below you can find visualization of inference durations with and without <code>torch.compile()</code> and percentage improvements for each model in different hardware and batch sizes.",Qt,T,en='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/a100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/t4_batch_comp.png"/></div>',Kt,M,nn='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_duration.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_percentage.png"/></div>',te,x,rn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_1_duration.png" alt="Duration Comparison on V100 with Batch Size of 1"/>',ee,V,an='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/T4_4_percentage.png" alt="Percentage Improvement on T4 with Batch Size of 4"/>',ne,X,ln="Below you can find inference durations in milliseconds for each model with and without <code>compile()</code>. Note that OwlViT results in OOM in larger batch sizes.",ie,G,re,A,dn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">9.325</td> <td align="center">7.584</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">11.759</td> <td align="center">10.500</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">24.978</td> <td align="center">18.420</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.282</td> <td align="center">8.448</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">34.619</td> <td align="center">19.040</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">10.410</td> <td align="center">10.208</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.531</td> <td align="center">4.124</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">60.188</td> <td align="center">49.117</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">75.764</td> <td align="center">59.487</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">8.583</td> <td align="center">3.974</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">36.276</td> <td align="center">18.197</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">31.219</td> <td align="center">17.993</td></tr></tbody>',ae,F,le,Y,cn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">14.832</td> <td align="center">14.499</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">18.838</td> <td align="center">16.476</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">13.205</td> <td align="center">13.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">48.657</td> <td align="center">32.418</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">22.940</td> <td align="center">21.631</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.657</td> <td align="center">4.268</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">74.277</td> <td align="center">61.781</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">180.700</td> <td align="center">159.116</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">14.174</td> <td align="center">8.515</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">68.101</td> <td align="center">44.998</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">56.470</td> <td align="center">35.552</td></tr></tbody>',de,q,ce,P,gn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">40.944</td> <td align="center">40.010</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">37.005</td> <td align="center">31.144</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">41.854</td> <td align="center">41.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">164.382</td> <td align="center">161.902</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">82.258</td> <td align="center">75.561</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">7.018</td> <td align="center">5.024</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">178.945</td> <td align="center">154.814</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">638.570</td> <td align="center">579.826</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">51.693</td> <td align="center">30.310</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">232.887</td> <td align="center">155.021</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">180.491</td> <td align="center">124.032</td></tr></tbody>',ge,Q,oe,K,on='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">10.495</td> <td align="center">6.00</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">13.321</td> <td align="center">5.862</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">25.769</td> <td align="center">22.395</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.347</td> <td align="center">7.234</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">33.951</td> <td align="center">19.388</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">11.623</td> <td align="center">10.412</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.484</td> <td align="center">3.820</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">64.640</td> <td align="center">49.873</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">95.532</td> <td align="center">72.207</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">9.217</td> <td align="center">4.753</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">52.818</td> <td align="center">28.367</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">39.512</td> <td align="center">20.816</td></tr></tbody>',se,tt,me,et,sn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">15.181</td> <td align="center">14.501</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.787</td> <td align="center">16.188</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">15.171</td> <td align="center">14.753</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">88.529</td> <td align="center">64.195</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">29.574</td> <td align="center">27.085</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.109</td> <td align="center">4.731</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">90.402</td> <td align="center">76.926</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">234.261</td> <td align="center">205.456</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">24.623</td> <td align="center">14.816</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">134.672</td> <td align="center">101.304</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">97.464</td> <td align="center">69.739</td></tr></tbody>',he,nt,fe,it,mn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">52.209</td> <td align="center">51.633</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">61.013</td> <td align="center">55.499</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">53.938</td> <td align="center">53.581</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">109.682</td> <td align="center">100.771</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">14.857</td> <td align="center">12.089</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">249.605</td> <td align="center">222.801</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">831.142</td> <td align="center">743.645</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">93.129</td> <td align="center">55.365</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">482.425</td> <td align="center">361.843</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">344.661</td> <td align="center">255.298</td></tr></tbody>',pe,rt,be,at,hn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">16.520</td> <td align="center">15.786</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.116</td> <td align="center">14.205</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">53.634</td> <td align="center">51.105</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16.464</td> <td align="center">15.710</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">73.100</td> <td align="center">53.99</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">32.932</td> <td align="center">30.845</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.031</td> <td align="center">4.321</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">79.192</td> <td align="center">66.815</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">200.026</td> <td align="center">188.268</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">18.908</td> <td align="center">11.997</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">106.622</td> <td align="center">82.566</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">77.594</td> <td align="center">56.984</td></tr></tbody>',Te,lt,Me,dt,fn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">43.653</td> <td align="center">43.626</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">45.327</td> <td align="center">42.445</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">52.007</td> <td align="center">51.354</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">277.850</td> <td align="center">268.003</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">119.259</td> <td align="center">105.580</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">13.039</td> <td align="center">11.388</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">201.540</td> <td align="center">184.670</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">764.052</td> <td align="center">711.280</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">74.289</td> <td align="center">48.677</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">421.859</td> <td align="center">357.614</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">289.002</td> <td align="center">226.945</td></tr></tbody>',ue,ct,ye,gt,pn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">163.914</td> <td align="center">160.907</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">192.412</td> <td align="center">163.620</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">188.978</td> <td align="center">187.976</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">422.886</td> <td align="center">388.078</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">44.114</td> <td align="center">37.604</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">756.337</td> <td align="center">695.291</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">2842.940</td> <td align="center">2656.88</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">299.003</td> <td align="center">201.942</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">1619.505</td> <td align="center">1262.758</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">1137.513</td> <td align="center">897.390</td></tr></tbody>',ve,ot,$e,st,bn='We also benchmarked on PyTorch nightly (2.1.0dev, find the wheel <a href="https://download.pytorch.org/whl/nightly/cu118" rel="nofollow">here</a>) and observed improvement in latency both for uncompiled and compiled models.',Ce,mt,we,ht,Tn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - no compile</strong></th> <th align="center"><strong>torch 2.0 -<br/> compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">12.462</td> <td align="center">6.954</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">14.109</td> <td align="center">12.851</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">30.484</td> <td align="center">15.221</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">46.816</td> <td align="center">30.942</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">163.749</td> <td align="center">163.706</td></tr></tbody>',Ie,ft,je,pt,Mn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">14.408</td> <td align="center">14.052</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">47.381</td> <td align="center">46.604</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">68.382</td> <td align="center">53.481</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">269.615</td> <td align="center">204.785</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',ke,bt,un="### V100",Re,Tt,yn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">13.477</td> <td align="center">7.926</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">15.103</td> <td align="center">14.378</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">52.517</td> <td align="center">51.691</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">28.706</td> <td align="center">19.077</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">88.402</td> <td align="center">62.949</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',Je,Mt,Ee,ut,vn="We benchmarked <code>reduce-overhead</code> compilation mode for A100 and T4 in Nightly.",_e,yt,Be,vt,$n='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">11.758</td> <td align="center">7.335</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">23.171</td> <td align="center">21.490</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">7.435</td> <td align="center">3.801</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">7.261</td> <td align="center">2.187</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">32.823</td> <td align="center">11.627</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">50.622</td> <td align="center">33.831</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">9.869</td> <td align="center">4.244</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">14.385</td> <td align="center">7.946</td></tr></tbody>',Ue,$t,Ze,Ct,Cn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">32.137</td> <td align="center">31.84</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">120.944</td> <td align="center">110.209</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">9.761</td> <td align="center">7.698</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">15.215</td> <td align="center">13.871</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">72.150</td> <td align="center">57.660</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">301.494</td> <td align="center">247.543</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">22.266</td> <td align="center">19.339</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">78.311</td> <td align="center">50.983</td></tr></tbody>',Se,wt,Le,jt,ze;return u=new p({props:{title:"Optimize inference using torch.compile()",local:"optimize-inference-using-torchcompile",headingTag:"h1"}}),v=new p({props:{title:"Benefits of torch.compile",local:"benefits-of-torchcompile",headingTag:"h2"}}),w=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKE1PREVMX0lEKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCk=",highlighted:`from transformers import AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(MODEL_ID).to(&quot;cuda&quot;)
<span class="hljs-addition">+ model = torch.compile(model)</span>`,wrap:!1}}),k=new p({props:{title:"Benchmarking code",local:"benchmarking-code",headingTag:"h2"}}),J=new p({props:{title:"Image Classification with ViT",local:"image-classification-with-vit",headingTag:"h3"}}),E=new De({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEElMEFwcm9jZXNzZWRfaW5wdXQlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCdwdCcpLnRvKGRldmljZSUzRCUyMmN1ZGElMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBtb2RlbCgqKnByb2Nlc3NlZF9pbnB1dCklMEE=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForImageClassification

url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)

processed_input = processor(image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**processed_input)
`,wrap:!1}}),_=new p({props:{title:"Object Detection with DETR",local:"object-detection-with-detr",headingTag:"h4"}}),B=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMikudG8oJTIyY3VkYSUyMiklMEFtb2RlbCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUobW9kZWwpJTBBJTBBdGV4dHMlMjAlM0QlMjAlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRzJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwbW9kZWwoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)

texts = [<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]
inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**inputs)`,wrap:!1}}),U=new p({props:{title:"Image Segmentation with Segformer",local:"image-segmentation-with-segformer",headingTag:"h4"}}),Z=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlZ2Zvcm1lckltYWdlUHJvY2Vzc29yJTJDJTIwU2VnZm9ybWVyRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTZWdmb3JtZXJJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybnZpZGlhJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyMFNlZ2Zvcm1lckZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJudmlkaWElMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEFzZWdfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwXyUyMCUzRCUyMG1vZGVsKCoqc2VnX2lucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SegformerImageProcessor, SegformerForSemanticSegmentation

processor = SegformerImageProcessor.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>)
model = SegformerForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)
seg_inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**seg_inputs)`,wrap:!1}}),G=new p({props:{title:"A100 (batch size: 1)",local:"a100-batch-size-1",headingTag:"h3"}}),F=new p({props:{title:"A100 (batch size: 4)",local:"a100-batch-size-4",headingTag:"h3"}}),q=new p({props:{title:"A100 (batch size: 16)",local:"a100-batch-size-16",headingTag:"h3"}}),Q=new p({props:{title:"V100 (batch size: 1)",local:"v100-batch-size-1",headingTag:"h3"}}),tt=new p({props:{title:"V100 (batch size: 4)",local:"v100-batch-size-4",headingTag:"h3"}}),nt=new p({props:{title:"V100 (batch size: 16)",local:"v100-batch-size-16",headingTag:"h3"}}),rt=new p({props:{title:"T4 (batch size: 1)",local:"t4-batch-size-1",headingTag:"h3"}}),lt=new p({props:{title:"T4 (batch size: 4)",local:"t4-batch-size-4",headingTag:"h3"}}),ct=new p({props:{title:"T4 (batch size: 16)",local:"t4-batch-size-16",headingTag:"h3"}}),ot=new p({props:{title:"PyTorch Nightly",local:"pytorch-nightly",headingTag:"h2"}}),mt=new p({props:{title:"A100",local:"a100",headingTag:"h3"}}),ft=new p({props:{title:"T4",local:"t4",headingTag:"h3"}}),Mt=new p({props:{title:"Reduce Overhead",local:"reduce-overhead",headingTag:"h2"}}),yt=new p({props:{title:"A100",local:"a100",headingTag:"h3"}}),$t=new p({props:{title:"T4",local:"t4",headingTag:"h3"}}),wt=new Bn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/perf_torch_compile.md"}}),{c(){b=l("meta"),kt=r(),It=l("p"),Rt=r(),g(u.$$.fragment),Jt=r(),y=l("p"),y.innerHTML=We,Et=r(),g(v.$$.fragment),_t=r(),$=l("p"),$.innerHTML=Oe,Bt=r(),C=l("p"),C.innerHTML=xe,Ut=r(),g(w.$$.fragment),Zt=r(),I=l("p"),I.innerHTML=Ve,St=r(),j=l("p"),j.innerHTML=Xe,Lt=r(),g(k.$$.fragment),zt=r(),R=l("p"),R.textContent=Ge,Nt=r(),g(J.$$.fragment),Dt=r(),g(E.$$.fragment),Ht=r(),g(_.$$.fragment),Wt=r(),g(B.$$.fragment),Ot=r(),g(U.$$.fragment),xt=r(),g(Z.$$.fragment),Vt=r(),S=l("p"),S.textContent=Ae,Xt=r(),L=l("p"),L.innerHTML=Fe,Gt=r(),z=l("ul"),z.innerHTML=Ye,At=r(),N=l("p"),N.innerHTML=qe,Ft=r(),D=l("ul"),D.innerHTML=Pe,Yt=r(),H=l("p"),H.innerHTML=Qe,qt=r(),W=l("ul"),W.innerHTML=Ke,Pt=r(),O=l("p"),O.innerHTML=tn,Qt=r(),T=l("div"),T.innerHTML=en,Kt=r(),M=l("div"),M.innerHTML=nn,te=r(),x=l("p"),x.innerHTML=rn,ee=r(),V=l("p"),V.innerHTML=an,ne=r(),X=l("p"),X.innerHTML=ln,ie=r(),g(G.$$.fragment),re=r(),A=l("table"),A.innerHTML=dn,ae=r(),g(F.$$.fragment),le=r(),Y=l("table"),Y.innerHTML=cn,de=r(),g(q.$$.fragment),ce=r(),P=l("table"),P.innerHTML=gn,ge=r(),g(Q.$$.fragment),oe=r(),K=l("table"),K.innerHTML=on,se=r(),g(tt.$$.fragment),me=r(),et=l("table"),et.innerHTML=sn,he=r(),g(nt.$$.fragment),fe=r(),it=l("table"),it.innerHTML=mn,pe=r(),g(rt.$$.fragment),be=r(),at=l("table"),at.innerHTML=hn,Te=r(),g(lt.$$.fragment),Me=r(),dt=l("table"),dt.innerHTML=fn,ue=r(),g(ct.$$.fragment),ye=r(),gt=l("table"),gt.innerHTML=pn,ve=r(),g(ot.$$.fragment),$e=r(),st=l("p"),st.innerHTML=bn,Ce=r(),g(mt.$$.fragment),we=r(),ht=l("table"),ht.innerHTML=Tn,Ie=r(),g(ft.$$.fragment),je=r(),pt=l("table"),pt.innerHTML=Mn,ke=r(),bt=l("p"),bt.textContent=un,Re=r(),Tt=l("table"),Tt.innerHTML=yn,Je=r(),g(Mt.$$.fragment),Ee=r(),ut=l("p"),ut.innerHTML=vn,_e=r(),g(yt.$$.fragment),Be=r(),vt=l("table"),vt.innerHTML=$n,Ue=r(),g($t.$$.fragment),Ze=r(),Ct=l("table"),Ct.innerHTML=Cn,Se=r(),g(wt.$$.fragment),Le=r(),jt=l("p"),this.h()},l(t){const e=En("svelte-u9bgzb",document.head);b=d(e,"META",{name:!0,content:!0}),e.forEach(n),kt=a(t),It=d(t,"P",{}),wn(It).forEach(n),Rt=a(t),o(u.$$.fragment,t),Jt=a(t),y=d(t,"P",{"data-svelte-h":!0}),c(y)!=="svelte-a1xmpp"&&(y.innerHTML=We),Et=a(t),o(v.$$.fragment,t),_t=a(t),$=d(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-108lixw"&&($.innerHTML=Oe),Bt=a(t),C=d(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1b66kne"&&(C.innerHTML=xe),Ut=a(t),o(w.$$.fragment,t),Zt=a(t),I=d(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-13c27qn"&&(I.innerHTML=Ve),St=a(t),j=d(t,"P",{"data-svelte-h":!0}),c(j)!=="svelte-116qe4s"&&(j.innerHTML=Xe),Lt=a(t),o(k.$$.fragment,t),zt=a(t),R=d(t,"P",{"data-svelte-h":!0}),c(R)!=="svelte-2dld2n"&&(R.textContent=Ge),Nt=a(t),o(J.$$.fragment,t),Dt=a(t),o(E.$$.fragment,t),Ht=a(t),o(_.$$.fragment,t),Wt=a(t),o(B.$$.fragment,t),Ot=a(t),o(U.$$.fragment,t),xt=a(t),o(Z.$$.fragment,t),Vt=a(t),S=d(t,"P",{"data-svelte-h":!0}),c(S)!=="svelte-fbvml8"&&(S.textContent=Ae),Xt=a(t),L=d(t,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1pzh5ag"&&(L.innerHTML=Fe),Gt=a(t),z=d(t,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-i1xpay"&&(z.innerHTML=Ye),At=a(t),N=d(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-vq25eq"&&(N.innerHTML=qe),Ft=a(t),D=d(t,"UL",{"data-svelte-h":!0}),c(D)!=="svelte-1vcuz7e"&&(D.innerHTML=Pe),Yt=a(t),H=d(t,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1e8jpwt"&&(H.innerHTML=Qe),qt=a(t),W=d(t,"UL",{"data-svelte-h":!0}),c(W)!=="svelte-yhf9tm"&&(W.innerHTML=Ke),Pt=a(t),O=d(t,"P",{"data-svelte-h":!0}),c(O)!=="svelte-7yg5eu"&&(O.innerHTML=tn),Qt=a(t),T=d(t,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-1jw9wmi"&&(T.innerHTML=en),Kt=a(t),M=d(t,"DIV",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-nlzsqo"&&(M.innerHTML=nn),te=a(t),x=d(t,"P",{"data-svelte-h":!0}),c(x)!=="svelte-gdeipd"&&(x.innerHTML=rn),ee=a(t),V=d(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1cusdpa"&&(V.innerHTML=an),ne=a(t),X=d(t,"P",{"data-svelte-h":!0}),c(X)!=="svelte-16crmf3"&&(X.innerHTML=ln),ie=a(t),o(G.$$.fragment,t),re=a(t),A=d(t,"TABLE",{"data-svelte-h":!0}),c(A)!=="svelte-6uvhqg"&&(A.innerHTML=dn),ae=a(t),o(F.$$.fragment,t),le=a(t),Y=d(t,"TABLE",{"data-svelte-h":!0}),c(Y)!=="svelte-f4zjoc"&&(Y.innerHTML=cn),de=a(t),o(q.$$.fragment,t),ce=a(t),P=d(t,"TABLE",{"data-svelte-h":!0}),c(P)!=="svelte-9ju0ii"&&(P.innerHTML=gn),ge=a(t),o(Q.$$.fragment,t),oe=a(t),K=d(t,"TABLE",{"data-svelte-h":!0}),c(K)!=="svelte-18ncoxq"&&(K.innerHTML=on),se=a(t),o(tt.$$.fragment,t),me=a(t),et=d(t,"TABLE",{"data-svelte-h":!0}),c(et)!=="svelte-15udyd3"&&(et.innerHTML=sn),he=a(t),o(nt.$$.fragment,t),fe=a(t),it=d(t,"TABLE",{"data-svelte-h":!0}),c(it)!=="svelte-rw07j7"&&(it.innerHTML=mn),pe=a(t),o(rt.$$.fragment,t),be=a(t),at=d(t,"TABLE",{"data-svelte-h":!0}),c(at)!=="svelte-37x5jw"&&(at.innerHTML=hn),Te=a(t),o(lt.$$.fragment,t),Me=a(t),dt=d(t,"TABLE",{"data-svelte-h":!0}),c(dt)!=="svelte-1mc5027"&&(dt.innerHTML=fn),ue=a(t),o(ct.$$.fragment,t),ye=a(t),gt=d(t,"TABLE",{"data-svelte-h":!0}),c(gt)!=="svelte-10eiin7"&&(gt.innerHTML=pn),ve=a(t),o(ot.$$.fragment,t),$e=a(t),st=d(t,"P",{"data-svelte-h":!0}),c(st)!=="svelte-ov5yx8"&&(st.innerHTML=bn),Ce=a(t),o(mt.$$.fragment,t),we=a(t),ht=d(t,"TABLE",{"data-svelte-h":!0}),c(ht)!=="svelte-1cg5nyy"&&(ht.innerHTML=Tn),Ie=a(t),o(ft.$$.fragment,t),je=a(t),pt=d(t,"TABLE",{"data-svelte-h":!0}),c(pt)!=="svelte-1nlzppe"&&(pt.innerHTML=Mn),ke=a(t),bt=d(t,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-l1xtas"&&(bt.textContent=un),Re=a(t),Tt=d(t,"TABLE",{"data-svelte-h":!0}),c(Tt)!=="svelte-ok1p6e"&&(Tt.innerHTML=yn),Je=a(t),o(Mt.$$.fragment,t),Ee=a(t),ut=d(t,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1axz5ve"&&(ut.innerHTML=vn),_e=a(t),o(yt.$$.fragment,t),Be=a(t),vt=d(t,"TABLE",{"data-svelte-h":!0}),c(vt)!=="svelte-13rnx0"&&(vt.innerHTML=$n),Ue=a(t),o($t.$$.fragment,t),Ze=a(t),Ct=d(t,"TABLE",{"data-svelte-h":!0}),c(Ct)!=="svelte-oh2zql"&&(Ct.innerHTML=Cn),Se=a(t),o(wt.$$.fragment,t),Le=a(t),jt=d(t,"P",{}),wn(jt).forEach(n),this.h()},h(){Ne(b,"name","hf:doc:metadata"),Ne(b,"content",Zn),Ne(T,"class","flex"),Ne(M,"class","flex")},m(t,e){_n(document.head,b),i(t,kt,e),i(t,It,e),i(t,Rt,e),s(u,t,e),i(t,Jt,e),i(t,y,e),i(t,Et,e),s(v,t,e),i(t,_t,e),i(t,$,e),i(t,Bt,e),i(t,C,e),i(t,Ut,e),s(w,t,e),i(t,Zt,e),i(t,I,e),i(t,St,e),i(t,j,e),i(t,Lt,e),s(k,t,e),i(t,zt,e),i(t,R,e),i(t,Nt,e),s(J,t,e),i(t,Dt,e),s(E,t,e),i(t,Ht,e),s(_,t,e),i(t,Wt,e),s(B,t,e),i(t,Ot,e),s(U,t,e),i(t,xt,e),s(Z,t,e),i(t,Vt,e),i(t,S,e),i(t,Xt,e),i(t,L,e),i(t,Gt,e),i(t,z,e),i(t,At,e),i(t,N,e),i(t,Ft,e),i(t,D,e),i(t,Yt,e),i(t,H,e),i(t,qt,e),i(t,W,e),i(t,Pt,e),i(t,O,e),i(t,Qt,e),i(t,T,e),i(t,Kt,e),i(t,M,e),i(t,te,e),i(t,x,e),i(t,ee,e),i(t,V,e),i(t,ne,e),i(t,X,e),i(t,ie,e),s(G,t,e),i(t,re,e),i(t,A,e),i(t,ae,e),s(F,t,e),i(t,le,e),i(t,Y,e),i(t,de,e),s(q,t,e),i(t,ce,e),i(t,P,e),i(t,ge,e),s(Q,t,e),i(t,oe,e),i(t,K,e),i(t,se,e),s(tt,t,e),i(t,me,e),i(t,et,e),i(t,he,e),s(nt,t,e),i(t,fe,e),i(t,it,e),i(t,pe,e),s(rt,t,e),i(t,be,e),i(t,at,e),i(t,Te,e),s(lt,t,e),i(t,Me,e),i(t,dt,e),i(t,ue,e),s(ct,t,e),i(t,ye,e),i(t,gt,e),i(t,ve,e),s(ot,t,e),i(t,$e,e),i(t,st,e),i(t,Ce,e),s(mt,t,e),i(t,we,e),i(t,ht,e),i(t,Ie,e),s(ft,t,e),i(t,je,e),i(t,pt,e),i(t,ke,e),i(t,bt,e),i(t,Re,e),i(t,Tt,e),i(t,Je,e),s(Mt,t,e),i(t,Ee,e),i(t,ut,e),i(t,_e,e),s(yt,t,e),i(t,Be,e),i(t,vt,e),i(t,Ue,e),s($t,t,e),i(t,Ze,e),i(t,Ct,e),i(t,Se,e),s(wt,t,e),i(t,Le,e),i(t,jt,e),ze=!0},p:jn,i(t){ze||(m(u.$$.fragment,t),m(v.$$.fragment,t),m(w.$$.fragment,t),m(k.$$.fragment,t),m(J.$$.fragment,t),m(E.$$.fragment,t),m(_.$$.fragment,t),m(B.$$.fragment,t),m(U.$$.fragment,t),m(Z.$$.fragment,t),m(G.$$.fragment,t),m(F.$$.fragment,t),m(q.$$.fragment,t),m(Q.$$.fragment,t),m(tt.$$.fragment,t),m(nt.$$.fragment,t),m(rt.$$.fragment,t),m(lt.$$.fragment,t),m(ct.$$.fragment,t),m(ot.$$.fragment,t),m(mt.$$.fragment,t),m(ft.$$.fragment,t),m(Mt.$$.fragment,t),m(yt.$$.fragment,t),m($t.$$.fragment,t),m(wt.$$.fragment,t),ze=!0)},o(t){h(u.$$.fragment,t),h(v.$$.fragment,t),h(w.$$.fragment,t),h(k.$$.fragment,t),h(J.$$.fragment,t),h(E.$$.fragment,t),h(_.$$.fragment,t),h(B.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(F.$$.fragment,t),h(q.$$.fragment,t),h(Q.$$.fragment,t),h(tt.$$.fragment,t),h(nt.$$.fragment,t),h(rt.$$.fragment,t),h(lt.$$.fragment,t),h(ct.$$.fragment,t),h(ot.$$.fragment,t),h(mt.$$.fragment,t),h(ft.$$.fragment,t),h(Mt.$$.fragment,t),h(yt.$$.fragment,t),h($t.$$.fragment,t),h(wt.$$.fragment,t),ze=!1},d(t){t&&(n(kt),n(It),n(Rt),n(Jt),n(y),n(Et),n(_t),n($),n(Bt),n(C),n(Ut),n(Zt),n(I),n(St),n(j),n(Lt),n(zt),n(R),n(Nt),n(Dt),n(Ht),n(Wt),n(Ot),n(xt),n(Vt),n(S),n(Xt),n(L),n(Gt),n(z),n(At),n(N),n(Ft),n(D),n(Yt),n(H),n(qt),n(W),n(Pt),n(O),n(Qt),n(T),n(Kt),n(M),n(te),n(x),n(ee),n(V),n(ne),n(X),n(ie),n(re),n(A),n(ae),n(le),n(Y),n(de),n(ce),n(P),n(ge),n(oe),n(K),n(se),n(me),n(et),n(he),n(fe),n(it),n(pe),n(be),n(at),n(Te),n(Me),n(dt),n(ue),n(ye),n(gt),n(ve),n($e),n(st),n(Ce),n(we),n(ht),n(Ie),n(je),n(pt),n(ke),n(bt),n(Re),n(Tt),n(Je),n(Ee),n(ut),n(_e),n(Be),n(vt),n(Ue),n(Ze),n(Ct),n(Se),n(Le),n(jt)),n(b),f(u,t),f(v,t),f(w,t),f(k,t),f(J,t),f(E,t),f(_,t),f(B,t),f(U,t),f(Z,t),f(G,t),f(F,t),f(q,t),f(Q,t),f(tt,t),f(nt,t),f(rt,t),f(lt,t),f(ct,t),f(ot,t),f(mt,t),f(ft,t),f(Mt,t),f(yt,t),f($t,t),f(wt,t)}}}const Zn='{"title":"Optimize inference using torch.compile()","local":"optimize-inference-using-torchcompile","sections":[{"title":"Benefits of torch.compile","local":"benefits-of-torchcompile","sections":[],"depth":2},{"title":"Benchmarking code","local":"benchmarking-code","sections":[{"title":"Image Classification with ViT","local":"image-classification-with-vit","sections":[{"title":"Object Detection with DETR","local":"object-detection-with-detr","sections":[],"depth":4},{"title":"Image Segmentation with Segformer","local":"image-segmentation-with-segformer","sections":[],"depth":4}],"depth":3},{"title":"A100 (batch size: 1)","local":"a100-batch-size-1","sections":[],"depth":3},{"title":"A100 (batch size: 4)","local":"a100-batch-size-4","sections":[],"depth":3},{"title":"A100 (batch size: 16)","local":"a100-batch-size-16","sections":[],"depth":3},{"title":"V100 (batch size: 1)","local":"v100-batch-size-1","sections":[],"depth":3},{"title":"V100 (batch size: 4)","local":"v100-batch-size-4","sections":[],"depth":3},{"title":"V100 (batch size: 16)","local":"v100-batch-size-16","sections":[],"depth":3},{"title":"T4 (batch size: 1)","local":"t4-batch-size-1","sections":[],"depth":3},{"title":"T4 (batch size: 4)","local":"t4-batch-size-4","sections":[],"depth":3},{"title":"T4 (batch size: 16)","local":"t4-batch-size-16","sections":[],"depth":3}],"depth":2},{"title":"PyTorch Nightly","local":"pytorch-nightly","sections":[{"title":"A100","local":"a100","sections":[],"depth":3},{"title":"T4","local":"t4","sections":[],"depth":3}],"depth":2},{"title":"Reduce Overhead","local":"reduce-overhead","sections":[{"title":"A100","local":"a100","sections":[],"depth":3},{"title":"T4","local":"t4","sections":[],"depth":3}],"depth":2}],"depth":1}';function Sn(He){return kn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hn extends Rn{constructor(b){super(),Jn(this,b,Sn,Un,In,{})}}export{Hn as component};
