import{s as Zs,n as ks,o as Bs}from"../chunks/scheduler.7bc62968.js";import{S as Cs,i as Gs,g as p,s as t,r as i,A as Es,h as o,f as a,c as n,j as bs,u as c,x as r,k as Is,y as $s,a as e,v as M,d as h,t as j,w as u}from"../chunks/index.66556066.js";import{C as js}from"../chunks/CodeBlock.a759539a.js";import{H as X,E as Ws}from"../chunks/EditOnGithub.46ca76a5.js";function Rs(us){let y,Y,A,F,J,H,d,rs="Official utilities to use the Hugging Face Hub API.",_,w,S,m,q,T,z,U,L,g,x,f,ys='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',P,b,Js='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',D,I,K,Z,O,k,ds='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',ss,B,ws="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",ls,C,as,G,ms='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',es,E,ts,$,Ts="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",ns,W,Us="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",ps,R,gs="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",os,Q,is,N,fs="<li><code>@huggingface/tasks</code> : Typings only</li>",cs,V,Ms,v,hs;return J=new X({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),w=new X({props:{title:"Install",local:"install",headingTag:"h2"}}),m=new js({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),T=new X({props:{title:"Deno",local:"deno",headingTag:"h3"}}),U=new js({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),g=new X({props:{title:"Usage",local:"usage",headingTag:"h2"}}),I=new js({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFiles, uploadFilesWithProgress, deleteFile, deleteRepo, listFiles, whoAmI } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> <span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> <span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> <span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),Z=new X({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),C=new js({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),E=new X({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),Q=new X({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),V=new Ws({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){y=p("meta"),Y=t(),A=p("p"),F=t(),i(J.$$.fragment),H=t(),d=p("p"),d.textContent=rs,_=t(),i(w.$$.fragment),S=t(),i(m.$$.fragment),q=t(),i(T.$$.fragment),z=t(),i(U.$$.fragment),L=t(),i(g.$$.fragment),x=t(),f=p("p"),f.innerHTML=ys,P=t(),b=p("p"),b.innerHTML=Js,D=t(),i(I.$$.fragment),K=t(),i(Z.$$.fragment),O=t(),k=p("p"),k.innerHTML=ds,ss=t(),B=p("p"),B.textContent=ws,ls=t(),i(C.$$.fragment),as=t(),G=p("p"),G.innerHTML=ms,es=t(),i(E.$$.fragment),ts=t(),$=p("p"),$.innerHTML=Ts,ns=t(),W=p("p"),W.innerHTML=Us,ps=t(),R=p("p"),R.innerHTML=gs,os=t(),i(Q.$$.fragment),is=t(),N=p("ul"),N.innerHTML=fs,cs=t(),i(V.$$.fragment),Ms=t(),v=p("p"),this.h()},l(s){const l=Es("svelte-u9bgzb",document.head);y=o(l,"META",{name:!0,content:!0}),l.forEach(a),Y=n(s),A=o(s,"P",{}),bs(A).forEach(a),F=n(s),c(J.$$.fragment,s),H=n(s),d=o(s,"P",{"data-svelte-h":!0}),r(d)!=="svelte-a2asrt"&&(d.textContent=rs),_=n(s),c(w.$$.fragment,s),S=n(s),c(m.$$.fragment,s),q=n(s),c(T.$$.fragment,s),z=n(s),c(U.$$.fragment,s),L=n(s),c(g.$$.fragment,s),x=n(s),f=o(s,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1nqczoz"&&(f.innerHTML=ys),P=n(s),b=o(s,"P",{"data-svelte-h":!0}),r(b)!=="svelte-6ptpin"&&(b.innerHTML=Js),D=n(s),c(I.$$.fragment,s),K=n(s),c(Z.$$.fragment,s),O=n(s),k=o(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-bfok93"&&(k.innerHTML=ds),ss=n(s),B=o(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1az135e"&&(B.textContent=ws),ls=n(s),c(C.$$.fragment,s),as=n(s),G=o(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1qsa6tj"&&(G.innerHTML=ms),es=n(s),c(E.$$.fragment,s),ts=n(s),$=o(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-1gspubq"&&($.innerHTML=Ts),ns=n(s),W=o(s,"P",{"data-svelte-h":!0}),r(W)!=="svelte-em0etc"&&(W.innerHTML=Us),ps=n(s),R=o(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-lja874"&&(R.innerHTML=gs),os=n(s),c(Q.$$.fragment,s),is=n(s),N=o(s,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-mopwlb"&&(N.innerHTML=fs),cs=n(s),c(V.$$.fragment,s),Ms=n(s),v=o(s,"P",{}),bs(v).forEach(a),this.h()},h(){Is(y,"name","hf:doc:metadata"),Is(y,"content",Qs)},m(s,l){$s(document.head,y),e(s,Y,l),e(s,A,l),e(s,F,l),M(J,s,l),e(s,H,l),e(s,d,l),e(s,_,l),M(w,s,l),e(s,S,l),M(m,s,l),e(s,q,l),M(T,s,l),e(s,z,l),M(U,s,l),e(s,L,l),M(g,s,l),e(s,x,l),e(s,f,l),e(s,P,l),e(s,b,l),e(s,D,l),M(I,s,l),e(s,K,l),M(Z,s,l),e(s,O,l),e(s,k,l),e(s,ss,l),e(s,B,l),e(s,ls,l),M(C,s,l),e(s,as,l),e(s,G,l),e(s,es,l),M(E,s,l),e(s,ts,l),e(s,$,l),e(s,ns,l),e(s,W,l),e(s,ps,l),e(s,R,l),e(s,os,l),M(Q,s,l),e(s,is,l),e(s,N,l),e(s,cs,l),M(V,s,l),e(s,Ms,l),e(s,v,l),hs=!0},p:ks,i(s){hs||(h(J.$$.fragment,s),h(w.$$.fragment,s),h(m.$$.fragment,s),h(T.$$.fragment,s),h(U.$$.fragment,s),h(g.$$.fragment,s),h(I.$$.fragment,s),h(Z.$$.fragment,s),h(C.$$.fragment,s),h(E.$$.fragment,s),h(Q.$$.fragment,s),h(V.$$.fragment,s),hs=!0)},o(s){j(J.$$.fragment,s),j(w.$$.fragment,s),j(m.$$.fragment,s),j(T.$$.fragment,s),j(U.$$.fragment,s),j(g.$$.fragment,s),j(I.$$.fragment,s),j(Z.$$.fragment,s),j(C.$$.fragment,s),j(E.$$.fragment,s),j(Q.$$.fragment,s),j(V.$$.fragment,s),hs=!1},d(s){s&&(a(Y),a(A),a(F),a(H),a(d),a(_),a(S),a(q),a(z),a(L),a(x),a(f),a(P),a(b),a(D),a(K),a(O),a(k),a(ss),a(B),a(ls),a(as),a(G),a(es),a(ts),a($),a(ns),a(W),a(ps),a(R),a(os),a(is),a(N),a(cs),a(Ms),a(v)),a(y),u(J,s),u(w,s),u(m,s),u(T,s),u(U,s),u(g,s),u(I,s),u(Z,s),u(C,s),u(E,s),u(Q,s),u(V,s)}}}const Qs='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Ns(us){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends Cs{constructor(y){super(),Gs(this,y,Ns,Rs,Zs,{})}}export{Ys as component};
