import{s as pe,n as ue,o as fe}from"../chunks/scheduler.9039eef2.js";import{S as he,i as be,g as o,s as l,r as m,A as ye,h as r,f as t,c as a,j as ce,u as c,x as d,k as de,y as Te,a as s,v as p,d as u,t as f,w as h}from"../chunks/index.cdcc3d35.js";import{C as K}from"../chunks/CodeBlock.e3ac94d9.js";import{H as ee}from"../chunks/Heading.96ce3702.js";function we(ne){let i,v,V,C,b,N,y,te='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/sentence-transformers/getting-started.ipynb" rel="nofollow">here</a>.</em>',R,T,se='This guide explains how to compile, load, and use <a href="https://www.sbert.net/" rel="nofollow">Sentence Transformers (SBERT)</a> models on AWS Inferentia2 with Optimum Neuron, enabling efficient calculation of embeddings. Sentence Transformers are powerful models for generating sentence embeddings. You can use this Sentence Transformers to compute sentence / text embeddings for more than 100 languages. These embeddings can then be compared e.g. with cosine-similarity to find sentences with a similar meaning. This can be useful for semantic textual similarity, semantic search, or paraphrase mining.',G,w,le="<em>Note: Currently only text models are supported, we are working on vision support for CLIP.</em>",H,M,z,J,ae="First, you need to convert your Sentence Transformers model to a format compatible with AWS Inferentia2. You can compile Sentence Transformers models with Optimum Neuron using the <code>optimum-cli</code> or <code>NeuronModelForSentenceTransformers</code> class. Below you will find an example for both approaches. We have to make sure <code>sentence-transformers</code> is installed. Thats only needed for exporting the model.",X,W,x,Z,oe="Here we will use the <code>NeuronModelForSentenceTransformers</code>, which can be used to convert any Sntence Transformers model to a format compatible with AWS Inferentia2 or load already converted models. When exporting models with the <code>NeuronModelForSentenceTransformers</code> you need to set <code>export=True</code> and define the input shape and batch size. The input shape is defined by the <code>sequence_length</code> and the batch size by <code>batch_size</code>.",Q,U,Y,g,re="Here we will use the <code>optimum-cli</code> to convert the model. Similar to the <code>NeuronModelForSentenceTransformers</code> we need to define our input shape and batch size. The input shape is defined by the <code>sequence_length</code> and the batch size by <code>batch_size</code>. The <code>optimum-cli</code> will automatically convert the model to a format compatible with AWS Inferentia2 and save it to the specified output directory.",F,j,A,_,L,I,ie="Once we have a compiled Sentence Transformers model, which we either exported ourselves or is available on the Hugging Face Hub, we can load it and run inference. For loading the model we can use the <code>NeuronModelForSentenceTransformers</code> class, which is an abstraction layer for the <code>SentenceTransformer</code> class. The <code>NeuronModelForSentenceTransformers</code> class will automatically pad the input to the specified <code>sequence_length</code> and run inference on AWS Inferentia2.",q,S,E,B,P,$,me='For deploying these models in a production environment, refer to the <a href="https://www.philschmid.de/inferentia2-embeddings" rel="nofollow">Amazon SageMaker Blog</a>.',O,k,D;return b=new ee({props:{title:"Sentence Transformers on AWS Inferentia with Optimum Neuron",local:"sentence-transformers-on-aws-inferentia-with-optimum-neuron",headingTag:"h1"}}),M=new ee({props:{title:"Convert Sentence Transformers model to AWS Inferentia2",local:"convert-sentence-transformers-model-to-aws-inferentia2",headingTag:"h2"}}),W=new K({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycw==",highlighted:"pip install sentence-transformers",wrap:!1}}),U=new K({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQSUwQSUyMyUyMFNlbnRlbmNlJTIwVHJhbnNmb3JtZXJzJTIwbW9kZWwlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMzg0JTdEJTIwJTIwJTIzJTIwbWFuZGF0b3J5JTIwc2hhcGVzJTBBJTBBJTIzJTIwTG9hZCUyMFRyYW5zZm9ybWVycyUyMG1vZGVsJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMEFXUyUyMEluZmVyZW50aWEyJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEElMjMlMjBTYXZlJTIwbW9kZWwlMjB0byUyMGRpc2slMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyYmdlX2VtYl9pbmYyJTJGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-comment"># Sentence Transformers model from HuggingFace</span>
model_id = <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">384</span>}  <span class="hljs-comment"># mandatory shapes</span>

<span class="hljs-comment"># Load Transformers model and export it to AWS Inferentia2</span>
model = NeuronModelForSentenceTransformers.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)

<span class="hljs-comment"># Save model to disk</span>
model.save_pretrained(<span class="hljs-string">&quot;bge_emb_inf2/&quot;</span>)`,wrap:!1}}),j=new K({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMEJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMC0tbGlicmFyeS1uYW1lJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwLS1zZXF1ZW5jZV9sZW5ndGglMjAzODQlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS10YXNrJTIwZmVhdHVyZS1leHRyYWN0aW9uJTIwYmdlX2VtYl9pbmYyJTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m BAAI/bge-small-en-v1.5 --library-name sentence_transformers --sequence_length 384 --batch_size 1 --task feature-extraction bge_emb_inf2/',wrap:!1}}),_=new ee({props:{title:"Load compiled Sentence Transformers model and run inference",local:"load-compiled-sentence-transformers-model-and-run-inference",headingTag:"h2"}}),S=new K({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWRfb3JfcGF0aCUyMCUzRCUyMCUyMmJnZV9lbWJfaW5mMiUyRiUyMiUwQXRva2VuaXplcl9pZCUyMCUzRCUyMCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZW50ZW5jZVRyYW5zZm9ybWVycy5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCh0b2tlbml6ZXJfaWQpJTBBJTBBJTIzJTIwUnVuJTIwaW5mZXJlbmNlJTBBcHJvbXB0JTIwJTNEJTIwJTIySSUyMGxpa2UlMjB0byUyMGVhdCUyMGFwcGxlcyUyMiUwQWVuY29kZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QncHQnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kZWRfaW5wdXQpJTBBJTBBdG9rZW5fZW1iZWRkaW5ncyUyMCUzRCUyMG91dHB1dHMudG9rZW5fZW1iZWRkaW5ncyUwQXNlbnRlbmNlX2VtYmVkZGluZyUyMCUzRCUyMG91dHB1dHMuc2VudGVuY2VfZW1iZWRkaW5nJTBBJTBBcHJpbnQoZiUyMnRva2VuJTIwZW1iZWRkaW5ncyUzQSUyMCU3QnRva2VuX2VtYmVkZGluZ3Muc2hhcGUlN0QlMjIpJTIwJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwNyUyQyUyMDM4NCU1RCklMEFwcmludChmJTIyc2VudGVuY2VfZW1iZWRkaW5nJTNBJTIwJTdCc2VudGVuY2VfZW1iZWRkaW5nLnNoYXBlJTdEJTIyKSUyMCUyMyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDM4NCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

model_id_or_path = <span class="hljs-string">&quot;bge_emb_inf2/&quot;</span>
tokenizer_id = <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>

<span class="hljs-comment"># Load model and tokenizer</span>
model = NeuronModelForSentenceTransformers.from_pretrained(model_id_or_path)
tokenizer = AutoTokenizer.from_pretrained(tokenizer_id)

<span class="hljs-comment"># Run inference</span>
prompt = <span class="hljs-string">&quot;I like to eat apples&quot;</span>
encoded_input = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>)
outputs = model(**encoded_input)

token_embeddings = outputs.token_embeddings
sentence_embedding = outputs.sentence_embedding

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;token embeddings: <span class="hljs-subst">{token_embeddings.shape}</span>&quot;</span>) <span class="hljs-comment"># torch.Size([1, 7, 384])</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sentence_embedding: <span class="hljs-subst">{sentence_embedding.shape}</span>&quot;</span>) <span class="hljs-comment"># torch.Size([1, 384])</span>`,wrap:!1}}),B=new ee({props:{title:"Production Usage",local:"production-usage",headingTag:"h2"}}),{c(){i=o("meta"),v=l(),V=o("p"),C=l(),m(b.$$.fragment),N=l(),y=o("p"),y.innerHTML=te,R=l(),T=o("p"),T.innerHTML=se,G=l(),w=o("p"),w.innerHTML=le,H=l(),m(M.$$.fragment),z=l(),J=o("p"),J.innerHTML=ae,X=l(),m(W.$$.fragment),x=l(),Z=o("p"),Z.innerHTML=oe,Q=l(),m(U.$$.fragment),Y=l(),g=o("p"),g.innerHTML=re,F=l(),m(j.$$.fragment),A=l(),m(_.$$.fragment),L=l(),I=o("p"),I.innerHTML=ie,q=l(),m(S.$$.fragment),E=l(),m(B.$$.fragment),P=l(),$=o("p"),$.innerHTML=me,O=l(),k=o("p"),this.h()},l(e){const n=ye("svelte-u9bgzb",document.head);i=r(n,"META",{name:!0,content:!0}),n.forEach(t),v=a(e),V=r(e,"P",{}),ce(V).forEach(t),C=a(e),c(b.$$.fragment,e),N=a(e),y=r(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-z9n49l"&&(y.innerHTML=te),R=a(e),T=r(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-12xwboz"&&(T.innerHTML=se),G=a(e),w=r(e,"P",{"data-svelte-h":!0}),d(w)!=="svelte-opaxfq"&&(w.innerHTML=le),H=a(e),c(M.$$.fragment,e),z=a(e),J=r(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-3c4dyj"&&(J.innerHTML=ae),X=a(e),c(W.$$.fragment,e),x=a(e),Z=r(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-h22i3c"&&(Z.innerHTML=oe),Q=a(e),c(U.$$.fragment,e),Y=a(e),g=r(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-reiugv"&&(g.innerHTML=re),F=a(e),c(j.$$.fragment,e),A=a(e),c(_.$$.fragment,e),L=a(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-4dcngh"&&(I.innerHTML=ie),q=a(e),c(S.$$.fragment,e),E=a(e),c(B.$$.fragment,e),P=a(e),$=r(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-qum7z"&&($.innerHTML=me),O=a(e),k=r(e,"P",{}),ce(k).forEach(t),this.h()},h(){de(i,"name","hf:doc:metadata"),de(i,"content",Me)},m(e,n){Te(document.head,i),s(e,v,n),s(e,V,n),s(e,C,n),p(b,e,n),s(e,N,n),s(e,y,n),s(e,R,n),s(e,T,n),s(e,G,n),s(e,w,n),s(e,H,n),p(M,e,n),s(e,z,n),s(e,J,n),s(e,X,n),p(W,e,n),s(e,x,n),s(e,Z,n),s(e,Q,n),p(U,e,n),s(e,Y,n),s(e,g,n),s(e,F,n),p(j,e,n),s(e,A,n),p(_,e,n),s(e,L,n),s(e,I,n),s(e,q,n),p(S,e,n),s(e,E,n),p(B,e,n),s(e,P,n),s(e,$,n),s(e,O,n),s(e,k,n),D=!0},p:ue,i(e){D||(u(b.$$.fragment,e),u(M.$$.fragment,e),u(W.$$.fragment,e),u(U.$$.fragment,e),u(j.$$.fragment,e),u(_.$$.fragment,e),u(S.$$.fragment,e),u(B.$$.fragment,e),D=!0)},o(e){f(b.$$.fragment,e),f(M.$$.fragment,e),f(W.$$.fragment,e),f(U.$$.fragment,e),f(j.$$.fragment,e),f(_.$$.fragment,e),f(S.$$.fragment,e),f(B.$$.fragment,e),D=!1},d(e){e&&(t(v),t(V),t(C),t(N),t(y),t(R),t(T),t(G),t(w),t(H),t(z),t(J),t(X),t(x),t(Z),t(Q),t(Y),t(g),t(F),t(A),t(L),t(I),t(q),t(E),t(P),t($),t(O),t(k)),t(i),h(b,e),h(M,e),h(W,e),h(U,e),h(j,e),h(_,e),h(S,e),h(B,e)}}}const Me='{"title":"Sentence Transformers on AWS Inferentia with Optimum Neuron","local":"sentence-transformers-on-aws-inferentia-with-optimum-neuron","sections":[{"title":"Convert Sentence Transformers model to AWS Inferentia2","local":"convert-sentence-transformers-model-to-aws-inferentia2","sections":[],"depth":2},{"title":"Load compiled Sentence Transformers model and run inference","local":"load-compiled-sentence-transformers-model-and-run-inference","sections":[],"depth":2},{"title":"Production Usage","local":"production-usage","sections":[],"depth":2}],"depth":1}';function Je(ne){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class je extends he{constructor(i){super(),be(this,i,Je,we,pe,{})}}export{je as component};
