import{s as Et,o as qt,n as _e}from"../chunks/scheduler.182ea377.js";import{S as zt,i as Qt,g as c,s as o,r as g,A as Yt,h as f,f as s,c as r,j as P,u as h,x as M,k,y as l,a as d,v as _,d as b,t as y,w as v}from"../chunks/index.abf12888.js";import{T as At}from"../chunks/Tip.230e2334.js";import{D as N}from"../chunks/Docstring.93f6f462.js";import{C as Ge}from"../chunks/CodeBlock.57fe6e13.js";import{E as Je}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Ce}from"../chunks/Heading.16916d63.js";function Ot(x){let n,w='Make sure to check out the Schedulers <a href="/using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="/using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){n=c("p"),n.innerHTML=w},l(p){n=f(p,"P",{"data-svelte-h":!0}),M(n)!=="svelte-5fcsv6"&&(n.innerHTML=w)},m(p,i){d(p,n,i)},p:_e,d(p){p&&s(n)}}}function Ht(x){let n,w="Examples:",p,i,u;return i=new Ge({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFZlcnNhdGlsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEElMjMlMjBsZXQncyUyMGRvd25sb2FkJTIwYW4lMjBpbml0aWFsJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZpbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmJlbnouanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEF0ZXh0JTIwJTNEJTIwJTIyYSUyMHJlZCUyMGNhciUyMGluJTIwdGhlJTIwc3VuJTIyJTBBJTBBcGlwZSUyMCUzRCUyMFZlcnNhdGlsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzaGktbGFicyUyRnZlcnNhdGlsZS1kaWZmdXNpb24lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEF0ZXh0X3RvX2ltYWdlX3N0cmVuZ3RoJTIwJTNEJTIwMC43NSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZS5kdWFsX2d1aWRlZCglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0R0ZXh0JTJDJTIwaW1hZ2UlM0RpbWFnZSUyQyUyMHRleHRfdG9faW1hZ2Vfc3RyZW5ndGglM0R0ZXh0X3RvX2ltYWdlX3N0cmVuZ3RoJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjIuJTJGY2FyX3ZhcmlhdGlvbi5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> VersatileDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an initial image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/images/resolve/main/benz.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;a red car in the sun&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = VersatileDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;shi-labs/versatile-diffusion&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_to_image_strength = <span class="hljs-number">0.75</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe.dual_guided(
<span class="hljs-meta">... </span>    prompt=text, image=image, text_to_image_strength=text_to_image_strength, generator=generator
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;./car_variation.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=w,p=o(),g(i.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=w),p=r(t),h(i.$$.fragment,t)},m(t,m){d(t,n,m),d(t,p,m),_(i,t,m),u=!0},p:_e,i(t){u||(b(i.$$.fragment,t),u=!0)},o(t){y(i.$$.fragment,t),u=!1},d(t){t&&(s(n),s(p)),v(i,t)}}}function Kt(x){let n,w="Examples:",p,i,u;return i=new Ge({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFZlcnNhdGlsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEElMjMlMjBsZXQncyUyMGRvd25sb2FkJTIwYW4lMjBpbml0aWFsJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZpbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmJlbnouanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwVmVyc2F0aWxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnNoaS1sYWJzJTJGdmVyc2F0aWxlLWRpZmZ1c2lvbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZS5pbWFnZV92YXJpYXRpb24oaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMi4lMkZjYXJfdmFyaWF0aW9uLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> VersatileDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an initial image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/images/resolve/main/benz.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = VersatileDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;shi-labs/versatile-diffusion&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe.image_variation(image, generator=generator).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;./car_variation.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=w,p=o(),g(i.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=w),p=r(t),h(i.$$.fragment,t)},m(t,m){d(t,n,m),d(t,p,m),_(i,t,m),u=!0},p:_e,i(t){u||(b(i.$$.fragment,t),u=!0)},o(t){y(i.$$.fragment,t),u=!1},d(t){t&&(s(n),s(p)),v(i,t)}}}function en(x){let n,w="Examples:",p,i,u;return i=new Ge({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFZlcnNhdGlsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwVmVyc2F0aWxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnNoaS1sYWJzJTJGdmVyc2F0aWxlLWRpZmZ1c2lvbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZS50ZXh0X3RvX2ltYWdlKCUyMmFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwb24lMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMi4lMkZhc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> VersatileDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = VersatileDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;shi-labs/versatile-diffusion&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe.text_to_image(<span class="hljs-string">&quot;an astronaut riding on a horse on mars&quot;</span>, generator=generator).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;./astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=w,p=o(),g(i.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=w),p=r(t),h(i.$$.fragment,t)},m(t,m){d(t,n,m),d(t,p,m),_(i,t,m),u=!0},p:_e,i(t){u||(b(i.$$.fragment,t),u=!0)},o(t){y(i.$$.fragment,t),u=!1},d(t){t&&(s(n),s(p)),v(i,t)}}}function tn(x){let n,w="Examples:",p,i,u;return i=new Ge({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFZlcnNhdGlsZURpZmZ1c2lvblRleHRUb0ltYWdlUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBWZXJzYXRpbGVEaWZmdXNpb25UZXh0VG9JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzaGktbGFicyUyRnZlcnNhdGlsZS1kaWZmdXNpb24lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS5yZW1vdmVfdW51c2VkX3dlaWdodHMoKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwb24lMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMi4lMkZhc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> VersatileDiffusionTextToImagePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = VersatileDiffusionTextToImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;shi-labs/versatile-diffusion&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.remove_unused_weights()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(<span class="hljs-string">&quot;an astronaut riding on a horse on mars&quot;</span>, generator=generator).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;./astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=w,p=o(),g(i.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=w),p=r(t),h(i.$$.fragment,t)},m(t,m){d(t,n,m),d(t,p,m),_(i,t,m),u=!0},p:_e,i(t){u||(b(i.$$.fragment,t),u=!0)},o(t){y(i.$$.fragment,t),u=!1},d(t){t&&(s(n),s(p)),v(i,t)}}}function nn(x){let n,w="Examples:",p,i,u;return i=new Ge({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFZlcnNhdGlsZURpZmZ1c2lvbkltYWdlVmFyaWF0aW9uUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQSUyMyUyMGxldCdzJTIwZG93bmxvYWQlMjBhbiUyMGluaXRpYWwlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmRpZmZ1c2VycyUyRmltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVuei5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBWZXJzYXRpbGVEaWZmdXNpb25JbWFnZVZhcmlhdGlvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzaGktbGFicyUyRnZlcnNhdGlsZS1kaWZmdXNpb24lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMi4lMkZjYXJfdmFyaWF0aW9uLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> VersatileDiffusionImageVariationPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an initial image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/images/resolve/main/benz.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = VersatileDiffusionImageVariationPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;shi-labs/versatile-diffusion&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(image, generator=generator).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;./car_variation.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=w,p=o(),g(i.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=w),p=r(t),h(i.$$.fragment,t)},m(t,m){d(t,n,m),d(t,p,m),_(i,t,m),u=!0},p:_e,i(t){u||(b(i.$$.fragment,t),u=!0)},o(t){y(i.$$.fragment,t),u=!1},d(t){t&&(s(n),s(p)),v(i,t)}}}function sn(x){let n,w="Examples:",p,i,u;return i=new Ge({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFZlcnNhdGlsZURpZmZ1c2lvbkR1YWxHdWlkZWRQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBJTIzJTIwbGV0J3MlMjBkb3dubG9hZCUyMGFuJTIwaW5pdGlhbCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGZGlmZnVzZXJzJTJGaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZiZW56LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBdGV4dCUyMCUzRCUyMCUyMmElMjByZWQlMjBjYXIlMjBpbiUyMHRoZSUyMHN1biUyMiUwQSUwQXBpcGUlMjAlM0QlMjBWZXJzYXRpbGVEaWZmdXNpb25EdWFsR3VpZGVkUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnNoaS1sYWJzJTJGdmVyc2F0aWxlLWRpZmZ1c2lvbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnJlbW92ZV91bnVzZWRfd2VpZ2h0cygpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEF0ZXh0X3RvX2ltYWdlX3N0cmVuZ3RoJTIwJTNEJTIwMC43NSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0R0ZXh0JTJDJTIwaW1hZ2UlM0RpbWFnZSUyQyUyMHRleHRfdG9faW1hZ2Vfc3RyZW5ndGglM0R0ZXh0X3RvX2ltYWdlX3N0cmVuZ3RoJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjIuJTJGY2FyX3ZhcmlhdGlvbi5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> VersatileDiffusionDualGuidedPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s download an initial image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/images/resolve/main/benz.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;a red car in the sun&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = VersatileDiffusionDualGuidedPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;shi-labs/versatile-diffusion&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.remove_unused_weights()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_to_image_strength = <span class="hljs-number">0.75</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=text, image=image, text_to_image_strength=text_to_image_strength, generator=generator
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;./car_variation.png&quot;</span>)`,wrap:!1}}),{c(){n=c("p"),n.textContent=w,p=o(),g(i.$$.fragment)},l(t){n=f(t,"P",{"data-svelte-h":!0}),M(n)!=="svelte-kvfsh7"&&(n.textContent=w),p=r(t),h(i.$$.fragment,t)},m(t,m){d(t,n,m),d(t,p,m),_(i,t,m),u=!0},p:_e,i(t){u||(b(i.$$.fragment,t),u=!0)},o(t){y(i.$$.fragment,t),u=!1},d(t){t&&(s(n),s(p)),v(i,t)}}}function an(x){let n,w,p,i,u,t,m,It='Versatile Diffusion was proposed in <a href="https://huggingface.co/papers/2211.08332" rel="nofollow">Versatile Diffusion: Text, Images and Variations All in One Diffusion Model</a> by Xingqian Xu, Zhangyang Wang, Eric Zhang, Kai Wang, Humphrey Shi .',Se,H,Vt="The abstract from the paper is:",Ne,K,jt="<em>The recent advances in diffusion models have set an impressive milestone in many generation tasks. Trending works such as DALL-E2, Imagen, and Stable Diffusion have attracted great interest in academia and industry. Despite the rapid landscape changes, recent new approaches focus on extensions and performance rather than capacity, thus requiring separate models for separate tasks. In this work, we expand the existing single-flow diffusion pipeline into a multi-flow network, dubbed Versatile Diffusion (VD), that handles text-to-image, image-to-text, image-variation, and text-variation in one unified model. Moreover, we generalize VD to a unified multi-flow multimodal diffusion framework with grouped layers, swappable streams, and other propositions that can process modalities beyond images and text. Through our experiments, we demonstrate that VD and its underlying framework have the following merits: a) VD handles all subtasks with competitive quality; b) VD initiates novel extensions and applications such as disentanglement of style and semantic, image-text dual-guided generation, etc.; c) Through these experiments and applications, VD provides more semantic insights of the generated outputs.</em>",Be,ee,Le,te,Pt='You can load the more memory intensive “all-in-one” <a href="/docs/diffusers/main/en/api/pipelines/versatile_diffusion#diffusers.VersatileDiffusionPipeline">VersatileDiffusionPipeline</a> that supports all the tasks or use the individual pipelines which are more memory efficient.',Fe,ne,kt='<thead><tr><th><strong>Pipeline</strong></th> <th><strong>Supported tasks</strong></th></tr></thead> <tbody><tr><td><a href="/docs/diffusers/main/en/api/pipelines/versatile_diffusion#diffusers.VersatileDiffusionPipeline">VersatileDiffusionPipeline</a></td> <td>all of the below</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/versatile_diffusion#diffusers.VersatileDiffusionTextToImagePipeline">VersatileDiffusionTextToImagePipeline</a></td> <td>text-to-image</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/versatile_diffusion#diffusers.VersatileDiffusionImageVariationPipeline">VersatileDiffusionImageVariationPipeline</a></td> <td>image variation</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/versatile_diffusion#diffusers.VersatileDiffusionDualGuidedPipeline">VersatileDiffusionDualGuidedPipeline</a></td> <td>image-text dual guided generation</td></tr></tbody>',Xe,R,Re,se,Ee,T,ie,et,be,Ut="Pipeline for text-to-image generation using Stable Diffusion.",tt,ye,Zt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,nt,$,ae,st,ve,$t="The call function to the pipeline for generation.",it,E,at,J,oe,ot,Me,Jt="The call function to the pipeline for generation.",rt,q,lt,C,re,dt,we,Ct="The call function to the pipeline for generation.",pt,z,qe,le,ze,I,de,ct,Te,Gt="Pipeline for text-to-image generation using Versatile Diffusion.",ft,xe,Wt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ut,G,pe,mt,De,St="The call function to the pipeline for generation.",gt,Q,Qe,ce,Ye,V,fe,ht,Ie,Nt="Pipeline for image variation using Versatile Diffusion.",_t,Ve,Bt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,bt,W,ue,yt,je,Lt="The call function to the pipeline for generation.",vt,Y,Ae,me,Oe,j,ge,Mt,Pe,Ft="Pipeline for image-text dual-guided generation using Versatile Diffusion.",wt,ke,Xt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Tt,S,he,xt,Ue,Rt="The call function to the pipeline for generation.",Dt,A,He,We,Ke;return u=new Ce({props:{title:"Versatile Diffusion",local:"versatile-diffusion",headingTag:"h1"}}),ee=new Ce({props:{title:"Tips",local:"tips",headingTag:"h2"}}),R=new At({props:{$$slots:{default:[Ot]},$$scope:{ctx:x}}}),se=new Ce({props:{title:"VersatileDiffusionPipeline",local:"diffusers.VersatileDiffusionPipeline",headingTag:"h2"}}),ie=new N({props:{name:"class diffusers.VersatileDiffusionPipeline",anchor:"diffusers.VersatileDiffusionPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"image_feature_extractor",val:": CLIPImageProcessor"},{name:"text_encoder",val:": CLIPTextModel"},{name:"image_encoder",val:": CLIPVisionModel"},{name:"image_unet",val:": UNet2DConditionModel"},{name:"text_unet",val:": UNet2DConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.VersatileDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.VersatileDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VersatileDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.VersatileDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.VersatileDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.VersatileDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion.py#L20"}}),ae=new N({props:{name:"dual_guided",anchor:"diffusers.VersatileDiffusionPipeline.dual_guided",parameters:[{name:"prompt",val:": typing.Union[PIL.Image.Image, typing.List[PIL.Image.Image]]"},{name:"image",val:": typing.Union[str, typing.List[str]]"},{name:"text_to_image_strength",val:": float = 0.5"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion.py#L301",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),E=new Je({props:{anchor:"diffusers.VersatileDiffusionPipeline.dual_guided.example",$$slots:{default:[Ht]},$$scope:{ctx:x}}}),oe=new N({props:{name:"image_variation",anchor:"diffusers.VersatileDiffusionPipeline.image_variation",parameters:[{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>List[PIL.Image.Image]</code> or <code>torch.Tensor</code>) &#x2014;
The image prompt or prompts to guide the image generation.`,name:"image"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion.py#L81",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),q=new Je({props:{anchor:"diffusers.VersatileDiffusionPipeline.image_variation.example",$$slots:{default:[Kt]},$$scope:{ctx:x}}}),re=new N({props:{name:"text_to_image",anchor:"diffusers.VersatileDiffusionPipeline.text_to_image",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),z=new Je({props:{anchor:"diffusers.VersatileDiffusionPipeline.text_to_image.example",$$slots:{default:[en]},$$scope:{ctx:x}}}),le=new Ce({props:{title:"VersatileDiffusionTextToImagePipeline",local:"diffusers.VersatileDiffusionTextToImagePipeline",headingTag:"h2"}}),de=new N({props:{name:"class diffusers.VersatileDiffusionTextToImagePipeline",anchor:"diffusers.VersatileDiffusionTextToImagePipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"image_unet",val:": UNet2DConditionModel"},{name:"text_unet",val:": UNetFlatConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.vqvae",description:`<strong>vqvae</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
Vector-quantized (VQ) model to encode and decode images to and from latent representations.`,name:"vqvae"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.bert",description:`<strong>bert</strong> (<code>LDMBertModel</code>) &#x2014;
Text-encoder model based on <code>BERT</code>.`,name:"bert"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer" rel="nofollow">BertTokenizer</a>) &#x2014;
A <code>BertTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion_text_to_image.py#L34"}}),pe=new N({props:{name:"__call__",anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion_text_to_image.py#L314",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Q=new Je({props:{anchor:"diffusers.VersatileDiffusionTextToImagePipeline.__call__.example",$$slots:{default:[tn]},$$scope:{ctx:x}}}),ce=new Ce({props:{title:"VersatileDiffusionImageVariationPipeline",local:"diffusers.VersatileDiffusionImageVariationPipeline",headingTag:"h2"}}),fe=new N({props:{name:"class diffusers.VersatileDiffusionImageVariationPipeline",anchor:"diffusers.VersatileDiffusionImageVariationPipeline",parameters:[{name:"image_feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_unet",val:": UNet2DConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.vqvae",description:`<strong>vqvae</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
Vector-quantized (VQ) model to encode and decode images to and from latent representations.`,name:"vqvae"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.bert",description:`<strong>bert</strong> (<code>LDMBertModel</code>) &#x2014;
Text-encoder model based on <code>BERT</code>.`,name:"bert"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer" rel="nofollow">BertTokenizer</a>) &#x2014;
A <code>BertTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion_image_variation.py#L35"}}),ue=new N({props:{name:"__call__",anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, typing.List[PIL.Image.Image], torch.Tensor]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>List[PIL.Image.Image]</code> or <code>torch.Tensor</code>) &#x2014;
The image prompt or prompts to guide the image generation.`,name:"image"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion_image_variation.py#L232",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),Y=new Je({props:{anchor:"diffusers.VersatileDiffusionImageVariationPipeline.__call__.example",$$slots:{default:[nn]},$$scope:{ctx:x}}}),me=new Ce({props:{title:"VersatileDiffusionDualGuidedPipeline",local:"diffusers.VersatileDiffusionDualGuidedPipeline",headingTag:"h2"}}),ge=new N({props:{name:"class diffusers.VersatileDiffusionDualGuidedPipeline",anchor:"diffusers.VersatileDiffusionDualGuidedPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"image_feature_extractor",val:": CLIPImageProcessor"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_unet",val:": UNet2DConditionModel"},{name:"text_unet",val:": UNetFlatConditionModel"},{name:"vae",val:": AutoencoderKL"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.vqvae",description:`<strong>vqvae</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
Vector-quantized (VQ) model to encode and decode images to and from latent representations.`,name:"vqvae"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.bert",description:`<strong>bert</strong> (<code>LDMBertModel</code>) &#x2014;
Text-encoder model based on <code>BERT</code>.`,name:"bert"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer" rel="nofollow">BertTokenizer</a>) &#x2014;
A <code>BertTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion_dual_guided.py#L41"}}),he=new N({props:{name:"__call__",anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[PIL.Image.Image, typing.List[PIL.Image.Image]]"},{name:"image",val:": typing.Union[str, typing.List[str]]"},{name:"text_to_image_strength",val:": float = 0.5"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/versatile_diffusion/pipeline_versatile_diffusion_dual_guided.py#L379",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),A=new Je({props:{anchor:"diffusers.VersatileDiffusionDualGuidedPipeline.__call__.example",$$slots:{default:[sn]},$$scope:{ctx:x}}}),{c(){n=c("meta"),w=o(),p=c("p"),i=o(),g(u.$$.fragment),t=o(),m=c("p"),m.innerHTML=It,Se=o(),H=c("p"),H.textContent=Vt,Ne=o(),K=c("p"),K.innerHTML=jt,Be=o(),g(ee.$$.fragment),Le=o(),te=c("p"),te.innerHTML=Pt,Fe=o(),ne=c("table"),ne.innerHTML=kt,Xe=o(),g(R.$$.fragment),Re=o(),g(se.$$.fragment),Ee=o(),T=c("div"),g(ie.$$.fragment),et=o(),be=c("p"),be.textContent=Ut,tt=o(),ye=c("p"),ye.innerHTML=Zt,nt=o(),$=c("div"),g(ae.$$.fragment),st=o(),ve=c("p"),ve.textContent=$t,it=o(),g(E.$$.fragment),at=o(),J=c("div"),g(oe.$$.fragment),ot=o(),Me=c("p"),Me.textContent=Jt,rt=o(),g(q.$$.fragment),lt=o(),C=c("div"),g(re.$$.fragment),dt=o(),we=c("p"),we.textContent=Ct,pt=o(),g(z.$$.fragment),qe=o(),g(le.$$.fragment),ze=o(),I=c("div"),g(de.$$.fragment),ct=o(),Te=c("p"),Te.textContent=Gt,ft=o(),xe=c("p"),xe.innerHTML=Wt,ut=o(),G=c("div"),g(pe.$$.fragment),mt=o(),De=c("p"),De.textContent=St,gt=o(),g(Q.$$.fragment),Qe=o(),g(ce.$$.fragment),Ye=o(),V=c("div"),g(fe.$$.fragment),ht=o(),Ie=c("p"),Ie.textContent=Nt,_t=o(),Ve=c("p"),Ve.innerHTML=Bt,bt=o(),W=c("div"),g(ue.$$.fragment),yt=o(),je=c("p"),je.textContent=Lt,vt=o(),g(Y.$$.fragment),Ae=o(),g(me.$$.fragment),Oe=o(),j=c("div"),g(ge.$$.fragment),Mt=o(),Pe=c("p"),Pe.textContent=Ft,wt=o(),ke=c("p"),ke.innerHTML=Xt,Tt=o(),S=c("div"),g(he.$$.fragment),xt=o(),Ue=c("p"),Ue.textContent=Rt,Dt=o(),g(A.$$.fragment),He=o(),We=c("p"),this.h()},l(e){const a=Yt("svelte-u9bgzb",document.head);n=f(a,"META",{name:!0,content:!0}),a.forEach(s),w=r(e),p=f(e,"P",{}),P(p).forEach(s),i=r(e),h(u.$$.fragment,e),t=r(e),m=f(e,"P",{"data-svelte-h":!0}),M(m)!=="svelte-sck21n"&&(m.innerHTML=It),Se=r(e),H=f(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1cwsb16"&&(H.textContent=Vt),Ne=r(e),K=f(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-lahewi"&&(K.innerHTML=jt),Be=r(e),h(ee.$$.fragment,e),Le=r(e),te=f(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-a0e7s2"&&(te.innerHTML=Pt),Fe=r(e),ne=f(e,"TABLE",{"data-svelte-h":!0}),M(ne)!=="svelte-1pknwyx"&&(ne.innerHTML=kt),Xe=r(e),h(R.$$.fragment,e),Re=r(e),h(se.$$.fragment,e),Ee=r(e),T=f(e,"DIV",{class:!0});var D=P(T);h(ie.$$.fragment,D),et=r(D),be=f(D,"P",{"data-svelte-h":!0}),M(be)!=="svelte-35p306"&&(be.textContent=Ut),tt=r(D),ye=f(D,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-496sm0"&&(ye.innerHTML=Zt),nt=r(D),$=f(D,"DIV",{class:!0});var B=P($);h(ae.$$.fragment,B),st=r(B),ve=f(B,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-50j04k"&&(ve.textContent=$t),it=r(B),h(E.$$.fragment,B),B.forEach(s),at=r(D),J=f(D,"DIV",{class:!0});var L=P(J);h(oe.$$.fragment,L),ot=r(L),Me=f(L,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-50j04k"&&(Me.textContent=Jt),rt=r(L),h(q.$$.fragment,L),L.forEach(s),lt=r(D),C=f(D,"DIV",{class:!0});var F=P(C);h(re.$$.fragment,F),dt=r(F),we=f(F,"P",{"data-svelte-h":!0}),M(we)!=="svelte-50j04k"&&(we.textContent=Ct),pt=r(F),h(z.$$.fragment,F),F.forEach(s),D.forEach(s),qe=r(e),h(le.$$.fragment,e),ze=r(e),I=f(e,"DIV",{class:!0});var U=P(I);h(de.$$.fragment,U),ct=r(U),Te=f(U,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1uoqzws"&&(Te.textContent=Gt),ft=r(U),xe=f(U,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-496sm0"&&(xe.innerHTML=Wt),ut=r(U),G=f(U,"DIV",{class:!0});var X=P(G);h(pe.$$.fragment,X),mt=r(X),De=f(X,"P",{"data-svelte-h":!0}),M(De)!=="svelte-50j04k"&&(De.textContent=St),gt=r(X),h(Q.$$.fragment,X),X.forEach(s),U.forEach(s),Qe=r(e),h(ce.$$.fragment,e),Ye=r(e),V=f(e,"DIV",{class:!0});var Z=P(V);h(fe.$$.fragment,Z),ht=r(Z),Ie=f(Z,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-1t57s4z"&&(Ie.textContent=Nt),_t=r(Z),Ve=f(Z,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-496sm0"&&(Ve.innerHTML=Bt),bt=r(Z),W=f(Z,"DIV",{class:!0});var Ze=P(W);h(ue.$$.fragment,Ze),yt=r(Ze),je=f(Ze,"P",{"data-svelte-h":!0}),M(je)!=="svelte-50j04k"&&(je.textContent=Lt),vt=r(Ze),h(Y.$$.fragment,Ze),Ze.forEach(s),Z.forEach(s),Ae=r(e),h(me.$$.fragment,e),Oe=r(e),j=f(e,"DIV",{class:!0});var O=P(j);h(ge.$$.fragment,O),Mt=r(O),Pe=f(O,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-vvoygj"&&(Pe.textContent=Ft),wt=r(O),ke=f(O,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-496sm0"&&(ke.innerHTML=Xt),Tt=r(O),S=f(O,"DIV",{class:!0});var $e=P(S);h(he.$$.fragment,$e),xt=r($e),Ue=f($e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-50j04k"&&(Ue.textContent=Rt),Dt=r($e),h(A.$$.fragment,$e),$e.forEach(s),O.forEach(s),He=r(e),We=f(e,"P",{}),P(We).forEach(s),this.h()},h(){k(n,"name","hf:doc:metadata"),k(n,"content",on),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){l(document.head,n),d(e,w,a),d(e,p,a),d(e,i,a),_(u,e,a),d(e,t,a),d(e,m,a),d(e,Se,a),d(e,H,a),d(e,Ne,a),d(e,K,a),d(e,Be,a),_(ee,e,a),d(e,Le,a),d(e,te,a),d(e,Fe,a),d(e,ne,a),d(e,Xe,a),_(R,e,a),d(e,Re,a),_(se,e,a),d(e,Ee,a),d(e,T,a),_(ie,T,null),l(T,et),l(T,be),l(T,tt),l(T,ye),l(T,nt),l(T,$),_(ae,$,null),l($,st),l($,ve),l($,it),_(E,$,null),l(T,at),l(T,J),_(oe,J,null),l(J,ot),l(J,Me),l(J,rt),_(q,J,null),l(T,lt),l(T,C),_(re,C,null),l(C,dt),l(C,we),l(C,pt),_(z,C,null),d(e,qe,a),_(le,e,a),d(e,ze,a),d(e,I,a),_(de,I,null),l(I,ct),l(I,Te),l(I,ft),l(I,xe),l(I,ut),l(I,G),_(pe,G,null),l(G,mt),l(G,De),l(G,gt),_(Q,G,null),d(e,Qe,a),_(ce,e,a),d(e,Ye,a),d(e,V,a),_(fe,V,null),l(V,ht),l(V,Ie),l(V,_t),l(V,Ve),l(V,bt),l(V,W),_(ue,W,null),l(W,yt),l(W,je),l(W,vt),_(Y,W,null),d(e,Ae,a),_(me,e,a),d(e,Oe,a),d(e,j,a),_(ge,j,null),l(j,Mt),l(j,Pe),l(j,wt),l(j,ke),l(j,Tt),l(j,S),_(he,S,null),l(S,xt),l(S,Ue),l(S,Dt),_(A,S,null),d(e,He,a),d(e,We,a),Ke=!0},p(e,[a]){const D={};a&2&&(D.$$scope={dirty:a,ctx:e}),R.$set(D);const B={};a&2&&(B.$$scope={dirty:a,ctx:e}),E.$set(B);const L={};a&2&&(L.$$scope={dirty:a,ctx:e}),q.$set(L);const F={};a&2&&(F.$$scope={dirty:a,ctx:e}),z.$set(F);const U={};a&2&&(U.$$scope={dirty:a,ctx:e}),Q.$set(U);const X={};a&2&&(X.$$scope={dirty:a,ctx:e}),Y.$set(X);const Z={};a&2&&(Z.$$scope={dirty:a,ctx:e}),A.$set(Z)},i(e){Ke||(b(u.$$.fragment,e),b(ee.$$.fragment,e),b(R.$$.fragment,e),b(se.$$.fragment,e),b(ie.$$.fragment,e),b(ae.$$.fragment,e),b(E.$$.fragment,e),b(oe.$$.fragment,e),b(q.$$.fragment,e),b(re.$$.fragment,e),b(z.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(pe.$$.fragment,e),b(Q.$$.fragment,e),b(ce.$$.fragment,e),b(fe.$$.fragment,e),b(ue.$$.fragment,e),b(Y.$$.fragment,e),b(me.$$.fragment,e),b(ge.$$.fragment,e),b(he.$$.fragment,e),b(A.$$.fragment,e),Ke=!0)},o(e){y(u.$$.fragment,e),y(ee.$$.fragment,e),y(R.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(ae.$$.fragment,e),y(E.$$.fragment,e),y(oe.$$.fragment,e),y(q.$$.fragment,e),y(re.$$.fragment,e),y(z.$$.fragment,e),y(le.$$.fragment,e),y(de.$$.fragment,e),y(pe.$$.fragment,e),y(Q.$$.fragment,e),y(ce.$$.fragment,e),y(fe.$$.fragment,e),y(ue.$$.fragment,e),y(Y.$$.fragment,e),y(me.$$.fragment,e),y(ge.$$.fragment,e),y(he.$$.fragment,e),y(A.$$.fragment,e),Ke=!1},d(e){e&&(s(w),s(p),s(i),s(t),s(m),s(Se),s(H),s(Ne),s(K),s(Be),s(Le),s(te),s(Fe),s(ne),s(Xe),s(Re),s(Ee),s(T),s(qe),s(ze),s(I),s(Qe),s(Ye),s(V),s(Ae),s(Oe),s(j),s(He),s(We)),s(n),v(u,e),v(ee,e),v(R,e),v(se,e),v(ie),v(ae),v(E),v(oe),v(q),v(re),v(z),v(le,e),v(de),v(pe),v(Q),v(ce,e),v(fe),v(ue),v(Y),v(me,e),v(ge),v(he),v(A)}}}const on='{"title":"Versatile Diffusion","local":"versatile-diffusion","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"VersatileDiffusionPipeline","local":"diffusers.VersatileDiffusionPipeline","sections":[],"depth":2},{"title":"VersatileDiffusionTextToImagePipeline","local":"diffusers.VersatileDiffusionTextToImagePipeline","sections":[],"depth":2},{"title":"VersatileDiffusionImageVariationPipeline","local":"diffusers.VersatileDiffusionImageVariationPipeline","sections":[],"depth":2},{"title":"VersatileDiffusionDualGuidedPipeline","local":"diffusers.VersatileDiffusionDualGuidedPipeline","sections":[],"depth":2}],"depth":1}';function rn(x){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends zt{constructor(n){super(),Qt(this,n,rn,an,Et,{})}}export{gn as component};
