import{s as ut,o as dt,n as ft}from"../chunks/scheduler.182ea377.js";import{S as Mt,i as mt,g as i,s as n,r,A as yt,h as o,f as l,c as a,j as pt,u as c,x as p,k as rt,y as ht,a as t,v as f,d as u,t as d,w as M}from"../chunks/index.abf12888.js";import{T as ct}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{D as Jt}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as T}from"../chunks/Heading.16916d63.js";function Tt(He){let m,J='💡 Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you interested in learning in more detail about how the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){m=i("p"),m.innerHTML=J},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1ayrfcq"&&(m.innerHTML=J)},m(h,U){t(h,m,U)},p:ft,d(h){h&&l(m)}}}function Ut(He){let m,J="💡 When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories instead of variations (for example, <code>stable-diffusion-v1-4</code> and <code>stable-diffusion-v1-5</code>).";return{c(){m=i("p"),m.innerHTML=J},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1bx6mv6"&&(m.innerHTML=J)},m(h,U){t(h,m,U)},p:ft,d(h){h&&l(m)}}}function wt(He){let m,J,h,U,j,Ae,Z,Ye,g,Jl='Having an easy way to use a diffusion system for inference is essential to 🧨 Diffusers. Diffusion systems often consist of multiple components like parameterized models, tokenizers, and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API, while remaining flexible enough to be adapted for other use cases, such as loading each component individually as building blocks to assemble your own diffusion system.',Le,v,Tl="Everything you need for inference or training is accessible with the <code>from_pretrained()</code> method.",Fe,I,Ul="This guide will show you how to load:",Pe,C,wl="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li> <li>models and schedulers</li>",Oe,k,Ke,w,es,V,bl='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is the simplest and most generic way to load any diffusion model from the <a href="https://huggingface.co/models?library=diffusers" rel="nofollow">Hub</a>. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> method automatically detects the correct pipeline class from the checkpoint, downloads and caches all the required configuration and weight files, and returns a pipeline instance ready for inference.',ss,W,ls,R,jl='You can also load a checkpoint with it’s specific pipeline class. The example above loaded a Stable Diffusion model; to get the same result, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class:',ts,B,ns,_,Zl='A checkpoint (such as <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow"><code>CompVis/stable-diffusion-v1-4</code></a> or <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) may also be used for more than one task, like text-to-image or image-to-image. To differentiate what task you want to use the checkpoint for, you have to load it directly with it’s corresponding task-specific pipeline class:',as,$,is,N,os,G,gl='To load a diffusion pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow"><code>git-lfs</code></a> to manually download the checkpoint (in this case, <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) to your local disk. This creates a local folder, <code>./stable-diffusion-v1-5</code>, on your disk:',ps,Q,rs,E,vl='Then pass the local path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>:',cs,q,fs,x,Il='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download any files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',us,X,ds,S,Cl="You can customize the default components of any pipeline with another compatible component. Customization is important because:",Ms,D,kl="<li>Changing the scheduler is important for exploring the trade-off between generation speed and quality.</li> <li>Different components of a model are typically trained independently and you can swap out a component with a better-performing one.</li> <li>During finetuning, usually only some components - like the UNet or text encoder - are trained.</li>",ms,H,Vl="To find out which schedulers are compatible for customization, you can use the <code>compatibles</code> method:",ys,z,hs,A,Wl='Let’s use the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method to replace the default <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> with a more performant scheduler, <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>. The <code>subfolder=&quot;scheduler&quot;</code> argument is required to load the scheduler configuration from the correct <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.',Js,Y,Rl='Then you can pass the new <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> instance to the <code>scheduler</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Ts,L,Us,F,ws,P,Bl='Diffusion models like Stable Diffusion can generate harmful content, which is why 🧨 Diffusers has a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> to check generated outputs against known hardcoded NSFW content. If you’d like to disable the safety checker for whatever reason, pass <code>None</code> to the <code>safety_checker</code> argument:',bs,O,js,K,Zs,ee,_l='You can also reuse the same components in multiple pipelines to avoid loading the weights into RAM twice. Use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.components">components</a> method to save the components:',gs,se,vs,le,$l="Then you can pass the <code>components</code> to another pipeline without reloading the weights into RAM:",Is,te,Cs,ne,Nl="You can also pass the components individually to the pipeline if you want more flexibility over which components to reuse or disable. For example, to reuse the same components in the text-to-image pipeline, except for the safety checker and feature extractor, in the image-to-image pipeline:",ks,ae,Vs,ie,Ws,oe,Gl="A checkpoint variant is usually a checkpoint where it’s weights are:",Rs,pe,Ql='<li>Stored in a different floating point type for lower precision and lower storage, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow"><code>torch.float16</code></a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights which shouldn’t be used for inference. You should use these to continue finetuning a model.</li>',Bs,b,_s,re,El='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">Safetensors</a>), model structure, and weights have identical tensor shapes.',$s,ce,ql="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.bin</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.bin</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.bin</td> <td><code>variant</code></td></tr></tbody>",Ns,fe,xl="There are two important arguments to know for loading variants:",Gs,ue,Xl='<li><p><code>torch_dtype</code> defines the floating point precision of the loaded checkpoints. For example, if you want to save bandwidth by loading a <code>fp16</code> variant, you should specify <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to <code>fp16</code>. Otherwise, the <code>fp16</code> weights are converted to the default <code>fp32</code> precision. You can also load the original checkpoint without defining the <code>variant</code> argument, and convert it to <code>fp16</code> with <code>torch_dtype=torch.float16</code>. In this case, the default <code>fp32</code> weights are downloaded first, and then they’re converted to <code>fp16</code> after loading.</p></li> <li><p><code>variant</code> defines which files should be loaded from the repository. For example, if you want to load a <code>non_ema</code> variant from the <a href="https://huggingface.co/diffusers/stable-diffusion-variants/tree/main/unet" rel="nofollow"><code>diffusers/stable-diffusion-variants</code></a> repository, you should specify <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> files.</p></li>',Qs,de,Es,Me,Sl='To save a checkpoint stored in a different floating point type or as a non-EMA variant, use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method and specify the <code>variant</code> argument. You should try and save a variant to the same folder as the original checkpoint, so you can load both from the same folder:',qs,me,xs,ye,Dl="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint:",Xs,he,Ss,Je,Ds,Te,Hl='Models are loaded from the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> method, which downloads and caches the latest version of the model weights and configurations. If the latest files are available in the local cache, <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> reuses files in the cache instead of redownloading them.',Hs,Ue,zl='Models can be loaded from a subfolder with the <code>subfolder</code> argument. For example, the model weights for <code>runwayml/stable-diffusion-v1-5</code> are stored in the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/unet" rel="nofollow"><code>unet</code></a> subfolder:',zs,we,As,be,Al='Or directly from a repository’s <a href="https://huggingface.co/google/ddpm-cifar10-32/tree/main" rel="nofollow">directory</a>:',Ys,je,Ls,Ze,Yl='You can also load and save model variants by specifying the <code>variant</code> argument in <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> and <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>:',Fs,ge,Ps,ve,Os,Ie,Ll='Schedulers are loaded from the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method, and unlike models, schedulers are <strong>not parameterized</strong> or <strong>trained</strong>; they are defined by a configuration file.',Ks,Ce,Fl=`Loading schedulers does not consume any significant amount of memory and the same configuration file can be used for a variety of different schedulers.
For example, the following schedulers are compatible with <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> which means you can load the same scheduler configuration file in any of these classes:`,el,ke,sl,Ve,ll,We,Pl='As a class method, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',tl,Re,Ol='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="./api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',nl,Be,Kl='The pipelines underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>.',al,_e,il,$e,et='You’ll see pipeline is an instance of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',ol,Ne,st='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPFeatureExtractor" rel="nofollow">CLIPFeatureExtractor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code> an instance of <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',pl,Ge,rl,Qe,lt='Compare the components of the pipeline instance to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',cl,Ee,fl,qe,tt="You can access each of the components of the pipeline as an attribute to view its configuration:",ul,xe,dl,Xe,nt='Every pipeline expects a <code>model_index.json</code> file that tells the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Ml,Se,at="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",ml,De,yl,ze,hl;return j=new T({props:{title:"Load pipelines, models, and schedulers",local:"load-pipelines-models-and-schedulers",headingTag:"h1"}}),Z=new Jt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),k=new T({props:{title:"Diffusion Pipeline",local:"diffusion-pipeline",headingTag:"h2"}}),w=new ct({props:{$$slots:{default:[Tt]},$$scope:{ctx:He}}}),W=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),B=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),$=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionImg2ImgPipeline.from_pretrained(repo_id)`,wrap:!1}}),N=new T({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),Q=new y({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`,wrap:!1}}),q=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new T({props:{title:"Swap components in a pipeline",local:"swap-components-in-a-pipeline",headingTag:"h3"}}),z=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFzdGFibGVfZGlmZnVzaW9uLnNjaGVkdWxlci5jb21wYXRpYmxlcw==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion.scheduler.compatibles`,wrap:!1}}),L=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUyQyUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, EulerDiscreteScheduler, DPMSolverMultistepScheduler

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

scheduler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, scheduler=scheduler, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),F=new T({props:{title:"Safety checker",local:"safety-checker",headingTag:"h3"}}),O=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),K=new T({props:{title:"Reuse components across pipelines",local:"reuse-components-across-pipelines",headingTag:"h3"}}),se=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5jb21wb25lbnRz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

components = stable_diffusion_txt2img.components`,wrap:!1}}),te=new y({props:{code:"c3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqY29tcG9uZW50cyk=",highlighted:"stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(**components)",wrap:!1}}),ae=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBc3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHZhZSUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy52YWUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHVuZXQlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudW5ldCUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5zY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(
    vae=stable_diffusion_txt2img.vae,
    text_encoder=stable_diffusion_txt2img.text_encoder,
    tokenizer=stable_diffusion_txt2img.tokenizer,
    unet=stable_diffusion_txt2img.unet,
    scheduler=stable_diffusion_txt2img.scheduler,
    safety_checker=<span class="hljs-literal">None</span>,
    feature_extractor=<span class="hljs-literal">None</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),ie=new T({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),b=new ct({props:{$$slots:{default:[Ut]},$$scope:{ctx:He}}}),de=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBsb2FkJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMGxvYWQlMjBub25fZW1hJTIwdmFyaWFudCUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load fp16 variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># load non_ema variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),me=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwc2F2ZSUyMGFzJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUyMyUyMHNhdmUlMjBhcyUyMG5vbi1lbWElMjB2YXJpYW50JTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># save as fp16 variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-comment"># save as non-ema variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),he=new y({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIzJTIwJUYwJTlGJTkxJThEJTIwdGhpcyUyMHdvcmtzJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Je=new T({props:{title:"Models",local:"models",headingTag:"h2"}}),we=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
model = UNet2DConditionModel.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),je=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

repo_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>
model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ge=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbi1lbWElMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGbG9jYWwtdW5ldCUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub24tZW1hJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;non-ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
model.save_pretrained(<span class="hljs-string">&quot;./local-unet&quot;</span>, variant=<span class="hljs-string">&quot;non-ema&quot;</span>)`,wrap:!1}}),ve=new T({props:{title:"Schedulers",local:"schedulers",headingTag:"h2"}}),ke=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRERJTVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMFBORE1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBKSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQWRkcG0lMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRkaW0lMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXBuZG0lMjAlM0QlMjBQTkRNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWxtcyUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWV1bGVyX2FuYyUyMCUzRCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBZXVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRwbSUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEElMjMlMjByZXBsYWNlJTIwJTYwZHBtJTYwJTIwd2l0aCUyMGFueSUyMG9mJTIwJTYwZGRwbSU2MCUyQyUyMCU2MGRkaW0lNjAlMkMlMjAlNjBwbmRtJTYwJTJDJTIwJTYwbG1zJTYwJTJDJTIwJTYwZXVsZXJfYW5jJTYwJTJDJTIwJTYwZXVsZXIlNjAlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEZHBtJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDPMScheduler,
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    EulerDiscreteScheduler,
    EulerAncestralDiscreteScheduler,
    DPMSolverMultistepScheduler,
)

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

ddpm = DDPMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
ddim = DDIMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
pndm = PNDMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
lms = LMSDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler_anc = EulerAncestralDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
dpm = DPMSolverMultistepScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

<span class="hljs-comment"># replace \`dpm\` with any of \`ddpm\`, \`ddim\`, \`pndm\`, \`lms\`, \`euler_anc\`, \`euler\`</span>
pipeline = StableDiffusionPipeline.from_pretrained(repo_id, scheduler=dpm, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ve=new T({props:{title:"DiffusionPipeline explained",local:"diffusionpipeline-explained",headingTag:"h2"}}),_e=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcHJpbnQocGlwZWxpbmUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),Ge=new y({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ee=new y({props:{code:"LiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGZlYXR1cmVfZXh0cmFjdG9yJTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHJlcHJvY2Vzc29yX2NvbmZpZy5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwbW9kZWxfaW5kZXguanNvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNhZmV0eV9jaGVja2VyJTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBweXRvcmNoX21vZGVsLmJpbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNjaGVkdWxlciUwQSVFMiU5NCU4MiVDMiVBMCVDMiVBMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHNjaGVkdWxlcl9jb25maWcuanNvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHRleHRfZW5jb2RlciUwQSVFMiU5NCU4MiVDMiVBMCVDMiVBMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbmZpZy5qc29uJTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0b2tlbml6ZXIlMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBtZXJnZXMudHh0JTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwc3BlY2lhbF90b2tlbnNfbWFwLmpzb24lMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjB2b2NhYi5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwdW5ldCUwQSVFMiU5NCU4MiVDMiVBMCVDMiVBMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbmZpZy5qc29uJTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGlmZnVzaW9uX3B5dG9yY2hfbW9kZWwuYmluJTBBJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwdmFlJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMEElMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5iaW4=",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.<span class="hljs-keyword">json
</span>├── model_index.<span class="hljs-keyword">json
</span>├── safety_checker
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   └── pytorch_model.<span class="hljs-keyword">bin
</span>├── <span class="hljs-keyword">scheduler
</span>│   └── <span class="hljs-keyword">scheduler_config.json
</span>├── text_encoder
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   └── pytorch_model.<span class="hljs-keyword">bin
</span>├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.<span class="hljs-keyword">json
</span>│   ├── tokenizer_config.<span class="hljs-keyword">json
</span>│   └── vocab.<span class="hljs-keyword">json
</span>├── unet
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   ├── <span class="hljs-keyword">diffusion_pytorch_model.bin
</span>└── vae
    ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>    ├── <span class="hljs-keyword">diffusion_pytorch_model.bin</span>`,wrap:!1}}),xe=new y({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
)`,wrap:!1}}),De=new y({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),{c(){m=i("meta"),J=n(),h=i("p"),U=n(),r(j.$$.fragment),Ae=n(),r(Z.$$.fragment),Ye=n(),g=i("p"),g.innerHTML=Jl,Le=n(),v=i("p"),v.innerHTML=Tl,Fe=n(),I=i("p"),I.textContent=Ul,Pe=n(),C=i("ul"),C.innerHTML=wl,Oe=n(),r(k.$$.fragment),Ke=n(),r(w.$$.fragment),es=n(),V=i("p"),V.innerHTML=bl,ss=n(),r(W.$$.fragment),ls=n(),R=i("p"),R.innerHTML=jl,ts=n(),r(B.$$.fragment),ns=n(),_=i("p"),_.innerHTML=Zl,as=n(),r($.$$.fragment),is=n(),r(N.$$.fragment),os=n(),G=i("p"),G.innerHTML=gl,ps=n(),r(Q.$$.fragment),rs=n(),E=i("p"),E.innerHTML=vl,cs=n(),r(q.$$.fragment),fs=n(),x=i("p"),x.innerHTML=Il,us=n(),r(X.$$.fragment),ds=n(),S=i("p"),S.textContent=Cl,Ms=n(),D=i("ul"),D.innerHTML=kl,ms=n(),H=i("p"),H.innerHTML=Vl,ys=n(),r(z.$$.fragment),hs=n(),A=i("p"),A.innerHTML=Wl,Js=n(),Y=i("p"),Y.innerHTML=Rl,Ts=n(),r(L.$$.fragment),Us=n(),r(F.$$.fragment),ws=n(),P=i("p"),P.innerHTML=Bl,bs=n(),r(O.$$.fragment),js=n(),r(K.$$.fragment),Zs=n(),ee=i("p"),ee.innerHTML=_l,gs=n(),r(se.$$.fragment),vs=n(),le=i("p"),le.innerHTML=$l,Is=n(),r(te.$$.fragment),Cs=n(),ne=i("p"),ne.textContent=Nl,ks=n(),r(ae.$$.fragment),Vs=n(),r(ie.$$.fragment),Ws=n(),oe=i("p"),oe.textContent=Gl,Rs=n(),pe=i("ul"),pe.innerHTML=Ql,Bs=n(),r(b.$$.fragment),_s=n(),re=i("p"),re.innerHTML=El,$s=n(),ce=i("table"),ce.innerHTML=ql,Ns=n(),fe=i("p"),fe.textContent=xl,Gs=n(),ue=i("ul"),ue.innerHTML=Xl,Qs=n(),r(de.$$.fragment),Es=n(),Me=i("p"),Me.innerHTML=Sl,qs=n(),r(me.$$.fragment),xs=n(),ye=i("p"),ye.innerHTML=Dl,Xs=n(),r(he.$$.fragment),Ss=n(),r(Je.$$.fragment),Ds=n(),Te=i("p"),Te.innerHTML=Hl,Hs=n(),Ue=i("p"),Ue.innerHTML=zl,zs=n(),r(we.$$.fragment),As=n(),be=i("p"),be.innerHTML=Al,Ys=n(),r(je.$$.fragment),Ls=n(),Ze=i("p"),Ze.innerHTML=Yl,Fs=n(),r(ge.$$.fragment),Ps=n(),r(ve.$$.fragment),Os=n(),Ie=i("p"),Ie.innerHTML=Ll,Ks=n(),Ce=i("p"),Ce.innerHTML=Fl,el=n(),r(ke.$$.fragment),sl=n(),r(Ve.$$.fragment),ll=n(),We=i("p"),We.innerHTML=Pl,tl=n(),Re=i("ul"),Re.innerHTML=Ol,nl=n(),Be=i("p"),Be.innerHTML=Kl,al=n(),r(_e.$$.fragment),il=n(),$e=i("p"),$e.innerHTML=et,ol=n(),Ne=i("ul"),Ne.innerHTML=st,pl=n(),r(Ge.$$.fragment),rl=n(),Qe=i("p"),Qe.innerHTML=lt,cl=n(),r(Ee.$$.fragment),fl=n(),qe=i("p"),qe.textContent=tt,ul=n(),r(xe.$$.fragment),dl=n(),Xe=i("p"),Xe.innerHTML=nt,Ml=n(),Se=i("ul"),Se.innerHTML=at,ml=n(),r(De.$$.fragment),yl=n(),ze=i("p"),this.h()},l(e){const s=yt("svelte-u9bgzb",document.head);m=o(s,"META",{name:!0,content:!0}),s.forEach(l),J=a(e),h=o(e,"P",{}),pt(h).forEach(l),U=a(e),c(j.$$.fragment,e),Ae=a(e),c(Z.$$.fragment,e),Ye=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-b825yc"&&(g.innerHTML=Jl),Le=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1let6ok"&&(v.innerHTML=Tl),Fe=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-b6mpdv"&&(I.textContent=Ul),Pe=a(e),C=o(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-19eqgr5"&&(C.innerHTML=wl),Oe=a(e),c(k.$$.fragment,e),Ke=a(e),c(w.$$.fragment,e),es=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-tsk74g"&&(V.innerHTML=bl),ss=a(e),c(W.$$.fragment,e),ls=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1o3ai6q"&&(R.innerHTML=jl),ts=a(e),c(B.$$.fragment,e),ns=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-qyjup4"&&(_.innerHTML=Zl),as=a(e),c($.$$.fragment,e),is=a(e),c(N.$$.fragment,e),os=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-zzamd0"&&(G.innerHTML=gl),ps=a(e),c(Q.$$.fragment,e),rs=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-14lmk7e"&&(E.innerHTML=vl),cs=a(e),c(q.$$.fragment,e),fs=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-i8rr5s"&&(x.innerHTML=Il),us=a(e),c(X.$$.fragment,e),ds=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1b4jg3u"&&(S.textContent=Cl),Ms=a(e),D=o(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-vp14rw"&&(D.innerHTML=kl),ms=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-s7xu2t"&&(H.innerHTML=Vl),ys=a(e),c(z.$$.fragment,e),hs=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1llio5t"&&(A.innerHTML=Wl),Js=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1cym4i4"&&(Y.innerHTML=Rl),Ts=a(e),c(L.$$.fragment,e),Us=a(e),c(F.$$.fragment,e),ws=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-181junk"&&(P.innerHTML=Bl),bs=a(e),c(O.$$.fragment,e),js=a(e),c(K.$$.fragment,e),Zs=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-12c191q"&&(ee.innerHTML=_l),gs=a(e),c(se.$$.fragment,e),vs=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-jytaak"&&(le.innerHTML=$l),Is=a(e),c(te.$$.fragment,e),Cs=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1o7di1p"&&(ne.textContent=Nl),ks=a(e),c(ae.$$.fragment,e),Vs=a(e),c(ie.$$.fragment,e),Ws=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1wbk6u3"&&(oe.textContent=Gl),Rs=a(e),pe=o(e,"UL",{"data-svelte-h":!0}),p(pe)!=="svelte-3vv2bf"&&(pe.innerHTML=Ql),Bs=a(e),c(b.$$.fragment,e),_s=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-19u4owg"&&(re.innerHTML=El),$s=a(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),p(ce)!=="svelte-1e3wdtx"&&(ce.innerHTML=ql),Ns=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-16brnlv"&&(fe.textContent=xl),Gs=a(e),ue=o(e,"UL",{"data-svelte-h":!0}),p(ue)!=="svelte-11239e9"&&(ue.innerHTML=Xl),Qs=a(e),c(de.$$.fragment,e),Es=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-i3vx09"&&(Me.innerHTML=Sl),qs=a(e),c(me.$$.fragment,e),xs=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-ydb193"&&(ye.innerHTML=Dl),Xs=a(e),c(he.$$.fragment,e),Ss=a(e),c(Je.$$.fragment,e),Ds=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1036ei7"&&(Te.innerHTML=Hl),Hs=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1y53na1"&&(Ue.innerHTML=zl),zs=a(e),c(we.$$.fragment,e),As=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-7x7c45"&&(be.innerHTML=Al),Ys=a(e),c(je.$$.fragment,e),Ls=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-h4z70l"&&(Ze.innerHTML=Yl),Fs=a(e),c(ge.$$.fragment,e),Ps=a(e),c(ve.$$.fragment,e),Os=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1xjd8d0"&&(Ie.innerHTML=Ll),Ks=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1syzkky"&&(Ce.innerHTML=Fl),el=a(e),c(ke.$$.fragment,e),sl=a(e),c(Ve.$$.fragment,e),ll=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-nr77qh"&&(We.innerHTML=Pl),tl=a(e),Re=o(e,"UL",{"data-svelte-h":!0}),p(Re)!=="svelte-z3l1r9"&&(Re.innerHTML=Ol),nl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1m5lxqx"&&(Be.innerHTML=Kl),al=a(e),c(_e.$$.fragment,e),il=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-102ytrs"&&($e.innerHTML=et),ol=a(e),Ne=o(e,"UL",{"data-svelte-h":!0}),p(Ne)!=="svelte-1vtl904"&&(Ne.innerHTML=st),pl=a(e),c(Ge.$$.fragment,e),rl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-p8hzeo"&&(Qe.innerHTML=lt),cl=a(e),c(Ee.$$.fragment,e),fl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-5jik9b"&&(qe.textContent=tt),ul=a(e),c(xe.$$.fragment,e),dl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-bbh395"&&(Xe.innerHTML=nt),Ml=a(e),Se=o(e,"UL",{"data-svelte-h":!0}),p(Se)!=="svelte-hr84vt"&&(Se.innerHTML=at),ml=a(e),c(De.$$.fragment,e),yl=a(e),ze=o(e,"P",{}),pt(ze).forEach(l),this.h()},h(){rt(m,"name","hf:doc:metadata"),rt(m,"content",bt)},m(e,s){ht(document.head,m),t(e,J,s),t(e,h,s),t(e,U,s),f(j,e,s),t(e,Ae,s),f(Z,e,s),t(e,Ye,s),t(e,g,s),t(e,Le,s),t(e,v,s),t(e,Fe,s),t(e,I,s),t(e,Pe,s),t(e,C,s),t(e,Oe,s),f(k,e,s),t(e,Ke,s),f(w,e,s),t(e,es,s),t(e,V,s),t(e,ss,s),f(W,e,s),t(e,ls,s),t(e,R,s),t(e,ts,s),f(B,e,s),t(e,ns,s),t(e,_,s),t(e,as,s),f($,e,s),t(e,is,s),f(N,e,s),t(e,os,s),t(e,G,s),t(e,ps,s),f(Q,e,s),t(e,rs,s),t(e,E,s),t(e,cs,s),f(q,e,s),t(e,fs,s),t(e,x,s),t(e,us,s),f(X,e,s),t(e,ds,s),t(e,S,s),t(e,Ms,s),t(e,D,s),t(e,ms,s),t(e,H,s),t(e,ys,s),f(z,e,s),t(e,hs,s),t(e,A,s),t(e,Js,s),t(e,Y,s),t(e,Ts,s),f(L,e,s),t(e,Us,s),f(F,e,s),t(e,ws,s),t(e,P,s),t(e,bs,s),f(O,e,s),t(e,js,s),f(K,e,s),t(e,Zs,s),t(e,ee,s),t(e,gs,s),f(se,e,s),t(e,vs,s),t(e,le,s),t(e,Is,s),f(te,e,s),t(e,Cs,s),t(e,ne,s),t(e,ks,s),f(ae,e,s),t(e,Vs,s),f(ie,e,s),t(e,Ws,s),t(e,oe,s),t(e,Rs,s),t(e,pe,s),t(e,Bs,s),f(b,e,s),t(e,_s,s),t(e,re,s),t(e,$s,s),t(e,ce,s),t(e,Ns,s),t(e,fe,s),t(e,Gs,s),t(e,ue,s),t(e,Qs,s),f(de,e,s),t(e,Es,s),t(e,Me,s),t(e,qs,s),f(me,e,s),t(e,xs,s),t(e,ye,s),t(e,Xs,s),f(he,e,s),t(e,Ss,s),f(Je,e,s),t(e,Ds,s),t(e,Te,s),t(e,Hs,s),t(e,Ue,s),t(e,zs,s),f(we,e,s),t(e,As,s),t(e,be,s),t(e,Ys,s),f(je,e,s),t(e,Ls,s),t(e,Ze,s),t(e,Fs,s),f(ge,e,s),t(e,Ps,s),f(ve,e,s),t(e,Os,s),t(e,Ie,s),t(e,Ks,s),t(e,Ce,s),t(e,el,s),f(ke,e,s),t(e,sl,s),f(Ve,e,s),t(e,ll,s),t(e,We,s),t(e,tl,s),t(e,Re,s),t(e,nl,s),t(e,Be,s),t(e,al,s),f(_e,e,s),t(e,il,s),t(e,$e,s),t(e,ol,s),t(e,Ne,s),t(e,pl,s),f(Ge,e,s),t(e,rl,s),t(e,Qe,s),t(e,cl,s),f(Ee,e,s),t(e,fl,s),t(e,qe,s),t(e,ul,s),f(xe,e,s),t(e,dl,s),t(e,Xe,s),t(e,Ml,s),t(e,Se,s),t(e,ml,s),f(De,e,s),t(e,yl,s),t(e,ze,s),hl=!0},p(e,[s]){const it={};s&2&&(it.$$scope={dirty:s,ctx:e}),w.$set(it);const ot={};s&2&&(ot.$$scope={dirty:s,ctx:e}),b.$set(ot)},i(e){hl||(u(j.$$.fragment,e),u(Z.$$.fragment,e),u(k.$$.fragment,e),u(w.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u($.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u(q.$$.fragment,e),u(X.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(se.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(b.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(Je.$$.fragment,e),u(we.$$.fragment,e),u(je.$$.fragment,e),u(ge.$$.fragment,e),u(ve.$$.fragment,e),u(ke.$$.fragment,e),u(Ve.$$.fragment,e),u(_e.$$.fragment,e),u(Ge.$$.fragment,e),u(Ee.$$.fragment,e),u(xe.$$.fragment,e),u(De.$$.fragment,e),hl=!0)},o(e){d(j.$$.fragment,e),d(Z.$$.fragment,e),d(k.$$.fragment,e),d(w.$$.fragment,e),d(W.$$.fragment,e),d(B.$$.fragment,e),d($.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(q.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(L.$$.fragment,e),d(F.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(b.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(Je.$$.fragment,e),d(we.$$.fragment,e),d(je.$$.fragment,e),d(ge.$$.fragment,e),d(ve.$$.fragment,e),d(ke.$$.fragment,e),d(Ve.$$.fragment,e),d(_e.$$.fragment,e),d(Ge.$$.fragment,e),d(Ee.$$.fragment,e),d(xe.$$.fragment,e),d(De.$$.fragment,e),hl=!1},d(e){e&&(l(J),l(h),l(U),l(Ae),l(Ye),l(g),l(Le),l(v),l(Fe),l(I),l(Pe),l(C),l(Oe),l(Ke),l(es),l(V),l(ss),l(ls),l(R),l(ts),l(ns),l(_),l(as),l(is),l(os),l(G),l(ps),l(rs),l(E),l(cs),l(fs),l(x),l(us),l(ds),l(S),l(Ms),l(D),l(ms),l(H),l(ys),l(hs),l(A),l(Js),l(Y),l(Ts),l(Us),l(ws),l(P),l(bs),l(js),l(Zs),l(ee),l(gs),l(vs),l(le),l(Is),l(Cs),l(ne),l(ks),l(Vs),l(Ws),l(oe),l(Rs),l(pe),l(Bs),l(_s),l(re),l($s),l(ce),l(Ns),l(fe),l(Gs),l(ue),l(Qs),l(Es),l(Me),l(qs),l(xs),l(ye),l(Xs),l(Ss),l(Ds),l(Te),l(Hs),l(Ue),l(zs),l(As),l(be),l(Ys),l(Ls),l(Ze),l(Fs),l(Ps),l(Os),l(Ie),l(Ks),l(Ce),l(el),l(sl),l(ll),l(We),l(tl),l(Re),l(nl),l(Be),l(al),l(il),l($e),l(ol),l(Ne),l(pl),l(rl),l(Qe),l(cl),l(fl),l(qe),l(ul),l(dl),l(Xe),l(Ml),l(Se),l(ml),l(yl),l(ze)),l(m),M(j,e),M(Z,e),M(k,e),M(w,e),M(W,e),M(B,e),M($,e),M(N,e),M(Q,e),M(q,e),M(X,e),M(z,e),M(L,e),M(F,e),M(O,e),M(K,e),M(se,e),M(te,e),M(ae,e),M(ie,e),M(b,e),M(de,e),M(me,e),M(he,e),M(Je,e),M(we,e),M(je,e),M(ge,e),M(ve,e),M(ke,e),M(Ve,e),M(_e,e),M(Ge,e),M(Ee,e),M(xe,e),M(De,e)}}}const bt='{"title":"Load pipelines, models, and schedulers","local":"load-pipelines-models-and-schedulers","sections":[{"title":"Diffusion Pipeline","local":"diffusion-pipeline","sections":[{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3},{"title":"Swap components in a pipeline","local":"swap-components-in-a-pipeline","sections":[],"depth":3},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":3},{"title":"Reuse components across pipelines","local":"reuse-components-across-pipelines","sections":[],"depth":3}],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Schedulers","local":"schedulers","sections":[],"depth":2},{"title":"DiffusionPipeline explained","local":"diffusionpipeline-explained","sections":[],"depth":2}],"depth":1}';function jt(He){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Mt{constructor(m){super(),mt(this,m,jt,wt,ut,{})}}export{Vt as component};
