import{s as Dc,n as qc,o as Ic}from"../chunks/scheduler.b108d059.js";import{S as Kc,i as Bc,g as i,s as n,r as a,A as Nc,h as r,f as l,c as o,j as h,u as m,x as d,k as u,y as Vc,a as s,v as p,d as c,t as f,w as T}from"../chunks/index.008de539.js";import{C as lm}from"../chunks/CodeBlock.3968c746.js";import{H as _,E as Qc}from"../chunks/EditOnGithub.d1c48e3d.js";function Sc(sm){let $,un,rn,an,y,mn,b,pn,v,nm="Helper module for <code>Tensor</code> processing.",cn,M,om=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,fn,x,im='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒</li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor..args%5B1%5D"><code>~args[1]</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',Tn,hn,_n,C,$n,H,yn,L,rm='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',bn,w,dm='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',vn,Mn,xn,A,Cn,g,Hn,z,um="Create a new Tensor or copy an existing Tensor.",Ln,P,am="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",wn,An,gn,U,zn,R,Pn,E,mm="Dimensions of the tensor.",Un,j,pm='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Rn,En,jn,J,Jn,k,kn,D,cm="Type of the tensor.",Dn,q,fm='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',qn,In,Kn,I,Bn,K,Nn,B,Tm="The data stored in the tensor.",Vn,N,hm='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Qn,Sn,On,V,Wn,Q,Yn,S,_m="The number of elements in the tensor.",Fn,O,$m='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Gn,Zn,Xn,W,eo,Y,to,F,ym=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,lo,G,bm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',so,no,oo,Z,io,X,ro,ee,vm="Index into a Tensor object.",uo,te,Mm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',ao,le,xm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",mo,po,co,se,fo,ne,To,oe,Cm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',ho,ie,Hm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",_o,$o,yo,re,bo,de,vo,ue,Lm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mo,ae,wm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",xo,Co,Ho,me,Lo,pe,wo,ce,Am=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Ao,fe,gm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',go,Te,zm="<li><code>Error</code> If the tensor has more than one element.</li>",zo,Po,Uo,he,Ro,_e,Eo,$e,Pm="Convert tensor data to a n-dimensional JS list",jo,ye,Um='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Jo,ko,Do,be,qo,ve,Io,Me,Rm="Return a new Tensor with the sigmoid function applied to each element.",Ko,xe,Em='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Bo,No,Vo,Ce,Qo,He,So,Le,jm="Applies the sigmoid function to the tensor in place.",Oo,we,Jm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Wo,Yo,Fo,Ae,Go,ge,Zo,ze,km="Return a new Tensor with every element multiplied by a constant.",Xo,Pe,Dm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',ei,Ue,qm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",ti,li,si,Re,ni,Ee,oi,je,Im="Multiply the tensor by a constant in place.",ii,Je,Km='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',ri,ke,Bm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",di,ui,ai,De,mi,qe,pi,Ie,Nm="Return a new Tensor with every element added by a constant.",ci,Ke,Vm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',fi,Be,Qm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Ti,hi,_i,Ne,$i,Ve,yi,Qe,Sm="Add the tensor by a constant in place.",bi,Se,Om='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',vi,Oe,Wm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Mi,xi,Ci,We,Hi,Ye,Li,Fe,Ym="Return a permuted version of this Tensor, according to the provided dimensions.",wi,Ge,Fm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',Ai,Ze,Gm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",gi,zi,Pi,Xe,Ui,et,Ri,tt,Zm="Returns the sum of each row of the input tensor in the given dimension dim.",Ei,lt,Xm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',ji,st,ep="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Ji,ki,Di,nt,qi,ot,Ii,it,tp="Returns the matrix norm or vector norm of a given tensor.",Ki,rt,lp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Bi,dt,sp=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Ni,Vi,Qi,ut,Si,at,Oi,mt,np="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Wi,pt,op='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Yi,ct,ip="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Fi,Gi,Zi,ft,Xi,Tt,er,ht,rp="Performs <code>L_p</code> normalization of inputs over specified dimension.",tr,_t,dp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',lr,$t,up="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",sr,nr,or,yt,ir,bt,rr,vt,ap=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,dr,Mt,mp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',ur,ar,mr,xt,pr,Ct,cr,Ht,pp="Returns a tensor with all specified dimensions of input of size 1 removed.",fr,Lt,cp=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,Tr,wt,fp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The squeezed tensor',hr,At,Tp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",_r,$r,yr,gt,br,zt,vr,Pt,hp='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',Mr,Ut,_p='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',xr,Cr,Hr,Rt,Lr,Et,wr,jt,$p="Returns a new tensor with a dimension of size one inserted at the specified position.",Ar,Jt,yp="NOTE: The returned tensor shares the same underlying data with this tensor.",gr,kt,bp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The unsqueezed tensor',zr,Dt,vp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",Pr,Ur,Rr,qt,Er,It,jr,Kt,Mp='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Jr,Bt,xp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',kr,Dr,qr,Nt,Ir,Vt,Kr,Qt,Cp='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Br,St,Hp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Nr,Vr,Qr,Ot,Sr,Wt,Or,Yt,Lp=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Wr,Ft,wp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The flattened tensor.',Yr,Gt,Ap="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Fr,Gr,Zr,Zt,Xr,Xt,ed,el,gp="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",td,tl,zp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',ld,ll,Pp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",sd,nd,od,sl,id,nl,rd,ol,Up='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',dd,il,Rp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ud,ad,md,rl,pd,dl,cd,ul,Ep="Clamps all elements in input into the range [ min, max ]",fd,al,jp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',Td,ml,Jp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",hd,_d,$d,pl,yd,cl,bd,fl,kp='In-place version of @see <a href="Tensor.round">Tensor.round</a>',vd,Tl,Dp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Md,xd,Cd,hl,Hd,_l,Ld,$l,qp="Rounds elements of input to the nearest integer.",wd,yl,Ip='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',Ad,gd,zd,bl,Pd,vl,Ud,Ml,Kp="Performs Tensor dtype conversion.",Rd,xl,Bp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',Ed,Cl,Np="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code>DataType</code></td><td><p>The desired data type.</p></td></tr></tbody>",jd,Jd,kd,Hl,Dd,Ll,qd,wl,Vp="Permutes a tensor according to the provided axes.",Id,Al,Qp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',Kd,gl,Sp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",Bd,Nd,Vd,zl,Qd,Pl,Sd,Ul,Op="Interpolates an Tensor to the given size.",Od,Rl,Wp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Wd,El,Yp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Yd,Fd,Gd,jl,Zd,Jl,Xd,kl,Fp="Perform mean pooling of the last hidden state followed by a normalization step.",eu,Dl,Gp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',tu,ql,Zp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",lu,su,nu,Il,ou,Kl,iu,Bl,Xp="Apply Layer Normalization for last certain number of dimensions.",ru,Nl,ec='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',du,Vl,tc="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>",uu,au,mu,Ql,pu,Sl,cu,Ol,lc="Concatenates an array of tensors along a specified dimension.",fu,Wl,sc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',Tu,Yl,nc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",hu,_u,$u,Fl,yu,Gl,bu,Zl,oc="Stack an array of tensors along a specified dimension.",vu,Xl,ic='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',Mu,es,rc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",xu,Cu,Hu,ts,Lu,ls,wu,ss,dc="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",Au,ns,uc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',gu,os,ac="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",zu,Pu,Uu,is,Ru,rs,Eu,ds,mc="Returns the mean value of each row of the input tensor in the given dimension dim.",ju,us,pc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: A new tensor with means taken along the specified dimension.',Ju,as,cc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",ku,Du,qu,ms,Iu,ps,Ku,cs,fc=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,Bu,fs,Tc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Nu,Ts,hc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",Vu,Qu,Su,hs,Ou,_s,Wu,$s,_c="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Yu,ys,$c='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Fu,bs,yc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Gu,Zu,Xu,vs,ea,Ms,ta,xs,bc="Returns a tensor filled with the scalar value 1, with the same size as input.",la,Cs,vc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: The ones tensor.',sa,Hs,Mc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",na,oa,ia,Ls,ra,ws,da,As,xc="Quantizes the embeddings tensor to binary or unsigned binary precision.",ua,gs,Cc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The quantized tensor.',aa,zs,Hc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>",ma,pa,ca,Ps,fa,Us,Ta,Rs,Lc='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',ha,_a,$a,Es,ya,js,ba,Js,wc='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',va,Ma,xa,ks,Ca,Ds,Ha,qs,Ac="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",La,Is,gc='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',wa,Ks,zc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",Aa,Bs,Pc="<strong>Example</strong>",ga,Ns,za,Pa,Ua,Vs,Ra,Qs,Ea,Ss,Uc='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',ja,Ja,ka,Os,Da,Ws,qa,Ys,Rc='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Ia,Ka,Ba,Fs,Na,Gs,Va,Zs,Ec="This creates a nested array of a given type and depth (see examples).",Qa,Xs,jc='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',Sa,en,Oa,tn,Jc="<strong>Example</strong>",Wa,ln,Ya,sn,kc="<strong>Example</strong>",Fa,nn,Ga,Za,Xa,on,em,dn,tm;return b=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),R=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),k=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),Q=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),X=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),ne=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),de=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),_e=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),ve=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ee=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),qe=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Ve=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Ye=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),et=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),ot=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),at=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Tt=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),bt=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.squeeze([dim]) ⇒",local:"tensorsqueezedim-",headingTag:"h3"}}),zt=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Et=new _({props:{title:"tensor.unsqueeze(dim) ⇒",local:"tensorunsqueezedim-",headingTag:"h3"}}),It=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Wt=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒",local:"tensorflattenstartdim-enddim-",headingTag:"h3"}}),Xt=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),nl=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),dl=new _({props:{title:"tensor.clamp(min, max) ⇒",local:"tensorclampmin-max-",headingTag:"h3"}}),cl=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),_l=new _({props:{title:"tensor.round() ⇒",local:"tensorround-",headingTag:"h3"}}),vl=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),Pl=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Jl=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Kl=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),Sl=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Gl=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),ls=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),rs=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒",local:"utilstensormeaninput-dim-keepdim-",headingTag:"h2"}}),ps=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),_s=new _({props:{title:"utils/tensor.ones(size)",local:"utilstensoronessize",headingTag:"h2"}}),Ms=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒",local:"utilstensoronesliketensor-",headingTag:"h2"}}),ws=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),Us=new _({props:{title:"utils/tensor~args[0] : <code> DataType </code>",local:"utilstensorargs0--code-datatype-code",headingTag:"h2"}}),js=new _({props:{title:"utils/tensor~args[1] : <code> * </code>",local:"utilstensorargs1--code--code",headingTag:"h2"}}),Ds=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Ns=new lm({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),Qs=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),Ws=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Gs=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),en=new lm({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),ln=new lm({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),nn=new lm({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),on=new Qc({props:{source:"https://github.com/xenova/transformers.js/blob/v2.17.2/docs/source/api/utils/tensor.md"}}),{c(){$=i("meta"),un=n(),rn=i("p"),an=n(),y=i("a"),mn=n(),a(b.$$.fragment),pn=n(),v=i("p"),v.innerHTML=nm,cn=n(),M=i("p"),M.textContent=om,fn=n(),x=i("ul"),x.innerHTML=im,Tn=n(),hn=i("hr"),_n=n(),C=i("a"),$n=n(),a(H.$$.fragment),yn=n(),L=i("p"),L.innerHTML=rm,bn=n(),w=i("ul"),w.innerHTML=dm,vn=n(),Mn=i("hr"),xn=n(),A=i("a"),Cn=n(),a(g.$$.fragment),Hn=n(),z=i("p"),z.textContent=um,Ln=n(),P=i("table"),P.innerHTML=am,wn=n(),An=i("hr"),gn=n(),U=i("a"),zn=n(),a(R.$$.fragment),Pn=n(),E=i("p"),E.textContent=mm,Un=n(),j=i("p"),j.innerHTML=pm,Rn=n(),En=i("hr"),jn=n(),J=i("a"),Jn=n(),a(k.$$.fragment),kn=n(),D=i("p"),D.textContent=cm,Dn=n(),q=i("p"),q.innerHTML=fm,qn=n(),In=i("hr"),Kn=n(),I=i("a"),Bn=n(),a(K.$$.fragment),Nn=n(),B=i("p"),B.textContent=Tm,Vn=n(),N=i("p"),N.innerHTML=hm,Qn=n(),Sn=i("hr"),On=n(),V=i("a"),Wn=n(),a(Q.$$.fragment),Yn=n(),S=i("p"),S.textContent=_m,Fn=n(),O=i("p"),O.innerHTML=$m,Gn=n(),Zn=i("hr"),Xn=n(),W=i("a"),eo=n(),a(Y.$$.fragment),to=n(),F=i("p"),F.textContent=ym,lo=n(),G=i("p"),G.innerHTML=bm,so=n(),no=i("hr"),oo=n(),Z=i("a"),io=n(),a(X.$$.fragment),ro=n(),ee=i("p"),ee.textContent=vm,uo=n(),te=i("p"),te.innerHTML=Mm,ao=n(),le=i("table"),le.innerHTML=xm,mo=n(),po=i("hr"),co=n(),se=i("a"),fo=n(),a(ne.$$.fragment),To=n(),oe=i("p"),oe.innerHTML=Cm,ho=n(),ie=i("table"),ie.innerHTML=Hm,_o=n(),$o=i("hr"),yo=n(),re=i("a"),bo=n(),a(de.$$.fragment),vo=n(),ue=i("p"),ue.innerHTML=Lm,Mo=n(),ae=i("table"),ae.innerHTML=wm,xo=n(),Co=i("hr"),Ho=n(),me=i("a"),Lo=n(),a(pe.$$.fragment),wo=n(),ce=i("p"),ce.innerHTML=Am,Ao=n(),fe=i("p"),fe.innerHTML=gm,go=n(),Te=i("ul"),Te.innerHTML=zm,zo=n(),Po=i("hr"),Uo=n(),he=i("a"),Ro=n(),a(_e.$$.fragment),Eo=n(),$e=i("p"),$e.textContent=Pm,jo=n(),ye=i("p"),ye.innerHTML=Um,Jo=n(),ko=i("hr"),Do=n(),be=i("a"),qo=n(),a(ve.$$.fragment),Io=n(),Me=i("p"),Me.textContent=Rm,Ko=n(),xe=i("p"),xe.innerHTML=Em,Bo=n(),No=i("hr"),Vo=n(),Ce=i("a"),Qo=n(),a(He.$$.fragment),So=n(),Le=i("p"),Le.textContent=jm,Oo=n(),we=i("p"),we.innerHTML=Jm,Wo=n(),Yo=i("hr"),Fo=n(),Ae=i("a"),Go=n(),a(ge.$$.fragment),Zo=n(),ze=i("p"),ze.textContent=km,Xo=n(),Pe=i("p"),Pe.innerHTML=Dm,ei=n(),Ue=i("table"),Ue.innerHTML=qm,ti=n(),li=i("hr"),si=n(),Re=i("a"),ni=n(),a(Ee.$$.fragment),oi=n(),je=i("p"),je.textContent=Im,ii=n(),Je=i("p"),Je.innerHTML=Km,ri=n(),ke=i("table"),ke.innerHTML=Bm,di=n(),ui=i("hr"),ai=n(),De=i("a"),mi=n(),a(qe.$$.fragment),pi=n(),Ie=i("p"),Ie.textContent=Nm,ci=n(),Ke=i("p"),Ke.innerHTML=Vm,fi=n(),Be=i("table"),Be.innerHTML=Qm,Ti=n(),hi=i("hr"),_i=n(),Ne=i("a"),$i=n(),a(Ve.$$.fragment),yi=n(),Qe=i("p"),Qe.textContent=Sm,bi=n(),Se=i("p"),Se.innerHTML=Om,vi=n(),Oe=i("table"),Oe.innerHTML=Wm,Mi=n(),xi=i("hr"),Ci=n(),We=i("a"),Hi=n(),a(Ye.$$.fragment),Li=n(),Fe=i("p"),Fe.textContent=Ym,wi=n(),Ge=i("p"),Ge.innerHTML=Fm,Ai=n(),Ze=i("table"),Ze.innerHTML=Gm,gi=n(),zi=i("hr"),Pi=n(),Xe=i("a"),Ui=n(),a(et.$$.fragment),Ri=n(),tt=i("p"),tt.textContent=Zm,Ei=n(),lt=i("p"),lt.innerHTML=Xm,ji=n(),st=i("table"),st.innerHTML=ep,Ji=n(),ki=i("hr"),Di=n(),nt=i("a"),qi=n(),a(ot.$$.fragment),Ii=n(),it=i("p"),it.textContent=tp,Ki=n(),rt=i("p"),rt.innerHTML=lp,Bi=n(),dt=i("table"),dt.innerHTML=sp,Ni=n(),Vi=i("hr"),Qi=n(),ut=i("a"),Si=n(),a(at.$$.fragment),Oi=n(),mt=i("p"),mt.innerHTML=np,Wi=n(),pt=i("p"),pt.innerHTML=op,Yi=n(),ct=i("table"),ct.innerHTML=ip,Fi=n(),Gi=i("hr"),Zi=n(),ft=i("a"),Xi=n(),a(Tt.$$.fragment),er=n(),ht=i("p"),ht.innerHTML=rp,tr=n(),_t=i("p"),_t.innerHTML=dp,lr=n(),$t=i("table"),$t.innerHTML=up,sr=n(),nr=i("hr"),or=n(),yt=i("a"),ir=n(),a(bt.$$.fragment),rr=n(),vt=i("p"),vt.textContent=ap,dr=n(),Mt=i("p"),Mt.innerHTML=mp,ur=n(),ar=i("hr"),mr=n(),xt=i("a"),pr=n(),a(Ct.$$.fragment),cr=n(),Ht=i("p"),Ht.textContent=pp,fr=n(),Lt=i("p"),Lt.innerHTML=cp,Tr=n(),wt=i("p"),wt.innerHTML=fp,hr=n(),At=i("table"),At.innerHTML=Tp,_r=n(),$r=i("hr"),yr=n(),gt=i("a"),br=n(),a(zt.$$.fragment),vr=n(),Pt=i("p"),Pt.innerHTML=hp,Mr=n(),Ut=i("p"),Ut.innerHTML=_p,xr=n(),Cr=i("hr"),Hr=n(),Rt=i("a"),Lr=n(),a(Et.$$.fragment),wr=n(),jt=i("p"),jt.textContent=$p,Ar=n(),Jt=i("p"),Jt.textContent=yp,gr=n(),kt=i("p"),kt.innerHTML=bp,zr=n(),Dt=i("table"),Dt.innerHTML=vp,Pr=n(),Ur=i("hr"),Rr=n(),qt=i("a"),Er=n(),a(It.$$.fragment),jr=n(),Kt=i("p"),Kt.innerHTML=Mp,Jr=n(),Bt=i("p"),Bt.innerHTML=xp,kr=n(),Dr=i("hr"),qr=n(),Nt=i("a"),Ir=n(),a(Vt.$$.fragment),Kr=n(),Qt=i("p"),Qt.innerHTML=Cp,Br=n(),St=i("p"),St.innerHTML=Hp,Nr=n(),Vr=i("hr"),Qr=n(),Ot=i("a"),Sr=n(),a(Wt.$$.fragment),Or=n(),Yt=i("p"),Yt.innerHTML=Lp,Wr=n(),Ft=i("p"),Ft.innerHTML=wp,Yr=n(),Gt=i("table"),Gt.innerHTML=Ap,Fr=n(),Gr=i("hr"),Zr=n(),Zt=i("a"),Xr=n(),a(Xt.$$.fragment),ed=n(),el=i("p"),el.innerHTML=gp,td=n(),tl=i("p"),tl.innerHTML=zp,ld=n(),ll=i("table"),ll.innerHTML=Pp,sd=n(),nd=i("hr"),od=n(),sl=i("a"),id=n(),a(nl.$$.fragment),rd=n(),ol=i("p"),ol.innerHTML=Up,dd=n(),il=i("p"),il.innerHTML=Rp,ud=n(),ad=i("hr"),md=n(),rl=i("a"),pd=n(),a(dl.$$.fragment),cd=n(),ul=i("p"),ul.textContent=Ep,fd=n(),al=i("p"),al.innerHTML=jp,Td=n(),ml=i("table"),ml.innerHTML=Jp,hd=n(),_d=i("hr"),$d=n(),pl=i("a"),yd=n(),a(cl.$$.fragment),bd=n(),fl=i("p"),fl.innerHTML=kp,vd=n(),Tl=i("p"),Tl.innerHTML=Dp,Md=n(),xd=i("hr"),Cd=n(),hl=i("a"),Hd=n(),a(_l.$$.fragment),Ld=n(),$l=i("p"),$l.textContent=qp,wd=n(),yl=i("p"),yl.innerHTML=Ip,Ad=n(),gd=i("hr"),zd=n(),bl=i("a"),Pd=n(),a(vl.$$.fragment),Ud=n(),Ml=i("p"),Ml.textContent=Kp,Rd=n(),xl=i("p"),xl.innerHTML=Bp,Ed=n(),Cl=i("table"),Cl.innerHTML=Np,jd=n(),Jd=i("hr"),kd=n(),Hl=i("a"),Dd=n(),a(Ll.$$.fragment),qd=n(),wl=i("p"),wl.textContent=Vp,Id=n(),Al=i("p"),Al.innerHTML=Qp,Kd=n(),gl=i("table"),gl.innerHTML=Sp,Bd=n(),Nd=i("hr"),Vd=n(),zl=i("a"),Qd=n(),a(Pl.$$.fragment),Sd=n(),Ul=i("p"),Ul.textContent=Op,Od=n(),Rl=i("p"),Rl.innerHTML=Wp,Wd=n(),El=i("table"),El.innerHTML=Yp,Yd=n(),Fd=i("hr"),Gd=n(),jl=i("a"),Zd=n(),a(Jl.$$.fragment),Xd=n(),kl=i("p"),kl.textContent=Fp,eu=n(),Dl=i("p"),Dl.innerHTML=Gp,tu=n(),ql=i("table"),ql.innerHTML=Zp,lu=n(),su=i("hr"),nu=n(),Il=i("a"),ou=n(),a(Kl.$$.fragment),iu=n(),Bl=i("p"),Bl.textContent=Xp,ru=n(),Nl=i("p"),Nl.innerHTML=ec,du=n(),Vl=i("table"),Vl.innerHTML=tc,uu=n(),au=i("hr"),mu=n(),Ql=i("a"),pu=n(),a(Sl.$$.fragment),cu=n(),Ol=i("p"),Ol.textContent=lc,fu=n(),Wl=i("p"),Wl.innerHTML=sc,Tu=n(),Yl=i("table"),Yl.innerHTML=nc,hu=n(),_u=i("hr"),$u=n(),Fl=i("a"),yu=n(),a(Gl.$$.fragment),bu=n(),Zl=i("p"),Zl.textContent=oc,vu=n(),Xl=i("p"),Xl.innerHTML=ic,Mu=n(),es=i("table"),es.innerHTML=rc,xu=n(),Cu=i("hr"),Hu=n(),ts=i("a"),Lu=n(),a(ls.$$.fragment),wu=n(),ss=i("p"),ss.innerHTML=dc,Au=n(),ns=i("p"),ns.innerHTML=uc,gu=n(),os=i("table"),os.innerHTML=ac,zu=n(),Pu=i("hr"),Uu=n(),is=i("a"),Ru=n(),a(rs.$$.fragment),Eu=n(),ds=i("p"),ds.textContent=mc,ju=n(),us=i("p"),us.innerHTML=pc,Ju=n(),as=i("table"),as.innerHTML=cc,ku=n(),Du=i("hr"),qu=n(),ms=i("a"),Iu=n(),a(ps.$$.fragment),Ku=n(),cs=i("p"),cs.textContent=fc,Bu=n(),fs=i("p"),fs.innerHTML=Tc,Nu=n(),Ts=i("table"),Ts.innerHTML=hc,Vu=n(),Qu=i("hr"),Su=n(),hs=i("a"),Ou=n(),a(_s.$$.fragment),Wu=n(),$s=i("p"),$s.textContent=_c,Yu=n(),ys=i("p"),ys.innerHTML=$c,Fu=n(),bs=i("table"),bs.innerHTML=yc,Gu=n(),Zu=i("hr"),Xu=n(),vs=i("a"),ea=n(),a(Ms.$$.fragment),ta=n(),xs=i("p"),xs.textContent=bc,la=n(),Cs=i("p"),Cs.innerHTML=vc,sa=n(),Hs=i("table"),Hs.innerHTML=Mc,na=n(),oa=i("hr"),ia=n(),Ls=i("a"),ra=n(),a(ws.$$.fragment),da=n(),As=i("p"),As.textContent=xc,ua=n(),gs=i("p"),gs.innerHTML=Cc,aa=n(),zs=i("table"),zs.innerHTML=Hc,ma=n(),pa=i("hr"),ca=n(),Ps=i("a"),fa=n(),a(Us.$$.fragment),Ta=n(),Rs=i("p"),Rs.innerHTML=Lc,ha=n(),_a=i("hr"),$a=n(),Es=i("a"),ya=n(),a(js.$$.fragment),ba=n(),Js=i("p"),Js.innerHTML=wc,va=n(),Ma=i("hr"),xa=n(),ks=i("a"),Ca=n(),a(Ds.$$.fragment),Ha=n(),qs=i("p"),qs.textContent=Ac,La=n(),Is=i("p"),Is.innerHTML=gc,wa=n(),Ks=i("table"),Ks.innerHTML=zc,Aa=n(),Bs=i("p"),Bs.innerHTML=Pc,ga=n(),a(Ns.$$.fragment),za=n(),Pa=i("hr"),Ua=n(),Vs=i("a"),Ra=n(),a(Qs.$$.fragment),Ea=n(),Ss=i("p"),Ss.innerHTML=Uc,ja=n(),Ja=i("hr"),ka=n(),Os=i("a"),Da=n(),a(Ws.$$.fragment),qa=n(),Ys=i("p"),Ys.innerHTML=Rc,Ia=n(),Ka=i("hr"),Ba=n(),Fs=i("a"),Na=n(),a(Gs.$$.fragment),Va=n(),Zs=i("p"),Zs.textContent=Ec,Qa=n(),Xs=i("p"),Xs.innerHTML=jc,Sa=n(),a(en.$$.fragment),Oa=n(),tn=i("p"),tn.innerHTML=Jc,Wa=n(),a(ln.$$.fragment),Ya=n(),sn=i("p"),sn.innerHTML=kc,Fa=n(),a(nn.$$.fragment),Ga=n(),Za=i("hr"),Xa=n(),a(on.$$.fragment),em=n(),dn=i("p"),this.h()},l(e){const t=Nc("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),un=o(e),rn=r(e,"P",{}),h(rn).forEach(l),an=o(e),y=r(e,"A",{id:!0,class:!0}),h(y).forEach(l),mn=o(e),m(b.$$.fragment,e),pn=o(e),v=r(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-uw4y1m"&&(v.innerHTML=nm),cn=o(e),M=r(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=om),fn=o(e),x=r(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-1bjk6s8"&&(x.innerHTML=im),Tn=o(e),hn=r(e,"HR",{}),_n=o(e),C=r(e,"A",{id:!0,class:!0}),h(C).forEach(l),$n=o(e),m(H.$$.fragment,e),yn=o(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=rm),bn=o(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-kawule"&&(w.innerHTML=dm),vn=o(e),Mn=r(e,"HR",{}),xn=o(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(l),Cn=o(e),m(g.$$.fragment,e),Hn=o(e),z=r(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-55wecd"&&(z.textContent=um),Ln=o(e),P=r(e,"TABLE",{"data-svelte-h":!0}),d(P)!=="svelte-ee7emz"&&(P.innerHTML=am),wn=o(e),An=r(e,"HR",{}),gn=o(e),U=r(e,"A",{id:!0,class:!0}),h(U).forEach(l),zn=o(e),m(R.$$.fragment,e),Pn=o(e),E=r(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1gc2rt4"&&(E.textContent=mm),Un=o(e),j=r(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-10qzguj"&&(j.innerHTML=pm),Rn=o(e),En=r(e,"HR",{}),jn=o(e),J=r(e,"A",{id:!0,class:!0}),h(J).forEach(l),Jn=o(e),m(k.$$.fragment,e),kn=o(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=cm),Dn=o(e),q=r(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-10qzguj"&&(q.innerHTML=fm),qn=o(e),In=r(e,"HR",{}),Kn=o(e),I=r(e,"A",{id:!0,class:!0}),h(I).forEach(l),Bn=o(e),m(K.$$.fragment,e),Nn=o(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1eqabt7"&&(B.textContent=Tm),Vn=o(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-10qzguj"&&(N.innerHTML=hm),Qn=o(e),Sn=r(e,"HR",{}),On=o(e),V=r(e,"A",{id:!0,class:!0}),h(V).forEach(l),Wn=o(e),m(Q.$$.fragment,e),Yn=o(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=_m),Fn=o(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-10qzguj"&&(O.innerHTML=$m),Gn=o(e),Zn=r(e,"HR",{}),Xn=o(e),W=r(e,"A",{id:!0,class:!0}),h(W).forEach(l),eo=o(e),m(Y.$$.fragment,e),to=o(e),F=r(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1adn56z"&&(F.textContent=ym),lo=o(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1gxgvk6"&&(G.innerHTML=bm),so=o(e),no=r(e,"HR",{}),oo=o(e),Z=r(e,"A",{id:!0,class:!0}),h(Z).forEach(l),io=o(e),m(X.$$.fragment,e),ro=o(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1u97xg1"&&(ee.textContent=vm),uo=o(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1afa2dz"&&(te.innerHTML=Mm),ao=o(e),le=r(e,"TABLE",{"data-svelte-h":!0}),d(le)!=="svelte-1kq04ga"&&(le.innerHTML=xm),mo=o(e),po=r(e,"HR",{}),co=o(e),se=r(e,"A",{id:!0,class:!0}),h(se).forEach(l),fo=o(e),m(ne.$$.fragment,e),To=o(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1cg22af"&&(oe.innerHTML=Cm),ho=o(e),ie=r(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-1hful42"&&(ie.innerHTML=Hm),_o=o(e),$o=r(e,"HR",{}),yo=o(e),re=r(e,"A",{id:!0,class:!0}),h(re).forEach(l),bo=o(e),m(de.$$.fragment,e),vo=o(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1mr58c3"&&(ue.innerHTML=Lm),Mo=o(e),ae=r(e,"TABLE",{"data-svelte-h":!0}),d(ae)!=="svelte-153ftfy"&&(ae.innerHTML=wm),xo=o(e),Co=r(e,"HR",{}),Ho=o(e),me=r(e,"A",{id:!0,class:!0}),h(me).forEach(l),Lo=o(e),m(pe.$$.fragment,e),wo=o(e),ce=r(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-13nzfs3"&&(ce.innerHTML=Am),Ao=o(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-11rv1mu"&&(fe.innerHTML=gm),go=o(e),Te=r(e,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-5t2sg3"&&(Te.innerHTML=zm),zo=o(e),Po=r(e,"HR",{}),Uo=o(e),he=r(e,"A",{id:!0,class:!0}),h(he).forEach(l),Ro=o(e),m(_e.$$.fragment,e),Eo=o(e),$e=r(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-87xdyr"&&($e.textContent=Pm),jo=o(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1mr58c3"&&(ye.innerHTML=Um),Jo=o(e),ko=r(e,"HR",{}),Do=o(e),be=r(e,"A",{id:!0,class:!0}),h(be).forEach(l),qo=o(e),m(ve.$$.fragment,e),Io=o(e),Me=r(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-2wti2w"&&(Me.textContent=Rm),Ko=o(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-kpq7mo"&&(xe.innerHTML=Em),Bo=o(e),No=r(e,"HR",{}),Vo=o(e),Ce=r(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Qo=o(e),m(He.$$.fragment,e),So=o(e),Le=r(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1edu6c8"&&(Le.textContent=jm),Oo=o(e),we=r(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1hc4oxa"&&(we.innerHTML=Jm),Wo=o(e),Yo=r(e,"HR",{}),Fo=o(e),Ae=r(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),Go=o(e),m(ge.$$.fragment,e),Zo=o(e),ze=r(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-xg80lg"&&(ze.textContent=km),Xo=o(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1aygav2"&&(Pe.innerHTML=Dm),ei=o(e),Ue=r(e,"TABLE",{"data-svelte-h":!0}),d(Ue)!=="svelte-1tbtmqd"&&(Ue.innerHTML=qm),ti=o(e),li=r(e,"HR",{}),si=o(e),Re=r(e,"A",{id:!0,class:!0}),h(Re).forEach(l),ni=o(e),m(Ee.$$.fragment,e),oi=o(e),je=r(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1i12x1s"&&(je.textContent=Im),ii=o(e),Je=r(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1hc4oxa"&&(Je.innerHTML=Km),ri=o(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),d(ke)!=="svelte-1tbtmqd"&&(ke.innerHTML=Bm),di=o(e),ui=r(e,"HR",{}),ai=o(e),De=r(e,"A",{id:!0,class:!0}),h(De).forEach(l),mi=o(e),m(qe.$$.fragment,e),pi=o(e),Ie=r(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1hl64jn"&&(Ie.textContent=Nm),ci=o(e),Ke=r(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1aygav2"&&(Ke.innerHTML=Vm),fi=o(e),Be=r(e,"TABLE",{"data-svelte-h":!0}),d(Be)!=="svelte-1p5444"&&(Be.innerHTML=Qm),Ti=o(e),hi=r(e,"HR",{}),_i=o(e),Ne=r(e,"A",{id:!0,class:!0}),h(Ne).forEach(l),$i=o(e),m(Ve.$$.fragment,e),yi=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-bbf4x3"&&(Qe.textContent=Sm),bi=o(e),Se=r(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1hc4oxa"&&(Se.innerHTML=Om),vi=o(e),Oe=r(e,"TABLE",{"data-svelte-h":!0}),d(Oe)!=="svelte-1p5444"&&(Oe.innerHTML=Wm),Mi=o(e),xi=r(e,"HR",{}),Ci=o(e),We=r(e,"A",{id:!0,class:!0}),h(We).forEach(l),Hi=o(e),m(Ye.$$.fragment,e),Li=o(e),Fe=r(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1g8ouql"&&(Fe.textContent=Ym),wi=o(e),Ge=r(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1scc4l4"&&(Ge.innerHTML=Fm),Ai=o(e),Ze=r(e,"TABLE",{"data-svelte-h":!0}),d(Ze)!=="svelte-1p49qvp"&&(Ze.innerHTML=Gm),gi=o(e),zi=r(e,"HR",{}),Pi=o(e),Xe=r(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),Ui=o(e),m(et.$$.fragment,e),Ri=o(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-yjryb1"&&(tt.textContent=Zm),Ei=o(e),lt=r(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-xtr8tc"&&(lt.innerHTML=Xm),ji=o(e),st=r(e,"TABLE",{"data-svelte-h":!0}),d(st)!=="svelte-6xvdso"&&(st.innerHTML=ep),Ji=o(e),ki=r(e,"HR",{}),Di=o(e),nt=r(e,"A",{id:!0,class:!0}),h(nt).forEach(l),qi=o(e),m(ot.$$.fragment,e),Ii=o(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1okfsqx"&&(it.textContent=tp),Ki=o(e),rt=r(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1t556pk"&&(rt.innerHTML=lp),Bi=o(e),dt=r(e,"TABLE",{"data-svelte-h":!0}),d(dt)!=="svelte-13m2wni"&&(dt.innerHTML=sp),Ni=o(e),Vi=r(e,"HR",{}),Qi=o(e),ut=r(e,"A",{id:!0,class:!0}),h(ut).forEach(l),Si=o(e),m(at.$$.fragment,e),Oi=o(e),mt=r(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1htpbrk"&&(mt.innerHTML=np),Wi=o(e),pt=r(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1t0m8l6"&&(pt.innerHTML=op),Yi=o(e),ct=r(e,"TABLE",{"data-svelte-h":!0}),d(ct)!=="svelte-1qi99pl"&&(ct.innerHTML=ip),Fi=o(e),Gi=r(e,"HR",{}),Zi=o(e),ft=r(e,"A",{id:!0,class:!0}),h(ft).forEach(l),Xi=o(e),m(Tt.$$.fragment,e),er=o(e),ht=r(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1ztgqp"&&(ht.innerHTML=rp),tr=o(e),_t=r(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-mvb39p"&&(_t.innerHTML=dp),lr=o(e),$t=r(e,"TABLE",{"data-svelte-h":!0}),d($t)!=="svelte-1qi99pl"&&($t.innerHTML=up),sr=o(e),nr=r(e,"HR",{}),or=o(e),yt=r(e,"A",{id:!0,class:!0}),h(yt).forEach(l),ir=o(e),m(bt.$$.fragment,e),rr=o(e),vt=r(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1a7u185"&&(vt.textContent=ap),dr=o(e),Mt=r(e,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1eu3doh"&&(Mt.innerHTML=mp),ur=o(e),ar=r(e,"HR",{}),mr=o(e),xt=r(e,"A",{id:!0,class:!0}),h(xt).forEach(l),pr=o(e),m(Ct.$$.fragment,e),cr=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-qls17b"&&(Ht.textContent=pp),fr=o(e),Lt=r(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-5nabmy"&&(Lt.innerHTML=cp),Tr=o(e),wt=r(e,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1skbfxl"&&(wt.innerHTML=fp),hr=o(e),At=r(e,"TABLE",{"data-svelte-h":!0}),d(At)!=="svelte-52pnzr"&&(At.innerHTML=Tp),_r=o(e),$r=r(e,"HR",{}),yr=o(e),gt=r(e,"A",{id:!0,class:!0}),h(gt).forEach(l),br=o(e),m(zt.$$.fragment,e),vr=o(e),Pt=r(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-19w0pic"&&(Pt.innerHTML=hp),Mr=o(e),Ut=r(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1mr58c3"&&(Ut.innerHTML=_p),xr=o(e),Cr=r(e,"HR",{}),Hr=o(e),Rt=r(e,"A",{id:!0,class:!0}),h(Rt).forEach(l),Lr=o(e),m(Et.$$.fragment,e),wr=o(e),jt=r(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-18ws76n"&&(jt.textContent=$p),Ar=o(e),Jt=r(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1tnr5gm"&&(Jt.textContent=yp),gr=o(e),kt=r(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1aoa5jo"&&(kt.innerHTML=bp),zr=o(e),Dt=r(e,"TABLE",{"data-svelte-h":!0}),d(Dt)!=="svelte-1u9lyxp"&&(Dt.innerHTML=vp),Pr=o(e),Ur=r(e,"HR",{}),Rr=o(e),qt=r(e,"A",{id:!0,class:!0}),h(qt).forEach(l),Er=o(e),m(It.$$.fragment,e),jr=o(e),Kt=r(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-1b9ygao"&&(Kt.innerHTML=Mp),Jr=o(e),Bt=r(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1mr58c3"&&(Bt.innerHTML=xp),kr=o(e),Dr=r(e,"HR",{}),qr=o(e),Nt=r(e,"A",{id:!0,class:!0}),h(Nt).forEach(l),Ir=o(e),m(Vt.$$.fragment,e),Kr=o(e),Qt=r(e,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-1vkr5xo"&&(Qt.innerHTML=Cp),Br=o(e),St=r(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1mr58c3"&&(St.innerHTML=Hp),Nr=o(e),Vr=r(e,"HR",{}),Qr=o(e),Ot=r(e,"A",{id:!0,class:!0}),h(Ot).forEach(l),Sr=o(e),m(Wt.$$.fragment,e),Or=o(e),Yt=r(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-1gguudf"&&(Yt.innerHTML=Lp),Wr=o(e),Ft=r(e,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-9ffe42"&&(Ft.innerHTML=wp),Yr=o(e),Gt=r(e,"TABLE",{"data-svelte-h":!0}),d(Gt)!=="svelte-z6whez"&&(Gt.innerHTML=Ap),Fr=o(e),Gr=r(e,"HR",{}),Zr=o(e),Zt=r(e,"A",{id:!0,class:!0}),h(Zt).forEach(l),Xr=o(e),m(Xt.$$.fragment,e),ed=o(e),el=r(e,"P",{"data-svelte-h":!0}),d(el)!=="svelte-d6gvut"&&(el.innerHTML=gp),td=o(e),tl=r(e,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-18n9ux4"&&(tl.innerHTML=zp),ld=o(e),ll=r(e,"TABLE",{"data-svelte-h":!0}),d(ll)!=="svelte-jj58dd"&&(ll.innerHTML=Pp),sd=o(e),nd=r(e,"HR",{}),od=o(e),sl=r(e,"A",{id:!0,class:!0}),h(sl).forEach(l),id=o(e),m(nl.$$.fragment,e),rd=o(e),ol=r(e,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-1adolpg"&&(ol.innerHTML=Up),dd=o(e),il=r(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1mr58c3"&&(il.innerHTML=Rp),ud=o(e),ad=r(e,"HR",{}),md=o(e),rl=r(e,"A",{id:!0,class:!0}),h(rl).forEach(l),pd=o(e),m(dl.$$.fragment,e),cd=o(e),ul=r(e,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-1hm8vtj"&&(ul.textContent=Ep),fd=o(e),al=r(e,"P",{"data-svelte-h":!0}),d(al)!=="svelte-106ei5g"&&(al.innerHTML=jp),Td=o(e),ml=r(e,"TABLE",{"data-svelte-h":!0}),d(ml)!=="svelte-9ff0sy"&&(ml.innerHTML=Jp),hd=o(e),_d=r(e,"HR",{}),$d=o(e),pl=r(e,"A",{id:!0,class:!0}),h(pl).forEach(l),yd=o(e),m(cl.$$.fragment,e),bd=o(e),fl=r(e,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-1e6kzks"&&(fl.innerHTML=kp),vd=o(e),Tl=r(e,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-1mr58c3"&&(Tl.innerHTML=Dp),Md=o(e),xd=r(e,"HR",{}),Cd=o(e),hl=r(e,"A",{id:!0,class:!0}),h(hl).forEach(l),Hd=o(e),m(_l.$$.fragment,e),Ld=o(e),$l=r(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-t5k6jp"&&($l.textContent=qp),wd=o(e),yl=r(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-106ei5g"&&(yl.innerHTML=Ip),Ad=o(e),gd=r(e,"HR",{}),zd=o(e),bl=r(e,"A",{id:!0,class:!0}),h(bl).forEach(l),Pd=o(e),m(vl.$$.fragment,e),Ud=o(e),Ml=r(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-avw2a1"&&(Ml.textContent=Kp),Rd=o(e),xl=r(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-16q99cu"&&(xl.innerHTML=Bp),Ed=o(e),Cl=r(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-zy0eig"&&(Cl.innerHTML=Np),jd=o(e),Jd=r(e,"HR",{}),kd=o(e),Hl=r(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),Dd=o(e),m(Ll.$$.fragment,e),qd=o(e),wl=r(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-167n5bd"&&(wl.textContent=Vp),Id=o(e),Al=r(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-1pz529g"&&(Al.innerHTML=Qp),Kd=o(e),gl=r(e,"TABLE",{"data-svelte-h":!0}),d(gl)!=="svelte-1oyadc3"&&(gl.innerHTML=Sp),Bd=o(e),Nd=r(e,"HR",{}),Vd=o(e),zl=r(e,"A",{id:!0,class:!0}),h(zl).forEach(l),Qd=o(e),m(Pl.$$.fragment,e),Sd=o(e),Ul=r(e,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-fju8tm"&&(Ul.textContent=Op),Od=o(e),Rl=r(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-13s6o0v"&&(Rl.innerHTML=Wp),Wd=o(e),El=r(e,"TABLE",{"data-svelte-h":!0}),d(El)!=="svelte-8i278m"&&(El.innerHTML=Yp),Yd=o(e),Fd=r(e,"HR",{}),Gd=o(e),jl=r(e,"A",{id:!0,class:!0}),h(jl).forEach(l),Zd=o(e),m(Jl.$$.fragment,e),Xd=o(e),kl=r(e,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-11ei68w"&&(kl.textContent=Fp),eu=o(e),Dl=r(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1p3llh"&&(Dl.innerHTML=Gp),tu=o(e),ql=r(e,"TABLE",{"data-svelte-h":!0}),d(ql)!=="svelte-1xe0vb8"&&(ql.innerHTML=Zp),lu=o(e),su=r(e,"HR",{}),nu=o(e),Il=r(e,"A",{id:!0,class:!0}),h(Il).forEach(l),ou=o(e),m(Kl.$$.fragment,e),iu=o(e),Bl=r(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-7ivim4"&&(Bl.textContent=Xp),ru=o(e),Nl=r(e,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-151n4qz"&&(Nl.innerHTML=ec),du=o(e),Vl=r(e,"TABLE",{"data-svelte-h":!0}),d(Vl)!=="svelte-iprxta"&&(Vl.innerHTML=tc),uu=o(e),au=r(e,"HR",{}),mu=o(e),Ql=r(e,"A",{id:!0,class:!0}),h(Ql).forEach(l),pu=o(e),m(Sl.$$.fragment,e),cu=o(e),Ol=r(e,"P",{"data-svelte-h":!0}),d(Ol)!=="svelte-k6p1db"&&(Ol.textContent=lc),fu=o(e),Wl=r(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-1o30xnd"&&(Wl.innerHTML=sc),Tu=o(e),Yl=r(e,"TABLE",{"data-svelte-h":!0}),d(Yl)!=="svelte-101obk2"&&(Yl.innerHTML=nc),hu=o(e),_u=r(e,"HR",{}),$u=o(e),Fl=r(e,"A",{id:!0,class:!0}),h(Fl).forEach(l),yu=o(e),m(Gl.$$.fragment,e),bu=o(e),Zl=r(e,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-8afo9v"&&(Zl.textContent=oc),vu=o(e),Xl=r(e,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-1vvmhgz"&&(Xl.innerHTML=ic),Mu=o(e),es=r(e,"TABLE",{"data-svelte-h":!0}),d(es)!=="svelte-wz2jkw"&&(es.innerHTML=rc),xu=o(e),Cu=r(e,"HR",{}),Hu=o(e),ts=r(e,"A",{id:!0,class:!0}),h(ts).forEach(l),Lu=o(e),m(ls.$$.fragment,e),wu=o(e),ss=r(e,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-11plveb"&&(ss.innerHTML=dc),Au=o(e),ns=r(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1wu8g4g"&&(ns.innerHTML=uc),gu=o(e),os=r(e,"TABLE",{"data-svelte-h":!0}),d(os)!=="svelte-1vsvca3"&&(os.innerHTML=ac),zu=o(e),Pu=r(e,"HR",{}),Uu=o(e),is=r(e,"A",{id:!0,class:!0}),h(is).forEach(l),Ru=o(e),m(rs.$$.fragment,e),Eu=o(e),ds=r(e,"P",{"data-svelte-h":!0}),d(ds)!=="svelte-17f4oxi"&&(ds.textContent=mc),ju=o(e),us=r(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1lh8r1a"&&(us.innerHTML=pc),Ju=o(e),as=r(e,"TABLE",{"data-svelte-h":!0}),d(as)!=="svelte-m4z8c4"&&(as.innerHTML=cc),ku=o(e),Du=r(e,"HR",{}),qu=o(e),ms=r(e,"A",{id:!0,class:!0}),h(ms).forEach(l),Iu=o(e),m(ps.$$.fragment,e),Ku=o(e),cs=r(e,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-kcewlk"&&(cs.textContent=fc),Bu=o(e),fs=r(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-17f480h"&&(fs.innerHTML=Tc),Nu=o(e),Ts=r(e,"TABLE",{"data-svelte-h":!0}),d(Ts)!=="svelte-1to7jw8"&&(Ts.innerHTML=hc),Vu=o(e),Qu=r(e,"HR",{}),Su=o(e),hs=r(e,"A",{id:!0,class:!0}),h(hs).forEach(l),Ou=o(e),m(_s.$$.fragment,e),Wu=o(e),$s=r(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-1ayje0f"&&($s.textContent=_c),Yu=o(e),ys=r(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-17f480h"&&(ys.innerHTML=$c),Fu=o(e),bs=r(e,"TABLE",{"data-svelte-h":!0}),d(bs)!=="svelte-gyxne1"&&(bs.innerHTML=yc),Gu=o(e),Zu=r(e,"HR",{}),Xu=o(e),vs=r(e,"A",{id:!0,class:!0}),h(vs).forEach(l),ea=o(e),m(Ms.$$.fragment,e),ta=o(e),xs=r(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-1wvb8sq"&&(xs.textContent=bc),la=o(e),Cs=r(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-154yhp4"&&(Cs.innerHTML=vc),sa=o(e),Hs=r(e,"TABLE",{"data-svelte-h":!0}),d(Hs)!=="svelte-1fk5fng"&&(Hs.innerHTML=Mc),na=o(e),oa=r(e,"HR",{}),ia=o(e),Ls=r(e,"A",{id:!0,class:!0}),h(Ls).forEach(l),ra=o(e),m(ws.$$.fragment,e),da=o(e),As=r(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-185sm1b"&&(As.textContent=xc),ua=o(e),gs=r(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-1y8qzzr"&&(gs.innerHTML=Cc),aa=o(e),zs=r(e,"TABLE",{"data-svelte-h":!0}),d(zs)!=="svelte-1v01t7k"&&(zs.innerHTML=Hc),ma=o(e),pa=r(e,"HR",{}),ca=o(e),Ps=r(e,"A",{id:!0,class:!0}),h(Ps).forEach(l),fa=o(e),m(Us.$$.fragment,e),Ta=o(e),Rs=r(e,"P",{"data-svelte-h":!0}),d(Rs)!=="svelte-12loz97"&&(Rs.innerHTML=Lc),ha=o(e),_a=r(e,"HR",{}),$a=o(e),Es=r(e,"A",{id:!0,class:!0}),h(Es).forEach(l),ya=o(e),m(js.$$.fragment,e),ba=o(e),Js=r(e,"P",{"data-svelte-h":!0}),d(Js)!=="svelte-12loz97"&&(Js.innerHTML=wc),va=o(e),Ma=r(e,"HR",{}),xa=o(e),ks=r(e,"A",{id:!0,class:!0}),h(ks).forEach(l),Ca=o(e),m(Ds.$$.fragment,e),Ha=o(e),qs=r(e,"P",{"data-svelte-h":!0}),d(qs)!=="svelte-40isdg"&&(qs.textContent=Ac),La=o(e),Is=r(e,"P",{"data-svelte-h":!0}),d(Is)!=="svelte-tlsa2h"&&(Is.innerHTML=gc),wa=o(e),Ks=r(e,"TABLE",{"data-svelte-h":!0}),d(Ks)!=="svelte-17343p6"&&(Ks.innerHTML=zc),Aa=o(e),Bs=r(e,"P",{"data-svelte-h":!0}),d(Bs)!=="svelte-1aswmub"&&(Bs.innerHTML=Pc),ga=o(e),m(Ns.$$.fragment,e),za=o(e),Pa=r(e,"HR",{}),Ua=o(e),Vs=r(e,"A",{id:!0,class:!0}),h(Vs).forEach(l),Ra=o(e),m(Qs.$$.fragment,e),Ea=o(e),Ss=r(e,"P",{"data-svelte-h":!0}),d(Ss)!=="svelte-kp31r8"&&(Ss.innerHTML=Uc),ja=o(e),Ja=r(e,"HR",{}),ka=o(e),Os=r(e,"A",{id:!0,class:!0}),h(Os).forEach(l),Da=o(e),m(Ws.$$.fragment,e),qa=o(e),Ys=r(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-1fs9no9"&&(Ys.innerHTML=Rc),Ia=o(e),Ka=r(e,"HR",{}),Ba=o(e),Fs=r(e,"A",{id:!0,class:!0}),h(Fs).forEach(l),Na=o(e),m(Gs.$$.fragment,e),Va=o(e),Zs=r(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-2mif9c"&&(Zs.textContent=Ec),Qa=o(e),Xs=r(e,"P",{"data-svelte-h":!0}),d(Xs)!=="svelte-1jas2kw"&&(Xs.innerHTML=jc),Sa=o(e),m(en.$$.fragment,e),Oa=o(e),tn=r(e,"P",{"data-svelte-h":!0}),d(tn)!=="svelte-1aswmub"&&(tn.innerHTML=Jc),Wa=o(e),m(ln.$$.fragment,e),Ya=o(e),sn=r(e,"P",{"data-svelte-h":!0}),d(sn)!=="svelte-1aswmub"&&(sn.innerHTML=kc),Fa=o(e),m(nn.$$.fragment,e),Ga=o(e),Za=r(e,"HR",{}),Xa=o(e),m(on.$$.fragment,e),em=o(e),dn=r(e,"P",{}),h(dn).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",Oc),u(y,"id","module_utils/tensor"),u(y,"class","group"),u(C,"id","module_utils/tensor.Tensor"),u(C,"class","group"),u(A,"id","new_module_utils/tensor.Tensor_new"),u(A,"class","group"),u(U,"id","module_utils/tensor.Tensor+dims"),u(U,"class","group"),u(J,"id","module_utils/tensor.Tensor+type"),u(J,"class","group"),u(I,"id","module_utils/tensor.Tensor+data"),u(I,"class","group"),u(V,"id","module_utils/tensor.Tensor+size"),u(V,"class","group"),u(W,"id","module_utils/tensor.Tensor+Symbol.iterator"),u(W,"class","group"),u(Z,"id","module_utils/tensor.Tensor+_getitem"),u(Z,"class","group"),u(se,"id","module_utils/tensor.Tensor+indexOf"),u(se,"class","group"),u(re,"id","module_utils/tensor.Tensor+_subarray"),u(re,"class","group"),u(me,"id","module_utils/tensor.Tensor+item"),u(me,"class","group"),u(he,"id","module_utils/tensor.Tensor+tolist"),u(he,"class","group"),u(be,"id","module_utils/tensor.Tensor+sigmoid"),u(be,"class","group"),u(Ce,"id","module_utils/tensor.Tensor+sigmoid_"),u(Ce,"class","group"),u(Ae,"id","module_utils/tensor.Tensor+mul"),u(Ae,"class","group"),u(Re,"id","module_utils/tensor.Tensor+mul_"),u(Re,"class","group"),u(De,"id","module_utils/tensor.Tensor+add"),u(De,"class","group"),u(Ne,"id","module_utils/tensor.Tensor+add_"),u(Ne,"class","group"),u(We,"id","module_utils/tensor.Tensor+permute"),u(We,"class","group"),u(Xe,"id","module_utils/tensor.Tensor+sum"),u(Xe,"class","group"),u(nt,"id","module_utils/tensor.Tensor+norm"),u(nt,"class","group"),u(ut,"id","module_utils/tensor.Tensor+normalize_"),u(ut,"class","group"),u(ft,"id","module_utils/tensor.Tensor+normalize"),u(ft,"class","group"),u(yt,"id","module_utils/tensor.Tensor+stride"),u(yt,"class","group"),u(xt,"id","module_utils/tensor.Tensor+squeeze"),u(xt,"class","group"),u(gt,"id","module_utils/tensor.Tensor+squeeze_"),u(gt,"class","group"),u(Rt,"id","module_utils/tensor.Tensor+unsqueeze"),u(Rt,"class","group"),u(qt,"id","module_utils/tensor.Tensor+unsqueeze_"),u(qt,"class","group"),u(Nt,"id","module_utils/tensor.Tensor+flatten_"),u(Nt,"class","group"),u(Ot,"id","module_utils/tensor.Tensor+flatten"),u(Ot,"class","group"),u(Zt,"id","module_utils/tensor.Tensor+view"),u(Zt,"class","group"),u(sl,"id","module_utils/tensor.Tensor+clamp_"),u(sl,"class","group"),u(rl,"id","module_utils/tensor.Tensor+clamp"),u(rl,"class","group"),u(pl,"id","module_utils/tensor.Tensor+round_"),u(pl,"class","group"),u(hl,"id","module_utils/tensor.Tensor+round"),u(hl,"class","group"),u(bl,"id","module_utils/tensor.Tensor+to"),u(bl,"class","group"),u(Hl,"id","module_utils/tensor.permute"),u(Hl,"class","group"),u(zl,"id","module_utils/tensor.interpolate"),u(zl,"class","group"),u(jl,"id","module_utils/tensor.mean_pooling"),u(jl,"class","group"),u(Il,"id","module_utils/tensor.layer_norm"),u(Il,"class","group"),u(Ql,"id","module_utils/tensor.cat"),u(Ql,"class","group"),u(Fl,"id","module_utils/tensor.stack"),u(Fl,"class","group"),u(ts,"id","module_utils/tensor.std_mean"),u(ts,"class","group"),u(is,"id","module_utils/tensor.mean"),u(is,"class","group"),u(ms,"id","module_utils/tensor.dynamicTimeWarping"),u(ms,"class","group"),u(hs,"id","module_utils/tensor.ones"),u(hs,"class","group"),u(vs,"id","module_utils/tensor.ones_like"),u(vs,"class","group"),u(Ls,"id","module_utils/tensor.quantize_embeddings"),u(Ls,"class","group"),u(Ps,"id","module_utils/tensor..args[0]"),u(Ps,"class","group"),u(Es,"id","module_utils/tensor..args[1]"),u(Es,"class","group"),u(ks,"id","module_utils/tensor..reshape"),u(ks,"class","group"),u(Vs,"id","module_utils/tensor..reshape..reshapedArray"),u(Vs,"class","group"),u(Os,"id","module_utils/tensor..DataArray"),u(Os,"class","group"),u(Fs,"id","module_utils/tensor..NestArray"),u(Fs,"class","group")},m(e,t){Vc(document.head,$),s(e,un,t),s(e,rn,t),s(e,an,t),s(e,y,t),s(e,mn,t),p(b,e,t),s(e,pn,t),s(e,v,t),s(e,cn,t),s(e,M,t),s(e,fn,t),s(e,x,t),s(e,Tn,t),s(e,hn,t),s(e,_n,t),s(e,C,t),s(e,$n,t),p(H,e,t),s(e,yn,t),s(e,L,t),s(e,bn,t),s(e,w,t),s(e,vn,t),s(e,Mn,t),s(e,xn,t),s(e,A,t),s(e,Cn,t),p(g,e,t),s(e,Hn,t),s(e,z,t),s(e,Ln,t),s(e,P,t),s(e,wn,t),s(e,An,t),s(e,gn,t),s(e,U,t),s(e,zn,t),p(R,e,t),s(e,Pn,t),s(e,E,t),s(e,Un,t),s(e,j,t),s(e,Rn,t),s(e,En,t),s(e,jn,t),s(e,J,t),s(e,Jn,t),p(k,e,t),s(e,kn,t),s(e,D,t),s(e,Dn,t),s(e,q,t),s(e,qn,t),s(e,In,t),s(e,Kn,t),s(e,I,t),s(e,Bn,t),p(K,e,t),s(e,Nn,t),s(e,B,t),s(e,Vn,t),s(e,N,t),s(e,Qn,t),s(e,Sn,t),s(e,On,t),s(e,V,t),s(e,Wn,t),p(Q,e,t),s(e,Yn,t),s(e,S,t),s(e,Fn,t),s(e,O,t),s(e,Gn,t),s(e,Zn,t),s(e,Xn,t),s(e,W,t),s(e,eo,t),p(Y,e,t),s(e,to,t),s(e,F,t),s(e,lo,t),s(e,G,t),s(e,so,t),s(e,no,t),s(e,oo,t),s(e,Z,t),s(e,io,t),p(X,e,t),s(e,ro,t),s(e,ee,t),s(e,uo,t),s(e,te,t),s(e,ao,t),s(e,le,t),s(e,mo,t),s(e,po,t),s(e,co,t),s(e,se,t),s(e,fo,t),p(ne,e,t),s(e,To,t),s(e,oe,t),s(e,ho,t),s(e,ie,t),s(e,_o,t),s(e,$o,t),s(e,yo,t),s(e,re,t),s(e,bo,t),p(de,e,t),s(e,vo,t),s(e,ue,t),s(e,Mo,t),s(e,ae,t),s(e,xo,t),s(e,Co,t),s(e,Ho,t),s(e,me,t),s(e,Lo,t),p(pe,e,t),s(e,wo,t),s(e,ce,t),s(e,Ao,t),s(e,fe,t),s(e,go,t),s(e,Te,t),s(e,zo,t),s(e,Po,t),s(e,Uo,t),s(e,he,t),s(e,Ro,t),p(_e,e,t),s(e,Eo,t),s(e,$e,t),s(e,jo,t),s(e,ye,t),s(e,Jo,t),s(e,ko,t),s(e,Do,t),s(e,be,t),s(e,qo,t),p(ve,e,t),s(e,Io,t),s(e,Me,t),s(e,Ko,t),s(e,xe,t),s(e,Bo,t),s(e,No,t),s(e,Vo,t),s(e,Ce,t),s(e,Qo,t),p(He,e,t),s(e,So,t),s(e,Le,t),s(e,Oo,t),s(e,we,t),s(e,Wo,t),s(e,Yo,t),s(e,Fo,t),s(e,Ae,t),s(e,Go,t),p(ge,e,t),s(e,Zo,t),s(e,ze,t),s(e,Xo,t),s(e,Pe,t),s(e,ei,t),s(e,Ue,t),s(e,ti,t),s(e,li,t),s(e,si,t),s(e,Re,t),s(e,ni,t),p(Ee,e,t),s(e,oi,t),s(e,je,t),s(e,ii,t),s(e,Je,t),s(e,ri,t),s(e,ke,t),s(e,di,t),s(e,ui,t),s(e,ai,t),s(e,De,t),s(e,mi,t),p(qe,e,t),s(e,pi,t),s(e,Ie,t),s(e,ci,t),s(e,Ke,t),s(e,fi,t),s(e,Be,t),s(e,Ti,t),s(e,hi,t),s(e,_i,t),s(e,Ne,t),s(e,$i,t),p(Ve,e,t),s(e,yi,t),s(e,Qe,t),s(e,bi,t),s(e,Se,t),s(e,vi,t),s(e,Oe,t),s(e,Mi,t),s(e,xi,t),s(e,Ci,t),s(e,We,t),s(e,Hi,t),p(Ye,e,t),s(e,Li,t),s(e,Fe,t),s(e,wi,t),s(e,Ge,t),s(e,Ai,t),s(e,Ze,t),s(e,gi,t),s(e,zi,t),s(e,Pi,t),s(e,Xe,t),s(e,Ui,t),p(et,e,t),s(e,Ri,t),s(e,tt,t),s(e,Ei,t),s(e,lt,t),s(e,ji,t),s(e,st,t),s(e,Ji,t),s(e,ki,t),s(e,Di,t),s(e,nt,t),s(e,qi,t),p(ot,e,t),s(e,Ii,t),s(e,it,t),s(e,Ki,t),s(e,rt,t),s(e,Bi,t),s(e,dt,t),s(e,Ni,t),s(e,Vi,t),s(e,Qi,t),s(e,ut,t),s(e,Si,t),p(at,e,t),s(e,Oi,t),s(e,mt,t),s(e,Wi,t),s(e,pt,t),s(e,Yi,t),s(e,ct,t),s(e,Fi,t),s(e,Gi,t),s(e,Zi,t),s(e,ft,t),s(e,Xi,t),p(Tt,e,t),s(e,er,t),s(e,ht,t),s(e,tr,t),s(e,_t,t),s(e,lr,t),s(e,$t,t),s(e,sr,t),s(e,nr,t),s(e,or,t),s(e,yt,t),s(e,ir,t),p(bt,e,t),s(e,rr,t),s(e,vt,t),s(e,dr,t),s(e,Mt,t),s(e,ur,t),s(e,ar,t),s(e,mr,t),s(e,xt,t),s(e,pr,t),p(Ct,e,t),s(e,cr,t),s(e,Ht,t),s(e,fr,t),s(e,Lt,t),s(e,Tr,t),s(e,wt,t),s(e,hr,t),s(e,At,t),s(e,_r,t),s(e,$r,t),s(e,yr,t),s(e,gt,t),s(e,br,t),p(zt,e,t),s(e,vr,t),s(e,Pt,t),s(e,Mr,t),s(e,Ut,t),s(e,xr,t),s(e,Cr,t),s(e,Hr,t),s(e,Rt,t),s(e,Lr,t),p(Et,e,t),s(e,wr,t),s(e,jt,t),s(e,Ar,t),s(e,Jt,t),s(e,gr,t),s(e,kt,t),s(e,zr,t),s(e,Dt,t),s(e,Pr,t),s(e,Ur,t),s(e,Rr,t),s(e,qt,t),s(e,Er,t),p(It,e,t),s(e,jr,t),s(e,Kt,t),s(e,Jr,t),s(e,Bt,t),s(e,kr,t),s(e,Dr,t),s(e,qr,t),s(e,Nt,t),s(e,Ir,t),p(Vt,e,t),s(e,Kr,t),s(e,Qt,t),s(e,Br,t),s(e,St,t),s(e,Nr,t),s(e,Vr,t),s(e,Qr,t),s(e,Ot,t),s(e,Sr,t),p(Wt,e,t),s(e,Or,t),s(e,Yt,t),s(e,Wr,t),s(e,Ft,t),s(e,Yr,t),s(e,Gt,t),s(e,Fr,t),s(e,Gr,t),s(e,Zr,t),s(e,Zt,t),s(e,Xr,t),p(Xt,e,t),s(e,ed,t),s(e,el,t),s(e,td,t),s(e,tl,t),s(e,ld,t),s(e,ll,t),s(e,sd,t),s(e,nd,t),s(e,od,t),s(e,sl,t),s(e,id,t),p(nl,e,t),s(e,rd,t),s(e,ol,t),s(e,dd,t),s(e,il,t),s(e,ud,t),s(e,ad,t),s(e,md,t),s(e,rl,t),s(e,pd,t),p(dl,e,t),s(e,cd,t),s(e,ul,t),s(e,fd,t),s(e,al,t),s(e,Td,t),s(e,ml,t),s(e,hd,t),s(e,_d,t),s(e,$d,t),s(e,pl,t),s(e,yd,t),p(cl,e,t),s(e,bd,t),s(e,fl,t),s(e,vd,t),s(e,Tl,t),s(e,Md,t),s(e,xd,t),s(e,Cd,t),s(e,hl,t),s(e,Hd,t),p(_l,e,t),s(e,Ld,t),s(e,$l,t),s(e,wd,t),s(e,yl,t),s(e,Ad,t),s(e,gd,t),s(e,zd,t),s(e,bl,t),s(e,Pd,t),p(vl,e,t),s(e,Ud,t),s(e,Ml,t),s(e,Rd,t),s(e,xl,t),s(e,Ed,t),s(e,Cl,t),s(e,jd,t),s(e,Jd,t),s(e,kd,t),s(e,Hl,t),s(e,Dd,t),p(Ll,e,t),s(e,qd,t),s(e,wl,t),s(e,Id,t),s(e,Al,t),s(e,Kd,t),s(e,gl,t),s(e,Bd,t),s(e,Nd,t),s(e,Vd,t),s(e,zl,t),s(e,Qd,t),p(Pl,e,t),s(e,Sd,t),s(e,Ul,t),s(e,Od,t),s(e,Rl,t),s(e,Wd,t),s(e,El,t),s(e,Yd,t),s(e,Fd,t),s(e,Gd,t),s(e,jl,t),s(e,Zd,t),p(Jl,e,t),s(e,Xd,t),s(e,kl,t),s(e,eu,t),s(e,Dl,t),s(e,tu,t),s(e,ql,t),s(e,lu,t),s(e,su,t),s(e,nu,t),s(e,Il,t),s(e,ou,t),p(Kl,e,t),s(e,iu,t),s(e,Bl,t),s(e,ru,t),s(e,Nl,t),s(e,du,t),s(e,Vl,t),s(e,uu,t),s(e,au,t),s(e,mu,t),s(e,Ql,t),s(e,pu,t),p(Sl,e,t),s(e,cu,t),s(e,Ol,t),s(e,fu,t),s(e,Wl,t),s(e,Tu,t),s(e,Yl,t),s(e,hu,t),s(e,_u,t),s(e,$u,t),s(e,Fl,t),s(e,yu,t),p(Gl,e,t),s(e,bu,t),s(e,Zl,t),s(e,vu,t),s(e,Xl,t),s(e,Mu,t),s(e,es,t),s(e,xu,t),s(e,Cu,t),s(e,Hu,t),s(e,ts,t),s(e,Lu,t),p(ls,e,t),s(e,wu,t),s(e,ss,t),s(e,Au,t),s(e,ns,t),s(e,gu,t),s(e,os,t),s(e,zu,t),s(e,Pu,t),s(e,Uu,t),s(e,is,t),s(e,Ru,t),p(rs,e,t),s(e,Eu,t),s(e,ds,t),s(e,ju,t),s(e,us,t),s(e,Ju,t),s(e,as,t),s(e,ku,t),s(e,Du,t),s(e,qu,t),s(e,ms,t),s(e,Iu,t),p(ps,e,t),s(e,Ku,t),s(e,cs,t),s(e,Bu,t),s(e,fs,t),s(e,Nu,t),s(e,Ts,t),s(e,Vu,t),s(e,Qu,t),s(e,Su,t),s(e,hs,t),s(e,Ou,t),p(_s,e,t),s(e,Wu,t),s(e,$s,t),s(e,Yu,t),s(e,ys,t),s(e,Fu,t),s(e,bs,t),s(e,Gu,t),s(e,Zu,t),s(e,Xu,t),s(e,vs,t),s(e,ea,t),p(Ms,e,t),s(e,ta,t),s(e,xs,t),s(e,la,t),s(e,Cs,t),s(e,sa,t),s(e,Hs,t),s(e,na,t),s(e,oa,t),s(e,ia,t),s(e,Ls,t),s(e,ra,t),p(ws,e,t),s(e,da,t),s(e,As,t),s(e,ua,t),s(e,gs,t),s(e,aa,t),s(e,zs,t),s(e,ma,t),s(e,pa,t),s(e,ca,t),s(e,Ps,t),s(e,fa,t),p(Us,e,t),s(e,Ta,t),s(e,Rs,t),s(e,ha,t),s(e,_a,t),s(e,$a,t),s(e,Es,t),s(e,ya,t),p(js,e,t),s(e,ba,t),s(e,Js,t),s(e,va,t),s(e,Ma,t),s(e,xa,t),s(e,ks,t),s(e,Ca,t),p(Ds,e,t),s(e,Ha,t),s(e,qs,t),s(e,La,t),s(e,Is,t),s(e,wa,t),s(e,Ks,t),s(e,Aa,t),s(e,Bs,t),s(e,ga,t),p(Ns,e,t),s(e,za,t),s(e,Pa,t),s(e,Ua,t),s(e,Vs,t),s(e,Ra,t),p(Qs,e,t),s(e,Ea,t),s(e,Ss,t),s(e,ja,t),s(e,Ja,t),s(e,ka,t),s(e,Os,t),s(e,Da,t),p(Ws,e,t),s(e,qa,t),s(e,Ys,t),s(e,Ia,t),s(e,Ka,t),s(e,Ba,t),s(e,Fs,t),s(e,Na,t),p(Gs,e,t),s(e,Va,t),s(e,Zs,t),s(e,Qa,t),s(e,Xs,t),s(e,Sa,t),p(en,e,t),s(e,Oa,t),s(e,tn,t),s(e,Wa,t),p(ln,e,t),s(e,Ya,t),s(e,sn,t),s(e,Fa,t),p(nn,e,t),s(e,Ga,t),s(e,Za,t),s(e,Xa,t),p(on,e,t),s(e,em,t),s(e,dn,t),tm=!0},p:qc,i(e){tm||(c(b.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(R.$$.fragment,e),c(k.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(Y.$$.fragment,e),c(X.$$.fragment,e),c(ne.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(_e.$$.fragment,e),c(ve.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(Ee.$$.fragment,e),c(qe.$$.fragment,e),c(Ve.$$.fragment,e),c(Ye.$$.fragment,e),c(et.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(Tt.$$.fragment,e),c(bt.$$.fragment,e),c(Ct.$$.fragment,e),c(zt.$$.fragment,e),c(Et.$$.fragment,e),c(It.$$.fragment,e),c(Vt.$$.fragment,e),c(Wt.$$.fragment,e),c(Xt.$$.fragment,e),c(nl.$$.fragment,e),c(dl.$$.fragment,e),c(cl.$$.fragment,e),c(_l.$$.fragment,e),c(vl.$$.fragment,e),c(Ll.$$.fragment,e),c(Pl.$$.fragment,e),c(Jl.$$.fragment,e),c(Kl.$$.fragment,e),c(Sl.$$.fragment,e),c(Gl.$$.fragment,e),c(ls.$$.fragment,e),c(rs.$$.fragment,e),c(ps.$$.fragment,e),c(_s.$$.fragment,e),c(Ms.$$.fragment,e),c(ws.$$.fragment,e),c(Us.$$.fragment,e),c(js.$$.fragment,e),c(Ds.$$.fragment,e),c(Ns.$$.fragment,e),c(Qs.$$.fragment,e),c(Ws.$$.fragment,e),c(Gs.$$.fragment,e),c(en.$$.fragment,e),c(ln.$$.fragment,e),c(nn.$$.fragment,e),c(on.$$.fragment,e),tm=!0)},o(e){f(b.$$.fragment,e),f(H.$$.fragment,e),f(g.$$.fragment,e),f(R.$$.fragment,e),f(k.$$.fragment,e),f(K.$$.fragment,e),f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(X.$$.fragment,e),f(ne.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(_e.$$.fragment,e),f(ve.$$.fragment,e),f(He.$$.fragment,e),f(ge.$$.fragment,e),f(Ee.$$.fragment,e),f(qe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ye.$$.fragment,e),f(et.$$.fragment,e),f(ot.$$.fragment,e),f(at.$$.fragment,e),f(Tt.$$.fragment,e),f(bt.$$.fragment,e),f(Ct.$$.fragment,e),f(zt.$$.fragment,e),f(Et.$$.fragment,e),f(It.$$.fragment,e),f(Vt.$$.fragment,e),f(Wt.$$.fragment,e),f(Xt.$$.fragment,e),f(nl.$$.fragment,e),f(dl.$$.fragment,e),f(cl.$$.fragment,e),f(_l.$$.fragment,e),f(vl.$$.fragment,e),f(Ll.$$.fragment,e),f(Pl.$$.fragment,e),f(Jl.$$.fragment,e),f(Kl.$$.fragment,e),f(Sl.$$.fragment,e),f(Gl.$$.fragment,e),f(ls.$$.fragment,e),f(rs.$$.fragment,e),f(ps.$$.fragment,e),f(_s.$$.fragment,e),f(Ms.$$.fragment,e),f(ws.$$.fragment,e),f(Us.$$.fragment,e),f(js.$$.fragment,e),f(Ds.$$.fragment,e),f(Ns.$$.fragment,e),f(Qs.$$.fragment,e),f(Ws.$$.fragment,e),f(Gs.$$.fragment,e),f(en.$$.fragment,e),f(ln.$$.fragment,e),f(nn.$$.fragment,e),f(on.$$.fragment,e),tm=!1},d(e){e&&(l(un),l(rn),l(an),l(y),l(mn),l(pn),l(v),l(cn),l(M),l(fn),l(x),l(Tn),l(hn),l(_n),l(C),l($n),l(yn),l(L),l(bn),l(w),l(vn),l(Mn),l(xn),l(A),l(Cn),l(Hn),l(z),l(Ln),l(P),l(wn),l(An),l(gn),l(U),l(zn),l(Pn),l(E),l(Un),l(j),l(Rn),l(En),l(jn),l(J),l(Jn),l(kn),l(D),l(Dn),l(q),l(qn),l(In),l(Kn),l(I),l(Bn),l(Nn),l(B),l(Vn),l(N),l(Qn),l(Sn),l(On),l(V),l(Wn),l(Yn),l(S),l(Fn),l(O),l(Gn),l(Zn),l(Xn),l(W),l(eo),l(to),l(F),l(lo),l(G),l(so),l(no),l(oo),l(Z),l(io),l(ro),l(ee),l(uo),l(te),l(ao),l(le),l(mo),l(po),l(co),l(se),l(fo),l(To),l(oe),l(ho),l(ie),l(_o),l($o),l(yo),l(re),l(bo),l(vo),l(ue),l(Mo),l(ae),l(xo),l(Co),l(Ho),l(me),l(Lo),l(wo),l(ce),l(Ao),l(fe),l(go),l(Te),l(zo),l(Po),l(Uo),l(he),l(Ro),l(Eo),l($e),l(jo),l(ye),l(Jo),l(ko),l(Do),l(be),l(qo),l(Io),l(Me),l(Ko),l(xe),l(Bo),l(No),l(Vo),l(Ce),l(Qo),l(So),l(Le),l(Oo),l(we),l(Wo),l(Yo),l(Fo),l(Ae),l(Go),l(Zo),l(ze),l(Xo),l(Pe),l(ei),l(Ue),l(ti),l(li),l(si),l(Re),l(ni),l(oi),l(je),l(ii),l(Je),l(ri),l(ke),l(di),l(ui),l(ai),l(De),l(mi),l(pi),l(Ie),l(ci),l(Ke),l(fi),l(Be),l(Ti),l(hi),l(_i),l(Ne),l($i),l(yi),l(Qe),l(bi),l(Se),l(vi),l(Oe),l(Mi),l(xi),l(Ci),l(We),l(Hi),l(Li),l(Fe),l(wi),l(Ge),l(Ai),l(Ze),l(gi),l(zi),l(Pi),l(Xe),l(Ui),l(Ri),l(tt),l(Ei),l(lt),l(ji),l(st),l(Ji),l(ki),l(Di),l(nt),l(qi),l(Ii),l(it),l(Ki),l(rt),l(Bi),l(dt),l(Ni),l(Vi),l(Qi),l(ut),l(Si),l(Oi),l(mt),l(Wi),l(pt),l(Yi),l(ct),l(Fi),l(Gi),l(Zi),l(ft),l(Xi),l(er),l(ht),l(tr),l(_t),l(lr),l($t),l(sr),l(nr),l(or),l(yt),l(ir),l(rr),l(vt),l(dr),l(Mt),l(ur),l(ar),l(mr),l(xt),l(pr),l(cr),l(Ht),l(fr),l(Lt),l(Tr),l(wt),l(hr),l(At),l(_r),l($r),l(yr),l(gt),l(br),l(vr),l(Pt),l(Mr),l(Ut),l(xr),l(Cr),l(Hr),l(Rt),l(Lr),l(wr),l(jt),l(Ar),l(Jt),l(gr),l(kt),l(zr),l(Dt),l(Pr),l(Ur),l(Rr),l(qt),l(Er),l(jr),l(Kt),l(Jr),l(Bt),l(kr),l(Dr),l(qr),l(Nt),l(Ir),l(Kr),l(Qt),l(Br),l(St),l(Nr),l(Vr),l(Qr),l(Ot),l(Sr),l(Or),l(Yt),l(Wr),l(Ft),l(Yr),l(Gt),l(Fr),l(Gr),l(Zr),l(Zt),l(Xr),l(ed),l(el),l(td),l(tl),l(ld),l(ll),l(sd),l(nd),l(od),l(sl),l(id),l(rd),l(ol),l(dd),l(il),l(ud),l(ad),l(md),l(rl),l(pd),l(cd),l(ul),l(fd),l(al),l(Td),l(ml),l(hd),l(_d),l($d),l(pl),l(yd),l(bd),l(fl),l(vd),l(Tl),l(Md),l(xd),l(Cd),l(hl),l(Hd),l(Ld),l($l),l(wd),l(yl),l(Ad),l(gd),l(zd),l(bl),l(Pd),l(Ud),l(Ml),l(Rd),l(xl),l(Ed),l(Cl),l(jd),l(Jd),l(kd),l(Hl),l(Dd),l(qd),l(wl),l(Id),l(Al),l(Kd),l(gl),l(Bd),l(Nd),l(Vd),l(zl),l(Qd),l(Sd),l(Ul),l(Od),l(Rl),l(Wd),l(El),l(Yd),l(Fd),l(Gd),l(jl),l(Zd),l(Xd),l(kl),l(eu),l(Dl),l(tu),l(ql),l(lu),l(su),l(nu),l(Il),l(ou),l(iu),l(Bl),l(ru),l(Nl),l(du),l(Vl),l(uu),l(au),l(mu),l(Ql),l(pu),l(cu),l(Ol),l(fu),l(Wl),l(Tu),l(Yl),l(hu),l(_u),l($u),l(Fl),l(yu),l(bu),l(Zl),l(vu),l(Xl),l(Mu),l(es),l(xu),l(Cu),l(Hu),l(ts),l(Lu),l(wu),l(ss),l(Au),l(ns),l(gu),l(os),l(zu),l(Pu),l(Uu),l(is),l(Ru),l(Eu),l(ds),l(ju),l(us),l(Ju),l(as),l(ku),l(Du),l(qu),l(ms),l(Iu),l(Ku),l(cs),l(Bu),l(fs),l(Nu),l(Ts),l(Vu),l(Qu),l(Su),l(hs),l(Ou),l(Wu),l($s),l(Yu),l(ys),l(Fu),l(bs),l(Gu),l(Zu),l(Xu),l(vs),l(ea),l(ta),l(xs),l(la),l(Cs),l(sa),l(Hs),l(na),l(oa),l(ia),l(Ls),l(ra),l(da),l(As),l(ua),l(gs),l(aa),l(zs),l(ma),l(pa),l(ca),l(Ps),l(fa),l(Ta),l(Rs),l(ha),l(_a),l($a),l(Es),l(ya),l(ba),l(Js),l(va),l(Ma),l(xa),l(ks),l(Ca),l(Ha),l(qs),l(La),l(Is),l(wa),l(Ks),l(Aa),l(Bs),l(ga),l(za),l(Pa),l(Ua),l(Vs),l(Ra),l(Ea),l(Ss),l(ja),l(Ja),l(ka),l(Os),l(Da),l(qa),l(Ys),l(Ia),l(Ka),l(Ba),l(Fs),l(Na),l(Va),l(Zs),l(Qa),l(Xs),l(Sa),l(Oa),l(tn),l(Wa),l(Ya),l(sn),l(Fa),l(Ga),l(Za),l(Xa),l(em),l(dn)),l($),T(b,e),T(H,e),T(g,e),T(R,e),T(k,e),T(K,e),T(Q,e),T(Y,e),T(X,e),T(ne,e),T(de,e),T(pe,e),T(_e,e),T(ve,e),T(He,e),T(ge,e),T(Ee,e),T(qe,e),T(Ve,e),T(Ye,e),T(et,e),T(ot,e),T(at,e),T(Tt,e),T(bt,e),T(Ct,e),T(zt,e),T(Et,e),T(It,e),T(Vt,e),T(Wt,e),T(Xt,e),T(nl,e),T(dl,e),T(cl,e),T(_l,e),T(vl,e),T(Ll,e),T(Pl,e),T(Jl,e),T(Kl,e),T(Sl,e),T(Gl,e),T(ls,e),T(rs,e),T(ps,e),T(_s,e),T(Ms,e),T(ws,e),T(Us,e),T(js,e),T(Ds,e),T(Ns,e),T(Qs,e),T(Ws,e),T(Gs,e),T(en,e),T(ln,e),T(nn,e),T(on,e)}}}const Oc='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒","local":"tensorsqueezedim-","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒","local":"tensorunsqueezedim-","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒","local":"tensorflattenstartdim-enddim-","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒","local":"tensorclampmin-max-","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒","local":"tensorround-","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒","local":"utilstensormeaninput-dim-keepdim-","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor.ones(size)","local":"utilstensoronessize","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒","local":"utilstensoronesliketensor-","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> DataType </code>","local":"utilstensorargs0--code-datatype-code","sections":[],"depth":2},{"title":"utils/tensor~args[1] : <code> * </code>","local":"utilstensorargs1--code--code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function Wc(sm){return Ic(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xc extends Kc{constructor($){super(),Bc(this,$,Wc,Sc,Dc,{})}}export{Xc as component};
