import{S as Bu,i as Wu,s as Uu,e as s,k as m,w as k,t as n,M as Ru,c as a,d as t,m as g,a as r,x as j,h as o,b as h,G as e,g as x,y as w,q as $,o as L,B as T,v as Hu,L as Fe}from"../../chunks/vendor-hf-doc-builder.js";import{T as et}from"../../chunks/Tip-hf-doc-builder.js";import{D as z}from"../../chunks/Docstring-hf-doc-builder.js";import{C as De}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as Pa}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as Pe}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function Vu(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import GenerationConfig

# Download configuration from huggingface.co and cache.
generation_config = GenerationConfig.from_pretrained("gpt2")

# E.g. config was saved using *save_pretrained('./test/saved_model/')*
generation_config.save_pretrained("./test/saved_model/")
generation_config = GenerationConfig.from_pretrained("./test/saved_model/")

# You can also specify configuration names to your generation configuration file
generation_config.save_pretrained("./test/saved_model/", config_file_name="my_configuration.json")
generation_config = GenerationConfig.from_pretrained("./test/saved_model/", "my_configuration.json")

# If you'd like to try a minor variation to an existing configuration, you can also pass generation
# arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored
generation_config, unused_kwargs = GenerationConfig.from_pretrained(
    "gpt2", top_k=1, foo=False, return_unused_kwargs=True
)
generation_config.top_k

unused_kwargs`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function Yu(M){let c,_,p,d,f,i,u,E,y,b,G,O,F,ie,I,J,N;return{c(){c=s("p"),_=n("Most generation-controlling parameters are set in "),p=s("code"),d=n("generation_config"),f=n(` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=s("code"),u=n("generation_config"),E=n(` by passing the corresponding
parameters to generate(), e.g. `),y=s("code"),b=n(".generate(inputs, num_beams=4, do_sample=True)"),G=n("."),O=m(),F=s("p"),ie=n("For an overview of generation strategies and code examples, check out the "),I=s("a"),J=n(`following
guide`),N=n("."),this.h()},l(C){c=a(C,"P",{});var q=r(c);_=o(q,"Most generation-controlling parameters are set in "),p=a(q,"CODE",{});var X=r(p);d=o(X,"generation_config"),X.forEach(t),f=o(q,` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=a(q,"CODE",{});var Ae=r(i);u=o(Ae,"generation_config"),Ae.forEach(t),E=o(q,` by passing the corresponding
parameters to generate(), e.g. `),y=a(q,"CODE",{});var ze=r(y);b=o(ze,".generate(inputs, num_beams=4, do_sample=True)"),ze.forEach(t),G=o(q,"."),q.forEach(t),O=g(C),F=a(C,"P",{});var R=r(F);ie=o(R,"For an overview of generation strategies and code examples, check out the "),I=a(R,"A",{href:!0});var Ne=r(I);J=o(Ne,`following
guide`),Ne.forEach(t),N=o(R,"."),R.forEach(t),this.h()},h(){h(I,"href","../generation_strategies")},m(C,q){x(C,c,q),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E),e(c,y),e(y,b),e(c,G),x(C,O,q),x(C,F,q),e(F,ie),e(F,I),e(I,J),e(F,N)},d(C){C&&t(c),C&&t(O),C&&t(F)}}}function Ku(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import GPT2Tokenizer, AutoModelForCausalLM
import numpy as np

tokenizer = GPT2Tokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")
tokenizer.pad_token_id = tokenizer.eos_token_id
inputs = tokenizer(["Today is"], return_tensors="pt")

# Example 1: Print the scores for each token generated with Greedy Search
outputs = model.generate(**inputs, max_new_tokens=5, return_dict_in_generate=True, output_scores=True)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, normalize_logits=True
)
# input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for
# encoder-decoder models, like BART or T5.
input_length = 1 if model.config.is_encoder_decoder else inputs.input_ids.shape[1]
generated_tokens = outputs.sequences[:, input_length:]
for tok, score in zip(generated_tokens[0], transition_scores[0]):
    # | token | token string | logits | probability
    print(f"| {tok:5d} | {tokenizer.decode(tok):8s} | {score.numpy():.3f} | {np.exp(score.numpy()):.2%}")

# Example 2: Reconstruct the sequence scores from Beam Search
outputs = model.generate(
    **inputs,
    max_new_tokens=5,
    num_beams=4,
    num_return_sequences=4,
    return_dict_in_generate=True,
    output_scores=True,
)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=False
)
# If you sum the generated tokens' scores and apply the length penalty, you'll get the sequence scores.
# Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the
# use case, you might want to recompute it with \`normalize_logits=True\`.
output_length = input_length + np.sum(transition_scores.numpy() < 0, axis=1)
length_penalty = model.generation_config.length_penalty
reconstructed_scores = transition_scores.sum(axis=1) / (output_length**length_penalty)
print(np.allclose(outputs.sequences_scores, reconstructed_scores))`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = input_length + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function Zu(M){let c,_,p,d,f,i,u,E;return{c(){c=s("p"),_=n("In most cases, you do not need to call "),p=s("a"),d=n("greedy_search()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=s("a"),u=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=o(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=o(G,"greedy_search()"),G.forEach(t),f=o(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);u=o(O,`following
guide`),O.forEach(t),E=o(b,"."),b.forEach(t),this.h()},h(){h(p,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),h(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E)},d(y){y&&t(c)}}}function Ju(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    StoppingCriteriaList,
    MaxLengthCriteria,
)

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

# set pad_token_id to eos_token_id because GPT2 does not have a PAD token
model.generation_config.pad_token_id = model.generation_config.eos_token_id

input_prompt = "It might be possible to"
input_ids = tokenizer(input_prompt, return_tensors="pt").input_ids

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(10, eos_token_id=model.generation_config.eos_token_id),
    ]
)
stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=20)])

outputs = model.greedy_search(
    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.generation_config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;It might be possible to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">10</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.greedy_search(
<span class="hljs-meta">... </span>    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;It might be possible to get a better understanding of the nature of the problem, but it&#x27;s not&quot;</span>]`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function Xu(M){let c,_,p,d,f,i,u,E;return{c(){c=s("p"),_=n("In most cases, you do not need to call "),p=s("a"),d=n("sample()"),f=n(` directly. Use generate() instead.
For an overview of generation strategies and code examples, check the `),i=s("a"),u=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=o(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=o(G,"sample()"),G.forEach(t),f=o(b,` directly. Use generate() instead.
For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);u=o(O,`following
guide`),O.forEach(t),E=o(b,"."),b.forEach(t),this.h()},h(){h(p,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.sample"),h(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E)},d(y){y&&t(c)}}}function Qu(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    TopKLogitsWarper,
    TemperatureLogitsWarper,
    StoppingCriteriaList,
    MaxLengthCriteria,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

# set pad_token_id to eos_token_id because GPT2 does not have a EOS token
model.config.pad_token_id = model.config.eos_token_id
model.generation_config.pad_token_id = model.config.eos_token_id

input_prompt = "Today is a beautiful day, and"
input_ids = tokenizer(input_prompt, return_tensors="pt").input_ids

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(15, eos_token_id=model.generation_config.eos_token_id),
    ]
)
# instantiate logits processors
logits_warper = LogitsProcessorList(
    [
        TopKLogitsWarper(50),
        TemperatureLogitsWarper(0.7),
    ]
)

stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=20)])

torch.manual_seed(0)
outputs = model.sample(
    input_ids,
    logits_processor=logits_processor,
    logits_warper=logits_warper,
    stopping_criteria=stopping_criteria,
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;Today is a beautiful day, and&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">15</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.sample(
<span class="hljs-meta">... </span>    input_ids,
<span class="hljs-meta">... </span>    logits_processor=logits_processor,
<span class="hljs-meta">... </span>    logits_warper=logits_warper,
<span class="hljs-meta">... </span>    stopping_criteria=stopping_criteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today is a beautiful day, and we must do everything possible to make it a day of celebration.&#x27;</span>]`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function eh(M){let c,_,p,d,f,i,u,E;return{c(){c=s("p"),_=n("In most cases, you do not need to call "),p=s("a"),d=n("beam_search()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=s("a"),u=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=o(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=o(G,"beam_search()"),G.forEach(t),f=o(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);u=o(O,`following
guide`),O.forEach(t),E=o(b,"."),b.forEach(t),this.h()},h(){h(p,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),h(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E)},d(y){y&&t(c)}}}function th(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    num_beams=num_beams,
    device=model.device,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function nh(M){let c,_,p,d,f,i,u,E;return{c(){c=s("p"),_=n("In most cases, you do not need to call "),p=s("a"),d=n("beam_sample()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=s("a"),u=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=o(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=o(G,"beam_sample()"),G.forEach(t),f=o(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);u=o(O,`following
guide`),O.forEach(t),E=o(b,"."),b.forEach(t),this.h()},h(){h(p,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),h(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E)},d(y){y&&t(c)}}}function oh(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    TopKLogitsWarper,
    TemperatureLogitsWarper,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids

# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    max_length=model.config.max_length,
    num_beams=num_beams,
    device=model.device,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id)]
)
# instantiate logits processors
logits_warper = LogitsProcessorList(
    [
        TopKLogitsWarper(50),
        TemperatureLogitsWarper(0.7),
    ]
)

outputs = model.beam_sample(
    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id)]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_sample(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function sh(M){let c,_,p,d,f,i,u,E;return{c(){c=s("p"),_=n("In most cases, you do not need to call "),p=s("a"),d=n("contrastive_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=s("a"),u=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=o(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=o(G,"contrastive_search()"),G.forEach(t),f=o(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);u=o(O,`following
guide`),O.forEach(t),E=o(b,"."),b.forEach(t),this.h()},h(){h(p,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),h(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E)},d(y){y&&t(c)}}}function ah(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    StoppingCriteriaList,
    MaxLengthCriteria,
)

tokenizer = AutoTokenizer.from_pretrained("facebook/opt-125m")
model = AutoModelForCausalLM.from_pretrained("facebook/opt-125m")
# set pad_token_id to eos_token_id because OPT does not have a PAD token
model.config.pad_token_id = model.config.eos_token_id
input_prompt = "DeepMind Company is"
input_ids = tokenizer(input_prompt, return_tensors="pt")
stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=64)])
outputs = model.contrastive_search(
    **input_ids, penalty_alpha=0.6, top_k=4, stopping_criteria=stopping_criteria
)
tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because OPT does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;DeepMind Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">64</span>)])
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.contrastive_search(
<span class="hljs-meta">... </span>    **input_ids, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;DeepMind Company is a company that focuses on the development and commercialization of artificial intelligence (AI). DeepMind\u2019s mission is to help people understand and solve problems that are difficult to solve in the world today.\\n\\nIn this post, we talk about the benefits of deep learning in business and how it&#x27;</span>]`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function rh(M){let c,_,p,d,f,i,u,E;return{c(){c=s("p"),_=n("In most cases, you do not need to call "),p=s("a"),d=n("group_beam_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=s("a"),u=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=o(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=o(G,"group_beam_search()"),G.forEach(t),f=o(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);u=o(O,`following
guide`),O.forEach(t),E=o(b,"."),b.forEach(t),this.h()},h(){h(p,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),h(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E)},d(y){y&&t(c)}}}function ih(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    HammingDiversityLogitsProcessor,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run diverse beam search using 6 beams
num_beams = 6
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    max_length=model.config.max_length,
    num_beams=num_beams,
    device=model.device,
    num_beam_groups=3,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        HammingDiversityLogitsProcessor(5.5, num_beams=6, num_beam_groups=3),
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.group_beam_search(
    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    HammingDiversityLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run diverse beam search using 6 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        HammingDiversityLogitsProcessor(<span class="hljs-number">5.5</span>, num_beams=<span class="hljs-number">6</span>, num_beam_groups=<span class="hljs-number">3</span>),
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.group_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function lh(M){let c,_,p,d,f,i,u,E;return{c(){c=s("p"),_=n("In most cases, you do not need to call "),p=s("a"),d=n("constrained_beam_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=s("a"),u=n(`following
guide`),E=n("."),this.h()},l(y){c=a(y,"P",{});var b=r(c);_=o(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=o(G,"constrained_beam_search()"),G.forEach(t),f=o(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);u=o(O,`following
guide`),O.forEach(t),E=o(b,"."),b.forEach(t),this.h()},h(){h(p,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),h(i,"href","../generation_strategies")},m(y,b){x(y,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E)},d(y){y&&t(c)}}}function ch(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    ConstrainedBeamSearchScorer,
    PhrasalConstraint,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

constraint_str = "Sie"
constraint_token_ids = tokenizer.encode(constraint_str)[:-1]  # slice to remove eos token
constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


# instantiate beam scorer
beam_scorer = ConstrainedBeamSearchScorer(
    batch_size=1, num_beams=num_beams, device=model.device, constraints=constraints
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.constrained_beam_search(
    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    ConstrainedBeamSearchScorer,
<span class="hljs-meta">... </span>    PhrasalConstraint,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_str = <span class="hljs-string">&quot;Sie&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_token_ids = tokenizer.encode(constraint_str)[:-<span class="hljs-number">1</span>]  <span class="hljs-comment"># slice to remove eos token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = ConstrainedBeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>, num_beams=num_beams, device=model.device, constraints=constraints
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.constrained_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt sind Sie?&#x27;</span>]`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function dh(M){let c,_,p,d,f,i,u,E,y,b,G,O,F,ie,I,J,N;return{c(){c=s("p"),_=n("Most generation-controlling parameters are set in "),p=s("code"),d=n("generation_config"),f=n(` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=s("code"),u=n("generation_config"),E=n(` by passing the corresponding
parameters to generate, e.g. `),y=s("code"),b=n(".generate(inputs, num_beams=4, do_sample=True)"),G=n("."),O=m(),F=s("p"),ie=n("For an overview of generation strategies and code examples, check out the "),I=s("a"),J=n(`following
guide`),N=n("."),this.h()},l(C){c=a(C,"P",{});var q=r(c);_=o(q,"Most generation-controlling parameters are set in "),p=a(q,"CODE",{});var X=r(p);d=o(X,"generation_config"),X.forEach(t),f=o(q,` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=a(q,"CODE",{});var Ae=r(i);u=o(Ae,"generation_config"),Ae.forEach(t),E=o(q,` by passing the corresponding
parameters to generate, e.g. `),y=a(q,"CODE",{});var ze=r(y);b=o(ze,".generate(inputs, num_beams=4, do_sample=True)"),ze.forEach(t),G=o(q,"."),q.forEach(t),O=g(C),F=a(C,"P",{});var R=r(F);ie=o(R,"For an overview of generation strategies and code examples, check out the "),I=a(R,"A",{href:!0});var Ne=r(I);J=o(Ne,`following
guide`),Ne.forEach(t),N=o(R,"."),R.forEach(t),this.h()},h(){h(I,"href","../generation_strategies")},m(C,q){x(C,c,q),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,u),e(c,E),e(c,y),e(y,b),e(c,G),x(C,O,q),x(C,F,q),e(F,ie),e(F,I),e(I,J),e(F,N)},d(C){C&&t(c),C&&t(O),C&&t(F)}}}function ph(M){let c,_,p,d,f;return d=new De({props:{code:`from transformers import GPT2Tokenizer, TFAutoModelForCausalLM
import numpy as np

tokenizer = GPT2Tokenizer.from_pretrained("gpt2")
model = TFAutoModelForCausalLM.from_pretrained("gpt2")
tokenizer.pad_token_id = tokenizer.eos_token_id
inputs = tokenizer(["Today is"], return_tensors="tf")

# Example 1: Print the scores for each token generated with Greedy Search
outputs = model.generate(**inputs, max_new_tokens=5, return_dict_in_generate=True, output_scores=True)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, normalize_logits=True
)
# input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for
# encoder-decoder models, like BART or T5.
input_length = 1 if model.config.is_encoder_decoder else inputs.input_ids.shape[1]
generated_tokens = outputs.sequences[:, input_length:]
for tok, score in zip(generated_tokens[0], transition_scores[0]):
    # | token | token string | logits | probability
    print(f"| {tok:5d} | {tokenizer.decode(tok):8s} | {score.numpy():.3f} | {np.exp(score.numpy()):.2%}")

# Example 2: Reconstruct the sequence scores from Beam Search
outputs = model.generate(
    **inputs,
    max_new_tokens=5,
    num_beams=4,
    num_return_sequences=4,
    return_dict_in_generate=True,
    output_scores=True,
)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=False
)
# If you sum the generated tokens' scores and apply the length penalty, you'll get the sequence scores.
# Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the
# use case, you might want to recompute it with \`normalize_logits=True\`.
output_length = input_length + np.sum(transition_scores.numpy() < 0, axis=1)
length_penalty = model.generation_config.length_penalty
reconstructed_scores = np.sum(transition_scores, axis=1) / (output_length**length_penalty)
print(np.allclose(outputs.sequences_scores, reconstructed_scores))`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.413</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.009</span> | <span class="hljs-number">13.41</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = input_length + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`}}),{c(){c=s("p"),_=n("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var u=r(c);_=o(u,"Examples:"),u.forEach(t),p=g(i),j(d.$$.fragment,i)},m(i,u){x(i,c,u),e(c,_),x(i,p,u),w(d,i,u),f=!0},p:Fe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),T(d,i)}}}function mh(M){let c,_,p,d,f,i,u,E,y,b,G,O,F,ie,I,J,N,C,q,X,Ae,ze,R,Ne,vr,xr,Ie,yr,Zn,kr,jr,Jn,wr,$r,Lr,Be,Tr,Xn,Er,Mr,Qn,Gr,Or,Fa,tt,Cr,eo,Sr,qr,Da,nt,Pr,to,Fr,Dr,Aa,We,ot,Io,on,Ar,Bo,zr,za,D,sn,Nr,an,Ir,Wo,Br,Wr,Ur,B,le,Uo,Rr,Hr,no,Vr,Yr,Ro,Kr,Zr,Ho,Jr,Xr,ce,Vo,Qr,ei,oo,ti,ni,Yo,oi,si,Ko,ai,ri,de,Zo,ii,li,so,ci,di,Jo,pi,mi,Xo,gi,ui,pe,Qo,hi,fi,ao,_i,bi,es,vi,xi,ts,yi,ki,me,ns,ji,wi,ro,$i,Li,os,Ti,Ei,ss,Mi,Gi,ge,as,Oi,Ci,io,Si,qi,rs,Pi,Fi,is,Di,Ai,ue,ls,zi,Ni,lo,Ii,Bi,cs,Wi,Ui,ds,Ri,Hi,rn,Vi,co,Yi,Ki,Zi,Me,ln,Ji,cn,Xi,po,Qi,el,tl,st,nl,at,dn,ol,Z,sl,mo,al,rl,go,il,ll,uo,cl,dl,ho,pl,ml,gl,rt,pn,ul,Ue,hl,ps,fl,_l,fo,bl,vl,Na,Re,it,ms,mn,xl,gs,yl,Ia,S,gn,kl,un,jl,_o,wl,$l,Ll,hn,Tl,bo,El,Ml,Gl,W,he,us,Ol,Cl,vo,Sl,ql,hs,Pl,Fl,fs,Dl,Al,fe,_s,zl,Nl,xo,Il,Bl,bs,Wl,Ul,vs,Rl,Hl,_e,xs,Vl,Yl,yo,Kl,Zl,ys,Jl,Xl,ks,Ql,ec,be,js,tc,nc,ko,oc,sc,ws,ac,rc,$s,ic,lc,ve,Ls,cc,dc,jo,pc,mc,Ts,gc,uc,Es,hc,fc,xe,Ms,_c,bc,wo,vc,xc,Gs,yc,kc,Os,jc,wc,ye,Cs,$c,Lc,$o,Tc,Ec,Ss,Mc,Gc,qs,Oc,Cc,fn,Sc,Lo,qc,Pc,Fc,Ge,_n,Dc,Ps,Ac,zc,lt,Nc,Oe,bn,Ic,Fs,Bc,Wc,ct,Uc,Q,vn,Rc,xn,Hc,Ds,Vc,Yc,Kc,dt,Zc,pt,Jc,ee,yn,Xc,kn,Qc,As,ed,td,nd,mt,od,gt,sd,te,jn,ad,wn,rd,zs,id,ld,cd,ut,dd,ht,pd,ne,$n,md,Ln,gd,Ns,ud,hd,fd,ft,_d,_t,bd,oe,Tn,vd,En,xd,Is,yd,kd,jd,bt,wd,vt,$d,se,Mn,Ld,Gn,Td,Bs,Ed,Md,Gd,xt,Od,yt,Cd,ae,On,Sd,Cn,qd,Ws,Pd,Fd,Dd,kt,Ad,jt,Ba,He,wt,Us,Sn,zd,Rs,Nd,Wa,A,qn,Id,Pn,Bd,To,Wd,Ud,Rd,Fn,Hd,Eo,Vd,Yd,Kd,ke,je,Hs,Zd,Jd,Vs,Xd,Qd,Ys,ep,tp,Ks,np,op,we,Zs,sp,ap,Js,rp,ip,Xs,lp,cp,Qs,dp,pp,$e,ea,mp,gp,ta,up,hp,na,fp,_p,oa,bp,vp,Ve,sa,xp,yp,aa,kp,jp,ra,wp,$p,Dn,Lp,Mo,Tp,Ep,Mp,Ce,An,Gp,ia,Op,Cp,$t,Sp,Se,zn,qp,la,Pp,Fp,Lt,Ua,Ye,Tt,ca,Nn,Dp,da,Ap,Ra,U,In,zp,Bn,Np,Go,Ip,Bp,Wp,Wn,Up,Oo,Rp,Hp,Vp,Ke,Le,pa,Yp,Kp,ma,Zp,Jp,ga,Xp,Qp,ua,em,tm,Te,ha,nm,om,fa,sm,am,_a,rm,im,ba,lm,cm,Ee,va,dm,pm,xa,mm,gm,ya,um,hm,ka,fm,_m,Un,bm,Co,vm,xm,ym,Et,Rn,km,ja,jm,Ha;return i=new Pa({}),on=new Pa({}),sn=new z({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/configuration_utils.py#L38",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated. Corresponds to the length of the input prompt +
<code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.`,name:"min_length"},{anchor:"transformers.GenerationConfig.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"min_new_tokens"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time(float,",description:`<strong>max_time(<code>float</code>,</strong> <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time(float,"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
<code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the
size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"transformers.GenerationConfig.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between
0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token
probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"eta_cutoff"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.encoder_repetition_penalty",description:`<strong>encoder_repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the
original input. 1.0 means no penalty.`,name:"encoder_repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids(List[List[int]],",description:`<strong>bad_words_ids(<code>List[List[int]]</code>,</strong> <em>optional</em>) &#x2014;
List of token ids that are not allowed to be generated. In order to get the token ids of the words that
should not appear in the generated text, use <code>tokenizer(bad_words, add_prefix_space=True, add_special_tokens=False).input_ids</code>.`,name:"bad_words_ids(List[List[int]],"},{anchor:"transformers.GenerationConfig.force_words_ids(List[List[int]]",description:`<strong>force_words_ids(<code>List[List[int]]</code></strong> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids(List[List[int]]"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors or warpers (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors or warpers break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use of
certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to <code>model.config.forced_eos_token_id</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"}]},{title:"Parameters that define the output variables of `generate`",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"}]},{title:"Wild card",parametersDescription:[]}]}}),ln=new z({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"use_auth_token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/configuration_utils.py#L373",returnDescription:`
<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),st=new Pe({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[Vu]},$$scope:{ctx:M}}}),dn=new z({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/configuration_utils.py#L665",returnDescription:`
<p>The configuration object instantiated from those parameters.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),pn=new z({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).
kwargs &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.27.2/en/internal/image_processing_utils#transformers.ImageProcessingMixin.push_to_hub">push_to_hub()</a> method.`,name:"push_to_hub"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/configuration_utils.py#L323"}}),mn=new Pa({}),gn=new z({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L465"}}),_n=new z({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Union[typing.Callable[[int, torch.Tensor], typing.List[int]], NoneType] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max<em>length (needed for ZeRO stage 3)
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with *decoder</em>*.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L1110",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),lt=new et({props:{warning:!0,$$slots:{default:[Yu]},$$scope:{ctx:M}}}),bn=new z({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[torch.Tensor]"},{name:"beam_indices",val:": typing.Optional[torch.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with
each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L940",returnDescription:`
<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>torch.Tensor</code></p>
`}}),ct=new Pe({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[Ku]},$$scope:{ctx:M}}}),vn=new z({props:{name:"greedy_search",anchor:"transformers.GenerationMixin.greedy_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.greedy_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.greedy_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.greedy_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.greedy_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.greedy_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.greedy_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.greedy_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.greedy_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.greedy_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L2037",returnDescription:`
<p><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),dt=new et({props:{warning:!0,$$slots:{default:[Zu]},$$scope:{ctx:M}}}),pt=new Pe({props:{anchor:"transformers.GenerationMixin.greedy_search.example",$$slots:{default:[Ju]},$$scope:{ctx:M}}}),yn=new z({props:{name:"sample",anchor:"transformers.GenerationMixin.sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L2283",returnDescription:`
<p>A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> or <code>torch.LongTensor</code></p>
`}}),mt=new et({props:{warning:!0,$$slots:{default:[Xu]},$$scope:{ctx:M}}}),gt=new Pe({props:{anchor:"transformers.GenerationMixin.sample.example",$$slots:{default:[Qu]},$$scope:{ctx:M}}}),jn=new z({props:{name:"beam_search",anchor:"transformers.GenerationMixin.beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L2552",returnDescription:`
<p><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),ut=new et({props:{warning:!0,$$slots:{default:[eh]},$$scope:{ctx:M}}}),ht=new Pe({props:{anchor:"transformers.GenerationMixin.beam_search.example",$$slots:{default:[th]},$$scope:{ctx:M}}}),$n=new z({props:{name:"beam_sample",anchor:"transformers.GenerationMixin.beam_sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_sample.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.beam_sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L2875",returnDescription:`
<p><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),ft=new et({props:{warning:!0,$$slots:{default:[nh]},$$scope:{ctx:M}}}),_t=new Pe({props:{anchor:"transformers.GenerationMixin.beam_sample.example",$$slots:{default:[oh]},$$scope:{ctx:M}}}),Tn=new z({props:{name:"contrastive_search",anchor:"transformers.GenerationMixin.contrastive_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"top_k",val:": typing.Optional[int] = 1"},{name:"penalty_alpha",val:": typing.Optional[float] = 0"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.contrastive_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.contrastive_search.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the candidate set that is used to re-rank for contrastive search`,name:"top_k"},{anchor:"transformers.GenerationMixin.contrastive_search.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The degeneration penalty for contrastive search; activate when it is larger than 0`,name:"penalty_alpha"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.contrastive_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.contrastive_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.contrastive_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.contrastive_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.contrastive_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.contrastive_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L1676",returnDescription:`
<p><code>ContrastiveSearchDecoderOnlyOutput</code>, <code>ContrastiveSearchEncoderDecoderOutput</code>
or <code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<code>ContrastiveSearchDecoderOnlyOutput</code> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <code>ContrastiveSearchEncoderDecoderOutput</code> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),bt=new et({props:{warning:!0,$$slots:{default:[sh]},$$scope:{ctx:M}}}),vt=new Pe({props:{anchor:"transformers.GenerationMixin.contrastive_search.example",$$slots:{default:[ah]},$$scope:{ctx:M}}}),Mn=new z({props:{name:"group_beam_search",anchor:"transformers.GenerationMixin.group_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.group_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.group_beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.group_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.group_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.group_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.group_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.group_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.group_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.group_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.group_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)</p>
<p>model_kwargs &#x2014;
Additional model specific kwargs that will be forwarded to the <code>forward</code> function of the model. If
model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L3208",returnDescription:`
<p><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if
<code>model.config.is_encoder_decoder=False</code> and <code>return_dict_in_generate=True</code> or a
<a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if <code>model.config.is_encoder_decoder=True</code>.</p>
`}}),xt=new et({props:{warning:!0,$$slots:{default:[rh]},$$scope:{ctx:M}}}),yt=new Pe({props:{anchor:"transformers.GenerationMixin.group_beam_search.example",$$slots:{default:[ih]},$$scope:{ctx:M}}}),On=new z({props:{name:"constrained_beam_search",anchor:"transformers.GenerationMixin.constrained_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"constrained_beam_scorer",val:": ConstrainedBeamSearchScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.constrained_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.constrained_beam_search.constrained_beam_scorer",description:`<strong>constrained_beam_scorer</strong> (<code>ConstrainedBeamSearchScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation, while satisfying a list of positive constraints. For more information, the
documentation of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.ConstrainedBeamSearchScorer">ConstrainedBeamSearchScorer</a> should be read.`,name:"constrained_beam_scorer"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.constrained_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.constrained_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.constrained_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.constrained_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.constrained_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/utils.py#L3586",returnDescription:`
<p><a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.27.2/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),kt=new et({props:{warning:!0,$$slots:{default:[lh]},$$scope:{ctx:M}}}),jt=new Pe({props:{anchor:"transformers.GenerationMixin.constrained_beam_search.example",$$slots:{default:[ch]},$$scope:{ctx:M}}}),Sn=new Pa({}),qn=new z({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/tf_utils.py#L444"}}),An=new z({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.tf_logits_process.TFLogitsProcessorList] = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"seed"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/tf_utils.py#L666",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><code>TFGreedySearchDecoderOnlyOutput</code>,</li>
<li><code>TFSampleDecoderOnlyOutput</code>,</li>
<li><code>TFBeamSearchDecoderOnlyOutput</code>,</li>
<li><code>TFBeamSampleDecoderOnlyOutput</code></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><code>TFGreedySearchEncoderDecoderOutput</code>,</li>
<li><code>TFSampleEncoderDecoderOutput</code>,</li>
<li><code>TFBeamSearchEncoderDecoderOutput</code>,</li>
<li><code>TFBeamSampleEncoderDecoderOutput</code></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),$t=new et({props:{warning:!0,$$slots:{default:[dh]},$$scope:{ctx:M}}}),zn=new z({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[tensorflow.python.framework.ops.Tensor]"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/tf_utils.py#L498",returnDescription:`
<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>tf.Tensor</code></p>
`}}),Lt=new Pe({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[ph]},$$scope:{ctx:M}}}),Nn=new Pa({}),In=new z({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/flax_utils.py#L129"}}),Rn=new z({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": ndarray"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"prng_key",val:": typing.Optional[jax._src.numpy.ndarray.ndarray] = None"},{name:"trace",val:": bool = True"},{name:"params",val:": typing.Union[typing.Dict[str, jax._src.numpy.ndarray.ndarray], NoneType] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.flax_logits_process.FlaxLogitsProcessorList] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"logits_processor"}],source:"https://github.com/huggingface/transformers/blob/v4.27.2/src/transformers/generation/flax_utils.py#L267",returnDescription:`
<p><a
  href="/docs/transformers/v4.27.2/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),{c(){c=s("meta"),_=m(),p=s("h1"),d=s("a"),f=s("span"),k(i.$$.fragment),u=m(),E=s("span"),y=n("Generation"),b=m(),G=s("p"),O=n("Each framework has a generate method for text generation implemented in their respective "),F=s("code"),ie=n("GenerationMixin"),I=n(" class:"),J=m(),N=s("ul"),C=s("li"),q=n("PyTorch "),X=s("a"),Ae=n("generate()"),ze=n(" is implemented in "),R=s("a"),Ne=n("GenerationMixin"),vr=n("."),xr=m(),Ie=s("li"),yr=n("TensorFlow "),Zn=s("a"),kr=n("generate()"),jr=n(" is implemented in "),Jn=s("a"),wr=n("TFGenerationMixin"),$r=n("."),Lr=m(),Be=s("li"),Tr=n("Flax/JAX "),Xn=s("a"),Er=n("generate()"),Mr=n(" is implemented in "),Qn=s("a"),Gr=n("FlaxGenerationMixin"),Or=n("."),Fa=m(),tt=s("p"),Cr=n("Regardless of your framework of choice, you can parameterize the generate method with a "),eo=s("a"),Sr=n("GenerationConfig"),qr=n(`
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`),Da=m(),nt=s("p"),Pr=n(`To learn how to inspect a model\u2019s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
`),to=s("a"),Fr=n("text generation strategies guide"),Dr=n("."),Aa=m(),We=s("h2"),ot=s("a"),Io=s("span"),k(on.$$.fragment),Ar=m(),Bo=s("span"),zr=n("GenerationConfig"),za=m(),D=s("div"),k(sn.$$.fragment),Nr=m(),an=s("p"),Ir=n("Class that holds a configuration for a generation task. A "),Wo=s("code"),Br=n("generate"),Wr=n(` call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),Ur=m(),B=s("ul"),le=s("li"),Uo=s("em"),Rr=n("greedy decoding"),Hr=n(" by calling "),no=s("a"),Vr=n("greedy_search()"),Yr=n(" if "),Ro=s("code"),Kr=n("num_beams=1"),Zr=n(` and
`),Ho=s("code"),Jr=n("do_sample=False"),Xr=m(),ce=s("li"),Vo=s("em"),Qr=n("contrastive search"),ei=n(" by calling "),oo=s("a"),ti=n("contrastive_search()"),ni=n(" if "),Yo=s("code"),oi=n("penalty_alpha>0."),si=n(`
and `),Ko=s("code"),ai=n("top_k>1"),ri=m(),de=s("li"),Zo=s("em"),ii=n("multinomial sampling"),li=n(" by calling "),so=s("a"),ci=n("sample()"),di=n(" if "),Jo=s("code"),pi=n("num_beams=1"),mi=n(` and
`),Xo=s("code"),gi=n("do_sample=True"),ui=m(),pe=s("li"),Qo=s("em"),hi=n("beam-search decoding"),fi=n(" by calling "),ao=s("a"),_i=n("beam_search()"),bi=n(" if "),es=s("code"),vi=n("num_beams>1"),xi=n(` and
`),ts=s("code"),yi=n("do_sample=False"),ki=m(),me=s("li"),ns=s("em"),ji=n("beam-search multinomial sampling"),wi=n(" by calling "),ro=s("a"),$i=n("beam_sample()"),Li=n(` if
`),os=s("code"),Ti=n("num_beams>1"),Ei=n(" and "),ss=s("code"),Mi=n("do_sample=True"),Gi=m(),ge=s("li"),as=s("em"),Oi=n("diverse beam-search decoding"),Ci=n(" by calling "),io=s("a"),Si=n("group_beam_search()"),qi=n(`, if
`),rs=s("code"),Pi=n("num_beams>1"),Fi=n(" and "),is=s("code"),Di=n("num_beam_groups>1"),Ai=m(),ue=s("li"),ls=s("em"),zi=n("constrained beam-search decoding"),Ni=n(" by calling "),lo=s("a"),Ii=n("constrained_beam_search()"),Bi=n(`, if
`),cs=s("code"),Wi=n("constraints!=None"),Ui=n(" or "),ds=s("code"),Ri=n("force_words_ids!=None"),Hi=m(),rn=s("p"),Vi=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019. To learn
more about decoding strategies refer to the `),co=s("a"),Yi=n("text generation strategies guide"),Ki=n("."),Zi=m(),Me=s("div"),k(ln.$$.fragment),Ji=m(),cn=s("p"),Xi=n("Instantiate a "),po=s("a"),Qi=n("GenerationConfig"),el=n(" from a generation configuration file."),tl=m(),k(st.$$.fragment),nl=m(),at=s("div"),k(dn.$$.fragment),ol=m(),Z=s("p"),sl=n("Instantiates a "),mo=s("a"),al=n("GenerationConfig"),rl=n(" from a "),go=s("a"),il=n("PretrainedConfig"),ll=n(`. This function is useful to convert legacy
`),uo=s("a"),cl=n("PretrainedConfig"),dl=n(" objects, which may contain generation parameters, into a stand-alone "),ho=s("a"),pl=n("GenerationConfig"),ml=n("."),gl=m(),rt=s("div"),k(pn.$$.fragment),ul=m(),Ue=s("p"),hl=n("Save a generation configuration object to the directory "),ps=s("code"),fl=n("save_directory"),_l=n(`, so that it can be re-loaded using the
`),fo=s("a"),bl=n("from_pretrained()"),vl=n(" class method."),Na=m(),Re=s("h2"),it=s("a"),ms=s("span"),k(mn.$$.fragment),xl=m(),gs=s("span"),yl=n("GenerationMixin"),Ia=m(),S=s("div"),k(gn.$$.fragment),kl=m(),un=s("p"),jl=n("A class containing all functions for auto-regressive text generation, to be used as a mixin in "),_o=s("a"),wl=n("PreTrainedModel"),$l=n("."),Ll=m(),hn=s("p"),Tl=n("The class exposes "),bo=s("a"),El=n("generate()"),Ml=n(", which can be used for:"),Gl=m(),W=s("ul"),he=s("li"),us=s("em"),Ol=n("greedy decoding"),Cl=n(" by calling "),vo=s("a"),Sl=n("greedy_search()"),ql=n(" if "),hs=s("code"),Pl=n("num_beams=1"),Fl=n(` and
`),fs=s("code"),Dl=n("do_sample=False"),Al=m(),fe=s("li"),_s=s("em"),zl=n("contrastive search"),Nl=n(" by calling "),xo=s("a"),Il=n("contrastive_search()"),Bl=n(" if "),bs=s("code"),Wl=n("penalty_alpha>0"),Ul=n(` and
`),vs=s("code"),Rl=n("top_k>1"),Hl=m(),_e=s("li"),xs=s("em"),Vl=n("multinomial sampling"),Yl=n(" by calling "),yo=s("a"),Kl=n("sample()"),Zl=n(" if "),ys=s("code"),Jl=n("num_beams=1"),Xl=n(` and
`),ks=s("code"),Ql=n("do_sample=True"),ec=m(),be=s("li"),js=s("em"),tc=n("beam-search decoding"),nc=n(" by calling "),ko=s("a"),oc=n("beam_search()"),sc=n(" if "),ws=s("code"),ac=n("num_beams>1"),rc=n(` and
`),$s=s("code"),ic=n("do_sample=False"),lc=m(),ve=s("li"),Ls=s("em"),cc=n("beam-search multinomial sampling"),dc=n(" by calling "),jo=s("a"),pc=n("beam_sample()"),mc=n(" if "),Ts=s("code"),gc=n("num_beams>1"),uc=n(`
and `),Es=s("code"),hc=n("do_sample=True"),fc=m(),xe=s("li"),Ms=s("em"),_c=n("diverse beam-search decoding"),bc=n(" by calling "),wo=s("a"),vc=n("group_beam_search()"),xc=n(", if "),Gs=s("code"),yc=n("num_beams>1"),kc=n(`
and `),Os=s("code"),jc=n("num_beam_groups>1"),wc=m(),ye=s("li"),Cs=s("em"),$c=n("constrained beam-search decoding"),Lc=n(" by calling "),$o=s("a"),Tc=n("constrained_beam_search()"),Ec=n(`, if
`),Ss=s("code"),Mc=n("constraints!=None"),Gc=n(" or "),qs=s("code"),Oc=n("force_words_ids!=None"),Cc=m(),fn=s("p"),Sc=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Lo=s("a"),qc=n("text generation strategies guide"),Pc=n("."),Fc=m(),Ge=s("div"),k(_n.$$.fragment),Dc=m(),Ps=s("p"),Ac=n("Generates sequences of token ids for models with a language modeling head."),zc=m(),k(lt.$$.fragment),Nc=m(),Oe=s("div"),k(bn.$$.fragment),Ic=m(),Fs=s("p"),Bc=n(`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Wc=m(),k(ct.$$.fragment),Uc=m(),Q=s("div"),k(vn.$$.fragment),Rc=m(),xn=s("p"),Hc=n("Generates sequences of token ids for models with a language modeling head using "),Ds=s("strong"),Vc=n("greedy decoding"),Yc=n(` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Kc=m(),k(dt.$$.fragment),Zc=m(),k(pt.$$.fragment),Jc=m(),ee=s("div"),k(yn.$$.fragment),Xc=m(),kn=s("p"),Qc=n("Generates sequences of token ids for models with a language modeling head using "),As=s("strong"),ed=n("multinomial sampling"),td=n(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),nd=m(),k(mt.$$.fragment),od=m(),k(gt.$$.fragment),sd=m(),te=s("div"),k(jn.$$.fragment),ad=m(),wn=s("p"),rd=n("Generates sequences of token ids for models with a language modeling head using "),zs=s("strong"),id=n("beam search decoding"),ld=n(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),cd=m(),k(ut.$$.fragment),dd=m(),k(ht.$$.fragment),pd=m(),ne=s("div"),k($n.$$.fragment),md=m(),Ln=s("p"),gd=n("Generates sequences of token ids for models with a language modeling head using "),Ns=s("strong"),ud=n(`beam search multinomial
sampling`),hd=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),fd=m(),k(ft.$$.fragment),_d=m(),k(_t.$$.fragment),bd=m(),oe=s("div"),k(Tn.$$.fragment),vd=m(),En=s("p"),xd=n("Generates sequences of token ids for models with a language modeling head using "),Is=s("strong"),yd=n("contrastive search"),kd=n(` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),jd=m(),k(bt.$$.fragment),wd=m(),k(vt.$$.fragment),$d=m(),se=s("div"),k(Mn.$$.fragment),Ld=m(),Gn=s("p"),Td=n("Generates sequences of token ids for models with a language modeling head using "),Bs=s("strong"),Ed=n(`diverse beam search
decoding`),Md=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Gd=m(),k(xt.$$.fragment),Od=m(),k(yt.$$.fragment),Cd=m(),ae=s("div"),k(On.$$.fragment),Sd=m(),Cn=s("p"),qd=n("Generates sequences of token ids for models with a language modeling head using "),Ws=s("strong"),Pd=n(`constrained beam search
decoding`),Fd=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Dd=m(),k(kt.$$.fragment),Ad=m(),k(jt.$$.fragment),Ba=m(),He=s("h2"),wt=s("a"),Us=s("span"),k(Sn.$$.fragment),zd=m(),Rs=s("span"),Nd=n("TFGenerationMixin"),Wa=m(),A=s("div"),k(qn.$$.fragment),Id=m(),Pn=s("p"),Bd=n("A class containing all of the functions supporting generation, to be used as a mixin in "),To=s("a"),Wd=n("TFPreTrainedModel"),Ud=n("."),Rd=m(),Fn=s("p"),Hd=n("The class exposes "),Eo=s("a"),Vd=n("generate()"),Yd=n(", which can be used for:"),Kd=m(),ke=s("ul"),je=s("li"),Hs=s("em"),Zd=n("greedy decoding"),Jd=n(" by calling "),Vs=s("code"),Xd=n("greedy_search()"),Qd=n(" if "),Ys=s("code"),ep=n("num_beams=1"),tp=n(` and
`),Ks=s("code"),np=n("do_sample=False"),op=m(),we=s("li"),Zs=s("em"),sp=n("contrastive search"),ap=n(" by calling "),Js=s("code"),rp=n("contrastive_search()"),ip=n(" if "),Xs=s("code"),lp=n("penalty_alpha>0"),cp=n(` and
`),Qs=s("code"),dp=n("top_k>1"),pp=m(),$e=s("li"),ea=s("em"),mp=n("multinomial sampling"),gp=n(" by calling "),ta=s("code"),up=n("sample()"),hp=n(" if "),na=s("code"),fp=n("num_beams=1"),_p=n(` and
`),oa=s("code"),bp=n("do_sample=True"),vp=m(),Ve=s("li"),sa=s("em"),xp=n("beam-search decoding"),yp=n(" by calling "),aa=s("code"),kp=n("beam_search()"),jp=n(" if "),ra=s("code"),wp=n("num_beams>1"),$p=m(),Dn=s("p"),Lp=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Mo=s("a"),Tp=n("text generation strategies guide"),Ep=n("."),Mp=m(),Ce=s("div"),k(An.$$.fragment),Gp=m(),ia=s("p"),Op=n("Generates sequences of token ids for models with a language modeling head."),Cp=m(),k($t.$$.fragment),Sp=m(),Se=s("div"),k(zn.$$.fragment),qp=m(),la=s("p"),Pp=n(`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Fp=m(),k(Lt.$$.fragment),Ua=m(),Ye=s("h2"),Tt=s("a"),ca=s("span"),k(Nn.$$.fragment),Dp=m(),da=s("span"),Ap=n("FlaxGenerationMixin"),Ra=m(),U=s("div"),k(In.$$.fragment),zp=m(),Bn=s("p"),Np=n(`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),Go=s("a"),Ip=n("FlaxPreTrainedModel"),Bp=n("."),Wp=m(),Wn=s("p"),Up=n("The class exposes "),Oo=s("a"),Rp=n("generate()"),Hp=n(", which can be used for:"),Vp=m(),Ke=s("ul"),Le=s("li"),pa=s("em"),Yp=n("greedy decoding"),Kp=n(" by calling "),ma=s("code"),Zp=n("_greedy_search()"),Jp=n(" if "),ga=s("code"),Xp=n("num_beams=1"),Qp=n(` and
`),ua=s("code"),em=n("do_sample=False"),tm=m(),Te=s("li"),ha=s("em"),nm=n("multinomial sampling"),om=n(" by calling "),fa=s("code"),sm=n("_sample()"),am=n(" if "),_a=s("code"),rm=n("num_beams=1"),im=n(` and
`),ba=s("code"),lm=n("do_sample=True"),cm=m(),Ee=s("li"),va=s("em"),dm=n("beam-search decoding"),pm=n(" by calling "),xa=s("code"),mm=n("_beam_search()"),gm=n(" if "),ya=s("code"),um=n("num_beams>1"),hm=n(` and
`),ka=s("code"),fm=n("do_sample=False"),_m=m(),Un=s("p"),bm=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Co=s("a"),vm=n("text generation strategies guide"),xm=n("."),ym=m(),Et=s("div"),k(Rn.$$.fragment),km=m(),ja=s("p"),jm=n("Generates sequences of token ids for models with a language modeling head."),this.h()},l(l){const v=Ru('[data-svelte="svelte-1phssyn"]',document.head);c=a(v,"META",{name:!0,content:!0}),v.forEach(t),_=g(l),p=a(l,"H1",{class:!0});var Hn=r(p);d=a(Hn,"A",{id:!0,class:!0,href:!0});var wa=r(d);f=a(wa,"SPAN",{});var $a=r(f);j(i.$$.fragment,$a),$a.forEach(t),wa.forEach(t),u=g(Hn),E=a(Hn,"SPAN",{});var La=r(E);y=o(La,"Generation"),La.forEach(t),Hn.forEach(t),b=g(l),G=a(l,"P",{});var Vn=r(G);O=o(Vn,"Each framework has a generate method for text generation implemented in their respective "),F=a(Vn,"CODE",{});var Ta=r(F);ie=o(Ta,"GenerationMixin"),Ta.forEach(t),I=o(Vn," class:"),Vn.forEach(t),J=g(l),N=a(l,"UL",{});var Ze=r(N);C=a(Ze,"LI",{});var Je=r(C);q=o(Je,"PyTorch "),X=a(Je,"A",{href:!0});var Ea=r(X);Ae=o(Ea,"generate()"),Ea.forEach(t),ze=o(Je," is implemented in "),R=a(Je,"A",{href:!0});var Ma=r(R);Ne=o(Ma,"GenerationMixin"),Ma.forEach(t),vr=o(Je,"."),Je.forEach(t),xr=g(Ze),Ie=a(Ze,"LI",{});var Xe=r(Ie);yr=o(Xe,"TensorFlow "),Zn=a(Xe,"A",{href:!0});var Ga=r(Zn);kr=o(Ga,"generate()"),Ga.forEach(t),jr=o(Xe," is implemented in "),Jn=a(Xe,"A",{href:!0});var Oa=r(Jn);wr=o(Oa,"TFGenerationMixin"),Oa.forEach(t),$r=o(Xe,"."),Xe.forEach(t),Lr=g(Ze),Be=a(Ze,"LI",{});var Qe=r(Be);Tr=o(Qe,"Flax/JAX "),Xn=a(Qe,"A",{href:!0});var Ca=r(Xn);Er=o(Ca,"generate()"),Ca.forEach(t),Mr=o(Qe," is implemented in "),Qn=a(Qe,"A",{href:!0});var Sa=r(Qn);Gr=o(Sa,"FlaxGenerationMixin"),Sa.forEach(t),Or=o(Qe,"."),Qe.forEach(t),Ze.forEach(t),Fa=g(l),tt=a(l,"P",{});var Yn=r(tt);Cr=o(Yn,"Regardless of your framework of choice, you can parameterize the generate method with a "),eo=a(Yn,"A",{href:!0});var qa=r(eo);Sr=o(qa,"GenerationConfig"),qa.forEach(t),qr=o(Yn,`
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`),Yn.forEach(t),Da=g(l),nt=a(l,"P",{});var Kn=r(nt);Pr=o(Kn,`To learn how to inspect a model\u2019s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
`),to=a(Kn,"A",{href:!0});var wm=r(to);Fr=o(wm,"text generation strategies guide"),wm.forEach(t),Dr=o(Kn,"."),Kn.forEach(t),Aa=g(l),We=a(l,"H2",{class:!0});var Va=r(We);ot=a(Va,"A",{id:!0,class:!0,href:!0});var $m=r(ot);Io=a($m,"SPAN",{});var Lm=r(Io);j(on.$$.fragment,Lm),Lm.forEach(t),$m.forEach(t),Ar=g(Va),Bo=a(Va,"SPAN",{});var Tm=r(Bo);zr=o(Tm,"GenerationConfig"),Tm.forEach(t),Va.forEach(t),za=g(l),D=a(l,"DIV",{class:!0});var H=r(D);j(sn.$$.fragment,H),Nr=g(H),an=a(H,"P",{});var Ya=r(an);Ir=o(Ya,"Class that holds a configuration for a generation task. A "),Wo=a(Ya,"CODE",{});var Em=r(Wo);Br=o(Em,"generate"),Em.forEach(t),Wr=o(Ya,` call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),Ya.forEach(t),Ur=g(H),B=a(H,"UL",{});var V=r(B);le=a(V,"LI",{});var Mt=r(le);Uo=a(Mt,"EM",{});var Mm=r(Uo);Rr=o(Mm,"greedy decoding"),Mm.forEach(t),Hr=o(Mt," by calling "),no=a(Mt,"A",{href:!0});var Gm=r(no);Vr=o(Gm,"greedy_search()"),Gm.forEach(t),Yr=o(Mt," if "),Ro=a(Mt,"CODE",{});var Om=r(Ro);Kr=o(Om,"num_beams=1"),Om.forEach(t),Zr=o(Mt,` and
`),Ho=a(Mt,"CODE",{});var Cm=r(Ho);Jr=o(Cm,"do_sample=False"),Cm.forEach(t),Mt.forEach(t),Xr=g(V),ce=a(V,"LI",{});var Gt=r(ce);Vo=a(Gt,"EM",{});var Sm=r(Vo);Qr=o(Sm,"contrastive search"),Sm.forEach(t),ei=o(Gt," by calling "),oo=a(Gt,"A",{href:!0});var qm=r(oo);ti=o(qm,"contrastive_search()"),qm.forEach(t),ni=o(Gt," if "),Yo=a(Gt,"CODE",{});var Pm=r(Yo);oi=o(Pm,"penalty_alpha>0."),Pm.forEach(t),si=o(Gt,`
and `),Ko=a(Gt,"CODE",{});var Fm=r(Ko);ai=o(Fm,"top_k>1"),Fm.forEach(t),Gt.forEach(t),ri=g(V),de=a(V,"LI",{});var Ot=r(de);Zo=a(Ot,"EM",{});var Dm=r(Zo);ii=o(Dm,"multinomial sampling"),Dm.forEach(t),li=o(Ot," by calling "),so=a(Ot,"A",{href:!0});var Am=r(so);ci=o(Am,"sample()"),Am.forEach(t),di=o(Ot," if "),Jo=a(Ot,"CODE",{});var zm=r(Jo);pi=o(zm,"num_beams=1"),zm.forEach(t),mi=o(Ot,` and
`),Xo=a(Ot,"CODE",{});var Nm=r(Xo);gi=o(Nm,"do_sample=True"),Nm.forEach(t),Ot.forEach(t),ui=g(V),pe=a(V,"LI",{});var Ct=r(pe);Qo=a(Ct,"EM",{});var Im=r(Qo);hi=o(Im,"beam-search decoding"),Im.forEach(t),fi=o(Ct," by calling "),ao=a(Ct,"A",{href:!0});var Bm=r(ao);_i=o(Bm,"beam_search()"),Bm.forEach(t),bi=o(Ct," if "),es=a(Ct,"CODE",{});var Wm=r(es);vi=o(Wm,"num_beams>1"),Wm.forEach(t),xi=o(Ct,` and
`),ts=a(Ct,"CODE",{});var Um=r(ts);yi=o(Um,"do_sample=False"),Um.forEach(t),Ct.forEach(t),ki=g(V),me=a(V,"LI",{});var St=r(me);ns=a(St,"EM",{});var Rm=r(ns);ji=o(Rm,"beam-search multinomial sampling"),Rm.forEach(t),wi=o(St," by calling "),ro=a(St,"A",{href:!0});var Hm=r(ro);$i=o(Hm,"beam_sample()"),Hm.forEach(t),Li=o(St,` if
`),os=a(St,"CODE",{});var Vm=r(os);Ti=o(Vm,"num_beams>1"),Vm.forEach(t),Ei=o(St," and "),ss=a(St,"CODE",{});var Ym=r(ss);Mi=o(Ym,"do_sample=True"),Ym.forEach(t),St.forEach(t),Gi=g(V),ge=a(V,"LI",{});var qt=r(ge);as=a(qt,"EM",{});var Km=r(as);Oi=o(Km,"diverse beam-search decoding"),Km.forEach(t),Ci=o(qt," by calling "),io=a(qt,"A",{href:!0});var Zm=r(io);Si=o(Zm,"group_beam_search()"),Zm.forEach(t),qi=o(qt,`, if
`),rs=a(qt,"CODE",{});var Jm=r(rs);Pi=o(Jm,"num_beams>1"),Jm.forEach(t),Fi=o(qt," and "),is=a(qt,"CODE",{});var Xm=r(is);Di=o(Xm,"num_beam_groups>1"),Xm.forEach(t),qt.forEach(t),Ai=g(V),ue=a(V,"LI",{});var Pt=r(ue);ls=a(Pt,"EM",{});var Qm=r(ls);zi=o(Qm,"constrained beam-search decoding"),Qm.forEach(t),Ni=o(Pt," by calling "),lo=a(Pt,"A",{href:!0});var eg=r(lo);Ii=o(eg,"constrained_beam_search()"),eg.forEach(t),Bi=o(Pt,`, if
`),cs=a(Pt,"CODE",{});var tg=r(cs);Wi=o(tg,"constraints!=None"),tg.forEach(t),Ui=o(Pt," or "),ds=a(Pt,"CODE",{});var ng=r(ds);Ri=o(ng,"force_words_ids!=None"),ng.forEach(t),Pt.forEach(t),V.forEach(t),Hi=g(H),rn=a(H,"P",{});var Ka=r(rn);Vi=o(Ka,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019. To learn
more about decoding strategies refer to the `),co=a(Ka,"A",{href:!0});var og=r(co);Yi=o(og,"text generation strategies guide"),og.forEach(t),Ki=o(Ka,"."),Ka.forEach(t),Zi=g(H),Me=a(H,"DIV",{class:!0});var So=r(Me);j(ln.$$.fragment,So),Ji=g(So),cn=a(So,"P",{});var Za=r(cn);Xi=o(Za,"Instantiate a "),po=a(Za,"A",{href:!0});var sg=r(po);Qi=o(sg,"GenerationConfig"),sg.forEach(t),el=o(Za," from a generation configuration file."),Za.forEach(t),tl=g(So),j(st.$$.fragment,So),So.forEach(t),nl=g(H),at=a(H,"DIV",{class:!0});var Ja=r(at);j(dn.$$.fragment,Ja),ol=g(Ja),Z=a(Ja,"P",{});var qe=r(Z);sl=o(qe,"Instantiates a "),mo=a(qe,"A",{href:!0});var ag=r(mo);al=o(ag,"GenerationConfig"),ag.forEach(t),rl=o(qe," from a "),go=a(qe,"A",{href:!0});var rg=r(go);il=o(rg,"PretrainedConfig"),rg.forEach(t),ll=o(qe,`. This function is useful to convert legacy
`),uo=a(qe,"A",{href:!0});var ig=r(uo);cl=o(ig,"PretrainedConfig"),ig.forEach(t),dl=o(qe," objects, which may contain generation parameters, into a stand-alone "),ho=a(qe,"A",{href:!0});var lg=r(ho);pl=o(lg,"GenerationConfig"),lg.forEach(t),ml=o(qe,"."),qe.forEach(t),Ja.forEach(t),gl=g(H),rt=a(H,"DIV",{class:!0});var Xa=r(rt);j(pn.$$.fragment,Xa),ul=g(Xa),Ue=a(Xa,"P",{});var qo=r(Ue);hl=o(qo,"Save a generation configuration object to the directory "),ps=a(qo,"CODE",{});var cg=r(ps);fl=o(cg,"save_directory"),cg.forEach(t),_l=o(qo,`, so that it can be re-loaded using the
`),fo=a(qo,"A",{href:!0});var dg=r(fo);bl=o(dg,"from_pretrained()"),dg.forEach(t),vl=o(qo," class method."),qo.forEach(t),Xa.forEach(t),H.forEach(t),Na=g(l),Re=a(l,"H2",{class:!0});var Qa=r(Re);it=a(Qa,"A",{id:!0,class:!0,href:!0});var pg=r(it);ms=a(pg,"SPAN",{});var mg=r(ms);j(mn.$$.fragment,mg),mg.forEach(t),pg.forEach(t),xl=g(Qa),gs=a(Qa,"SPAN",{});var gg=r(gs);yl=o(gg,"GenerationMixin"),gg.forEach(t),Qa.forEach(t),Ia=g(l),S=a(l,"DIV",{class:!0});var P=r(S);j(gn.$$.fragment,P),kl=g(P),un=a(P,"P",{});var er=r(un);jl=o(er,"A class containing all functions for auto-regressive text generation, to be used as a mixin in "),_o=a(er,"A",{href:!0});var ug=r(_o);wl=o(ug,"PreTrainedModel"),ug.forEach(t),$l=o(er,"."),er.forEach(t),Ll=g(P),hn=a(P,"P",{});var tr=r(hn);Tl=o(tr,"The class exposes "),bo=a(tr,"A",{href:!0});var hg=r(bo);El=o(hg,"generate()"),hg.forEach(t),Ml=o(tr,", which can be used for:"),tr.forEach(t),Gl=g(P),W=a(P,"UL",{});var Y=r(W);he=a(Y,"LI",{});var Ft=r(he);us=a(Ft,"EM",{});var fg=r(us);Ol=o(fg,"greedy decoding"),fg.forEach(t),Cl=o(Ft," by calling "),vo=a(Ft,"A",{href:!0});var _g=r(vo);Sl=o(_g,"greedy_search()"),_g.forEach(t),ql=o(Ft," if "),hs=a(Ft,"CODE",{});var bg=r(hs);Pl=o(bg,"num_beams=1"),bg.forEach(t),Fl=o(Ft,` and
`),fs=a(Ft,"CODE",{});var vg=r(fs);Dl=o(vg,"do_sample=False"),vg.forEach(t),Ft.forEach(t),Al=g(Y),fe=a(Y,"LI",{});var Dt=r(fe);_s=a(Dt,"EM",{});var xg=r(_s);zl=o(xg,"contrastive search"),xg.forEach(t),Nl=o(Dt," by calling "),xo=a(Dt,"A",{href:!0});var yg=r(xo);Il=o(yg,"contrastive_search()"),yg.forEach(t),Bl=o(Dt," if "),bs=a(Dt,"CODE",{});var kg=r(bs);Wl=o(kg,"penalty_alpha>0"),kg.forEach(t),Ul=o(Dt,` and
`),vs=a(Dt,"CODE",{});var jg=r(vs);Rl=o(jg,"top_k>1"),jg.forEach(t),Dt.forEach(t),Hl=g(Y),_e=a(Y,"LI",{});var At=r(_e);xs=a(At,"EM",{});var wg=r(xs);Vl=o(wg,"multinomial sampling"),wg.forEach(t),Yl=o(At," by calling "),yo=a(At,"A",{href:!0});var $g=r(yo);Kl=o($g,"sample()"),$g.forEach(t),Zl=o(At," if "),ys=a(At,"CODE",{});var Lg=r(ys);Jl=o(Lg,"num_beams=1"),Lg.forEach(t),Xl=o(At,` and
`),ks=a(At,"CODE",{});var Tg=r(ks);Ql=o(Tg,"do_sample=True"),Tg.forEach(t),At.forEach(t),ec=g(Y),be=a(Y,"LI",{});var zt=r(be);js=a(zt,"EM",{});var Eg=r(js);tc=o(Eg,"beam-search decoding"),Eg.forEach(t),nc=o(zt," by calling "),ko=a(zt,"A",{href:!0});var Mg=r(ko);oc=o(Mg,"beam_search()"),Mg.forEach(t),sc=o(zt," if "),ws=a(zt,"CODE",{});var Gg=r(ws);ac=o(Gg,"num_beams>1"),Gg.forEach(t),rc=o(zt,` and
`),$s=a(zt,"CODE",{});var Og=r($s);ic=o(Og,"do_sample=False"),Og.forEach(t),zt.forEach(t),lc=g(Y),ve=a(Y,"LI",{});var Nt=r(ve);Ls=a(Nt,"EM",{});var Cg=r(Ls);cc=o(Cg,"beam-search multinomial sampling"),Cg.forEach(t),dc=o(Nt," by calling "),jo=a(Nt,"A",{href:!0});var Sg=r(jo);pc=o(Sg,"beam_sample()"),Sg.forEach(t),mc=o(Nt," if "),Ts=a(Nt,"CODE",{});var qg=r(Ts);gc=o(qg,"num_beams>1"),qg.forEach(t),uc=o(Nt,`
and `),Es=a(Nt,"CODE",{});var Pg=r(Es);hc=o(Pg,"do_sample=True"),Pg.forEach(t),Nt.forEach(t),fc=g(Y),xe=a(Y,"LI",{});var It=r(xe);Ms=a(It,"EM",{});var Fg=r(Ms);_c=o(Fg,"diverse beam-search decoding"),Fg.forEach(t),bc=o(It," by calling "),wo=a(It,"A",{href:!0});var Dg=r(wo);vc=o(Dg,"group_beam_search()"),Dg.forEach(t),xc=o(It,", if "),Gs=a(It,"CODE",{});var Ag=r(Gs);yc=o(Ag,"num_beams>1"),Ag.forEach(t),kc=o(It,`
and `),Os=a(It,"CODE",{});var zg=r(Os);jc=o(zg,"num_beam_groups>1"),zg.forEach(t),It.forEach(t),wc=g(Y),ye=a(Y,"LI",{});var Bt=r(ye);Cs=a(Bt,"EM",{});var Ng=r(Cs);$c=o(Ng,"constrained beam-search decoding"),Ng.forEach(t),Lc=o(Bt," by calling "),$o=a(Bt,"A",{href:!0});var Ig=r($o);Tc=o(Ig,"constrained_beam_search()"),Ig.forEach(t),Ec=o(Bt,`, if
`),Ss=a(Bt,"CODE",{});var Bg=r(Ss);Mc=o(Bg,"constraints!=None"),Bg.forEach(t),Gc=o(Bt," or "),qs=a(Bt,"CODE",{});var Wg=r(qs);Oc=o(Wg,"force_words_ids!=None"),Wg.forEach(t),Bt.forEach(t),Y.forEach(t),Cc=g(P),fn=a(P,"P",{});var nr=r(fn);Sc=o(nr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Lo=a(nr,"A",{href:!0});var Ug=r(Lo);qc=o(Ug,"text generation strategies guide"),Ug.forEach(t),Pc=o(nr,"."),nr.forEach(t),Fc=g(P),Ge=a(P,"DIV",{class:!0});var Po=r(Ge);j(_n.$$.fragment,Po),Dc=g(Po),Ps=a(Po,"P",{});var Rg=r(Ps);Ac=o(Rg,"Generates sequences of token ids for models with a language modeling head."),Rg.forEach(t),zc=g(Po),j(lt.$$.fragment,Po),Po.forEach(t),Nc=g(P),Oe=a(P,"DIV",{class:!0});var Fo=r(Oe);j(bn.$$.fragment,Fo),Ic=g(Fo),Fs=a(Fo,"P",{});var Hg=r(Fs);Bc=o(Hg,`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Hg.forEach(t),Wc=g(Fo),j(ct.$$.fragment,Fo),Fo.forEach(t),Uc=g(P),Q=a(P,"DIV",{class:!0});var Wt=r(Q);j(vn.$$.fragment,Wt),Rc=g(Wt),xn=a(Wt,"P",{});var or=r(xn);Hc=o(or,"Generates sequences of token ids for models with a language modeling head using "),Ds=a(or,"STRONG",{});var Vg=r(Ds);Vc=o(Vg,"greedy decoding"),Vg.forEach(t),Yc=o(or,` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),or.forEach(t),Kc=g(Wt),j(dt.$$.fragment,Wt),Zc=g(Wt),j(pt.$$.fragment,Wt),Wt.forEach(t),Jc=g(P),ee=a(P,"DIV",{class:!0});var Ut=r(ee);j(yn.$$.fragment,Ut),Xc=g(Ut),kn=a(Ut,"P",{});var sr=r(kn);Qc=o(sr,"Generates sequences of token ids for models with a language modeling head using "),As=a(sr,"STRONG",{});var Yg=r(As);ed=o(Yg,"multinomial sampling"),Yg.forEach(t),td=o(sr,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),sr.forEach(t),nd=g(Ut),j(mt.$$.fragment,Ut),od=g(Ut),j(gt.$$.fragment,Ut),Ut.forEach(t),sd=g(P),te=a(P,"DIV",{class:!0});var Rt=r(te);j(jn.$$.fragment,Rt),ad=g(Rt),wn=a(Rt,"P",{});var ar=r(wn);rd=o(ar,"Generates sequences of token ids for models with a language modeling head using "),zs=a(ar,"STRONG",{});var Kg=r(zs);id=o(Kg,"beam search decoding"),Kg.forEach(t),ld=o(ar,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),ar.forEach(t),cd=g(Rt),j(ut.$$.fragment,Rt),dd=g(Rt),j(ht.$$.fragment,Rt),Rt.forEach(t),pd=g(P),ne=a(P,"DIV",{class:!0});var Ht=r(ne);j($n.$$.fragment,Ht),md=g(Ht),Ln=a(Ht,"P",{});var rr=r(Ln);gd=o(rr,"Generates sequences of token ids for models with a language modeling head using "),Ns=a(rr,"STRONG",{});var Zg=r(Ns);ud=o(Zg,`beam search multinomial
sampling`),Zg.forEach(t),hd=o(rr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),rr.forEach(t),fd=g(Ht),j(ft.$$.fragment,Ht),_d=g(Ht),j(_t.$$.fragment,Ht),Ht.forEach(t),bd=g(P),oe=a(P,"DIV",{class:!0});var Vt=r(oe);j(Tn.$$.fragment,Vt),vd=g(Vt),En=a(Vt,"P",{});var ir=r(En);xd=o(ir,"Generates sequences of token ids for models with a language modeling head using "),Is=a(ir,"STRONG",{});var Jg=r(Is);yd=o(Jg,"contrastive search"),Jg.forEach(t),kd=o(ir,` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),ir.forEach(t),jd=g(Vt),j(bt.$$.fragment,Vt),wd=g(Vt),j(vt.$$.fragment,Vt),Vt.forEach(t),$d=g(P),se=a(P,"DIV",{class:!0});var Yt=r(se);j(Mn.$$.fragment,Yt),Ld=g(Yt),Gn=a(Yt,"P",{});var lr=r(Gn);Td=o(lr,"Generates sequences of token ids for models with a language modeling head using "),Bs=a(lr,"STRONG",{});var Xg=r(Bs);Ed=o(Xg,`diverse beam search
decoding`),Xg.forEach(t),Md=o(lr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),lr.forEach(t),Gd=g(Yt),j(xt.$$.fragment,Yt),Od=g(Yt),j(yt.$$.fragment,Yt),Yt.forEach(t),Cd=g(P),ae=a(P,"DIV",{class:!0});var Kt=r(ae);j(On.$$.fragment,Kt),Sd=g(Kt),Cn=a(Kt,"P",{});var cr=r(Cn);qd=o(cr,"Generates sequences of token ids for models with a language modeling head using "),Ws=a(cr,"STRONG",{});var Qg=r(Ws);Pd=o(Qg,`constrained beam search
decoding`),Qg.forEach(t),Fd=o(cr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),cr.forEach(t),Dd=g(Kt),j(kt.$$.fragment,Kt),Ad=g(Kt),j(jt.$$.fragment,Kt),Kt.forEach(t),P.forEach(t),Ba=g(l),He=a(l,"H2",{class:!0});var dr=r(He);wt=a(dr,"A",{id:!0,class:!0,href:!0});var eu=r(wt);Us=a(eu,"SPAN",{});var tu=r(Us);j(Sn.$$.fragment,tu),tu.forEach(t),eu.forEach(t),zd=g(dr),Rs=a(dr,"SPAN",{});var nu=r(Rs);Nd=o(nu,"TFGenerationMixin"),nu.forEach(t),dr.forEach(t),Wa=g(l),A=a(l,"DIV",{class:!0});var K=r(A);j(qn.$$.fragment,K),Id=g(K),Pn=a(K,"P",{});var pr=r(Pn);Bd=o(pr,"A class containing all of the functions supporting generation, to be used as a mixin in "),To=a(pr,"A",{href:!0});var ou=r(To);Wd=o(ou,"TFPreTrainedModel"),ou.forEach(t),Ud=o(pr,"."),pr.forEach(t),Rd=g(K),Fn=a(K,"P",{});var mr=r(Fn);Hd=o(mr,"The class exposes "),Eo=a(mr,"A",{href:!0});var su=r(Eo);Vd=o(su,"generate()"),su.forEach(t),Yd=o(mr,", which can be used for:"),mr.forEach(t),Kd=g(K),ke=a(K,"UL",{});var Zt=r(ke);je=a(Zt,"LI",{});var Jt=r(je);Hs=a(Jt,"EM",{});var au=r(Hs);Zd=o(au,"greedy decoding"),au.forEach(t),Jd=o(Jt," by calling "),Vs=a(Jt,"CODE",{});var ru=r(Vs);Xd=o(ru,"greedy_search()"),ru.forEach(t),Qd=o(Jt," if "),Ys=a(Jt,"CODE",{});var iu=r(Ys);ep=o(iu,"num_beams=1"),iu.forEach(t),tp=o(Jt,` and
`),Ks=a(Jt,"CODE",{});var lu=r(Ks);np=o(lu,"do_sample=False"),lu.forEach(t),Jt.forEach(t),op=g(Zt),we=a(Zt,"LI",{});var Xt=r(we);Zs=a(Xt,"EM",{});var cu=r(Zs);sp=o(cu,"contrastive search"),cu.forEach(t),ap=o(Xt," by calling "),Js=a(Xt,"CODE",{});var du=r(Js);rp=o(du,"contrastive_search()"),du.forEach(t),ip=o(Xt," if "),Xs=a(Xt,"CODE",{});var pu=r(Xs);lp=o(pu,"penalty_alpha>0"),pu.forEach(t),cp=o(Xt,` and
`),Qs=a(Xt,"CODE",{});var mu=r(Qs);dp=o(mu,"top_k>1"),mu.forEach(t),Xt.forEach(t),pp=g(Zt),$e=a(Zt,"LI",{});var Qt=r($e);ea=a(Qt,"EM",{});var gu=r(ea);mp=o(gu,"multinomial sampling"),gu.forEach(t),gp=o(Qt," by calling "),ta=a(Qt,"CODE",{});var uu=r(ta);up=o(uu,"sample()"),uu.forEach(t),hp=o(Qt," if "),na=a(Qt,"CODE",{});var hu=r(na);fp=o(hu,"num_beams=1"),hu.forEach(t),_p=o(Qt,` and
`),oa=a(Qt,"CODE",{});var fu=r(oa);bp=o(fu,"do_sample=True"),fu.forEach(t),Qt.forEach(t),vp=g(Zt),Ve=a(Zt,"LI",{});var Do=r(Ve);sa=a(Do,"EM",{});var _u=r(sa);xp=o(_u,"beam-search decoding"),_u.forEach(t),yp=o(Do," by calling "),aa=a(Do,"CODE",{});var bu=r(aa);kp=o(bu,"beam_search()"),bu.forEach(t),jp=o(Do," if "),ra=a(Do,"CODE",{});var vu=r(ra);wp=o(vu,"num_beams>1"),vu.forEach(t),Do.forEach(t),Zt.forEach(t),$p=g(K),Dn=a(K,"P",{});var gr=r(Dn);Lp=o(gr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Mo=a(gr,"A",{href:!0});var xu=r(Mo);Tp=o(xu,"text generation strategies guide"),xu.forEach(t),Ep=o(gr,"."),gr.forEach(t),Mp=g(K),Ce=a(K,"DIV",{class:!0});var Ao=r(Ce);j(An.$$.fragment,Ao),Gp=g(Ao),ia=a(Ao,"P",{});var yu=r(ia);Op=o(yu,"Generates sequences of token ids for models with a language modeling head."),yu.forEach(t),Cp=g(Ao),j($t.$$.fragment,Ao),Ao.forEach(t),Sp=g(K),Se=a(K,"DIV",{class:!0});var zo=r(Se);j(zn.$$.fragment,zo),qp=g(zo),la=a(zo,"P",{});var ku=r(la);Pp=o(ku,`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),ku.forEach(t),Fp=g(zo),j(Lt.$$.fragment,zo),zo.forEach(t),K.forEach(t),Ua=g(l),Ye=a(l,"H2",{class:!0});var ur=r(Ye);Tt=a(ur,"A",{id:!0,class:!0,href:!0});var ju=r(Tt);ca=a(ju,"SPAN",{});var wu=r(ca);j(Nn.$$.fragment,wu),wu.forEach(t),ju.forEach(t),Dp=g(ur),da=a(ur,"SPAN",{});var $u=r(da);Ap=o($u,"FlaxGenerationMixin"),$u.forEach(t),ur.forEach(t),Ra=g(l),U=a(l,"DIV",{class:!0});var re=r(U);j(In.$$.fragment,re),zp=g(re),Bn=a(re,"P",{});var hr=r(Bn);Np=o(hr,`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),Go=a(hr,"A",{href:!0});var Lu=r(Go);Ip=o(Lu,"FlaxPreTrainedModel"),Lu.forEach(t),Bp=o(hr,"."),hr.forEach(t),Wp=g(re),Wn=a(re,"P",{});var fr=r(Wn);Up=o(fr,"The class exposes "),Oo=a(fr,"A",{href:!0});var Tu=r(Oo);Rp=o(Tu,"generate()"),Tu.forEach(t),Hp=o(fr,", which can be used for:"),fr.forEach(t),Vp=g(re),Ke=a(re,"UL",{});var No=r(Ke);Le=a(No,"LI",{});var en=r(Le);pa=a(en,"EM",{});var Eu=r(pa);Yp=o(Eu,"greedy decoding"),Eu.forEach(t),Kp=o(en," by calling "),ma=a(en,"CODE",{});var Mu=r(ma);Zp=o(Mu,"_greedy_search()"),Mu.forEach(t),Jp=o(en," if "),ga=a(en,"CODE",{});var Gu=r(ga);Xp=o(Gu,"num_beams=1"),Gu.forEach(t),Qp=o(en,` and
`),ua=a(en,"CODE",{});var Ou=r(ua);em=o(Ou,"do_sample=False"),Ou.forEach(t),en.forEach(t),tm=g(No),Te=a(No,"LI",{});var tn=r(Te);ha=a(tn,"EM",{});var Cu=r(ha);nm=o(Cu,"multinomial sampling"),Cu.forEach(t),om=o(tn," by calling "),fa=a(tn,"CODE",{});var Su=r(fa);sm=o(Su,"_sample()"),Su.forEach(t),am=o(tn," if "),_a=a(tn,"CODE",{});var qu=r(_a);rm=o(qu,"num_beams=1"),qu.forEach(t),im=o(tn,` and
`),ba=a(tn,"CODE",{});var Pu=r(ba);lm=o(Pu,"do_sample=True"),Pu.forEach(t),tn.forEach(t),cm=g(No),Ee=a(No,"LI",{});var nn=r(Ee);va=a(nn,"EM",{});var Fu=r(va);dm=o(Fu,"beam-search decoding"),Fu.forEach(t),pm=o(nn," by calling "),xa=a(nn,"CODE",{});var Du=r(xa);mm=o(Du,"_beam_search()"),Du.forEach(t),gm=o(nn," if "),ya=a(nn,"CODE",{});var Au=r(ya);um=o(Au,"num_beams>1"),Au.forEach(t),hm=o(nn,` and
`),ka=a(nn,"CODE",{});var zu=r(ka);fm=o(zu,"do_sample=False"),zu.forEach(t),nn.forEach(t),No.forEach(t),_m=g(re),Un=a(re,"P",{});var _r=r(Un);bm=o(_r,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Co=a(_r,"A",{href:!0});var Nu=r(Co);vm=o(Nu,"text generation strategies guide"),Nu.forEach(t),xm=o(_r,"."),_r.forEach(t),ym=g(re),Et=a(re,"DIV",{class:!0});var br=r(Et);j(Rn.$$.fragment,br),km=g(br),ja=a(br,"P",{});var Iu=r(ja);jm=o(Iu,"Generates sequences of token ids for models with a language modeling head."),Iu.forEach(t),br.forEach(t),re.forEach(t),this.h()},h(){h(c,"name","hf:doc:metadata"),h(c,"content",JSON.stringify(gh)),h(d,"id","generation"),h(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(d,"href","#generation"),h(p,"class","relative group"),h(X,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.generate"),h(R,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin"),h(Zn,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),h(Jn,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.TFGenerationMixin"),h(Xn,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),h(Qn,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.FlaxGenerationMixin"),h(eo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig"),h(to,"href","../generation_strategies"),h(ot,"id","transformers.GenerationConfig"),h(ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ot,"href","#transformers.GenerationConfig"),h(We,"class","relative group"),h(no,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),h(oo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),h(so,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.sample"),h(ao,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),h(ro,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),h(io,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),h(lo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),h(co,"href","./generation_strategies"),h(po,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig"),h(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(mo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig"),h(go,"href","/docs/transformers/v4.27.2/en/main_classes/configuration#transformers.PretrainedConfig"),h(uo,"href","/docs/transformers/v4.27.2/en/main_classes/configuration#transformers.PretrainedConfig"),h(ho,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig"),h(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(fo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained"),h(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(it,"id","transformers.GenerationMixin"),h(it,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(it,"href","#transformers.GenerationMixin"),h(Re,"class","relative group"),h(_o,"href","/docs/transformers/v4.27.2/en/main_classes/model#transformers.PreTrainedModel"),h(bo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.generate"),h(vo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),h(xo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),h(yo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.sample"),h(ko,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),h(jo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),h(wo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),h($o,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),h(Lo,"href","../generation_strategies"),h(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(wt,"id","transformers.TFGenerationMixin"),h(wt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(wt,"href","#transformers.TFGenerationMixin"),h(He,"class","relative group"),h(To,"href","/docs/transformers/v4.27.2/en/main_classes/model#transformers.TFPreTrainedModel"),h(Eo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),h(Mo,"href","../generation_strategies"),h(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Tt,"id","transformers.FlaxGenerationMixin"),h(Tt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Tt,"href","#transformers.FlaxGenerationMixin"),h(Ye,"class","relative group"),h(Go,"href","/docs/transformers/v4.27.2/en/main_classes/model#transformers.FlaxPreTrainedModel"),h(Oo,"href","/docs/transformers/v4.27.2/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),h(Co,"href","../generation_strategies"),h(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(l,v){e(document.head,c),x(l,_,v),x(l,p,v),e(p,d),e(d,f),w(i,f,null),e(p,u),e(p,E),e(E,y),x(l,b,v),x(l,G,v),e(G,O),e(G,F),e(F,ie),e(G,I),x(l,J,v),x(l,N,v),e(N,C),e(C,q),e(C,X),e(X,Ae),e(C,ze),e(C,R),e(R,Ne),e(C,vr),e(N,xr),e(N,Ie),e(Ie,yr),e(Ie,Zn),e(Zn,kr),e(Ie,jr),e(Ie,Jn),e(Jn,wr),e(Ie,$r),e(N,Lr),e(N,Be),e(Be,Tr),e(Be,Xn),e(Xn,Er),e(Be,Mr),e(Be,Qn),e(Qn,Gr),e(Be,Or),x(l,Fa,v),x(l,tt,v),e(tt,Cr),e(tt,eo),e(eo,Sr),e(tt,qr),x(l,Da,v),x(l,nt,v),e(nt,Pr),e(nt,to),e(to,Fr),e(nt,Dr),x(l,Aa,v),x(l,We,v),e(We,ot),e(ot,Io),w(on,Io,null),e(We,Ar),e(We,Bo),e(Bo,zr),x(l,za,v),x(l,D,v),w(sn,D,null),e(D,Nr),e(D,an),e(an,Ir),e(an,Wo),e(Wo,Br),e(an,Wr),e(D,Ur),e(D,B),e(B,le),e(le,Uo),e(Uo,Rr),e(le,Hr),e(le,no),e(no,Vr),e(le,Yr),e(le,Ro),e(Ro,Kr),e(le,Zr),e(le,Ho),e(Ho,Jr),e(B,Xr),e(B,ce),e(ce,Vo),e(Vo,Qr),e(ce,ei),e(ce,oo),e(oo,ti),e(ce,ni),e(ce,Yo),e(Yo,oi),e(ce,si),e(ce,Ko),e(Ko,ai),e(B,ri),e(B,de),e(de,Zo),e(Zo,ii),e(de,li),e(de,so),e(so,ci),e(de,di),e(de,Jo),e(Jo,pi),e(de,mi),e(de,Xo),e(Xo,gi),e(B,ui),e(B,pe),e(pe,Qo),e(Qo,hi),e(pe,fi),e(pe,ao),e(ao,_i),e(pe,bi),e(pe,es),e(es,vi),e(pe,xi),e(pe,ts),e(ts,yi),e(B,ki),e(B,me),e(me,ns),e(ns,ji),e(me,wi),e(me,ro),e(ro,$i),e(me,Li),e(me,os),e(os,Ti),e(me,Ei),e(me,ss),e(ss,Mi),e(B,Gi),e(B,ge),e(ge,as),e(as,Oi),e(ge,Ci),e(ge,io),e(io,Si),e(ge,qi),e(ge,rs),e(rs,Pi),e(ge,Fi),e(ge,is),e(is,Di),e(B,Ai),e(B,ue),e(ue,ls),e(ls,zi),e(ue,Ni),e(ue,lo),e(lo,Ii),e(ue,Bi),e(ue,cs),e(cs,Wi),e(ue,Ui),e(ue,ds),e(ds,Ri),e(D,Hi),e(D,rn),e(rn,Vi),e(rn,co),e(co,Yi),e(rn,Ki),e(D,Zi),e(D,Me),w(ln,Me,null),e(Me,Ji),e(Me,cn),e(cn,Xi),e(cn,po),e(po,Qi),e(cn,el),e(Me,tl),w(st,Me,null),e(D,nl),e(D,at),w(dn,at,null),e(at,ol),e(at,Z),e(Z,sl),e(Z,mo),e(mo,al),e(Z,rl),e(Z,go),e(go,il),e(Z,ll),e(Z,uo),e(uo,cl),e(Z,dl),e(Z,ho),e(ho,pl),e(Z,ml),e(D,gl),e(D,rt),w(pn,rt,null),e(rt,ul),e(rt,Ue),e(Ue,hl),e(Ue,ps),e(ps,fl),e(Ue,_l),e(Ue,fo),e(fo,bl),e(Ue,vl),x(l,Na,v),x(l,Re,v),e(Re,it),e(it,ms),w(mn,ms,null),e(Re,xl),e(Re,gs),e(gs,yl),x(l,Ia,v),x(l,S,v),w(gn,S,null),e(S,kl),e(S,un),e(un,jl),e(un,_o),e(_o,wl),e(un,$l),e(S,Ll),e(S,hn),e(hn,Tl),e(hn,bo),e(bo,El),e(hn,Ml),e(S,Gl),e(S,W),e(W,he),e(he,us),e(us,Ol),e(he,Cl),e(he,vo),e(vo,Sl),e(he,ql),e(he,hs),e(hs,Pl),e(he,Fl),e(he,fs),e(fs,Dl),e(W,Al),e(W,fe),e(fe,_s),e(_s,zl),e(fe,Nl),e(fe,xo),e(xo,Il),e(fe,Bl),e(fe,bs),e(bs,Wl),e(fe,Ul),e(fe,vs),e(vs,Rl),e(W,Hl),e(W,_e),e(_e,xs),e(xs,Vl),e(_e,Yl),e(_e,yo),e(yo,Kl),e(_e,Zl),e(_e,ys),e(ys,Jl),e(_e,Xl),e(_e,ks),e(ks,Ql),e(W,ec),e(W,be),e(be,js),e(js,tc),e(be,nc),e(be,ko),e(ko,oc),e(be,sc),e(be,ws),e(ws,ac),e(be,rc),e(be,$s),e($s,ic),e(W,lc),e(W,ve),e(ve,Ls),e(Ls,cc),e(ve,dc),e(ve,jo),e(jo,pc),e(ve,mc),e(ve,Ts),e(Ts,gc),e(ve,uc),e(ve,Es),e(Es,hc),e(W,fc),e(W,xe),e(xe,Ms),e(Ms,_c),e(xe,bc),e(xe,wo),e(wo,vc),e(xe,xc),e(xe,Gs),e(Gs,yc),e(xe,kc),e(xe,Os),e(Os,jc),e(W,wc),e(W,ye),e(ye,Cs),e(Cs,$c),e(ye,Lc),e(ye,$o),e($o,Tc),e(ye,Ec),e(ye,Ss),e(Ss,Mc),e(ye,Gc),e(ye,qs),e(qs,Oc),e(S,Cc),e(S,fn),e(fn,Sc),e(fn,Lo),e(Lo,qc),e(fn,Pc),e(S,Fc),e(S,Ge),w(_n,Ge,null),e(Ge,Dc),e(Ge,Ps),e(Ps,Ac),e(Ge,zc),w(lt,Ge,null),e(S,Nc),e(S,Oe),w(bn,Oe,null),e(Oe,Ic),e(Oe,Fs),e(Fs,Bc),e(Oe,Wc),w(ct,Oe,null),e(S,Uc),e(S,Q),w(vn,Q,null),e(Q,Rc),e(Q,xn),e(xn,Hc),e(xn,Ds),e(Ds,Vc),e(xn,Yc),e(Q,Kc),w(dt,Q,null),e(Q,Zc),w(pt,Q,null),e(S,Jc),e(S,ee),w(yn,ee,null),e(ee,Xc),e(ee,kn),e(kn,Qc),e(kn,As),e(As,ed),e(kn,td),e(ee,nd),w(mt,ee,null),e(ee,od),w(gt,ee,null),e(S,sd),e(S,te),w(jn,te,null),e(te,ad),e(te,wn),e(wn,rd),e(wn,zs),e(zs,id),e(wn,ld),e(te,cd),w(ut,te,null),e(te,dd),w(ht,te,null),e(S,pd),e(S,ne),w($n,ne,null),e(ne,md),e(ne,Ln),e(Ln,gd),e(Ln,Ns),e(Ns,ud),e(Ln,hd),e(ne,fd),w(ft,ne,null),e(ne,_d),w(_t,ne,null),e(S,bd),e(S,oe),w(Tn,oe,null),e(oe,vd),e(oe,En),e(En,xd),e(En,Is),e(Is,yd),e(En,kd),e(oe,jd),w(bt,oe,null),e(oe,wd),w(vt,oe,null),e(S,$d),e(S,se),w(Mn,se,null),e(se,Ld),e(se,Gn),e(Gn,Td),e(Gn,Bs),e(Bs,Ed),e(Gn,Md),e(se,Gd),w(xt,se,null),e(se,Od),w(yt,se,null),e(S,Cd),e(S,ae),w(On,ae,null),e(ae,Sd),e(ae,Cn),e(Cn,qd),e(Cn,Ws),e(Ws,Pd),e(Cn,Fd),e(ae,Dd),w(kt,ae,null),e(ae,Ad),w(jt,ae,null),x(l,Ba,v),x(l,He,v),e(He,wt),e(wt,Us),w(Sn,Us,null),e(He,zd),e(He,Rs),e(Rs,Nd),x(l,Wa,v),x(l,A,v),w(qn,A,null),e(A,Id),e(A,Pn),e(Pn,Bd),e(Pn,To),e(To,Wd),e(Pn,Ud),e(A,Rd),e(A,Fn),e(Fn,Hd),e(Fn,Eo),e(Eo,Vd),e(Fn,Yd),e(A,Kd),e(A,ke),e(ke,je),e(je,Hs),e(Hs,Zd),e(je,Jd),e(je,Vs),e(Vs,Xd),e(je,Qd),e(je,Ys),e(Ys,ep),e(je,tp),e(je,Ks),e(Ks,np),e(ke,op),e(ke,we),e(we,Zs),e(Zs,sp),e(we,ap),e(we,Js),e(Js,rp),e(we,ip),e(we,Xs),e(Xs,lp),e(we,cp),e(we,Qs),e(Qs,dp),e(ke,pp),e(ke,$e),e($e,ea),e(ea,mp),e($e,gp),e($e,ta),e(ta,up),e($e,hp),e($e,na),e(na,fp),e($e,_p),e($e,oa),e(oa,bp),e(ke,vp),e(ke,Ve),e(Ve,sa),e(sa,xp),e(Ve,yp),e(Ve,aa),e(aa,kp),e(Ve,jp),e(Ve,ra),e(ra,wp),e(A,$p),e(A,Dn),e(Dn,Lp),e(Dn,Mo),e(Mo,Tp),e(Dn,Ep),e(A,Mp),e(A,Ce),w(An,Ce,null),e(Ce,Gp),e(Ce,ia),e(ia,Op),e(Ce,Cp),w($t,Ce,null),e(A,Sp),e(A,Se),w(zn,Se,null),e(Se,qp),e(Se,la),e(la,Pp),e(Se,Fp),w(Lt,Se,null),x(l,Ua,v),x(l,Ye,v),e(Ye,Tt),e(Tt,ca),w(Nn,ca,null),e(Ye,Dp),e(Ye,da),e(da,Ap),x(l,Ra,v),x(l,U,v),w(In,U,null),e(U,zp),e(U,Bn),e(Bn,Np),e(Bn,Go),e(Go,Ip),e(Bn,Bp),e(U,Wp),e(U,Wn),e(Wn,Up),e(Wn,Oo),e(Oo,Rp),e(Wn,Hp),e(U,Vp),e(U,Ke),e(Ke,Le),e(Le,pa),e(pa,Yp),e(Le,Kp),e(Le,ma),e(ma,Zp),e(Le,Jp),e(Le,ga),e(ga,Xp),e(Le,Qp),e(Le,ua),e(ua,em),e(Ke,tm),e(Ke,Te),e(Te,ha),e(ha,nm),e(Te,om),e(Te,fa),e(fa,sm),e(Te,am),e(Te,_a),e(_a,rm),e(Te,im),e(Te,ba),e(ba,lm),e(Ke,cm),e(Ke,Ee),e(Ee,va),e(va,dm),e(Ee,pm),e(Ee,xa),e(xa,mm),e(Ee,gm),e(Ee,ya),e(ya,um),e(Ee,hm),e(Ee,ka),e(ka,fm),e(U,_m),e(U,Un),e(Un,bm),e(Un,Co),e(Co,vm),e(Un,xm),e(U,ym),e(U,Et),w(Rn,Et,null),e(Et,km),e(Et,ja),e(ja,jm),Ha=!0},p(l,[v]){const Hn={};v&2&&(Hn.$$scope={dirty:v,ctx:l}),st.$set(Hn);const wa={};v&2&&(wa.$$scope={dirty:v,ctx:l}),lt.$set(wa);const $a={};v&2&&($a.$$scope={dirty:v,ctx:l}),ct.$set($a);const La={};v&2&&(La.$$scope={dirty:v,ctx:l}),dt.$set(La);const Vn={};v&2&&(Vn.$$scope={dirty:v,ctx:l}),pt.$set(Vn);const Ta={};v&2&&(Ta.$$scope={dirty:v,ctx:l}),mt.$set(Ta);const Ze={};v&2&&(Ze.$$scope={dirty:v,ctx:l}),gt.$set(Ze);const Je={};v&2&&(Je.$$scope={dirty:v,ctx:l}),ut.$set(Je);const Ea={};v&2&&(Ea.$$scope={dirty:v,ctx:l}),ht.$set(Ea);const Ma={};v&2&&(Ma.$$scope={dirty:v,ctx:l}),ft.$set(Ma);const Xe={};v&2&&(Xe.$$scope={dirty:v,ctx:l}),_t.$set(Xe);const Ga={};v&2&&(Ga.$$scope={dirty:v,ctx:l}),bt.$set(Ga);const Oa={};v&2&&(Oa.$$scope={dirty:v,ctx:l}),vt.$set(Oa);const Qe={};v&2&&(Qe.$$scope={dirty:v,ctx:l}),xt.$set(Qe);const Ca={};v&2&&(Ca.$$scope={dirty:v,ctx:l}),yt.$set(Ca);const Sa={};v&2&&(Sa.$$scope={dirty:v,ctx:l}),kt.$set(Sa);const Yn={};v&2&&(Yn.$$scope={dirty:v,ctx:l}),jt.$set(Yn);const qa={};v&2&&(qa.$$scope={dirty:v,ctx:l}),$t.$set(qa);const Kn={};v&2&&(Kn.$$scope={dirty:v,ctx:l}),Lt.$set(Kn)},i(l){Ha||($(i.$$.fragment,l),$(on.$$.fragment,l),$(sn.$$.fragment,l),$(ln.$$.fragment,l),$(st.$$.fragment,l),$(dn.$$.fragment,l),$(pn.$$.fragment,l),$(mn.$$.fragment,l),$(gn.$$.fragment,l),$(_n.$$.fragment,l),$(lt.$$.fragment,l),$(bn.$$.fragment,l),$(ct.$$.fragment,l),$(vn.$$.fragment,l),$(dt.$$.fragment,l),$(pt.$$.fragment,l),$(yn.$$.fragment,l),$(mt.$$.fragment,l),$(gt.$$.fragment,l),$(jn.$$.fragment,l),$(ut.$$.fragment,l),$(ht.$$.fragment,l),$($n.$$.fragment,l),$(ft.$$.fragment,l),$(_t.$$.fragment,l),$(Tn.$$.fragment,l),$(bt.$$.fragment,l),$(vt.$$.fragment,l),$(Mn.$$.fragment,l),$(xt.$$.fragment,l),$(yt.$$.fragment,l),$(On.$$.fragment,l),$(kt.$$.fragment,l),$(jt.$$.fragment,l),$(Sn.$$.fragment,l),$(qn.$$.fragment,l),$(An.$$.fragment,l),$($t.$$.fragment,l),$(zn.$$.fragment,l),$(Lt.$$.fragment,l),$(Nn.$$.fragment,l),$(In.$$.fragment,l),$(Rn.$$.fragment,l),Ha=!0)},o(l){L(i.$$.fragment,l),L(on.$$.fragment,l),L(sn.$$.fragment,l),L(ln.$$.fragment,l),L(st.$$.fragment,l),L(dn.$$.fragment,l),L(pn.$$.fragment,l),L(mn.$$.fragment,l),L(gn.$$.fragment,l),L(_n.$$.fragment,l),L(lt.$$.fragment,l),L(bn.$$.fragment,l),L(ct.$$.fragment,l),L(vn.$$.fragment,l),L(dt.$$.fragment,l),L(pt.$$.fragment,l),L(yn.$$.fragment,l),L(mt.$$.fragment,l),L(gt.$$.fragment,l),L(jn.$$.fragment,l),L(ut.$$.fragment,l),L(ht.$$.fragment,l),L($n.$$.fragment,l),L(ft.$$.fragment,l),L(_t.$$.fragment,l),L(Tn.$$.fragment,l),L(bt.$$.fragment,l),L(vt.$$.fragment,l),L(Mn.$$.fragment,l),L(xt.$$.fragment,l),L(yt.$$.fragment,l),L(On.$$.fragment,l),L(kt.$$.fragment,l),L(jt.$$.fragment,l),L(Sn.$$.fragment,l),L(qn.$$.fragment,l),L(An.$$.fragment,l),L($t.$$.fragment,l),L(zn.$$.fragment,l),L(Lt.$$.fragment,l),L(Nn.$$.fragment,l),L(In.$$.fragment,l),L(Rn.$$.fragment,l),Ha=!1},d(l){t(c),l&&t(_),l&&t(p),T(i),l&&t(b),l&&t(G),l&&t(J),l&&t(N),l&&t(Fa),l&&t(tt),l&&t(Da),l&&t(nt),l&&t(Aa),l&&t(We),T(on),l&&t(za),l&&t(D),T(sn),T(ln),T(st),T(dn),T(pn),l&&t(Na),l&&t(Re),T(mn),l&&t(Ia),l&&t(S),T(gn),T(_n),T(lt),T(bn),T(ct),T(vn),T(dt),T(pt),T(yn),T(mt),T(gt),T(jn),T(ut),T(ht),T($n),T(ft),T(_t),T(Tn),T(bt),T(vt),T(Mn),T(xt),T(yt),T(On),T(kt),T(jt),l&&t(Ba),l&&t(He),T(Sn),l&&t(Wa),l&&t(A),T(qn),T(An),T($t),T(zn),T(Lt),l&&t(Ua),l&&t(Ye),T(Nn),l&&t(Ra),l&&t(U),T(In),T(Rn)}}}const gh={local:"generation",sections:[{local:"transformers.GenerationConfig",title:"GenerationConfig"},{local:"transformers.GenerationMixin",title:"GenerationMixin"},{local:"transformers.TFGenerationMixin",title:"TFGenerationMixin"},{local:"transformers.FlaxGenerationMixin",title:"FlaxGenerationMixin"}],title:"Generation"};function uh(M){return Hu(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yh extends Bu{constructor(c){super();Wu(this,c,uh,mh,Uu,{})}}export{yh as default,gh as metadata};
