import{S as Ch,i as Sh,s as Ph,e as s,k as m,w as k,t,M as qh,c as a,d as o,m as g,a as r,x as w,h as n,b as u,G as e,g as y,y as j,q as $,o as L,B as E,v as Dh,L as Xe}from"../../chunks/vendor-hf-doc-builder.js";import{T as Ze}from"../../chunks/Tip-hf-doc-builder.js";import{D as z}from"../../chunks/Docstring-hf-doc-builder.js";import{C as Qe}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as Ma}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as Je}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function Ah(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import GenerationConfig

# Download configuration from huggingface.co and cache.
generation_config = GenerationConfig.from_pretrained("gpt2")

# E.g. config was saved using *save_pretrained('./test/saved_model/')*
generation_config.save_pretrained("./test/saved_model/")
generation_config = GenerationConfig.from_pretrained("./test/saved_model/")

# You can also specify configuration names to your generation configuration file
generation_config.save_pretrained("./test/saved_model/", config_file_name="my_configuration.json")
generation_config = GenerationConfig.from_pretrained("./test/saved_model/", "my_configuration.json")

# If you'd like to try a minor variation to an existing configuration, you can also pass generation
# arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored
generation_config, unused_kwargs = GenerationConfig.from_pretrained(
    "gpt2", top_k=1, foo=False, return_unused_kwargs=True
)
generation_config.top_k

unused_kwargs`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function Fh(M){let c,_,p,d,f,i,h,T,x,b,G,O,D,ie,N,Z,F;return{c(){c=s("p"),_=t("Most generation-controlling parameters are set in "),p=s("code"),d=t("generation_config"),f=t(` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=s("code"),h=t("generation_config"),T=t(` by passing the corresponding
parameters to generate(), e.g. `),x=s("code"),b=t(".generate(inputs, num_beams=4, do_sample=True)"),G=t("."),O=m(),D=s("p"),ie=t("For an overview of generation strategies and code examples, check out the "),N=s("a"),Z=t(`following
guide`),F=t("."),this.h()},l(C){c=a(C,"P",{});var P=r(c);_=n(P,"Most generation-controlling parameters are set in "),p=a(P,"CODE",{});var J=r(p);d=n(J,"generation_config"),J.forEach(o),f=n(P,` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=a(P,"CODE",{});var Pe=r(i);h=n(Pe,"generation_config"),Pe.forEach(o),T=n(P,` by passing the corresponding
parameters to generate(), e.g. `),x=a(P,"CODE",{});var qe=r(x);b=n(qe,".generate(inputs, num_beams=4, do_sample=True)"),qe.forEach(o),G=n(P,"."),P.forEach(o),O=g(C),D=a(C,"P",{});var R=r(D);ie=n(R,"For an overview of generation strategies and code examples, check out the "),N=a(R,"A",{href:!0});var De=r(N);Z=n(De,`following
guide`),De.forEach(o),F=n(R,"."),R.forEach(o),this.h()},h(){u(N,"href","./generation_strategies")},m(C,P){y(C,c,P),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T),e(c,x),e(x,b),e(c,G),y(C,O,P),y(C,D,P),e(D,ie),e(D,N),e(N,Z),e(D,F)},d(C){C&&o(c),C&&o(O),C&&o(D)}}}function zh(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import GPT2Tokenizer, AutoModelForCausalLM
import numpy as np

tokenizer = GPT2Tokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")
tokenizer.pad_token_id = tokenizer.eos_token_id
inputs = tokenizer(["Today is"], return_tensors="pt")

# Example 1: Print the scores for each token generated with Greedy Search
outputs = model.generate(**inputs, max_new_tokens=5, return_dict_in_generate=True, output_scores=True)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, normalize_logits=True
)
input_length = inputs.input_ids.shape[1]
generated_tokens = outputs.sequences[:, input_length:]
for tok, score in zip(generated_tokens[0], transition_scores[0]):
    # | token | token string | logits | probability
    print(f"| {tok:5d} | {tokenizer.decode(tok):8s} | {score.numpy():.3f} | {np.exp(score.numpy()):.2%}")

# Example 2: Reconstruct the sequence scores from Beam Search
outputs = model.generate(
    **inputs,
    max_new_tokens=5,
    num_beams=4,
    num_return_sequences=4,
    return_dict_in_generate=True,
    output_scores=True,
)
transition_scores = model.compute_transition_scores(
    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=False
)
# If you sum the generated tokens' scores and apply the length penalty, you'll get the sequence scores.
# Tip: set \`normalize_logits=True\` to recompute the scores from the normalized logits.
output_length = inputs.input_ids.shape[1] + np.sum(transition_scores.numpy() < 0, axis=1)
length_penalty = model.generation_config.length_penalty
reconstructed_scores = transition_scores.sum(axis=1) / (output_length**length_penalty)
print(np.allclose(outputs.sequences_scores, reconstructed_scores))`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: set \`normalize_logits=True\` to recompute the scores from the normalized logits.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function Nh(M){let c,_,p,d,f,i,h,T;return{c(){c=s("p"),_=t("In most cases, you do not need to call "),p=s("a"),d=t("greedy_search()"),f=t(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=s("a"),h=t(`following
guide`),T=t("."),this.h()},l(x){c=a(x,"P",{});var b=r(c);_=n(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=n(G,"greedy_search()"),G.forEach(o),f=n(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=n(O,`following
guide`),O.forEach(o),T=n(b,"."),b.forEach(o),this.h()},h(){u(p,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(i,"href","./generation_strategies")},m(x,b){y(x,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T)},d(x){x&&o(c)}}}function Ih(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    StoppingCriteriaList,
    MaxLengthCriteria,
)

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

# set pad_token_id to eos_token_id because GPT2 does not have a PAD token
model.generation_config.pad_token_id = model.generation_config.eos_token_id

input_prompt = "It might be possible to"
input_ids = tokenizer(input_prompt, return_tensors="pt").input_ids

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(10, eos_token_id=model.generation_config.eos_token_id),
    ]
)
stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=20)])

outputs = model.greedy_search(
    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.generation_config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;It might be possible to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">10</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.greedy_search(
<span class="hljs-meta">... </span>    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;It might be possible to get a better understanding of the nature of the problem, but it&#x27;s not&quot;</span>]`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function Bh(M){let c,_,p,d,f,i,h,T;return{c(){c=s("p"),_=t("In most cases, you do not need to call "),p=s("a"),d=t("sample()"),f=t(` directly. Use generate() instead.
For an overview of generation strategies and code examples, check the `),i=s("a"),h=t(`following
guide`),T=t("."),this.h()},l(x){c=a(x,"P",{});var b=r(c);_=n(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=n(G,"sample()"),G.forEach(o),f=n(b,` directly. Use generate() instead.
For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=n(O,`following
guide`),O.forEach(o),T=n(b,"."),b.forEach(o),this.h()},h(){u(p,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(i,"href","./generation_strategies")},m(x,b){y(x,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T)},d(x){x&&o(c)}}}function Wh(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    TopKLogitsWarper,
    TemperatureLogitsWarper,
    StoppingCriteriaList,
    MaxLengthCriteria,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("gpt2")
model = AutoModelForCausalLM.from_pretrained("gpt2")

# set pad_token_id to eos_token_id because GPT2 does not have a EOS token
model.config.pad_token_id = model.config.eos_token_id
model.generation_config.pad_token_id = model.config.eos_token_id

input_prompt = "Today is a beautiful day, and"
input_ids = tokenizer(input_prompt, return_tensors="pt").input_ids

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(15, eos_token_id=model.generation_config.eos_token_id),
    ]
)
# instantiate logits processors
logits_warper = LogitsProcessorList(
    [
        TopKLogitsWarper(50),
        TemperatureLogitsWarper(0.7),
    ]
)

stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=20)])

torch.manual_seed(0)
outputs = model.sample(
    input_ids,
    logits_processor=logits_processor,
    logits_warper=logits_warper,
    stopping_criteria=stopping_criteria,
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;Today is a beautiful day, and&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">15</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.sample(
<span class="hljs-meta">... </span>    input_ids,
<span class="hljs-meta">... </span>    logits_processor=logits_processor,
<span class="hljs-meta">... </span>    logits_warper=logits_warper,
<span class="hljs-meta">... </span>    stopping_criteria=stopping_criteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today is a beautiful day, and a wonderful day.\\n\\nI was lucky enough to meet the&#x27;</span>]`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function Uh(M){let c,_,p,d,f,i,h,T;return{c(){c=s("p"),_=t("In most cases, you do not need to call "),p=s("a"),d=t("beam_search()"),f=t(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=s("a"),h=t(`following
guide`),T=t("."),this.h()},l(x){c=a(x,"P",{});var b=r(c);_=n(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=n(G,"beam_search()"),G.forEach(o),f=n(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=n(O,`following
guide`),O.forEach(o),T=n(b,"."),b.forEach(o),this.h()},h(){u(p,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(i,"href","./generation_strategies")},m(x,b){y(x,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T)},d(x){x&&o(c)}}}function Rh(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    num_beams=num_beams,
    device=model.device,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function Hh(M){let c,_,p,d,f,i,h,T;return{c(){c=s("p"),_=t("In most cases, you do not need to call "),p=s("a"),d=t("beam_sample()"),f=t(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=s("a"),h=t(`following
guide`),T=t("."),this.h()},l(x){c=a(x,"P",{});var b=r(c);_=n(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=n(G,"beam_sample()"),G.forEach(o),f=n(b,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=n(O,`following
guide`),O.forEach(o),T=n(b,"."),b.forEach(o),this.h()},h(){u(p,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u(i,"href","./generation_strategies")},m(x,b){y(x,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T)},d(x){x&&o(c)}}}function Vh(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    TopKLogitsWarper,
    TemperatureLogitsWarper,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids

# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    max_length=model.config.max_length,
    num_beams=num_beams,
    device=model.device,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id)]
)
# instantiate logits processors
logits_warper = LogitsProcessorList(
    [
        TopKLogitsWarper(50),
        TemperatureLogitsWarper(0.7),
    ]
)

outputs = model.beam_sample(
    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id)]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_sample(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function Yh(M){let c,_,p,d,f,i,h,T;return{c(){c=s("p"),_=t("In most cases, you do not need to call "),p=s("a"),d=t("contrastive_search()"),f=t(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=s("a"),h=t(`following
guide`),T=t("."),this.h()},l(x){c=a(x,"P",{});var b=r(c);_=n(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=n(G,"contrastive_search()"),G.forEach(o),f=n(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=n(O,`following
guide`),O.forEach(o),T=n(b,"."),b.forEach(o),this.h()},h(){u(p,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(i,"href","./generation_strategies")},m(x,b){y(x,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T)},d(x){x&&o(c)}}}function Kh(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForCausalLM,
    StoppingCriteriaList,
    MaxLengthCriteria,
)

tokenizer = AutoTokenizer.from_pretrained("facebook/opt-125m")
model = AutoModelForCausalLM.from_pretrained("facebook/opt-125m")
# set pad_token_id to eos_token_id because OPT does not have a PAD token
model.config.pad_token_id = model.config.eos_token_id
input_prompt = "DeepMind Company is"
input_ids = tokenizer(input_prompt, return_tensors="pt")
stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=64)])
outputs = model.contrastive_search(
    **input_ids, penalty_alpha=0.6, top_k=4, stopping_criteria=stopping_criteria
)
tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because OPT does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;DeepMind Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">64</span>)])
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.contrastive_search(
<span class="hljs-meta">... </span>    **input_ids, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;DeepMind Company is a company that focuses on the development and commercialization of artificial intelligence (AI). DeepMind\u2019s mission is to help people understand and solve problems that are difficult to solve in the world today.\\n\\nIn this post, we talk about the benefits of deep learning in business and how it&#x27;</span>]`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function Zh(M){let c,_,p,d,f,i,h,T;return{c(){c=s("p"),_=t("In most cases, you do not need to call "),p=s("a"),d=t("group_beam_search()"),f=t(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=s("a"),h=t(`following
guide`),T=t("."),this.h()},l(x){c=a(x,"P",{});var b=r(c);_=n(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=n(G,"group_beam_search()"),G.forEach(o),f=n(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=n(O,`following
guide`),O.forEach(o),T=n(b,"."),b.forEach(o),this.h()},h(){u(p,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(i,"href","./generation_strategies")},m(x,b){y(x,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T)},d(x){x&&o(c)}}}function Jh(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    HammingDiversityLogitsProcessor,
    BeamSearchScorer,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run diverse beam search using 6 beams
num_beams = 6
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

# instantiate beam scorer
beam_scorer = BeamSearchScorer(
    batch_size=1,
    max_length=model.config.max_length,
    num_beams=num_beams,
    device=model.device,
    num_beam_groups=3,
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        HammingDiversityLogitsProcessor(5.5, num_beams=6, num_beam_groups=3),
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.group_beam_search(
    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    HammingDiversityLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run diverse beam search using 6 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        HammingDiversityLogitsProcessor(<span class="hljs-number">5.5</span>, num_beams=<span class="hljs-number">6</span>, num_beam_groups=<span class="hljs-number">3</span>),
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.group_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function Xh(M){let c,_,p,d,f,i,h,T;return{c(){c=s("p"),_=t("In most cases, you do not need to call "),p=s("a"),d=t("constrained_beam_search()"),f=t(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=s("a"),h=t(`following
guide`),T=t("."),this.h()},l(x){c=a(x,"P",{});var b=r(c);_=n(b,"In most cases, you do not need to call "),p=a(b,"A",{href:!0});var G=r(p);d=n(G,"constrained_beam_search()"),G.forEach(o),f=n(b,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(b,"A",{href:!0});var O=r(i);h=n(O,`following
guide`),O.forEach(o),T=n(b,"."),b.forEach(o),this.h()},h(){u(p,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(i,"href","./generation_strategies")},m(x,b){y(x,c,b),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T)},d(x){x&&o(c)}}}function Qh(M){let c,_,p,d,f;return d=new Qe({props:{code:`from transformers import (
    AutoTokenizer,
    AutoModelForSeq2SeqLM,
    LogitsProcessorList,
    MinLengthLogitsProcessor,
    ConstrainedBeamSearchScorer,
    PhrasalConstraint,
)
import torch

tokenizer = AutoTokenizer.from_pretrained("t5-base")
model = AutoModelForSeq2SeqLM.from_pretrained("t5-base")

encoder_input_str = "translate English to German: How old are you?"
encoder_input_ids = tokenizer(encoder_input_str, return_tensors="pt").input_ids


# lets run beam search using 3 beams
num_beams = 3
# define decoder start token ids
input_ids = torch.ones((num_beams, 1), device=model.device, dtype=torch.long)
input_ids = input_ids * model.config.decoder_start_token_id

# add encoder_outputs to model keyword arguments
model_kwargs = {
    "encoder_outputs": model.get_encoder()(
        encoder_input_ids.repeat_interleave(num_beams, dim=0), return_dict=True
    )
}

constraint_str = "Sie"
constraint_token_ids = tokenizer.encode(constraint_str)[:-1]  # slice to remove eos token
constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


# instantiate beam scorer
beam_scorer = ConstrainedBeamSearchScorer(
    batch_size=1, num_beams=num_beams, device=model.device, constraints=constraints
)

# instantiate logits processors
logits_processor = LogitsProcessorList(
    [
        MinLengthLogitsProcessor(5, eos_token_id=model.config.eos_token_id),
    ]
)

outputs = model.constrained_beam_search(
    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
)

tokenizer.batch_decode(outputs, skip_special_tokens=True)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    ConstrainedBeamSearchScorer,
<span class="hljs-meta">... </span>    PhrasalConstraint,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_str = <span class="hljs-string">&quot;Sie&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_token_ids = tokenizer.encode(constraint_str)[:-<span class="hljs-number">1</span>]  <span class="hljs-comment"># slice to remove eos token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = ConstrainedBeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>, num_beams=num_beams, device=model.device, constraints=constraints
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.constrained_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt sind Sie?&#x27;</span>]`}}),{c(){c=s("p"),_=t("Examples:"),p=m(),k(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=n(h,"Examples:"),h.forEach(o),p=g(i),w(d.$$.fragment,i)},m(i,h){y(i,c,h),e(c,_),y(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||($(d.$$.fragment,i),f=!0)},o(i){L(d.$$.fragment,i),f=!1},d(i){i&&o(c),i&&o(p),E(d,i)}}}function eu(M){let c,_,p,d,f,i,h,T,x,b,G,O,D,ie,N,Z,F;return{c(){c=s("p"),_=t("Most generation-controlling parameters are set in "),p=s("code"),d=t("generation_config"),f=t(` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=s("code"),h=t("generation_config"),T=t(` by passing the corresponding
parameters to generate, e.g. `),x=s("code"),b=t(".generate(inputs, num_beams=4, do_sample=True)"),G=t("."),O=m(),D=s("p"),ie=t("For an overview of generation strategies and code examples, check out the "),N=s("a"),Z=t(`following
guide`),F=t("."),this.h()},l(C){c=a(C,"P",{});var P=r(c);_=n(P,"Most generation-controlling parameters are set in "),p=a(P,"CODE",{});var J=r(p);d=n(J,"generation_config"),J.forEach(o),f=n(P,` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=a(P,"CODE",{});var Pe=r(i);h=n(Pe,"generation_config"),Pe.forEach(o),T=n(P,` by passing the corresponding
parameters to generate, e.g. `),x=a(P,"CODE",{});var qe=r(x);b=n(qe,".generate(inputs, num_beams=4, do_sample=True)"),qe.forEach(o),G=n(P,"."),P.forEach(o),O=g(C),D=a(C,"P",{});var R=r(D);ie=n(R,"For an overview of generation strategies and code examples, check out the "),N=a(R,"A",{href:!0});var De=r(N);Z=n(De,`following
guide`),De.forEach(o),F=n(R,"."),R.forEach(o),this.h()},h(){u(N,"href","./generation_strategies")},m(C,P){y(C,c,P),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,T),e(c,x),e(x,b),e(c,G),y(C,O,P),y(C,D,P),e(D,ie),e(D,N),e(N,Z),e(D,F)},d(C){C&&o(c),C&&o(O),C&&o(D)}}}function tu(M){let c,_,p,d,f,i,h,T,x,b,G,O,D,ie,N,Z,F,C,P,J,Pe,qe,R,De,hr,ur,Ae,fr,Hn,_r,br,Vn,vr,xr,yr,Fe,kr,Yn,wr,jr,Kn,$r,Lr,Ga,et,Er,Zn,Tr,Mr,Oa,tt,Gr,Jn,Or,Cr,Ca,ze,nt,Do,tn,Sr,Ao,Pr,Sa,A,nn,qr,on,Dr,Fo,Ar,Fr,zr,I,le,zo,Nr,Ir,Xn,Br,Wr,No,Ur,Rr,Io,Hr,Vr,ce,Bo,Yr,Kr,Qn,Zr,Jr,Wo,Xr,Qr,Uo,ei,ti,de,Ro,ni,oi,eo,si,ai,Ho,ri,ii,Vo,li,ci,pe,Yo,di,pi,to,mi,gi,Ko,hi,ui,Zo,fi,_i,me,Jo,bi,vi,no,xi,yi,Xo,ki,wi,Qo,ji,$i,ge,es,Li,Ei,oo,Ti,Mi,ts,Gi,Oi,ns,Ci,Si,he,os,Pi,qi,so,Di,Ai,ss,Fi,zi,as,Ni,Ii,sn,Bi,ao,Wi,Ui,Ri,Me,an,Hi,rn,Vi,ro,Yi,Ki,Zi,ot,Ji,st,ln,Xi,K,Qi,io,el,tl,lo,nl,ol,co,sl,al,po,rl,il,ll,at,cn,cl,Ne,dl,rs,pl,ml,mo,gl,hl,Pa,Ie,rt,is,dn,ul,ls,fl,qa,S,pn,_l,mn,bl,go,vl,xl,yl,gn,kl,ho,wl,jl,$l,B,ue,cs,Ll,El,uo,Tl,Ml,ds,Gl,Ol,ps,Cl,Sl,fe,ms,Pl,ql,fo,Dl,Al,gs,Fl,zl,hs,Nl,Il,_e,us,Bl,Wl,_o,Ul,Rl,fs,Hl,Vl,_s,Yl,Kl,be,bs,Zl,Jl,bo,Xl,Ql,vs,ec,tc,xs,nc,oc,ve,ys,sc,ac,vo,rc,ic,ks,lc,cc,ws,dc,pc,xe,js,mc,gc,xo,hc,uc,$s,fc,_c,Ls,bc,vc,ye,Es,xc,yc,yo,kc,wc,Ts,jc,$c,Ms,Lc,Ec,hn,Tc,ko,Mc,Gc,Oc,Ge,un,Cc,Gs,Sc,Pc,it,qc,Oe,fn,Dc,Os,Ac,Fc,lt,zc,X,_n,Nc,bn,Ic,Cs,Bc,Wc,Uc,ct,Rc,dt,Hc,Q,vn,Vc,xn,Yc,Ss,Kc,Zc,Jc,pt,Xc,mt,Qc,ee,yn,ed,kn,td,Ps,nd,od,sd,gt,ad,ht,rd,te,wn,id,jn,ld,qs,cd,dd,pd,ut,md,ft,gd,ne,$n,hd,Ln,ud,Ds,fd,_d,bd,_t,vd,bt,xd,oe,En,yd,Tn,kd,As,wd,jd,$d,vt,Ld,xt,Ed,se,Mn,Td,Gn,Md,Fs,Gd,Od,Cd,yt,Sd,kt,Da,Be,wt,zs,On,Pd,Ns,qd,Aa,W,Cn,Dd,Sn,Ad,wo,Fd,zd,Nd,Pn,Id,jo,Bd,Wd,Ud,ke,we,Is,Rd,Hd,Bs,Vd,Yd,Ws,Kd,Zd,Us,Jd,Xd,je,Rs,Qd,ep,Hs,tp,np,Vs,op,sp,Ys,ap,rp,$e,Ks,ip,lp,Zs,cp,dp,Js,pp,mp,Xs,gp,hp,We,Qs,up,fp,ea,_p,bp,ta,vp,xp,qn,yp,$o,kp,wp,jp,Ce,Dn,$p,na,Lp,Ep,jt,Fa,Ue,$t,oa,An,Tp,sa,Mp,za,U,Fn,Gp,zn,Op,Lo,Cp,Sp,Pp,Nn,qp,Eo,Dp,Ap,Fp,Re,Le,aa,zp,Np,ra,Ip,Bp,ia,Wp,Up,la,Rp,Hp,Ee,ca,Vp,Yp,da,Kp,Zp,pa,Jp,Xp,ma,Qp,em,Te,ga,tm,nm,ha,om,sm,ua,am,rm,fa,im,lm,In,cm,To,dm,pm,mm,Lt,Bn,gm,_a,hm,Na;return i=new Ma({}),tn=new Ma({}),nn=new z({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/configuration_utils.py#L38",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. In general, prefer the use of <code>max_new_tokens</code>, which ignores the number of tokens in the
prompt.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated. Corresponds to the length of the input prompt +
<code>min_new_tokens</code>. In general, prefer the use of <code>min_new_tokens</code>, which ignores the number of tokens in the
prompt.`,name:"min_length"},{anchor:"transformers.GenerationConfig.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"min_new_tokens"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to stop the beam search when at least <code>num_beams</code> sentences are finished per batch or not.`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time(float,",description:`<strong>max_time(<code>float</code>,</strong> <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time(float,"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to module the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
<code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the
size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"transformers.GenerationConfig.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between
0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token
probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"eta_cutoff"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.encoder_repetition_penalty",description:`<strong>encoder_repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the
original input. 1.0 means no penalty.`,name:"encoder_repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids(List[List[int]],",description:`<strong>bad_words_ids(<code>List[List[int]]</code>,</strong> <em>optional</em>) &#x2014;
List of token ids that are not allowed to be generated. In order to get the token ids of the words that
should not appear in the generated text, use <code>tokenizer(bad_words, add_prefix_space=True, add_special_tokens=False).input_ids</code>.`,name:"bad_words_ids(List[List[int]],"},{anchor:"transformers.GenerationConfig.force_words_ids(List[List[int]]",description:`<strong>force_words_ids(<code>List[List[int]]</code></strong> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids(List[List[int]]"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors or warpers (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors or warpers break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use of
certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to <code>model.config.forced_eos_token_id</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"}]},{title:"Parameters that define the output variables of `generate`",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"}]},{title:"Wild card",parametersDescription:[]}]}}),an=new z({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"use_auth_token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/configuration_utils.py#L343",returnDescription:`
<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),ot=new Je({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[Ah]},$$scope:{ctx:M}}}),ln=new z({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/configuration_utils.py#L619",returnDescription:`
<p>The configuration object instantiated from those parameters.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),cn=new z({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).
kwargs &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.26.1/en/internal/image_processing_utils#transformers.ImageProcessingMixin.push_to_hub">push_to_hub()</a> method.`,name:"push_to_hub"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/configuration_utils.py#L297"}}),dn=new Ma({}),pn=new z({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L466"}}),un=new z({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Union[typing.Callable[[int, torch.Tensor], typing.List[int]], NoneType] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max<em>length (needed for ZeRO stage 3)
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with *decoder</em>*.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L1095",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),it=new Ze({props:{warning:!0,$$slots:{default:[Fh]},$$scope:{ctx:M}}}),fn=new z({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[torch.Tensor]"},{name:"beam_indices",val:": typing.Optional[torch.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with
each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tuple(tuple(torch.LongTensor))</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, input_ids.shape[-1])</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L927",returnDescription:`
<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>torch.Tensor</code></p>
`}}),lt=new Je({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[zh]},$$scope:{ctx:M}}}),_n=new z({props:{name:"greedy_search",anchor:"transformers.GenerationMixin.greedy_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.greedy_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.greedy_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.greedy_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.greedy_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.greedy_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.greedy_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.greedy_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.greedy_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.greedy_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L2016",returnDescription:`
<p><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),ct=new Ze({props:{warning:!0,$$slots:{default:[Nh]},$$scope:{ctx:M}}}),dt=new Je({props:{anchor:"transformers.GenerationMixin.greedy_search.example",$$slots:{default:[Ih]},$$scope:{ctx:M}}}),vn=new z({props:{name:"sample",anchor:"transformers.GenerationMixin.sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L2259",returnDescription:`
<p>A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> or <code>torch.LongTensor</code></p>
`}}),pt=new Ze({props:{warning:!0,$$slots:{default:[Bh]},$$scope:{ctx:M}}}),mt=new Je({props:{anchor:"transformers.GenerationMixin.sample.example",$$slots:{default:[Wh]},$$scope:{ctx:M}}}),yn=new z({props:{name:"beam_search",anchor:"transformers.GenerationMixin.beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L2525",returnDescription:`
<p><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),gt=new Ze({props:{warning:!0,$$slots:{default:[Uh]},$$scope:{ctx:M}}}),ht=new Je({props:{anchor:"transformers.GenerationMixin.beam_search.example",$$slots:{default:[Rh]},$$scope:{ctx:M}}}),wn=new z({props:{name:"beam_sample",anchor:"transformers.GenerationMixin.beam_sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_sample.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.beam_sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L2848",returnDescription:`
<p><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),ut=new Ze({props:{warning:!0,$$slots:{default:[Hh]},$$scope:{ctx:M}}}),ft=new Je({props:{anchor:"transformers.GenerationMixin.beam_sample.example",$$slots:{default:[Vh]},$$scope:{ctx:M}}}),$n=new z({props:{name:"contrastive_search",anchor:"transformers.GenerationMixin.contrastive_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"top_k",val:": typing.Optional[int] = 1"},{name:"penalty_alpha",val:": typing.Optional[float] = 0"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.contrastive_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.contrastive_search.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the candidate set that is used to re-rank for contrastive search`,name:"top_k"},{anchor:"transformers.GenerationMixin.contrastive_search.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The degeneration penalty for contrastive search; activate when it is larger than 0`,name:"penalty_alpha"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.contrastive_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.contrastive_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.contrastive_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.contrastive_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.contrastive_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.contrastive_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L1658",returnDescription:`
<p><code>ContrastiveSearchDecoderOnlyOutput</code>, <code>ContrastiveSearchEncoderDecoderOutput</code>
or <code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<code>ContrastiveSearchDecoderOnlyOutput</code> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <code>ContrastiveSearchEncoderDecoderOutput</code> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),_t=new Ze({props:{warning:!0,$$slots:{default:[Yh]},$$scope:{ctx:M}}}),bt=new Je({props:{anchor:"transformers.GenerationMixin.contrastive_search.example",$$slots:{default:[Kh]},$$scope:{ctx:M}}}),En=new z({props:{name:"group_beam_search",anchor:"transformers.GenerationMixin.group_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.group_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.group_beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.group_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.group_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.group_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.group_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.group_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.group_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.group_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.group_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)</p>
<p>model_kwargs &#x2014;
Additional model specific kwargs that will be forwarded to the <code>forward</code> function of the model. If
model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L3178",returnDescription:`
<p><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if
<code>model.config.is_encoder_decoder=False</code> and <code>return_dict_in_generate=True</code> or a
<a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if <code>model.config.is_encoder_decoder=True</code>.</p>
`}}),vt=new Ze({props:{warning:!0,$$slots:{default:[Zh]},$$scope:{ctx:M}}}),xt=new Je({props:{anchor:"transformers.GenerationMixin.group_beam_search.example",$$slots:{default:[Jh]},$$scope:{ctx:M}}}),Mn=new z({props:{name:"constrained_beam_search",anchor:"transformers.GenerationMixin.constrained_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"constrained_beam_scorer",val:": ConstrainedBeamSearchScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.constrained_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.constrained_beam_search.constrained_beam_scorer",description:`<strong>constrained_beam_scorer</strong> (<code>ConstrainedBeamSearchScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation, while satisfying a list of positive constraints. For more information, the
documentation of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.ConstrainedBeamSearchScorer">ConstrainedBeamSearchScorer</a> should be read.`,name:"constrained_beam_scorer"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.constrained_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.constrained_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.constrained_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.constrained_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.constrained_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/utils.py#L3556",returnDescription:`
<p><a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.26.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),yt=new Ze({props:{warning:!0,$$slots:{default:[Xh]},$$scope:{ctx:M}}}),kt=new Je({props:{anchor:"transformers.GenerationMixin.constrained_beam_search.example",$$slots:{default:[Qh]},$$scope:{ctx:M}}}),On=new Ma({}),Cn=new z({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/tf_utils.py#L429"}}),Dn=new z({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"input_ids",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of <code>dtype=tf.int32</code> and shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation. If <code>None</code> the method initializes it with
<code>bos_token_id</code> and a batch size of 1.`,name:"input_ids"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"seed"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/tf_utils.py#L531",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><code>TFGreedySearchDecoderOnlyOutput</code>,</li>
<li><code>TFSampleDecoderOnlyOutput</code>,</li>
<li><code>TFBeamSearchDecoderOnlyOutput</code>,</li>
<li><code>TFBeamSampleDecoderOnlyOutput</code></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><code>TFGreedySearchEncoderDecoderOutput</code>,</li>
<li><code>TFSampleEncoderDecoderOutput</code>,</li>
<li><code>TFBeamSearchEncoderDecoderOutput</code>,</li>
<li><code>TFBeamSampleEncoderDecoderOutput</code></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),jt=new Ze({props:{warning:!0,$$slots:{default:[eu]},$$scope:{ctx:M}}}),An=new Ma({}),Fn=new z({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/flax_utils.py#L127"}}),Bn=new z({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": ndarray"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"prng_key",val:": typing.Optional[jax._src.numpy.ndarray.ndarray] = None"},{name:"trace",val:": bool = True"},{name:"params",val:": typing.Union[typing.Dict[str, jax._src.numpy.ndarray.ndarray], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.
kwargs &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"params"}],source:"https://github.com/huggingface/transformers/blob/v4.26.1/src/transformers/generation/flax_utils.py#L221",returnDescription:`
<p><a
  href="/docs/transformers/v4.26.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),{c(){c=s("meta"),_=m(),p=s("h1"),d=s("a"),f=s("span"),k(i.$$.fragment),h=m(),T=s("span"),x=t("Generation"),b=m(),G=s("p"),O=t("Each framework has a generate method for text generation implemented in their respective "),D=s("code"),ie=t("GenerationMixin"),N=t(" class:"),Z=m(),F=s("ul"),C=s("li"),P=t("PyTorch "),J=s("a"),Pe=t("generate()"),qe=t(" is implemented in "),R=s("a"),De=t("GenerationMixin"),hr=t("."),ur=m(),Ae=s("li"),fr=t("TensorFlow "),Hn=s("a"),_r=t("generate()"),br=t(" is implemented in "),Vn=s("a"),vr=t("TFGenerationMixin"),xr=t("."),yr=m(),Fe=s("li"),kr=t("Flax/JAX "),Yn=s("a"),wr=t("generate()"),jr=t(" is implemented in "),Kn=s("a"),$r=t("FlaxGenerationMixin"),Lr=t("."),Ga=m(),et=s("p"),Er=t("Regardless of your framework of choice, you can parameterize the generate method with a "),Zn=s("a"),Tr=t("GenerationConfig"),Mr=t(`
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`),Oa=m(),tt=s("p"),Gr=t(`To learn how to inspect a model\u2019s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
`),Jn=s("a"),Or=t("text generation strategies guide"),Cr=t("."),Ca=m(),ze=s("h2"),nt=s("a"),Do=s("span"),k(tn.$$.fragment),Sr=m(),Ao=s("span"),Pr=t("GenerationConfig"),Sa=m(),A=s("div"),k(nn.$$.fragment),qr=m(),on=s("p"),Dr=t("Class that holds a configuration for a generation task. A "),Fo=s("code"),Ar=t("generate"),Fr=t(` call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),zr=m(),I=s("ul"),le=s("li"),zo=s("em"),Nr=t("greedy decoding"),Ir=t(" by calling "),Xn=s("a"),Br=t("greedy_search()"),Wr=t(" if "),No=s("code"),Ur=t("num_beams=1"),Rr=t(` and
`),Io=s("code"),Hr=t("do_sample=False"),Vr=m(),ce=s("li"),Bo=s("em"),Yr=t("contrastive search"),Kr=t(" by calling "),Qn=s("a"),Zr=t("contrastive_search()"),Jr=t(" if "),Wo=s("code"),Xr=t("penalty_alpha>0."),Qr=t(`
and `),Uo=s("code"),ei=t("top_k>1"),ti=m(),de=s("li"),Ro=s("em"),ni=t("multinomial sampling"),oi=t(" by calling "),eo=s("a"),si=t("sample()"),ai=t(" if "),Ho=s("code"),ri=t("num_beams=1"),ii=t(` and
`),Vo=s("code"),li=t("do_sample=True"),ci=m(),pe=s("li"),Yo=s("em"),di=t("beam-search decoding"),pi=t(" by calling "),to=s("a"),mi=t("beam_search()"),gi=t(" if "),Ko=s("code"),hi=t("num_beams>1"),ui=t(` and
`),Zo=s("code"),fi=t("do_sample=False"),_i=m(),me=s("li"),Jo=s("em"),bi=t("beam-search multinomial sampling"),vi=t(" by calling "),no=s("a"),xi=t("beam_sample()"),yi=t(` if
`),Xo=s("code"),ki=t("num_beams>1"),wi=t(" and "),Qo=s("code"),ji=t("do_sample=True"),$i=m(),ge=s("li"),es=s("em"),Li=t("diverse beam-search decoding"),Ei=t(" by calling "),oo=s("a"),Ti=t("group_beam_search()"),Mi=t(`, if
`),ts=s("code"),Gi=t("num_beams>1"),Oi=t(" and "),ns=s("code"),Ci=t("num_beam_groups>1"),Si=m(),he=s("li"),os=s("em"),Pi=t("constrained beam-search decoding"),qi=t(" by calling "),so=s("a"),Di=t("constrained_beam_search()"),Ai=t(`, if
`),ss=s("code"),Fi=t("constraints!=None"),zi=t(" or "),as=s("code"),Ni=t("force_words_ids!=None"),Ii=m(),sn=s("p"),Bi=t(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019. To learn
more about decoding strategies refer to the `),ao=s("a"),Wi=t("text generation strategies guide"),Ui=t("."),Ri=m(),Me=s("div"),k(an.$$.fragment),Hi=m(),rn=s("p"),Vi=t("Instantiate a "),ro=s("a"),Yi=t("GenerationConfig"),Ki=t(" from a generation configuration file."),Zi=m(),k(ot.$$.fragment),Ji=m(),st=s("div"),k(ln.$$.fragment),Xi=m(),K=s("p"),Qi=t("Instantiates a "),io=s("a"),el=t("GenerationConfig"),tl=t(" from a "),lo=s("a"),nl=t("PretrainedConfig"),ol=t(`. This function is useful to convert legacy
`),co=s("a"),sl=t("PretrainedConfig"),al=t(" objects, which may contain generation parameters, into a stand-alone "),po=s("a"),rl=t("GenerationConfig"),il=t("."),ll=m(),at=s("div"),k(cn.$$.fragment),cl=m(),Ne=s("p"),dl=t("Save a generation configuration object to the directory "),rs=s("code"),pl=t("save_directory"),ml=t(`, so that it can be re-loaded using the
`),mo=s("a"),gl=t("from_pretrained()"),hl=t(" class method."),Pa=m(),Ie=s("h2"),rt=s("a"),is=s("span"),k(dn.$$.fragment),ul=m(),ls=s("span"),fl=t("GenerationMixin"),qa=m(),S=s("div"),k(pn.$$.fragment),_l=m(),mn=s("p"),bl=t("A class containing all functions for auto-regressive text generation, to be used as a mixin in "),go=s("a"),vl=t("PreTrainedModel"),xl=t("."),yl=m(),gn=s("p"),kl=t("The class exposes "),ho=s("a"),wl=t("generate()"),jl=t(", which can be used for:"),$l=m(),B=s("ul"),ue=s("li"),cs=s("em"),Ll=t("greedy decoding"),El=t(" by calling "),uo=s("a"),Tl=t("greedy_search()"),Ml=t(" if "),ds=s("code"),Gl=t("num_beams=1"),Ol=t(` and
`),ps=s("code"),Cl=t("do_sample=False"),Sl=m(),fe=s("li"),ms=s("em"),Pl=t("contrastive search"),ql=t(" by calling "),fo=s("a"),Dl=t("contrastive_search()"),Al=t(" if "),gs=s("code"),Fl=t("penalty_alpha>0"),zl=t(` and
`),hs=s("code"),Nl=t("top_k>1"),Il=m(),_e=s("li"),us=s("em"),Bl=t("multinomial sampling"),Wl=t(" by calling "),_o=s("a"),Ul=t("sample()"),Rl=t(" if "),fs=s("code"),Hl=t("num_beams=1"),Vl=t(` and
`),_s=s("code"),Yl=t("do_sample=True"),Kl=m(),be=s("li"),bs=s("em"),Zl=t("beam-search decoding"),Jl=t(" by calling "),bo=s("a"),Xl=t("beam_search()"),Ql=t(" if "),vs=s("code"),ec=t("num_beams>1"),tc=t(` and
`),xs=s("code"),nc=t("do_sample=False"),oc=m(),ve=s("li"),ys=s("em"),sc=t("beam-search multinomial sampling"),ac=t(" by calling "),vo=s("a"),rc=t("beam_sample()"),ic=t(" if "),ks=s("code"),lc=t("num_beams>1"),cc=t(`
and `),ws=s("code"),dc=t("do_sample=True"),pc=m(),xe=s("li"),js=s("em"),mc=t("diverse beam-search decoding"),gc=t(" by calling "),xo=s("a"),hc=t("group_beam_search()"),uc=t(", if "),$s=s("code"),fc=t("num_beams>1"),_c=t(`
and `),Ls=s("code"),bc=t("num_beam_groups>1"),vc=m(),ye=s("li"),Es=s("em"),xc=t("constrained beam-search decoding"),yc=t(" by calling "),yo=s("a"),kc=t("constrained_beam_search()"),wc=t(`, if
`),Ts=s("code"),jc=t("constraints!=None"),$c=t(" or "),Ms=s("code"),Lc=t("force_words_ids!=None"),Ec=m(),hn=s("p"),Tc=t(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),ko=s("a"),Mc=t("text generation strategies guide"),Gc=t("."),Oc=m(),Ge=s("div"),k(un.$$.fragment),Cc=m(),Gs=s("p"),Sc=t("Generates sequences of token ids for models with a language modeling head."),Pc=m(),k(it.$$.fragment),qc=m(),Oe=s("div"),k(fn.$$.fragment),Dc=m(),Os=s("p"),Ac=t(`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Fc=m(),k(lt.$$.fragment),zc=m(),X=s("div"),k(_n.$$.fragment),Nc=m(),bn=s("p"),Ic=t("Generates sequences of token ids for models with a language modeling head using "),Cs=s("strong"),Bc=t("greedy decoding"),Wc=t(` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Uc=m(),k(ct.$$.fragment),Rc=m(),k(dt.$$.fragment),Hc=m(),Q=s("div"),k(vn.$$.fragment),Vc=m(),xn=s("p"),Yc=t("Generates sequences of token ids for models with a language modeling head using "),Ss=s("strong"),Kc=t("multinomial sampling"),Zc=t(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Jc=m(),k(pt.$$.fragment),Xc=m(),k(mt.$$.fragment),Qc=m(),ee=s("div"),k(yn.$$.fragment),ed=m(),kn=s("p"),td=t("Generates sequences of token ids for models with a language modeling head using "),Ps=s("strong"),nd=t("beam search decoding"),od=t(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),sd=m(),k(gt.$$.fragment),ad=m(),k(ht.$$.fragment),rd=m(),te=s("div"),k(wn.$$.fragment),id=m(),jn=s("p"),ld=t("Generates sequences of token ids for models with a language modeling head using "),qs=s("strong"),cd=t(`beam search multinomial
sampling`),dd=t(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),pd=m(),k(ut.$$.fragment),md=m(),k(ft.$$.fragment),gd=m(),ne=s("div"),k($n.$$.fragment),hd=m(),Ln=s("p"),ud=t("Generates sequences of token ids for models with a language modeling head using "),Ds=s("strong"),fd=t("contrastive search"),_d=t(` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),bd=m(),k(_t.$$.fragment),vd=m(),k(bt.$$.fragment),xd=m(),oe=s("div"),k(En.$$.fragment),yd=m(),Tn=s("p"),kd=t("Generates sequences of token ids for models with a language modeling head using "),As=s("strong"),wd=t(`diverse beam search
decoding`),jd=t(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),$d=m(),k(vt.$$.fragment),Ld=m(),k(xt.$$.fragment),Ed=m(),se=s("div"),k(Mn.$$.fragment),Td=m(),Gn=s("p"),Md=t("Generates sequences of token ids for models with a language modeling head using "),Fs=s("strong"),Gd=t(`constrained beam search
decoding`),Od=t(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Cd=m(),k(yt.$$.fragment),Sd=m(),k(kt.$$.fragment),Da=m(),Be=s("h2"),wt=s("a"),zs=s("span"),k(On.$$.fragment),Pd=m(),Ns=s("span"),qd=t("TFGenerationMixin"),Aa=m(),W=s("div"),k(Cn.$$.fragment),Dd=m(),Sn=s("p"),Ad=t("A class containing all of the functions supporting generation, to be used as a mixin in "),wo=s("a"),Fd=t("TFPreTrainedModel"),zd=t("."),Nd=m(),Pn=s("p"),Id=t("The class exposes "),jo=s("a"),Bd=t("generate()"),Wd=t(", which can be used for:"),Ud=m(),ke=s("ul"),we=s("li"),Is=s("em"),Rd=t("greedy decoding"),Hd=t(" by calling "),Bs=s("code"),Vd=t("greedy_search()"),Yd=t(" if "),Ws=s("code"),Kd=t("num_beams=1"),Zd=t(` and
`),Us=s("code"),Jd=t("do_sample=False"),Xd=m(),je=s("li"),Rs=s("em"),Qd=t("contrastive search"),ep=t(" by calling "),Hs=s("code"),tp=t("contrastive_search()"),np=t(" if "),Vs=s("code"),op=t("penalty_alpha>0"),sp=t(` and
`),Ys=s("code"),ap=t("top_k>1"),rp=m(),$e=s("li"),Ks=s("em"),ip=t("multinomial sampling"),lp=t(" by calling "),Zs=s("code"),cp=t("sample()"),dp=t(" if "),Js=s("code"),pp=t("num_beams=1"),mp=t(` and
`),Xs=s("code"),gp=t("do_sample=True"),hp=m(),We=s("li"),Qs=s("em"),up=t("beam-search decoding"),fp=t(" by calling "),ea=s("code"),_p=t("beam_search()"),bp=t(" if "),ta=s("code"),vp=t("num_beams>1"),xp=m(),qn=s("p"),yp=t(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),$o=s("a"),kp=t("text generation strategies guide"),wp=t("."),jp=m(),Ce=s("div"),k(Dn.$$.fragment),$p=m(),na=s("p"),Lp=t("Generates sequences of token ids for models with a language modeling head."),Ep=m(),k(jt.$$.fragment),Fa=m(),Ue=s("h2"),$t=s("a"),oa=s("span"),k(An.$$.fragment),Tp=m(),sa=s("span"),Mp=t("FlaxGenerationMixin"),za=m(),U=s("div"),k(Fn.$$.fragment),Gp=m(),zn=s("p"),Op=t(`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),Lo=s("a"),Cp=t("FlaxPreTrainedModel"),Sp=t("."),Pp=m(),Nn=s("p"),qp=t("The class exposes "),Eo=s("a"),Dp=t("generate()"),Ap=t(", which can be used for:"),Fp=m(),Re=s("ul"),Le=s("li"),aa=s("em"),zp=t("greedy decoding"),Np=t(" by calling "),ra=s("code"),Ip=t("_greedy_search()"),Bp=t(" if "),ia=s("code"),Wp=t("num_beams=1"),Up=t(` and
`),la=s("code"),Rp=t("do_sample=False"),Hp=m(),Ee=s("li"),ca=s("em"),Vp=t("multinomial sampling"),Yp=t(" by calling "),da=s("code"),Kp=t("_sample()"),Zp=t(" if "),pa=s("code"),Jp=t("num_beams=1"),Xp=t(` and
`),ma=s("code"),Qp=t("do_sample=True"),em=m(),Te=s("li"),ga=s("em"),tm=t("beam-search decoding"),nm=t(" by calling "),ha=s("code"),om=t("_beam_search()"),sm=t(" if "),ua=s("code"),am=t("num_beams>1"),rm=t(` and
`),fa=s("code"),im=t("do_sample=False"),lm=m(),In=s("p"),cm=t(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),To=s("a"),dm=t("text generation strategies guide"),pm=t("."),mm=m(),Lt=s("div"),k(Bn.$$.fragment),gm=m(),_a=s("p"),hm=t("Generates sequences of token ids for models with a language modeling head."),this.h()},l(l){const v=qh('[data-svelte="svelte-1phssyn"]',document.head);c=a(v,"META",{name:!0,content:!0}),v.forEach(o),_=g(l),p=a(l,"H1",{class:!0});var Wn=r(p);d=a(Wn,"A",{id:!0,class:!0,href:!0});var ba=r(d);f=a(ba,"SPAN",{});var va=r(f);w(i.$$.fragment,va),va.forEach(o),ba.forEach(o),h=g(Wn),T=a(Wn,"SPAN",{});var xa=r(T);x=n(xa,"Generation"),xa.forEach(o),Wn.forEach(o),b=g(l),G=a(l,"P",{});var Un=r(G);O=n(Un,"Each framework has a generate method for text generation implemented in their respective "),D=a(Un,"CODE",{});var ya=r(D);ie=n(ya,"GenerationMixin"),ya.forEach(o),N=n(Un," class:"),Un.forEach(o),Z=g(l),F=a(l,"UL",{});var He=r(F);C=a(He,"LI",{});var Ve=r(C);P=n(Ve,"PyTorch "),J=a(Ve,"A",{href:!0});var ka=r(J);Pe=n(ka,"generate()"),ka.forEach(o),qe=n(Ve," is implemented in "),R=a(Ve,"A",{href:!0});var wa=r(R);De=n(wa,"GenerationMixin"),wa.forEach(o),hr=n(Ve,"."),Ve.forEach(o),ur=g(He),Ae=a(He,"LI",{});var Ye=r(Ae);fr=n(Ye,"TensorFlow "),Hn=a(Ye,"A",{href:!0});var ja=r(Hn);_r=n(ja,"generate()"),ja.forEach(o),br=n(Ye," is implemented in "),Vn=a(Ye,"A",{href:!0});var $a=r(Vn);vr=n($a,"TFGenerationMixin"),$a.forEach(o),xr=n(Ye,"."),Ye.forEach(o),yr=g(He),Fe=a(He,"LI",{});var Ke=r(Fe);kr=n(Ke,"Flax/JAX "),Yn=a(Ke,"A",{href:!0});var La=r(Yn);wr=n(La,"generate()"),La.forEach(o),jr=n(Ke," is implemented in "),Kn=a(Ke,"A",{href:!0});var Ea=r(Kn);$r=n(Ea,"FlaxGenerationMixin"),Ea.forEach(o),Lr=n(Ke,"."),Ke.forEach(o),He.forEach(o),Ga=g(l),et=a(l,"P",{});var Rn=r(et);Er=n(Rn,"Regardless of your framework of choice, you can parameterize the generate method with a "),Zn=a(Rn,"A",{href:!0});var Ta=r(Zn);Tr=n(Ta,"GenerationConfig"),Ta.forEach(o),Mr=n(Rn,`
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`),Rn.forEach(o),Oa=g(l),tt=a(l,"P",{});var Ia=r(tt);Gr=n(Ia,`To learn how to inspect a model\u2019s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
`),Jn=a(Ia,"A",{href:!0});var um=r(Jn);Or=n(um,"text generation strategies guide"),um.forEach(o),Cr=n(Ia,"."),Ia.forEach(o),Ca=g(l),ze=a(l,"H2",{class:!0});var Ba=r(ze);nt=a(Ba,"A",{id:!0,class:!0,href:!0});var fm=r(nt);Do=a(fm,"SPAN",{});var _m=r(Do);w(tn.$$.fragment,_m),_m.forEach(o),fm.forEach(o),Sr=g(Ba),Ao=a(Ba,"SPAN",{});var bm=r(Ao);Pr=n(bm,"GenerationConfig"),bm.forEach(o),Ba.forEach(o),Sa=g(l),A=a(l,"DIV",{class:!0});var H=r(A);w(nn.$$.fragment,H),qr=g(H),on=a(H,"P",{});var Wa=r(on);Dr=n(Wa,"Class that holds a configuration for a generation task. A "),Fo=a(Wa,"CODE",{});var vm=r(Fo);Ar=n(vm,"generate"),vm.forEach(o),Fr=n(Wa,` call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),Wa.forEach(o),zr=g(H),I=a(H,"UL",{});var V=r(I);le=a(V,"LI",{});var Et=r(le);zo=a(Et,"EM",{});var xm=r(zo);Nr=n(xm,"greedy decoding"),xm.forEach(o),Ir=n(Et," by calling "),Xn=a(Et,"A",{href:!0});var ym=r(Xn);Br=n(ym,"greedy_search()"),ym.forEach(o),Wr=n(Et," if "),No=a(Et,"CODE",{});var km=r(No);Ur=n(km,"num_beams=1"),km.forEach(o),Rr=n(Et,` and
`),Io=a(Et,"CODE",{});var wm=r(Io);Hr=n(wm,"do_sample=False"),wm.forEach(o),Et.forEach(o),Vr=g(V),ce=a(V,"LI",{});var Tt=r(ce);Bo=a(Tt,"EM",{});var jm=r(Bo);Yr=n(jm,"contrastive search"),jm.forEach(o),Kr=n(Tt," by calling "),Qn=a(Tt,"A",{href:!0});var $m=r(Qn);Zr=n($m,"contrastive_search()"),$m.forEach(o),Jr=n(Tt," if "),Wo=a(Tt,"CODE",{});var Lm=r(Wo);Xr=n(Lm,"penalty_alpha>0."),Lm.forEach(o),Qr=n(Tt,`
and `),Uo=a(Tt,"CODE",{});var Em=r(Uo);ei=n(Em,"top_k>1"),Em.forEach(o),Tt.forEach(o),ti=g(V),de=a(V,"LI",{});var Mt=r(de);Ro=a(Mt,"EM",{});var Tm=r(Ro);ni=n(Tm,"multinomial sampling"),Tm.forEach(o),oi=n(Mt," by calling "),eo=a(Mt,"A",{href:!0});var Mm=r(eo);si=n(Mm,"sample()"),Mm.forEach(o),ai=n(Mt," if "),Ho=a(Mt,"CODE",{});var Gm=r(Ho);ri=n(Gm,"num_beams=1"),Gm.forEach(o),ii=n(Mt,` and
`),Vo=a(Mt,"CODE",{});var Om=r(Vo);li=n(Om,"do_sample=True"),Om.forEach(o),Mt.forEach(o),ci=g(V),pe=a(V,"LI",{});var Gt=r(pe);Yo=a(Gt,"EM",{});var Cm=r(Yo);di=n(Cm,"beam-search decoding"),Cm.forEach(o),pi=n(Gt," by calling "),to=a(Gt,"A",{href:!0});var Sm=r(to);mi=n(Sm,"beam_search()"),Sm.forEach(o),gi=n(Gt," if "),Ko=a(Gt,"CODE",{});var Pm=r(Ko);hi=n(Pm,"num_beams>1"),Pm.forEach(o),ui=n(Gt,` and
`),Zo=a(Gt,"CODE",{});var qm=r(Zo);fi=n(qm,"do_sample=False"),qm.forEach(o),Gt.forEach(o),_i=g(V),me=a(V,"LI",{});var Ot=r(me);Jo=a(Ot,"EM",{});var Dm=r(Jo);bi=n(Dm,"beam-search multinomial sampling"),Dm.forEach(o),vi=n(Ot," by calling "),no=a(Ot,"A",{href:!0});var Am=r(no);xi=n(Am,"beam_sample()"),Am.forEach(o),yi=n(Ot,` if
`),Xo=a(Ot,"CODE",{});var Fm=r(Xo);ki=n(Fm,"num_beams>1"),Fm.forEach(o),wi=n(Ot," and "),Qo=a(Ot,"CODE",{});var zm=r(Qo);ji=n(zm,"do_sample=True"),zm.forEach(o),Ot.forEach(o),$i=g(V),ge=a(V,"LI",{});var Ct=r(ge);es=a(Ct,"EM",{});var Nm=r(es);Li=n(Nm,"diverse beam-search decoding"),Nm.forEach(o),Ei=n(Ct," by calling "),oo=a(Ct,"A",{href:!0});var Im=r(oo);Ti=n(Im,"group_beam_search()"),Im.forEach(o),Mi=n(Ct,`, if
`),ts=a(Ct,"CODE",{});var Bm=r(ts);Gi=n(Bm,"num_beams>1"),Bm.forEach(o),Oi=n(Ct," and "),ns=a(Ct,"CODE",{});var Wm=r(ns);Ci=n(Wm,"num_beam_groups>1"),Wm.forEach(o),Ct.forEach(o),Si=g(V),he=a(V,"LI",{});var St=r(he);os=a(St,"EM",{});var Um=r(os);Pi=n(Um,"constrained beam-search decoding"),Um.forEach(o),qi=n(St," by calling "),so=a(St,"A",{href:!0});var Rm=r(so);Di=n(Rm,"constrained_beam_search()"),Rm.forEach(o),Ai=n(St,`, if
`),ss=a(St,"CODE",{});var Hm=r(ss);Fi=n(Hm,"constraints!=None"),Hm.forEach(o),zi=n(St," or "),as=a(St,"CODE",{});var Vm=r(as);Ni=n(Vm,"force_words_ids!=None"),Vm.forEach(o),St.forEach(o),V.forEach(o),Ii=g(H),sn=a(H,"P",{});var Ua=r(sn);Bi=n(Ua,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019. To learn
more about decoding strategies refer to the `),ao=a(Ua,"A",{href:!0});var Ym=r(ao);Wi=n(Ym,"text generation strategies guide"),Ym.forEach(o),Ui=n(Ua,"."),Ua.forEach(o),Ri=g(H),Me=a(H,"DIV",{class:!0});var Mo=r(Me);w(an.$$.fragment,Mo),Hi=g(Mo),rn=a(Mo,"P",{});var Ra=r(rn);Vi=n(Ra,"Instantiate a "),ro=a(Ra,"A",{href:!0});var Km=r(ro);Yi=n(Km,"GenerationConfig"),Km.forEach(o),Ki=n(Ra," from a generation configuration file."),Ra.forEach(o),Zi=g(Mo),w(ot.$$.fragment,Mo),Mo.forEach(o),Ji=g(H),st=a(H,"DIV",{class:!0});var Ha=r(st);w(ln.$$.fragment,Ha),Xi=g(Ha),K=a(Ha,"P",{});var Se=r(K);Qi=n(Se,"Instantiates a "),io=a(Se,"A",{href:!0});var Zm=r(io);el=n(Zm,"GenerationConfig"),Zm.forEach(o),tl=n(Se," from a "),lo=a(Se,"A",{href:!0});var Jm=r(lo);nl=n(Jm,"PretrainedConfig"),Jm.forEach(o),ol=n(Se,`. This function is useful to convert legacy
`),co=a(Se,"A",{href:!0});var Xm=r(co);sl=n(Xm,"PretrainedConfig"),Xm.forEach(o),al=n(Se," objects, which may contain generation parameters, into a stand-alone "),po=a(Se,"A",{href:!0});var Qm=r(po);rl=n(Qm,"GenerationConfig"),Qm.forEach(o),il=n(Se,"."),Se.forEach(o),Ha.forEach(o),ll=g(H),at=a(H,"DIV",{class:!0});var Va=r(at);w(cn.$$.fragment,Va),cl=g(Va),Ne=a(Va,"P",{});var Go=r(Ne);dl=n(Go,"Save a generation configuration object to the directory "),rs=a(Go,"CODE",{});var eg=r(rs);pl=n(eg,"save_directory"),eg.forEach(o),ml=n(Go,`, so that it can be re-loaded using the
`),mo=a(Go,"A",{href:!0});var tg=r(mo);gl=n(tg,"from_pretrained()"),tg.forEach(o),hl=n(Go," class method."),Go.forEach(o),Va.forEach(o),H.forEach(o),Pa=g(l),Ie=a(l,"H2",{class:!0});var Ya=r(Ie);rt=a(Ya,"A",{id:!0,class:!0,href:!0});var ng=r(rt);is=a(ng,"SPAN",{});var og=r(is);w(dn.$$.fragment,og),og.forEach(o),ng.forEach(o),ul=g(Ya),ls=a(Ya,"SPAN",{});var sg=r(ls);fl=n(sg,"GenerationMixin"),sg.forEach(o),Ya.forEach(o),qa=g(l),S=a(l,"DIV",{class:!0});var q=r(S);w(pn.$$.fragment,q),_l=g(q),mn=a(q,"P",{});var Ka=r(mn);bl=n(Ka,"A class containing all functions for auto-regressive text generation, to be used as a mixin in "),go=a(Ka,"A",{href:!0});var ag=r(go);vl=n(ag,"PreTrainedModel"),ag.forEach(o),xl=n(Ka,"."),Ka.forEach(o),yl=g(q),gn=a(q,"P",{});var Za=r(gn);kl=n(Za,"The class exposes "),ho=a(Za,"A",{href:!0});var rg=r(ho);wl=n(rg,"generate()"),rg.forEach(o),jl=n(Za,", which can be used for:"),Za.forEach(o),$l=g(q),B=a(q,"UL",{});var Y=r(B);ue=a(Y,"LI",{});var Pt=r(ue);cs=a(Pt,"EM",{});var ig=r(cs);Ll=n(ig,"greedy decoding"),ig.forEach(o),El=n(Pt," by calling "),uo=a(Pt,"A",{href:!0});var lg=r(uo);Tl=n(lg,"greedy_search()"),lg.forEach(o),Ml=n(Pt," if "),ds=a(Pt,"CODE",{});var cg=r(ds);Gl=n(cg,"num_beams=1"),cg.forEach(o),Ol=n(Pt,` and
`),ps=a(Pt,"CODE",{});var dg=r(ps);Cl=n(dg,"do_sample=False"),dg.forEach(o),Pt.forEach(o),Sl=g(Y),fe=a(Y,"LI",{});var qt=r(fe);ms=a(qt,"EM",{});var pg=r(ms);Pl=n(pg,"contrastive search"),pg.forEach(o),ql=n(qt," by calling "),fo=a(qt,"A",{href:!0});var mg=r(fo);Dl=n(mg,"contrastive_search()"),mg.forEach(o),Al=n(qt," if "),gs=a(qt,"CODE",{});var gg=r(gs);Fl=n(gg,"penalty_alpha>0"),gg.forEach(o),zl=n(qt,` and
`),hs=a(qt,"CODE",{});var hg=r(hs);Nl=n(hg,"top_k>1"),hg.forEach(o),qt.forEach(o),Il=g(Y),_e=a(Y,"LI",{});var Dt=r(_e);us=a(Dt,"EM",{});var ug=r(us);Bl=n(ug,"multinomial sampling"),ug.forEach(o),Wl=n(Dt," by calling "),_o=a(Dt,"A",{href:!0});var fg=r(_o);Ul=n(fg,"sample()"),fg.forEach(o),Rl=n(Dt," if "),fs=a(Dt,"CODE",{});var _g=r(fs);Hl=n(_g,"num_beams=1"),_g.forEach(o),Vl=n(Dt,` and
`),_s=a(Dt,"CODE",{});var bg=r(_s);Yl=n(bg,"do_sample=True"),bg.forEach(o),Dt.forEach(o),Kl=g(Y),be=a(Y,"LI",{});var At=r(be);bs=a(At,"EM",{});var vg=r(bs);Zl=n(vg,"beam-search decoding"),vg.forEach(o),Jl=n(At," by calling "),bo=a(At,"A",{href:!0});var xg=r(bo);Xl=n(xg,"beam_search()"),xg.forEach(o),Ql=n(At," if "),vs=a(At,"CODE",{});var yg=r(vs);ec=n(yg,"num_beams>1"),yg.forEach(o),tc=n(At,` and
`),xs=a(At,"CODE",{});var kg=r(xs);nc=n(kg,"do_sample=False"),kg.forEach(o),At.forEach(o),oc=g(Y),ve=a(Y,"LI",{});var Ft=r(ve);ys=a(Ft,"EM",{});var wg=r(ys);sc=n(wg,"beam-search multinomial sampling"),wg.forEach(o),ac=n(Ft," by calling "),vo=a(Ft,"A",{href:!0});var jg=r(vo);rc=n(jg,"beam_sample()"),jg.forEach(o),ic=n(Ft," if "),ks=a(Ft,"CODE",{});var $g=r(ks);lc=n($g,"num_beams>1"),$g.forEach(o),cc=n(Ft,`
and `),ws=a(Ft,"CODE",{});var Lg=r(ws);dc=n(Lg,"do_sample=True"),Lg.forEach(o),Ft.forEach(o),pc=g(Y),xe=a(Y,"LI",{});var zt=r(xe);js=a(zt,"EM",{});var Eg=r(js);mc=n(Eg,"diverse beam-search decoding"),Eg.forEach(o),gc=n(zt," by calling "),xo=a(zt,"A",{href:!0});var Tg=r(xo);hc=n(Tg,"group_beam_search()"),Tg.forEach(o),uc=n(zt,", if "),$s=a(zt,"CODE",{});var Mg=r($s);fc=n(Mg,"num_beams>1"),Mg.forEach(o),_c=n(zt,`
and `),Ls=a(zt,"CODE",{});var Gg=r(Ls);bc=n(Gg,"num_beam_groups>1"),Gg.forEach(o),zt.forEach(o),vc=g(Y),ye=a(Y,"LI",{});var Nt=r(ye);Es=a(Nt,"EM",{});var Og=r(Es);xc=n(Og,"constrained beam-search decoding"),Og.forEach(o),yc=n(Nt," by calling "),yo=a(Nt,"A",{href:!0});var Cg=r(yo);kc=n(Cg,"constrained_beam_search()"),Cg.forEach(o),wc=n(Nt,`, if
`),Ts=a(Nt,"CODE",{});var Sg=r(Ts);jc=n(Sg,"constraints!=None"),Sg.forEach(o),$c=n(Nt," or "),Ms=a(Nt,"CODE",{});var Pg=r(Ms);Lc=n(Pg,"force_words_ids!=None"),Pg.forEach(o),Nt.forEach(o),Y.forEach(o),Ec=g(q),hn=a(q,"P",{});var Ja=r(hn);Tc=n(Ja,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),ko=a(Ja,"A",{href:!0});var qg=r(ko);Mc=n(qg,"text generation strategies guide"),qg.forEach(o),Gc=n(Ja,"."),Ja.forEach(o),Oc=g(q),Ge=a(q,"DIV",{class:!0});var Oo=r(Ge);w(un.$$.fragment,Oo),Cc=g(Oo),Gs=a(Oo,"P",{});var Dg=r(Gs);Sc=n(Dg,"Generates sequences of token ids for models with a language modeling head."),Dg.forEach(o),Pc=g(Oo),w(it.$$.fragment,Oo),Oo.forEach(o),qc=g(q),Oe=a(q,"DIV",{class:!0});var Co=r(Oe);w(fn.$$.fragment,Co),Dc=g(Co),Os=a(Co,"P",{});var Ag=r(Os);Ac=n(Ag,`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Ag.forEach(o),Fc=g(Co),w(lt.$$.fragment,Co),Co.forEach(o),zc=g(q),X=a(q,"DIV",{class:!0});var It=r(X);w(_n.$$.fragment,It),Nc=g(It),bn=a(It,"P",{});var Xa=r(bn);Ic=n(Xa,"Generates sequences of token ids for models with a language modeling head using "),Cs=a(Xa,"STRONG",{});var Fg=r(Cs);Bc=n(Fg,"greedy decoding"),Fg.forEach(o),Wc=n(Xa,` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Xa.forEach(o),Uc=g(It),w(ct.$$.fragment,It),Rc=g(It),w(dt.$$.fragment,It),It.forEach(o),Hc=g(q),Q=a(q,"DIV",{class:!0});var Bt=r(Q);w(vn.$$.fragment,Bt),Vc=g(Bt),xn=a(Bt,"P",{});var Qa=r(xn);Yc=n(Qa,"Generates sequences of token ids for models with a language modeling head using "),Ss=a(Qa,"STRONG",{});var zg=r(Ss);Kc=n(zg,"multinomial sampling"),zg.forEach(o),Zc=n(Qa,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Qa.forEach(o),Jc=g(Bt),w(pt.$$.fragment,Bt),Xc=g(Bt),w(mt.$$.fragment,Bt),Bt.forEach(o),Qc=g(q),ee=a(q,"DIV",{class:!0});var Wt=r(ee);w(yn.$$.fragment,Wt),ed=g(Wt),kn=a(Wt,"P",{});var er=r(kn);td=n(er,"Generates sequences of token ids for models with a language modeling head using "),Ps=a(er,"STRONG",{});var Ng=r(Ps);nd=n(Ng,"beam search decoding"),Ng.forEach(o),od=n(er,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),er.forEach(o),sd=g(Wt),w(gt.$$.fragment,Wt),ad=g(Wt),w(ht.$$.fragment,Wt),Wt.forEach(o),rd=g(q),te=a(q,"DIV",{class:!0});var Ut=r(te);w(wn.$$.fragment,Ut),id=g(Ut),jn=a(Ut,"P",{});var tr=r(jn);ld=n(tr,"Generates sequences of token ids for models with a language modeling head using "),qs=a(tr,"STRONG",{});var Ig=r(qs);cd=n(Ig,`beam search multinomial
sampling`),Ig.forEach(o),dd=n(tr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),tr.forEach(o),pd=g(Ut),w(ut.$$.fragment,Ut),md=g(Ut),w(ft.$$.fragment,Ut),Ut.forEach(o),gd=g(q),ne=a(q,"DIV",{class:!0});var Rt=r(ne);w($n.$$.fragment,Rt),hd=g(Rt),Ln=a(Rt,"P",{});var nr=r(Ln);ud=n(nr,"Generates sequences of token ids for models with a language modeling head using "),Ds=a(nr,"STRONG",{});var Bg=r(Ds);fd=n(Bg,"contrastive search"),Bg.forEach(o),_d=n(nr,` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),nr.forEach(o),bd=g(Rt),w(_t.$$.fragment,Rt),vd=g(Rt),w(bt.$$.fragment,Rt),Rt.forEach(o),xd=g(q),oe=a(q,"DIV",{class:!0});var Ht=r(oe);w(En.$$.fragment,Ht),yd=g(Ht),Tn=a(Ht,"P",{});var or=r(Tn);kd=n(or,"Generates sequences of token ids for models with a language modeling head using "),As=a(or,"STRONG",{});var Wg=r(As);wd=n(Wg,`diverse beam search
decoding`),Wg.forEach(o),jd=n(or," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),or.forEach(o),$d=g(Ht),w(vt.$$.fragment,Ht),Ld=g(Ht),w(xt.$$.fragment,Ht),Ht.forEach(o),Ed=g(q),se=a(q,"DIV",{class:!0});var Vt=r(se);w(Mn.$$.fragment,Vt),Td=g(Vt),Gn=a(Vt,"P",{});var sr=r(Gn);Md=n(sr,"Generates sequences of token ids for models with a language modeling head using "),Fs=a(sr,"STRONG",{});var Ug=r(Fs);Gd=n(Ug,`constrained beam search
decoding`),Ug.forEach(o),Od=n(sr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),sr.forEach(o),Cd=g(Vt),w(yt.$$.fragment,Vt),Sd=g(Vt),w(kt.$$.fragment,Vt),Vt.forEach(o),q.forEach(o),Da=g(l),Be=a(l,"H2",{class:!0});var ar=r(Be);wt=a(ar,"A",{id:!0,class:!0,href:!0});var Rg=r(wt);zs=a(Rg,"SPAN",{});var Hg=r(zs);w(On.$$.fragment,Hg),Hg.forEach(o),Rg.forEach(o),Pd=g(ar),Ns=a(ar,"SPAN",{});var Vg=r(Ns);qd=n(Vg,"TFGenerationMixin"),Vg.forEach(o),ar.forEach(o),Aa=g(l),W=a(l,"DIV",{class:!0});var ae=r(W);w(Cn.$$.fragment,ae),Dd=g(ae),Sn=a(ae,"P",{});var rr=r(Sn);Ad=n(rr,"A class containing all of the functions supporting generation, to be used as a mixin in "),wo=a(rr,"A",{href:!0});var Yg=r(wo);Fd=n(Yg,"TFPreTrainedModel"),Yg.forEach(o),zd=n(rr,"."),rr.forEach(o),Nd=g(ae),Pn=a(ae,"P",{});var ir=r(Pn);Id=n(ir,"The class exposes "),jo=a(ir,"A",{href:!0});var Kg=r(jo);Bd=n(Kg,"generate()"),Kg.forEach(o),Wd=n(ir,", which can be used for:"),ir.forEach(o),Ud=g(ae),ke=a(ae,"UL",{});var Yt=r(ke);we=a(Yt,"LI",{});var Kt=r(we);Is=a(Kt,"EM",{});var Zg=r(Is);Rd=n(Zg,"greedy decoding"),Zg.forEach(o),Hd=n(Kt," by calling "),Bs=a(Kt,"CODE",{});var Jg=r(Bs);Vd=n(Jg,"greedy_search()"),Jg.forEach(o),Yd=n(Kt," if "),Ws=a(Kt,"CODE",{});var Xg=r(Ws);Kd=n(Xg,"num_beams=1"),Xg.forEach(o),Zd=n(Kt,` and
`),Us=a(Kt,"CODE",{});var Qg=r(Us);Jd=n(Qg,"do_sample=False"),Qg.forEach(o),Kt.forEach(o),Xd=g(Yt),je=a(Yt,"LI",{});var Zt=r(je);Rs=a(Zt,"EM",{});var eh=r(Rs);Qd=n(eh,"contrastive search"),eh.forEach(o),ep=n(Zt," by calling "),Hs=a(Zt,"CODE",{});var th=r(Hs);tp=n(th,"contrastive_search()"),th.forEach(o),np=n(Zt," if "),Vs=a(Zt,"CODE",{});var nh=r(Vs);op=n(nh,"penalty_alpha>0"),nh.forEach(o),sp=n(Zt,` and
`),Ys=a(Zt,"CODE",{});var oh=r(Ys);ap=n(oh,"top_k>1"),oh.forEach(o),Zt.forEach(o),rp=g(Yt),$e=a(Yt,"LI",{});var Jt=r($e);Ks=a(Jt,"EM",{});var sh=r(Ks);ip=n(sh,"multinomial sampling"),sh.forEach(o),lp=n(Jt," by calling "),Zs=a(Jt,"CODE",{});var ah=r(Zs);cp=n(ah,"sample()"),ah.forEach(o),dp=n(Jt," if "),Js=a(Jt,"CODE",{});var rh=r(Js);pp=n(rh,"num_beams=1"),rh.forEach(o),mp=n(Jt,` and
`),Xs=a(Jt,"CODE",{});var ih=r(Xs);gp=n(ih,"do_sample=True"),ih.forEach(o),Jt.forEach(o),hp=g(Yt),We=a(Yt,"LI",{});var So=r(We);Qs=a(So,"EM",{});var lh=r(Qs);up=n(lh,"beam-search decoding"),lh.forEach(o),fp=n(So," by calling "),ea=a(So,"CODE",{});var ch=r(ea);_p=n(ch,"beam_search()"),ch.forEach(o),bp=n(So," if "),ta=a(So,"CODE",{});var dh=r(ta);vp=n(dh,"num_beams>1"),dh.forEach(o),So.forEach(o),Yt.forEach(o),xp=g(ae),qn=a(ae,"P",{});var lr=r(qn);yp=n(lr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),$o=a(lr,"A",{href:!0});var ph=r($o);kp=n(ph,"text generation strategies guide"),ph.forEach(o),wp=n(lr,"."),lr.forEach(o),jp=g(ae),Ce=a(ae,"DIV",{class:!0});var Po=r(Ce);w(Dn.$$.fragment,Po),$p=g(Po),na=a(Po,"P",{});var mh=r(na);Lp=n(mh,"Generates sequences of token ids for models with a language modeling head."),mh.forEach(o),Ep=g(Po),w(jt.$$.fragment,Po),Po.forEach(o),ae.forEach(o),Fa=g(l),Ue=a(l,"H2",{class:!0});var cr=r(Ue);$t=a(cr,"A",{id:!0,class:!0,href:!0});var gh=r($t);oa=a(gh,"SPAN",{});var hh=r(oa);w(An.$$.fragment,hh),hh.forEach(o),gh.forEach(o),Tp=g(cr),sa=a(cr,"SPAN",{});var uh=r(sa);Mp=n(uh,"FlaxGenerationMixin"),uh.forEach(o),cr.forEach(o),za=g(l),U=a(l,"DIV",{class:!0});var re=r(U);w(Fn.$$.fragment,re),Gp=g(re),zn=a(re,"P",{});var dr=r(zn);Op=n(dr,`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),Lo=a(dr,"A",{href:!0});var fh=r(Lo);Cp=n(fh,"FlaxPreTrainedModel"),fh.forEach(o),Sp=n(dr,"."),dr.forEach(o),Pp=g(re),Nn=a(re,"P",{});var pr=r(Nn);qp=n(pr,"The class exposes "),Eo=a(pr,"A",{href:!0});var _h=r(Eo);Dp=n(_h,"generate()"),_h.forEach(o),Ap=n(pr,", which can be used for:"),pr.forEach(o),Fp=g(re),Re=a(re,"UL",{});var qo=r(Re);Le=a(qo,"LI",{});var Xt=r(Le);aa=a(Xt,"EM",{});var bh=r(aa);zp=n(bh,"greedy decoding"),bh.forEach(o),Np=n(Xt," by calling "),ra=a(Xt,"CODE",{});var vh=r(ra);Ip=n(vh,"_greedy_search()"),vh.forEach(o),Bp=n(Xt," if "),ia=a(Xt,"CODE",{});var xh=r(ia);Wp=n(xh,"num_beams=1"),xh.forEach(o),Up=n(Xt,` and
`),la=a(Xt,"CODE",{});var yh=r(la);Rp=n(yh,"do_sample=False"),yh.forEach(o),Xt.forEach(o),Hp=g(qo),Ee=a(qo,"LI",{});var Qt=r(Ee);ca=a(Qt,"EM",{});var kh=r(ca);Vp=n(kh,"multinomial sampling"),kh.forEach(o),Yp=n(Qt," by calling "),da=a(Qt,"CODE",{});var wh=r(da);Kp=n(wh,"_sample()"),wh.forEach(o),Zp=n(Qt," if "),pa=a(Qt,"CODE",{});var jh=r(pa);Jp=n(jh,"num_beams=1"),jh.forEach(o),Xp=n(Qt,` and
`),ma=a(Qt,"CODE",{});var $h=r(ma);Qp=n($h,"do_sample=True"),$h.forEach(o),Qt.forEach(o),em=g(qo),Te=a(qo,"LI",{});var en=r(Te);ga=a(en,"EM",{});var Lh=r(ga);tm=n(Lh,"beam-search decoding"),Lh.forEach(o),nm=n(en," by calling "),ha=a(en,"CODE",{});var Eh=r(ha);om=n(Eh,"_beam_search()"),Eh.forEach(o),sm=n(en," if "),ua=a(en,"CODE",{});var Th=r(ua);am=n(Th,"num_beams>1"),Th.forEach(o),rm=n(en,` and
`),fa=a(en,"CODE",{});var Mh=r(fa);im=n(Mh,"do_sample=False"),Mh.forEach(o),en.forEach(o),qo.forEach(o),lm=g(re),In=a(re,"P",{});var mr=r(In);cm=n(mr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),To=a(mr,"A",{href:!0});var Gh=r(To);dm=n(Gh,"text generation strategies guide"),Gh.forEach(o),pm=n(mr,"."),mr.forEach(o),mm=g(re),Lt=a(re,"DIV",{class:!0});var gr=r(Lt);w(Bn.$$.fragment,gr),gm=g(gr),_a=a(gr,"P",{});var Oh=r(_a);hm=n(Oh,"Generates sequences of token ids for models with a language modeling head."),Oh.forEach(o),gr.forEach(o),re.forEach(o),this.h()},h(){u(c,"name","hf:doc:metadata"),u(c,"content",JSON.stringify(nu)),u(d,"id","generation"),u(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(d,"href","#generation"),u(p,"class","relative group"),u(J,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),u(R,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin"),u(Hn,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),u(Vn,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.TFGenerationMixin"),u(Yn,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),u(Kn,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin"),u(Zn,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(Jn,"href","./generation_strategies"),u(nt,"id","transformers.GenerationConfig"),u(nt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(nt,"href","#transformers.GenerationConfig"),u(ze,"class","relative group"),u(Xn,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(Qn,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(eo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(to,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(no,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u(oo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(so,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(ao,"href","./generation_strategies"),u(ro,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(io,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(lo,"href","/docs/transformers/v4.26.1/en/main_classes/configuration#transformers.PretrainedConfig"),u(co,"href","/docs/transformers/v4.26.1/en/main_classes/configuration#transformers.PretrainedConfig"),u(po,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(mo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained"),u(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(rt,"id","transformers.GenerationMixin"),u(rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(rt,"href","#transformers.GenerationMixin"),u(Ie,"class","relative group"),u(go,"href","/docs/transformers/v4.26.1/en/main_classes/model#transformers.PreTrainedModel"),u(ho,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),u(uo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(fo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(_o,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(bo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(vo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u(xo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(yo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(ko,"href","./generation_strategies"),u(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(wt,"id","transformers.TFGenerationMixin"),u(wt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(wt,"href","#transformers.TFGenerationMixin"),u(Be,"class","relative group"),u(wo,"href","/docs/transformers/v4.26.1/en/main_classes/model#transformers.TFPreTrainedModel"),u(jo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),u($o,"href","./generation_strategies"),u(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u($t,"id","transformers.FlaxGenerationMixin"),u($t,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u($t,"href","#transformers.FlaxGenerationMixin"),u(Ue,"class","relative group"),u(Lo,"href","/docs/transformers/v4.26.1/en/main_classes/model#transformers.FlaxPreTrainedModel"),u(Eo,"href","/docs/transformers/v4.26.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),u(To,"href","./generation_strategies"),u(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(l,v){e(document.head,c),y(l,_,v),y(l,p,v),e(p,d),e(d,f),j(i,f,null),e(p,h),e(p,T),e(T,x),y(l,b,v),y(l,G,v),e(G,O),e(G,D),e(D,ie),e(G,N),y(l,Z,v),y(l,F,v),e(F,C),e(C,P),e(C,J),e(J,Pe),e(C,qe),e(C,R),e(R,De),e(C,hr),e(F,ur),e(F,Ae),e(Ae,fr),e(Ae,Hn),e(Hn,_r),e(Ae,br),e(Ae,Vn),e(Vn,vr),e(Ae,xr),e(F,yr),e(F,Fe),e(Fe,kr),e(Fe,Yn),e(Yn,wr),e(Fe,jr),e(Fe,Kn),e(Kn,$r),e(Fe,Lr),y(l,Ga,v),y(l,et,v),e(et,Er),e(et,Zn),e(Zn,Tr),e(et,Mr),y(l,Oa,v),y(l,tt,v),e(tt,Gr),e(tt,Jn),e(Jn,Or),e(tt,Cr),y(l,Ca,v),y(l,ze,v),e(ze,nt),e(nt,Do),j(tn,Do,null),e(ze,Sr),e(ze,Ao),e(Ao,Pr),y(l,Sa,v),y(l,A,v),j(nn,A,null),e(A,qr),e(A,on),e(on,Dr),e(on,Fo),e(Fo,Ar),e(on,Fr),e(A,zr),e(A,I),e(I,le),e(le,zo),e(zo,Nr),e(le,Ir),e(le,Xn),e(Xn,Br),e(le,Wr),e(le,No),e(No,Ur),e(le,Rr),e(le,Io),e(Io,Hr),e(I,Vr),e(I,ce),e(ce,Bo),e(Bo,Yr),e(ce,Kr),e(ce,Qn),e(Qn,Zr),e(ce,Jr),e(ce,Wo),e(Wo,Xr),e(ce,Qr),e(ce,Uo),e(Uo,ei),e(I,ti),e(I,de),e(de,Ro),e(Ro,ni),e(de,oi),e(de,eo),e(eo,si),e(de,ai),e(de,Ho),e(Ho,ri),e(de,ii),e(de,Vo),e(Vo,li),e(I,ci),e(I,pe),e(pe,Yo),e(Yo,di),e(pe,pi),e(pe,to),e(to,mi),e(pe,gi),e(pe,Ko),e(Ko,hi),e(pe,ui),e(pe,Zo),e(Zo,fi),e(I,_i),e(I,me),e(me,Jo),e(Jo,bi),e(me,vi),e(me,no),e(no,xi),e(me,yi),e(me,Xo),e(Xo,ki),e(me,wi),e(me,Qo),e(Qo,ji),e(I,$i),e(I,ge),e(ge,es),e(es,Li),e(ge,Ei),e(ge,oo),e(oo,Ti),e(ge,Mi),e(ge,ts),e(ts,Gi),e(ge,Oi),e(ge,ns),e(ns,Ci),e(I,Si),e(I,he),e(he,os),e(os,Pi),e(he,qi),e(he,so),e(so,Di),e(he,Ai),e(he,ss),e(ss,Fi),e(he,zi),e(he,as),e(as,Ni),e(A,Ii),e(A,sn),e(sn,Bi),e(sn,ao),e(ao,Wi),e(sn,Ui),e(A,Ri),e(A,Me),j(an,Me,null),e(Me,Hi),e(Me,rn),e(rn,Vi),e(rn,ro),e(ro,Yi),e(rn,Ki),e(Me,Zi),j(ot,Me,null),e(A,Ji),e(A,st),j(ln,st,null),e(st,Xi),e(st,K),e(K,Qi),e(K,io),e(io,el),e(K,tl),e(K,lo),e(lo,nl),e(K,ol),e(K,co),e(co,sl),e(K,al),e(K,po),e(po,rl),e(K,il),e(A,ll),e(A,at),j(cn,at,null),e(at,cl),e(at,Ne),e(Ne,dl),e(Ne,rs),e(rs,pl),e(Ne,ml),e(Ne,mo),e(mo,gl),e(Ne,hl),y(l,Pa,v),y(l,Ie,v),e(Ie,rt),e(rt,is),j(dn,is,null),e(Ie,ul),e(Ie,ls),e(ls,fl),y(l,qa,v),y(l,S,v),j(pn,S,null),e(S,_l),e(S,mn),e(mn,bl),e(mn,go),e(go,vl),e(mn,xl),e(S,yl),e(S,gn),e(gn,kl),e(gn,ho),e(ho,wl),e(gn,jl),e(S,$l),e(S,B),e(B,ue),e(ue,cs),e(cs,Ll),e(ue,El),e(ue,uo),e(uo,Tl),e(ue,Ml),e(ue,ds),e(ds,Gl),e(ue,Ol),e(ue,ps),e(ps,Cl),e(B,Sl),e(B,fe),e(fe,ms),e(ms,Pl),e(fe,ql),e(fe,fo),e(fo,Dl),e(fe,Al),e(fe,gs),e(gs,Fl),e(fe,zl),e(fe,hs),e(hs,Nl),e(B,Il),e(B,_e),e(_e,us),e(us,Bl),e(_e,Wl),e(_e,_o),e(_o,Ul),e(_e,Rl),e(_e,fs),e(fs,Hl),e(_e,Vl),e(_e,_s),e(_s,Yl),e(B,Kl),e(B,be),e(be,bs),e(bs,Zl),e(be,Jl),e(be,bo),e(bo,Xl),e(be,Ql),e(be,vs),e(vs,ec),e(be,tc),e(be,xs),e(xs,nc),e(B,oc),e(B,ve),e(ve,ys),e(ys,sc),e(ve,ac),e(ve,vo),e(vo,rc),e(ve,ic),e(ve,ks),e(ks,lc),e(ve,cc),e(ve,ws),e(ws,dc),e(B,pc),e(B,xe),e(xe,js),e(js,mc),e(xe,gc),e(xe,xo),e(xo,hc),e(xe,uc),e(xe,$s),e($s,fc),e(xe,_c),e(xe,Ls),e(Ls,bc),e(B,vc),e(B,ye),e(ye,Es),e(Es,xc),e(ye,yc),e(ye,yo),e(yo,kc),e(ye,wc),e(ye,Ts),e(Ts,jc),e(ye,$c),e(ye,Ms),e(Ms,Lc),e(S,Ec),e(S,hn),e(hn,Tc),e(hn,ko),e(ko,Mc),e(hn,Gc),e(S,Oc),e(S,Ge),j(un,Ge,null),e(Ge,Cc),e(Ge,Gs),e(Gs,Sc),e(Ge,Pc),j(it,Ge,null),e(S,qc),e(S,Oe),j(fn,Oe,null),e(Oe,Dc),e(Oe,Os),e(Os,Ac),e(Oe,Fc),j(lt,Oe,null),e(S,zc),e(S,X),j(_n,X,null),e(X,Nc),e(X,bn),e(bn,Ic),e(bn,Cs),e(Cs,Bc),e(bn,Wc),e(X,Uc),j(ct,X,null),e(X,Rc),j(dt,X,null),e(S,Hc),e(S,Q),j(vn,Q,null),e(Q,Vc),e(Q,xn),e(xn,Yc),e(xn,Ss),e(Ss,Kc),e(xn,Zc),e(Q,Jc),j(pt,Q,null),e(Q,Xc),j(mt,Q,null),e(S,Qc),e(S,ee),j(yn,ee,null),e(ee,ed),e(ee,kn),e(kn,td),e(kn,Ps),e(Ps,nd),e(kn,od),e(ee,sd),j(gt,ee,null),e(ee,ad),j(ht,ee,null),e(S,rd),e(S,te),j(wn,te,null),e(te,id),e(te,jn),e(jn,ld),e(jn,qs),e(qs,cd),e(jn,dd),e(te,pd),j(ut,te,null),e(te,md),j(ft,te,null),e(S,gd),e(S,ne),j($n,ne,null),e(ne,hd),e(ne,Ln),e(Ln,ud),e(Ln,Ds),e(Ds,fd),e(Ln,_d),e(ne,bd),j(_t,ne,null),e(ne,vd),j(bt,ne,null),e(S,xd),e(S,oe),j(En,oe,null),e(oe,yd),e(oe,Tn),e(Tn,kd),e(Tn,As),e(As,wd),e(Tn,jd),e(oe,$d),j(vt,oe,null),e(oe,Ld),j(xt,oe,null),e(S,Ed),e(S,se),j(Mn,se,null),e(se,Td),e(se,Gn),e(Gn,Md),e(Gn,Fs),e(Fs,Gd),e(Gn,Od),e(se,Cd),j(yt,se,null),e(se,Sd),j(kt,se,null),y(l,Da,v),y(l,Be,v),e(Be,wt),e(wt,zs),j(On,zs,null),e(Be,Pd),e(Be,Ns),e(Ns,qd),y(l,Aa,v),y(l,W,v),j(Cn,W,null),e(W,Dd),e(W,Sn),e(Sn,Ad),e(Sn,wo),e(wo,Fd),e(Sn,zd),e(W,Nd),e(W,Pn),e(Pn,Id),e(Pn,jo),e(jo,Bd),e(Pn,Wd),e(W,Ud),e(W,ke),e(ke,we),e(we,Is),e(Is,Rd),e(we,Hd),e(we,Bs),e(Bs,Vd),e(we,Yd),e(we,Ws),e(Ws,Kd),e(we,Zd),e(we,Us),e(Us,Jd),e(ke,Xd),e(ke,je),e(je,Rs),e(Rs,Qd),e(je,ep),e(je,Hs),e(Hs,tp),e(je,np),e(je,Vs),e(Vs,op),e(je,sp),e(je,Ys),e(Ys,ap),e(ke,rp),e(ke,$e),e($e,Ks),e(Ks,ip),e($e,lp),e($e,Zs),e(Zs,cp),e($e,dp),e($e,Js),e(Js,pp),e($e,mp),e($e,Xs),e(Xs,gp),e(ke,hp),e(ke,We),e(We,Qs),e(Qs,up),e(We,fp),e(We,ea),e(ea,_p),e(We,bp),e(We,ta),e(ta,vp),e(W,xp),e(W,qn),e(qn,yp),e(qn,$o),e($o,kp),e(qn,wp),e(W,jp),e(W,Ce),j(Dn,Ce,null),e(Ce,$p),e(Ce,na),e(na,Lp),e(Ce,Ep),j(jt,Ce,null),y(l,Fa,v),y(l,Ue,v),e(Ue,$t),e($t,oa),j(An,oa,null),e(Ue,Tp),e(Ue,sa),e(sa,Mp),y(l,za,v),y(l,U,v),j(Fn,U,null),e(U,Gp),e(U,zn),e(zn,Op),e(zn,Lo),e(Lo,Cp),e(zn,Sp),e(U,Pp),e(U,Nn),e(Nn,qp),e(Nn,Eo),e(Eo,Dp),e(Nn,Ap),e(U,Fp),e(U,Re),e(Re,Le),e(Le,aa),e(aa,zp),e(Le,Np),e(Le,ra),e(ra,Ip),e(Le,Bp),e(Le,ia),e(ia,Wp),e(Le,Up),e(Le,la),e(la,Rp),e(Re,Hp),e(Re,Ee),e(Ee,ca),e(ca,Vp),e(Ee,Yp),e(Ee,da),e(da,Kp),e(Ee,Zp),e(Ee,pa),e(pa,Jp),e(Ee,Xp),e(Ee,ma),e(ma,Qp),e(Re,em),e(Re,Te),e(Te,ga),e(ga,tm),e(Te,nm),e(Te,ha),e(ha,om),e(Te,sm),e(Te,ua),e(ua,am),e(Te,rm),e(Te,fa),e(fa,im),e(U,lm),e(U,In),e(In,cm),e(In,To),e(To,dm),e(In,pm),e(U,mm),e(U,Lt),j(Bn,Lt,null),e(Lt,gm),e(Lt,_a),e(_a,hm),Na=!0},p(l,[v]){const Wn={};v&2&&(Wn.$$scope={dirty:v,ctx:l}),ot.$set(Wn);const ba={};v&2&&(ba.$$scope={dirty:v,ctx:l}),it.$set(ba);const va={};v&2&&(va.$$scope={dirty:v,ctx:l}),lt.$set(va);const xa={};v&2&&(xa.$$scope={dirty:v,ctx:l}),ct.$set(xa);const Un={};v&2&&(Un.$$scope={dirty:v,ctx:l}),dt.$set(Un);const ya={};v&2&&(ya.$$scope={dirty:v,ctx:l}),pt.$set(ya);const He={};v&2&&(He.$$scope={dirty:v,ctx:l}),mt.$set(He);const Ve={};v&2&&(Ve.$$scope={dirty:v,ctx:l}),gt.$set(Ve);const ka={};v&2&&(ka.$$scope={dirty:v,ctx:l}),ht.$set(ka);const wa={};v&2&&(wa.$$scope={dirty:v,ctx:l}),ut.$set(wa);const Ye={};v&2&&(Ye.$$scope={dirty:v,ctx:l}),ft.$set(Ye);const ja={};v&2&&(ja.$$scope={dirty:v,ctx:l}),_t.$set(ja);const $a={};v&2&&($a.$$scope={dirty:v,ctx:l}),bt.$set($a);const Ke={};v&2&&(Ke.$$scope={dirty:v,ctx:l}),vt.$set(Ke);const La={};v&2&&(La.$$scope={dirty:v,ctx:l}),xt.$set(La);const Ea={};v&2&&(Ea.$$scope={dirty:v,ctx:l}),yt.$set(Ea);const Rn={};v&2&&(Rn.$$scope={dirty:v,ctx:l}),kt.$set(Rn);const Ta={};v&2&&(Ta.$$scope={dirty:v,ctx:l}),jt.$set(Ta)},i(l){Na||($(i.$$.fragment,l),$(tn.$$.fragment,l),$(nn.$$.fragment,l),$(an.$$.fragment,l),$(ot.$$.fragment,l),$(ln.$$.fragment,l),$(cn.$$.fragment,l),$(dn.$$.fragment,l),$(pn.$$.fragment,l),$(un.$$.fragment,l),$(it.$$.fragment,l),$(fn.$$.fragment,l),$(lt.$$.fragment,l),$(_n.$$.fragment,l),$(ct.$$.fragment,l),$(dt.$$.fragment,l),$(vn.$$.fragment,l),$(pt.$$.fragment,l),$(mt.$$.fragment,l),$(yn.$$.fragment,l),$(gt.$$.fragment,l),$(ht.$$.fragment,l),$(wn.$$.fragment,l),$(ut.$$.fragment,l),$(ft.$$.fragment,l),$($n.$$.fragment,l),$(_t.$$.fragment,l),$(bt.$$.fragment,l),$(En.$$.fragment,l),$(vt.$$.fragment,l),$(xt.$$.fragment,l),$(Mn.$$.fragment,l),$(yt.$$.fragment,l),$(kt.$$.fragment,l),$(On.$$.fragment,l),$(Cn.$$.fragment,l),$(Dn.$$.fragment,l),$(jt.$$.fragment,l),$(An.$$.fragment,l),$(Fn.$$.fragment,l),$(Bn.$$.fragment,l),Na=!0)},o(l){L(i.$$.fragment,l),L(tn.$$.fragment,l),L(nn.$$.fragment,l),L(an.$$.fragment,l),L(ot.$$.fragment,l),L(ln.$$.fragment,l),L(cn.$$.fragment,l),L(dn.$$.fragment,l),L(pn.$$.fragment,l),L(un.$$.fragment,l),L(it.$$.fragment,l),L(fn.$$.fragment,l),L(lt.$$.fragment,l),L(_n.$$.fragment,l),L(ct.$$.fragment,l),L(dt.$$.fragment,l),L(vn.$$.fragment,l),L(pt.$$.fragment,l),L(mt.$$.fragment,l),L(yn.$$.fragment,l),L(gt.$$.fragment,l),L(ht.$$.fragment,l),L(wn.$$.fragment,l),L(ut.$$.fragment,l),L(ft.$$.fragment,l),L($n.$$.fragment,l),L(_t.$$.fragment,l),L(bt.$$.fragment,l),L(En.$$.fragment,l),L(vt.$$.fragment,l),L(xt.$$.fragment,l),L(Mn.$$.fragment,l),L(yt.$$.fragment,l),L(kt.$$.fragment,l),L(On.$$.fragment,l),L(Cn.$$.fragment,l),L(Dn.$$.fragment,l),L(jt.$$.fragment,l),L(An.$$.fragment,l),L(Fn.$$.fragment,l),L(Bn.$$.fragment,l),Na=!1},d(l){o(c),l&&o(_),l&&o(p),E(i),l&&o(b),l&&o(G),l&&o(Z),l&&o(F),l&&o(Ga),l&&o(et),l&&o(Oa),l&&o(tt),l&&o(Ca),l&&o(ze),E(tn),l&&o(Sa),l&&o(A),E(nn),E(an),E(ot),E(ln),E(cn),l&&o(Pa),l&&o(Ie),E(dn),l&&o(qa),l&&o(S),E(pn),E(un),E(it),E(fn),E(lt),E(_n),E(ct),E(dt),E(vn),E(pt),E(mt),E(yn),E(gt),E(ht),E(wn),E(ut),E(ft),E($n),E(_t),E(bt),E(En),E(vt),E(xt),E(Mn),E(yt),E(kt),l&&o(Da),l&&o(Be),E(On),l&&o(Aa),l&&o(W),E(Cn),E(Dn),E(jt),l&&o(Fa),l&&o(Ue),E(An),l&&o(za),l&&o(U),E(Fn),E(Bn)}}}const nu={local:"generation",sections:[{local:"transformers.GenerationConfig",title:"GenerationConfig"},{local:"transformers.GenerationMixin",title:"GenerationMixin"},{local:"transformers.TFGenerationMixin",title:"TFGenerationMixin"},{local:"transformers.FlaxGenerationMixin",title:"FlaxGenerationMixin"}],title:"Generation"};function ou(M){return Dh(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class du extends Ch{constructor(c){super();Sh(this,c,ou,tu,Ph,{})}}export{du as default,nu as metadata};
