import{s as vn,o as In,n as Nt}from"../chunks/scheduler.182ea377.js";import{S as Tn,i as Jn,g as l,s as i,r as f,A as xn,h as r,f as n,c as a,j as J,u,x as d,k as x,y as o,a as s,v as g,d as h,t as _,w as b}from"../chunks/index.abf12888.js";import{T as wn}from"../chunks/Tip.230e2334.js";import{D as Z}from"../chunks/Docstring.93f6f462.js";import{C as Et}from"../chunks/CodeBlock.57fe6e13.js";import{E as Pn}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as E}from"../chunks/Heading.16916d63.js";function Un(j){let p,v="If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the PIA checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){p=l("p"),p.innerHTML=v},l(y){p=r(y,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1a93myr"&&(p.innerHTML=v)},m(y,w){s(y,p,w)},p:Nt,d(y){y&&n(p)}}}function Zn(j){let p,v="FreeInit is not really free - the improved quality comes at the cost of extra computation. It requires sampling a few extra times depending on the <code>num_iters</code> parameter that is set when enabling it. Setting the <code>use_fast_sampling</code> parameter to <code>True</code> can improve the overall performance (at the cost of lower quality compared to when <code>use_fast_sampling=False</code> but still better results than vanilla video generation models).";return{c(){p=l("p"),p.innerHTML=v},l(y){p=r(y,"P",{"data-svelte-h":!0}),d(p)!=="svelte-xxwpr5"&&(p.innerHTML=v)},m(y,w){s(y,p,w)},p:Nt,d(y){y&&n(p)}}}function $n(j){let p,v="Examples:",y,w,I;return w=new Et({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    EulerDiscreteScheduler,
<span class="hljs-meta">... </span>    MotionAdapter,
<span class="hljs-meta">... </span>    PIAPipeline,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image
<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;../checkpoints/pia-diffusers&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = EulerDiscreteScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat in a hat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality, deformed, distorted, disfigured, bad eyes, wrong lips,weird mouth, bad teeth, mutated hands and fingers, bad anatomy,wrong anatomy, amputation, extra limb, missing limb, floating,limbs, disconnected limbs, mutation, ugly, disgusting, bad_pictures, negative_hand-neg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(image=image, prompt=prompt, negative_prompt=negative_prompt, generator=generator)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;pia-animation.gif&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=v,y=i(),f(w.$$.fragment)},l(M){p=r(M,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=v),y=a(M),u(w.$$.fragment,M)},m(M,P){s(M,p,P),s(M,y,P),g(w,M,P),I=!0},p:Nt,i(M){I||(h(w.$$.fragment,M),I=!0)},o(M){_(w.$$.fragment,M),I=!1},d(M){M&&(n(p),n(y)),b(w,M)}}}function kn(j){let p,v,y,w,I,M,P,Xe,N,Lt='<a href="https://arxiv.org/abs/2312.13964" rel="nofollow">PIA: Your Personalized Image Animator via Plug-and-Play Modules in Text-to-Image Models</a> by Yiming Zhang, Zhening Xing, Yanhong Zeng, Youqing Fang, Kai Chen',Re,L,St="Recent advancements in personalized text-to-image (T2I) models have revolutionized content creation, empowering non-experts to generate stunning images with unique styles. While promising, adding realistic motions into these personalized images by text poses significant challenges in preserving distinct styles, high-fidelity details, and achieving motion controllability by text. In this paper, we present PIA, a Personalized Image Animator that excels in aligning with condition images, achieving motion controllability by text, and the compatibility with various personalized T2I models without specific tuning. To achieve these goals, PIA builds upon a base T2I model with well-trained temporal alignment layers, allowing for the seamless transformation of any personalized T2I model into an image animation model. A key component of PIA is the introduction of the condition module, which utilizes the condition frame and inter-frame affinity as input to transfer appearance information guided by the affinity hint for individual frame synthesis in the latent space. This design mitigates the challenges of appearance-related image alignment within and allows for a stronger focus on aligning with motion-related guidance.",Fe,S,Ht='<a href="https://pi-animator.github.io/" rel="nofollow">Project page</a>',Ye,H,Ee,D,Dt='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py" rel="nofollow">PIAPipeline</a></td> <td><em>Image-to-Video Generation with PIA</em></td> <td align="center"></td></tr></tbody>',Ne,z,Le,Q,zt='Motion Adapter checkpoints for PIA can be found under the <a href="https://huggingface.co/openmmlab/PIA-condition-adapter" rel="nofollow">OpenMMLab org</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.5',Se,q,He,O,Qt="PIA works with a MotionAdapter checkpoint and a Stable Diffusion 1.5 model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in the Stable Diffusion UNet. In addition to the motion modules, PIA also replaces the input convolution layer of the SD 1.5 UNet model with a 9 channel input convolution layer.",De,K,qt="The following example demonstrates how to use PIA to generate a video from a single image.",ze,ee,Qe,te,Ot="Here are some sample outputs:",qe,ne,Kt=`<tbody><tr><td><center>cat in a field.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pia-default-output.gif" alt="cat in a field" style="width: 300px;"/></center></td></tr></tbody>`,Oe,G,Ke,ie,et,ae,en='<a href="https://arxiv.org/abs/2312.07537" rel="nofollow">FreeInit: Bridging Initialization Gap in Video Diffusion Models</a> by Tianxing Wu, Chenyang Si, Yuming Jiang, Ziqi Huang, Ziwei Liu.',tt,se,tn="FreeInit is an effective method that improves temporal consistency and overall quality of videos generated using video-diffusion-models without any addition training. It can be applied to PIA, AnimateDiff, ModelScope, VideoCrafter and various other video generation models seamlessly at inference time, and works by iteratively refining the latent-initialization noise. More details can be found it the paper.",nt,oe,nn="The following example demonstrates the usage of FreeInit.",it,le,at,re,an=`<tbody><tr><td><center>cat in a field.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pia-freeinit-output-cat.gif" alt="cat in a field" style="width: 300px;"/></center></td></tr></tbody>`,st,A,ot,pe,lt,c,de,yt,Ie,sn="Pipeline for text-to-video generation.",Mt,Te,on=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,wt,Je,ln="The pipeline also inherits the following loading methods:",vt,xe,rn='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',It,U,ce,Tt,Pe,pn="The call function to the pipeline for generation.",Jt,C,xt,W,me,Pt,Ue,dn="Disables the FreeU mechanism if enabled.",Ut,B,fe,Zt,Ze,cn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,$t,V,ue,kt,$e,mn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,jt,T,ge,Gt,ke,fn='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',At,je,un="The suffixes after the scaling factors represent the stages where they are being applied.",Ct,Ge,gn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Wt,X,he,Bt,Ae,hn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Vt,R,_e,Xt,Ce,_n=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Rt,F,be,Ft,We,bn="Encodes the prompt into text encoder hidden states.",rt,ye,yn="<li>enable_freeu</li> <li>disable_freeu</li> <li>enable_free_init</li> <li>disable_free_init</li> <li>enable_vae_slicing</li> <li>disable_vae_slicing</li> <li>enable_vae_tiling</li> <li>disable_vae_tiling</li>",pt,Me,dt,$,we,Yt,Be,Mn="Output class for PIAPipeline.",ct,Ve,mt;return I=new E({props:{title:"Image-to-Video Generation with PIA (Personalized Image Animator)",local:"image-to-video-generation-with-pia-personalized-image-animator",headingTag:"h1"}}),P=new E({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new E({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),z=new E({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),q=new E({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ee=new Et({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBNb3Rpb25BZGFwdGVyJTJDJTBBJTIwJTIwJTIwJTIwUElBUGlwZWxpbmUlMkMlMEEpJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMkMlMjBsb2FkX2ltYWdlJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5tbWxhYiUyRlBJQS1jb25kaXRpb24tYWRhcHRlciUyMiklMEFwaXBlJTIwJTNEJTIwUElBUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpeDJwaXglMkZjYXRfNi5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIlMEEpJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwaW4lMjBhJTIwZmllbGQlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3cm9uZyUyMHdoaXRlJTIwYmFsYW5jZSUyQyUyMGRhcmslMkMlMjBza2V0Y2hlcyUyQ3dvcnN0JTIwcXVhbGl0eSUyQ2xvdyUyMHF1YWxpdHklMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQW91dHB1dCUyMCUzRCUyMHBpcGUoaW1hZ2UlM0RpbWFnZSUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciklMEFmcmFtZXMlMjAlM0QlMjBvdXRwdXQuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b19naWYoZnJhbWVzJTJDJTIwJTIycGlhLWFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    EulerDiscreteScheduler,
    MotionAdapter,
    PIAPipeline,
)
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.scheduler = EulerDiscreteScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()
pipe.enable_vae_slicing()

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
)
image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;cat in a field&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
output = pipe(image=image, prompt=prompt, generator=generator)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;pia-animation.gif&quot;</span>)`,wrap:!1}}),G=new wn({props:{$$slots:{default:[Un]},$$scope:{ctx:j}}}),ie=new E({props:{title:"Using FreeInit",local:"using-freeinit",headingTag:"h2"}}),le=new Et({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMERESU1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBNb3Rpb25BZGFwdGVyJTJDJTBBJTIwJTIwJTIwJTIwUElBUGlwZWxpbmUlMkMlMEEpJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMkMlMjBsb2FkX2ltYWdlJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5tbWxhYiUyRlBJQS1jb25kaXRpb24tYWRhcHRlciUyMiklMEFwaXBlJTIwJTNEJTIwUElBUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyKSUwQSUwQSUyMyUyMGVuYWJsZSUyMEZyZWVJbml0JTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMGVuYWJsZV9mcmVlX2luaXQlMjBkb2N1bWVudGF0aW9uJTIwZm9yJTIwYSUyMGZ1bGwlMjBsaXN0JTIwb2YlMjBjb25maWd1cmFibGUlMjBwYXJhbWV0ZXJzJTBBcGlwZS5lbmFibGVfZnJlZV9pbml0KG1ldGhvZCUzRCUyMmJ1dHRlcndvcnRoJTIyJTJDJTIwdXNlX2Zhc3Rfc2FtcGxpbmclM0RUcnVlKSUwQSUwQSUyMyUyME1lbW9yeSUyMHNhdmluZyUyMG9wdGlvbnMlMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXgycGl4JTJGY2F0XzYucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMGluJTIwYSUyMGZpZWxkJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyd3JvbmclMjB3aGl0ZSUyMGJhbGFuY2UlMkMlMjBkYXJrJTJDJTIwc2tldGNoZXMlMkN3b3JzdCUyMHF1YWxpdHklMkNsb3clMjBxdWFsaXR5JTIyJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlKGltYWdlJTNEaW1hZ2UlMkMlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMnBpYS1mcmVlaW5pdC1hbmltYXRpb24uZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDIMScheduler,
    MotionAdapter,
    PIAPipeline,
)
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter)

<span class="hljs-comment"># enable FreeInit</span>
<span class="hljs-comment"># Refer to the enable_free_init documentation for a full list of configurable parameters</span>
pipe.enable_free_init(method=<span class="hljs-string">&quot;butterworth&quot;</span>, use_fast_sampling=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Memory saving options</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_slicing()

pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
)
image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;cat in a field&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

output = pipe(image=image, prompt=prompt, generator=generator)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;pia-freeinit-animation.gif&quot;</span>)`,wrap:!1}}),A=new wn({props:{warning:!0,$$slots:{default:[Zn]},$$scope:{ctx:j}}}),pe=new E({props:{title:"PIAPipeline",local:"diffusers.PIAPipeline",headingTag:"h2"}}),de=new Z({props:{name:"class diffusers.PIAPipeline",anchor:"diffusers.PIAPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"scheduler",val:": Union"},{name:"motion_adapter",val:": Optional = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PIAPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.PIAPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.PIAPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.PIAPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.PIAPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L213"}}),ce=new Z({props:{name:"__call__",anchor:"diffusers.PIAPipeline.__call__",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Union = None"},{name:"strength",val:": float = 1.0"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"motion_scale",val:": int = 0"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to be used for video generation.`,name:"image"},{anchor:"diffusers.PIAPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.PIAPipeline.__call__.strength",description:"<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014; Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1.",name:"strength"},{anchor:"diffusers.PIAPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.PIAPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.PIAPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.PIAPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PIAPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.PIAPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PIAPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.PIAPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.PIAPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.PIAPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PIAPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PIAPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.
motion_scale &#x2014; (<code>int</code>, <em>optional</em>, defaults to 0):
Parameter that controls the amount and type of motion that is added to the image. Increasing the value increases the amount of motion, while specific
ranges of values control the type of motion that is added. Must be between 0 and 8.
Set between 0-2 to only increase the amount of motion.
Set between 3-5 to create looping motion.
Set between 6-8 to perform motion with image style transfer.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.PIAPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PIAPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PIAPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.PIAPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.PIAPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.PIAPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L782",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),C=new Pn({props:{anchor:"diffusers.PIAPipeline.__call__.example",$$slots:{default:[$n]},$$scope:{ctx:j}}}),me=new Z({props:{name:"disable_freeu",anchor:"diffusers.PIAPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L560"}}),fe=new Z({props:{name:"disable_vae_slicing",anchor:"diffusers.PIAPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L512"}}),ue=new Z({props:{name:"disable_vae_tiling",anchor:"diffusers.PIAPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L529"}}),ge=new Z({props:{name:"enable_freeu",anchor:"diffusers.PIAPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.PIAPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.PIAPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.PIAPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L537"}}),he=new Z({props:{name:"enable_vae_slicing",anchor:"diffusers.PIAPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L504"}}),_e=new Z({props:{name:"enable_vae_tiling",anchor:"diffusers.PIAPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L520"}}),be=new Z({props:{name:"encode_prompt",anchor:"diffusers.PIAPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PIAPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PIAPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PIAPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.PIAPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L284"}}),Me=new E({props:{title:"PIAPipelineOutput",local:"diffusers.pipelines.pia.PIAPipelineOutput",headingTag:"h2"}}),we=new Z({props:{name:"class diffusers.pipelines.pia.PIAPipelineOutput",anchor:"diffusers.pipelines.pia.PIAPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.frames",description:"<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;",name:"frames"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.Nested",description:"<strong>Nested</strong> list of length <code>batch_size</code> with denoised PIL image sequences of length <code>num_frames</code>, &#x2014;",name:"Nested"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.NumPy",description:"<strong>NumPy</strong> array of shape `(batch_size, num_frames, channels, height, width, &#x2014;",name:"NumPy"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.Torch",description:"<strong>Torch</strong> tensor of shape <code>(batch_size, num_frames, channels, height, width)</code>. &#x2014;",name:"Torch"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L198"}}),{c(){p=l("meta"),v=i(),y=l("p"),w=i(),f(I.$$.fragment),M=i(),f(P.$$.fragment),Xe=i(),N=l("p"),N.innerHTML=Lt,Re=i(),L=l("p"),L.textContent=St,Fe=i(),S=l("p"),S.innerHTML=Ht,Ye=i(),f(H.$$.fragment),Ee=i(),D=l("table"),D.innerHTML=Dt,Ne=i(),f(z.$$.fragment),Le=i(),Q=l("p"),Q.innerHTML=zt,Se=i(),f(q.$$.fragment),He=i(),O=l("p"),O.textContent=Qt,De=i(),K=l("p"),K.textContent=qt,ze=i(),f(ee.$$.fragment),Qe=i(),te=l("p"),te.textContent=Ot,qe=i(),ne=l("table"),ne.innerHTML=Kt,Oe=i(),f(G.$$.fragment),Ke=i(),f(ie.$$.fragment),et=i(),ae=l("p"),ae.innerHTML=en,tt=i(),se=l("p"),se.textContent=tn,nt=i(),oe=l("p"),oe.textContent=nn,it=i(),f(le.$$.fragment),at=i(),re=l("table"),re.innerHTML=an,st=i(),f(A.$$.fragment),ot=i(),f(pe.$$.fragment),lt=i(),c=l("div"),f(de.$$.fragment),yt=i(),Ie=l("p"),Ie.textContent=sn,Mt=i(),Te=l("p"),Te.innerHTML=on,wt=i(),Je=l("p"),Je.textContent=ln,vt=i(),xe=l("ul"),xe.innerHTML=rn,It=i(),U=l("div"),f(ce.$$.fragment),Tt=i(),Pe=l("p"),Pe.textContent=pn,Jt=i(),f(C.$$.fragment),xt=i(),W=l("div"),f(me.$$.fragment),Pt=i(),Ue=l("p"),Ue.textContent=dn,Ut=i(),B=l("div"),f(fe.$$.fragment),Zt=i(),Ze=l("p"),Ze.innerHTML=cn,$t=i(),V=l("div"),f(ue.$$.fragment),kt=i(),$e=l("p"),$e.innerHTML=mn,jt=i(),T=l("div"),f(ge.$$.fragment),Gt=i(),ke=l("p"),ke.innerHTML=fn,At=i(),je=l("p"),je.textContent=un,Ct=i(),Ge=l("p"),Ge.innerHTML=gn,Wt=i(),X=l("div"),f(he.$$.fragment),Bt=i(),Ae=l("p"),Ae.textContent=hn,Vt=i(),R=l("div"),f(_e.$$.fragment),Xt=i(),Ce=l("p"),Ce.textContent=_n,Rt=i(),F=l("div"),f(be.$$.fragment),Ft=i(),We=l("p"),We.textContent=bn,rt=i(),ye=l("ul"),ye.innerHTML=yn,pt=i(),f(Me.$$.fragment),dt=i(),$=l("div"),f(we.$$.fragment),Yt=i(),Be=l("p"),Be.textContent=Mn,ct=i(),Ve=l("p"),this.h()},l(e){const t=xn("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(n),v=a(e),y=r(e,"P",{}),J(y).forEach(n),w=a(e),u(I.$$.fragment,e),M=a(e),u(P.$$.fragment,e),Xe=a(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-nano8w"&&(N.innerHTML=Lt),Re=a(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1jcs7ly"&&(L.textContent=St),Fe=a(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-q609lx"&&(S.innerHTML=Ht),Ye=a(e),u(H.$$.fragment,e),Ee=a(e),D=r(e,"TABLE",{"data-svelte-h":!0}),d(D)!=="svelte-5p4fpx"&&(D.innerHTML=Dt),Ne=a(e),u(z.$$.fragment,e),Le=a(e),Q=r(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1bi1ry7"&&(Q.innerHTML=zt),Se=a(e),u(q.$$.fragment,e),He=a(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-woui0n"&&(O.textContent=Qt),De=a(e),K=r(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-wwfxrb"&&(K.textContent=qt),ze=a(e),u(ee.$$.fragment,e),Qe=a(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1pxzje"&&(te.textContent=Ot),qe=a(e),ne=r(e,"TABLE",{"data-svelte-h":!0}),d(ne)!=="svelte-7kzy88"&&(ne.innerHTML=Kt),Oe=a(e),u(G.$$.fragment,e),Ke=a(e),u(ie.$$.fragment,e),et=a(e),ae=r(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-a52po1"&&(ae.innerHTML=en),tt=a(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-bwalkj"&&(se.textContent=tn),nt=a(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1qq4ux4"&&(oe.textContent=nn),it=a(e),u(le.$$.fragment,e),at=a(e),re=r(e,"TABLE",{"data-svelte-h":!0}),d(re)!=="svelte-fegy4a"&&(re.innerHTML=an),st=a(e),u(A.$$.fragment,e),ot=a(e),u(pe.$$.fragment,e),lt=a(e),c=r(e,"DIV",{class:!0});var m=J(c);u(de.$$.fragment,m),yt=a(m),Ie=r(m,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-19ipoo4"&&(Ie.textContent=sn),Mt=a(m),Te=r(m,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-496sm0"&&(Te.innerHTML=on),wt=a(m),Je=r(m,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-14s6m4u"&&(Je.textContent=ln),vt=a(m),xe=r(m,"UL",{"data-svelte-h":!0}),d(xe)!=="svelte-jjuyoc"&&(xe.innerHTML=rn),It=a(m),U=r(m,"DIV",{class:!0});var k=J(U);u(ce.$$.fragment,k),Tt=a(k),Pe=r(k,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-50j04k"&&(Pe.textContent=pn),Jt=a(k),u(C.$$.fragment,k),k.forEach(n),xt=a(m),W=r(m,"DIV",{class:!0});var ve=J(W);u(me.$$.fragment,ve),Pt=a(ve),Ue=r(ve,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-psupw6"&&(Ue.textContent=dn),ve.forEach(n),Ut=a(m),B=r(m,"DIV",{class:!0});var ft=J(B);u(fe.$$.fragment,ft),Zt=a(ft),Ze=r(ft,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-1s3c06i"&&(Ze.innerHTML=cn),ft.forEach(n),$t=a(m),V=r(m,"DIV",{class:!0});var ut=J(V);u(ue.$$.fragment,ut),kt=a(ut),$e=r(ut,"P",{"data-svelte-h":!0}),d($e)!=="svelte-pkn4ui"&&($e.innerHTML=mn),ut.forEach(n),jt=a(m),T=r(m,"DIV",{class:!0});var Y=J(T);u(ge.$$.fragment,Y),Gt=a(Y),ke=r(Y,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1f3tmq1"&&(ke.innerHTML=fn),At=a(Y),je=r(Y,"P",{"data-svelte-h":!0}),d(je)!=="svelte-xjijlp"&&(je.textContent=un),Ct=a(Y),Ge=r(Y,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-hy0nzs"&&(Ge.innerHTML=gn),Y.forEach(n),Wt=a(m),X=r(m,"DIV",{class:!0});var gt=J(X);u(he.$$.fragment,gt),Bt=a(gt),Ae=r(gt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-14bnrb6"&&(Ae.textContent=hn),gt.forEach(n),Vt=a(m),R=r(m,"DIV",{class:!0});var ht=J(R);u(_e.$$.fragment,ht),Xt=a(ht),Ce=r(ht,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1xwrf7t"&&(Ce.textContent=_n),ht.forEach(n),Rt=a(m),F=r(m,"DIV",{class:!0});var _t=J(F);u(be.$$.fragment,_t),Ft=a(_t),We=r(_t,"P",{"data-svelte-h":!0}),d(We)!=="svelte-16q0ax1"&&(We.textContent=bn),_t.forEach(n),m.forEach(n),rt=a(e),ye=r(e,"UL",{"data-svelte-h":!0}),d(ye)!=="svelte-1piu0vk"&&(ye.innerHTML=yn),pt=a(e),u(Me.$$.fragment,e),dt=a(e),$=r(e,"DIV",{class:!0});var bt=J($);u(we.$$.fragment,bt),Yt=a(bt),Be=r(bt,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-6skj8c"&&(Be.textContent=Mn),bt.forEach(n),ct=a(e),Ve=r(e,"P",{}),J(Ve).forEach(n),this.h()},h(){x(p,"name","hf:doc:metadata"),x(p,"content",jn),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){o(document.head,p),s(e,v,t),s(e,y,t),s(e,w,t),g(I,e,t),s(e,M,t),g(P,e,t),s(e,Xe,t),s(e,N,t),s(e,Re,t),s(e,L,t),s(e,Fe,t),s(e,S,t),s(e,Ye,t),g(H,e,t),s(e,Ee,t),s(e,D,t),s(e,Ne,t),g(z,e,t),s(e,Le,t),s(e,Q,t),s(e,Se,t),g(q,e,t),s(e,He,t),s(e,O,t),s(e,De,t),s(e,K,t),s(e,ze,t),g(ee,e,t),s(e,Qe,t),s(e,te,t),s(e,qe,t),s(e,ne,t),s(e,Oe,t),g(G,e,t),s(e,Ke,t),g(ie,e,t),s(e,et,t),s(e,ae,t),s(e,tt,t),s(e,se,t),s(e,nt,t),s(e,oe,t),s(e,it,t),g(le,e,t),s(e,at,t),s(e,re,t),s(e,st,t),g(A,e,t),s(e,ot,t),g(pe,e,t),s(e,lt,t),s(e,c,t),g(de,c,null),o(c,yt),o(c,Ie),o(c,Mt),o(c,Te),o(c,wt),o(c,Je),o(c,vt),o(c,xe),o(c,It),o(c,U),g(ce,U,null),o(U,Tt),o(U,Pe),o(U,Jt),g(C,U,null),o(c,xt),o(c,W),g(me,W,null),o(W,Pt),o(W,Ue),o(c,Ut),o(c,B),g(fe,B,null),o(B,Zt),o(B,Ze),o(c,$t),o(c,V),g(ue,V,null),o(V,kt),o(V,$e),o(c,jt),o(c,T),g(ge,T,null),o(T,Gt),o(T,ke),o(T,At),o(T,je),o(T,Ct),o(T,Ge),o(c,Wt),o(c,X),g(he,X,null),o(X,Bt),o(X,Ae),o(c,Vt),o(c,R),g(_e,R,null),o(R,Xt),o(R,Ce),o(c,Rt),o(c,F),g(be,F,null),o(F,Ft),o(F,We),s(e,rt,t),s(e,ye,t),s(e,pt,t),g(Me,e,t),s(e,dt,t),s(e,$,t),g(we,$,null),o($,Yt),o($,Be),s(e,ct,t),s(e,Ve,t),mt=!0},p(e,[t]){const m={};t&2&&(m.$$scope={dirty:t,ctx:e}),G.$set(m);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),A.$set(k);const ve={};t&2&&(ve.$$scope={dirty:t,ctx:e}),C.$set(ve)},i(e){mt||(h(I.$$.fragment,e),h(P.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(ee.$$.fragment,e),h(G.$$.fragment,e),h(ie.$$.fragment,e),h(le.$$.fragment,e),h(A.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(C.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),mt=!0)},o(e){_(I.$$.fragment,e),_(P.$$.fragment,e),_(H.$$.fragment,e),_(z.$$.fragment,e),_(q.$$.fragment,e),_(ee.$$.fragment,e),_(G.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(A.$$.fragment,e),_(pe.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(C.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(we.$$.fragment,e),mt=!1},d(e){e&&(n(v),n(y),n(w),n(M),n(Xe),n(N),n(Re),n(L),n(Fe),n(S),n(Ye),n(Ee),n(D),n(Ne),n(Le),n(Q),n(Se),n(He),n(O),n(De),n(K),n(ze),n(Qe),n(te),n(qe),n(ne),n(Oe),n(Ke),n(et),n(ae),n(tt),n(se),n(nt),n(oe),n(it),n(at),n(re),n(st),n(ot),n(lt),n(c),n(rt),n(ye),n(pt),n(dt),n($),n(ct),n(Ve)),n(p),b(I,e),b(P,e),b(H,e),b(z,e),b(q,e),b(ee,e),b(G,e),b(ie,e),b(le,e),b(A,e),b(pe,e),b(de),b(ce),b(C),b(me),b(fe),b(ue),b(ge),b(he),b(_e),b(be),b(Me,e),b(we)}}}const jn='{"title":"Image-to-Video Generation with PIA (Personalized Image Animator)","local":"image-to-video-generation-with-pia-personalized-image-animator","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Using FreeInit","local":"using-freeinit","sections":[],"depth":2},{"title":"PIAPipeline","local":"diffusers.PIAPipeline","sections":[],"depth":2},{"title":"PIAPipelineOutput","local":"diffusers.pipelines.pia.PIAPipelineOutput","sections":[],"depth":2}],"depth":1}';function Gn(j){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fn extends Tn{constructor(p){super(),Jn(this,p,Gn,kn,vn,{})}}export{Fn as component};
