import{s as ii,o as si,n as ni}from"../chunks/scheduler.182ea377.js";import{S as ai,i as oi,g as r,s as i,r as f,A as ri,h as l,f as n,c as s,j as w,u as c,x as d,k as x,y as o,a,v as u,d as g,t as h,w as _}from"../chunks/index.abf12888.js";import{T as ti}from"../chunks/Tip.230e2334.js";import{D as y}from"../chunks/Docstring.93f6f462.js";import{C as Ce}from"../chunks/CodeBlock.57fe6e13.js";import{H as U}from"../chunks/Heading.16916d63.js";function li(Ve){let b,T="There is currently an issue on PyTorch 1.X where the output images are all black or the pixel values become <code>NaNs</code>. This issue can be mitigated by switching to PyTorch 2.X.";return{c(){b=r("p"),b.innerHTML=T},l(v){b=l(v,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1uoi7bt"&&(b.innerHTML=T)},m(v,J){a(v,b,J)},p:ni,d(v){v&&n(b)}}}function pi(Ve){let b,T='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){b=r("p"),b.innerHTML=T},l(v){b=l(v,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1wmc0l4"&&(b.innerHTML=T)},m(v,J){a(v,b,J)},p:ni,d(v){v&&n(b)}}}function di(Ve){let b,T,v,J,R,Ke,F,Tn='The UniDiffuser model was proposed in <a href="https://huggingface.co/papers/2303.06555" rel="nofollow">One Transformer Fits All Distributions in Multi-Modal Diffusion at Scale</a> by Fan Bao, Shen Nie, Kaiwen Xue, Chongxuan Li, Shi Pu, Yaole Wang, Gang Yue, Yue Cao, Hang Su, Jun Zhu.',et,L,Mn="The abstract from the paper is:",tt,N,Un="<em>This paper proposes a unified diffusion framework (dubbed UniDiffuser) to fit all distributions relevant to a set of multi-modal data in one model. Our key insight is — learning diffusion models for marginal, conditional, and joint distributions can be unified as predicting the noise in the perturbed data, where the perturbation levels (i.e. timesteps) can be different for different modalities. Inspired by the unified view, UniDiffuser learns all distributions simultaneously with a minimal modification to the original diffusion model — perturbs data in all modalities instead of a single modality, inputs individual timesteps in different modalities, and predicts the noise of all modalities instead of a single modality. UniDiffuser is parameterized by a transformer for diffusion models to handle input types of different modalities. Implemented on large-scale paired image-text data, UniDiffuser is able to perform image, text, text-to-image, image-to-text, and image-text pair generation by setting proper timesteps without additional overhead. In particular, UniDiffuser is able to produce perceptually realistic samples in all tasks and its quantitative results (e.g., the FID and CLIP score) are not only superior to existing general-purpose models but also comparable to the bespoken models (e.g., Stable Diffusion and DALL-E 2) in representative tasks (e.g., text-to-image generation).</em>",nt,Q,Jn='You can find the original codebase at <a href="https://github.com/thu-ml/unidiffuser" rel="nofollow">thu-ml/unidiffuser</a> and additional checkpoints at <a href="https://huggingface.co/thu-ml" rel="nofollow">thu-ml</a>.',it,Z,st,z,Zn='This pipeline was contributed by <a href="https://github.com/dg845" rel="nofollow">dg845</a>. ❤️',at,S,ot,Y,$n="Because the UniDiffuser model is trained to model the joint distribution of (image, text) pairs, it is capable of performing a diverse range of generation tasks:",rt,H,lt,q,In='Unconditional generation (where we start from only latents sampled from a standard Gaussian prior) from a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline">UniDiffuserPipeline</a> will produce a (image, text) pair:',pt,A,dt,O,jn="This is also called “joint” generation in the UniDiffuser paper, since we are sampling from the joint image-text distribution.",mt,K,Wn=`Note that the generation task is inferred from the inputs used when calling the pipeline.
It is also possible to manually specify the unconditional generation task (“mode”) manually with <a href="/docs/diffusers/v0.26.0/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_joint_mode">UniDiffuserPipeline.set_joint_mode()</a>:`,ft,ee,ct,te,Xn=`When the mode is set manually, subsequent calls to the pipeline will use the set mode without attempting to infer the mode.
You can reset the mode with <a href="/docs/diffusers/v0.26.0/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.reset_mode">UniDiffuserPipeline.reset_mode()</a>, after which the pipeline will once again infer the mode.`,ut,ne,Gn="You can also generate only an image or only text (which the UniDiffuser paper calls “marginal” generation since we sample from the marginal distribution of images and text, respectively):",gt,ie,ht,se,_t,ae,Pn=`UniDiffuser is also capable of sampling from conditional distributions; that is, the distribution of images conditioned on a text prompt or the distribution of texts conditioned on an image.
Here is an example of sampling from the conditional image distribution (text-to-image generation or text-conditioned image generation):`,bt,oe,vt,re,Cn='The <code>text2img</code> mode requires that either an input <code>prompt</code> or <code>prompt_embeds</code> be supplied. You can set the <code>text2img</code> mode manually with <a href="/docs/diffusers/v0.26.0/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_text_to_image_mode">UniDiffuserPipeline.set_text_to_image_mode()</a>.',wt,le,xt,pe,Vn="Similarly, UniDiffuser can also produce text samples given an image (image-to-text or image-conditioned text generation):",yt,de,Tt,me,Dn='The <code>img2text</code> mode requires that an input <code>image</code> be supplied. You can set the <code>img2text</code> mode manually with <a href="/docs/diffusers/v0.26.0/en/api/pipelines/unidiffuser#diffusers.UniDiffuserPipeline.set_image_to_text_mode">UniDiffuserPipeline.set_image_to_text_mode()</a>.',Mt,fe,Ut,ce,En=`The UniDiffuser authors suggest performing image variation through a “round-trip” generation method, where given an input image, we first perform an image-to-text generation, and then perform a text-to-image generation on the outputs of the first generation.
This produces a new image which is semantically similar to the input image:`,Jt,ue,Zt,ge,$t,he,kn="Similarly, text variation can be performed on an input prompt with a text-to-image generation followed by a image-to-text generation:",It,_e,jt,$,Wt,be,Xt,p,ve,Ht,De,Bn=`Pipeline for a bimodal image-text model which supports unconditional text and image generation, text-conditioned
image generation, image-conditioned text generation, and joint image-text generation.`,qt,Ee,Rn=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,At,I,we,Ot,ke,Fn="The call function to the pipeline for generation.",Kt,j,xe,en,Be,Ln=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,tn,W,ye,nn,Re,Nn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,sn,X,Te,an,Fe,Qn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,on,G,Me,rn,Le,zn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ln,P,Ue,pn,Ne,Sn="Encodes the prompt into text encoder hidden states.",dn,C,Je,mn,Qe,Yn="Removes a manually set mode; after calling this, the pipeline will infer the mode from inputs.",fn,V,Ze,cn,ze,Hn="Manually set the generation mode to unconditional (“marginal”) image generation.",un,D,$e,gn,Se,qn="Manually set the generation mode to image-conditioned text generation.",hn,E,Ie,_n,Ye,An="Manually set the generation mode to unconditional joint image-text generation.",bn,k,je,vn,He,On="Manually set the generation mode to unconditional (“marginal”) text generation.",wn,B,We,xn,qe,Kn="Manually set the generation mode to text-conditioned image generation.",Gt,Xe,Pt,M,Ge,yn,Ae,ei="Output class for joint image-text pipelines.",Ct,Oe,Vt;return R=new U({props:{title:"UniDiffuser",local:"unidiffuser",headingTag:"h1"}}),Z=new ti({props:{warning:!0,$$slots:{default:[li]},$$scope:{ctx:Ve}}}),S=new U({props:{title:"Usage Examples",local:"usage-examples",headingTag:"h2"}}),H=new U({props:{title:"Unconditional Image and Text Generation",local:"unconditional-image-and-text-generation",headingTag:"h3"}}),A=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBVbmNvbmRpdGlvbmFsJTIwaW1hZ2UlMjBhbmQlMjB0ZXh0JTIwZ2VuZXJhdGlvbi4lMjBUaGUlMjBnZW5lcmF0aW9uJTIwdGFzayUyMGlzJTIwYXV0b21hdGljYWxseSUyMGluZmVycmVkLiUwQXNhbXBsZSUyMCUzRCUyMHBpcGUobnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjApJTBBaW1hZ2UlMjAlM0QlMjBzYW1wbGUuaW1hZ2VzJTVCMCU1RCUwQXRleHQlMjAlM0QlMjBzYW1wbGUudGV4dCU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnVuaWRpZmZ1c2VyX2pvaW50X3NhbXBsZV9pbWFnZS5wbmclMjIpJTBBcHJpbnQodGV4dCk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Unconditional image and text generation. The generation task is automatically inferred.</span>
sample = pipe(num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
image = sample.images[<span class="hljs-number">0</span>]
text = sample.text[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;unidiffuser_joint_sample_image.png&quot;</span>)
<span class="hljs-built_in">print</span>(text)`,wrap:!1}}),ee=new Ce({props:{code:"JTIzJTIwRXF1aXZhbGVudCUyMHRvJTIwdGhlJTIwYWJvdmUuJTBBcGlwZS5zZXRfam9pbnRfbW9kZSgpJTBBc2FtcGxlJTIwJTNEJTIwcGlwZShudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCk=",highlighted:`<span class="hljs-comment"># Equivalent to the above.</span>
pipe.set_joint_mode()
sample = pipe(num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)`,wrap:!1}}),ie=new Ce({props:{code:"JTIzJTIwVW5saWtlJTIwb3RoZXIlMjBnZW5lcmF0aW9uJTIwdGFza3MlMkMlMjBpbWFnZS1vbmx5JTIwYW5kJTIwdGV4dC1vbmx5JTIwZ2VuZXJhdGlvbiUyMGRvbid0JTIwdXNlJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMEElMjMlMjBJbWFnZS1vbmx5JTIwZ2VuZXJhdGlvbiUwQXBpcGUuc2V0X2ltYWdlX21vZGUoKSUwQXNhbXBsZV9pbWFnZSUyMCUzRCUyMHBpcGUobnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVEJTBBJTIzJTIwVGV4dC1vbmx5JTIwZ2VuZXJhdGlvbiUwQXBpcGUuc2V0X3RleHRfbW9kZSgpJTBBc2FtcGxlX3RleHQlMjAlM0QlMjBwaXBlKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCkudGV4dCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Unlike other generation tasks, image-only and text-only generation don&#x27;t use classifier-free guidance</span>
<span class="hljs-comment"># Image-only generation</span>
pipe.set_image_mode()
sample_image = pipe(num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-comment"># Text-only generation</span>
pipe.set_text_mode()
sample_text = pipe(num_inference_steps=<span class="hljs-number">20</span>).text[<span class="hljs-number">0</span>]`,wrap:!1}}),se=new U({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h3"}}),oe=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBUZXh0LXRvLWltYWdlJTIwZ2VuZXJhdGlvbiUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwZWxlcGhhbnQlMjB1bmRlciUyMHRoZSUyMHNlYSUyMiUwQSUwQXNhbXBsZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjApJTBBdDJpX2ltYWdlJTIwJTNEJTIwc2FtcGxlLmltYWdlcyU1QjAlNUQlMEF0MmlfaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Text-to-image generation</span>
prompt = <span class="hljs-string">&quot;an elephant under the sea&quot;</span>

sample = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
t2i_image = sample.images[<span class="hljs-number">0</span>]
t2i_image`,wrap:!1}}),le=new U({props:{title:"Image-to-Text Generation",local:"image-to-text-generation",headingTag:"h3"}}),de=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJ0aHUtbWwlMkZ1bmlkaWZmdXNlci12MSUyMiUwQXBpcGUlMjAlM0QlMjBVbmlEaWZmdXNlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUudG8oZGV2aWNlKSUwQSUwQSUyMyUyMEltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnVuaWRpZmZ1c2VyJTJGdW5pZGlmZnVzZXJfZXhhbXBsZV9pbWFnZS5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFzYW1wbGUlMjAlM0QlMjBwaXBlKGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWkydF90ZXh0JTIwJTNEJTIwc2FtcGxlLnRleHQlNUIwJTVEJTBBcHJpbnQoaTJ0X3RleHQp",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Image-to-text generation</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/unidiffuser/unidiffuser_example_image.jpg&quot;</span>
init_image = load_image(image_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

sample = pipe(image=init_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
i2t_text = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(i2t_text)`,wrap:!1}}),fe=new U({props:{title:"Image Variation",local:"image-variation",headingTag:"h3"}}),ue=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJ0aHUtbWwlMkZ1bmlkaWZmdXNlci12MSUyMiUwQXBpcGUlMjAlM0QlMjBVbmlEaWZmdXNlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZF9vcl9wYXRoJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUudG8oZGV2aWNlKSUwQSUwQSUyMyUyMEltYWdlJTIwdmFyaWF0aW9uJTIwY2FuJTIwYmUlMjBwZXJmb3JtZWQlMjB3aXRoJTIwYW4lMjBpbWFnZS10by10ZXh0JTIwZ2VuZXJhdGlvbiUyMGZvbGxvd2VkJTIwYnklMjBhJTIwdGV4dC10by1pbWFnZSUyMGdlbmVyYXRpb24lM0ElMEElMjMlMjAxLiUyMEltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnVuaWRpZmZ1c2VyJTJGdW5pZGlmZnVzZXJfZXhhbXBsZV9pbWFnZS5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFzYW1wbGUlMjAlM0QlMjBwaXBlKGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWkydF90ZXh0JTIwJTNEJTIwc2FtcGxlLnRleHQlNUIwJTVEJTBBcHJpbnQoaTJ0X3RleHQpJTBBJTBBJTIzJTIwMi4lMjBUZXh0LXRvLWltYWdlJTIwZ2VuZXJhdGlvbiUwQXNhbXBsZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEaTJ0X3RleHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCklMEFmaW5hbF9pbWFnZSUyMCUzRCUyMHNhbXBsZS5pbWFnZXMlNUIwJTVEJTBBZmluYWxfaW1hZ2Uuc2F2ZSglMjJ1bmlkaWZmdXNlcl9pbWFnZV92YXJpYXRpb25fc2FtcGxlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Image variation can be performed with an image-to-text generation followed by a text-to-image generation:</span>
<span class="hljs-comment"># 1. Image-to-text generation</span>
image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/unidiffuser/unidiffuser_example_image.jpg&quot;</span>
init_image = load_image(image_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

sample = pipe(image=init_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
i2t_text = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(i2t_text)

<span class="hljs-comment"># 2. Text-to-image generation</span>
sample = pipe(prompt=i2t_text, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
final_image = sample.images[<span class="hljs-number">0</span>]
final_image.save(<span class="hljs-string">&quot;unidiffuser_image_variation_sample.png&quot;</span>)`,wrap:!1}}),ge=new U({props:{title:"Text Variation",local:"text-variation",headingTag:"h3"}}),_e=new Ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5pRGlmZnVzZXJQaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFtb2RlbF9pZF9vcl9wYXRoJTIwJTNEJTIwJTIydGh1LW1sJTJGdW5pZGlmZnVzZXItdjElMjIlMEFwaXBlJTIwJTNEJTIwVW5pRGlmZnVzZXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWRfb3JfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKGRldmljZSklMEElMEElMjMlMjBUZXh0JTIwdmFyaWF0aW9uJTIwY2FuJTIwYmUlMjBwZXJmb3JtZWQlMjB3aXRoJTIwYSUyMHRleHQtdG8taW1hZ2UlMjBnZW5lcmF0aW9uJTIwZm9sbG93ZWQlMjBieSUyMGElMjBpbWFnZS10by10ZXh0JTIwZ2VuZXJhdGlvbiUzQSUwQSUyMyUyMDEuJTIwVGV4dC10by1pbWFnZSUyMGdlbmVyYXRpb24lMEFwcm9tcHQlMjAlM0QlMjAlMjJhbiUyMGVsZXBoYW50JTIwdW5kZXIlMjB0aGUlMjBzZWElMjIlMEElMEFzYW1wbGUlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQXQyaV9pbWFnZSUyMCUzRCUyMHNhbXBsZS5pbWFnZXMlNUIwJTVEJTBBdDJpX2ltYWdlLnNhdmUoJTIydW5pZGlmZnVzZXJfdGV4dDJpbWdfc2FtcGxlX2ltYWdlLnBuZyUyMiklMEElMEElMjMlMjAyLiUyMEltYWdlLXRvLXRleHQlMjBnZW5lcmF0aW9uJTBBc2FtcGxlJTIwJTNEJTIwcGlwZShpbWFnZSUzRHQyaV9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKSUwQWZpbmFsX3Byb21wdCUyMCUzRCUyMHNhbXBsZS50ZXh0JTVCMCU1RCUwQXByaW50KGZpbmFsX3Byb21wdCk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniDiffuserPipeline

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id_or_path = <span class="hljs-string">&quot;thu-ml/unidiffuser-v1&quot;</span>
pipe = UniDiffuserPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
pipe.to(device)

<span class="hljs-comment"># Text variation can be performed with a text-to-image generation followed by a image-to-text generation:</span>
<span class="hljs-comment"># 1. Text-to-image generation</span>
prompt = <span class="hljs-string">&quot;an elephant under the sea&quot;</span>

sample = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
t2i_image = sample.images[<span class="hljs-number">0</span>]
t2i_image.save(<span class="hljs-string">&quot;unidiffuser_text2img_sample_image.png&quot;</span>)

<span class="hljs-comment"># 2. Image-to-text generation</span>
sample = pipe(image=t2i_image, num_inference_steps=<span class="hljs-number">20</span>, guidance_scale=<span class="hljs-number">8.0</span>)
final_prompt = sample.text[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(final_prompt)`,wrap:!1}}),$=new ti({props:{$$slots:{default:[pi]},$$scope:{ctx:Ve}}}),be=new U({props:{title:"UniDiffuserPipeline",local:"diffusers.UniDiffuserPipeline",headingTag:"h2"}}),ve=new y({props:{name:"class diffusers.UniDiffuserPipeline",anchor:"diffusers.UniDiffuserPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"clip_image_processor",val:": CLIPImageProcessor"},{name:"clip_tokenizer",val:": CLIPTokenizer"},{name:"text_decoder",val:": UniDiffuserTextDecoder"},{name:"text_tokenizer",val:": GPT2Tokenizer"},{name:"unet",val:": UniDiffuserModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations. This
is part of the UniDiffuser image representation along with the CLIP vision encoding.`,name:"vae"},{anchor:"diffusers.UniDiffuserPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.UniDiffuserPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModel</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPVisionModel" rel="nofollow">CLIPVisionModel</a> to encode images as part of its image representation along with the VAE
latent representation.`,name:"image_encoder"},{anchor:"diffusers.UniDiffuserPipeline.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> to preprocess an image before CLIP encoding it with <code>image_encoder</code>.`,name:"image_processor"},{anchor:"diffusers.UniDiffuserPipeline.clip_tokenizer",description:`<strong>clip_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.38.1/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize the prompt before encoding it with <code>text_encoder</code>.`,name:"clip_tokenizer"},{anchor:"diffusers.UniDiffuserPipeline.text_decoder",description:`<strong>text_decoder</strong> (<code>UniDiffuserTextDecoder</code>) &#x2014;
Frozen text decoder. This is a GPT-style model which is used to generate text from the UniDiffuser
embedding.`,name:"text_decoder"},{anchor:"diffusers.UniDiffuserPipeline.text_tokenizer",description:`<strong>text_tokenizer</strong> (<code>GPT2Tokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.38.1/en/model_doc/gpt2#transformers.GPT2Tokenizer" rel="nofollow">GPT2Tokenizer</a> to decode text for text generation; used along with the <code>text_decoder</code>.`,name:"text_tokenizer"},{anchor:"diffusers.UniDiffuserPipeline.unet",description:`<strong>unet</strong> (<code>UniDiffuserModel</code>) &#x2014;
A <a href="https://github.com/baofff/U-ViT" rel="nofollow">U-ViT</a> model with UNNet-style skip connections between transformer
layers to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.UniDiffuserPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image and/or text latents. The
original UniDiffuser paper uses the <a href="/docs/diffusers/v0.26.0/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> scheduler.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L51"}}),we=new y({props:{name:"__call__",anchor:"diffusers.UniDiffuserPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"data_type",val:": Optional = 1"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 8.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"num_prompts_per_image",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_latents",val:": Optional = None"},{name:"vae_latents",val:": Optional = None"},{name:"clip_latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.
Required for text-conditioned image generation (<code>text2img</code>) mode.`,name:"prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
<code>Image</code> or tensor representing an image batch. Required for image-conditioned text generation
(<code>img2text</code>) mode.`,name:"image"},{anchor:"diffusers.UniDiffuserPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.UniDiffuserPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.UniDiffuserPipeline.__call__.data_type",description:`<strong>data_type</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The data type (either 0 or 1). Only used if you are loading a checkpoint which supports a data type
embedding; this is added for compatibility with the
<a href="https://huggingface.co/thu-ml/unidiffuser-v1" rel="nofollow">UniDiffuser-v1</a> checkpoint.`,name:"data_type"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.UniDiffuserPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 8.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.UniDiffuserPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>). Used in
text-conditioned image generation (<code>text2img</code>) mode.`,name:"negative_prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt. Used in <code>text2img</code> (text-conditioned image generation) and
<code>img</code> mode. If the mode is joint and both <code>num_images_per_prompt</code> and <code>num_prompts_per_image</code> are
supplied, <code>min(num_images_per_prompt, num_prompts_per_image)</code> samples are generated.`,name:"num_images_per_prompt"},{anchor:"diffusers.UniDiffuserPipeline.__call__.num_prompts_per_image",description:`<strong>num_prompts_per_image</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of prompts to generate per image. Used in <code>img2text</code> (image-conditioned text generation) and
<code>text</code> mode. If the mode is joint and both <code>num_images_per_prompt</code> and <code>num_prompts_per_image</code> are
supplied, <code>min(num_images_per_prompt, num_prompts_per_image)</code> samples are generated.`,name:"num_prompts_per_image"},{anchor:"diffusers.UniDiffuserPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.26.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.UniDiffuserPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.UniDiffuserPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for joint
image-text generation. Can be used to tweak the same generation with different prompts. If not
provided, a latents tensor is generated by sampling using the supplied random <code>generator</code>. This assumes
a full set of VAE, CLIP, and text latents, if supplied, overrides the value of <code>prompt_latents</code>,
<code>vae_latents</code>, and <code>clip_latents</code>.`,name:"latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt_latents",description:`<strong>prompt_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for text
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"prompt_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.vae_latents",description:`<strong>vae_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"vae_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.clip_latents",description:`<strong>clip_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"clip_latents"},{anchor:"diffusers.UniDiffuserPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument. Used in text-conditioned
image generation (<code>text2img</code>) mode.`,name:"prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are be generated from the <code>negative_prompt</code> input argument. Used
in text-conditioned image generation (<code>text2img</code>) mode.`,name:"negative_prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.UniDiffuserPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput">ImageTextPipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.UniDiffuserPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.UniDiffuserPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L1079",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput"
>ImageTextPipelineOutput</a> is returned, otherwise a
<code>tuple</code> is returned where the first element is a list with the generated images and the second element
is a list of generated texts.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/unidiffuser#diffusers.ImageTextPipelineOutput"
>ImageTextPipelineOutput</a> or <code>tuple</code></p>
`}}),xe=new y({props:{name:"disable_vae_slicing",anchor:"diffusers.UniDiffuserPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L147"}}),ye=new y({props:{name:"disable_vae_tiling",anchor:"diffusers.UniDiffuserPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L164"}}),Te=new y({props:{name:"enable_vae_slicing",anchor:"diffusers.UniDiffuserPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L139"}}),Me=new y({props:{name:"enable_vae_tiling",anchor:"diffusers.UniDiffuserPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L155"}}),Ue=new y({props:{name:"encode_prompt",anchor:"diffusers.UniDiffuserPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.UniDiffuserPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L382"}}),Je=new y({props:{name:"reset_mode",anchor:"diffusers.UniDiffuserPipeline.reset_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L268"}}),Ze=new y({props:{name:"set_image_mode",anchor:"diffusers.UniDiffuserPipeline.set_image_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L252"}}),$e=new y({props:{name:"set_image_to_text_mode",anchor:"diffusers.UniDiffuserPipeline.set_image_to_text_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L260"}}),Ie=new y({props:{name:"set_joint_mode",anchor:"diffusers.UniDiffuserPipeline.set_joint_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L264"}}),je=new y({props:{name:"set_text_mode",anchor:"diffusers.UniDiffuserPipeline.set_text_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L248"}}),We=new y({props:{name:"set_text_to_image_mode",anchor:"diffusers.UniDiffuserPipeline.set_text_to_image_mode",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L256"}}),Xe=new U({props:{title:"ImageTextPipelineOutput",local:"diffusers.ImageTextPipelineOutput",headingTag:"h2"}}),Ge=new y({props:{name:"class diffusers.ImageTextPipelineOutput",anchor:"diffusers.ImageTextPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"text",val:": Union"}],parametersDescription:[{anchor:"diffusers.ImageTextPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.ImageTextPipelineOutput.text",description:`<strong>text</strong> (<code>List[str]</code> or <code>List[List[str]]</code>) &#x2014;
List of generated text strings of length <code>batch_size</code> or a list of list of strings whose outer list has
length <code>batch_size</code>.`,name:"text"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L33"}}),{c(){b=r("meta"),T=i(),v=r("p"),J=i(),f(R.$$.fragment),Ke=i(),F=r("p"),F.innerHTML=Tn,et=i(),L=r("p"),L.textContent=Mn,tt=i(),N=r("p"),N.innerHTML=Un,nt=i(),Q=r("p"),Q.innerHTML=Jn,it=i(),f(Z.$$.fragment),st=i(),z=r("p"),z.innerHTML=Zn,at=i(),f(S.$$.fragment),ot=i(),Y=r("p"),Y.textContent=$n,rt=i(),f(H.$$.fragment),lt=i(),q=r("p"),q.innerHTML=In,pt=i(),f(A.$$.fragment),dt=i(),O=r("p"),O.textContent=jn,mt=i(),K=r("p"),K.innerHTML=Wn,ft=i(),f(ee.$$.fragment),ct=i(),te=r("p"),te.innerHTML=Xn,ut=i(),ne=r("p"),ne.textContent=Gn,gt=i(),f(ie.$$.fragment),ht=i(),f(se.$$.fragment),_t=i(),ae=r("p"),ae.textContent=Pn,bt=i(),f(oe.$$.fragment),vt=i(),re=r("p"),re.innerHTML=Cn,wt=i(),f(le.$$.fragment),xt=i(),pe=r("p"),pe.textContent=Vn,yt=i(),f(de.$$.fragment),Tt=i(),me=r("p"),me.innerHTML=Dn,Mt=i(),f(fe.$$.fragment),Ut=i(),ce=r("p"),ce.textContent=En,Jt=i(),f(ue.$$.fragment),Zt=i(),f(ge.$$.fragment),$t=i(),he=r("p"),he.textContent=kn,It=i(),f(_e.$$.fragment),jt=i(),f($.$$.fragment),Wt=i(),f(be.$$.fragment),Xt=i(),p=r("div"),f(ve.$$.fragment),Ht=i(),De=r("p"),De.textContent=Bn,qt=i(),Ee=r("p"),Ee.innerHTML=Rn,At=i(),I=r("div"),f(we.$$.fragment),Ot=i(),ke=r("p"),ke.textContent=Fn,Kt=i(),j=r("div"),f(xe.$$.fragment),en=i(),Be=r("p"),Be.innerHTML=Ln,tn=i(),W=r("div"),f(ye.$$.fragment),nn=i(),Re=r("p"),Re.innerHTML=Nn,sn=i(),X=r("div"),f(Te.$$.fragment),an=i(),Fe=r("p"),Fe.textContent=Qn,on=i(),G=r("div"),f(Me.$$.fragment),rn=i(),Le=r("p"),Le.textContent=zn,ln=i(),P=r("div"),f(Ue.$$.fragment),pn=i(),Ne=r("p"),Ne.textContent=Sn,dn=i(),C=r("div"),f(Je.$$.fragment),mn=i(),Qe=r("p"),Qe.textContent=Yn,fn=i(),V=r("div"),f(Ze.$$.fragment),cn=i(),ze=r("p"),ze.textContent=Hn,un=i(),D=r("div"),f($e.$$.fragment),gn=i(),Se=r("p"),Se.textContent=qn,hn=i(),E=r("div"),f(Ie.$$.fragment),_n=i(),Ye=r("p"),Ye.textContent=An,bn=i(),k=r("div"),f(je.$$.fragment),vn=i(),He=r("p"),He.textContent=On,wn=i(),B=r("div"),f(We.$$.fragment),xn=i(),qe=r("p"),qe.textContent=Kn,Gt=i(),f(Xe.$$.fragment),Pt=i(),M=r("div"),f(Ge.$$.fragment),yn=i(),Ae=r("p"),Ae.textContent=ei,Ct=i(),Oe=r("p"),this.h()},l(e){const t=ri("svelte-u9bgzb",document.head);b=l(t,"META",{name:!0,content:!0}),t.forEach(n),T=s(e),v=l(e,"P",{}),w(v).forEach(n),J=s(e),c(R.$$.fragment,e),Ke=s(e),F=l(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-x4qgym"&&(F.innerHTML=Tn),et=s(e),L=l(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1cwsb16"&&(L.textContent=Mn),tt=s(e),N=l(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1rrofj2"&&(N.innerHTML=Un),nt=s(e),Q=l(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1mkhqav"&&(Q.innerHTML=Jn),it=s(e),c(Z.$$.fragment,e),st=s(e),z=l(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1eykv1b"&&(z.innerHTML=Zn),at=s(e),c(S.$$.fragment,e),ot=s(e),Y=l(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-cbm0c5"&&(Y.textContent=$n),rt=s(e),c(H.$$.fragment,e),lt=s(e),q=l(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1ighph6"&&(q.innerHTML=In),pt=s(e),c(A.$$.fragment,e),dt=s(e),O=l(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-19mmnnc"&&(O.textContent=jn),mt=s(e),K=l(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-klwya8"&&(K.innerHTML=Wn),ft=s(e),c(ee.$$.fragment,e),ct=s(e),te=l(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-7bx4su"&&(te.innerHTML=Xn),ut=s(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1y647uj"&&(ne.textContent=Gn),gt=s(e),c(ie.$$.fragment,e),ht=s(e),c(se.$$.fragment,e),_t=s(e),ae=l(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-euu6tg"&&(ae.textContent=Pn),bt=s(e),c(oe.$$.fragment,e),vt=s(e),re=l(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1sslzm3"&&(re.innerHTML=Cn),wt=s(e),c(le.$$.fragment,e),xt=s(e),pe=l(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-tubb14"&&(pe.textContent=Vn),yt=s(e),c(de.$$.fragment,e),Tt=s(e),me=l(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-226te4"&&(me.innerHTML=Dn),Mt=s(e),c(fe.$$.fragment,e),Ut=s(e),ce=l(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-lnxqa8"&&(ce.textContent=En),Jt=s(e),c(ue.$$.fragment,e),Zt=s(e),c(ge.$$.fragment,e),$t=s(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1t6lzo0"&&(he.textContent=kn),It=s(e),c(_e.$$.fragment,e),jt=s(e),c($.$$.fragment,e),Wt=s(e),c(be.$$.fragment,e),Xt=s(e),p=l(e,"DIV",{class:!0});var m=w(p);c(ve.$$.fragment,m),Ht=s(m),De=l(m,"P",{"data-svelte-h":!0}),d(De)!=="svelte-qg5tdp"&&(De.textContent=Bn),qt=s(m),Ee=l(m,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-13tknt9"&&(Ee.innerHTML=Rn),At=s(m),I=l(m,"DIV",{class:!0});var Pe=w(I);c(we.$$.fragment,Pe),Ot=s(Pe),ke=l(Pe,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-50j04k"&&(ke.textContent=Fn),Pe.forEach(n),Kt=s(m),j=l(m,"DIV",{class:!0});var Dt=w(j);c(xe.$$.fragment,Dt),en=s(Dt),Be=l(Dt,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1s3c06i"&&(Be.innerHTML=Ln),Dt.forEach(n),tn=s(m),W=l(m,"DIV",{class:!0});var Et=w(W);c(ye.$$.fragment,Et),nn=s(Et),Re=l(Et,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-pkn4ui"&&(Re.innerHTML=Nn),Et.forEach(n),sn=s(m),X=l(m,"DIV",{class:!0});var kt=w(X);c(Te.$$.fragment,kt),an=s(kt),Fe=l(kt,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-14bnrb6"&&(Fe.textContent=Qn),kt.forEach(n),on=s(m),G=l(m,"DIV",{class:!0});var Bt=w(G);c(Me.$$.fragment,Bt),rn=s(Bt),Le=l(Bt,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1xwrf7t"&&(Le.textContent=zn),Bt.forEach(n),ln=s(m),P=l(m,"DIV",{class:!0});var Rt=w(P);c(Ue.$$.fragment,Rt),pn=s(Rt),Ne=l(Rt,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-16q0ax1"&&(Ne.textContent=Sn),Rt.forEach(n),dn=s(m),C=l(m,"DIV",{class:!0});var Ft=w(C);c(Je.$$.fragment,Ft),mn=s(Ft),Qe=l(Ft,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-ycux85"&&(Qe.textContent=Yn),Ft.forEach(n),fn=s(m),V=l(m,"DIV",{class:!0});var Lt=w(V);c(Ze.$$.fragment,Lt),cn=s(Lt),ze=l(Lt,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-f12s4l"&&(ze.textContent=Hn),Lt.forEach(n),un=s(m),D=l(m,"DIV",{class:!0});var Nt=w(D);c($e.$$.fragment,Nt),gn=s(Nt),Se=l(Nt,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1b9y8l5"&&(Se.textContent=qn),Nt.forEach(n),hn=s(m),E=l(m,"DIV",{class:!0});var Qt=w(E);c(Ie.$$.fragment,Qt),_n=s(Qt),Ye=l(Qt,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-u7njpc"&&(Ye.textContent=An),Qt.forEach(n),bn=s(m),k=l(m,"DIV",{class:!0});var zt=w(k);c(je.$$.fragment,zt),vn=s(zt),He=l(zt,"P",{"data-svelte-h":!0}),d(He)!=="svelte-p08nnp"&&(He.textContent=On),zt.forEach(n),wn=s(m),B=l(m,"DIV",{class:!0});var St=w(B);c(We.$$.fragment,St),xn=s(St),qe=l(St,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-rah46x"&&(qe.textContent=Kn),St.forEach(n),m.forEach(n),Gt=s(e),c(Xe.$$.fragment,e),Pt=s(e),M=l(e,"DIV",{class:!0});var Yt=w(M);c(Ge.$$.fragment,Yt),yn=s(Yt),Ae=l(Yt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1i2ycus"&&(Ae.textContent=ei),Yt.forEach(n),Ct=s(e),Oe=l(e,"P",{}),w(Oe).forEach(n),this.h()},h(){x(b,"name","hf:doc:metadata"),x(b,"content",mi),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){o(document.head,b),a(e,T,t),a(e,v,t),a(e,J,t),u(R,e,t),a(e,Ke,t),a(e,F,t),a(e,et,t),a(e,L,t),a(e,tt,t),a(e,N,t),a(e,nt,t),a(e,Q,t),a(e,it,t),u(Z,e,t),a(e,st,t),a(e,z,t),a(e,at,t),u(S,e,t),a(e,ot,t),a(e,Y,t),a(e,rt,t),u(H,e,t),a(e,lt,t),a(e,q,t),a(e,pt,t),u(A,e,t),a(e,dt,t),a(e,O,t),a(e,mt,t),a(e,K,t),a(e,ft,t),u(ee,e,t),a(e,ct,t),a(e,te,t),a(e,ut,t),a(e,ne,t),a(e,gt,t),u(ie,e,t),a(e,ht,t),u(se,e,t),a(e,_t,t),a(e,ae,t),a(e,bt,t),u(oe,e,t),a(e,vt,t),a(e,re,t),a(e,wt,t),u(le,e,t),a(e,xt,t),a(e,pe,t),a(e,yt,t),u(de,e,t),a(e,Tt,t),a(e,me,t),a(e,Mt,t),u(fe,e,t),a(e,Ut,t),a(e,ce,t),a(e,Jt,t),u(ue,e,t),a(e,Zt,t),u(ge,e,t),a(e,$t,t),a(e,he,t),a(e,It,t),u(_e,e,t),a(e,jt,t),u($,e,t),a(e,Wt,t),u(be,e,t),a(e,Xt,t),a(e,p,t),u(ve,p,null),o(p,Ht),o(p,De),o(p,qt),o(p,Ee),o(p,At),o(p,I),u(we,I,null),o(I,Ot),o(I,ke),o(p,Kt),o(p,j),u(xe,j,null),o(j,en),o(j,Be),o(p,tn),o(p,W),u(ye,W,null),o(W,nn),o(W,Re),o(p,sn),o(p,X),u(Te,X,null),o(X,an),o(X,Fe),o(p,on),o(p,G),u(Me,G,null),o(G,rn),o(G,Le),o(p,ln),o(p,P),u(Ue,P,null),o(P,pn),o(P,Ne),o(p,dn),o(p,C),u(Je,C,null),o(C,mn),o(C,Qe),o(p,fn),o(p,V),u(Ze,V,null),o(V,cn),o(V,ze),o(p,un),o(p,D),u($e,D,null),o(D,gn),o(D,Se),o(p,hn),o(p,E),u(Ie,E,null),o(E,_n),o(E,Ye),o(p,bn),o(p,k),u(je,k,null),o(k,vn),o(k,He),o(p,wn),o(p,B),u(We,B,null),o(B,xn),o(B,qe),a(e,Gt,t),u(Xe,e,t),a(e,Pt,t),a(e,M,t),u(Ge,M,null),o(M,yn),o(M,Ae),a(e,Ct,t),a(e,Oe,t),Vt=!0},p(e,[t]){const m={};t&2&&(m.$$scope={dirty:t,ctx:e}),Z.$set(m);const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),$.$set(Pe)},i(e){Vt||(g(R.$$.fragment,e),g(Z.$$.fragment,e),g(S.$$.fragment,e),g(H.$$.fragment,e),g(A.$$.fragment,e),g(ee.$$.fragment,e),g(ie.$$.fragment,e),g(se.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g($.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(xe.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(Ue.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g($e.$$.fragment,e),g(Ie.$$.fragment,e),g(je.$$.fragment,e),g(We.$$.fragment,e),g(Xe.$$.fragment,e),g(Ge.$$.fragment,e),Vt=!0)},o(e){h(R.$$.fragment,e),h(Z.$$.fragment,e),h(S.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(ee.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),h($.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(xe.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(Ue.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(je.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ge.$$.fragment,e),Vt=!1},d(e){e&&(n(T),n(v),n(J),n(Ke),n(F),n(et),n(L),n(tt),n(N),n(nt),n(Q),n(it),n(st),n(z),n(at),n(ot),n(Y),n(rt),n(lt),n(q),n(pt),n(dt),n(O),n(mt),n(K),n(ft),n(ct),n(te),n(ut),n(ne),n(gt),n(ht),n(_t),n(ae),n(bt),n(vt),n(re),n(wt),n(xt),n(pe),n(yt),n(Tt),n(me),n(Mt),n(Ut),n(ce),n(Jt),n(Zt),n($t),n(he),n(It),n(jt),n(Wt),n(Xt),n(p),n(Gt),n(Pt),n(M),n(Ct),n(Oe)),n(b),_(R,e),_(Z,e),_(S,e),_(H,e),_(A,e),_(ee,e),_(ie,e),_(se,e),_(oe,e),_(le,e),_(de,e),_(fe,e),_(ue,e),_(ge,e),_(_e,e),_($,e),_(be,e),_(ve),_(we),_(xe),_(ye),_(Te),_(Me),_(Ue),_(Je),_(Ze),_($e),_(Ie),_(je),_(We),_(Xe,e),_(Ge)}}}const mi='{"title":"UniDiffuser","local":"unidiffuser","sections":[{"title":"Usage Examples","local":"usage-examples","sections":[{"title":"Unconditional Image and Text Generation","local":"unconditional-image-and-text-generation","sections":[],"depth":3},{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":3},{"title":"Image-to-Text Generation","local":"image-to-text-generation","sections":[],"depth":3},{"title":"Image Variation","local":"image-variation","sections":[],"depth":3},{"title":"Text Variation","local":"text-variation","sections":[],"depth":3}],"depth":2},{"title":"UniDiffuserPipeline","local":"diffusers.UniDiffuserPipeline","sections":[],"depth":2},{"title":"ImageTextPipelineOutput","local":"diffusers.ImageTextPipelineOutput","sections":[],"depth":2}],"depth":1}';function fi(Ve){return si(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vi extends ai{constructor(b){super(),oi(this,b,fi,di,ii,{})}}export{vi as component};
