import{s as Fe,n as He,o as Ye}from"../chunks/scheduler.182ea377.js";import{S as Ie,i as Re,g as n,s as a,r as p,A as Ve,h as o,f as l,c as i,j as Se,u as m,x as r,k as Ue,y as Ne,a as s,v as u,d,t as c,w as f}from"../chunks/index.abf12888.js";import{C as V}from"../chunks/CodeBlock.57fe6e13.js";import{D as Le}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as Q}from"../chunks/Heading.16916d63.js";function Qe(Je){let b,E,N,q,y,z,M,D,w,Te=`SDXL Turbo is an adversarial time-distilled <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> (SDXL) model capable
of running inference in as little as 1 step.`,P,U,Ze="This guide will show you how to use SDXL-Turbo for text-to-image and image-to-image.",A,J,je="Before you begin, make sure you have the following libraries installed:",K,T,O,Z,ee,j,Ge='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',te,G,le,$,$e='You can also use the <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method to load a model checkpoint stored in a single file format (<code>.ckpt</code> or <code>.safetensors</code>) from the Hub or locally:',se,W,ae,k,ie,v,We="For text-to-image, pass a text prompt. By default, SDXL Turbo generates a 512x512 image, and that resolution gives the best results. You can try setting the <code>height</code> and <code>width</code> parameters to 768x768 or 1024x1024, but you should expect quality degradations when doing so.",ne,x,ke=`Make sure to set <code>guidance_scale</code> to 0.0 to disable, as the model was trained without it. A single inference step is enough to generate high quality images.
Increasing the number of steps to 2, 3 or 4 should improve image quality.`,oe,_,pe,g,ve='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-text2img.png" alt="generated image of a racoon in a robe"/>',me,B,re,C,xe=`For image-to-image generation, make sure that <code>num_inference_steps * strength</code> is larger or equal to 1.
The image-to-image pipeline will run for <code>int(num_inference_steps * strength)</code> steps, e.g. <code>0.5 * 2.0 = 1</code> step in
our example below.`,ue,X,de,h,_e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-img2img.png" alt="Image-to-image generation sample using SDXL Turbo"/>',ce,S,fe,F,Be="<li>Compile the UNet if you are using PyTorch version 2 or better. The first inference run will be very slow, but subsequent ones will be much faster.</li>",be,H,ge,Y,Ce="<li>When using the default VAE, keep it in <code>float32</code> to avoid costly <code>dtype</code> conversions before and after each generation. You only need to do this one before your first generation:</li>",he,I,ye,R,Xe='As an alternative, you can also use a <a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">16-bit VAE</a> created by community member <a href="https://huggingface.co/madebyollin" rel="nofollow"><code>@madebyollin</code></a> that does not need to be upcasted to <code>float32</code>.',Me,L,we;return y=new Q({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h1"}}),M=new Le({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"}]}}),T=new V({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate</span>`,wrap:!1}}),Z=new Q({props:{title:"Load model checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),G=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),W=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMkZibG9iJTJGbWFpbiUyRnNkX3hsX3R1cmJvXzEuMF9mcDE2LnNhZmV0ZW5zb3JzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/sdxl-turbo/blob/main/sd_xl_turbo_1.0_fp16.safetensors&quot;</span>, torch_dtype=torch.float16)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),k=new Q({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),_=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lX3RleHQyaW1hZ2UlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZV90ZXh0MmltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjaW5lbWF0aWMlMjBzaG90JTIwb2YlMjBhJTIwYmFieSUyMHJhY29vbiUyMHdlYXJpbmclMjBhbiUyMGludHJpY2F0ZSUyMGl0YWxpYW4lMjBwcmllc3QlMjByb2JlLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2image = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline_text2image = pipeline_text2image.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cinematic shot of a baby racoon wearing an intricate italian priest robe.&quot;</span>

image = pipeline_text2image(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),B=new Q({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),X=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjB1c2UlMjBmcm9tX3BpcGUlMjB0byUyMGF2b2lkJTIwY29uc3VtaW5nJTIwYWRkaXRpb25hbCUyMG1lbW9yeSUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMGNoZWNrcG9pbnQlMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltYWdlKS50byglMjJjdWRhJTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhdC5wbmclMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMHdpemFyZCUyQyUyMGdhbmRhbGYlMkMlMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGRldGFpbGVkJTJDJTIwZmFudGFzeSUyQyUyMGN1dGUlMkMlMjBhZG9yYWJsZSUyQyUyMFBpeGFyJTJDJTIwRGlzbmV5JTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC41JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMikuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">2</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),S=new Q({props:{title:"Speed-up SDXL Turbo even more",local:"speed-up-sdxl-turbo-even-more",headingTag:"h2"}}),H=new V({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:'pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),I=new V({props:{code:"cGlwZS51cGNhc3RfdmFlKCk=",highlighted:"pipe.upcast_vae()",wrap:!1}}),{c(){b=n("meta"),E=a(),N=n("p"),q=a(),p(y.$$.fragment),z=a(),p(M.$$.fragment),D=a(),w=n("p"),w.innerHTML=Te,P=a(),U=n("p"),U.textContent=Ze,A=a(),J=n("p"),J.textContent=je,K=a(),p(T.$$.fragment),O=a(),p(Z.$$.fragment),ee=a(),j=n("p"),j.innerHTML=Ge,te=a(),p(G.$$.fragment),le=a(),$=n("p"),$.innerHTML=$e,se=a(),p(W.$$.fragment),ae=a(),p(k.$$.fragment),ie=a(),v=n("p"),v.innerHTML=We,ne=a(),x=n("p"),x.innerHTML=ke,oe=a(),p(_.$$.fragment),pe=a(),g=n("div"),g.innerHTML=ve,me=a(),p(B.$$.fragment),re=a(),C=n("p"),C.innerHTML=xe,ue=a(),p(X.$$.fragment),de=a(),h=n("div"),h.innerHTML=_e,ce=a(),p(S.$$.fragment),fe=a(),F=n("ul"),F.innerHTML=Be,be=a(),p(H.$$.fragment),ge=a(),Y=n("ul"),Y.innerHTML=Ce,he=a(),p(I.$$.fragment),ye=a(),R=n("p"),R.innerHTML=Xe,Me=a(),L=n("p"),this.h()},l(e){const t=Ve("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),E=i(e),N=o(e,"P",{}),Se(N).forEach(l),q=i(e),m(y.$$.fragment,e),z=i(e),m(M.$$.fragment,e),D=i(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1465uj8"&&(w.innerHTML=Te),P=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-851pbc"&&(U.textContent=Ze),A=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-cwruts"&&(J.textContent=je),K=i(e),m(T.$$.fragment,e),O=i(e),m(Z.$$.fragment,e),ee=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-hva56b"&&(j.innerHTML=Ge),te=i(e),m(G.$$.fragment,e),le=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1bnykxt"&&($.innerHTML=$e),se=i(e),m(W.$$.fragment,e),ae=i(e),m(k.$$.fragment,e),ie=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1urqyhr"&&(v.innerHTML=We),ne=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-d70s1"&&(x.innerHTML=ke),oe=i(e),m(_.$$.fragment,e),pe=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1lx4ppg"&&(g.innerHTML=ve),me=i(e),m(B.$$.fragment,e),re=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1rvgn5v"&&(C.innerHTML=xe),ue=i(e),m(X.$$.fragment,e),de=i(e),h=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ovbosa"&&(h.innerHTML=_e),ce=i(e),m(S.$$.fragment,e),fe=i(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1d7cg56"&&(F.innerHTML=Be),be=i(e),m(H.$$.fragment,e),ge=i(e),Y=o(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-jn62ws"&&(Y.innerHTML=Ce),he=i(e),m(I.$$.fragment,e),ye=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1pt3hz0"&&(R.innerHTML=Xe),Me=i(e),L=o(e,"P",{}),Se(L).forEach(l),this.h()},h(){Ue(b,"name","hf:doc:metadata"),Ue(b,"content",Ee),Ue(g,"class","flex justify-center"),Ue(h,"class","flex justify-center")},m(e,t){Ne(document.head,b),s(e,E,t),s(e,N,t),s(e,q,t),u(y,e,t),s(e,z,t),u(M,e,t),s(e,D,t),s(e,w,t),s(e,P,t),s(e,U,t),s(e,A,t),s(e,J,t),s(e,K,t),u(T,e,t),s(e,O,t),u(Z,e,t),s(e,ee,t),s(e,j,t),s(e,te,t),u(G,e,t),s(e,le,t),s(e,$,t),s(e,se,t),u(W,e,t),s(e,ae,t),u(k,e,t),s(e,ie,t),s(e,v,t),s(e,ne,t),s(e,x,t),s(e,oe,t),u(_,e,t),s(e,pe,t),s(e,g,t),s(e,me,t),u(B,e,t),s(e,re,t),s(e,C,t),s(e,ue,t),u(X,e,t),s(e,de,t),s(e,h,t),s(e,ce,t),u(S,e,t),s(e,fe,t),s(e,F,t),s(e,be,t),u(H,e,t),s(e,ge,t),s(e,Y,t),s(e,he,t),u(I,e,t),s(e,ye,t),s(e,R,t),s(e,Me,t),s(e,L,t),we=!0},p:He,i(e){we||(d(y.$$.fragment,e),d(M.$$.fragment,e),d(T.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(k.$$.fragment,e),d(_.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d(H.$$.fragment,e),d(I.$$.fragment,e),we=!0)},o(e){c(y.$$.fragment,e),c(M.$$.fragment,e),c(T.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(k.$$.fragment,e),c(_.$$.fragment,e),c(B.$$.fragment,e),c(X.$$.fragment,e),c(S.$$.fragment,e),c(H.$$.fragment,e),c(I.$$.fragment,e),we=!1},d(e){e&&(l(E),l(N),l(q),l(z),l(D),l(w),l(P),l(U),l(A),l(J),l(K),l(O),l(ee),l(j),l(te),l(le),l($),l(se),l(ae),l(ie),l(v),l(ne),l(x),l(oe),l(pe),l(g),l(me),l(re),l(C),l(ue),l(de),l(h),l(ce),l(fe),l(F),l(be),l(ge),l(Y),l(he),l(ye),l(R),l(Me),l(L)),l(b),f(y,e),f(M,e),f(T,e),f(Z,e),f(G,e),f(W,e),f(k,e),f(_,e),f(B,e),f(X,e),f(S,e),f(H,e),f(I,e)}}}const Ee='{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Load model checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Speed-up SDXL Turbo even more","local":"speed-up-sdxl-turbo-even-more","sections":[],"depth":2}],"depth":1}';function qe(Je){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ie{constructor(b){super(),Re(this,b,qe,Qe,Fe,{})}}export{Oe as component};
