import{s as es,o as ts,n as G}from"../chunks/scheduler.8c3d61f6.js";import{S as ns,i as os,g as a,s as i,r as u,A as is,h as r,f as p,c as s,j as U,u as h,x as c,k as Z,y as n,a as v,v as g,d as b,t as _,w as y}from"../chunks/index.da70eac4.js";import{T as _t}from"../chunks/Tip.1d9b8c37.js";import{D as j}from"../chunks/Docstring.9419aa1d.js";import{C as oe}from"../chunks/CodeBlock.a9c4becf.js";import{E as ne}from"../chunks/ExampleCodeBlock.1b2603c3.js";import{H as Gn,E as ss}from"../chunks/getInferenceSnippets.39110341.js";function as(T){let o,w='You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',d,l,m,t,M='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){o=a("p"),o.innerHTML=w,d=i(),l=a("br"),m=i(),t=a("p"),t.innerHTML=M},l(C){o=r(C,"P",{"data-svelte-h":!0}),c(o)!=="svelte-17t0bk9"&&(o.innerHTML=w),d=s(C),l=r(C,"BR",{}),m=s(C),t=r(C,"P",{"data-svelte-h":!0}),c(t)!=="svelte-1a94ctl"&&(t.innerHTML=M)},m(C,Q){v(C,o,Q),v(C,d,Q),v(C,l,Q),v(C,m,Q),v(C,t,Q)},p:G,d(C){C&&(p(o),p(d),p(l),p(m),p(t))}}}function rs(T){let o,w=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){o=a("p"),o.textContent=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-18gkv0g"&&(o.textContent=w)},m(d,l){v(d,o,l)},p:G,d(d){d&&p(o)}}}function ls(T){let o,w="Examples:",d,l,m;return l=new oe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBaW1nMmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMpJTBBaW5wYWludCUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function ds(T){let o,w=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=a("p"),o.innerHTML=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-6jnfc0"&&(o.innerHTML=w)},m(d,l){v(d,o,l)},p:G,d(d){d&&p(o)}}}function ps(T){let o,w=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=a("p"),o.innerHTML=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-ackzsn"&&(o.innerHTML=w)},m(d,l){v(d,o,l)},p:G,d(d){d&&p(o)}}}function fs(T){let o,w="Examples:",d,l,m;return l=new oe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function cs(T){let o,w=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=a("p"),o.textContent=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-17p1lpg"&&(o.textContent=w)},m(d,l){v(d,o,l)},p:G,d(d){d&&p(o)}}}function ms(T){let o,w="Examples:",d,l,m;return l=new oe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function us(T){let o,w="Examples:",d,l,m;return l=new oe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFuZXdfcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblNBR1BpcGVsaW5lLmZyb21fcGlwZShwaXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionSAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>new_pipe = StableDiffusionSAGPipeline.from_pipe(pipe)`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function hs(T){let o,w="If you get the error message below, you need to finetune the weights for your downstream task:",d,l,m;return l=new oe({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQSUwQS0lMjBjb252X2luLndlaWdodCUzQSUyMGZvdW5kJTIwc2hhcGUlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDQlMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMGNoZWNrcG9pbnQlMjBhbmQlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDklMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMG1vZGVsJTIwaW5zdGFudGlhdGVkJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint <span class="hljs-built_in">at</span> stable-<span class="hljs-keyword">diffusion-v1-5/stable-diffusion-v1-5 </span><span class="hljs-keyword">and </span>are newly initialized <span class="hljs-keyword">because </span>the <span class="hljs-keyword">shapes </span><span class="hljs-keyword">did </span>not match:
- conv_in.weight: found <span class="hljs-keyword">shape </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the checkpoint <span class="hljs-keyword">and </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the model <span class="hljs-keyword">instantiated
</span>You <span class="hljs-keyword">should </span>probably TRAIN this model on a down-stream task to <span class="hljs-keyword">be </span>able to use it for predictions <span class="hljs-keyword">and </span>inference.`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-xueb0m"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function gs(T){let o,w=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=a("p"),o.innerHTML=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-x73rgs"&&(o.innerHTML=w)},m(d,l){v(d,o,l)},p:G,d(d){d&&p(o)}}}function bs(T){let o,w="Examples:",d,l,m;return l=new oe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUwQSUyMyUyMFVzZSUyMGElMjBkaWZmZXJlbnQlMjBzY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTE1TRGlzY3JldGVTY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMHNjaGVkdWxlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function _s(T){let o,w="If you get the error message below, you need to finetune the weights for your downstream task:",d,l,m;return l=new oe({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUyMHdlcmUlMjBub3QlMjBpbml0aWFsaXplZCUyMGZyb20lMjB0aGUlMjBtb2RlbCUyMGNoZWNrcG9pbnQlMjBhdCUyMHN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMGFuZCUyMGFyZSUyMG5ld2x5JTIwaW5pdGlhbGl6ZWQlMjBiZWNhdXNlJTIwdGhlJTIwc2hhcGVzJTIwZGlkJTIwbm90JTIwbWF0Y2glM0E=",highlighted:'Some weights of FlaxUNet2DConditionModel were not initialized from the model checkpoint <span class="hljs-built_in">at</span> stable-<span class="hljs-keyword">diffusion-v1-5/stable-diffusion-v1-5 </span><span class="hljs-keyword">and </span>are newly initialized <span class="hljs-keyword">because </span>the <span class="hljs-keyword">shapes </span><span class="hljs-keyword">did </span>not match:',wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-xueb0m"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function ys(T){let o,w=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=a("p"),o.innerHTML=w},l(d){o=r(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-6jnfc0"&&(o.innerHTML=w)},m(d,l){v(d,o,l)},p:G,d(d){d&&p(o)}}}function vs(T){let o,w="Examples:",d,l,m;return l=new oe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEElMjMlMjBSZXF1aXJlcyUyMHRvJTIwYmUlMjBsb2dnZWQlMjBpbiUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMkMlMEElMjMlMjBzZWUlMjBtb3JlJTIwaW4lMjAlNUJ0aGUlMjBkb2N1bWVudGF0aW9uJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc2VjdXJpdHktdG9rZW5zKSUwQXBpcGVsaW5lJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEam5wLmJmbG9hdDE2JTJDJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMkMlMjBidXQlMjB1c2UlMjBhJTIwZGlmZmVyZW50JTIwc2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWRwbXBwJTJDJTIwZHBtcHBfc3RhdGUlMjAlM0QlMjBGbGF4RFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSklMEElMEFkcG1fcGlwZSUyQyUyMGRwbV9wYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwdmFyaWFudCUzRCUyMmJmMTYlMjIlMkMlMjBkdHlwZSUzRGpucC5iZmxvYXQxNiUyQyUyMHNjaGVkdWxlciUzRGRwbXBwJTBBKSUwQWRwbV9wYXJhbXMlNUIlMjJzY2hlZHVsZXIlMjIlNUQlMjAlM0QlMjBkcG1wcF9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Requires to be logged in to Hugging Face hub,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see more in [the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;bf16&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline, but use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDPMSolverMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dpmpp, dpmpp_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_pipe, dpm_params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, variant=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jnp.bfloat16, scheduler=dpmpp
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_params[<span class="hljs-string">&quot;scheduler&quot;</span>] = dpmpp_state`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function xs(T){let o,w="Examples:",d,l,m;return l=new oe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=w,d=i(),u(l.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=w),d=s(t),h(l.$$.fragment,t)},m(t,M){v(t,o,M),v(t,d,M),g(l,t,M),m=!0},p:G,i(t){m||(b(l.$$.fragment,t),m=!0)},o(t){_(l.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),y(l,t)}}}function ws(T){let o,w,d,l,m,t,M,C="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",Q,De,li='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',un,ie,hn,Je,di="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",gn,Ge,pi='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="amused">aMUSEd</a></td> <td>text2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="auraflow">AuraFlow</a></td> <td>text2image</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="cogvideox">CogVideoX</a></td> <td>text2video</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_flux">ControlNet with Flux.1</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_hunyuandit">ControlNet with Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sd3">ControlNet with Stable Diffusion 3</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="flux">Flux</a></td> <td>text2image</td></tr> <tr><td><a href="hunyuandit">Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="i2vgenxl">I2VGen-XL</a></td> <td>image2video</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="kolors">Kolors</a></td> <td>text2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="latte">Latte</a></td> <td>text2image</td></tr> <tr><td><a href="ledits_pp">LEDITS++</a></td> <td>image editing</td></tr> <tr><td><a href="lumina">Lumina-T2X</a></td> <td>text2image</td></tr> <tr><td><a href="marigold">Marigold</a></td> <td>depth-estimation, normals-estimation, intrinsic-decomposition</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="pag">PAG</a></td> <td>text2image</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="pia">PIA</a></td> <td>image2video</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pixart_sigma">PixArt-Σ</a></td> <td>text2image</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="stable_audio">Stable Audio</a></td> <td>text2audio</td></tr> <tr><td><a href="stable_cascade">Stable Cascade</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr> <tr><td><a href="visualcloze">VisualCloze</a></td> <td>text2image, image2image, subject driven generation, inpainting, style transfer, image restoration, image editing, [depth,normal,edge,pose]2image, [depth,normal,edge,pose]-estimation, virtual try-on, image relighting</td></tr></tbody>',bn,Ie,_n,x,We,In,yt,fi="Base class for all pipelines.",Wn,vt,ci=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Hn,xt,mi="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",Fn,wt,ui="Class attributes:",Bn,$t,hi=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,Sn,se,He,Nn,Mt,gi="Call self as a function.",Vn,Tt,Fe,Ln,W,Be,Xn,Ut,bi=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,Rn,ae,En,Zt,_i="Here are the ways to call <code>to</code>:",zn,jt,yi=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,Yn,B,Se,Qn,kt,vi=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,qn,Pt,xi=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,An,re,On,le,Ne,Kn,Ct,wi=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,eo,de,Ve,to,Dt,$i='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',no,q,Le,oo,Jt,Mi="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",io,pe,so,S,Xe,ao,Gt,Ti=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,ro,fe,lo,ce,po,me,Re,fo,It,Ui=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the accelerator when its
<code>forward</code> method is called, and the model remains in accelerator until the next model runs. Memory savings are
lower than with <code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution
of the <code>unet</code>.`,co,ue,Ee,mo,Wt,Zi=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to accelerator only when their specific submodule has its
<code>forward</code> method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,uo,N,ze,ho,Ht,ji=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,go,he,bo,ge,_o,A,Ye,yo,Ft,ki=`Create a new pipeline from a given pipeline. This method is useful to create a new pipeline from the existing
pipeline components without reallocating additional memory.`,vo,be,xo,D,Qe,wo,Bt,Pi="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",$o,St,Ci="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",Mo,_e,To,ye,Uo,ve,Zo,V,qe,jo,Nt,Di="Method that performs the following:",ko,Vt,Ji=`<li>Offloads all components.</li> <li>Removes all model hooks that were added when using <code>enable_model_cpu_offload</code>, and then applies them again.
In case the model has not been offloaded, this function is a no-op.</li> <li>Resets stateful diffusers hooks of denoiser components if they were added with
<code>register_hook()</code>.</li>`,Po,Lt,Gi=`Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it functions
correctly when applying <code>enable_model_cpu_offload</code>.`,Co,xe,Ae,Do,Xt,Ii="Convert a NumPy image or a batch of images to a PIL image.",Jo,we,Oe,Go,Rt,Wi="Removes all hooks that were added when using <code>enable_sequential_cpu_offload</code> or <code>enable_model_cpu_offload</code>.",Io,$e,Ke,Wo,Et,Hi="Resets the device maps (if any) to None.",Ho,Me,et,Fo,zt,Fi=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,yn,H,tt,Bo,Yt,Bi='Enables the FreeU mechanism as in <a href="https://huggingface.co/papers/2309.11497" rel="nofollow">https://huggingface.co/papers/2309.11497</a>.',So,Qt,Si="The suffixes after the scaling factors represent the stages where they are being applied.",No,qt,Ni=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,vn,K,nt,Vo,At,Vi="Disables the FreeU mechanism if enabled.",xn,ot,wn,k,it,Lo,Ot,Li="Base class for Flax-based pipelines.",Xo,Kt,Xi=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Ro,en,Ri="<li>enable/disable the progress bar for the denoising iteration</li>",Eo,tn,Ei="Class attributes:",zo,nn,zi=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li>`,Yo,J,st,Qo,on,Yi="Instantiate a Flax-based diffusion pipeline from pretrained pipeline weights.",qo,sn,Qi="The pipeline is set in evaluation mode (`model.eval()) by default and dropout modules are deactivated.",Ao,Te,Oo,Ue,Ko,Ze,ei,je,at,ti,an,qi="Convert a NumPy image or a batch of images to a PIL image.",ni,ke,rt,oi,rn,Ai=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,$n,lt,Mn,X,dt,ii,ln,Oi="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",si,O,pt,ai,dn,Ki="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",ri,Pe,Tn,ft,Un,cn,Zn;return m=new Gn({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),ie=new _t({props:{warning:!0,$$slots:{default:[as]},$$scope:{ctx:T}}}),Ie=new Gn({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),We=new j({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L179"}}),He=new j({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Fe=new j({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L557",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Be=new j({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L368",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),ae=new _t({props:{$$slots:{default:[rs]},$$scope:{ctx:T}}}),Se=new j({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1711"}}),re=new ne({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[ls]},$$scope:{ctx:T}}}),Ne=new j({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1876"}}),Ve=new j({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1810"}}),Le=new j({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified DDUF file.`,name:"dduf_file(str,"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1349",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),pe=new _t({props:{$$slots:{default:[ds]},$$scope:{ctx:T}}}),Xe=new j({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1836"}}),fe=new _t({props:{warning:!0,$$slots:{default:[ps]},$$scope:{ctx:T}}}),ce=new ne({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[fs]},$$scope:{ctx:T}}}),Re=new j({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1150"}}),Ee=new j({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1268"}}),ze=new j({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1775"}}),he=new _t({props:{warning:!0,$$slots:{default:[cs]},$$scope:{ctx:T}}}),ge=new ne({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ms]},$$scope:{ctx:T}}}),Ye=new j({props:{name:"from_pipe",anchor:"diffusers.DiffusionPipeline.from_pipe",parameters:[{name:"pipeline",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pipe.pipeline",description:`<strong>pipeline</strong> (<code>DiffusionPipeline</code>) &#x2014;
The pipeline from which to create a new pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1892",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A new pipeline with the same weights and configurations as <code>pipeline</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>DiffusionPipeline</code></p>
`}}),be=new ne({props:{anchor:"diffusers.DiffusionPipeline.from_pipe.example",$$slots:{default:[us]},$$scope:{ctx:T}}}),Qe=new j({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing a dduf file</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>torch.dtype</code> or <code>dict[str, Union[str, torch.dtype]]</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. To load submodels with
different dtype pass a <code>dict</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;vae&apos;: torch.float16}</code>).
Set the default dtype for unspecified components with <code>default</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;default&apos;: torch.float16}</code>). If a component is not specified and no default is set,
<code>torch.float32</code> is used.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. Defaults to the latest stable &#x1F917; Diffusers
version.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified dduf file.`,name:"dduf_file(str,"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L587"}}),_e=new ne({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[hs]},$$scope:{ctx:T}}}),ye=new _t({props:{$$slots:{default:[gs]},$$scope:{ctx:T}}}),ve=new ne({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[bs]},$$scope:{ctx:T}}}),qe=new j({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1245"}}),Ae=new j({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1749"}}),Oe=new j({props:{name:"remove_all_hooks",anchor:"diffusers.DiffusionPipeline.remove_all_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1141"}}),Ke=new j({props:{name:"reset_device_map",anchor:"diffusers.DiffusionPipeline.reset_device_map",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1336"}}),et=new j({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, defaults to <code>None</code>) &#x2014;
The maximum size for a checkpoint before being sharded. Checkpoints shard will then be each of size
lower than this size. If expressed as a string, needs to be digits followed by a unit (like <code>&quot;5GB&quot;</code>).
If expressed as an integer, the unit is bytes. Note that this limit will be decreased after a certain
period of time (starting from Oct 2024) to allow users to upgrade to the latest version of <code>diffusers</code>.
This is to establish a common default size for this argument across different libraries in the Hugging
Face ecosystem (<code>transformers</code>, and <code>accelerate</code>, for example).`,name:"max_shard_size"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L235"}}),tt=new j({props:{name:"diffusers.StableDiffusionMixin.enable_freeu",anchor:"diffusers.StableDiffusionMixin.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2068"}}),nt=new j({props:{name:"diffusers.StableDiffusionMixin.disable_freeu",anchor:"diffusers.StableDiffusionMixin.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2090"}}),ot=new Gn({props:{title:"FlaxDiffusionPipeline",local:"diffusers.FlaxDiffusionPipeline",headingTag:"h2"}}),it=new j({props:{name:"class diffusers.FlaxDiffusionPipeline",anchor:"diffusers.FlaxDiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L101"}}),st=new j({props:{name:"from_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>stable-diffusion-v1-5/stable-diffusion-v1-5</code>) of a
pretrained pipeline hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>jnp.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>jnp.dtype</code> and load the model under this dtype.`,name:"dtype"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components) of the specific pipeline
class. The overwritten components are passed directly to the pipelines <code>__init__</code> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L229"}}),Te=new ne({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example",$$slots:{default:[_s]},$$scope:{ctx:T}}}),Ue=new _t({props:{$$slots:{default:[ys]},$$scope:{ctx:T}}}),Ze=new ne({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example-2",$$slots:{default:[vs]},$$scope:{ctx:T}}}),at=new j({props:{name:"numpy_to_pil",anchor:"diffusers.FlaxDiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L582"}}),rt=new j({props:{name:"save_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L151"}}),lt=new Gn({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),dt=new j({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L458"}}),pt=new j({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the
organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L487"}}),Pe=new ne({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[xs]},$$scope:{ctx:T}}}),ft=new ss({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/overview.md"}}),{c(){o=a("meta"),w=i(),d=a("p"),l=i(),u(m.$$.fragment),t=i(),M=a("p"),M.textContent=C,Q=i(),De=a("p"),De.innerHTML=li,un=i(),u(ie.$$.fragment),hn=i(),Je=a("p"),Je.textContent=di,gn=i(),Ge=a("table"),Ge.innerHTML=pi,bn=i(),u(Ie.$$.fragment),_n=i(),x=a("div"),u(We.$$.fragment),In=i(),yt=a("p"),yt.textContent=fi,Wn=i(),vt=a("p"),vt.innerHTML=ci,Hn=i(),xt=a("ul"),xt.innerHTML=mi,Fn=i(),wt=a("p"),wt.textContent=ui,Bn=i(),$t=a("ul"),$t.innerHTML=hi,Sn=i(),se=a("div"),u(He.$$.fragment),Nn=i(),Mt=a("p"),Mt.textContent=gi,Vn=i(),Tt=a("div"),u(Fe.$$.fragment),Ln=i(),W=a("div"),u(Be.$$.fragment),Xn=i(),Ut=a("p"),Ut.innerHTML=bi,Rn=i(),u(ae.$$.fragment),En=i(),Zt=a("p"),Zt.innerHTML=_i,zn=i(),jt=a("ul"),jt.innerHTML=yi,Yn=i(),B=a("div"),u(Se.$$.fragment),Qn=i(),kt=a("p"),kt.innerHTML=vi,qn=i(),Pt=a("p"),Pt.innerHTML=xi,An=i(),u(re.$$.fragment),On=i(),le=a("div"),u(Ne.$$.fragment),Kn=i(),Ct=a("p"),Ct.innerHTML=wi,eo=i(),de=a("div"),u(Ve.$$.fragment),to=i(),Dt=a("p"),Dt.innerHTML=$i,no=i(),q=a("div"),u(Le.$$.fragment),oo=i(),Jt=a("p"),Jt.textContent=Mi,io=i(),u(pe.$$.fragment),so=i(),S=a("div"),u(Xe.$$.fragment),ao=i(),Gt=a("p"),Gt.textContent=Ti,ro=i(),u(fe.$$.fragment),lo=i(),u(ce.$$.fragment),po=i(),me=a("div"),u(Re.$$.fragment),fo=i(),It=a("p"),It.innerHTML=Ui,co=i(),ue=a("div"),u(Ee.$$.fragment),mo=i(),Wt=a("p"),Wt.innerHTML=Zi,uo=i(),N=a("div"),u(ze.$$.fragment),ho=i(),Ht=a("p"),Ht.innerHTML=ji,go=i(),u(he.$$.fragment),bo=i(),u(ge.$$.fragment),_o=i(),A=a("div"),u(Ye.$$.fragment),yo=i(),Ft=a("p"),Ft.textContent=ki,vo=i(),u(be.$$.fragment),xo=i(),D=a("div"),u(Qe.$$.fragment),wo=i(),Bt=a("p"),Bt.textContent=Pi,$o=i(),St=a("p"),St.innerHTML=Ci,Mo=i(),u(_e.$$.fragment),To=i(),u(ye.$$.fragment),Uo=i(),u(ve.$$.fragment),Zo=i(),V=a("div"),u(qe.$$.fragment),jo=i(),Nt=a("p"),Nt.textContent=Di,ko=i(),Vt=a("ul"),Vt.innerHTML=Ji,Po=i(),Lt=a("p"),Lt.innerHTML=Gi,Co=i(),xe=a("div"),u(Ae.$$.fragment),Do=i(),Xt=a("p"),Xt.textContent=Ii,Jo=i(),we=a("div"),u(Oe.$$.fragment),Go=i(),Rt=a("p"),Rt.innerHTML=Wi,Io=i(),$e=a("div"),u(Ke.$$.fragment),Wo=i(),Et=a("p"),Et.textContent=Hi,Ho=i(),Me=a("div"),u(et.$$.fragment),Fo=i(),zt=a("p"),zt.innerHTML=Fi,yn=i(),H=a("div"),u(tt.$$.fragment),Bo=i(),Yt=a("p"),Yt.innerHTML=Bi,So=i(),Qt=a("p"),Qt.textContent=Si,No=i(),qt=a("p"),qt.innerHTML=Ni,vn=i(),K=a("div"),u(nt.$$.fragment),Vo=i(),At=a("p"),At.textContent=Vi,xn=i(),u(ot.$$.fragment),wn=i(),k=a("div"),u(it.$$.fragment),Lo=i(),Ot=a("p"),Ot.textContent=Li,Xo=i(),Kt=a("p"),Kt.innerHTML=Xi,Ro=i(),en=a("ul"),en.innerHTML=Ri,Eo=i(),tn=a("p"),tn.textContent=Ei,zo=i(),nn=a("ul"),nn.innerHTML=zi,Yo=i(),J=a("div"),u(st.$$.fragment),Qo=i(),on=a("p"),on.textContent=Yi,qo=i(),sn=a("p"),sn.textContent=Qi,Ao=i(),u(Te.$$.fragment),Oo=i(),u(Ue.$$.fragment),Ko=i(),u(Ze.$$.fragment),ei=i(),je=a("div"),u(at.$$.fragment),ti=i(),an=a("p"),an.textContent=qi,ni=i(),ke=a("div"),u(rt.$$.fragment),oi=i(),rn=a("p"),rn.innerHTML=Ai,$n=i(),u(lt.$$.fragment),Mn=i(),X=a("div"),u(dt.$$.fragment),ii=i(),ln=a("p"),ln.textContent=Oi,si=i(),O=a("div"),u(pt.$$.fragment),ai=i(),dn=a("p"),dn.textContent=Ki,ri=i(),u(Pe.$$.fragment),Tn=i(),u(ft.$$.fragment),Un=i(),cn=a("p"),this.h()},l(e){const f=is("svelte-u9bgzb",document.head);o=r(f,"META",{name:!0,content:!0}),f.forEach(p),w=s(e),d=r(e,"P",{}),U(d).forEach(p),l=s(e),h(m.$$.fragment,e),t=s(e),M=r(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-eejdx6"&&(M.textContent=C),Q=s(e),De=r(e,"P",{"data-svelte-h":!0}),c(De)!=="svelte-1d3b6kb"&&(De.innerHTML=li),un=s(e),h(ie.$$.fragment,e),hn=s(e),Je=r(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-2xd39c"&&(Je.textContent=di),gn=s(e),Ge=r(e,"TABLE",{"data-svelte-h":!0}),c(Ge)!=="svelte-1hsbta5"&&(Ge.innerHTML=pi),bn=s(e),h(Ie.$$.fragment,e),_n=s(e),x=r(e,"DIV",{class:!0});var $=U(x);h(We.$$.fragment,$),In=s($),yt=r($,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-1neg3rw"&&(yt.textContent=fi),Wn=s($),vt=r($,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-1kbb8l4"&&(vt.innerHTML=ci),Hn=s($),xt=r($,"UL",{"data-svelte-h":!0}),c(xt)!=="svelte-2a5chx"&&(xt.innerHTML=mi),Fn=s($),wt=r($,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-wz8va1"&&(wt.textContent=ui),Bn=s($),$t=r($,"UL",{"data-svelte-h":!0}),c($t)!=="svelte-1ilr6sx"&&($t.innerHTML=hi),Sn=s($),se=r($,"DIV",{class:!0});var ct=U(se);h(He.$$.fragment,ct),Nn=s(ct),Mt=r(ct,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-1eed40t"&&(Mt.textContent=gi),ct.forEach(p),Vn=s($),Tt=r($,"DIV",{class:!0});var mn=U(Tt);h(Fe.$$.fragment,mn),mn.forEach(p),Ln=s($),W=r($,"DIV",{class:!0});var F=U(W);h(Be.$$.fragment,F),Xn=s(F),Ut=r(F,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-1vbhnip"&&(Ut.innerHTML=bi),Rn=s(F),h(ae.$$.fragment,F),En=s(F),Zt=r(F,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-5ul9n2"&&(Zt.innerHTML=_i),zn=s(F),jt=r(F,"UL",{"data-svelte-h":!0}),c(jt)!=="svelte-1icy6l9"&&(jt.innerHTML=yi),F.forEach(p),Yn=s($),B=r($,"DIV",{class:!0});var R=U(B);h(Se.$$.fragment,R),Qn=s(R),kt=r(R,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-had4mb"&&(kt.innerHTML=vi),qn=s(R),Pt=r(R,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-19k67ce"&&(Pt.innerHTML=xi),An=s(R),h(re.$$.fragment,R),R.forEach(p),On=s($),le=r($,"DIV",{class:!0});var mt=U(le);h(Ne.$$.fragment,mt),Kn=s(mt),Ct=r(mt,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-1lh0nh5"&&(Ct.innerHTML=wi),mt.forEach(p),eo=s($),de=r($,"DIV",{class:!0});var ut=U(de);h(Ve.$$.fragment,ut),to=s(ut),Dt=r(ut,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-1vfte1e"&&(Dt.innerHTML=$i),ut.forEach(p),no=s($),q=r($,"DIV",{class:!0});var ee=U(q);h(Le.$$.fragment,ee),oo=s(ee),Jt=r(ee,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-1mfctah"&&(Jt.textContent=Mi),io=s(ee),h(pe.$$.fragment,ee),ee.forEach(p),so=s($),S=r($,"DIV",{class:!0});var E=U(S);h(Xe.$$.fragment,E),ao=s(E),Gt=r(E,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-10jaql7"&&(Gt.textContent=Ti),ro=s(E),h(fe.$$.fragment,E),lo=s(E),h(ce.$$.fragment,E),E.forEach(p),po=s($),me=r($,"DIV",{class:!0});var ht=U(me);h(Re.$$.fragment,ht),fo=s(ht),It=r(ht,"P",{"data-svelte-h":!0}),c(It)!=="svelte-9hgqai"&&(It.innerHTML=Ui),ht.forEach(p),co=s($),ue=r($,"DIV",{class:!0});var gt=U(ue);h(Ee.$$.fragment,gt),mo=s(gt),Wt=r(gt,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-1bs0ixe"&&(Wt.innerHTML=Zi),gt.forEach(p),uo=s($),N=r($,"DIV",{class:!0});var z=U(N);h(ze.$$.fragment,z),ho=s(z),Ht=r(z,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-e03q3e"&&(Ht.innerHTML=ji),go=s(z),h(he.$$.fragment,z),bo=s(z),h(ge.$$.fragment,z),z.forEach(p),_o=s($),A=r($,"DIV",{class:!0});var te=U(A);h(Ye.$$.fragment,te),yo=s(te),Ft=r(te,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-1jx3icn"&&(Ft.textContent=ki),vo=s(te),h(be.$$.fragment,te),te.forEach(p),xo=s($),D=r($,"DIV",{class:!0});var I=U(D);h(Qe.$$.fragment,I),wo=s(I),Bt=r(I,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-ccbjek"&&(Bt.textContent=Pi),$o=s(I),St=r(I,"P",{"data-svelte-h":!0}),c(St)!=="svelte-1p5vgmd"&&(St.innerHTML=Ci),Mo=s(I),h(_e.$$.fragment,I),To=s(I),h(ye.$$.fragment,I),Uo=s(I),h(ve.$$.fragment,I),I.forEach(p),Zo=s($),V=r($,"DIV",{class:!0});var Y=U(V);h(qe.$$.fragment,Y),jo=s(Y),Nt=r(Y,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-z79kjq"&&(Nt.textContent=Di),ko=s(Y),Vt=r(Y,"UL",{"data-svelte-h":!0}),c(Vt)!=="svelte-1ju7puc"&&(Vt.innerHTML=Ji),Po=s(Y),Lt=r(Y,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-1pqppti"&&(Lt.innerHTML=Gi),Y.forEach(p),Co=s($),xe=r($,"DIV",{class:!0});var bt=U(xe);h(Ae.$$.fragment,bt),Do=s(bt),Xt=r(bt,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-1gut907"&&(Xt.textContent=Ii),bt.forEach(p),Jo=s($),we=r($,"DIV",{class:!0});var jn=U(we);h(Oe.$$.fragment,jn),Go=s(jn),Rt=r(jn,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-8kophh"&&(Rt.innerHTML=Wi),jn.forEach(p),Io=s($),$e=r($,"DIV",{class:!0});var kn=U($e);h(Ke.$$.fragment,kn),Wo=s(kn),Et=r(kn,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-6tjysh"&&(Et.textContent=Hi),kn.forEach(p),Ho=s($),Me=r($,"DIV",{class:!0});var Pn=U(Me);h(et.$$.fragment,Pn),Fo=s(Pn),zt=r(Pn,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-1jcmq84"&&(zt.innerHTML=Fi),Pn.forEach(p),$.forEach(p),yn=s(e),H=r(e,"DIV",{class:!0});var Ce=U(H);h(tt.$$.fragment,Ce),Bo=s(Ce),Yt=r(Ce,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-192jnkh"&&(Yt.innerHTML=Bi),So=s(Ce),Qt=r(Ce,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-xjijlp"&&(Qt.textContent=Si),No=s(Ce),qt=r(Ce,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-hy0nzs"&&(qt.innerHTML=Ni),Ce.forEach(p),vn=s(e),K=r(e,"DIV",{class:!0});var Cn=U(K);h(nt.$$.fragment,Cn),Vo=s(Cn),At=r(Cn,"P",{"data-svelte-h":!0}),c(At)!=="svelte-psupw6"&&(At.textContent=Vi),Cn.forEach(p),xn=s(e),h(ot.$$.fragment,e),wn=s(e),k=r(e,"DIV",{class:!0});var P=U(k);h(it.$$.fragment,P),Lo=s(P),Ot=r(P,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-1o1wti6"&&(Ot.textContent=Li),Xo=s(P),Kt=r(P,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-1h33ucg"&&(Kt.innerHTML=Xi),Ro=s(P),en=r(P,"UL",{"data-svelte-h":!0}),c(en)!=="svelte-1kk3msp"&&(en.innerHTML=Ri),Eo=s(P),tn=r(P,"P",{"data-svelte-h":!0}),c(tn)!=="svelte-wz8va1"&&(tn.textContent=Ei),zo=s(P),nn=r(P,"UL",{"data-svelte-h":!0}),c(nn)!=="svelte-56flce"&&(nn.innerHTML=zi),Yo=s(P),J=r(P,"DIV",{class:!0});var L=U(J);h(st.$$.fragment,L),Qo=s(L),on=r(L,"P",{"data-svelte-h":!0}),c(on)!=="svelte-7z61o"&&(on.textContent=Yi),qo=s(L),sn=r(L,"P",{"data-svelte-h":!0}),c(sn)!=="svelte-wyh2cr"&&(sn.textContent=Qi),Ao=s(L),h(Te.$$.fragment,L),Oo=s(L),h(Ue.$$.fragment,L),Ko=s(L),h(Ze.$$.fragment,L),L.forEach(p),ei=s(P),je=r(P,"DIV",{class:!0});var Dn=U(je);h(at.$$.fragment,Dn),ti=s(Dn),an=r(Dn,"P",{"data-svelte-h":!0}),c(an)!=="svelte-1gut907"&&(an.textContent=qi),Dn.forEach(p),ni=s(P),ke=r(P,"DIV",{class:!0});var Jn=U(ke);h(rt.$$.fragment,Jn),oi=s(Jn),rn=r(Jn,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-spoull"&&(rn.innerHTML=Ai),Jn.forEach(p),P.forEach(p),$n=s(e),h(lt.$$.fragment,e),Mn=s(e),X=r(e,"DIV",{class:!0});var pn=U(X);h(dt.$$.fragment,pn),ii=s(pn),ln=r(pn,"P",{"data-svelte-h":!0}),c(ln)!=="svelte-7y8zei"&&(ln.textContent=Oi),si=s(pn),O=r(pn,"DIV",{class:!0});var fn=U(O);h(pt.$$.fragment,fn),ai=s(fn),dn=r(fn,"P",{"data-svelte-h":!0}),c(dn)!=="svelte-5nfhmh"&&(dn.textContent=Ki),ri=s(fn),h(Pe.$$.fragment,fn),fn.forEach(p),pn.forEach(p),Tn=s(e),h(ft.$$.fragment,e),Un=s(e),cn=r(e,"P",{}),U(cn).forEach(p),this.h()},h(){Z(o,"name","hf:doc:metadata"),Z(o,"content",$s),Z(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){n(document.head,o),v(e,w,f),v(e,d,f),v(e,l,f),g(m,e,f),v(e,t,f),v(e,M,f),v(e,Q,f),v(e,De,f),v(e,un,f),g(ie,e,f),v(e,hn,f),v(e,Je,f),v(e,gn,f),v(e,Ge,f),v(e,bn,f),g(Ie,e,f),v(e,_n,f),v(e,x,f),g(We,x,null),n(x,In),n(x,yt),n(x,Wn),n(x,vt),n(x,Hn),n(x,xt),n(x,Fn),n(x,wt),n(x,Bn),n(x,$t),n(x,Sn),n(x,se),g(He,se,null),n(se,Nn),n(se,Mt),n(x,Vn),n(x,Tt),g(Fe,Tt,null),n(x,Ln),n(x,W),g(Be,W,null),n(W,Xn),n(W,Ut),n(W,Rn),g(ae,W,null),n(W,En),n(W,Zt),n(W,zn),n(W,jt),n(x,Yn),n(x,B),g(Se,B,null),n(B,Qn),n(B,kt),n(B,qn),n(B,Pt),n(B,An),g(re,B,null),n(x,On),n(x,le),g(Ne,le,null),n(le,Kn),n(le,Ct),n(x,eo),n(x,de),g(Ve,de,null),n(de,to),n(de,Dt),n(x,no),n(x,q),g(Le,q,null),n(q,oo),n(q,Jt),n(q,io),g(pe,q,null),n(x,so),n(x,S),g(Xe,S,null),n(S,ao),n(S,Gt),n(S,ro),g(fe,S,null),n(S,lo),g(ce,S,null),n(x,po),n(x,me),g(Re,me,null),n(me,fo),n(me,It),n(x,co),n(x,ue),g(Ee,ue,null),n(ue,mo),n(ue,Wt),n(x,uo),n(x,N),g(ze,N,null),n(N,ho),n(N,Ht),n(N,go),g(he,N,null),n(N,bo),g(ge,N,null),n(x,_o),n(x,A),g(Ye,A,null),n(A,yo),n(A,Ft),n(A,vo),g(be,A,null),n(x,xo),n(x,D),g(Qe,D,null),n(D,wo),n(D,Bt),n(D,$o),n(D,St),n(D,Mo),g(_e,D,null),n(D,To),g(ye,D,null),n(D,Uo),g(ve,D,null),n(x,Zo),n(x,V),g(qe,V,null),n(V,jo),n(V,Nt),n(V,ko),n(V,Vt),n(V,Po),n(V,Lt),n(x,Co),n(x,xe),g(Ae,xe,null),n(xe,Do),n(xe,Xt),n(x,Jo),n(x,we),g(Oe,we,null),n(we,Go),n(we,Rt),n(x,Io),n(x,$e),g(Ke,$e,null),n($e,Wo),n($e,Et),n(x,Ho),n(x,Me),g(et,Me,null),n(Me,Fo),n(Me,zt),v(e,yn,f),v(e,H,f),g(tt,H,null),n(H,Bo),n(H,Yt),n(H,So),n(H,Qt),n(H,No),n(H,qt),v(e,vn,f),v(e,K,f),g(nt,K,null),n(K,Vo),n(K,At),v(e,xn,f),g(ot,e,f),v(e,wn,f),v(e,k,f),g(it,k,null),n(k,Lo),n(k,Ot),n(k,Xo),n(k,Kt),n(k,Ro),n(k,en),n(k,Eo),n(k,tn),n(k,zo),n(k,nn),n(k,Yo),n(k,J),g(st,J,null),n(J,Qo),n(J,on),n(J,qo),n(J,sn),n(J,Ao),g(Te,J,null),n(J,Oo),g(Ue,J,null),n(J,Ko),g(Ze,J,null),n(k,ei),n(k,je),g(at,je,null),n(je,ti),n(je,an),n(k,ni),n(k,ke),g(rt,ke,null),n(ke,oi),n(ke,rn),v(e,$n,f),g(lt,e,f),v(e,Mn,f),v(e,X,f),g(dt,X,null),n(X,ii),n(X,ln),n(X,si),n(X,O),g(pt,O,null),n(O,ai),n(O,dn),n(O,ri),g(Pe,O,null),v(e,Tn,f),g(ft,e,f),v(e,Un,f),v(e,cn,f),Zn=!0},p(e,[f]){const $={};f&2&&($.$$scope={dirty:f,ctx:e}),ie.$set($);const ct={};f&2&&(ct.$$scope={dirty:f,ctx:e}),ae.$set(ct);const mn={};f&2&&(mn.$$scope={dirty:f,ctx:e}),re.$set(mn);const F={};f&2&&(F.$$scope={dirty:f,ctx:e}),pe.$set(F);const R={};f&2&&(R.$$scope={dirty:f,ctx:e}),fe.$set(R);const mt={};f&2&&(mt.$$scope={dirty:f,ctx:e}),ce.$set(mt);const ut={};f&2&&(ut.$$scope={dirty:f,ctx:e}),he.$set(ut);const ee={};f&2&&(ee.$$scope={dirty:f,ctx:e}),ge.$set(ee);const E={};f&2&&(E.$$scope={dirty:f,ctx:e}),be.$set(E);const ht={};f&2&&(ht.$$scope={dirty:f,ctx:e}),_e.$set(ht);const gt={};f&2&&(gt.$$scope={dirty:f,ctx:e}),ye.$set(gt);const z={};f&2&&(z.$$scope={dirty:f,ctx:e}),ve.$set(z);const te={};f&2&&(te.$$scope={dirty:f,ctx:e}),Te.$set(te);const I={};f&2&&(I.$$scope={dirty:f,ctx:e}),Ue.$set(I);const Y={};f&2&&(Y.$$scope={dirty:f,ctx:e}),Ze.$set(Y);const bt={};f&2&&(bt.$$scope={dirty:f,ctx:e}),Pe.$set(bt)},i(e){Zn||(b(m.$$.fragment,e),b(ie.$$.fragment,e),b(Ie.$$.fragment,e),b(We.$$.fragment,e),b(He.$$.fragment,e),b(Fe.$$.fragment,e),b(Be.$$.fragment,e),b(ae.$$.fragment,e),b(Se.$$.fragment,e),b(re.$$.fragment,e),b(Ne.$$.fragment,e),b(Ve.$$.fragment,e),b(Le.$$.fragment,e),b(pe.$$.fragment,e),b(Xe.$$.fragment,e),b(fe.$$.fragment,e),b(ce.$$.fragment,e),b(Re.$$.fragment,e),b(Ee.$$.fragment,e),b(ze.$$.fragment,e),b(he.$$.fragment,e),b(ge.$$.fragment,e),b(Ye.$$.fragment,e),b(be.$$.fragment,e),b(Qe.$$.fragment,e),b(_e.$$.fragment,e),b(ye.$$.fragment,e),b(ve.$$.fragment,e),b(qe.$$.fragment,e),b(Ae.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(nt.$$.fragment,e),b(ot.$$.fragment,e),b(it.$$.fragment,e),b(st.$$.fragment,e),b(Te.$$.fragment,e),b(Ue.$$.fragment,e),b(Ze.$$.fragment,e),b(at.$$.fragment,e),b(rt.$$.fragment,e),b(lt.$$.fragment,e),b(dt.$$.fragment,e),b(pt.$$.fragment,e),b(Pe.$$.fragment,e),b(ft.$$.fragment,e),Zn=!0)},o(e){_(m.$$.fragment,e),_(ie.$$.fragment,e),_(Ie.$$.fragment,e),_(We.$$.fragment,e),_(He.$$.fragment,e),_(Fe.$$.fragment,e),_(Be.$$.fragment,e),_(ae.$$.fragment,e),_(Se.$$.fragment,e),_(re.$$.fragment,e),_(Ne.$$.fragment,e),_(Ve.$$.fragment,e),_(Le.$$.fragment,e),_(pe.$$.fragment,e),_(Xe.$$.fragment,e),_(fe.$$.fragment,e),_(ce.$$.fragment,e),_(Re.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(Ye.$$.fragment,e),_(be.$$.fragment,e),_(Qe.$$.fragment,e),_(_e.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(qe.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(nt.$$.fragment,e),_(ot.$$.fragment,e),_(it.$$.fragment,e),_(st.$$.fragment,e),_(Te.$$.fragment,e),_(Ue.$$.fragment,e),_(Ze.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(pt.$$.fragment,e),_(Pe.$$.fragment,e),_(ft.$$.fragment,e),Zn=!1},d(e){e&&(p(w),p(d),p(l),p(t),p(M),p(Q),p(De),p(un),p(hn),p(Je),p(gn),p(Ge),p(bn),p(_n),p(x),p(yn),p(H),p(vn),p(K),p(xn),p(wn),p(k),p($n),p(Mn),p(X),p(Tn),p(Un),p(cn)),p(o),y(m,e),y(ie,e),y(Ie,e),y(We),y(He),y(Fe),y(Be),y(ae),y(Se),y(re),y(Ne),y(Ve),y(Le),y(pe),y(Xe),y(fe),y(ce),y(Re),y(Ee),y(ze),y(he),y(ge),y(Ye),y(be),y(Qe),y(_e),y(ye),y(ve),y(qe),y(Ae),y(Oe),y(Ke),y(et),y(tt),y(nt),y(ot,e),y(it),y(st),y(Te),y(Ue),y(Ze),y(at),y(rt),y(lt,e),y(dt),y(pt),y(Pe),y(ft,e)}}}const $s='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"FlaxDiffusionPipeline","local":"diffusers.FlaxDiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function Ms(T){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends ns{constructor(o){super(),os(this,o,Ms,ws,es,{})}}export{Ds as component};
