import{s as mt,n as rt,o as pt}from"../chunks/scheduler.6062bdaf.js";import{S as ct,i as Mt,g as i,s as a,r as m,A as dt,h as o,f as l,c as s,j as it,u as r,x as p,k as ot,y as ut,a as n,v as c,d as M,t as d,w as u}from"../chunks/index.4bca734e.js";import{C as f}from"../chunks/CodeBlock.cbbddafc.js";import{H as h,E as yt}from"../chunks/getInferenceSnippets.855730f4.js";function ht(_e){let y,le,ee,ne,b,ae,U,Fe="This quick tour is intended for developers who are ready to dive into the code and see examples of how to integrate 🤗 Optimum into their model training and inference workflows.",se,T,ie,g,oe,J,Ee=`To load a model and run inference with OpenVINO Runtime, you can just replace your <code>AutoModelForXxx</code> class with the corresponding <code>OVModelForXxx</code> class.
If you want to load a PyTorch checkpoint, set <code>export=True</code> to convert your model to the OpenVINO IR (Intermediate Representation).`,me,w,re,j,ze='You can find more examples in the <a href="https://huggingface.co/docs/optimum/intel/inference" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-intel/tree/main/examples/openvino" rel="nofollow">examples</a>.',pe,Z,ce,W,Ye="To accelerate inference with ONNX Runtime, 🤗 Optimum uses <em>configuration objects</em> to define parameters for graph optimization and quantization. These objects are then used to instantiate dedicated <em>optimizers</em> and <em>quantizers</em>.",Me,C,Se='Before applying quantization or optimization, first we need to load our model. To load a model and run inference with ONNX Runtime, you can just replace the canonical Transformers <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoModel" rel="nofollow"><code>AutoModelForXxx</code></a> class with the corresponding <a href="https://huggingface.co/docs/optimum/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel" rel="nofollow"><code>ORTModelForXxx</code></a> class. If you want to load from a PyTorch checkpoint, set <code>export=True</code> to export your model to the ONNX format.',de,B,ue,I,Ae="Let’s see now how we can apply dynamic quantization with ONNX Runtime:",ye,R,he,X,qe="In this example, we’ve quantized a model from the Hugging Face Hub, in the same manner we can quantize a model hosted locally by providing the path to the directory containing the model weights. The result from applying the <code>quantize()</code> method is a <code>model_quantized.onnx</code> file that can be used to run inference. Here’s an example of how to load an ONNX Runtime model and generate predictions with it:",fe,x,be,$,Oe='You can find more examples in the <a href="https://huggingface.co/docs/optimum/onnxruntime/quickstart" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum/tree/main/examples/onnxruntime" rel="nofollow">examples</a>.',Ue,v,Te,V,ge,k,Le='To train transformers on Habana’s Gaudi processors, 🤗 Optimum provides a <code>GaudiTrainer</code> that is very similar to the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a>. Here is a simple example:',Je,G,we,H,Pe='You can find more examples in the <a href="https://huggingface.co/docs/optimum/habana/quickstart" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">examples</a>.',je,N,Ze,Q,De='To train transformers with ONNX Runtime’s acceleration features, 🤗 Optimum provides a <code>ORTTrainer</code> that is very similar to the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a>. Here is a simple example:',We,_,Ce,F,Ke='You can find more examples in the <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/trainer" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum/tree/main/examples/onnxruntime/training" rel="nofollow">examples</a>.',Be,E,Ie,z,et="The Optimum library handles out of the box the ONNX export of Transformers and Diffusers models!",Re,Y,tt="Exporting a model to ONNX is as simple as",Xe,S,xe,A,lt="Check out the help for more options:",$e,q,ve,O,nt='Check out the <a href="https://huggingface.co/docs/optimum/exporters/onnx/usage_guides/export_a_model" rel="nofollow">documentation</a> for more.',Ve,L,ke,P,at='Optimum integrates with <code>torch.fx</code>, providing as a one-liner several graph transformations. We aim at supporting a better management of <a href="https://huggingface.co/docs/optimum/concept_guides/quantization" rel="nofollow">quantization</a> through <code>torch.fx</code>, both for quantization-aware training (QAT) and post-training quantization (PTQ).',Ge,D,st='Check out the <a href="https://huggingface.co/docs/optimum/torch_fx/usage_guides/optimization" rel="nofollow">documentation</a> and <a href="https://huggingface.co/docs/optimum/torch_fx/package_reference/optimization" rel="nofollow">reference</a> for more!',He,K,Ne,te,Qe;return b=new h({props:{title:"Quick tour",local:"quick-tour",headingTag:"h1"}}),T=new h({props:{title:"Accelerated inference",local:"accelerated-inference",headingTag:"h2"}}),g=new h({props:{title:"OpenVINO",local:"openvino",headingTag:"h4"}}),w=new f({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0uaW50ZWwub3BlbnZpbm8lMjBpbXBvcnQlMjBPVk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwcGlwZWxpbmUlMEElMEElMjAlMjAlMjMlMjBEb3dubG9hZCUyMGElMjB0b2tlbml6ZXIlMjBhbmQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMjBhbmQlMjBjb252ZXJ0JTIwdG8lMjBPcGVuVklOTyUyMGZvcm1hdCUwQSUyMCUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyMCUyMG1vZGVsX2lkJTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMkIlMjBtb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIwJTIwJTIzJTIwUnVuJTIwaW5mZXJlbmNlISUwQSUyMCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMjAlMjByZXN1bHRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJIZSdzJTIwYSUyMGRyZWFkZnVsJTIwbWFnaWNpYW4uJTIyKQ==",highlighted:`<span class="hljs-deletion">- from transformers import AutoModelForSequenceClassification</span>
<span class="hljs-addition">+ from optimum.intel.openvino import OVModelForSequenceClassification</span>
  from transformers import AutoTokenizer, pipeline

  # Download a tokenizer and model from the Hub and convert to OpenVINO format
  tokenizer = AutoTokenizer.from_pretrained(model_id)
  model_id = &quot;distilbert-base-uncased-finetuned-sst-2-english&quot;
<span class="hljs-deletion">- model = AutoModelForSequenceClassification.from_pretrained(model_id)</span>
<span class="hljs-addition">+ model = OVModelForSequenceClassification.from_pretrained(model_id, export=True)</span>

  # Run inference!
  classifier = pipeline(&quot;text-classification&quot;, model=model, tokenizer=tokenizer)
  results = classifier(&quot;He&#x27;s a dreadful magician.&quot;)`,wrap:!1}}),Z=new h({props:{title:"ONNX Runtime",local:"onnx-runtime",headingTag:"h4"}}),B=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIydG1wJTJGb25ueCUyRiUyMiUwQSUwQSUyMyUyMExvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyME9OTlglMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIzJTIwU2F2ZSUyMHRoZSUyME9OTlglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW9ydF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;tmp/onnx/&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a model from transformers and export it to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(model_checkpoint, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the ONNX model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(save_directory)`,wrap:!1}}),R=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFF1YW50aXplciUwQSUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHF1YW50aXphdGlvbiUyMG1ldGhvZG9sb2d5JTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNERmFsc2UlMkMlMjBwZXJfY2hhbm5lbCUzREZhbHNlKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob3J0X21vZGVsKSUwQSUwQSUyMyUyMEFwcGx5JTIwZHluYW1pYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the quantization methodology</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_directory, quantization_config=qconfig)`,wrap:!1}}),x=new f({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5JTJDJTIwZmlsZV9uYW1lJTNEJTIybW9kZWxfcXVhbnRpemVkLm9ubnglMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXJlc3VsdHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkklMjBsb3ZlJTIwYnVycml0b3MhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_directory, file_name=<span class="hljs-string">&quot;model_quantized.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>results = classifier(<span class="hljs-string">&quot;I love burritos!&quot;</span>)`,wrap:!1}}),v=new h({props:{title:"Accelerated training",local:"accelerated-training",headingTag:"h2"}}),V=new h({props:{title:"Habana",local:"habana",headingTag:"h4"}}),G=new f({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMkMlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIwJTIwJTIzJTIwRG93bmxvYWQlMjBhJTIwcHJldHJhaW5lZCUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEh1YiUwQSUyMCUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWHh4LmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjAlMjAlMjMlMjBEZWZpbmUlMjB0aGUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUwQS0lMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTJCJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMEdhdWRpVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnBhdGglMkZ0byUyRnNhdmUlMkZmb2xkZXIlMkYlMjIlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjB1c2VfaGFiYW5hJTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMHVzZV9sYXp5X21vZGUlM0RUcnVlJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwZ2F1ZGlfY29uZmlnX25hbWUlM0QlMjJIYWJhbmElMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwdHJhaW5lciUwQS0lMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMkIlMjB0cmFpbmVyJTIwJTNEJTIwR2F1ZGlUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwKSUwQSUwQSUyMCUyMCUyMyUyMFVzZSUyMEhhYmFuYSUyMEdhdWRpJTIwcHJvY2Vzc29yJTIwZm9yJTIwdHJhaW5pbmchJTBBJTIwJTIwdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.habana import GaudiTrainer, GaudiTrainingArguments</span>

  # Download a pretrained model from the Hub
  model = AutoModelForXxx.from_pretrained(&quot;bert-base-uncased&quot;)

  # Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = GaudiTrainingArguments(</span>
      output_dir=&quot;path/to/save/folder/&quot;,
<span class="hljs-addition">+     use_habana=True,</span>
<span class="hljs-addition">+     use_lazy_mode=True,</span>
<span class="hljs-addition">+     gaudi_config_name=&quot;Habana/bert-base-uncased&quot;,</span>
      ...
  )

  # Initialize the trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = GaudiTrainer(</span>
      model=model,
      args=training_args,
      train_dataset=train_dataset,
      ...
  )

  # Use Habana Gaudi processor for training!
  trainer.train()`,wrap:!1}}),N=new h({props:{title:"ONNX Runtime",local:"onnx-runtime",headingTag:"h4"}}),_=new f({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFRyYWluZXIlMkMlMjBPUlRUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQSUyMCUyMCUyMyUyMERvd25sb2FkJTIwYSUyMHByZXRyYWluZWQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEElMjAlMjBtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMCUyMCUyMyUyMERlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwYXJndW1lbnRzJTBBLSUyMHRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMkIlMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwT1JUVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnBhdGglMkZ0byUyRnNhdmUlMkZmb2xkZXIlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvcHRpbSUzRCUyMmFkYW13X29ydF9mdXNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBDcmVhdGUlMjBhJTIwT05OWCUyMFJ1bnRpbWUlMjBUcmFpbmVyJTBBLSUyMHRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyQiUyMHRyYWluZXIlMjAlM0QlMjBPUlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwZmVhdHVyZSUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjMlMjBUaGUlMjBtb2RlbCUyMHR5cGUlMjB0byUyMGV4cG9ydCUyMHRvJTIwT05OWCUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBVc2UlMjBPTk5YJTIwUnVudGltZSUyMGZvciUyMHRyYWluaW5nISUwQSUyMCUyMHRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.onnxruntime import ORTTrainer, ORTTrainingArguments</span>

  # Download a pretrained model from the Hub
  model = AutoModelForSequenceClassification.from_pretrained(&quot;bert-base-uncased&quot;)

  # Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = ORTTrainingArguments(</span>
      output_dir=&quot;path/to/save/folder/&quot;,
      optim=&quot;adamw_ort_fused&quot;,
      ...
  )

  # Create a ONNX Runtime Trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = ORTTrainer(</span>
      model=model,
      args=training_args,
      train_dataset=train_dataset,
<span class="hljs-addition">+     feature=&quot;text-classification&quot;, # The model type to export to ONNX</span>
      ...
  )

  # Use ONNX Runtime for training!
  trainer.train()`,wrap:!1}}),E=new h({props:{title:"Out of the box ONNX export",local:"out-of-the-box-onnx-export",headingTag:"h2"}}),S=new f({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1tb2RlbCUyMGdwdDIlMjBncHQyX29ubnglMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> onnx --model gpt2 gpt2_onnx/',wrap:!1}}),q=new f({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1oZWxw",highlighted:'optimum-cli <span class="hljs-built_in">export</span> onnx --<span class="hljs-built_in">help</span>',wrap:!1}}),L=new h({props:{title:"torch.fx integration",local:"torchfx-integration",headingTag:"h2"}}),K=new yt({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/quicktour.mdx"}}),{c(){y=i("meta"),le=a(),ee=i("p"),ne=a(),m(b.$$.fragment),ae=a(),U=i("p"),U.textContent=Fe,se=a(),m(T.$$.fragment),ie=a(),m(g.$$.fragment),oe=a(),J=i("p"),J.innerHTML=Ee,me=a(),m(w.$$.fragment),re=a(),j=i("p"),j.innerHTML=ze,pe=a(),m(Z.$$.fragment),ce=a(),W=i("p"),W.innerHTML=Ye,Me=a(),C=i("p"),C.innerHTML=Se,de=a(),m(B.$$.fragment),ue=a(),I=i("p"),I.textContent=Ae,ye=a(),m(R.$$.fragment),he=a(),X=i("p"),X.innerHTML=qe,fe=a(),m(x.$$.fragment),be=a(),$=i("p"),$.innerHTML=Oe,Ue=a(),m(v.$$.fragment),Te=a(),m(V.$$.fragment),ge=a(),k=i("p"),k.innerHTML=Le,Je=a(),m(G.$$.fragment),we=a(),H=i("p"),H.innerHTML=Pe,je=a(),m(N.$$.fragment),Ze=a(),Q=i("p"),Q.innerHTML=De,We=a(),m(_.$$.fragment),Ce=a(),F=i("p"),F.innerHTML=Ke,Be=a(),m(E.$$.fragment),Ie=a(),z=i("p"),z.textContent=et,Re=a(),Y=i("p"),Y.textContent=tt,Xe=a(),m(S.$$.fragment),xe=a(),A=i("p"),A.textContent=lt,$e=a(),m(q.$$.fragment),ve=a(),O=i("p"),O.innerHTML=nt,Ve=a(),m(L.$$.fragment),ke=a(),P=i("p"),P.innerHTML=at,Ge=a(),D=i("p"),D.innerHTML=st,He=a(),m(K.$$.fragment),Ne=a(),te=i("p"),this.h()},l(e){const t=dt("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),le=s(e),ee=o(e,"P",{}),it(ee).forEach(l),ne=s(e),r(b.$$.fragment,e),ae=s(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-3d25f3"&&(U.textContent=Fe),se=s(e),r(T.$$.fragment,e),ie=s(e),r(g.$$.fragment,e),oe=s(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-6jviwr"&&(J.innerHTML=Ee),me=s(e),r(w.$$.fragment,e),re=s(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1tmum2f"&&(j.innerHTML=ze),pe=s(e),r(Z.$$.fragment,e),ce=s(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-bjfa3x"&&(W.innerHTML=Ye),Me=s(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-a1kook"&&(C.innerHTML=Se),de=s(e),r(B.$$.fragment,e),ue=s(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-e7rpqh"&&(I.textContent=Ae),ye=s(e),r(R.$$.fragment,e),he=s(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-eh7tzg"&&(X.innerHTML=qe),fe=s(e),r(x.$$.fragment,e),be=s(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-19cbrlu"&&($.innerHTML=Oe),Ue=s(e),r(v.$$.fragment,e),Te=s(e),r(V.$$.fragment,e),ge=s(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-8h57ng"&&(k.innerHTML=Le),Je=s(e),r(G.$$.fragment,e),we=s(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-nvdwz8"&&(H.innerHTML=Pe),je=s(e),r(N.$$.fragment,e),Ze=s(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1q2r63q"&&(Q.innerHTML=De),We=s(e),r(_.$$.fragment,e),Ce=s(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-sgbmo9"&&(F.innerHTML=Ke),Be=s(e),r(E.$$.fragment,e),Ie=s(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1qcigt9"&&(z.textContent=et),Re=s(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1oa09xy"&&(Y.textContent=tt),Xe=s(e),r(S.$$.fragment,e),xe=s(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-b35baa"&&(A.textContent=lt),$e=s(e),r(q.$$.fragment,e),ve=s(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-q4y2mt"&&(O.innerHTML=nt),Ve=s(e),r(L.$$.fragment,e),ke=s(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1psut32"&&(P.innerHTML=at),Ge=s(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-p7b5of"&&(D.innerHTML=st),He=s(e),r(K.$$.fragment,e),Ne=s(e),te=o(e,"P",{}),it(te).forEach(l),this.h()},h(){ot(y,"name","hf:doc:metadata"),ot(y,"content",ft)},m(e,t){ut(document.head,y),n(e,le,t),n(e,ee,t),n(e,ne,t),c(b,e,t),n(e,ae,t),n(e,U,t),n(e,se,t),c(T,e,t),n(e,ie,t),c(g,e,t),n(e,oe,t),n(e,J,t),n(e,me,t),c(w,e,t),n(e,re,t),n(e,j,t),n(e,pe,t),c(Z,e,t),n(e,ce,t),n(e,W,t),n(e,Me,t),n(e,C,t),n(e,de,t),c(B,e,t),n(e,ue,t),n(e,I,t),n(e,ye,t),c(R,e,t),n(e,he,t),n(e,X,t),n(e,fe,t),c(x,e,t),n(e,be,t),n(e,$,t),n(e,Ue,t),c(v,e,t),n(e,Te,t),c(V,e,t),n(e,ge,t),n(e,k,t),n(e,Je,t),c(G,e,t),n(e,we,t),n(e,H,t),n(e,je,t),c(N,e,t),n(e,Ze,t),n(e,Q,t),n(e,We,t),c(_,e,t),n(e,Ce,t),n(e,F,t),n(e,Be,t),c(E,e,t),n(e,Ie,t),n(e,z,t),n(e,Re,t),n(e,Y,t),n(e,Xe,t),c(S,e,t),n(e,xe,t),n(e,A,t),n(e,$e,t),c(q,e,t),n(e,ve,t),n(e,O,t),n(e,Ve,t),c(L,e,t),n(e,ke,t),n(e,P,t),n(e,Ge,t),n(e,D,t),n(e,He,t),c(K,e,t),n(e,Ne,t),n(e,te,t),Qe=!0},p:rt,i(e){Qe||(M(b.$$.fragment,e),M(T.$$.fragment,e),M(g.$$.fragment,e),M(w.$$.fragment,e),M(Z.$$.fragment,e),M(B.$$.fragment,e),M(R.$$.fragment,e),M(x.$$.fragment,e),M(v.$$.fragment,e),M(V.$$.fragment,e),M(G.$$.fragment,e),M(N.$$.fragment,e),M(_.$$.fragment,e),M(E.$$.fragment,e),M(S.$$.fragment,e),M(q.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),Qe=!0)},o(e){d(b.$$.fragment,e),d(T.$$.fragment,e),d(g.$$.fragment,e),d(w.$$.fragment,e),d(Z.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(x.$$.fragment,e),d(v.$$.fragment,e),d(V.$$.fragment,e),d(G.$$.fragment,e),d(N.$$.fragment,e),d(_.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d(K.$$.fragment,e),Qe=!1},d(e){e&&(l(le),l(ee),l(ne),l(ae),l(U),l(se),l(ie),l(oe),l(J),l(me),l(re),l(j),l(pe),l(ce),l(W),l(Me),l(C),l(de),l(ue),l(I),l(ye),l(he),l(X),l(fe),l(be),l($),l(Ue),l(Te),l(ge),l(k),l(Je),l(we),l(H),l(je),l(Ze),l(Q),l(We),l(Ce),l(F),l(Be),l(Ie),l(z),l(Re),l(Y),l(Xe),l(xe),l(A),l($e),l(ve),l(O),l(Ve),l(ke),l(P),l(Ge),l(D),l(He),l(Ne),l(te)),l(y),u(b,e),u(T,e),u(g,e),u(w,e),u(Z,e),u(B,e),u(R,e),u(x,e),u(v,e),u(V,e),u(G,e),u(N,e),u(_,e),u(E,e),u(S,e),u(q,e),u(L,e),u(K,e)}}}const ft='{"title":"Quick tour","local":"quick-tour","sections":[{"title":"Accelerated inference","local":"accelerated-inference","sections":[{"title":"OpenVINO","local":"openvino","sections":[],"depth":4},{"title":"ONNX Runtime","local":"onnx-runtime","sections":[],"depth":4}],"depth":2},{"title":"Accelerated training","local":"accelerated-training","sections":[{"title":"Habana","local":"habana","sections":[],"depth":4},{"title":"ONNX Runtime","local":"onnx-runtime","sections":[],"depth":4}],"depth":2},{"title":"Out of the box ONNX export","local":"out-of-the-box-onnx-export","sections":[],"depth":2},{"title":"torch.fx integration","local":"torchfx-integration","sections":[],"depth":2}],"depth":1}';function bt(_e){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends ct{constructor(y){super(),Mt(this,y,bt,ht,mt,{})}}export{wt as component};
