import{s as ys,n as fs,o as Js}from"../chunks/scheduler.85c25b89.js";import{S as Ts,i as bs,g as a,s as o,u as m,A as vs,h as n,f as s,c as p,j as h,v as M,y as c,k as i,o as r,a as l,w as d,d as u,t as j,x as w}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Us(zt){let g,ct,lt,mt,y,v,at,k,Vt,q,Ft="Xception",Mt,I,Pt='<strong>Xception</strong> is a convolutional neural network architecture that relies solely on <a href="https://paperswithcode.com/method/depthwise-separable-convolution" rel="nofollow">depthwise separable convolution layers</a>.',dt,_,Lt='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',ut,f,U,nt,N,Rt,K,Dt="How do I use this model on an image?",jt,Z,qt="To load a pretrained model:",wt,E,gt,W,Kt="To load and preprocess the image:",yt,G,ft,B,Ot="To get the model predictions:",Jt,A,Tt,X,ts="To get the top-5 predictions class names:",bt,Q,vt,V,ss="Replace the model name with the variant you want to use, e.g. <code>xception</code>. You can find the IDs in the model summaries at the top of this page.",Ut,R,es='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ct,J,C,ot,S,St,O,ls="How do I finetune this model?",xt,Y,as="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",$t,H,kt,z,ns=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,It,T,x,pt,F,Yt,tt,os="How do I train this model?",_t,P,ps='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Nt,b,$,it,L,Ht,st,is="Citation",Zt,D,Et,rt,Wt;return k=new ht({}),N=new ht({}),E=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3hjZXB0aW9uJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;xception&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),G=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),A=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),S=new ht({}),H=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgneGNlcHRpb24nJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;xception&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new ht({}),L=new ht({}),D=new et({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZaYWdvcnV5a29LMTYlMkMlMEElNDBtaXNjJTdCY2hvbGxldDIwMTd4Y2VwdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCWGNlcHRpb24lM0ElMjBEZWVwJTIwTGVhcm5pbmclMjB3aXRoJTIwRGVwdGh3aXNlJTIwU2VwYXJhYmxlJTIwQ29udm9sdXRpb25zJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRnJhbiVDMyVBN29pcyUyMENob2xsZXQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE2MTAuMDIzNTclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="hljs-variable">@article</span>{<span class="hljs-variable constant_">DBLP</span><span class="hljs-symbol">:journals/corr/ZagoruykoK16</span>,
<span class="hljs-variable">@misc</span>{chollet2017xception,
      title={<span class="hljs-title class_">Xception</span>: <span class="hljs-title class_">Deep</span> <span class="hljs-title class_">Learning</span> with <span class="hljs-title class_">Depthwise</span> <span class="hljs-title class_">Separable</span> <span class="hljs-title class_">Convolutions</span>}, 
      author={<span class="hljs-title class_">Fran</span>çois <span class="hljs-title class_">Chollet</span>},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1610.02357</span>},
      archivePrefix={arXiv},
      primaryClass={cs.<span class="hljs-variable constant_">CV</span>}
}`}}),{c(){g=a("meta"),ct=o(),lt=a("p"),mt=o(),y=a("h1"),v=a("a"),at=a("span"),m(k.$$.fragment),Vt=o(),q=a("span"),q.textContent=Ft,Mt=o(),I=a("p"),I.innerHTML=Pt,dt=o(),_=a("p"),_.innerHTML=Lt,ut=o(),f=a("h2"),U=a("a"),nt=a("span"),m(N.$$.fragment),Rt=o(),K=a("span"),K.textContent=Dt,jt=o(),Z=a("p"),Z.textContent=qt,wt=o(),m(E.$$.fragment),gt=o(),W=a("p"),W.textContent=Kt,yt=o(),m(G.$$.fragment),ft=o(),B=a("p"),B.textContent=Ot,Jt=o(),m(A.$$.fragment),Tt=o(),X=a("p"),X.textContent=ts,bt=o(),m(Q.$$.fragment),vt=o(),V=a("p"),V.innerHTML=ss,Ut=o(),R=a("p"),R.innerHTML=es,Ct=o(),J=a("h2"),C=a("a"),ot=a("span"),m(S.$$.fragment),St=o(),O=a("span"),O.textContent=ls,xt=o(),Y=a("p"),Y.textContent=as,$t=o(),m(H.$$.fragment),kt=o(),z=a("p"),z.innerHTML=ns,It=o(),T=a("h2"),x=a("a"),pt=a("span"),m(F.$$.fragment),Yt=o(),tt=a("span"),tt.textContent=os,_t=o(),P=a("p"),P.innerHTML=ps,Nt=o(),b=a("h2"),$=a("a"),it=a("span"),m(L.$$.fragment),Ht=o(),st=a("span"),st.textContent=is,Zt=o(),m(D.$$.fragment),Et=o(),rt=a("p"),this.h()},l(t){const e=vs("svelte-1phssyn",document.head);g=n(e,"META",{name:!0,content:!0}),e.forEach(s),ct=p(t),lt=n(t,"P",{}),h(lt).forEach(s),mt=p(t),y=n(t,"H1",{class:!0});var Gt=h(y);v=n(Gt,"A",{id:!0,class:!0,href:!0});var rs=h(v);at=n(rs,"SPAN",{});var hs=h(at);M(k.$$.fragment,hs),hs.forEach(s),rs.forEach(s),Vt=p(Gt),q=n(Gt,"SPAN",{"data-svelte-h":!0}),c(q)!=="svelte-sujnjf"&&(q.textContent=Ft),Gt.forEach(s),Mt=p(t),I=n(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-s14d2h"&&(I.innerHTML=Pt),dt=p(t),_=n(t,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1nh6o5x"&&(_.innerHTML=Lt),ut=p(t),f=n(t,"H2",{class:!0});var Bt=h(f);U=n(Bt,"A",{id:!0,class:!0,href:!0});var cs=h(U);nt=n(cs,"SPAN",{});var ms=h(nt);M(N.$$.fragment,ms),ms.forEach(s),cs.forEach(s),Rt=p(Bt),K=n(Bt,"SPAN",{"data-svelte-h":!0}),c(K)!=="svelte-1c1hspn"&&(K.textContent=Dt),Bt.forEach(s),jt=p(t),Z=n(t,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-18ywhxh"&&(Z.textContent=qt),wt=p(t),M(E.$$.fragment,t),gt=p(t),W=n(t,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1c2ipa8"&&(W.textContent=Kt),yt=p(t),M(G.$$.fragment,t),ft=p(t),B=n(t,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1n9qsq1"&&(B.textContent=Ot),Jt=p(t),M(A.$$.fragment,t),Tt=p(t),X=n(t,"P",{"data-svelte-h":!0}),c(X)!=="svelte-19cnvx1"&&(X.textContent=ts),bt=p(t),M(Q.$$.fragment,t),vt=p(t),V=n(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-11ggpx2"&&(V.innerHTML=ss),Ut=p(t),R=n(t,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1wmi3ea"&&(R.innerHTML=es),Ct=p(t),J=n(t,"H2",{class:!0});var At=h(J);C=n(At,"A",{id:!0,class:!0,href:!0});var Ms=h(C);ot=n(Ms,"SPAN",{});var ds=h(ot);M(S.$$.fragment,ds),ds.forEach(s),Ms.forEach(s),St=p(At),O=n(At,"SPAN",{"data-svelte-h":!0}),c(O)!=="svelte-1viv4qv"&&(O.textContent=ls),At.forEach(s),xt=p(t),Y=n(t,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-9sr7nh"&&(Y.textContent=as),$t=p(t),M(H.$$.fragment,t),kt=p(t),z=n(t,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1kguc51"&&(z.innerHTML=ns),It=p(t),T=n(t,"H2",{class:!0});var Xt=h(T);x=n(Xt,"A",{id:!0,class:!0,href:!0});var us=h(x);pt=n(us,"SPAN",{});var js=h(pt);M(F.$$.fragment,js),js.forEach(s),us.forEach(s),Yt=p(Xt),tt=n(Xt,"SPAN",{"data-svelte-h":!0}),c(tt)!=="svelte-1ce591d"&&(tt.textContent=os),Xt.forEach(s),_t=p(t),P=n(t,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1n0coha"&&(P.innerHTML=ps),Nt=p(t),b=n(t,"H2",{class:!0});var Qt=h(b);$=n(Qt,"A",{id:!0,class:!0,href:!0});var ws=h($);it=n(ws,"SPAN",{});var gs=h(it);M(L.$$.fragment,gs),gs.forEach(s),ws.forEach(s),Ht=p(Qt),st=n(Qt,"SPAN",{"data-svelte-h":!0}),c(st)!=="svelte-15mb3gy"&&(st.textContent=is),Qt.forEach(s),Zt=p(t),M(D.$$.fragment,t),Et=p(t),rt=n(t,"P",{}),h(rt).forEach(s),this.h()},h(){i(g,"name","hf:doc:metadata"),i(g,"content",JSON.stringify(Cs)),i(v,"id","xception"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#xception"),i(y,"class","relative group"),i(U,"id","how-do-i-use-this-model-on-an-image"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#how-do-i-use-this-model-on-an-image"),i(f,"class","relative group"),i(C,"id","how-do-i-finetune-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-finetune-this-model"),i(J,"class","relative group"),i(x,"id","how-do-i-train-this-model"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#how-do-i-train-this-model"),i(T,"class","relative group"),i($,"id","citation"),i($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i($,"href","#citation"),i(b,"class","relative group")},m(t,e){r(document.head,g),l(t,ct,e),l(t,lt,e),l(t,mt,e),l(t,y,e),r(y,v),r(v,at),d(k,at,null),r(y,Vt),r(y,q),l(t,Mt,e),l(t,I,e),l(t,dt,e),l(t,_,e),l(t,ut,e),l(t,f,e),r(f,U),r(U,nt),d(N,nt,null),r(f,Rt),r(f,K),l(t,jt,e),l(t,Z,e),l(t,wt,e),d(E,t,e),l(t,gt,e),l(t,W,e),l(t,yt,e),d(G,t,e),l(t,ft,e),l(t,B,e),l(t,Jt,e),d(A,t,e),l(t,Tt,e),l(t,X,e),l(t,bt,e),d(Q,t,e),l(t,vt,e),l(t,V,e),l(t,Ut,e),l(t,R,e),l(t,Ct,e),l(t,J,e),r(J,C),r(C,ot),d(S,ot,null),r(J,St),r(J,O),l(t,xt,e),l(t,Y,e),l(t,$t,e),d(H,t,e),l(t,kt,e),l(t,z,e),l(t,It,e),l(t,T,e),r(T,x),r(x,pt),d(F,pt,null),r(T,Yt),r(T,tt),l(t,_t,e),l(t,P,e),l(t,Nt,e),l(t,b,e),r(b,$),r($,it),d(L,it,null),r(b,Ht),r(b,st),l(t,Zt,e),d(D,t,e),l(t,Et,e),l(t,rt,e),Wt=!0},p:fs,i(t){Wt||(u(k.$$.fragment,t),u(N.$$.fragment,t),u(E.$$.fragment,t),u(G.$$.fragment,t),u(A.$$.fragment,t),u(Q.$$.fragment,t),u(S.$$.fragment,t),u(H.$$.fragment,t),u(F.$$.fragment,t),u(L.$$.fragment,t),u(D.$$.fragment,t),Wt=!0)},o(t){j(k.$$.fragment,t),j(N.$$.fragment,t),j(E.$$.fragment,t),j(G.$$.fragment,t),j(A.$$.fragment,t),j(Q.$$.fragment,t),j(S.$$.fragment,t),j(H.$$.fragment,t),j(F.$$.fragment,t),j(L.$$.fragment,t),j(D.$$.fragment,t),Wt=!1},d(t){t&&(s(ct),s(lt),s(mt),s(y),s(Mt),s(I),s(dt),s(_),s(ut),s(f),s(jt),s(Z),s(wt),s(gt),s(W),s(yt),s(ft),s(B),s(Jt),s(Tt),s(X),s(bt),s(vt),s(V),s(Ut),s(R),s(Ct),s(J),s(xt),s(Y),s($t),s(kt),s(z),s(It),s(T),s(_t),s(P),s(Nt),s(b),s(Zt),s(Et),s(rt)),s(g),w(k),w(N),w(E,t),w(G,t),w(A,t),w(Q,t),w(S),w(H,t),w(F),w(L),w(D,t)}}}const Cs={local:"xception",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Xception"};function xs(zt){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends Ts{constructor(g){super(),bs(this,g,xs,Us,ys,{})}}export{Ns as component};
