import{s as ge,n as Te,o as je}from"../chunks/scheduler.85c25b89.js";import{S as fe,i as be,g as a,s as p,u as c,A as Ue,h as n,f as e,c as o,j as h,v as M,y as m,k as i,o as r,a as l,w as J,d as w,t as d,x as u}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function Ie(zt){let y,mt,lt,ct,g,U,at,Z,Qt,q,Ft="(Gluon) ResNet",Mt,x,Pt='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',Jt,E,Lt='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',wt,T,I,nt,N,Vt,K,Dt="How do I use this model on an image?",dt,A,qt="To load a pretrained model:",ut,$,yt,W,Kt="To load and preprocess the image:",gt,B,Tt,_,Ot="To get the model predictions:",jt,G,ft,R,te="To get the top-5 predictions class names:",bt,S,Ut,Q,ee="Replace the model name with the variant you want to use, e.g. <code>gluon_resnet101_v1b</code>. You can find the IDs in the model summaries at the top of this page.",It,V,se='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,j,v,pt,H,Ht,O,le="How do I finetune this model?",Ct,Y,ae="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",kt,X,Zt,z,ne=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,xt,f,C,ot,F,Yt,tt,pe="How do I train this model?",Et,P,oe='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Nt,b,k,it,L,Xt,et,ie="Citation",At,D,$t,rt,Wt;return Z=new ht({}),N=new ht({}),$=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3Jlc25ldDEwMV92MWInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnet101_v1b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),B=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),S=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),H=new ht({}),X=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25fcmVzbmV0MTAxX3YxYiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnet101_v1b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new ht({}),L=new ht({}),D=new st({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIZVpSUzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCS2FpbWluZyUyMEhlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWGlhbmd5dSUyMFpoYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2hhb3FpbmclMjBSZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBKaWFuJTIwU3VuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JEZWVwJTIwUmVzaWR1YWwlMjBMZWFybmluZyUyMGZvciUyMEltYWdlJTIwUmVjb2duaXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE1MTIuMDMzODUlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNSU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNTEyLjAzMzg1JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTUxMi4wMzM4NSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QldlZCUyQyUyMDE3JTIwQXByJTIwMjAxOSUyMDE3JTNBMjMlM0E0NSUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSGVaUlMxNS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HeZRS15,
  author    = {Kaiming He and
               Xiangyu Zhang and
               Shaoqing Ren and
               Jian Sun},
  title     = {Deep Residual Learning <span class="hljs-keyword">for</span> Image Recognition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.03385</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.03385</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.03385</span>},
  timestamp = {Wed, <span class="hljs-number">17</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">17</span>:<span class="hljs-number">23</span>:<span class="hljs-number">45</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HeZRS15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`}}),{c(){y=a("meta"),mt=p(),lt=a("p"),ct=p(),g=a("h1"),U=a("a"),at=a("span"),c(Z.$$.fragment),Qt=p(),q=a("span"),q.textContent=Ft,Mt=p(),x=a("p"),x.innerHTML=Pt,Jt=p(),E=a("p"),E.innerHTML=Lt,wt=p(),T=a("h2"),I=a("a"),nt=a("span"),c(N.$$.fragment),Vt=p(),K=a("span"),K.textContent=Dt,dt=p(),A=a("p"),A.textContent=qt,ut=p(),c($.$$.fragment),yt=p(),W=a("p"),W.textContent=Kt,gt=p(),c(B.$$.fragment),Tt=p(),_=a("p"),_.textContent=Ot,jt=p(),c(G.$$.fragment),ft=p(),R=a("p"),R.textContent=te,bt=p(),c(S.$$.fragment),Ut=p(),Q=a("p"),Q.innerHTML=ee,It=p(),V=a("p"),V.innerHTML=se,vt=p(),j=a("h2"),v=a("a"),pt=a("span"),c(H.$$.fragment),Ht=p(),O=a("span"),O.textContent=le,Ct=p(),Y=a("p"),Y.textContent=ae,kt=p(),c(X.$$.fragment),Zt=p(),z=a("p"),z.innerHTML=ne,xt=p(),f=a("h2"),C=a("a"),ot=a("span"),c(F.$$.fragment),Yt=p(),tt=a("span"),tt.textContent=pe,Et=p(),P=a("p"),P.innerHTML=oe,Nt=p(),b=a("h2"),k=a("a"),it=a("span"),c(L.$$.fragment),Xt=p(),et=a("span"),et.textContent=ie,At=p(),c(D.$$.fragment),$t=p(),rt=a("p"),this.h()},l(t){const s=Ue("svelte-1phssyn",document.head);y=n(s,"META",{name:!0,content:!0}),s.forEach(e),mt=o(t),lt=n(t,"P",{}),h(lt).forEach(e),ct=o(t),g=n(t,"H1",{class:!0});var Bt=h(g);U=n(Bt,"A",{id:!0,class:!0,href:!0});var re=h(U);at=n(re,"SPAN",{});var he=h(at);M(Z.$$.fragment,he),he.forEach(e),re.forEach(e),Qt=o(Bt),q=n(Bt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-c3mdsg"&&(q.textContent=Ft),Bt.forEach(e),Mt=o(t),x=n(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-p6ybkz"&&(x.innerHTML=Pt),Jt=o(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1vag5uc"&&(E.innerHTML=Lt),wt=o(t),T=n(t,"H2",{class:!0});var _t=h(T);I=n(_t,"A",{id:!0,class:!0,href:!0});var me=h(I);nt=n(me,"SPAN",{});var ce=h(nt);M(N.$$.fragment,ce),ce.forEach(e),me.forEach(e),Vt=o(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1c1hspn"&&(K.textContent=Dt),_t.forEach(e),dt=o(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-18ywhxh"&&(A.textContent=qt),ut=o(t),M($.$$.fragment,t),yt=o(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1c2ipa8"&&(W.textContent=Kt),gt=o(t),M(B.$$.fragment,t),Tt=o(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=Ot),jt=o(t),M(G.$$.fragment,t),ft=o(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-19cnvx1"&&(R.textContent=te),bt=o(t),M(S.$$.fragment,t),Ut=o(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-frqp5b"&&(Q.innerHTML=ee),It=o(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1wmi3ea"&&(V.innerHTML=se),vt=o(t),j=n(t,"H2",{class:!0});var Gt=h(j);v=n(Gt,"A",{id:!0,class:!0,href:!0});var Me=h(v);pt=n(Me,"SPAN",{});var Je=h(pt);M(H.$$.fragment,Je),Je.forEach(e),Me.forEach(e),Ht=o(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1viv4qv"&&(O.textContent=le),Gt.forEach(e),Ct=o(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ae),kt=o(t),M(X.$$.fragment,t),Zt=o(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1kguc51"&&(z.innerHTML=ne),xt=o(t),f=n(t,"H2",{class:!0});var Rt=h(f);C=n(Rt,"A",{id:!0,class:!0,href:!0});var we=h(C);ot=n(we,"SPAN",{});var de=h(ot);M(F.$$.fragment,de),de.forEach(e),we.forEach(e),Yt=o(Rt),tt=n(Rt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1ce591d"&&(tt.textContent=pe),Rt.forEach(e),Et=o(t),P=n(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1n0coha"&&(P.innerHTML=oe),Nt=o(t),b=n(t,"H2",{class:!0});var St=h(b);k=n(St,"A",{id:!0,class:!0,href:!0});var ue=h(k);it=n(ue,"SPAN",{});var ye=h(it);M(L.$$.fragment,ye),ye.forEach(e),ue.forEach(e),Xt=o(St),et=n(St,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-15mb3gy"&&(et.textContent=ie),St.forEach(e),At=o(t),M(D.$$.fragment,t),$t=o(t),rt=n(t,"P",{}),h(rt).forEach(e),this.h()},h(){i(y,"name","hf:doc:metadata"),i(y,"content",JSON.stringify(ve)),i(U,"id","gluon-resnet"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#gluon-resnet"),i(g,"class","relative group"),i(I,"id","how-do-i-use-this-model-on-an-image"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#how-do-i-use-this-model-on-an-image"),i(T,"class","relative group"),i(v,"id","how-do-i-finetune-this-model"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#how-do-i-finetune-this-model"),i(j,"class","relative group"),i(C,"id","how-do-i-train-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-train-this-model"),i(f,"class","relative group"),i(k,"id","citation"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#citation"),i(b,"class","relative group")},m(t,s){r(document.head,y),l(t,mt,s),l(t,lt,s),l(t,ct,s),l(t,g,s),r(g,U),r(U,at),J(Z,at,null),r(g,Qt),r(g,q),l(t,Mt,s),l(t,x,s),l(t,Jt,s),l(t,E,s),l(t,wt,s),l(t,T,s),r(T,I),r(I,nt),J(N,nt,null),r(T,Vt),r(T,K),l(t,dt,s),l(t,A,s),l(t,ut,s),J($,t,s),l(t,yt,s),l(t,W,s),l(t,gt,s),J(B,t,s),l(t,Tt,s),l(t,_,s),l(t,jt,s),J(G,t,s),l(t,ft,s),l(t,R,s),l(t,bt,s),J(S,t,s),l(t,Ut,s),l(t,Q,s),l(t,It,s),l(t,V,s),l(t,vt,s),l(t,j,s),r(j,v),r(v,pt),J(H,pt,null),r(j,Ht),r(j,O),l(t,Ct,s),l(t,Y,s),l(t,kt,s),J(X,t,s),l(t,Zt,s),l(t,z,s),l(t,xt,s),l(t,f,s),r(f,C),r(C,ot),J(F,ot,null),r(f,Yt),r(f,tt),l(t,Et,s),l(t,P,s),l(t,Nt,s),l(t,b,s),r(b,k),r(k,it),J(L,it,null),r(b,Xt),r(b,et),l(t,At,s),J(D,t,s),l(t,$t,s),l(t,rt,s),Wt=!0},p:Te,i(t){Wt||(w(Z.$$.fragment,t),w(N.$$.fragment,t),w($.$$.fragment,t),w(B.$$.fragment,t),w(G.$$.fragment,t),w(S.$$.fragment,t),w(H.$$.fragment,t),w(X.$$.fragment,t),w(F.$$.fragment,t),w(L.$$.fragment,t),w(D.$$.fragment,t),Wt=!0)},o(t){d(Z.$$.fragment,t),d(N.$$.fragment,t),d($.$$.fragment,t),d(B.$$.fragment,t),d(G.$$.fragment,t),d(S.$$.fragment,t),d(H.$$.fragment,t),d(X.$$.fragment,t),d(F.$$.fragment,t),d(L.$$.fragment,t),d(D.$$.fragment,t),Wt=!1},d(t){t&&(e(mt),e(lt),e(ct),e(g),e(Mt),e(x),e(Jt),e(E),e(wt),e(T),e(dt),e(A),e(ut),e(yt),e(W),e(gt),e(Tt),e(_),e(jt),e(ft),e(R),e(bt),e(Ut),e(Q),e(It),e(V),e(vt),e(j),e(Ct),e(Y),e(kt),e(Zt),e(z),e(xt),e(f),e(Et),e(P),e(Nt),e(b),e(At),e($t),e(rt)),e(y),u(Z),u(N),u($,t),u(B,t),u(G,t),u(S,t),u(H),u(X,t),u(F),u(L),u(D,t)}}}const ve={local:"gluon-resnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"(Gluon) ResNet"};function Ce(zt){return je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ne extends fe{constructor(y){super(),be(this,y,Ce,Ie,ge,{})}}export{Ne as component};
