import{s as Us,n as Is,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as ks,i as Ws,g as p,s as e,r as m,A as Zs,h as i,f as a,c as n,j as fs,u as o,x as M,k as bs,y as Cs,a as l,v as c,d as r,t as h,w as J}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.52fa569e.js";import{H as Y}from"../chunks/Heading.3097d2ed.js";function Ns(rs){let w,_,X,V,d,S,y,hs="<strong>Single-Path NAS</strong> is a novel differentiable NAS method for designing hardware-efficient ConvNets in less than 4 hours.",z,g,A,j,Js="To load a pretrained model:",H,T,F,u,Ms="To load and preprocess the image:",D,f,L,b,ws="To get the model predictions:",P,U,q,I,ds="To get the top-5 predictions class names:",K,$,O,k,ys="Replace the model name with the variant you want to use, e.g. <code>spnasnet_100</code>. You can find the IDs in the model summaries at the top of this page.",ss,W,gs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,Z,as,C,js="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ls,N,es,B,Ts=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,G,ps,x,us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',is,E,ms,v,os,Q,cs;return d=new Y({props:{title:"SPNASNet",local:"spnasnet",headingTag:"h1"}}),g=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NwbmFzbmV0XzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;spnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3BuYXNuZXRfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;spnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new R({props:{code:"JTQwbWlzYyU3QnN0YW1vdWxpczIwMTlzaW5nbGVwYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTaW5nbGUtUGF0aCUyME5BUyUzQSUyMERlc2lnbmluZyUyMEhhcmR3YXJlLUVmZmljaWVudCUyMENvbnZOZXRzJTIwaW4lMjBsZXNzJTIwdGhhbiUyMDQlMjBIb3VycyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkRpbWl0cmlvcyUyMFN0YW1vdWxpcyUyMGFuZCUyMFJ1aXpob3UlMjBEaW5nJTIwYW5kJTIwRGklMjBXYW5nJTIwYW5kJTIwRGltaXRyaW9zJTIwTHltYmVyb3BvdWxvcyUyMGFuZCUyMEJvZGhpJTIwUHJpeWFudGhhJTIwYW5kJTIwSmllJTIwTGl1JTIwYW5kJTIwRGlhbmElMjBNYXJjdWxlc2N1JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA0LjAyODc3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`@misc{stamoulis2019singlepath,
      title={Single-Path NAS: Designing Hardware-Efficient ConvNets in less than <span class="hljs-number">4</span> Hours}, 
      author={<span class="hljs-keyword">Dimitrios </span>Stamoulis <span class="hljs-keyword">and </span>Ruizhou <span class="hljs-keyword">Ding </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Di </span>Wang <span class="hljs-keyword">and </span><span class="hljs-keyword">Dimitrios </span>Lymberopoulos <span class="hljs-keyword">and </span><span class="hljs-keyword">Bodhi </span>Priyantha <span class="hljs-keyword">and </span><span class="hljs-keyword">Jie </span>Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Diana </span>Marculescu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">02877</span>},
      archivePrefix={arXiv},
      primaryClass={cs.LG}
}`,wrap:!1}}),{c(){w=p("meta"),_=e(),X=p("p"),V=e(),m(d.$$.fragment),S=e(),y=p("p"),y.innerHTML=hs,z=e(),m(g.$$.fragment),A=e(),j=p("p"),j.textContent=Js,H=e(),m(T.$$.fragment),F=e(),u=p("p"),u.textContent=Ms,D=e(),m(f.$$.fragment),L=e(),b=p("p"),b.textContent=ws,P=e(),m(U.$$.fragment),q=e(),I=p("p"),I.textContent=ds,K=e(),m($.$$.fragment),O=e(),k=p("p"),k.innerHTML=ys,ss=e(),W=p("p"),W.innerHTML=gs,ts=e(),m(Z.$$.fragment),as=e(),C=p("p"),C.textContent=js,ls=e(),m(N.$$.fragment),es=e(),B=p("p"),B.innerHTML=Ts,ns=e(),m(G.$$.fragment),ps=e(),x=p("p"),x.innerHTML=us,is=e(),m(E.$$.fragment),ms=e(),m(v.$$.fragment),os=e(),Q=p("p"),this.h()},l(s){const t=Zs("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(a),_=n(s),X=i(s,"P",{}),fs(X).forEach(a),V=n(s),o(d.$$.fragment,s),S=n(s),y=i(s,"P",{"data-svelte-h":!0}),M(y)!=="svelte-15s7q8i"&&(y.innerHTML=hs),z=n(s),o(g.$$.fragment,s),A=n(s),j=i(s,"P",{"data-svelte-h":!0}),M(j)!=="svelte-18ywhxh"&&(j.textContent=Js),H=n(s),o(T.$$.fragment,s),F=n(s),u=i(s,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1c2ipa8"&&(u.textContent=Ms),D=n(s),o(f.$$.fragment,s),L=n(s),b=i(s,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1n9qsq1"&&(b.textContent=ws),P=n(s),o(U.$$.fragment,s),q=n(s),I=i(s,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=ds),K=n(s),o($.$$.fragment,s),O=n(s),k=i(s,"P",{"data-svelte-h":!0}),M(k)!=="svelte-d1japu"&&(k.innerHTML=ys),ss=n(s),W=i(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1wmi3ea"&&(W.innerHTML=gs),ts=n(s),o(Z.$$.fragment,s),as=n(s),C=i(s,"P",{"data-svelte-h":!0}),M(C)!=="svelte-9sr7nh"&&(C.textContent=js),ls=n(s),o(N.$$.fragment,s),es=n(s),B=i(s,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1kguc51"&&(B.innerHTML=Ts),ns=n(s),o(G.$$.fragment,s),ps=n(s),x=i(s,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1n0coha"&&(x.innerHTML=us),is=n(s),o(E.$$.fragment,s),ms=n(s),o(v.$$.fragment,s),os=n(s),Q=i(s,"P",{}),fs(Q).forEach(a),this.h()},h(){bs(w,"name","hf:doc:metadata"),bs(w,"content",Bs)},m(s,t){Cs(document.head,w),l(s,_,t),l(s,X,t),l(s,V,t),c(d,s,t),l(s,S,t),l(s,y,t),l(s,z,t),c(g,s,t),l(s,A,t),l(s,j,t),l(s,H,t),c(T,s,t),l(s,F,t),l(s,u,t),l(s,D,t),c(f,s,t),l(s,L,t),l(s,b,t),l(s,P,t),c(U,s,t),l(s,q,t),l(s,I,t),l(s,K,t),c($,s,t),l(s,O,t),l(s,k,t),l(s,ss,t),l(s,W,t),l(s,ts,t),c(Z,s,t),l(s,as,t),l(s,C,t),l(s,ls,t),c(N,s,t),l(s,es,t),l(s,B,t),l(s,ns,t),c(G,s,t),l(s,ps,t),l(s,x,t),l(s,is,t),c(E,s,t),l(s,ms,t),c(v,s,t),l(s,os,t),l(s,Q,t),cs=!0},p:Is,i(s){cs||(r(d.$$.fragment,s),r(g.$$.fragment,s),r(T.$$.fragment,s),r(f.$$.fragment,s),r(U.$$.fragment,s),r($.$$.fragment,s),r(Z.$$.fragment,s),r(N.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(v.$$.fragment,s),cs=!0)},o(s){h(d.$$.fragment,s),h(g.$$.fragment,s),h(T.$$.fragment,s),h(f.$$.fragment,s),h(U.$$.fragment,s),h($.$$.fragment,s),h(Z.$$.fragment,s),h(N.$$.fragment,s),h(G.$$.fragment,s),h(E.$$.fragment,s),h(v.$$.fragment,s),cs=!1},d(s){s&&(a(_),a(X),a(V),a(S),a(y),a(z),a(A),a(j),a(H),a(F),a(u),a(D),a(L),a(b),a(P),a(q),a(I),a(K),a(O),a(k),a(ss),a(W),a(ts),a(as),a(C),a(ls),a(es),a(B),a(ns),a(ps),a(x),a(is),a(ms),a(os),a(Q)),a(w),J(d,s),J(g,s),J(T,s),J(f,s),J(U,s),J($,s),J(Z,s),J(N,s),J(G,s),J(E,s),J(v,s)}}}const Bs='{"title":"SPNASNet","local":"spnasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Gs(rs){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends ks{constructor(w){super(),Ws(this,w,Gs,Ns,Us,{})}}export{Xs as component};
