import{s as $t,n as kt,o as xt}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as Wt,g as p,s as a,r as i,A as Nt,h as m,f as e,c as n,j as Ct,u as o,x as r,k as It,y as Bt,a as l,v as c,d as h,t as M,w as d}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.52fa569e.js";import{H as v}from"../chunks/Heading.3097d2ed.js";function Gt(Mt){let y,S,Q,z,g,Y,w,dt='<strong>SE ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnext" rel="nofollow">ResNext</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',H,J,yt='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',F,j,A,u,gt="To load a pretrained model:",L,T,q,f,wt="To load and preprocess the image:",D,b,P,U,Jt="To get the model predictions:",K,C,O,I,jt="To get the top-5 predictions class names:",tt,$,st,k,ut="Replace the model name with the variant you want to use, e.g. <code>gluon_seresnext101_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",et,x,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,Z,at,W,ft="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,N,pt,B,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,G,it,E,Ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,X,rt,_,ct,R,ht;return g=new v({props:{title:"(Gluon) SE-ResNeXt",local:"gluon-se-resnext",headingTag:"h1"}}),j=new v({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3NlcmVzbmV4dDEwMV8zMng0ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_seresnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new v({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25fc2VyZXNuZXh0MTAxXzMyeDRkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_seresnext101_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new v({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),X=new v({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new V({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){y=p("meta"),S=a(),Q=p("p"),z=a(),i(g.$$.fragment),Y=a(),w=p("p"),w.innerHTML=dt,H=a(),J=p("p"),J.innerHTML=yt,F=a(),i(j.$$.fragment),A=a(),u=p("p"),u.textContent=gt,L=a(),i(T.$$.fragment),q=a(),f=p("p"),f.textContent=wt,D=a(),i(b.$$.fragment),P=a(),U=p("p"),U.textContent=Jt,K=a(),i(C.$$.fragment),O=a(),I=p("p"),I.textContent=jt,tt=a(),i($.$$.fragment),st=a(),k=p("p"),k.innerHTML=ut,et=a(),x=p("p"),x.innerHTML=Tt,lt=a(),i(Z.$$.fragment),at=a(),W=p("p"),W.textContent=ft,nt=a(),i(N.$$.fragment),pt=a(),B=p("p"),B.innerHTML=bt,mt=a(),i(G.$$.fragment),it=a(),E=p("p"),E.innerHTML=Ut,ot=a(),i(X.$$.fragment),rt=a(),i(_.$$.fragment),ct=a(),R=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(e),S=n(t),Q=m(t,"P",{}),Ct(Q).forEach(e),z=n(t),o(g.$$.fragment,t),Y=n(t),w=m(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-pmif4u"&&(w.innerHTML=dt),H=n(t),J=m(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1vag5uc"&&(J.innerHTML=yt),F=n(t),o(j.$$.fragment,t),A=n(t),u=m(t,"P",{"data-svelte-h":!0}),r(u)!=="svelte-18ywhxh"&&(u.textContent=gt),L=n(t),o(T.$$.fragment,t),q=n(t),f=m(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1c2ipa8"&&(f.textContent=wt),D=n(t),o(b.$$.fragment,t),P=n(t),U=m(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1n9qsq1"&&(U.textContent=Jt),K=n(t),o(C.$$.fragment,t),O=n(t),I=m(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-19cnvx1"&&(I.textContent=jt),tt=n(t),o($.$$.fragment,t),st=n(t),k=m(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1owfshn"&&(k.innerHTML=ut),et=n(t),x=m(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1wmi3ea"&&(x.innerHTML=Tt),lt=n(t),o(Z.$$.fragment,t),at=n(t),W=m(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-9sr7nh"&&(W.textContent=ft),nt=n(t),o(N.$$.fragment,t),pt=n(t),B=m(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1kguc51"&&(B.innerHTML=bt),mt=n(t),o(G.$$.fragment,t),it=n(t),E=m(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1n0coha"&&(E.innerHTML=Ut),ot=n(t),o(X.$$.fragment,t),rt=n(t),o(_.$$.fragment,t),ct=n(t),R=m(t,"P",{}),Ct(R).forEach(e),this.h()},h(){It(y,"name","hf:doc:metadata"),It(y,"content",Et)},m(t,s){Bt(document.head,y),l(t,S,s),l(t,Q,s),l(t,z,s),c(g,t,s),l(t,Y,s),l(t,w,s),l(t,H,s),l(t,J,s),l(t,F,s),c(j,t,s),l(t,A,s),l(t,u,s),l(t,L,s),c(T,t,s),l(t,q,s),l(t,f,s),l(t,D,s),c(b,t,s),l(t,P,s),l(t,U,s),l(t,K,s),c(C,t,s),l(t,O,s),l(t,I,s),l(t,tt,s),c($,t,s),l(t,st,s),l(t,k,s),l(t,et,s),l(t,x,s),l(t,lt,s),c(Z,t,s),l(t,at,s),l(t,W,s),l(t,nt,s),c(N,t,s),l(t,pt,s),l(t,B,s),l(t,mt,s),c(G,t,s),l(t,it,s),l(t,E,s),l(t,ot,s),c(X,t,s),l(t,rt,s),c(_,t,s),l(t,ct,s),l(t,R,s),ht=!0},p:kt,i(t){ht||(h(g.$$.fragment,t),h(j.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h(C.$$.fragment,t),h($.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(G.$$.fragment,t),h(X.$$.fragment,t),h(_.$$.fragment,t),ht=!0)},o(t){M(g.$$.fragment,t),M(j.$$.fragment,t),M(T.$$.fragment,t),M(b.$$.fragment,t),M(C.$$.fragment,t),M($.$$.fragment,t),M(Z.$$.fragment,t),M(N.$$.fragment,t),M(G.$$.fragment,t),M(X.$$.fragment,t),M(_.$$.fragment,t),ht=!1},d(t){t&&(e(S),e(Q),e(z),e(Y),e(w),e(H),e(J),e(F),e(A),e(u),e(L),e(q),e(f),e(D),e(P),e(U),e(K),e(O),e(I),e(tt),e(st),e(k),e(et),e(x),e(lt),e(at),e(W),e(nt),e(pt),e(B),e(mt),e(it),e(E),e(ot),e(rt),e(ct),e(R)),e(y),d(g,t),d(j,t),d(T,t),d(b,t),d(C,t),d($,t),d(Z,t),d(N,t),d(G,t),d(X,t),d(_,t)}}}const Et='{"title":"(Gluon) SE-ResNeXt","local":"gluon-se-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(Mt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends Zt{constructor(y){super(),Wt(this,y,Xt,Gt,$t,{})}}export{vt as component};
