import{s as ss,n as ts,o as es}from"../chunks/scheduler.f7e1785c.js";import{S as Ms,i as as,g as n,s as M,r as i,A as ns,h as p,f as t,c as a,j as ls,u as y,x as j,k as Zl,y as ps,a as e,v as o,d as u,t as c,w as m}from"../chunks/index.9f8f0838.js";import{C as U}from"../chunks/CodeBlock.b3510e34.js";import{H as js}from"../chunks/Heading.6643a2f7.js";function is(Bl){let J,P,L,O,r,K,T,El=`В этом курсе мы будем использовать библиотеку 🤗 Datasets для работы с наборами аудиоданных. 🤗 Datasets - это библиотека с открытым исходным кодом для
загрузки и подготовки наборов данных всех модальностей, включая аудио. Библиотека предоставляет легкий доступ к беспрецедентному
подборке наборов данных машинного обучения, публично доступных на Hugging Face Hub. Кроме того, 🤗 Datasets содержит множество
функций, предназначенных для работы с аудиоданными, которые упрощают работу с ними как для исследователей, так и для практиков.`,ll,w,Ql="Для начала работы с наборами аудиоданных необходимо убедиться, что у вас установлена библиотека 🤗 Datasets:",sl,h,tl,A,Wl=`Одной из ключевых особенностей 🤗 Datasets является возможность загрузки и подготовки набора данных всего одной строкой
Python-кода с помощью функции <code>load_dataset()</code>.`,el,C,ql=`Давайте загрузим и исследуем набор аудиоданных под названием <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, который содержит
записи людей, задающих вопросы системе дистанционного банковского обслуживания на нескольких языках и диалектах.`,Ml,b,_l=`Для загрузки набора данных MINDS-14 нам необходимо скопировать идентификатор набора данных на хабе (<code>PolyAI/minds14</code>) и передать его
в функцию <code>load_dataset</code>. Мы также укажем, что нас интересует только австралийское подмножество (<code>en-AU</code>)
данных, и ограничим его частью набора данных предназначенной для обучения:`,al,f,nl,I,xl="<strong>Output:</strong>",pl,g,jl,G,Rl=`Набор содержит 654 аудиофайла, каждый из которых сопровождается транскрипцией, переводом на английский язык и меткой,
указывающей на намерение человека, сделавшего запрос. В столбце audio содержатся необработанные аудиоданные. Рассмотрим подробнее
на одном из примеров:`,il,$,yl,k,Fl="<strong>Output:</strong>",ol,v,ul,Z,Yl="Вы  можете заметить, что столбец аудио содержит несколько параметров. Вот что они собой представляют:",cl,B,Hl="<li><code>path</code>: путь к аудиофайлу (в данном случае <code>*.wav</code>).</li> <li><code>array</code>: Декодированные аудиоданные, представленные в виде одномерного массива NumPy.</li> <li><code>sampling_rate</code>. Частота дискретизации аудиофайла (в данном примере 8 000 Гц).</li>",ml,E,Nl=`Класс <code>intent_class</code> - это классификационная категория аудиозаписи. Для преобразования этого числа в осмысленную строку
можно использовать метод <code>int2str()</code>:`,Ul,Q,Jl,W,Sl="<strong>Output:</strong>",dl,q,rl,_,Xl=`Если посмотреть на транскрипцию, то можно увидеть, что в аудиофайле действительно записан человек, задающий вопрос
об оплате счета.`,Tl,x,zl=`Если вы планируете обучать аудиоклассификатор на этом подмножестве данных, то, возможно, вам не обязательно понадобятся все признаки. Например,
<code>lang_id</code> будет иметь одно и то же значение для всех примеров и не будет полезен. Параметр <code>english_transcription</code>, скорее всего, будет
дублировать <code>transcription</code> в этом подмножестве, поэтому их можно смело удалить.`,wl,R,Vl="Удалить нерелевантные признаки можно с помощью метода 🤗 Datasets <code>remove_columns</code>:",hl,F,Al,Y,Ll="<strong>Output:</strong>",Cl,H,bl,N,Dl=`Теперь, когда мы загрузили и осмотрели необработанное содержимое набора данных, давайте прослушаем несколько примеров! Мы воспользуемся функциями <code>Blocks</code>
и <code>Audio</code> из <code>Gradio</code> для декодирования нескольких случайных образцов из набора данных:`,fl,S,Il,X,Pl="При желании можно также визуализировать некоторые примеры. Построим форму волны для первого примера.",gl,z,Gl,d,Ol='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',$l,V,Kl=`Попробуйте! Загрузите другой диалект или язык из набора данных MINDS-14, прослушайте и визуализируйте несколько примеров, чтобы получить представление
о вариативности всего набора данных. Полный список доступных языков можно найти <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">здесь</a>.`,kl,D,vl;return r=new js({props:{title:"Загрузка и изучение аудио набора данных",local:"загрузка-и-изучение-аудио-набора-данных",headingTag:"h1"}}),h=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),f=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),g=new U({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),$=new U({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),v=new U({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),Q=new U({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),q=new U({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),F=new U({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),H=new U({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),S=new U({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),z=new U({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),{c(){J=n("meta"),P=M(),L=n("p"),O=M(),i(r.$$.fragment),K=M(),T=n("p"),T.textContent=El,ll=M(),w=n("p"),w.textContent=Ql,sl=M(),i(h.$$.fragment),tl=M(),A=n("p"),A.innerHTML=Wl,el=M(),C=n("p"),C.innerHTML=ql,Ml=M(),b=n("p"),b.innerHTML=_l,al=M(),i(f.$$.fragment),nl=M(),I=n("p"),I.innerHTML=xl,pl=M(),i(g.$$.fragment),jl=M(),G=n("p"),G.textContent=Rl,il=M(),i($.$$.fragment),yl=M(),k=n("p"),k.innerHTML=Fl,ol=M(),i(v.$$.fragment),ul=M(),Z=n("p"),Z.textContent=Yl,cl=M(),B=n("ul"),B.innerHTML=Hl,ml=M(),E=n("p"),E.innerHTML=Nl,Ul=M(),i(Q.$$.fragment),Jl=M(),W=n("p"),W.innerHTML=Sl,dl=M(),i(q.$$.fragment),rl=M(),_=n("p"),_.textContent=Xl,Tl=M(),x=n("p"),x.innerHTML=zl,wl=M(),R=n("p"),R.innerHTML=Vl,hl=M(),i(F.$$.fragment),Al=M(),Y=n("p"),Y.innerHTML=Ll,Cl=M(),i(H.$$.fragment),bl=M(),N=n("p"),N.innerHTML=Dl,fl=M(),i(S.$$.fragment),Il=M(),X=n("p"),X.textContent=Pl,gl=M(),i(z.$$.fragment),Gl=M(),d=n("div"),d.innerHTML=Ol,$l=M(),V=n("p"),V.innerHTML=Kl,kl=M(),D=n("p"),this.h()},l(l){const s=ns("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(t),P=a(l),L=p(l,"P",{}),ls(L).forEach(t),O=a(l),y(r.$$.fragment,l),K=a(l),T=p(l,"P",{"data-svelte-h":!0}),j(T)!=="svelte-1407nk3"&&(T.textContent=El),ll=a(l),w=p(l,"P",{"data-svelte-h":!0}),j(w)!=="svelte-jvig6b"&&(w.textContent=Ql),sl=a(l),y(h.$$.fragment,l),tl=a(l),A=p(l,"P",{"data-svelte-h":!0}),j(A)!=="svelte-19l0nc5"&&(A.innerHTML=Wl),el=a(l),C=p(l,"P",{"data-svelte-h":!0}),j(C)!=="svelte-y6lghn"&&(C.innerHTML=ql),Ml=a(l),b=p(l,"P",{"data-svelte-h":!0}),j(b)!=="svelte-1p95sde"&&(b.innerHTML=_l),al=a(l),y(f.$$.fragment,l),nl=a(l),I=p(l,"P",{"data-svelte-h":!0}),j(I)!=="svelte-1mvdyro"&&(I.innerHTML=xl),pl=a(l),y(g.$$.fragment,l),jl=a(l),G=p(l,"P",{"data-svelte-h":!0}),j(G)!=="svelte-z2d4pj"&&(G.textContent=Rl),il=a(l),y($.$$.fragment,l),yl=a(l),k=p(l,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1mvdyro"&&(k.innerHTML=Fl),ol=a(l),y(v.$$.fragment,l),ul=a(l),Z=p(l,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1d20a7n"&&(Z.textContent=Yl),cl=a(l),B=p(l,"UL",{"data-svelte-h":!0}),j(B)!=="svelte-19j7ei3"&&(B.innerHTML=Hl),ml=a(l),E=p(l,"P",{"data-svelte-h":!0}),j(E)!=="svelte-15rxufv"&&(E.innerHTML=Nl),Ul=a(l),y(Q.$$.fragment,l),Jl=a(l),W=p(l,"P",{"data-svelte-h":!0}),j(W)!=="svelte-1mvdyro"&&(W.innerHTML=Sl),dl=a(l),y(q.$$.fragment,l),rl=a(l),_=p(l,"P",{"data-svelte-h":!0}),j(_)!=="svelte-uf721q"&&(_.textContent=Xl),Tl=a(l),x=p(l,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1j19fbi"&&(x.innerHTML=zl),wl=a(l),R=p(l,"P",{"data-svelte-h":!0}),j(R)!=="svelte-8iyemc"&&(R.innerHTML=Vl),hl=a(l),y(F.$$.fragment,l),Al=a(l),Y=p(l,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=Ll),Cl=a(l),y(H.$$.fragment,l),bl=a(l),N=p(l,"P",{"data-svelte-h":!0}),j(N)!=="svelte-1q7cy5s"&&(N.innerHTML=Dl),fl=a(l),y(S.$$.fragment,l),Il=a(l),X=p(l,"P",{"data-svelte-h":!0}),j(X)!=="svelte-ovtdpu"&&(X.textContent=Pl),gl=a(l),y(z.$$.fragment,l),Gl=a(l),d=p(l,"DIV",{class:!0,"data-svelte-h":!0}),j(d)!=="svelte-1ym6zda"&&(d.innerHTML=Ol),$l=a(l),V=p(l,"P",{"data-svelte-h":!0}),j(V)!=="svelte-1un66iu"&&(V.innerHTML=Kl),kl=a(l),D=p(l,"P",{}),ls(D).forEach(t),this.h()},h(){Zl(J,"name","hf:doc:metadata"),Zl(J,"content",ys),Zl(d,"class","flex justify-center")},m(l,s){ps(document.head,J),e(l,P,s),e(l,L,s),e(l,O,s),o(r,l,s),e(l,K,s),e(l,T,s),e(l,ll,s),e(l,w,s),e(l,sl,s),o(h,l,s),e(l,tl,s),e(l,A,s),e(l,el,s),e(l,C,s),e(l,Ml,s),e(l,b,s),e(l,al,s),o(f,l,s),e(l,nl,s),e(l,I,s),e(l,pl,s),o(g,l,s),e(l,jl,s),e(l,G,s),e(l,il,s),o($,l,s),e(l,yl,s),e(l,k,s),e(l,ol,s),o(v,l,s),e(l,ul,s),e(l,Z,s),e(l,cl,s),e(l,B,s),e(l,ml,s),e(l,E,s),e(l,Ul,s),o(Q,l,s),e(l,Jl,s),e(l,W,s),e(l,dl,s),o(q,l,s),e(l,rl,s),e(l,_,s),e(l,Tl,s),e(l,x,s),e(l,wl,s),e(l,R,s),e(l,hl,s),o(F,l,s),e(l,Al,s),e(l,Y,s),e(l,Cl,s),o(H,l,s),e(l,bl,s),e(l,N,s),e(l,fl,s),o(S,l,s),e(l,Il,s),e(l,X,s),e(l,gl,s),o(z,l,s),e(l,Gl,s),e(l,d,s),e(l,$l,s),e(l,V,s),e(l,kl,s),e(l,D,s),vl=!0},p:ts,i(l){vl||(u(r.$$.fragment,l),u(h.$$.fragment,l),u(f.$$.fragment,l),u(g.$$.fragment,l),u($.$$.fragment,l),u(v.$$.fragment,l),u(Q.$$.fragment,l),u(q.$$.fragment,l),u(F.$$.fragment,l),u(H.$$.fragment,l),u(S.$$.fragment,l),u(z.$$.fragment,l),vl=!0)},o(l){c(r.$$.fragment,l),c(h.$$.fragment,l),c(f.$$.fragment,l),c(g.$$.fragment,l),c($.$$.fragment,l),c(v.$$.fragment,l),c(Q.$$.fragment,l),c(q.$$.fragment,l),c(F.$$.fragment,l),c(H.$$.fragment,l),c(S.$$.fragment,l),c(z.$$.fragment,l),vl=!1},d(l){l&&(t(P),t(L),t(O),t(K),t(T),t(ll),t(w),t(sl),t(tl),t(A),t(el),t(C),t(Ml),t(b),t(al),t(nl),t(I),t(pl),t(jl),t(G),t(il),t(yl),t(k),t(ol),t(ul),t(Z),t(cl),t(B),t(ml),t(E),t(Ul),t(Jl),t(W),t(dl),t(rl),t(_),t(Tl),t(x),t(wl),t(R),t(hl),t(Al),t(Y),t(Cl),t(bl),t(N),t(fl),t(Il),t(X),t(gl),t(Gl),t(d),t($l),t(V),t(kl),t(D)),t(J),m(r,l),m(h,l),m(f,l),m(g,l),m($,l),m(v,l),m(Q,l),m(q,l),m(F,l),m(H,l),m(S,l),m(z,l)}}}const ys='{"title":"Загрузка и изучение аудио набора данных","local":"загрузка-и-изучение-аудио-набора-данных","sections":[],"depth":1}';function os(Bl){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends Ms{constructor(J){super(),as(this,J,os,is,ss,{})}}export{Js as component};
