import{s as rs,f as cs,o as hs,n as us}from"../chunks/scheduler.f7e1785c.js";import{S as ds,i as ms,g as i,s as n,r,A as fs,h as o,f as s,c as l,j as kt,u as c,x as p,k as U,y as ys,a,v as h,d as u,t as d,w as m,m as gs,n as ws}from"../chunks/index.9f8f0838.js";import{T as ps}from"../chunks/Tip.4575d9cf.js";import{C as y}from"../chunks/CodeBlock.b3510e34.js";import{H as ve}from"../chunks/Heading.6643a2f7.js";function Ts(Ue){let f,w=`Whisper can also be ‘tricked’ into translating from speech in any language X to any language Y. Simply set the task to
<code>&quot;transcribe&quot;</code> and the <code>&quot;language&quot;</code> to your target language in the generation key-word arguments,
e.g. for Spanish, one would set:`,M,J,j="<code>generate_kwargs={&quot;task&quot;: &quot;transcribe&quot;, &quot;language&quot;: &quot;es&quot;}</code>";return{c(){f=i("p"),f.innerHTML=w,M=n(),J=i("p"),J.innerHTML=j},l(g){f=o(g,"P",{"data-svelte-h":!0}),p(f)!=="svelte-vga0jc"&&(f.innerHTML=w),M=l(g),J=o(g,"P",{"data-svelte-h":!0}),p(J)!=="svelte-130lm1j"&&(J.innerHTML=j)},m(g,b){a(g,f,b),a(g,M,b),a(g,J,b)},p:us,d(g){g&&(s(f),s(M),s(J))}}}function Ms(Ue){let f;return{c(){f=gs(`Here we're using SpeechT5 checkpoint trained specifically for English TTS. Should you wish to translate into a language 
    other than English, either swap the checkpoint for a SpeechT5 TTS model fine-tuned on your language of choice, or 
    use an MMS TTS checkpoint pre-trained in your target langauge.`)},l(w){f=ws(w,`Here we're using SpeechT5 checkpoint trained specifically for English TTS. Should you wish to translate into a language 
    other than English, either swap the checkpoint for a SpeechT5 TTS model fine-tuned on your language of choice, or 
    use an MMS TTS checkpoint pre-trained in your target langauge.`)},m(w,M){a(w,f,M)},d(w){w&&s(f)}}}function Js(Ue){let f,w,M,J,j,g,b,Zt=`Speech-to-speech translation (STST or S2ST) is a relatively new spoken language processing task. It involves translating
speech from one langauge into speech in a <strong>different</strong> language:`,$e,v,Gt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/s2st.png" alt="Diagram of speech to speech translation"/>',ke,G,St=`STST can be viewed as an extension of the traditional machine translation (MT) task: instead of translating <strong>text</strong> from one
language into another, we translate <strong>speech</strong> from one language into another. STST holds applications in the field of
multilingual communication, enabling speakers in different languages to communicate with one another through the medium
of speech.`,Ze,S,xt=`Suppose you want to communicate with another individual across a langauge barrier. Rather
than writing the information that you want to convey and then translating it to text in the target language, you
can speak it directly and have a STST system convert your spoken speech into the target langauge. The recipient can then
respond by speaking back at the STST system, and you can listen to their response. This is a more natural way of communicating
compared to text-based machine translation.`,Ge,x,Ct=`In this chapter, we’ll explore a <em>cascaded</em> approach to STST, piecing together the knowledge you’ve acquired in Units
5 and 6 of the course. We’ll use a <em>speech translation (ST)</em> system to transcribe the source speech into text in the target
language, then <em>text-to-speech (TTS)</em> to generate speech in the target language from the translated text:`,Se,$,It='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/s2st_cascaded.png" alt="Diagram of cascaded speech to speech translation"/>',xe,C,Wt=`We could also have used a three stage approach, where first we use an automatic speech recognition (ASR) system to
transcribe the source speech into text in the same language, then machine translation to translate the transcribed text
into the target language, and finally text-to-speech to generate speech in the target language. However, adding more
components to the pipeline lends itself to <em>error propagation</em>, where the errors introduced in one system are compounded
as they flow through the remaining systems, and also increases latency, since inference has to be conducted for more models.`,Ce,I,Nt=`While this cascaded approach to STST is pretty straightforward, it results in very effective STST systems. The three-stage
cascaded system of ASR + MT + TTS was previously used to power many commercial STST products, including <a href="https://ai.googleblog.com/2019/05/introducing-translatotron-end-to-end.html" rel="nofollow">Google Translate</a>.
It’s also a very data and compute efficient way of developing a STST system, since existing speech recognition and
text-to-speech systems can be coupled together to yield a new STST model without any additional training.`,Ie,W,_t=`In the remainder of this Unit, we’ll focus on creating a STST system that translates speech from any language X to speech
in English. The methods covered can be extended to STST systems that translate from any language X to any
langauge Y, but we leave this as an extension to the reader and provide pointers where applicable. We further divide up the
task of STST into its two constituent components: ST and TTS. We’ll finish by piecing them together to build a Gradio
demo to showcase our system.`,We,N,Ne,_,Bt=`We’ll use the Whisper model for our speech translation system, since it’s capable of translating from over 96 languages
to English. Specifically, we’ll load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which
clocks in at 74M parameters. It’s by no means the most performant Whisper model, with the <a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">largest Whisper checkpoint</a>
being over 20x larger, but since we’re concatenating two auto-regressive systems together (ST + TTS), we want to ensure
each model can generate relatively quickly so that we get reasonable inference speed:`,_e,B,Be,V,Vt=`Great! To test our STST system, we’ll load an audio sample in a non-English language. Let’s load the first example of the
Italian (<code>it</code>) split of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset:`,Ve,H,He,X,Ht='To listen to this sample, we can either play it using the dataset viewer on the Hub: <a href="https://huggingface.co/datasets/facebook/voxpopuli/viewer/it/validation?row=0" rel="nofollow">facebook/voxpopuli/viewer</a>',Xe,q,Xt="Or playback using the ipynb audio feature:",qe,R,Re,Y,qt=`Now let’s define a function that takes this audio input and returns the translated text. You’ll remember that we have to
pass the generation key-word argument for the <code>&quot;task&quot;</code>, setting it to <code>&quot;translate&quot;</code> to ensure that Whisper performs
speech translation and not speech recognition:`,Ye,Q,Qe,k,Fe,F,Rt="Great! Let’s quickly check that we get a sensible result from the model:",ze,z,Ee,E,Le,L,Yt="Alright! If we compare this to the source text:",Pe,P,Ae,A,Ke,K,Qt=`We see that the translation more or less lines up (you can double check this using Google Translate), barring a small
extra few words at the start of the transcription where the speaker was finishing off their previous sentence.`,De,D,Ft=`With that, we’ve completed the first half of our cascaded STST pipeline, putting into practice the skills we gained in Unit 5
when we learnt how to use the Whisper model for speech recognition and translation. If you want a refresher on any of the
steps we covered, have a read through the section on <a href="../chapter5/asr_models">Pre-trained models for ASR</a> from Unit 5.`,Oe,O,et,ee,zt=`The second half of our cascaded STST system involves mapping from English text to English speech. For this, we’ll use
the pre-trained <a href="https://huggingface.co/microsoft/speecht5_tts" rel="nofollow">SpeechT5 TTS</a> model for English TTS. 🤗 Transformers currently doesn’t
have a TTS <code>pipeline</code>, so we’ll have to use the model directly ourselves. This is no biggie, you’re all experts on using
the model for inference following Unit 6!`,tt,te,Et="First, let’s load the SpeechT5 processor, model and vocoder from the pre-trained checkpoint:",st,se,at,Z,nt,ae,Lt="As with the Whisper model, we’ll place the SpeechT5 model and vocoder on our GPU accelerator device if we have one:",lt,ne,it,le,Pt="Great! Let’s load up the speaker embeddings:",ot,ie,pt,oe,At=`We can now write a function that takes a text prompt as input, and generates the corresponding speech. We’ll first pre-process
the text input using the SpeechT5 processor, tokenizing the text to get our input ids. We’ll then pass the input ids and
speaker embeddings to the SpeechT5 model, placing each on the accelerator device if available. Finally, we’ll return the
generated speech, bringing it back to the CPU so that we can play it back in our ipynb notebook:`,rt,pe,ct,re,Kt="Let’s check it works with a dummy text input:",ht,ce,ut,he,Dt="Sounds good! Now for the exciting part - piecing it all together.",dt,ue,mt,de,Ot=`Before we create a <a href="https://gradio.app" rel="nofollow">Gradio</a> demo to showcase our STST system, let’s first do a quick sanity check
to make sure we can concatenate the two models, putting an audio sample in and getting an audio sample out. We’ll do
this by concatenating the two functions we defined in the previous two sub-sections, such that we input the source audio
and retrieve the translated text, then synthesise the translated text to get the translated speech. Finally, we’ll convert
the synthesised speech to an <code>int16</code> array, which is the output audio file format expected by Gradio. To do this, we
first have to normalise the audio array by the dynamic range of the target dtype (<code>int16</code>), and then convert from the
default NumPy dtype (<code>float64</code>) to the target dtype (<code>int16</code>):`,ft,me,yt,fe,es="Let’s check this concatenated function gives the expected result:",gt,ye,wt,ge,ts=`Perfect! Now we’ll wrap this up into a nice Gradio demo so that we can record our source speech using a microphone input
or file input and playback the system’s prediction:`,Tt,we,Mt,Te,ss="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",Jt,T,as,bt,Me,ns=`You can <a href="https://huggingface.co/spaces/course-demos/speech-to-speech-translation?duplicate=true" rel="nofollow">duplicate</a> this demo and adapt
it to use a different Whisper checkpoint, a different TTS checkpoint, or relax the constraint of outputting English
speech and follow the tips provide for translating into a langauge of your choice!`,Ut,Je,jt,be,ls=`While the cascaded system is a compute and data efficient way of building a STST system, it suffers from the issues of
error propagation and additive latency described above. Recent works have explored a <em>direct</em> approach to STST, one that
does not predict an intermediate text output and instead maps directly from source speech to target speech. These systems
are also capable of retaining the speaking characteristics of the source speaker in the target speech (such a prosody,
pitch and intonation). If you’re interested in finding out more about these systems, check-out the resources listed in
the section on <a href="supplemental_reading">supplemental reading</a>.`,vt,je,$t;return j=new ve({props:{title:"Speech-to-speech translation",local:"speech-to-speech-translation",headingTag:"h1"}}),N=new ve({props:{title:"Speech translation",local:"speech-translation",headingTag:"h2"}}),B=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),H=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmYWNlYm9vayUyRnZveHBvcHVsaSUyMiUyQyUyMCUyMml0JTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;it&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Q=new y({props:{code:"ZGVmJTIwdHJhbnNsYXRlKGF1ZGlvKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBwaXBlKGF1ZGlvJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNsYXRlJTIyJTdEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHMlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">translate</span>(<span class="hljs-params">audio</span>):
    outputs = pipe(audio, max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})
    <span class="hljs-keyword">return</span> outputs[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),k=new ps({props:{$$slots:{default:[Ts]},$$scope:{ctx:Ue}}}),z=new y({props:{code:"dHJhbnNsYXRlKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:'translate(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),E=new y({props:{code:"JyUyMHBzeWNob2xvZ2ljYWwlMjBhbmQlMjBzb2NpYWwuJTIwSSUyMHRoaW5rJTIwdGhhdCUyMGl0JTIwaXMlMjBhJTIwdmVyeSUyMGltcG9ydGFudCUyMHN0ZXAlMjBpbiUyMHRoZSUyMGNvbnN0cnVjdGlvbiUyMG9mJTIwYSUyMGp1cmlkaWNhbCUyMHNwYWNlJTIwb2YlMjBmcmVlZG9tJTJDJTIwY2lyY3VsYXRpb24lMjBhbmQlMjBwcm90ZWN0aW9uJTIwb2YlMjByaWdodHMuJw==",highlighted:'<span class="hljs-comment">&#x27; psychological and social. I think that it is a very important step in the construction of a juridical space of freedom, circulation and protection of rights.&#x27;</span>',wrap:!1}}),P=new y({props:{code:"c2FtcGxlJTVCJTIycmF3X3RleHQlMjIlNUQ=",highlighted:'sample[<span class="hljs-string">&quot;raw_text&quot;</span>]',wrap:!1}}),A=new y({props:{code:"J1BlbnNvJTIwY2hlJTIwcXVlc3RvJTIwc2lhJTIwdW4lMjBwYXNzbyUyMGluJTIwYXZhbnRpJTIwaW1wb3J0YW50ZSUyMG5lbGxhJTIwY29zdHJ1emlvbmUlMjBkaSUyMHVubyUyMHNwYXppbyUyMGdpdXJpZGljbyUyMGRpJTIwbGliZXJ0JUMzJUEwJTIwZGklMjBjaXJjb2xhemlvbmUlMjBlJTIwZGklMjBwcm90ZXppb25lJTIwZGVpJTIwZGlyaXR0aSUyMHBlciUyMGxlJTIwcGVyc29uZSUyMGluJTIwRXVyb3BhLic=",highlighted:'<span class="hljs-comment">&#x27;Penso che questo sia un passo in avanti importante nella costruzione di uno spazio giuridico di libertà di circolazione e di protezione dei diritti per le persone in Europa.&#x27;</span>',wrap:!1}}),O=new ve({props:{title:"Text-to-speech",local:"text-to-speech",headingTag:"h2"}}),se=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTJDJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2glMkMlMjBTcGVlY2hUNUhpZmlHYW4lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTcGVlY2hUNVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3BlZWNodDVfdHRzJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2guZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiklMEF2b2NvZGVyJTIwJTNEJTIwU3BlZWNoVDVIaWZpR2FuLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzcGVlY2h0NV9oaWZpZ2FuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor, SpeechT5ForTextToSpeech, SpeechT5HifiGan

processor = SpeechT5Processor.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)

model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)
vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)`,wrap:!1}}),Z=new ps({props:{$$slots:{default:[Ms]},$$scope:{ctx:Ue}}}),ne=new y({props:{code:"bW9kZWwudG8oZGV2aWNlKSUwQXZvY29kZXIudG8oZGV2aWNlKQ==",highlighted:`model.to(device)
vocoder.to(device)`,wrap:!1}}),ie=new y({props:{code:"ZW1iZWRkaW5nc19kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMk1hdHRoaWpzJTJGY211LWFyY3RpYy14dmVjdG9ycyUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW1iZWRkaW5nc19kYXRhc2V0JTVCNzMwNiU1RCU1QiUyMnh2ZWN0b3IlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`embeddings_dataset = load_dataset(<span class="hljs-string">&quot;Matthijs/cmu-arctic-xvectors&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
speaker_embeddings = torch.tensor(embeddings_dataset[<span class="hljs-number">7306</span>][<span class="hljs-string">&quot;xvector&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),pe=new y({props:{code:"ZGVmJTIwc3ludGhlc2lzZSh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC50byhkZXZpY2UpJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzLnRvKGRldmljZSklMkMlMjB2b2NvZGVyJTNEdm9jb2RlciUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVlY2guY3B1KCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">synthesise</span>(<span class="hljs-params">text</span>):
    inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    speech = model.generate_speech(
        inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(device), speaker_embeddings.to(device), vocoder=vocoder
    )
    <span class="hljs-keyword">return</span> speech.cpu()`,wrap:!1}}),ce=new y({props:{code:"c3BlZWNoJTIwJTNEJTIwc3ludGhlc2lzZSglMjJIZXklMjB0aGVyZSElMjBUaGlzJTIwaXMlMjBhJTIwdGVzdCElMjIpJTBBJTBBQXVkaW8oc3BlZWNoJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:`speech = synthesise(<span class="hljs-string">&quot;Hey there! This is a test!&quot;</span>)

Audio(speech, rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),ue=new ve({props:{title:"Creating a STST demo",local:"creating-a-stst-demo",headingTag:"h2"}}),me=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2R0eXBlJTIwJTNEJTIwbnAuaW50MTYlMEFtYXhfcmFuZ2UlMjAlM0QlMjBucC5paW5mbyh0YXJnZXRfZHR5cGUpLm1heCUwQSUwQSUwQWRlZiUyMHNwZWVjaF90b19zcGVlY2hfdHJhbnNsYXRpb24oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwdHJhbnNsYXRlZF90ZXh0JTIwJTNEJTIwdHJhbnNsYXRlKGF1ZGlvKSUwQSUyMCUyMCUyMCUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMHN5bnRoZXNpc2UodHJhbnNsYXRlZF90ZXh0KSUwQSUyMCUyMCUyMCUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMChzeW50aGVzaXNlZF9zcGVlY2gubnVtcHkoKSUyMColMjBtYXhfcmFuZ2UpLmFzdHlwZShucC5pbnQxNiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxNjAwMCUyQyUyMHN5bnRoZXNpc2VkX3NwZWVjaA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_dtype = np.int16
max_range = np.iinfo(target_dtype).<span class="hljs-built_in">max</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">speech_to_speech_translation</span>(<span class="hljs-params">audio</span>):
    translated_text = translate(audio)
    synthesised_speech = synthesise(translated_text)
    synthesised_speech = (synthesised_speech.numpy() * max_range).astype(np.int16)
    <span class="hljs-keyword">return</span> <span class="hljs-number">16000</span>, synthesised_speech`,wrap:!1}}),ye=new y({props:{code:"c2FtcGxpbmdfcmF0ZSUyQyUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMHNwZWVjaF90b19zcGVlY2hfdHJhbnNsYXRpb24oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQpJTBBJTBBQXVkaW8oc3ludGhlc2lzZWRfc3BlZWNoJTJDJTIwcmF0ZSUzRHNhbXBsaW5nX3JhdGUp",highlighted:`sampling_rate, synthesised_speech = speech_to_speech_translation(sample[<span class="hljs-string">&quot;audio&quot;</span>])

Audio(synthesised_speech, rate=sampling_rate)`,wrap:!1}}),we=new y({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQW1pY190cmFuc2xhdGUlMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RzcGVlY2hfdG9fc3BlZWNoX3RyYW5zbGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8oc291cmNlJTNEJTIybWljcm9waG9uZSUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJHZW5lcmF0ZWQlMjBTcGVlY2glMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIpJTJDJTBBKSUwQSUwQWZpbGVfdHJhbnNsYXRlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEc3BlZWNoX3RvX3NwZWVjaF90cmFuc2xhdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyUzRGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJHZW5lcmF0ZWQlMjBTcGVlY2glMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIpJTJDJTBBKSUwQSUwQXdpdGglMjBkZW1vJTNBJTBBJTIwJTIwJTIwJTIwZ3IuVGFiYmVkSW50ZXJmYWNlKCU1Qm1pY190cmFuc2xhdGUlMkMlMjBmaWxlX3RyYW5zbGF0ZSU1RCUyQyUyMCU1QiUyMk1pY3JvcGhvbmUlMjIlMkMlMjAlMjJBdWRpbyUyMEZpbGUlMjIlNUQpJTBBJTBBZGVtby5sYXVuY2goZGVidWclM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()

mic_translate = gr.Interface(
    fn=speech_to_speech_translation,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Audio(label=<span class="hljs-string">&quot;Generated Speech&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>),
)

file_translate = gr.Interface(
    fn=speech_to_speech_translation,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Audio(label=<span class="hljs-string">&quot;Generated Speech&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>),
)

<span class="hljs-keyword">with</span> demo:
    gr.TabbedInterface([mic_translate, file_translate], [<span class="hljs-string">&quot;Microphone&quot;</span>, <span class="hljs-string">&quot;Audio File&quot;</span>])

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),Je=new ve({props:{title:"Going forwards",local:"going-forwards",headingTag:"h2"}}),{c(){f=i("meta"),w=n(),M=i("p"),J=n(),r(j.$$.fragment),g=n(),b=i("p"),b.innerHTML=Zt,$e=n(),v=i("div"),v.innerHTML=Gt,ke=n(),G=i("p"),G.innerHTML=St,Ze=n(),S=i("p"),S.textContent=xt,Ge=n(),x=i("p"),x.innerHTML=Ct,Se=n(),$=i("div"),$.innerHTML=It,xe=n(),C=i("p"),C.innerHTML=Wt,Ce=n(),I=i("p"),I.innerHTML=Nt,Ie=n(),W=i("p"),W.textContent=_t,We=n(),r(N.$$.fragment),Ne=n(),_=i("p"),_.innerHTML=Bt,_e=n(),r(B.$$.fragment),Be=n(),V=i("p"),V.innerHTML=Vt,Ve=n(),r(H.$$.fragment),He=n(),X=i("p"),X.innerHTML=Ht,Xe=n(),q=i("p"),q.textContent=Xt,qe=n(),r(R.$$.fragment),Re=n(),Y=i("p"),Y.innerHTML=qt,Ye=n(),r(Q.$$.fragment),Qe=n(),r(k.$$.fragment),Fe=n(),F=i("p"),F.textContent=Rt,ze=n(),r(z.$$.fragment),Ee=n(),r(E.$$.fragment),Le=n(),L=i("p"),L.textContent=Yt,Pe=n(),r(P.$$.fragment),Ae=n(),r(A.$$.fragment),Ke=n(),K=i("p"),K.textContent=Qt,De=n(),D=i("p"),D.innerHTML=Ft,Oe=n(),r(O.$$.fragment),et=n(),ee=i("p"),ee.innerHTML=zt,tt=n(),te=i("p"),te.textContent=Et,st=n(),r(se.$$.fragment),at=n(),r(Z.$$.fragment),nt=n(),ae=i("p"),ae.textContent=Lt,lt=n(),r(ne.$$.fragment),it=n(),le=i("p"),le.textContent=Pt,ot=n(),r(ie.$$.fragment),pt=n(),oe=i("p"),oe.textContent=At,rt=n(),r(pe.$$.fragment),ct=n(),re=i("p"),re.textContent=Kt,ht=n(),r(ce.$$.fragment),ut=n(),he=i("p"),he.textContent=Dt,dt=n(),r(ue.$$.fragment),mt=n(),de=i("p"),de.innerHTML=Ot,ft=n(),r(me.$$.fragment),yt=n(),fe=i("p"),fe.textContent=es,gt=n(),r(ye.$$.fragment),wt=n(),ge=i("p"),ge.textContent=ts,Tt=n(),r(we.$$.fragment),Mt=n(),Te=i("p"),Te.textContent=ss,Jt=n(),T=i("iframe"),bt=n(),Me=i("p"),Me.innerHTML=ns,Ut=n(),r(Je.$$.fragment),jt=n(),be=i("p"),be.innerHTML=ls,vt=n(),je=i("p"),this.h()},l(e){const t=fs("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(s),w=l(e),M=o(e,"P",{}),kt(M).forEach(s),J=l(e),c(j.$$.fragment,e),g=l(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-xrl39y"&&(b.innerHTML=Zt),$e=l(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-1q8w6r1"&&(v.innerHTML=Gt),ke=l(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1r1gucv"&&(G.innerHTML=St),Ze=l(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1g3p1ee"&&(S.textContent=xt),Ge=l(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-16kqqhy"&&(x.innerHTML=Ct),Se=l(e),$=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p($)!=="svelte-55g36w"&&($.innerHTML=It),xe=l(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-17ui3zo"&&(C.innerHTML=Wt),Ce=l(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-oqffa8"&&(I.innerHTML=Nt),Ie=l(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1jnkkhd"&&(W.textContent=_t),We=l(e),c(N.$$.fragment,e),Ne=l(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1d2no8a"&&(_.innerHTML=Bt),_e=l(e),c(B.$$.fragment,e),Be=l(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1s7hzub"&&(V.innerHTML=Vt),Ve=l(e),c(H.$$.fragment,e),He=l(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-veyz1i"&&(X.innerHTML=Ht),Xe=l(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-txz4z7"&&(q.textContent=Xt),qe=l(e),c(R.$$.fragment,e),Re=l(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-uzvw8l"&&(Y.innerHTML=qt),Ye=l(e),c(Q.$$.fragment,e),Qe=l(e),c(k.$$.fragment,e),Fe=l(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-dz3cev"&&(F.textContent=Rt),ze=l(e),c(z.$$.fragment,e),Ee=l(e),c(E.$$.fragment,e),Le=l(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1j8a6ju"&&(L.textContent=Yt),Pe=l(e),c(P.$$.fragment,e),Ae=l(e),c(A.$$.fragment,e),Ke=l(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-wp88n3"&&(K.textContent=Qt),De=l(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-k7dh1z"&&(D.innerHTML=Ft),Oe=l(e),c(O.$$.fragment,e),et=l(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1xzib0a"&&(ee.innerHTML=zt),tt=l(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-d9cpp9"&&(te.textContent=Et),st=l(e),c(se.$$.fragment,e),at=l(e),c(Z.$$.fragment,e),nt=l(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-2glor5"&&(ae.textContent=Lt),lt=l(e),c(ne.$$.fragment,e),it=l(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-f6jrhm"&&(le.textContent=Pt),ot=l(e),c(ie.$$.fragment,e),pt=l(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1hvsx4q"&&(oe.textContent=At),rt=l(e),c(pe.$$.fragment,e),ct=l(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-i24jqg"&&(re.textContent=Kt),ht=l(e),c(ce.$$.fragment,e),ut=l(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-e3hzpi"&&(he.textContent=Dt),dt=l(e),c(ue.$$.fragment,e),mt=l(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-17w2mjs"&&(de.innerHTML=Ot),ft=l(e),c(me.$$.fragment,e),yt=l(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1a1frzk"&&(fe.textContent=es),gt=l(e),c(ye.$$.fragment,e),wt=l(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1f76kv1"&&(ge.textContent=ts),Tt=l(e),c(we.$$.fragment,e),Mt=l(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-10sf4ix"&&(Te.textContent=ss),Jt=l(e),T=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),kt(T).forEach(s),bt=l(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1arc8ys"&&(Me.innerHTML=ns),Ut=l(e),c(Je.$$.fragment,e),jt=l(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-9tvm6n"&&(be.innerHTML=ls),vt=l(e),je=o(e,"P",{}),kt(je).forEach(s),this.h()},h(){U(f,"name","hf:doc:metadata"),U(f,"content",bs),U(v,"class","flex justify-center"),U($,"class","flex justify-center"),cs(T.src,as="https://course-demos-speech-to-speech-translation.hf.space")||U(T,"src",as),U(T,"frameborder","0"),U(T,"height","450"),U(T,"title","Gradio app"),U(T,"class","container p-0 flex-grow space-iframe"),U(T,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),U(T,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){ys(document.head,f),a(e,w,t),a(e,M,t),a(e,J,t),h(j,e,t),a(e,g,t),a(e,b,t),a(e,$e,t),a(e,v,t),a(e,ke,t),a(e,G,t),a(e,Ze,t),a(e,S,t),a(e,Ge,t),a(e,x,t),a(e,Se,t),a(e,$,t),a(e,xe,t),a(e,C,t),a(e,Ce,t),a(e,I,t),a(e,Ie,t),a(e,W,t),a(e,We,t),h(N,e,t),a(e,Ne,t),a(e,_,t),a(e,_e,t),h(B,e,t),a(e,Be,t),a(e,V,t),a(e,Ve,t),h(H,e,t),a(e,He,t),a(e,X,t),a(e,Xe,t),a(e,q,t),a(e,qe,t),h(R,e,t),a(e,Re,t),a(e,Y,t),a(e,Ye,t),h(Q,e,t),a(e,Qe,t),h(k,e,t),a(e,Fe,t),a(e,F,t),a(e,ze,t),h(z,e,t),a(e,Ee,t),h(E,e,t),a(e,Le,t),a(e,L,t),a(e,Pe,t),h(P,e,t),a(e,Ae,t),h(A,e,t),a(e,Ke,t),a(e,K,t),a(e,De,t),a(e,D,t),a(e,Oe,t),h(O,e,t),a(e,et,t),a(e,ee,t),a(e,tt,t),a(e,te,t),a(e,st,t),h(se,e,t),a(e,at,t),h(Z,e,t),a(e,nt,t),a(e,ae,t),a(e,lt,t),h(ne,e,t),a(e,it,t),a(e,le,t),a(e,ot,t),h(ie,e,t),a(e,pt,t),a(e,oe,t),a(e,rt,t),h(pe,e,t),a(e,ct,t),a(e,re,t),a(e,ht,t),h(ce,e,t),a(e,ut,t),a(e,he,t),a(e,dt,t),h(ue,e,t),a(e,mt,t),a(e,de,t),a(e,ft,t),h(me,e,t),a(e,yt,t),a(e,fe,t),a(e,gt,t),h(ye,e,t),a(e,wt,t),a(e,ge,t),a(e,Tt,t),h(we,e,t),a(e,Mt,t),a(e,Te,t),a(e,Jt,t),a(e,T,t),a(e,bt,t),a(e,Me,t),a(e,Ut,t),h(Je,e,t),a(e,jt,t),a(e,be,t),a(e,vt,t),a(e,je,t),$t=!0},p(e,[t]){const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),k.$set(is);const os={};t&2&&(os.$$scope={dirty:t,ctx:e}),Z.$set(os)},i(e){$t||(u(j.$$.fragment,e),u(N.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(k.$$.fragment,e),u(z.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(Z.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),$t=!0)},o(e){d(j.$$.fragment,e),d(N.$$.fragment,e),d(B.$$.fragment,e),d(H.$$.fragment,e),d(R.$$.fragment,e),d(Q.$$.fragment,e),d(k.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(P.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(se.$$.fragment,e),d(Z.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),$t=!1},d(e){e&&(s(w),s(M),s(J),s(g),s(b),s($e),s(v),s(ke),s(G),s(Ze),s(S),s(Ge),s(x),s(Se),s($),s(xe),s(C),s(Ce),s(I),s(Ie),s(W),s(We),s(Ne),s(_),s(_e),s(Be),s(V),s(Ve),s(He),s(X),s(Xe),s(q),s(qe),s(Re),s(Y),s(Ye),s(Qe),s(Fe),s(F),s(ze),s(Ee),s(Le),s(L),s(Pe),s(Ae),s(Ke),s(K),s(De),s(D),s(Oe),s(et),s(ee),s(tt),s(te),s(st),s(at),s(nt),s(ae),s(lt),s(it),s(le),s(ot),s(pt),s(oe),s(rt),s(ct),s(re),s(ht),s(ut),s(he),s(dt),s(mt),s(de),s(ft),s(yt),s(fe),s(gt),s(wt),s(ge),s(Tt),s(Mt),s(Te),s(Jt),s(T),s(bt),s(Me),s(Ut),s(jt),s(be),s(vt),s(je)),s(f),m(j,e),m(N,e),m(B,e),m(H,e),m(R,e),m(Q,e),m(k,e),m(z,e),m(E,e),m(P,e),m(A,e),m(O,e),m(se,e),m(Z,e),m(ne,e),m(ie,e),m(pe,e),m(ce,e),m(ue,e),m(me,e),m(ye,e),m(we,e),m(Je,e)}}}const bs='{"title":"Speech-to-speech translation","local":"speech-to-speech-translation","sections":[{"title":"Speech translation","local":"speech-translation","sections":[],"depth":2},{"title":"Text-to-speech","local":"text-to-speech","sections":[],"depth":2},{"title":"Creating a STST demo","local":"creating-a-stst-demo","sections":[],"depth":2},{"title":"Going forwards","local":"going-forwards","sections":[],"depth":2}],"depth":1}';function Us(Ue){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends ds{constructor(f){super(),ms(this,f,Us,Js,rs,{})}}export{Gs as component};
