import{s as Ti,o as yi,n as Ho}from"../chunks/scheduler.8c3d61f6.js";import{S as Mi,i as Vi,g as r,s as n,r as m,A as Ci,h as l,f as o,c as i,j as y,u as g,x as p,k as M,y as s,a,v as u,d as f,t as h,w as _}from"../chunks/index.da70eac4.js";import{T as xi}from"../chunks/Tip.1d9b8c37.js";import{D as V}from"../chunks/Docstring.6b390b9a.js";import{C as R}from"../chunks/CodeBlock.00a903b3.js";import{E as Wt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as F,E as Ji}from"../chunks/EditOnGithub.1e64e623.js";function Ii(Z){let c,C='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=r("p"),c.innerHTML=C},l(v){c=l(v,"P",{"data-svelte-h":!0}),p(c)!=="svelte-w7r39y"&&(c.innerHTML=C)},m(v,b){a(v,c,b)},p:Ho,d(v){v&&o(c)}}}function Xi(Z){let c,C="Examples:",v,b,w;return b=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBJTIzJTIwTW9kZWxzJTNBJTIwJTIyVEhVRE0lMkZDb2dWaWRlb1gtMmIlMjIlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTViJTIyJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHBhbmRhJTJDJTIwZHJlc3NlZCUyMGluJTIwYSUyMHNtYWxsJTJDJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYSUyMHRpbnklMjBoYXQlMkMlMjBzaXRzJTIwb24lMjBhJTIwd29vZGVuJTIwc3Rvb2wlMjBpbiUyMGElMjBzZXJlbmUlMjBiYW1ib28lMjBmb3Jlc3QuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcGFuZGEncyUyMGZsdWZmeSUyMHBhd3MlMjBzdHJ1bSUyMGElMjBtaW5pYXR1cmUlMjBhY291c3RpYyUyMGd1aXRhciUyQyUyMHByb2R1Y2luZyUyMHNvZnQlMkMlMjBtZWxvZGljJTIwdHVuZXMuJTIwTmVhcmJ5JTJDJTIwYSUyMGZldyUyMG90aGVyJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIycGFuZGFzJTIwZ2F0aGVyJTJDJTIwd2F0Y2hpbmclMjBjdXJpb3VzbHklMjBhbmQlMjBzb21lJTIwY2xhcHBpbmclMjBpbiUyMHJoeXRobS4lMjBTdW5saWdodCUyMGZpbHRlcnMlMjB0aHJvdWdoJTIwdGhlJTIwdGFsbCUyMGJhbWJvbyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmNhc3RpbmclMjBhJTIwZ2VudGxlJTIwZ2xvdyUyMG9uJTIwdGhlJTIwc2NlbmUuJTIwVGhlJTIwcGFuZGEncyUyMGZhY2UlMjBpcyUyMGV4cHJlc3NpdmUlMkMlMjBzaG93aW5nJTIwY29uY2VudHJhdGlvbiUyMGFuZCUyMGpveSUyMGFzJTIwaXQlMjBwbGF5cy4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBiYWNrZ3JvdW5kJTIwaW5jbHVkZXMlMjBhJTIwc21hbGwlMkMlMjBmbG93aW5nJTIwc3RyZWFtJTIwYW5kJTIwdmlicmFudCUyMGdyZWVuJTIwZm9saWFnZSUyQyUyMGVuaGFuY2luZyUyMHRoZSUyMHBlYWNlZnVsJTIwYW5kJTIwbWFnaWNhbCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmF0bW9zcGhlcmUlMjBvZiUyMHRoaXMlMjB1bmlxdWUlMjBtdXNpY2FsJTIwcGVyZm9ybWFuY2UuJTIyJTBBKSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,v=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),v=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,v,T),u(b,d,T),w=!0},p:Ho,i(d){w||(f(b.$$.fragment,d),w=!0)},o(d){h(b.$$.fragment,d),w=!1},d(d){d&&(o(c),o(v)),_(b,d)}}}function Ui(Z){let c,C="Examples:",v,b,w;return b=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWItSTJWJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyQyUyMG9uJTIwdGhlJTIwc3VyZmFjZSUyMG9mJTIwdGhlJTIwbW9vbiUyQyUyMHRoZSUyMGRhcmtuZXNzJTIwYW5kJTIwZGVwdGglMjBvZiUyMHNwYWNlJTIwcmVhbGlzZWQlMjBpbiUyMHRoZSUyMGJhY2tncm91bmQuJTIwSGlnaCUyMHF1YWxpdHklMkMlMjB1bHRyYXJlYWxpc3RpYyUyMGRldGFpbCUyMGFuZCUyMGJyZWF0aC10YWtpbmclMjBtb3ZpZS1saWtlJTIwY2FtZXJhJTIwc2hvdC4lMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGYXN0cm9uYXV0LmpwZyUyMiUwQSklMEF2aWRlbyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBwcm9tcHQlMkMlMjB1c2VfZHluYW1pY19jZmclM0RUcnVlKSUwQWV4cG9ydF90b192aWRlbyh2aWRlby5mcmFtZXMlNUIwJTVEJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b-I2V&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;An astronaut hatching from an egg, on the surface of the moon, the darkness and depth of space realised in the background. High quality, ultrarealistic detail and breath-taking movie-like camera shot.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astronaut.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(image, prompt, use_dynamic_cfg=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,v=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),v=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,v,T),u(b,d,T),w=!0},p:Ho,i(d){w||(f(b.$$.fragment,d),w=!0)},o(d){h(b.$$.fragment,d),w=!1},d(d){d&&(o(c),o(v)),_(b,d)}}}function ji(Z){let c,C="Examples:",v,b,w;return b=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRFBNU2NoZWR1bGVyJTJDJTIwQ29nVmlkZW9YVmlkZW9Ub1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF92aWRlbyUwQSUwQSUyMyUyME1vZGVscyUzQSUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTJiJTIyJTIwb3IlMjAlMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMiUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hWaWRlb1RvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMENvZ1ZpZGVvWERQTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBaW5wdXRfdmlkZW8lMjAlM0QlMjBsb2FkX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmhpa2VyLm1wNCUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBzdGFuZHMlMjB0cml1bXBoYW50bHklMjBhdCUyMHRoZSUyMHBlYWslMjBvZiUyMGElMjB0b3dlcmluZyUyMG1vdW50YWluLiUyMFBhbm9yYW1hJTIwb2YlMjBydWdnZWQlMjBwZWFrcyUyMGFuZCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnZhbGxleXMuJTIwVmVyeSUyMGZ1dHVyaXN0aWMlMjB2aWJlJTIwYW5kJTIwYW5pbWF0ZWQlMjBhZXN0aGV0aWMuJTIwSGlnaGxpZ2h0cyUyMG9mJTIwcHVycGxlJTIwYW5kJTIwZ29sZGVuJTIwY29sb3JzJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBzY2VuZS4lMjBUaGUlMjBza3klMjBpcyUyMGxvb2tzJTIwbGlrZSUyMGFuJTIwYW5pbWF0ZWQlMkZjYXJ0b29uaXNoJTIwZHJlYW0lMjBvZiUyMGdhbGF4aWVzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwcGxhbmV0cyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMm1vb25zJTJDJTIwYnV0JTIwdGhlJTIwcmVtYWluZGVyJTIwb2YlMjB0aGUlMjBzY2VuZSUyMGlzJTIwbW9zdGx5JTIwcmVhbGlzdGljLiUyMiUwQSklMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwdmlkZW8lM0RpbnB1dF92aWRlbyUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMHN0cmVuZ3RoJTNEMC44JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q2JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXDPMScheduler, CogVideoXVideoToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXVideoToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = CogVideoXDPMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    video=input_video, prompt=prompt, strength=<span class="hljs-number">0.8</span>, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,v=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),v=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,v,T),u(b,d,T),w=!0},p:Ho,i(d){w||(f(b.$$.fragment,d),w=!0)},o(d){h(b.$$.fragment,d),w=!1},d(d){d&&(o(c),o(v)),_(b,d)}}}function ki(Z){let c,C="Examples:",v,b,w;return b=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRnVuQ29udHJvbFBpcGVsaW5lJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMkMlMjBsb2FkX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWEZ1bkNvbnRyb2xQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYWxpYmFiYS1wYWklMkZDb2dWaWRlb1gtRnVuLVYxLjEtNWItUG9zZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBY29udHJvbF92aWRlbyUyMCUzRCUyMGxvYWRfdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaGlrZXIubXA0JTIyJTBBKSUwQXByb21wdCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHN0YW5kcyUyMHRyaXVtcGhhbnRseSUyMGF0JTIwdGhlJTIwcGVhayUyMG9mJTIwYSUyMHRvd2VyaW5nJTIwbW91bnRhaW4uJTIwUGFub3JhbWElMjBvZiUyMHJ1Z2dlZCUyMHBlYWtzJTIwYW5kJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIydmFsbGV5cy4lMjBWZXJ5JTIwZnV0dXJpc3RpYyUyMHZpYmUlMjBhbmQlMjBhbmltYXRlZCUyMGFlc3RoZXRpYy4lMjBIaWdobGlnaHRzJTIwb2YlMjBwdXJwbGUlMjBhbmQlMjBnb2xkZW4lMjBjb2xvcnMlMjBpbiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnRoZSUyMHNjZW5lLiUyMFRoZSUyMHNreSUyMGlzJTIwbG9va3MlMjBsaWtlJTIwYW4lMjBhbmltYXRlZCUyRmNhcnRvb25pc2glMjBkcmVhbSUyMG9mJTIwZ2FsYXhpZXMlMkMlMjBuZWJ1bGFlJTJDJTIwc3RhcnMlMkMlMjBwbGFuZXRzJTJDJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIybW9vbnMlMkMlMjBidXQlMjB0aGUlMjByZW1haW5kZXIlMjBvZiUyMHRoZSUyMHNjZW5lJTIwaXMlMjBtb3N0bHklMjByZWFsaXN0aWMuJTIyJTBBKSUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBjb250cm9sX3ZpZGVvJTNEY29udHJvbF92aWRlbykuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMm91dHB1dC5tcDQlMjIlMkMlMjBmcHMlM0Q4KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXFunControlPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXFunControlPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>control_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, control_video=control_video).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=C,v=n(),m(b.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=C),v=i(d),g(b.$$.fragment,d)},m(d,T){a(d,c,T),a(d,v,T),u(b,d,T),w=!0},p:Ho,i(d){w||(f(b.$$.fragment,d),w=!0)},o(d){h(b.$$.fragment,d),w=!1},d(d){d&&(o(c),o(v)),_(b,d)}}}function $i(Z){let c,C,v,b,w,d,T,Un='<a href="https://arxiv.org/abs/2408.06072" rel="nofollow">CogVideoX: Text-to-Video Diffusion Models with An Expert Transformer</a> from Tsinghua University &amp; ZhipuAI, by Zhuoyi Yang, Jiayan Teng, Wendi Zheng, Ming Ding, Shiyu Huang, Jiazheng Xu, Yuanming Yang, Wenyi Hong, Xiaohan Zhang, Guanyu Feng, Da Yin, Xiaotao Gu, Yuxuan Zhang, Weihan Wang, Yean Cheng, Ting Liu, Bin Xu, Yuxiao Dong, Jie Tang.',No,ae,jn="The abstract from the paper is:",Fo,re,kn='<em>We introduce CogVideoX, a large-scale diffusion transformer model designed for generating videos based on text prompts. To efficently model video data, we propose to levearge a 3D Variational Autoencoder (VAE) to compresses videos along both spatial and temporal dimensions. To improve the text-video alignment, we propose an expert transformer with the expert adaptive LayerNorm to facilitate the deep fusion between the two modalities. By employing a progressive training technique, CogVideoX is adept at producing coherent, long-duration videos characterized by significant motion. In addition, we develop an effectively text-video data processing pipeline that includes various data preprocessing strategies and a video captioning method. It significantly helps enhance the performance of CogVideoX, improving both generation quality and semantic alignment. Results show that CogVideoX demonstrates state-of-the-art performance across both multiple machine metrics and human evaluations. The model weight of CogVideoX-2B is publicly available at <a href="https://github.com/THUDM/CogVideo" rel="nofollow">https://github.com/THUDM/CogVideo</a>.</em>',Ro,z,zo,le,$n='This pipeline was contributed by <a href="https://github.com/zRzRzRzRzRzRzR" rel="nofollow">zRzRzRzRzRzRzR</a>. The original codebase can be found <a href="https://huggingface.co/THUDM" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/THUDM" rel="nofollow">hf.co/THUDM</a>.',Yo,de,Zn=`There are three official CogVideoX checkpoints for text-to-video and video-to-video.
| checkpoints | recommended inference dtype |
|---|---|
| <a href="https://huggingface.co/THUDM/CogVideoX-2b" rel="nofollow"><code>THUDM/CogVideoX-2b</code></a> | torch.float16 |
| <a href="https://huggingface.co/THUDM/CogVideoX-5b" rel="nofollow"><code>THUDM/CogVideoX-5b</code></a> | torch.bfloat16 |
| <a href="https://huggingface.co/THUDM/CogVideoX1.5-5b" rel="nofollow"><code>THUDM/CogVideoX1.5-5b</code></a> | torch.bfloat16 |`,qo,pe,Pn=`There are two official CogVideoX checkpoints available for image-to-video.
| checkpoints | recommended inference dtype |
|---|---|
| <a href="https://huggingface.co/THUDM/CogVideoX-5b-I2V" rel="nofollow"><code>THUDM/CogVideoX-5b-I2V</code></a> | torch.bfloat16 |
| <a href="https://huggingface.co/THUDM/CogVideoX-1.5-5b-I2V" rel="nofollow"><code>THUDM/CogVideoX-1.5-5b-I2V</code></a> | torch.bfloat16 |`,Lo,ce,Gn="For the CogVideoX 1.5 series:",Do,me,Wn="<li>Text-to-video (T2V) works best at a resolution of 1360x768 because it was trained with that specific resolution.</li> <li>Image-to-video (I2V) works for multiple resolutions. The width can vary from 768 to 1360, but the height must be 768. The height/width must be divisible by 16.</li> <li>Both T2V and I2V models support generation with 81 and 161 frames and work best at this value. Exporting videos at 16 FPS is recommended.</li>",Eo,ge,Bn=`There are two official CogVideoX checkpoints that support pose controllable generation (by the <a href="https://huggingface.co/alibaba-pai" rel="nofollow">Alibaba-PAI</a> team).
| checkpoints | recommended inference dtype |
|---|---|
| <a href="https://huggingface.co/alibaba-pai/CogVideoX-Fun-V1.1-2b-Pose" rel="nofollow"><code>alibaba-pai/CogVideoX-Fun-V1.1-2b-Pose</code></a> | torch.bfloat16 |
| <a href="https://huggingface.co/alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose" rel="nofollow"><code>alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose</code></a> | torch.bfloat16 |`,So,ue,Qo,fe,Hn='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',Ao,he,Nn="First, load the pipeline:",Oo,_e,Ko,be,Fn="If you are using the image-to-video pipeline, load it as follows:",et,ve,ot,we,Rn="Then change the memory layout of the pipelines <code>transformer</code> component to <code>torch.channels_last</code>:",tt,Te,nt,ye,zn="Compile the components and run inference:",it,Me,st,Ve,Yn='The <a href="https://gist.github.com/a-r-r-o-w/5183d75e452a368fd17448fcc810bd3f" rel="nofollow">T2V benchmark</a> results on an 80GB A100 machine are:',at,Ce,rt,xe,lt,Je,qn='CogVideoX-2b requires about 19 GB of GPU memory to decode 49 frames (6 seconds of video at 8 FPS) with output resolution 720x480 (W x H), which makes it not possible to run on consumer GPUs or free-tier T4 Colab. The following memory optimizations could be used to reduce the memory footprint. For replication, you can refer to <a href="https://gist.github.com/a-r-r-o-w/3959a03f15be5c9bd1fe545b09dfcc93" rel="nofollow">this</a> script.',dt,Ie,Ln="<li><code>pipe.enable_model_cpu_offload()</code>:<ul><li>Without enabling cpu offloading, memory usage is <code>33 GB</code></li> <li>With enabling cpu offloading, memory usage is <code>19 GB</code></li></ul></li> <li><code>pipe.enable_sequential_cpu_offload()</code>:<ul><li>Similar to <code>enable_model_cpu_offload</code> but can significantly reduce memory usage at the cost of slow inference</li> <li>When enabled, memory usage is under <code>4 GB</code></li></ul></li> <li><code>pipe.vae.enable_tiling()</code>:<ul><li>With enabling cpu offloading and tiling, memory usage is <code>11 GB</code></li></ul></li> <li><code>pipe.vae.enable_slicing()</code></li>",pt,Xe,ct,Ue,Dn='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> and <a href="https://github.com/huggingface/optimum-quanto/" rel="nofollow">optimum-quanto</a> can be used to quantize the text encoder, transformer and VAE modules to lower the memory requirements. This makes it possible to run the model on a free-tier T4 Colab or lower VRAM GPUs!',mt,je,En='It is also worth noting that torchao quantization is fully compatible with <a href="/optimization/torch2.0#torchcompile">torch.compile</a>, which allows for much faster inference speed. Additionally, models can be serialized and stored in a quantized datatype to save disk space with torchao. Find examples and benchmarks in the gists below.',gt,ke,Sn='<li><a href="https://gist.github.com/a-r-r-o-w/4d9732d17412888c885480c6521a9897" rel="nofollow">torchao</a></li> <li><a href="https://gist.github.com/a-r-r-o-w/31be62828b00a9292821b85c1017effa" rel="nofollow">quanto</a></li>',ut,$e,ft,x,Ze,Bt,po,Qn="Pipeline for text-to-video generation using CogVideoX.",Ht,co,An=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Nt,P,Pe,Ft,mo,On="Function invoked when calling the pipeline for generation.",Rt,Y,zt,q,Ge,Yt,go,Kn="Encodes the prompt into text encoder hidden states.",qt,L,We,Lt,uo,ei="Enables fused QKV projections.",Dt,D,Be,Et,fo,oi="Disable QKV projection fusion if enabled.",ht,He,_t,J,Ne,St,ho,ti="Pipeline for image-to-video generation using CogVideoX.",Qt,_o,ni=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,At,G,Fe,Ot,bo,ii="Function invoked when calling the pipeline for generation.",Kt,E,en,S,Re,on,vo,si="Encodes the prompt into text encoder hidden states.",tn,Q,ze,nn,wo,ai="Enables fused QKV projections.",sn,A,Ye,an,To,ri="Disable QKV projection fusion if enabled.",bt,qe,vt,I,Le,rn,yo,li="Pipeline for video-to-video generation using CogVideoX.",ln,Mo,di=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,dn,W,De,pn,Vo,pi="Function invoked when calling the pipeline for generation.",cn,O,mn,K,Ee,gn,Co,ci="Encodes the prompt into text encoder hidden states.",un,ee,Se,fn,xo,mi="Enables fused QKV projections.",hn,oe,Qe,_n,Jo,gi="Disable QKV projection fusion if enabled.",wt,Ae,Tt,X,Oe,bn,Io,ui="Pipeline for controlled text-to-video generation using CogVideoX Fun.",vn,Xo,fi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,wn,B,Ke,Tn,Uo,hi="Function invoked when calling the pipeline for generation.",yn,te,Mn,ne,eo,Vn,jo,_i="Encodes the prompt into text encoder hidden states.",Cn,ie,oo,xn,ko,bi="Enables fused QKV projections.",Jn,se,to,In,$o,vi="Disable QKV projection fusion if enabled.",yt,no,Mt,H,io,Xn,Zo,wi="Output class for CogVideo pipelines.",Vt,so,Ct,Bo,xt;return w=new F({props:{title:"CogVideoX",local:"cogvideox",headingTag:"h1"}}),z=new xi({props:{$$slots:{default:[Ii]},$$scope:{ctx:Z}}}),ue=new F({props:{title:"Inference",local:"inference",headingTag:"h2"}}),_e=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMkMlMjBDb2dWaWRlb1hJbWFnZVRvVmlkZW9QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMkNsb2FkX2ltYWdlJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMikudG8oJTIyY3VkYSUyMiklMjAlMjMlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTJiJTIyJTIw",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, CogVideoXImageToVideoPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video,load_image
pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-comment"># or &quot;THUDM/CogVideoX-2b&quot; </span>`,wrap:!1}}),ve=new R({props:{code:"cGlwZSUyMCUzRCUyMENvZ1ZpZGVvWEltYWdlVG9WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC01Yi1JMlYlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:'pipe = CogVideoXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b-I2V&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),Te=new R({props:{code:"cGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCk=",highlighted:"pipe.transformer.to(memory_format=torch.channels_last)",wrap:!1}}),Me=new R({props:{code:"cGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudHJhbnNmb3JtZXIlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBDb2dWaWRlb1glMjB3b3JrcyUyMHdlbGwlMjB3aXRoJTIwbG9uZyUyMGFuZCUyMHdlbGwtZGVzY3JpYmVkJTIwcHJvbXB0cyUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBwYW5kYSUyQyUyMGRyZXNzZWQlMjBpbiUyMGElMjBzbWFsbCUyQyUyMHJlZCUyMGphY2tldCUyMGFuZCUyMGElMjB0aW55JTIwaGF0JTJDJTIwc2l0cyUyMG9uJTIwYSUyMHdvb2RlbiUyMHN0b29sJTIwaW4lMjBhJTIwc2VyZW5lJTIwYmFtYm9vJTIwZm9yZXN0LiUyMFRoZSUyMHBhbmRhJ3MlMjBmbHVmZnklMjBwYXdzJTIwc3RydW0lMjBhJTIwbWluaWF0dXJlJTIwYWNvdXN0aWMlMjBndWl0YXIlMkMlMjBwcm9kdWNpbmclMjBzb2Z0JTJDJTIwbWVsb2RpYyUyMHR1bmVzLiUyME5lYXJieSUyQyUyMGElMjBmZXclMjBvdGhlciUyMHBhbmRhcyUyMGdhdGhlciUyQyUyMHdhdGNoaW5nJTIwY3VyaW91c2x5JTIwYW5kJTIwc29tZSUyMGNsYXBwaW5nJTIwaW4lMjByaHl0aG0uJTIwU3VubGlnaHQlMjBmaWx0ZXJzJTIwdGhyb3VnaCUyMHRoZSUyMHRhbGwlMjBiYW1ib28lMkMlMjBjYXN0aW5nJTIwYSUyMGdlbnRsZSUyMGdsb3clMjBvbiUyMHRoZSUyMHNjZW5lLiUyMFRoZSUyMHBhbmRhJ3MlMjBmYWNlJTIwaXMlMjBleHByZXNzaXZlJTJDJTIwc2hvd2luZyUyMGNvbmNlbnRyYXRpb24lMjBhbmQlMjBqb3klMjBhcyUyMGl0JTIwcGxheXMuJTIwVGhlJTIwYmFja2dyb3VuZCUyMGluY2x1ZGVzJTIwYSUyMHNtYWxsJTJDJTIwZmxvd2luZyUyMHN0cmVhbSUyMGFuZCUyMHZpYnJhbnQlMjBncmVlbiUyMGZvbGlhZ2UlMkMlMjBlbmhhbmNpbmclMjB0aGUlMjBwZWFjZWZ1bCUyMGFuZCUyMG1hZ2ljYWwlMjBhdG1vc3BoZXJlJTIwb2YlMjB0aGlzJTIwdW5pcXVlJTIwbXVzaWNhbCUyMHBlcmZvcm1hbmNlLiUyMiUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQ=",highlighted:`pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># CogVideoX works well with long and well-described prompts</span>
prompt = <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical atmosphere of this unique musical performance.&quot;</span>
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]`,wrap:!1}}),Ce=new R({props:{code:"V2l0aG91dCUyMHRvcmNoLmNvbXBpbGUoKSUzQSUyMEF2ZXJhZ2UlMjBpbmZlcmVuY2UlMjB0aW1lJTNBJTIwOTYuODklMjBzZWNvbmRzLiUwQVdpdGglMjB0b3JjaC5jb21waWxlKCklM0ElMjBBdmVyYWdlJTIwaW5mZXJlbmNlJTIwdGltZSUzQSUyMDc2LjI3JTIwc2Vjb25kcy4=",highlighted:`<span class="hljs-attribute">Without</span> torch.compile(): Average inference time: <span class="hljs-number">96</span>.<span class="hljs-number">89</span> seconds.
<span class="hljs-attribute">With</span> torch.compile(): Average inference time: <span class="hljs-number">76</span>.<span class="hljs-number">27</span> seconds.`,wrap:!1}}),xe=new F({props:{title:"Memory optimization",local:"memory-optimization",headingTag:"h3"}}),Xe=new F({props:{title:"Quantized inference",local:"quantized-inference",headingTag:"h3"}}),$e=new F({props:{title:"CogVideoXPipeline",local:"diffusers.CogVideoXPipeline",headingTag:"h2"}}),Ze=new V({props:{name:"class diffusers.CogVideoXPipeline",anchor:"diffusers.CogVideoXPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": Union"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L140"}}),Pe=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_frames",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 8. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L496",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),Y=new Wt({props:{anchor:"diffusers.CogVideoXPipeline.__call__.example",$$slots:{default:[Xi]},$$scope:{ctx:Z}}}),Ge=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": Optional = None"},{name:"dtype",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device
dtype &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L239"}}),We=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L423"}}),Be=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L428"}}),He=new F({props:{title:"CogVideoXImageToVideoPipeline",local:"diffusers.CogVideoXImageToVideoPipeline",headingTag:"h2"}}),Ne=new V({props:{name:"class diffusers.CogVideoXImageToVideoPipeline",anchor:"diffusers.CogVideoXImageToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": Union"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L156"}}),Fe=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 8. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L592",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),E=new Wt({props:{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.example",$$slots:{default:[Ui]},$$scope:{ctx:Z}}}),Re=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": Optional = None"},{name:"dtype",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device
dtype &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L261"}}),ze=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXImageToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L517"}}),Ye=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXImageToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L523"}}),qe=new F({props:{title:"CogVideoXVideoToVideoPipeline",local:"diffusers.CogVideoXVideoToVideoPipeline",headingTag:"h2"}}),Le=new V({props:{name:"class diffusers.CogVideoXVideoToVideoPipeline",anchor:"diffusers.CogVideoXVideoToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": Union"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L162"}}),De=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": List = None"},{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"strength",val:": float = 0.8"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),O=new Wt({props:{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.example",$$slots:{default:[ji]},$$scope:{ctx:Z}}}),Ee=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": Optional = None"},{name:"dtype",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device
dtype &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L264"}}),Se=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L497"}}),Qe=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L503"}}),Ae=new F({props:{title:"CogVideoXFunControlPipeline",local:"diffusers.CogVideoXFunControlPipeline",headingTag:"h2"}}),Oe=new V({props:{name:"class diffusers.CogVideoXFunControlPipeline",anchor:"diffusers.CogVideoXFunControlPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXFunControlPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXFunControlPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXFunControlPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXFunControlPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L147"}}),Ke=new V({props:{name:"__call__",anchor:"diffusers.CogVideoXFunControlPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": Union = None"},{name:"control_video",val:": Optional = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"control_video_latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": Optional = None"},{name:"callback_on_step_end",val:": Union = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.control_video",description:`<strong>control_video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The control video to condition the generation on. Must be a list of images/frames of the video. If not
provided, <code>control_video_latents</code> must be provided.`,name:"control_video"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.control_video_latents",description:`<strong>control_video_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated control latents, sampled from a Gaussian distribution, to be used as inputs for
controlled video generation. If not provided, <code>control_video</code> must be provided.`,name:"control_video_latents"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L542",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),te=new Wt({props:{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.example",$$slots:{default:[ki]},$$scope:{ctx:Z}}}),eo=new V({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": Optional = None"},{name:"dtype",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device
dtype &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"negative_prompt_embeds"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L248"}}),oo=new V({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXFunControlPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L468"}}),to=new V({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXFunControlPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L473"}}),no=new F({props:{title:"CogVideoXPipelineOutput",local:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",headingTag:"h2"}}),io=new V({props:{name:"class diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_output.py#L8"}}),so=new Ji({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cogvideox.md"}}),{c(){c=r("meta"),C=n(),v=r("p"),b=n(),m(w.$$.fragment),d=n(),T=r("p"),T.innerHTML=Un,No=n(),ae=r("p"),ae.textContent=jn,Fo=n(),re=r("p"),re.innerHTML=kn,Ro=n(),m(z.$$.fragment),zo=n(),le=r("p"),le.innerHTML=$n,Yo=n(),de=r("p"),de.innerHTML=Zn,qo=n(),pe=r("p"),pe.innerHTML=Pn,Lo=n(),ce=r("p"),ce.textContent=Gn,Do=n(),me=r("ul"),me.innerHTML=Wn,Eo=n(),ge=r("p"),ge.innerHTML=Bn,So=n(),m(ue.$$.fragment),Qo=n(),fe=r("p"),fe.innerHTML=Hn,Ao=n(),he=r("p"),he.textContent=Nn,Oo=n(),m(_e.$$.fragment),Ko=n(),be=r("p"),be.textContent=Fn,et=n(),m(ve.$$.fragment),ot=n(),we=r("p"),we.innerHTML=Rn,tt=n(),m(Te.$$.fragment),nt=n(),ye=r("p"),ye.textContent=zn,it=n(),m(Me.$$.fragment),st=n(),Ve=r("p"),Ve.innerHTML=Yn,at=n(),m(Ce.$$.fragment),rt=n(),m(xe.$$.fragment),lt=n(),Je=r("p"),Je.innerHTML=qn,dt=n(),Ie=r("ul"),Ie.innerHTML=Ln,pt=n(),m(Xe.$$.fragment),ct=n(),Ue=r("p"),Ue.innerHTML=Dn,mt=n(),je=r("p"),je.innerHTML=En,gt=n(),ke=r("ul"),ke.innerHTML=Sn,ut=n(),m($e.$$.fragment),ft=n(),x=r("div"),m(Ze.$$.fragment),Bt=n(),po=r("p"),po.textContent=Qn,Ht=n(),co=r("p"),co.innerHTML=An,Nt=n(),P=r("div"),m(Pe.$$.fragment),Ft=n(),mo=r("p"),mo.textContent=On,Rt=n(),m(Y.$$.fragment),zt=n(),q=r("div"),m(Ge.$$.fragment),Yt=n(),go=r("p"),go.textContent=Kn,qt=n(),L=r("div"),m(We.$$.fragment),Lt=n(),uo=r("p"),uo.textContent=ei,Dt=n(),D=r("div"),m(Be.$$.fragment),Et=n(),fo=r("p"),fo.textContent=oi,ht=n(),m(He.$$.fragment),_t=n(),J=r("div"),m(Ne.$$.fragment),St=n(),ho=r("p"),ho.textContent=ti,Qt=n(),_o=r("p"),_o.innerHTML=ni,At=n(),G=r("div"),m(Fe.$$.fragment),Ot=n(),bo=r("p"),bo.textContent=ii,Kt=n(),m(E.$$.fragment),en=n(),S=r("div"),m(Re.$$.fragment),on=n(),vo=r("p"),vo.textContent=si,tn=n(),Q=r("div"),m(ze.$$.fragment),nn=n(),wo=r("p"),wo.textContent=ai,sn=n(),A=r("div"),m(Ye.$$.fragment),an=n(),To=r("p"),To.textContent=ri,bt=n(),m(qe.$$.fragment),vt=n(),I=r("div"),m(Le.$$.fragment),rn=n(),yo=r("p"),yo.textContent=li,ln=n(),Mo=r("p"),Mo.innerHTML=di,dn=n(),W=r("div"),m(De.$$.fragment),pn=n(),Vo=r("p"),Vo.textContent=pi,cn=n(),m(O.$$.fragment),mn=n(),K=r("div"),m(Ee.$$.fragment),gn=n(),Co=r("p"),Co.textContent=ci,un=n(),ee=r("div"),m(Se.$$.fragment),fn=n(),xo=r("p"),xo.textContent=mi,hn=n(),oe=r("div"),m(Qe.$$.fragment),_n=n(),Jo=r("p"),Jo.textContent=gi,wt=n(),m(Ae.$$.fragment),Tt=n(),X=r("div"),m(Oe.$$.fragment),bn=n(),Io=r("p"),Io.textContent=ui,vn=n(),Xo=r("p"),Xo.innerHTML=fi,wn=n(),B=r("div"),m(Ke.$$.fragment),Tn=n(),Uo=r("p"),Uo.textContent=hi,yn=n(),m(te.$$.fragment),Mn=n(),ne=r("div"),m(eo.$$.fragment),Vn=n(),jo=r("p"),jo.textContent=_i,Cn=n(),ie=r("div"),m(oo.$$.fragment),xn=n(),ko=r("p"),ko.textContent=bi,Jn=n(),se=r("div"),m(to.$$.fragment),In=n(),$o=r("p"),$o.textContent=vi,yt=n(),m(no.$$.fragment),Mt=n(),H=r("div"),m(io.$$.fragment),Xn=n(),Zo=r("p"),Zo.textContent=wi,Vt=n(),m(so.$$.fragment),Ct=n(),Bo=r("p"),this.h()},l(e){const t=Ci("svelte-u9bgzb",document.head);c=l(t,"META",{name:!0,content:!0}),t.forEach(o),C=i(e),v=l(e,"P",{}),y(v).forEach(o),b=i(e),g(w.$$.fragment,e),d=i(e),T=l(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1jx3rme"&&(T.innerHTML=Un),No=i(e),ae=l(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1cwsb16"&&(ae.textContent=jn),Fo=i(e),re=l(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-19oae4l"&&(re.innerHTML=kn),Ro=i(e),g(z.$$.fragment,e),zo=i(e),le=l(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-14a2tju"&&(le.innerHTML=$n),Yo=i(e),de=l(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-edcre8"&&(de.innerHTML=Zn),qo=i(e),pe=l(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-e2d2m8"&&(pe.innerHTML=Pn),Lo=i(e),ce=l(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1dritjd"&&(ce.textContent=Gn),Do=i(e),me=l(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-2qusrd"&&(me.innerHTML=Wn),Eo=i(e),ge=l(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-x19y24"&&(ge.innerHTML=Bn),So=i(e),g(ue.$$.fragment,e),Qo=i(e),fe=l(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-iekg51"&&(fe.innerHTML=Hn),Ao=i(e),he=l(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-jub7f1"&&(he.textContent=Nn),Oo=i(e),g(_e.$$.fragment,e),Ko=i(e),be=l(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-a3ahk3"&&(be.textContent=Fn),et=i(e),g(ve.$$.fragment,e),ot=i(e),we=l(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1p91erm"&&(we.innerHTML=Rn),tt=i(e),g(Te.$$.fragment,e),nt=i(e),ye=l(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-oyjtrh"&&(ye.textContent=zn),it=i(e),g(Me.$$.fragment,e),st=i(e),Ve=l(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1ri8bb"&&(Ve.innerHTML=Yn),at=i(e),g(Ce.$$.fragment,e),rt=i(e),g(xe.$$.fragment,e),lt=i(e),Je=l(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1wycjro"&&(Je.innerHTML=qn),dt=i(e),Ie=l(e,"UL",{"data-svelte-h":!0}),p(Ie)!=="svelte-195dfo2"&&(Ie.innerHTML=Ln),pt=i(e),g(Xe.$$.fragment,e),ct=i(e),Ue=l(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1elq2ob"&&(Ue.innerHTML=Dn),mt=i(e),je=l(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-9tb0fb"&&(je.innerHTML=En),gt=i(e),ke=l(e,"UL",{"data-svelte-h":!0}),p(ke)!=="svelte-190pde7"&&(ke.innerHTML=Sn),ut=i(e),g($e.$$.fragment,e),ft=i(e),x=l(e,"DIV",{class:!0});var U=y(x);g(Ze.$$.fragment,U),Bt=i(U),po=l(U,"P",{"data-svelte-h":!0}),p(po)!=="svelte-gmblkq"&&(po.textContent=Qn),Ht=i(U),co=l(U,"P",{"data-svelte-h":!0}),p(co)!=="svelte-wu1jmh"&&(co.innerHTML=An),Nt=i(U),P=l(U,"DIV",{class:!0});var N=y(P);g(Pe.$$.fragment,N),Ft=i(N),mo=l(N,"P",{"data-svelte-h":!0}),p(mo)!=="svelte-v78lg8"&&(mo.textContent=On),Rt=i(N),g(Y.$$.fragment,N),N.forEach(o),zt=i(U),q=l(U,"DIV",{class:!0});var ao=y(q);g(Ge.$$.fragment,ao),Yt=i(ao),go=l(ao,"P",{"data-svelte-h":!0}),p(go)!=="svelte-16q0ax1"&&(go.textContent=Kn),ao.forEach(o),qt=i(U),L=l(U,"DIV",{class:!0});var ro=y(L);g(We.$$.fragment,ro),Lt=i(ro),uo=l(ro,"P",{"data-svelte-h":!0}),p(uo)!=="svelte-1vadzv1"&&(uo.textContent=ei),ro.forEach(o),Dt=i(U),D=l(U,"DIV",{class:!0});var lo=y(D);g(Be.$$.fragment,lo),Et=i(lo),fo=l(lo,"P",{"data-svelte-h":!0}),p(fo)!=="svelte-fohozp"&&(fo.textContent=oi),lo.forEach(o),U.forEach(o),ht=i(e),g(He.$$.fragment,e),_t=i(e),J=l(e,"DIV",{class:!0});var j=y(J);g(Ne.$$.fragment,j),St=i(j),ho=l(j,"P",{"data-svelte-h":!0}),p(ho)!=="svelte-cngl0i"&&(ho.textContent=ti),Qt=i(j),_o=l(j,"P",{"data-svelte-h":!0}),p(_o)!=="svelte-wu1jmh"&&(_o.innerHTML=ni),At=i(j),G=l(j,"DIV",{class:!0});var Po=y(G);g(Fe.$$.fragment,Po),Ot=i(Po),bo=l(Po,"P",{"data-svelte-h":!0}),p(bo)!=="svelte-v78lg8"&&(bo.textContent=ii),Kt=i(Po),g(E.$$.fragment,Po),Po.forEach(o),en=i(j),S=l(j,"DIV",{class:!0});var Jt=y(S);g(Re.$$.fragment,Jt),on=i(Jt),vo=l(Jt,"P",{"data-svelte-h":!0}),p(vo)!=="svelte-16q0ax1"&&(vo.textContent=si),Jt.forEach(o),tn=i(j),Q=l(j,"DIV",{class:!0});var It=y(Q);g(ze.$$.fragment,It),nn=i(It),wo=l(It,"P",{"data-svelte-h":!0}),p(wo)!=="svelte-1vadzv1"&&(wo.textContent=ai),It.forEach(o),sn=i(j),A=l(j,"DIV",{class:!0});var Xt=y(A);g(Ye.$$.fragment,Xt),an=i(Xt),To=l(Xt,"P",{"data-svelte-h":!0}),p(To)!=="svelte-fohozp"&&(To.textContent=ri),Xt.forEach(o),j.forEach(o),bt=i(e),g(qe.$$.fragment,e),vt=i(e),I=l(e,"DIV",{class:!0});var k=y(I);g(Le.$$.fragment,k),rn=i(k),yo=l(k,"P",{"data-svelte-h":!0}),p(yo)!=="svelte-4lf8uk"&&(yo.textContent=li),ln=i(k),Mo=l(k,"P",{"data-svelte-h":!0}),p(Mo)!=="svelte-wu1jmh"&&(Mo.innerHTML=di),dn=i(k),W=l(k,"DIV",{class:!0});var Go=y(W);g(De.$$.fragment,Go),pn=i(Go),Vo=l(Go,"P",{"data-svelte-h":!0}),p(Vo)!=="svelte-v78lg8"&&(Vo.textContent=pi),cn=i(Go),g(O.$$.fragment,Go),Go.forEach(o),mn=i(k),K=l(k,"DIV",{class:!0});var Ut=y(K);g(Ee.$$.fragment,Ut),gn=i(Ut),Co=l(Ut,"P",{"data-svelte-h":!0}),p(Co)!=="svelte-16q0ax1"&&(Co.textContent=ci),Ut.forEach(o),un=i(k),ee=l(k,"DIV",{class:!0});var jt=y(ee);g(Se.$$.fragment,jt),fn=i(jt),xo=l(jt,"P",{"data-svelte-h":!0}),p(xo)!=="svelte-1vadzv1"&&(xo.textContent=mi),jt.forEach(o),hn=i(k),oe=l(k,"DIV",{class:!0});var kt=y(oe);g(Qe.$$.fragment,kt),_n=i(kt),Jo=l(kt,"P",{"data-svelte-h":!0}),p(Jo)!=="svelte-fohozp"&&(Jo.textContent=gi),kt.forEach(o),k.forEach(o),wt=i(e),g(Ae.$$.fragment,e),Tt=i(e),X=l(e,"DIV",{class:!0});var $=y(X);g(Oe.$$.fragment,$),bn=i($),Io=l($,"P",{"data-svelte-h":!0}),p(Io)!=="svelte-8tkh5d"&&(Io.textContent=ui),vn=i($),Xo=l($,"P",{"data-svelte-h":!0}),p(Xo)!=="svelte-wu1jmh"&&(Xo.innerHTML=fi),wn=i($),B=l($,"DIV",{class:!0});var Wo=y(B);g(Ke.$$.fragment,Wo),Tn=i(Wo),Uo=l(Wo,"P",{"data-svelte-h":!0}),p(Uo)!=="svelte-v78lg8"&&(Uo.textContent=hi),yn=i(Wo),g(te.$$.fragment,Wo),Wo.forEach(o),Mn=i($),ne=l($,"DIV",{class:!0});var $t=y(ne);g(eo.$$.fragment,$t),Vn=i($t),jo=l($t,"P",{"data-svelte-h":!0}),p(jo)!=="svelte-16q0ax1"&&(jo.textContent=_i),$t.forEach(o),Cn=i($),ie=l($,"DIV",{class:!0});var Zt=y(ie);g(oo.$$.fragment,Zt),xn=i(Zt),ko=l(Zt,"P",{"data-svelte-h":!0}),p(ko)!=="svelte-1vadzv1"&&(ko.textContent=bi),Zt.forEach(o),Jn=i($),se=l($,"DIV",{class:!0});var Pt=y(se);g(to.$$.fragment,Pt),In=i(Pt),$o=l(Pt,"P",{"data-svelte-h":!0}),p($o)!=="svelte-fohozp"&&($o.textContent=vi),Pt.forEach(o),$.forEach(o),yt=i(e),g(no.$$.fragment,e),Mt=i(e),H=l(e,"DIV",{class:!0});var Gt=y(H);g(io.$$.fragment,Gt),Xn=i(Gt),Zo=l(Gt,"P",{"data-svelte-h":!0}),p(Zo)!=="svelte-1qnvsrt"&&(Zo.textContent=wi),Gt.forEach(o),Vt=i(e),g(so.$$.fragment,e),Ct=i(e),Bo=l(e,"P",{}),y(Bo).forEach(o),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",Zi),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,c),a(e,C,t),a(e,v,t),a(e,b,t),u(w,e,t),a(e,d,t),a(e,T,t),a(e,No,t),a(e,ae,t),a(e,Fo,t),a(e,re,t),a(e,Ro,t),u(z,e,t),a(e,zo,t),a(e,le,t),a(e,Yo,t),a(e,de,t),a(e,qo,t),a(e,pe,t),a(e,Lo,t),a(e,ce,t),a(e,Do,t),a(e,me,t),a(e,Eo,t),a(e,ge,t),a(e,So,t),u(ue,e,t),a(e,Qo,t),a(e,fe,t),a(e,Ao,t),a(e,he,t),a(e,Oo,t),u(_e,e,t),a(e,Ko,t),a(e,be,t),a(e,et,t),u(ve,e,t),a(e,ot,t),a(e,we,t),a(e,tt,t),u(Te,e,t),a(e,nt,t),a(e,ye,t),a(e,it,t),u(Me,e,t),a(e,st,t),a(e,Ve,t),a(e,at,t),u(Ce,e,t),a(e,rt,t),u(xe,e,t),a(e,lt,t),a(e,Je,t),a(e,dt,t),a(e,Ie,t),a(e,pt,t),u(Xe,e,t),a(e,ct,t),a(e,Ue,t),a(e,mt,t),a(e,je,t),a(e,gt,t),a(e,ke,t),a(e,ut,t),u($e,e,t),a(e,ft,t),a(e,x,t),u(Ze,x,null),s(x,Bt),s(x,po),s(x,Ht),s(x,co),s(x,Nt),s(x,P),u(Pe,P,null),s(P,Ft),s(P,mo),s(P,Rt),u(Y,P,null),s(x,zt),s(x,q),u(Ge,q,null),s(q,Yt),s(q,go),s(x,qt),s(x,L),u(We,L,null),s(L,Lt),s(L,uo),s(x,Dt),s(x,D),u(Be,D,null),s(D,Et),s(D,fo),a(e,ht,t),u(He,e,t),a(e,_t,t),a(e,J,t),u(Ne,J,null),s(J,St),s(J,ho),s(J,Qt),s(J,_o),s(J,At),s(J,G),u(Fe,G,null),s(G,Ot),s(G,bo),s(G,Kt),u(E,G,null),s(J,en),s(J,S),u(Re,S,null),s(S,on),s(S,vo),s(J,tn),s(J,Q),u(ze,Q,null),s(Q,nn),s(Q,wo),s(J,sn),s(J,A),u(Ye,A,null),s(A,an),s(A,To),a(e,bt,t),u(qe,e,t),a(e,vt,t),a(e,I,t),u(Le,I,null),s(I,rn),s(I,yo),s(I,ln),s(I,Mo),s(I,dn),s(I,W),u(De,W,null),s(W,pn),s(W,Vo),s(W,cn),u(O,W,null),s(I,mn),s(I,K),u(Ee,K,null),s(K,gn),s(K,Co),s(I,un),s(I,ee),u(Se,ee,null),s(ee,fn),s(ee,xo),s(I,hn),s(I,oe),u(Qe,oe,null),s(oe,_n),s(oe,Jo),a(e,wt,t),u(Ae,e,t),a(e,Tt,t),a(e,X,t),u(Oe,X,null),s(X,bn),s(X,Io),s(X,vn),s(X,Xo),s(X,wn),s(X,B),u(Ke,B,null),s(B,Tn),s(B,Uo),s(B,yn),u(te,B,null),s(X,Mn),s(X,ne),u(eo,ne,null),s(ne,Vn),s(ne,jo),s(X,Cn),s(X,ie),u(oo,ie,null),s(ie,xn),s(ie,ko),s(X,Jn),s(X,se),u(to,se,null),s(se,In),s(se,$o),a(e,yt,t),u(no,e,t),a(e,Mt,t),a(e,H,t),u(io,H,null),s(H,Xn),s(H,Zo),a(e,Vt,t),u(so,e,t),a(e,Ct,t),a(e,Bo,t),xt=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),z.$set(U);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),Y.$set(N);const ao={};t&2&&(ao.$$scope={dirty:t,ctx:e}),E.$set(ao);const ro={};t&2&&(ro.$$scope={dirty:t,ctx:e}),O.$set(ro);const lo={};t&2&&(lo.$$scope={dirty:t,ctx:e}),te.$set(lo)},i(e){xt||(f(w.$$.fragment,e),f(z.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(Me.$$.fragment,e),f(Ce.$$.fragment,e),f(xe.$$.fragment,e),f(Xe.$$.fragment,e),f($e.$$.fragment,e),f(Ze.$$.fragment,e),f(Pe.$$.fragment,e),f(Y.$$.fragment,e),f(Ge.$$.fragment,e),f(We.$$.fragment,e),f(Be.$$.fragment,e),f(He.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(E.$$.fragment,e),f(Re.$$.fragment,e),f(ze.$$.fragment,e),f(Ye.$$.fragment,e),f(qe.$$.fragment,e),f(Le.$$.fragment,e),f(De.$$.fragment,e),f(O.$$.fragment,e),f(Ee.$$.fragment,e),f(Se.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(te.$$.fragment,e),f(eo.$$.fragment,e),f(oo.$$.fragment,e),f(to.$$.fragment,e),f(no.$$.fragment,e),f(io.$$.fragment,e),f(so.$$.fragment,e),xt=!0)},o(e){h(w.$$.fragment,e),h(z.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(Ce.$$.fragment,e),h(xe.$$.fragment,e),h(Xe.$$.fragment,e),h($e.$$.fragment,e),h(Ze.$$.fragment,e),h(Pe.$$.fragment,e),h(Y.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(He.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(E.$$.fragment,e),h(Re.$$.fragment,e),h(ze.$$.fragment,e),h(Ye.$$.fragment,e),h(qe.$$.fragment,e),h(Le.$$.fragment,e),h(De.$$.fragment,e),h(O.$$.fragment,e),h(Ee.$$.fragment,e),h(Se.$$.fragment,e),h(Qe.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(te.$$.fragment,e),h(eo.$$.fragment,e),h(oo.$$.fragment,e),h(to.$$.fragment,e),h(no.$$.fragment,e),h(io.$$.fragment,e),h(so.$$.fragment,e),xt=!1},d(e){e&&(o(C),o(v),o(b),o(d),o(T),o(No),o(ae),o(Fo),o(re),o(Ro),o(zo),o(le),o(Yo),o(de),o(qo),o(pe),o(Lo),o(ce),o(Do),o(me),o(Eo),o(ge),o(So),o(Qo),o(fe),o(Ao),o(he),o(Oo),o(Ko),o(be),o(et),o(ot),o(we),o(tt),o(nt),o(ye),o(it),o(st),o(Ve),o(at),o(rt),o(lt),o(Je),o(dt),o(Ie),o(pt),o(ct),o(Ue),o(mt),o(je),o(gt),o(ke),o(ut),o(ft),o(x),o(ht),o(_t),o(J),o(bt),o(vt),o(I),o(wt),o(Tt),o(X),o(yt),o(Mt),o(H),o(Vt),o(Ct),o(Bo)),o(c),_(w,e),_(z,e),_(ue,e),_(_e,e),_(ve,e),_(Te,e),_(Me,e),_(Ce,e),_(xe,e),_(Xe,e),_($e,e),_(Ze),_(Pe),_(Y),_(Ge),_(We),_(Be),_(He,e),_(Ne),_(Fe),_(E),_(Re),_(ze),_(Ye),_(qe,e),_(Le),_(De),_(O),_(Ee),_(Se),_(Qe),_(Ae,e),_(Oe),_(Ke),_(te),_(eo),_(oo),_(to),_(no,e),_(io),_(so,e)}}}const Zi='{"title":"CogVideoX","local":"cogvideox","sections":[{"title":"Inference","local":"inference","sections":[{"title":"Memory optimization","local":"memory-optimization","sections":[],"depth":3},{"title":"Quantized inference","local":"quantized-inference","sections":[],"depth":3}],"depth":2},{"title":"CogVideoXPipeline","local":"diffusers.CogVideoXPipeline","sections":[],"depth":2},{"title":"CogVideoXImageToVideoPipeline","local":"diffusers.CogVideoXImageToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXVideoToVideoPipeline","local":"diffusers.CogVideoXVideoToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXFunControlPipeline","local":"diffusers.CogVideoXFunControlPipeline","sections":[],"depth":2},{"title":"CogVideoXPipelineOutput","local":"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput","sections":[],"depth":2}],"depth":1}';function Pi(Z){return yi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zi extends Mi{constructor(c){super(),Vi(this,c,Pi,$i,Ti,{})}}export{zi as component};
