import{s as jl,n as gl,o as Cl}from"../chunks/scheduler.182ea377.js";import{S as Zl,i as Il,g as i,s as a,r,A as Nl,h as p,f as l,c as n,j as bl,u as c,x as o,k as _l,y as Xl,a as s,v as m,d as M,t as u,w as f}from"../chunks/index.abf12888.js";import{C as d}from"../chunks/CodeBlock.57fe6e13.js";import{H as h}from"../chunks/Heading.16916d63.js";function Wl(Bt){let w,Ie,Ce,Ne,y,Xe,T,Ft=`<a href="https://arxiv.org/abs/2212.04488" rel="nofollow">Custom Diffusion</a> is a method to customize text-to-image models like Stable Diffusion given just a few (4~5) images of a subject.
The <code>train_custom_diffusion.py</code> script shows how to implement the training procedure and adapt it for stable diffusion.`,We,U,kt='This training example was contributed by <a href="https://nupurkmr9.github.io/" rel="nofollow">Nupur Kumari</a> (one of the authors of Custom Diffusion).',ve,J,$e,b,Ve,_,zt="Before running the scripts, make sure to install the library’s training dependencies:",Re,j,Yt="<strong>Important</strong>",Ee,g,Ht="To make sure you can successfully run the latest versions of the example scripts, we highly recommend <strong>installing from source</strong> and keeping the install up to date as we update the example scripts frequently and install some example-specific requirements. To do this, execute the following steps in a new virtual environment:",xe,C,Ge,Z,Lt='Then cd into the <a href="https://github.com/huggingface/diffusers/tree/main/examples/custom_diffusion" rel="nofollow">example folder</a>',Be,I,Fe,N,Qt="Now run",ke,X,ze,W,St='And initialize an <a href="https://github.com/huggingface/accelerate/" rel="nofollow">🤗Accelerate</a> environment with:',Ye,v,He,$,At="Or for a default accelerate configuration without answering questions about your environment",Le,V,Qe,R,qt="Or if your environment doesn’t support an interactive shell e.g. a notebook",Se,E,Ae,x,qe,G,Dt='Now let’s get our dataset. Download dataset from <a href="https://www.cs.cmu.edu/~custom-diffusion/assets/data.zip" rel="nofollow">here</a> and unzip it. To use your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide.',De,B,Pt=`We also collect 200 real images using <code>clip-retrieval</code> which are combined with the target images in the training dataset as a regularization. This prevents overfitting to the given target image. The following flags enable the regularization <code>with_prior_preservation</code>, <code>real_prior</code> with <code>prior_loss_weight=1.</code>.
The <code>class_prompt</code> should be the category name same as target image. The collected real images are with text captions similar to the <code>class_prompt</code>. The retrieved image are saved in <code>class_data_dir</code>. You can disable <code>real_prior</code> to use generated images as regularization. To collect the real images use this command first before training.`,Pe,F,Oe,k,Ot='<strong><strong><em>Note: Change the <code>resolution</code> to 768 if you are using the <a href="https://huggingface.co/stabilityai/stable-diffusion-2" rel="nofollow">stable-diffusion-2</a> 768x768 model.</em></strong></strong>',Ke,z,Kt="The script creates and saves model checkpoints and a <code>pytorch_custom_diffusion_weights.bin</code> file in your repository.",et,Y,tt,H,el='<strong>Use <code>--enable_xformers_memory_efficient_attention</code> for faster training with lower VRAM requirement (16GB per GPU). Follow <a href="https://github.com/facebookresearch/xformers" rel="nofollow">this guide</a> for installation instructions.</strong>',lt,L,tl="To track your experiments using Weights and Biases (<code>wandb</code>) and to save intermediate results (which we HIGHLY recommend), follow these steps:",st,Q,ll="<li>Install <code>wandb</code>: <code>pip install wandb</code>.</li> <li>Authorize: <code>wandb login</code>.</li> <li>Then specify a <code>validation_prompt</code> and set <code>report_to</code> to <code>wandb</code> while launching training. You can also configure the following related arguments:<ul><li><code>num_validation_images</code></li> <li><code>validation_steps</code></li></ul></li>",at,S,sl="Here is an example command:",nt,A,it,q,al='Here is an example <a href="https://wandb.ai/sayakpaul/custom-diffusion/runs/26ghrcau" rel="nofollow">Weights and Biases page</a> where you can check out the intermediate results along with other training details.',pt,D,nl='If you specify <code>--push_to_hub</code>, the learned parameters will be pushed to a repository on the Hugging Face Hub. Here is an <a href="https://huggingface.co/sayakpaul/custom-diffusion-cat" rel="nofollow">example repository</a>.',ot,P,rt,O,il='Provide a <a href="https://github.com/adobe-research/custom-diffusion/blob/main/assets/concept_list.json" rel="nofollow">json</a> file with the info about each concept, similar to <a href="https://github.com/ShivamShrirao/diffusers/blob/main/examples/dreambooth/train_dreambooth.py" rel="nofollow">this</a>.',ct,K,pl="To collect the real images run this command for each concept in the json file.",mt,ee,Mt,te,ol="And then we’re ready to start training!",ut,le,ft,se,rl='Here is an example <a href="https://wandb.ai/sayakpaul/custom-diffusion/runs/3990tzkg" rel="nofollow">Weights and Biases page</a> where you can check out the intermediate results along with other training details.',dt,ae,ht,ne,cl="For fine-tuning on human faces we found the following configuration to work better: <code>learning_rate=5e-6</code>, <code>max_train_steps=1000 to 2000</code>, and <code>freeze_model=crossattn</code> with at least 15-20 images.",wt,ie,ml="To collect the real images use this command first before training.",yt,pe,Tt,oe,Ml="Then start training!",Ut,re,Jt,ce,bt,me,ul="Once you have trained a model using the above command, you can run inference using the below command. Make sure to include the <code>modifier token</code> (e.g. \\&lt;new1&gt; in above example) in your prompt.",_t,Me,jt,ue,fl="It’s possible to directly load these parameters from a Hub repository:",gt,fe,Ct,de,dl="Here is an example of performing inference with multiple concepts:",Zt,he,It,we,hl="Here, <code>cat</code> and <code>wooden pot</code> refer to the multiple concepts.",Nt,ye,Xt,Te,wl="You can also perform inference from one of the complete checkpoint saved during the training process, if you used the <code>--checkpointing_steps</code> argument.",Wt,Ue,yl="TODO.",vt,Je,$t,be,Tl="To save even more memory, pass the <code>--set_grads_to_none</code> argument to the script. This will set grads to None instead of zero. However, be aware that it changes certain behaviors, so if you start experiencing any problems, remove this argument.",Vt,_e,Ul='More info: <a href="https://pytorch.org/docs/stable/generated/torch.optim.Optimizer.zero_grad.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.optim.Optimizer.zero_grad.html</a>',Rt,je,Et,ge,Jl='You can refer to <a href="https://www.cs.cmu.edu/~custom-diffusion/" rel="nofollow">our webpage</a> that discusses our experiments in detail.',xt,Ze,Gt;return y=new h({props:{title:"Custom Diffusion training example",local:"custom-diffusion-training-example",headingTag:"h1"}}),J=new h({props:{title:"Running locally with PyTorch",local:"running-locally-with-pytorch",headingTag:"h2"}}),b=new h({props:{title:"Installing the dependencies",local:"installing-the-dependencies",headingTag:"h3"}}),C=new d({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC1lJTIwLg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install -e .`,wrap:!1}}),I=new d({props:{code:"Y2QlMjBleGFtcGxlcyUyRmN1c3RvbV9kaWZmdXNpb24=",highlighted:'<span class="hljs-built_in">cd</span> examples/custom_diffusion',wrap:!1}}),X=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dCUwQXBpcCUyMGluc3RhbGwlMjBjbGlwLXJldHJpZXZhbCUyMA==",highlighted:`pip install -r requirements.txt
pip install clip-retrieval `,wrap:!1}}),v=new d({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),V=new d({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),E=new d({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),x=new h({props:{title:"Cat example 😺",local:"cat-example-",headingTag:"h3"}}),F=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGNsaXAtcmV0cmlldmFsJTBBcHl0aG9uJTIwcmV0cmlldmUucHklMjAtLWNsYXNzX3Byb21wdCUyMGNhdCUyMC0tY2xhc3NfZGF0YV9kaXIlMjByZWFsX3JlZyUyRnNhbXBsZXNfY2F0JTIwLS1udW1fY2xhc3NfaW1hZ2VzJTIwMjAw",highlighted:`pip install clip-retrieval
python retrieve.py --class_prompt <span class="hljs-built_in">cat</span> --class_data_dir real_reg/samples_cat --num_class_images 200`,wrap:!1}}),Y=new d({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aC10by1zYXZlLW1vZGVsJTIyJTBBZXhwb3J0JTIwSU5TVEFOQ0VfRElSJTNEJTIyLiUyRmRhdGElMkZjYXQlMjIlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwdHJhaW5fY3VzdG9tX2RpZmZ1c2lvbi5weSUyMCU1QyUwQSUyMCUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9OQU1FJTIwJTIwJTVDJTBBJTIwJTIwLS1pbnN0YW5jZV9kYXRhX2RpciUzRCUyNElOU1RBTkNFX0RJUiUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAlMjAtLWNsYXNzX2RhdGFfZGlyJTNELiUyRnJlYWxfcmVnJTJGc2FtcGxlc19jYXQlMkYlMjAlNUMlMEElMjAlMjAtLXdpdGhfcHJpb3JfcHJlc2VydmF0aW9uJTIwLS1yZWFsX3ByaW9yJTIwLS1wcmlvcl9sb3NzX3dlaWdodCUzRDEuMCUyMCU1QyUwQSUyMCUyMC0tY2xhc3NfcHJvbXB0JTNEJTIyY2F0JTIyJTIwLS1udW1fY2xhc3NfaW1hZ2VzJTNEMjAwJTIwJTVDJTBBJTIwJTIwLS1pbnN0YW5jZV9wcm9tcHQlM0QlMjJwaG90byUyMG9mJTIwYSUyMCUzQ25ldzElM0UlMjBjYXQlMjIlMjAlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QyJTIwJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNSUyMCUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNEMCUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMjUwJTIwJTVDJTBBJTIwJTIwLS1zY2FsZV9sciUyMC0taGZsaXAlMjAlMjAlNUMlMEElMjAlMjAtLW1vZGlmaWVyX3Rva2VuJTIwJTIyJTNDbmV3MSUzRSUyMiUyMCU1QyUwQSUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path-to-save-model&quot;</span>
<span class="hljs-built_in">export</span> INSTANCE_DIR=<span class="hljs-string">&quot;./data/cat&quot;</span>

accelerate launch train_custom_diffusion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --instance_data_dir=<span class="hljs-variable">$INSTANCE_DIR</span> \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --class_data_dir=./real_reg/samples_cat/ \\
  --with_prior_preservation --real_prior --prior_loss_weight=1.0 \\
  --class_prompt=<span class="hljs-string">&quot;cat&quot;</span> --num_class_images=200 \\
  --instance_prompt=<span class="hljs-string">&quot;photo of a &lt;new1&gt; cat&quot;</span>  \\
  --resolution=512  \\
  --train_batch_size=2  \\
  --learning_rate=1e-5  \\
  --lr_warmup_steps=0 \\
  --max_train_steps=250 \\
  --scale_lr --hflip  \\
  --modifier_token <span class="hljs-string">&quot;&lt;new1&gt;&quot;</span> \\
  --push_to_hub`,wrap:!1}}),A=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2N1c3RvbV9kaWZmdXNpb24ucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCUyMCU1QyUwQSUyMCUyMC0taW5zdGFuY2VfZGF0YV9kaXIlM0QlMjRJTlNUQU5DRV9ESVIlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwJTIwLS1jbGFzc19kYXRhX2RpciUzRC4lMkZyZWFsX3JlZyUyRnNhbXBsZXNfY2F0JTJGJTIwJTVDJTBBJTIwJTIwLS13aXRoX3ByaW9yX3ByZXNlcnZhdGlvbiUyMC0tcmVhbF9wcmlvciUyMC0tcHJpb3JfbG9zc193ZWlnaHQlM0QxLjAlMjAlNUMlMEElMjAlMjAtLWNsYXNzX3Byb21wdCUzRCUyMmNhdCUyMiUyMC0tbnVtX2NsYXNzX2ltYWdlcyUzRDIwMCUyMCU1QyUwQSUyMCUyMC0taW5zdGFuY2VfcHJvbXB0JTNEJTIycGhvdG8lMjBvZiUyMGElMjAlM0NuZXcxJTNFJTIwY2F0JTIyJTIwJTIwJTVDJTBBJTIwJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwJTIwJTVDJTBBJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMiUyMCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMjAlMjAlNUMlMEElMjAlMjAtLWxyX3dhcm11cF9zdGVwcyUzRDAlMjAlNUMlMEElMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDI1MCUyMCU1QyUwQSUyMCUyMC0tc2NhbGVfbHIlMjAtLWhmbGlwJTIwJTIwJTVDJTBBJTIwJTIwLS1tb2RpZmllcl90b2tlbiUyMCUyMiUzQ25ldzElM0UlMjIlMjAlNUMlMEElMjAlMjAtLXZhbGlkYXRpb25fcHJvbXB0JTNEJTIyJTNDbmV3MSUzRSUyMGNhdCUyMHNpdHRpbmclMjBpbiUyMGElMjBidWNrZXQlMjIlMjAlNUMlMEElMjAlMjAtLXJlcG9ydF90byUzRCUyMndhbmRiJTIyJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`accelerate launch train_custom_diffusion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --instance_data_dir=<span class="hljs-variable">$INSTANCE_DIR</span> \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --class_data_dir=./real_reg/samples_cat/ \\
  --with_prior_preservation --real_prior --prior_loss_weight=1.0 \\
  --class_prompt=<span class="hljs-string">&quot;cat&quot;</span> --num_class_images=200 \\
  --instance_prompt=<span class="hljs-string">&quot;photo of a &lt;new1&gt; cat&quot;</span>  \\
  --resolution=512  \\
  --train_batch_size=2  \\
  --learning_rate=1e-5  \\
  --lr_warmup_steps=0 \\
  --max_train_steps=250 \\
  --scale_lr --hflip  \\
  --modifier_token <span class="hljs-string">&quot;&lt;new1&gt;&quot;</span> \\
  --validation_prompt=<span class="hljs-string">&quot;&lt;new1&gt; cat sitting in a bucket&quot;</span> \\
  --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
  --push_to_hub`,wrap:!1}}),P=new h({props:{title:"Training on multiple concepts 🐱🪵",local:"training-on-multiple-concepts-",headingTag:"h3"}}),ee=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGNsaXAtcmV0cmlldmFsJTBBcHl0aG9uJTIwcmV0cmlldmUucHklMjAtLWNsYXNzX3Byb21wdCUyMCU3QiU3RCUyMC0tY2xhc3NfZGF0YV9kaXIlMjAlN0IlN0QlMjAtLW51bV9jbGFzc19pbWFnZXMlMjAyMDA=",highlighted:`pip install clip-retrieval
python retrieve.py --class_prompt {} --class_data_dir {} --num_class_images 200`,wrap:!1}}),le=new d({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aC10by1zYXZlLW1vZGVsJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2N1c3RvbV9kaWZmdXNpb24ucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAlMjAtLWNvbmNlcHRzX2xpc3QlM0QuJTJGY29uY2VwdF9saXN0Lmpzb24lMjAlNUMlMEElMjAlMjAtLXdpdGhfcHJpb3JfcHJlc2VydmF0aW9uJTIwLS1yZWFsX3ByaW9yJTIwLS1wcmlvcl9sb3NzX3dlaWdodCUzRDEuMCUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMCUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDIlMjAlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS01JTIwJTIwJTVDJTBBJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0Q1MDAlMjAlNUMlMEElMjAlMjAtLW51bV9jbGFzc19pbWFnZXMlM0QyMDAlMjAlNUMlMEElMjAlMjAtLXNjYWxlX2xyJTIwLS1oZmxpcCUyMCUyMCU1QyUwQSUyMCUyMC0tbW9kaWZpZXJfdG9rZW4lMjAlMjIlM0NuZXcxJTNFJTJCJTNDbmV3MiUzRSUyMiUyMCU1QyUwQSUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path-to-save-model&quot;</span>

accelerate launch train_custom_diffusion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --concepts_list=./concept_list.json \\
  --with_prior_preservation --real_prior --prior_loss_weight=1.0 \\
  --resolution=512  \\
  --train_batch_size=2  \\
  --learning_rate=1e-5  \\
  --lr_warmup_steps=0 \\
  --max_train_steps=500 \\
  --num_class_images=200 \\
  --scale_lr --hflip  \\
  --modifier_token <span class="hljs-string">&quot;&lt;new1&gt;+&lt;new2&gt;&quot;</span> \\
  --push_to_hub`,wrap:!1}}),ae=new h({props:{title:"Training on human faces",local:"training-on-human-faces",headingTag:"h3"}}),pe=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGNsaXAtcmV0cmlldmFsJTBBcHl0aG9uJTIwcmV0cmlldmUucHklMjAtLWNsYXNzX3Byb21wdCUyMHBlcnNvbiUyMC0tY2xhc3NfZGF0YV9kaXIlMjByZWFsX3JlZyUyRnNhbXBsZXNfcGVyc29uJTIwLS1udW1fY2xhc3NfaW1hZ2VzJTIwMjAw",highlighted:`pip install clip-retrieval
python retrieve.py --class_prompt person --class_data_dir real_reg/samples_person --num_class_images 200`,wrap:!1}}),re=new d({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aC10by1zYXZlLW1vZGVsJTIyJTBBZXhwb3J0JTIwSU5TVEFOQ0VfRElSJTNEJTIycGF0aC10by1pbWFnZXMlMjIlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwdHJhaW5fY3VzdG9tX2RpZmZ1c2lvbi5weSUyMCU1QyUwQSUyMCUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9OQU1FJTIwJTIwJTVDJTBBJTIwJTIwLS1pbnN0YW5jZV9kYXRhX2RpciUzRCUyNElOU1RBTkNFX0RJUiUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAlMjAtLWNsYXNzX2RhdGFfZGlyJTNELiUyRnJlYWxfcmVnJTJGc2FtcGxlc19wZXJzb24lMkYlMjAlNUMlMEElMjAlMjAtLXdpdGhfcHJpb3JfcHJlc2VydmF0aW9uJTIwLS1yZWFsX3ByaW9yJTIwLS1wcmlvcl9sb3NzX3dlaWdodCUzRDEuMCUyMCU1QyUwQSUyMCUyMC0tY2xhc3NfcHJvbXB0JTNEJTIycGVyc29uJTIyJTIwLS1udW1fY2xhc3NfaW1hZ2VzJTNEMjAwJTIwJTVDJTBBJTIwJTIwLS1pbnN0YW5jZV9wcm9tcHQlM0QlMjJwaG90byUyMG9mJTIwYSUyMCUzQ25ldzElM0UlMjBwZXJzb24lMjIlMjAlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QyJTIwJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENWUtNiUyMCUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNEMCUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMTAwMCUyMCU1QyUwQSUyMCUyMC0tc2NhbGVfbHIlMjAtLWhmbGlwJTIwLS1ub2F1ZyUyMCU1QyUwQSUyMCUyMC0tZnJlZXplX21vZGVsJTIwY3Jvc3NhdHRuJTIwJTVDJTBBJTIwJTIwLS1tb2RpZmllcl90b2tlbiUyMCUyMiUzQ25ldzElM0UlMjIlMjAlNUMlMEElMjAlMjAtLWVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbiUyMCU1QyUwQSUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path-to-save-model&quot;</span>
<span class="hljs-built_in">export</span> INSTANCE_DIR=<span class="hljs-string">&quot;path-to-images&quot;</span>

accelerate launch train_custom_diffusion.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --instance_data_dir=<span class="hljs-variable">$INSTANCE_DIR</span> \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --class_data_dir=./real_reg/samples_person/ \\
  --with_prior_preservation --real_prior --prior_loss_weight=1.0 \\
  --class_prompt=<span class="hljs-string">&quot;person&quot;</span> --num_class_images=200 \\
  --instance_prompt=<span class="hljs-string">&quot;photo of a &lt;new1&gt; person&quot;</span>  \\
  --resolution=512  \\
  --train_batch_size=2  \\
  --learning_rate=5e-6  \\
  --lr_warmup_steps=0 \\
  --max_train_steps=1000 \\
  --scale_lr --hflip --noaug \\
  --freeze_model crossattn \\
  --modifier_token <span class="hljs-string">&quot;&lt;new1&gt;&quot;</span> \\
  --enable_xformers_memory_efficient_attention \\
  --push_to_hub`,wrap:!1}}),ce=new h({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Me=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUudW5ldC5sb2FkX2F0dG5fcHJvY3MoJTIycGF0aC10by1zYXZlLW1vZGVsJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJweXRvcmNoX2N1c3RvbV9kaWZmdXNpb25fd2VpZ2h0cy5iaW4lMjIpJTBBcGlwZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMnBhdGgtdG8tc2F2ZS1tb2RlbCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyJTNDbmV3MSUzRS5iaW4lMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMCUyMiUzQ25ldzElM0UlMjBjYXQlMjBzaXR0aW5nJTIwaW4lMjBhJTIwYnVja2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENi4wJTJDJTBBJTIwJTIwJTIwJTIwZXRhJTNEMS4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.load_attn_procs(<span class="hljs-string">&quot;path-to-save-model&quot;</span>, weight_name=<span class="hljs-string">&quot;pytorch_custom_diffusion_weights.bin&quot;</span>)
pipe.load_textual_inversion(<span class="hljs-string">&quot;path-to-save-model&quot;</span>, weight_name=<span class="hljs-string">&quot;&lt;new1&gt;.bin&quot;</span>)

image = pipe(
    <span class="hljs-string">&quot;&lt;new1&gt; cat sitting in a bucket&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    guidance_scale=<span class="hljs-number">6.0</span>,
    eta=<span class="hljs-number">1.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),fe=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnJlcG9jYXJkJTIwaW1wb3J0JTIwUmVwb0NhcmQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnNheWFrcGF1bCUyRmN1c3RvbS1kaWZmdXNpb24tY2F0JTIyJTBBY2FyZCUyMCUzRCUyMFJlcG9DYXJkLmxvYWQobW9kZWxfaWQpJTBBYmFzZV9tb2RlbF9pZCUyMCUzRCUyMGNhcmQuZGF0YS50b19kaWN0KCklNUIlMjJiYXNlX21vZGVsJTIyJTVEJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLnVuZXQubG9hZF9hdHRuX3Byb2NzKG1vZGVsX2lkJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJweXRvcmNoX2N1c3RvbV9kaWZmdXNpb25fd2VpZ2h0cy5iaW4lMjIpJTBBcGlwZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKG1vZGVsX2lkJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjIlM0NuZXcxJTNFLmJpbiUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwJTIyJTNDbmV3MSUzRSUyMGNhdCUyMHNpdHRpbmclMjBpbiUyMGElMjBidWNrZXQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q2LjAlMkMlMEElMjAlMjAlMjAlMjBldGElM0QxLjAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;sayakpaul/custom-diffusion-cat&quot;</span>
card = RepoCard.load(model_id)
base_model_id = card.data.to_dict()[<span class="hljs-string">&quot;base_model&quot;</span>]

pipe = DiffusionPipeline.from_pretrained(base_model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.load_attn_procs(model_id, weight_name=<span class="hljs-string">&quot;pytorch_custom_diffusion_weights.bin&quot;</span>)
pipe.load_textual_inversion(model_id, weight_name=<span class="hljs-string">&quot;&lt;new1&gt;.bin&quot;</span>)

image = pipe(
    <span class="hljs-string">&quot;&lt;new1&gt; cat sitting in a bucket&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    guidance_scale=<span class="hljs-number">6.0</span>,
    eta=<span class="hljs-number">1.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),he=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnJlcG9jYXJkJTIwaW1wb3J0JTIwUmVwb0NhcmQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnNheWFrcGF1bCUyRmN1c3RvbS1kaWZmdXNpb24tY2F0LXdvb2Rlbi1wb3QlMjIlMEFjYXJkJTIwJTNEJTIwUmVwb0NhcmQubG9hZChtb2RlbF9pZCklMEFiYXNlX21vZGVsX2lkJTIwJTNEJTIwY2FyZC5kYXRhLnRvX2RpY3QoKSU1QiUyMmJhc2VfbW9kZWwlMjIlNUQlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQXBpcGUudW5ldC5sb2FkX2F0dG5fcHJvY3MobW9kZWxfaWQlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMnB5dG9yY2hfY3VzdG9tX2RpZmZ1c2lvbl93ZWlnaHRzLmJpbiUyMiklMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24obW9kZWxfaWQlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMiUzQ25ldzElM0UuYmluJTIyKSUwQXBpcGUubG9hZF90ZXh0dWFsX2ludmVyc2lvbihtb2RlbF9pZCUyQyUyMHdlaWdodF9uYW1lJTNEJTIyJTNDbmV3MiUzRS5iaW4lMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMCUyMnRoZSUyMCUzQ25ldzElM0UlMjBjYXQlMjBzY3VscHR1cmUlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwJTNDbmV3MiUzRSUyMHdvb2RlbiUyMHBvdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDYuMCUyQyUwQSUyMCUyMCUyMCUyMGV0YSUzRDEuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIybXVsdGktc3ViamVjdC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;sayakpaul/custom-diffusion-cat-wooden-pot&quot;</span>
card = RepoCard.load(model_id)
base_model_id = card.data.to_dict()[<span class="hljs-string">&quot;base_model&quot;</span>]

pipe = DiffusionPipeline.from_pretrained(base_model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.load_attn_procs(model_id, weight_name=<span class="hljs-string">&quot;pytorch_custom_diffusion_weights.bin&quot;</span>)
pipe.load_textual_inversion(model_id, weight_name=<span class="hljs-string">&quot;&lt;new1&gt;.bin&quot;</span>)
pipe.load_textual_inversion(model_id, weight_name=<span class="hljs-string">&quot;&lt;new2&gt;.bin&quot;</span>)

image = pipe(
    <span class="hljs-string">&quot;the &lt;new1&gt; cat sculpture in the style of a &lt;new2&gt; wooden pot&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    guidance_scale=<span class="hljs-number">6.0</span>,
    eta=<span class="hljs-number">1.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;multi-subject.png&quot;</span>)`,wrap:!1}}),ye=new h({props:{title:"Inference from a training checkpoint",local:"inference-from-a-training-checkpoint",headingTag:"h3"}}),Je=new h({props:{title:"Set grads to none",local:"set-grads-to-none",headingTag:"h2"}}),je=new h({props:{title:"Experimental results",local:"experimental-results",headingTag:"h2"}}),{c(){w=i("meta"),Ie=a(),Ce=i("p"),Ne=a(),r(y.$$.fragment),Xe=a(),T=i("p"),T.innerHTML=Ft,We=a(),U=i("p"),U.innerHTML=kt,ve=a(),r(J.$$.fragment),$e=a(),r(b.$$.fragment),Ve=a(),_=i("p"),_.textContent=zt,Re=a(),j=i("p"),j.innerHTML=Yt,Ee=a(),g=i("p"),g.innerHTML=Ht,xe=a(),r(C.$$.fragment),Ge=a(),Z=i("p"),Z.innerHTML=Lt,Be=a(),r(I.$$.fragment),Fe=a(),N=i("p"),N.textContent=Qt,ke=a(),r(X.$$.fragment),ze=a(),W=i("p"),W.innerHTML=St,Ye=a(),r(v.$$.fragment),He=a(),$=i("p"),$.textContent=At,Le=a(),r(V.$$.fragment),Qe=a(),R=i("p"),R.textContent=qt,Se=a(),r(E.$$.fragment),Ae=a(),r(x.$$.fragment),qe=a(),G=i("p"),G.innerHTML=Dt,De=a(),B=i("p"),B.innerHTML=Pt,Pe=a(),r(F.$$.fragment),Oe=a(),k=i("p"),k.innerHTML=Ot,Ke=a(),z=i("p"),z.innerHTML=Kt,et=a(),r(Y.$$.fragment),tt=a(),H=i("p"),H.innerHTML=el,lt=a(),L=i("p"),L.innerHTML=tl,st=a(),Q=i("ul"),Q.innerHTML=ll,at=a(),S=i("p"),S.textContent=sl,nt=a(),r(A.$$.fragment),it=a(),q=i("p"),q.innerHTML=al,pt=a(),D=i("p"),D.innerHTML=nl,ot=a(),r(P.$$.fragment),rt=a(),O=i("p"),O.innerHTML=il,ct=a(),K=i("p"),K.textContent=pl,mt=a(),r(ee.$$.fragment),Mt=a(),te=i("p"),te.textContent=ol,ut=a(),r(le.$$.fragment),ft=a(),se=i("p"),se.innerHTML=rl,dt=a(),r(ae.$$.fragment),ht=a(),ne=i("p"),ne.innerHTML=cl,wt=a(),ie=i("p"),ie.textContent=ml,yt=a(),r(pe.$$.fragment),Tt=a(),oe=i("p"),oe.textContent=Ml,Ut=a(),r(re.$$.fragment),Jt=a(),r(ce.$$.fragment),bt=a(),me=i("p"),me.innerHTML=ul,_t=a(),r(Me.$$.fragment),jt=a(),ue=i("p"),ue.textContent=fl,gt=a(),r(fe.$$.fragment),Ct=a(),de=i("p"),de.textContent=dl,Zt=a(),r(he.$$.fragment),It=a(),we=i("p"),we.innerHTML=hl,Nt=a(),r(ye.$$.fragment),Xt=a(),Te=i("p"),Te.innerHTML=wl,Wt=a(),Ue=i("p"),Ue.textContent=yl,vt=a(),r(Je.$$.fragment),$t=a(),be=i("p"),be.innerHTML=Tl,Vt=a(),_e=i("p"),_e.innerHTML=Ul,Rt=a(),r(je.$$.fragment),Et=a(),ge=i("p"),ge.innerHTML=Jl,xt=a(),Ze=i("p"),this.h()},l(e){const t=Nl("svelte-u9bgzb",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(l),Ie=n(e),Ce=p(e,"P",{}),bl(Ce).forEach(l),Ne=n(e),c(y.$$.fragment,e),Xe=n(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-7g1m04"&&(T.innerHTML=Ft),We=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-34ga73"&&(U.innerHTML=kt),ve=n(e),c(J.$$.fragment,e),$e=n(e),c(b.$$.fragment,e),Ve=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-19lpyev"&&(_.textContent=zt),Re=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-hai21j"&&(j.innerHTML=Yt),Ee=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-yv8b1i"&&(g.innerHTML=Ht),xe=n(e),c(C.$$.fragment,e),Ge=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-16a3qbr"&&(Z.innerHTML=Lt),Be=n(e),c(I.$$.fragment,e),Fe=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1gehqux"&&(N.textContent=Qt),ke=n(e),c(X.$$.fragment,e),ze=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1apictl"&&(W.innerHTML=St),Ye=n(e),c(v.$$.fragment,e),He=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1gl04sb"&&($.textContent=At),Le=n(e),c(V.$$.fragment,e),Qe=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-wgvbkc"&&(R.textContent=qt),Se=n(e),c(E.$$.fragment,e),Ae=n(e),c(x.$$.fragment,e),qe=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-mi9op3"&&(G.innerHTML=Dt),De=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-17sdxu4"&&(B.innerHTML=Pt),Pe=n(e),c(F.$$.fragment,e),Oe=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1i5blgy"&&(k.innerHTML=Ot),Ke=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-153966r"&&(z.innerHTML=Kt),et=n(e),c(Y.$$.fragment,e),tt=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-tbd5vs"&&(H.innerHTML=el),lt=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-lufhu"&&(L.innerHTML=tl),st=n(e),Q=p(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-9ackcj"&&(Q.innerHTML=ll),at=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-6seaxs"&&(S.textContent=sl),nt=n(e),c(A.$$.fragment,e),it=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-12p76wk"&&(q.innerHTML=al),pt=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-18iac8j"&&(D.innerHTML=nl),ot=n(e),c(P.$$.fragment,e),rt=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1cov3v8"&&(O.innerHTML=il),ct=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-7847a2"&&(K.textContent=pl),mt=n(e),c(ee.$$.fragment,e),Mt=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-a50ejr"&&(te.textContent=ol),ut=n(e),c(le.$$.fragment,e),ft=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-ywreuz"&&(se.innerHTML=rl),dt=n(e),c(ae.$$.fragment,e),ht=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1f6cc7q"&&(ne.innerHTML=cl),wt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-14qeal9"&&(ie.textContent=ml),yt=n(e),c(pe.$$.fragment,e),Tt=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1uk21qi"&&(oe.textContent=Ml),Ut=n(e),c(re.$$.fragment,e),Jt=n(e),c(ce.$$.fragment,e),bt=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-bl5npa"&&(me.innerHTML=ul),_t=n(e),c(Me.$$.fragment,e),jt=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1iwuo0e"&&(ue.textContent=fl),gt=n(e),c(fe.$$.fragment,e),Ct=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-14k6lyj"&&(de.textContent=dl),Zt=n(e),c(he.$$.fragment,e),It=n(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1gzxh3x"&&(we.innerHTML=hl),Nt=n(e),c(ye.$$.fragment,e),Xt=n(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-x86osl"&&(Te.innerHTML=wl),Wt=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-hh1j4y"&&(Ue.textContent=yl),vt=n(e),c(Je.$$.fragment,e),$t=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-qp6kgq"&&(be.innerHTML=Tl),Vt=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1vk3rg"&&(_e.innerHTML=Ul),Rt=n(e),c(je.$$.fragment,e),Et=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-3bi6lt"&&(ge.innerHTML=Jl),xt=n(e),Ze=p(e,"P",{}),bl(Ze).forEach(l),this.h()},h(){_l(w,"name","hf:doc:metadata"),_l(w,"content",vl)},m(e,t){Xl(document.head,w),s(e,Ie,t),s(e,Ce,t),s(e,Ne,t),m(y,e,t),s(e,Xe,t),s(e,T,t),s(e,We,t),s(e,U,t),s(e,ve,t),m(J,e,t),s(e,$e,t),m(b,e,t),s(e,Ve,t),s(e,_,t),s(e,Re,t),s(e,j,t),s(e,Ee,t),s(e,g,t),s(e,xe,t),m(C,e,t),s(e,Ge,t),s(e,Z,t),s(e,Be,t),m(I,e,t),s(e,Fe,t),s(e,N,t),s(e,ke,t),m(X,e,t),s(e,ze,t),s(e,W,t),s(e,Ye,t),m(v,e,t),s(e,He,t),s(e,$,t),s(e,Le,t),m(V,e,t),s(e,Qe,t),s(e,R,t),s(e,Se,t),m(E,e,t),s(e,Ae,t),m(x,e,t),s(e,qe,t),s(e,G,t),s(e,De,t),s(e,B,t),s(e,Pe,t),m(F,e,t),s(e,Oe,t),s(e,k,t),s(e,Ke,t),s(e,z,t),s(e,et,t),m(Y,e,t),s(e,tt,t),s(e,H,t),s(e,lt,t),s(e,L,t),s(e,st,t),s(e,Q,t),s(e,at,t),s(e,S,t),s(e,nt,t),m(A,e,t),s(e,it,t),s(e,q,t),s(e,pt,t),s(e,D,t),s(e,ot,t),m(P,e,t),s(e,rt,t),s(e,O,t),s(e,ct,t),s(e,K,t),s(e,mt,t),m(ee,e,t),s(e,Mt,t),s(e,te,t),s(e,ut,t),m(le,e,t),s(e,ft,t),s(e,se,t),s(e,dt,t),m(ae,e,t),s(e,ht,t),s(e,ne,t),s(e,wt,t),s(e,ie,t),s(e,yt,t),m(pe,e,t),s(e,Tt,t),s(e,oe,t),s(e,Ut,t),m(re,e,t),s(e,Jt,t),m(ce,e,t),s(e,bt,t),s(e,me,t),s(e,_t,t),m(Me,e,t),s(e,jt,t),s(e,ue,t),s(e,gt,t),m(fe,e,t),s(e,Ct,t),s(e,de,t),s(e,Zt,t),m(he,e,t),s(e,It,t),s(e,we,t),s(e,Nt,t),m(ye,e,t),s(e,Xt,t),s(e,Te,t),s(e,Wt,t),s(e,Ue,t),s(e,vt,t),m(Je,e,t),s(e,$t,t),s(e,be,t),s(e,Vt,t),s(e,_e,t),s(e,Rt,t),m(je,e,t),s(e,Et,t),s(e,ge,t),s(e,xt,t),s(e,Ze,t),Gt=!0},p:gl,i(e){Gt||(M(y.$$.fragment,e),M(J.$$.fragment,e),M(b.$$.fragment,e),M(C.$$.fragment,e),M(I.$$.fragment,e),M(X.$$.fragment,e),M(v.$$.fragment,e),M(V.$$.fragment,e),M(E.$$.fragment,e),M(x.$$.fragment,e),M(F.$$.fragment,e),M(Y.$$.fragment,e),M(A.$$.fragment,e),M(P.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(fe.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(Je.$$.fragment,e),M(je.$$.fragment,e),Gt=!0)},o(e){u(y.$$.fragment,e),u(J.$$.fragment,e),u(b.$$.fragment,e),u(C.$$.fragment,e),u(I.$$.fragment,e),u(X.$$.fragment,e),u(v.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(x.$$.fragment,e),u(F.$$.fragment,e),u(Y.$$.fragment,e),u(A.$$.fragment,e),u(P.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(ye.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),Gt=!1},d(e){e&&(l(Ie),l(Ce),l(Ne),l(Xe),l(T),l(We),l(U),l(ve),l($e),l(Ve),l(_),l(Re),l(j),l(Ee),l(g),l(xe),l(Ge),l(Z),l(Be),l(Fe),l(N),l(ke),l(ze),l(W),l(Ye),l(He),l($),l(Le),l(Qe),l(R),l(Se),l(Ae),l(qe),l(G),l(De),l(B),l(Pe),l(Oe),l(k),l(Ke),l(z),l(et),l(tt),l(H),l(lt),l(L),l(st),l(Q),l(at),l(S),l(nt),l(it),l(q),l(pt),l(D),l(ot),l(rt),l(O),l(ct),l(K),l(mt),l(Mt),l(te),l(ut),l(ft),l(se),l(dt),l(ht),l(ne),l(wt),l(ie),l(yt),l(Tt),l(oe),l(Ut),l(Jt),l(bt),l(me),l(_t),l(jt),l(ue),l(gt),l(Ct),l(de),l(Zt),l(It),l(we),l(Nt),l(Xt),l(Te),l(Wt),l(Ue),l(vt),l($t),l(be),l(Vt),l(_e),l(Rt),l(Et),l(ge),l(xt),l(Ze)),l(w),f(y,e),f(J,e),f(b,e),f(C,e),f(I,e),f(X,e),f(v,e),f(V,e),f(E,e),f(x,e),f(F,e),f(Y,e),f(A,e),f(P,e),f(ee,e),f(le,e),f(ae,e),f(pe,e),f(re,e),f(ce,e),f(Me,e),f(fe,e),f(he,e),f(ye,e),f(Je,e),f(je,e)}}}const vl='{"title":"Custom Diffusion training example","local":"custom-diffusion-training-example","sections":[{"title":"Running locally with PyTorch","local":"running-locally-with-pytorch","sections":[{"title":"Installing the dependencies","local":"installing-the-dependencies","sections":[],"depth":3},{"title":"Cat example 😺","local":"cat-example-","sections":[],"depth":3},{"title":"Training on multiple concepts 🐱🪵","local":"training-on-multiple-concepts-","sections":[],"depth":3},{"title":"Training on human faces","local":"training-on-human-faces","sections":[],"depth":3}],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"Inference from a training checkpoint","local":"inference-from-a-training-checkpoint","sections":[],"depth":3}],"depth":2},{"title":"Set grads to none","local":"set-grads-to-none","sections":[],"depth":2},{"title":"Experimental results","local":"experimental-results","sections":[],"depth":2}],"depth":1}';function $l(Bt){return Cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gl extends Zl{constructor(w){super(),Il(this,w,$l,Wl,jl,{})}}export{Gl as component};
