import{s as Hs,n as As,o as Fs}from"../chunks/scheduler.39a43cde.js";import{S as Qs,i as xs,g as p,s as n,r,A as zs,h as i,f as e,c as a,j as Ws,u as c,x as M,k as Xs,y as Ys,a as s,v as o,d as y,t as m,w as u}from"../chunks/index.23ec2204.js";import{D as Ss,C as d}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as J,E as qs}from"../chunks/EditOnGithub.f2d09226.js";function Ls(Ae){let T,el,tl,sl,U,nl,j,al,f,Fe='<em>作者: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> 和 <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',pl,w,Qe="在本教程中，你将学习如何在 HF 推理端点上使用 Notus 模型，基于欧洲人工智能法案中的 RAG 指令创建一个合法的偏好数据集。这是一个完整的端到端示例，展示了如何使用 distilabel 来利用大型语言模型（LLMs）！",il,h,xe='<a href="https://github.com/argilla-io/distilabel" rel="nofollow">distilabel</a>是一个人工智能反馈（AIF）框架，它可以使用 LLMs 生成和标注数据集，并且可以用于许多不同的用例。它以稳健性、效率和可扩展性为目标实现，允许任何人构建可用于多种场景的合成数据集。',Ml,b,ze='为了生成指令数据集，我们将使用与 distilabel 集成的<a href="https://huggingface.co/docs/inference-endpoints/en/index" rel="nofollow">HF 推理端点</a>。这些推理端点由 Hugging Face 提供，允许在专用和自动扩展的基础设施上轻松部署和运行 transformers、diffusers 或 Hub 中的任何可用模型。你可以在<a href="https://huggingface.co/docs/inference-endpoints/guides/create_endpoint" rel="nofollow">这里</a>找到更多关于如何创建你的第一个端点的信息。',rl,g,Ye='我们将为此微调的 LLM 模型是 <a href="https://argilla.io/blog/notus7b/" rel="nofollow">Notus 7B</a>，这是 Zephyr 7B 的一个微调版本，它使用直接偏好优化（DPO）和 AIF 技术，在多个基准测试中超越了其基础模型，并且完全开源。',cl,I,Se="本教程包括以下步骤：",ol,$,qe="<li>为 <code>distilabel</code> 流水线定义一个自定义生成任务。</li> <li>使用 Haystack 为欧盟人工智能法案创建一个 RAG 流水线。</li> <li>使用 <code>SelfInstructTask</code> 生成一个指令数据集。</li> <li>使用 <code>UltraFeedback</code> 文本质量任务生成一个偏好数据集。</li>",yl,C,ml,Z,Le="让我们从安装运行 <strong>distilabel</strong> 以及教程中使用的其他包所需的依赖项开始；尤其是 <strong>Haystack</strong>。为了更好地可视化和管理结果，也请安装 <strong>Argilla</strong>。",ul,k,dl,_,Jl,G,Pe='本教程的主要依赖项是 distilabel，用于创建合成数据集，以及 Argilla，用于可视化和管理这些数据集，同时也用于微调我们的模型。包 <a href="https://haystack.deepset.ai/" rel="nofollow">Haystack</a> 用于从我们想要创建数据集的原始 PDF 文档中创建批次。',Tl,R,Ul,V,jl,v,De='我们需要提供我们的 HuggingFace 访问 token，可以从<a href="https://huggingface.co/settings/tokens" rel="nofollow">设置</a>中获取。此外，为了通过 UltraFeedback 文本质量任务生成偏好数据集，我们还需要 OpenAI 的 api 密钥。你可以在<a href="https://platform.openai.com/api-keys" rel="nofollow">这里</a>找到它。请注意，根据使用的模型不同，将收取不同的费用，因此请确保你检查了 OpenAI 的<a href="https://openai.com/pricing" rel="nofollow">定价页面</a>。',fl,N,Ke="为了稍后实例化一个 <code>InferenceEndpointsLLM</code> 对象，我们还需要作为参数传递 HF 推理端点名称和 HF 命名空间。通过环境变量也是一种非常方便的方式。",wl,B,hl,E,bl,W,Oe='推理端点是 Hugging Face 管理的一种解决方案，可以轻松部署任何类似 Transformer 的模型。它们是基于 Hugging Face Hub 上的模型构建的。推理端点对于在 LLMs 上进行推理非常方便，无需尝试在本地运行模型。在本教程中，我们将使用推理端点作为 <code>distilabel</code> 工作流程的一部分，使用我们的 Notus 模型生成文本。所选端点运行着一个<a href="https://ui.endpoints.huggingface.co/argilla/endpoints/aws-notus-7b-v1-4052" rel="nofollow">Notus 7B 实例</a>。',gl,X,Il,H,ts="为了开始本教程，让我们看看如何为我们的 Notus 模型设置一个端点。这不是我们稍后将看到的端到端示例的一部分，但是如何连接到 Hugging Face 端点以及测试 <code>distilabel</code> 流水线的一个示例。",$l,A,ls="让我们快速了解一下如何使用推理端点。我们已经准备了一个简单的 <code>TextGenerationTask</code> 来向模型提问，这种方式与我们使用聊天机器人与 LLMs 交流非常相似。首先，我们定义一个用于问答任务的类，其中包含的函数向 <code>distilabel</code> 展示了模型应该如何生成提示、解析输入和输出等。",Cl,F,Zl,Q,es="<code>llm</code> 是 <code>InferenceEndpointsLLM</code> 类的一个对象，通过使用它，我们可以开始使用 <code>llm.generate()</code> 方法来生成问题的答案。",kl,x,_l,z,ss="使用定义了端点和任务信息的 <code>InferenceEndpointsLLM</code> 对象，我们可以开始生成文本。让我们问这个 LLM，例如，丹麦第二大城市人口最多的是哪个城市。答案应该是 Aarhus。",Gl,Y,Rl,S,ns="端点工作正常！我们已经成功地为 <code>distilabel</code> 流水线设置了一个自定义生成任务。",Vl,q,vl,L,as="在这个端到端的示例中，我们希望创建一个能够回答问题并填写关于欧盟推广的新人工智能法案信息的专家模型，这是关于人工智能的第一项法规。作为其数字战略的一部分，欧盟希望规范人工智能，以确保更好地发展和使用这项创新技术。这个法案是人工智能的监管框架，不同的风险级别意味着更多的或更少的监管。它们是世界上关于人工智能的第一套规则。",Nl,P,ps="我们想要创建的这个 RAG 的流水线会下载 PDF 文件，将其转换为纯文本并进行预处理，创建我们可以提供给 <code>distilabel</code> 的批次，以便开始从中创建指令。让我们看看流水线的第一部分并获取输入数据。需要注意的是，这个流水线的 RAG 部分并不是基于活跃的查询或语义属性的流水线，而是一种更直接的方法，我们下载PDF并预处理其内容。",Bl,D,El,K,is="首先，我们需要下载 PDF 文档本身。如果它不在工作目录中，我们将把它放在那里。",Wl,O,Xl,tt,Ms="一旦我们将文件放入工作目录，我们可以使用 Haystack 的转换器和流水线功能来提取文本数据，清洗数据并将其分成不同的批次。之后，这些批次将被用来开始创建合成指令。",Hl,lt,Al,et,rs="让我们快速查看一下我们刚刚生成的批次。",Fl,st,Ql,nt,cs="文件已经被正确地分批处理，从一个大文档变成了最多 150 个字符长的 355 个字符串。现在这个字符串列表可以作为输入，使用 <code>distilabel</code> 生成指令数据集。",xl,at,zl,pt,os="由于我们的推理端点已经启动并运行，我们应该能够使用 distilabel 生成指令。通过我们的端点由 LLM 创建的这些指令，将形成一个指令数据集，其中的指令是由我们刚刚提取的数据创建的。",Yl,it,ys="为了示例的顺利进行，我们使用了上面生成的 50 个批次的一个子集，以减轻性能压力。",Sl,Mt,ql,rt,ms='使用 <code>SelfInstructTask</code> 类，我们可以为构建提示生成一个 Self-Instruct 规范，就像在 <a href="https://arxiv.org/abs/2212.10560" rel="nofollow">Self-Instruct 论文</a>中所做的那样。<code>distilabel</code> 将从人工制作的输入开始，在这个案例中，就是我们从 AI 法案 PDF 创建的批次，然后基于这些输入生成指令。之后，可以使用 Argilla 来审查这些指令，以保留最好的那些。',Ll,ct,us="我们可以通过传递一个应用描述作为参数来告诉模型它应该做什么；我们希望这个模型能够回答我们关于 AI 法案的任何问题。",Pl,ot,Dl,yt,ds="现在，我们来定义一个生成器，传入 <code>SelfInstructTask</code> 对象，并创建一个 <code>Pipeline</code> 对象。",Kl,mt,Ol,ut,Js="我们的流水线已经准备好用来生成指令了。下面就开始吧！",te,dt,le,Jt,Ts="流水线已经成功生成了指令，基于输入的主题和行为。让我们收集所有这些指令，看看它们是什么样的。",ee,Tt,se,Ut,Us=`Number of generated instructions: 178
What are the reasons for and objectives of the proposal for a Regulation laying down harmonised rules on artificial intelligence?
How can artificial intelligence improve prediction, optimise operations and resource allocation, and personalise service delivery?
What benefits can artificial intelligence bring to the European economy and society as a whole?
How can the use of artificial intelligence support socially and environmentally beneficial outcomes?
What are the high-impact sectors that require AI action according to the AI Act by the European Union?
`,ne,jt,js="这些初始指令构成了我们的指令数据集。遵循人机协同的方法，我们应该将指令推送到 Argilla 进行可视化，并能够根据质量对它们进行排序。这些注释对于制作高质量的数据至关重要，确保最终模型有更好的性能。然而，这一步是可选的。",ae,ft,pe,wt,fs="让我们快速查看一下由 <code>SelfInstructTask</code> 生成的指令。",ie,ht,Me,bt,ws="对于每个输入，即 AI 法案 PDF 文件的每个批次，我们都有一个生成器提示，其中包含了关于如何行动的通用指南，以及应用程序描述参数。每个输入已经生成了 4 条指令。",re,gt,hs="现在正好是将指令数据集上传到 Argilla，审查并手动注释它的最佳时机。",ce,It,oe,$t,ye,Ct,bs="在 Argilla 的用户界面中，每个输入-指令元组都会单独显示，并且可以单独进行注释。",me,Zt,gs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/instrucion_dataset_notus_ui.png" alt="Instruction dataset"/>',ue,kt,de,_t,Is=`一旦我们有了指令数据集，我们将会通过 UltraFeedback 文本质量任务创建一个偏好数据集。这是一种在自然语言处理中用于评估生成文本质量的任务类型；我们的目标是提供关于生成文本质量的详细反馈，而不仅仅是二元的标签。
我们的 <code>pipeline()</code> 方法允许我们为给定的任务创建一个带有提供的 LLMs 的 <code>Pipeline</code> 实例，这在你想要为给定任务使用预定义或自定义的 <code>Pipeline</code> 时非常有用。我们将指定我们的任务和子任务，我们想要使用的生成器（在这个案例中，是基于文本生成任务的生成器）以及我们的 OpenAI API 密钥。`,Je,Gt,$s="<p>请注意，不使用 OpenAI 模型来获取此反馈也是可能的。然而，性能将会受到影响，反馈的质量也会较低。</p>",Te,Rt,Ue,Vt,Cs="我们还需要从 Argilla 检索我们的指令数据集，因为它将是这个流水线的输入。",je,vt,fe,Nt,we,Bt,Zs="在根据我们的指令生成文本之前，我们需要重命名数据集中的某些列。从前面的部分，我们仍然有旧的输入，即来自 PDF 的批次。我们需要将它们改为我们生成的指令。",he,Et,be,Wt,ks="现在，让我们使用刚刚创建的流水线以及生成我们指令的主题来构建一个数据集。",ge,Xt,Ie,Ht,_s="让我们来看一下偏好数据集的一个实例：",$e,At,Ce,Ft,Ze,Qt,Gs='你可以直接使用 distilabel 创建的 AI 反馈，但我们已经看到，通过加入人工反馈可以提升 LLM 的质量。我们提供了一个 <code>to_argilla</code> 方法，它为 Argilla 创建了一个数据集，并附带了现成的定制元数据过滤器以及语义搜索，让你能够尽可能快速和有趣地提供人工反馈。你可以查看<a href="https://docs.argilla.io/en/latest/getting_started/quickstart_installation.html" rel="nofollow">Argilla 文档</a>来了解如何安装和运行。',ke,xt,Rs="如果你正在使用 Docker 快速启动镜像或 Hugging Face Spaces 运行Argilla，你需要使用 URL 和 API_KEY 初始化 Argilla 客户端：",_e,zt,Ge,Yt,Vs="一旦我们成功地制作出了偏好数据集，Argilla 的用户界面就是最适合我们用来查看和标记这些数据的东西。就像我们对指令数据集所做的那样，我们只需要把这个数据集变成 Argilla 能理解的格式，然后上传到 Argilla 上就可以开始工作了。",Re,St,Ve,qt,vs="在Argilla用户界面中，我们可以看到输入（一个指令），以及 LLM 基于该指令创建的两个生成文本。",ve,Lt,Ns='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/preference_dataset_notus_ui.png" alt="Preference dataset"/>',Ne,Pt,Be,Dt,Bs="总结一下，我们已经完成了一个使用 distilabel 的端到端示例。我们建立了一个推理端点，定义了一个从 PDF 提取信息的 distilabel 流水线，并创建和手动审查了从该输入生成的指令和偏好数据集。最终的偏好数据集非常适合进行微调，你可以使用 Argilla 的 ArgillaTrainer 轻松完成这一工作。如果你想深入了解，请查看以下资源：",Ee,Kt,Es='<li><a href="https://docs.argilla.io/en/latest/tutorials_and_integrations/tutorials/feedback/end2end_examples/train-model-006.html" rel="nofollow">使用 ArgillaTrainer 训练模型</a></li> <li><a href="https://docs.argilla.io/en/latest/tutorials_and_integrations/tutorials/feedback/training-llm-mistral-sft.html" rel="nofollow">Ⓜ️ 将 LLM 作为聊天助手进行监督式微调：Mistral 7B</a></li> <li><a href="https://docs.argilla.io/en/latest/tutorials_and_integrations/tutorials/feedback/fine-tuning-sentencesimilarity-rag.html" rel="nofollow">🌠 通过优化检索和重排模型来改进 RAG</a></li>',We,Ot,Xe,ll,He;return U=new Ss({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/pipeline_notus_instructions_preferences_legal.ipynb"}]}}),j=new J({props:{title:"⚖️ 创建一个合法偏好数据集",local:"-创建一个合法偏好数据集",headingTag:"h1"}}),C=new J({props:{title:"简介",local:"简介",headingTag:"h2"}}),k=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwZGlzdGlsYWJlbCUyMCUyMmZhcm0taGF5c3RhY2slNUJwcmVwcm9jZXNzaW5nJTVEJTIyJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwJTIyZGlzdGlsYWJlbCU1QmhmLWluZmVyZW5jZS1lbmRwb2ludHMlMkMlMjBhcmdpbGxhJTVEJTIy",highlighted:`!pip install -q -U distilabel <span class="hljs-string">&quot;farm-haystack[preprocessing]&quot;</span>
!pip install -q -U <span class="hljs-string">&quot;distilabel[hf-inference-endpoints, argilla]&quot;</span>`,wrap:!1}}),_=new J({props:{title:"导入依赖项",local:"导入依赖项",headingTag:"h3"}}),R=new d({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwRGljdCUwQSUwQWZyb20lMjBkaXN0aWxhYmVsLmxsbSUyMGltcG9ydCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnBpcGVsaW5lJTIwaW1wb3J0JTIwUGlwZWxpbmUlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBkaXN0aWxhYmVsLnRhc2tzJTIwaW1wb3J0JTIwVGV4dEdlbmVyYXRpb25UYXNrJTJDJTIwU2VsZkluc3RydWN0VGFzayUyQyUyMFByb21wdCUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEFmcm9tJTIwaGF5c3RhY2subm9kZXMlMjBpbXBvcnQlMjBQREZUb1RleHRDb252ZXJ0ZXIlMkMlMjBQcmVQcm9jZXNzb3I=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>

<span class="hljs-keyword">from</span> distilabel.llm <span class="hljs-keyword">import</span> InferenceEndpointsLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline, pipeline
<span class="hljs-keyword">from</span> distilabel.tasks <span class="hljs-keyword">import</span> TextGenerationTask, SelfInstructTask, Prompt

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> haystack.nodes <span class="hljs-keyword">import</span> PDFToTextConverter, PreProcessor`,wrap:!1}}),V=new J({props:{title:"环境变量",local:"环境变量",headingTag:"h3"}}),B=new d({props:{code:"b3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyJTIyJTBBb3MuZW52aXJvbiU1QiUyMkhGX0lORkVSRU5DRV9FTkRQT0lOVF9OQU1FJTIyJTVEJTIwJTNEJTIwJTIyYXdzLW5vdHVzLTdiLXYxLTMxODQlMjIlMEFvcy5lbnZpcm9uJTVCJTIySEZfTkFNRVNQQUNFJTIyJTVEJTIwJTNEJTIwJTIyYXJnaWxsYSUyMiUwQW9zLmVudmlyb24lNUIlMjJPUEVOQUlfQVBJX0tFWSUyMiU1RCUyMCUzRCUyMCUyMiUyMg==",highlighted:`os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_INFERENCE_ENDPOINT_NAME&quot;</span>] = <span class="hljs-string">&quot;aws-notus-7b-v1-3184&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_NAMESPACE&quot;</span>] = <span class="hljs-string">&quot;argilla&quot;</span>
os.environ[<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),E=new J({props:{title:"使用 Notus 设置推理端点",local:"使用-notus-设置推理端点",headingTag:"h2"}}),X=new J({props:{title:"为 distilabel 流水线定义一个自定义生成任务",local:"为-distilabel-流水线定义一个自定义生成任务",headingTag:"h3"}}),F=new d({props:{code:"Y2xhc3MlMjBRdWVzdGlvbkFuc3dlcmluZ1Rhc2soVGV4dEdlbmVyYXRpb25UYXNrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGdlbmVyYXRlX3Byb21wdChzZWxmJTJDJTIwcXVlc3Rpb24lM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb21wdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzeXN0ZW1fcHJvbXB0JTNEc2VsZi5zeXN0ZW1fcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3Byb21wdCUzRHF1ZXN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5mb3JtYXRfYXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGxhbWEyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyMCUyMCUyMyUyMHR5cGUlM0ElMjBpZ25vcmUlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBwYXJzZV9vdXRwdXQoc2VsZiUyQyUyMG91dHB1dCUzQSUyMHN0ciklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMHN0ciU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmFuc3dlciUyMiUzQSUyMG91dHB1dC5zdHJpcCgpJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dF9hcmdzX25hbWVzKHNlbGYpJTIwLSUzRSUyMGxpc3QlNUJzdHIlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMjJxdWVzdGlvbiUyMiU1RCUwQSUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwb3V0cHV0X2FyZ3NfbmFtZXMoc2VsZiklMjAtJTNFJTIwbGlzdCU1QnN0ciU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUyMmFuc3dlciUyMiU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">QuestionAnsweringTask</span>(<span class="hljs-title class_ inherited__">TextGenerationTask</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_prompt</span>(<span class="hljs-params">self, question: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">return</span> Prompt(
            system_prompt=self.system_prompt,
            formatted_prompt=question,
        ).format_as(
            <span class="hljs-string">&quot;llama2&quot;</span>
        )  <span class="hljs-comment"># type: ignore</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_output</span>(<span class="hljs-params">self, output: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;answer&quot;</span>: output.strip()}

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">input_args_names</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;question&quot;</span>]

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">output_args_names</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;answer&quot;</span>]`,wrap:!1}}),x=new d({props:{code:"bGxtJTIwJTNEJTIwSW5mZXJlbmNlRW5kcG9pbnRzTExNKCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50X25hbWVfb3JfbW9kZWxfaWQlM0Rvcy5nZXRlbnYoJTIySEZfSU5GRVJFTkNFX0VORFBPSU5UX05BTUUlMjIpJTJDJTIwJTIwJTIzJTIwdHlwZSUzQSUyMGlnbm9yZSUwQSUyMCUyMCUyMCUyMGVuZHBvaW50X25hbWVzcGFjZSUzRG9zLmdldGVudiglMjJIRl9OQU1FU1BBQ0UlMjIpJTJDJTIwJTIwJTIzJTIwdHlwZSUzQSUyMGlnbm9yZSUwQSUyMCUyMCUyMCUyMHRva2VuJTNEb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSUyMG9yJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0RRdWVzdGlvbkFuc3dlcmluZ1Rhc2soKSUyQyUwQSk=",highlighted:`llm = InferenceEndpointsLLM(
    endpoint_name_or_model_id=os.getenv(<span class="hljs-string">&quot;HF_INFERENCE_ENDPOINT_NAME&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
    endpoint_namespace=os.getenv(<span class="hljs-string">&quot;HF_NAMESPACE&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
    token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>) <span class="hljs-keyword">or</span> <span class="hljs-literal">None</span>,
    task=QuestionAnsweringTask(),
)`,wrap:!1}}),Y=new d({props:{code:"Z2VuZXJhdGlvbiUyMCUzRCUyMGxsbS5nZW5lcmF0ZSglNUIlN0IlMjJxdWVzdGlvbiUyMiUzQSUyMCUyMldoYXQncyUyMHRoZSUyMHNlY29uZCUyMG1vc3QlMjBwb3B1bGF0ZWQlMjBjaXR5JTIwaW4lMjBEZW5tYXJrJTNGJTIyJTdEJTVEKSUwQWdlbmVyYXRpb24lNUIwJTVEJTVCMCU1RCU1QiUyMnBhcnNlZF9vdXRwdXQlMjIlNUQlNUIlMjJhbnN3ZXIlMjIlNUQ=",highlighted:`generation = llm.generate([{<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the second most populated city in Denmark?&quot;</span>}])
generation[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;parsed_output&quot;</span>][<span class="hljs-string">&quot;answer&quot;</span>]`,wrap:!1}}),q=new J({props:{title:"使用 Haystack 为欧洲人工智能法案创建 RAG 流水线",local:"使用-haystack-为欧洲人工智能法案创建-rag-流水线",headingTag:"h2"}}),D=new J({props:{title:"下载人工智能法案 PDF",local:"下载人工智能法案-pdf",headingTag:"h3"}}),O=new d({props:{code:"JTI1JTI1YmFzaCUwQSUwQWlmJTIwJTVCJTIwISUyMC1mJTIwJTIyVGhlLUFJLUFjdC5wZGYlMjIlMjAlNUQlM0IlMjB0aGVuJTBBJTIwJTIwJTIwJTIwd2dldCUyMC1xJTIwaHR0cHMlM0ElMkYlMkZhcnRpZmljaWFsaW50ZWxsaWdlbmNlYWN0LmV1JTJGd3AtY29udGVudCUyRnVwbG9hZHMlMkYyMDIxJTJGMDglMkZUaGUtQUktQWN0LnBkZiUwQWZp",highlighted:`%%bash

<span class="hljs-keyword">if</span> [ ! -f <span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span> ]; then
    wget -q https://artificialintelligenceact.eu/wp-content/uploads/<span class="hljs-number">2021</span>/08/The-AI-Act.pdf
fi`,wrap:!1}}),lt=new d({props:{code:"JTIzJTIwVGhlJTIwY29udmVydGVyJTIwdHVybnMlMjB0aGUlMjBQREYlMjBpbnRvJTIwdGV4dCUyMHdlJTIwY2FuJTIwcHJvY2VzcyUyMGVhc2lseSUwQWNvbnZlcnRlciUyMCUzRCUyMFBERlRvVGV4dENvbnZlcnRlcihyZW1vdmVfbnVtZXJpY190YWJsZXMlM0RUcnVlJTJDJTIwdmFsaWRfbGFuZ3VhZ2VzJTNEJTVCJTIyZW4lMjIlNUQpJTBBJTBBJTIzJTIwUHJlcHJvY2Vzc2luZyUyMHBpcGVsaW5lcyUyMGNhbiUyMGhhdmUlMjBzZXZlcmFsJTIwc3RlcHMuJTBBJTIzJTIwT3VycyUyMGNsZWFuJTIwZW1wdHklMjBsaW5lcyUyQyUyMGhlYWRlciUyQyUyMGZvb3RlcnMlMjBhbmQlMjB3aGl0ZXNwYWNlcyUwQSUyMyUyMGFuZCUyMHNwbGl0JTIwdGhlJTIwdGV4dCUyMGludG8lMjAxNTAtY2hhciUyMGxvbmclMjBiYXRjaGVzJTJDJTIwcmVzcGVjdGluZyUwQSUyMyUyMHdoZXJlJTIwdGhlJTIwc2VudGVuY2VzJTIwbmF0dXJhbGx5JTIwZW5kJTIwYW5kJTIwYmVnaW4uJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwUHJlUHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGNsZWFuX2VtcHR5X2xpbmVzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNsZWFuX3doaXRlc3BhY2UlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwY2xlYW5faGVhZGVyX2Zvb3RlciUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzcGxpdF9ieSUzRCUyMndvcmQlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGxpdF9sZW5ndGglM0QxNTAlMkMlMEElMjAlMjAlMjAlMjBzcGxpdF9yZXNwZWN0X3NlbnRlbmNlX2JvdW5kYXJ5JTNEVHJ1ZSUyQyUwQSklMEElMEFkb2MlMjAlM0QlMjBjb252ZXJ0ZXIuY29udmVydChmaWxlX3BhdGglM0QlMjJUaGUtQUktQWN0LnBkZiUyMiUyQyUyMG1ldGElM0ROb25lKSU1QjAlNUQlMEFkb2NzJTIwJTNEJTIwcHJlcHJvY2Vzc29yLnByb2Nlc3MoJTVCZG9jJTVEKSUwQXByaW50KGYlMjJEb2N1bWVudHMlM0ElMjAxJTVDbkJhdGNoZXMlM0ElMjAlN0JsZW4oZG9jcyklN0QlMjIp",highlighted:`<span class="hljs-comment"># The converter turns the PDF into text we can process easily</span>
converter = PDFToTextConverter(remove_numeric_tables=<span class="hljs-literal">True</span>, valid_languages=[<span class="hljs-string">&quot;en&quot;</span>])

<span class="hljs-comment"># Preprocessing pipelines can have several steps.</span>
<span class="hljs-comment"># Ours clean empty lines, header, footers and whitespaces</span>
<span class="hljs-comment"># and split the text into 150-char long batches, respecting</span>
<span class="hljs-comment"># where the sentences naturally end and begin.</span>
preprocessor = PreProcessor(
    clean_empty_lines=<span class="hljs-literal">True</span>,
    clean_whitespace=<span class="hljs-literal">True</span>,
    clean_header_footer=<span class="hljs-literal">True</span>,
    split_by=<span class="hljs-string">&quot;word&quot;</span>,
    split_length=<span class="hljs-number">150</span>,
    split_respect_sentence_boundary=<span class="hljs-literal">True</span>,
)

doc = converter.convert(file_path=<span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span>, meta=<span class="hljs-literal">None</span>)[<span class="hljs-number">0</span>]
docs = preprocessor.process([doc])
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Documents: 1\\nBatches: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(docs)}</span>&quot;</span>)`,wrap:!1}}),st=new d({props:{code:"aW5wdXRzJTIwJTNEJTIwJTVCZG9jLmNvbnRlbnQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3MlNUQlMEFpbnB1dHMlNUIwJTVEJTVCMCUzQTUwMCU1RA==",highlighted:`inputs = [doc.content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs]
inputs[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>:<span class="hljs-number">500</span>]`,wrap:!1}}),at=new J({props:{title:"使用 SelfInstructTask 生成指令",local:"使用-selfinstructtask-生成指令",headingTag:"h2"}}),Mt=new d({props:{code:"aW5zdHJ1Y3Rpb25zX2RhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJpbnB1dCUyMiUzQSUyMGlucHV0cyU1QjAlM0E1MCU1RCU3RCklMEElMEFpbnN0cnVjdGlvbnNfZGF0YXNldA==",highlighted:`instructions_dataset = Dataset.from_dict({<span class="hljs-string">&quot;input&quot;</span>: inputs[<span class="hljs-number">0</span>:<span class="hljs-number">50</span>]})

instructions_dataset`,wrap:!1}}),ot=new d({props:{code:"aW5zdHJ1Y3Rpb25zX3Rhc2slMjAlM0QlMjBTZWxmSW5zdHJ1Y3RUYXNrKCUwQSUyMCUyMCUyMCUyMGFwcGxpY2F0aW9uX2Rlc2NyaXB0aW9uJTNEJTIyQSUyMGFzc2lzdGFudCUyMHRoYXQlMjBjYW4lMjBhbnN3ZXIlMjBxdWVzdGlvbnMlMjBhYm91dCUyMHRoZSUyMEFJJTIwQWN0JTIwbWFkZSUyMGJ5JTIwdGhlJTIwRXVyb3BlYW4lMjBVbmlvbi4lMjIlMEEp",highlighted:`instructions_task = SelfInstructTask(
    application_description=<span class="hljs-string">&quot;A assistant that can answer questions about the AI Act made by the European Union.&quot;</span>
)`,wrap:!1}}),mt=new d({props:{code:"aW5zdHJ1Y3Rpb25zX2dlbmVyYXRvciUyMCUzRCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lX29yX21vZGVsX2lkJTNEb3MuZ2V0ZW52KCUyMkhGX0lORkVSRU5DRV9FTkRQT0lOVF9OQU1FJTIyKSUyQyUyMCUyMCUyMyUyMHR5cGUlM0ElMjBpZ25vcmUlMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lc3BhY2UlM0Rvcy5nZXRlbnYoJTIySEZfTkFNRVNQQUNFJTIyKSUyQyUyMCUyMCUyMyUyMHR5cGUlM0ElMjBpZ25vcmUlMEElMjAlMjAlMjAlMjB0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMjBvciUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEaW5zdHJ1Y3Rpb25zX3Rhc2slMkMlMEEpJTBBJTBBaW5zdHJ1Y3Rpb25zX3BpcGVsaW5lJTIwJTNEJTIwUGlwZWxpbmUoZ2VuZXJhdG9yJTNEaW5zdHJ1Y3Rpb25zX2dlbmVyYXRvcik=",highlighted:`instructions_generator = InferenceEndpointsLLM(
    endpoint_name_or_model_id=os.getenv(<span class="hljs-string">&quot;HF_INFERENCE_ENDPOINT_NAME&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
    endpoint_namespace=os.getenv(<span class="hljs-string">&quot;HF_NAMESPACE&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
    token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>) <span class="hljs-keyword">or</span> <span class="hljs-literal">None</span>,
    task=instructions_task,
)

instructions_pipeline = Pipeline(generator=instructions_generator)`,wrap:!1}}),dt=new d({props:{code:"Z2VuZXJhdGVkX2luc3RydWN0aW9ucyUyMCUzRCUyMGluc3RydWN0aW9uc19waXBlbGluZS5nZW5lcmF0ZShkYXRhc2V0JTNEaW5zdHJ1Y3Rpb25zX2RhdGFzZXQlMkMlMjBudW1fZ2VuZXJhdGlvbnMlM0QxJTJDJTIwYmF0Y2hfc2l6ZSUzRDgp",highlighted:'generated_instructions = instructions_pipeline.generate(dataset=instructions_dataset, num_generations=<span class="hljs-number">1</span>, batch_size=<span class="hljs-number">8</span>)',wrap:!1}}),Tt=new d({props:{code:"aW5zdHJ1Y3Rpb25zJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwZ2VuZXJhdGlvbnMlMjBpbiUyMGdlbmVyYXRlZF9pbnN0cnVjdGlvbnMlNUIlMjJpbnN0cnVjdGlvbnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBnZW5lcmF0aW9uJTIwaW4lMjBnZW5lcmF0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RydWN0aW9ucy5leHRlbmQoZ2VuZXJhdGlvbiklMEElMEFwcmludChmJTIyTnVtYmVyJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbnN0cnVjdGlvbnMlM0ElMjAlN0JsZW4oaW5zdHJ1Y3Rpb25zKSU3RCUyMiklMEElMEFmb3IlMjBpbnN0cnVjdGlvbiUyMGluJTIwaW5zdHJ1Y3Rpb25zJTVCJTNBNSU1RCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGluc3RydWN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>instructions = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> generations <span class="hljs-keyword">in</span> generated_instructions[<span class="hljs-string">&quot;instructions&quot;</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> generation <span class="hljs-keyword">in</span> generations:
<span class="hljs-meta">... </span>        instructions.extend(generation)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of generated instructions: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(instructions)}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> instruction <span class="hljs-keyword">in</span> instructions[:<span class="hljs-number">5</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(instruction)`,wrap:!1}}),ft=new J({props:{title:"将指令数据集推送到Argilla以进行可视化和注释。",local:"将指令数据集推送到argilla以进行可视化和注释",headingTag:"h3"}}),ht=new d({props:{code:"Z2VuZXJhdGVkX2luc3RydWN0aW9ucyU1QjAlNUQ=",highlighted:'generated_instructions[<span class="hljs-number">0</span>]',wrap:!1}}),It=new d({props:{code:"aW5zdHJ1Y3Rpb25zX3JnX2RhdGFzZXQlMjAlM0QlMjBnZW5lcmF0ZWRfaW5zdHJ1Y3Rpb25zLnRvX2FyZ2lsbGEoKSUwQWluc3RydWN0aW9uc19yZ19kYXRhc2V0JTVCMCU1RA==",highlighted:`instructions_rg_dataset = generated_instructions.to_argilla()
instructions_rg_dataset[<span class="hljs-number">0</span>]`,wrap:!1}}),$t=new d({props:{code:"aW5zdHJ1Y3Rpb25zX3JnX2RhdGFzZXQucHVzaF90b19hcmdpbGxhKG5hbWUlM0RmJTIybm90dXNfQUlfaW5zdHJ1Y3Rpb25zJTIyKQ==",highlighted:'instructions_rg_dataset.push_to_argilla(name=<span class="hljs-string">f&quot;notus_AI_instructions&quot;</span>)',wrap:!1}}),kt=new J({props:{title:"使用 Ultrafeedback 文本质量任务生成偏好数据集",local:"使用-ultrafeedback-文本质量任务生成偏好数据集",headingTag:"h2"}}),Rt=new d({props:{code:"cHJlZmVyZW5jZV9waXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnByZWZlcmVuY2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnN0cnVjdGlvbi1mb2xsb3dpbmclMjIlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RJbmZlcmVuY2VFbmRwb2ludHNMTE0oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5kcG9pbnRfbmFtZV9vcl9tb2RlbF9pZCUzRG9zLmdldGVudiglMjJIRl9JTkZFUkVOQ0VfRU5EUE9JTlRfTkFNRSUyMiklMkMlMjAlMjAlMjMlMjB0eXBlJTNBJTIwaWdub3JlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5kcG9pbnRfbmFtZXNwYWNlJTNEb3MuZ2V0ZW52KCUyMkhGX05BTUVTUEFDRSUyMiUyQyUyME5vbmUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFzayUzRFRleHRHZW5lcmF0aW9uVGFzaygpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fdGhyZWFkcyUzRDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUwQSUyMCUyMCUyMCUyMG51bV90aHJlYWRzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyT1BFTkFJX0FQSV9LRVklMjIlMkMlMjBOb25lKSUyQyUwQSUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC4wJTJDJTBBKQ==",highlighted:`preference_pipeline = pipeline(
    <span class="hljs-string">&quot;preference&quot;</span>,
    <span class="hljs-string">&quot;instruction-following&quot;</span>,
    generator=InferenceEndpointsLLM(
        endpoint_name_or_model_id=os.getenv(<span class="hljs-string">&quot;HF_INFERENCE_ENDPOINT_NAME&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
        endpoint_namespace=os.getenv(<span class="hljs-string">&quot;HF_NAMESPACE&quot;</span>, <span class="hljs-literal">None</span>),
        task=TextGenerationTask(),
        max_new_tokens=<span class="hljs-number">256</span>,
        num_threads=<span class="hljs-number">2</span>,
        temperature=<span class="hljs-number">0.3</span>,
    ),
    max_new_tokens=<span class="hljs-number">256</span>,
    num_threads=<span class="hljs-number">2</span>,
    api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>, <span class="hljs-literal">None</span>),
    temperature=<span class="hljs-number">0.0</span>,
)`,wrap:!1}}),vt=new d({props:{code:"cmVtb3RlX2RhdGFzZXQlMjAlM0QlMjByZy5GZWVkYmFja0RhdGFzZXQuZnJvbV9hcmdpbGxhKCUyMm5vdHVzX0FJX2luc3RydWN0aW9ucyUyMiUyQyUyMHdvcmtzcGFjZSUzRCUyMmFkbWluJTIyKSUwQWluc3RydWN0aW9uc19kYXRhc2V0JTIwJTNEJTIwcmVtb3RlX2RhdGFzZXQucHVsbChtYXhfcmVjb3JkcyUzRDEwMCklMjAlMjAlMjMlMjBnZXQlMjBmaXJzdCUyMDEwMCUyMHJlY29yZHMlMEElMEFpbnN0cnVjdGlvbnNfZGF0YXNldCUyMCUzRCUyMGluc3RydWN0aW9uc19kYXRhc2V0LmZvcm1hdF9hcyglMjJkYXRhc2V0cyUyMiklMEFpbnN0cnVjdGlvbnNfZGF0YXNldA==",highlighted:`remote_dataset = rg.FeedbackDataset.from_argilla(<span class="hljs-string">&quot;notus_AI_instructions&quot;</span>, workspace=<span class="hljs-string">&quot;admin&quot;</span>)
instructions_dataset = remote_dataset.pull(max_records=<span class="hljs-number">100</span>)  <span class="hljs-comment"># get first 100 records</span>

instructions_dataset = instructions_dataset.format_as(<span class="hljs-string">&quot;datasets&quot;</span>)
instructions_dataset`,wrap:!1}}),Nt=new d({props:{code:"aW5zdHJ1Y3Rpb25zX2RhdGFzZXQlNUIwJTVE",highlighted:'instructions_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),Et=new d({props:{code:"aW5zdHJ1Y3Rpb25zX2RhdGFzZXQlMjAlM0QlMjBpbnN0cnVjdGlvbnNfZGF0YXNldC5yZW5hbWVfY29sdW1ucyglN0IlMjJpbnB1dCUyMiUzQSUyMCUyMmNvbnRleHQlMjIlMkMlMjAlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMmlucHV0JTIyJTdEKQ==",highlighted:'instructions_dataset = instructions_dataset.rename_columns({<span class="hljs-string">&quot;input&quot;</span>: <span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;input&quot;</span>})',wrap:!1}}),Xt=new d({props:{code:"cHJlZmVyZW5jZV9kYXRhc2V0JTIwJTNEJTIwcHJlZmVyZW5jZV9waXBlbGluZS5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnN0cnVjdGlvbnNfZGF0YXNldCUyQyUyMCUyMCUyMyUyMHR5cGUlM0ElMjBpZ25vcmUlMEElMjAlMjAlMjAlMjBudW1fZ2VuZXJhdGlvbnMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMEElMjAlMjAlMjAlMjBkaXNwbGF5X3Byb2dyZXNzX2JhciUzRFRydWUlMkMlMEEp",highlighted:`preference_dataset = preference_pipeline.generate(
    instructions_dataset,  <span class="hljs-comment"># type: ignore</span>
    num_generations=<span class="hljs-number">2</span>,
    batch_size=<span class="hljs-number">8</span>,
    display_progress_bar=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),At=new d({props:{code:"cHJlZmVyZW5jZV9kYXRhc2V0JTVCMCU1RA==",highlighted:'preference_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),Ft=new J({props:{title:"使用 Argilla 进行人工反馈",local:"使用-argilla-进行人工反馈",headingTag:"h2"}}),zt=new d({props:{code:"aW1wb3J0JTIwYXJnaWxsYSUyMGFzJTIwcmclMEElMEElMjMlMjBSZXBsYWNlJTIwYXBpX3VybCUyMHdpdGglMjB0aGUlMjB1cmwlMjB0byUyMHlvdXIlMjBIRiUyMFNwYWNlcyUyMFVSTCUyMGlmJTIwdXNpbmclMjBTcGFjZXMlMEElMjMlMjBSZXBsYWNlJTIwYXBpX2tleSUyMGlmJTIweW91JTIwY29uZmlndXJlZCUyMGElMjBjdXN0b20lMjBBUEklMjBrZXklMEFyZy5pbml0KGFwaV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBNjkwMCUyMiUyQyUyMGFwaV9rZXklM0QlMjJvd25lci5hcGlrZXklMjIlMkMlMjB3b3Jrc3BhY2UlM0QlMjJhZG1pbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg

<span class="hljs-comment"># Replace api_url with the url to your HF Spaces URL if using Spaces</span>
<span class="hljs-comment"># Replace api_key if you configured a custom API key</span>
rg.init(api_url=<span class="hljs-string">&quot;http://localhost:6900&quot;</span>, api_key=<span class="hljs-string">&quot;owner.apikey&quot;</span>, workspace=<span class="hljs-string">&quot;admin&quot;</span>)`,wrap:!1}}),St=new d({props:{code:"JTIzJTIwVXBsb2FkaW5nJTIwdGhlJTIwUHJlZmVyZW5jZSUyMERhdGFzZXQlMEFwcmVmZXJlbmNlX3JnX2RhdGFzZXQlMjAlM0QlMjBwcmVmZXJlbmNlX2RhdGFzZXQudG9fYXJnaWxsYSgpJTBBJTBBJTIzJTIwQWRkaW5nJTIwdGhlJTIwY29udGV4dCUyMGFzJTIwYSUyMG1ldGFkYXRhJTIwcHJvcGVydHklMjBpbiUyMHRoZSUyMG5ldyUyMEZlZWRiYWNrJTIwZGF0YXNldCUyQyUyMGFzJTIwdGhpcyUwQSUyMyUyMGluZm9ybWF0aW9uJTIwd2lsbCUyMGJlJTIwdXNlZnVsJTIwbGF0ZXIuJTBBZm9yJTIwcmVjb3JkX2ZlZWRiYWNrJTJDJTIwcmVjb3JkX2h1Z2dpbmdmYWNlJTIwaW4lMjB6aXAocHJlZmVyZW5jZV9yZ19kYXRhc2V0JTJDJTIwcHJlZmVyZW5jZV9kYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMHJlY29yZF9mZWVkYmFjay5tZXRhZGF0YSU1QiUyMmNvbnRleHQlMjIlNUQlMjAlM0QlMjByZWNvcmRfaHVnZ2luZ2ZhY2UlNUIlMjJjb250ZXh0JTIyJTVEJTBBJTBBcHJlZmVyZW5jZV9yZ19kYXRhc2V0LnB1c2hfdG9fYXJnaWxsYShuYW1lJTNEZiUyMm5vdHVzX0FJX3ByZWZlcmVuY2UlMjIp",highlighted:`<span class="hljs-comment"># Uploading the Preference Dataset</span>
preference_rg_dataset = preference_dataset.to_argilla()

<span class="hljs-comment"># Adding the context as a metadata property in the new Feedback dataset, as this</span>
<span class="hljs-comment"># information will be useful later.</span>
<span class="hljs-keyword">for</span> record_feedback, record_huggingface <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(preference_rg_dataset, preference_dataset):
    record_feedback.metadata[<span class="hljs-string">&quot;context&quot;</span>] = record_huggingface[<span class="hljs-string">&quot;context&quot;</span>]

preference_rg_dataset.push_to_argilla(name=<span class="hljs-string">f&quot;notus_AI_preference&quot;</span>)`,wrap:!1}}),Pt=new J({props:{title:"结论",local:"结论",headingTag:"h2"}}),Ot=new qs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/pipeline_notus_instructions_preferences_legal.md"}}),{c(){T=p("meta"),el=n(),tl=p("p"),sl=n(),r(U.$$.fragment),nl=n(),r(j.$$.fragment),al=n(),f=p("p"),f.innerHTML=Fe,pl=n(),w=p("p"),w.textContent=Qe,il=n(),h=p("p"),h.innerHTML=xe,Ml=n(),b=p("p"),b.innerHTML=ze,rl=n(),g=p("p"),g.innerHTML=Ye,cl=n(),I=p("p"),I.textContent=Se,ol=n(),$=p("ul"),$.innerHTML=qe,yl=n(),r(C.$$.fragment),ml=n(),Z=p("p"),Z.innerHTML=Le,ul=n(),r(k.$$.fragment),dl=n(),r(_.$$.fragment),Jl=n(),G=p("p"),G.innerHTML=Pe,Tl=n(),r(R.$$.fragment),Ul=n(),r(V.$$.fragment),jl=n(),v=p("p"),v.innerHTML=De,fl=n(),N=p("p"),N.innerHTML=Ke,wl=n(),r(B.$$.fragment),hl=n(),r(E.$$.fragment),bl=n(),W=p("p"),W.innerHTML=Oe,gl=n(),r(X.$$.fragment),Il=n(),H=p("p"),H.innerHTML=ts,$l=n(),A=p("p"),A.innerHTML=ls,Cl=n(),r(F.$$.fragment),Zl=n(),Q=p("p"),Q.innerHTML=es,kl=n(),r(x.$$.fragment),_l=n(),z=p("p"),z.innerHTML=ss,Gl=n(),r(Y.$$.fragment),Rl=n(),S=p("p"),S.innerHTML=ns,Vl=n(),r(q.$$.fragment),vl=n(),L=p("p"),L.textContent=as,Nl=n(),P=p("p"),P.innerHTML=ps,Bl=n(),r(D.$$.fragment),El=n(),K=p("p"),K.textContent=is,Wl=n(),r(O.$$.fragment),Xl=n(),tt=p("p"),tt.textContent=Ms,Hl=n(),r(lt.$$.fragment),Al=n(),et=p("p"),et.textContent=rs,Fl=n(),r(st.$$.fragment),Ql=n(),nt=p("p"),nt.innerHTML=cs,xl=n(),r(at.$$.fragment),zl=n(),pt=p("p"),pt.textContent=os,Yl=n(),it=p("p"),it.textContent=ys,Sl=n(),r(Mt.$$.fragment),ql=n(),rt=p("p"),rt.innerHTML=ms,Ll=n(),ct=p("p"),ct.textContent=us,Pl=n(),r(ot.$$.fragment),Dl=n(),yt=p("p"),yt.innerHTML=ds,Kl=n(),r(mt.$$.fragment),Ol=n(),ut=p("p"),ut.textContent=Js,te=n(),r(dt.$$.fragment),le=n(),Jt=p("p"),Jt.textContent=Ts,ee=n(),r(Tt.$$.fragment),se=n(),Ut=p("pre"),Ut.textContent=Us,ne=n(),jt=p("p"),jt.textContent=js,ae=n(),r(ft.$$.fragment),pe=n(),wt=p("p"),wt.innerHTML=fs,ie=n(),r(ht.$$.fragment),Me=n(),bt=p("p"),bt.textContent=ws,re=n(),gt=p("p"),gt.textContent=hs,ce=n(),r(It.$$.fragment),oe=n(),r($t.$$.fragment),ye=n(),Ct=p("p"),Ct.textContent=bs,me=n(),Zt=p("p"),Zt.innerHTML=gs,ue=n(),r(kt.$$.fragment),de=n(),_t=p("p"),_t.innerHTML=Is,Je=n(),Gt=p("blockquote"),Gt.innerHTML=$s,Te=n(),r(Rt.$$.fragment),Ue=n(),Vt=p("p"),Vt.textContent=Cs,je=n(),r(vt.$$.fragment),fe=n(),r(Nt.$$.fragment),we=n(),Bt=p("p"),Bt.textContent=Zs,he=n(),r(Et.$$.fragment),be=n(),Wt=p("p"),Wt.textContent=ks,ge=n(),r(Xt.$$.fragment),Ie=n(),Ht=p("p"),Ht.textContent=_s,$e=n(),r(At.$$.fragment),Ce=n(),r(Ft.$$.fragment),Ze=n(),Qt=p("p"),Qt.innerHTML=Gs,ke=n(),xt=p("p"),xt.textContent=Rs,_e=n(),r(zt.$$.fragment),Ge=n(),Yt=p("p"),Yt.textContent=Vs,Re=n(),r(St.$$.fragment),Ve=n(),qt=p("p"),qt.textContent=vs,ve=n(),Lt=p("p"),Lt.innerHTML=Ns,Ne=n(),r(Pt.$$.fragment),Be=n(),Dt=p("p"),Dt.textContent=Bs,Ee=n(),Kt=p("ul"),Kt.innerHTML=Es,We=n(),r(Ot.$$.fragment),Xe=n(),ll=p("p"),this.h()},l(t){const l=zs("svelte-u9bgzb",document.head);T=i(l,"META",{name:!0,content:!0}),l.forEach(e),el=a(t),tl=i(t,"P",{}),Ws(tl).forEach(e),sl=a(t),c(U.$$.fragment,t),nl=a(t),c(j.$$.fragment,t),al=a(t),f=i(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-2bgmhk"&&(f.innerHTML=Fe),pl=a(t),w=i(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1jrybko"&&(w.textContent=Qe),il=a(t),h=i(t,"P",{"data-svelte-h":!0}),M(h)!=="svelte-1wy7u9g"&&(h.innerHTML=xe),Ml=a(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1olxq68"&&(b.innerHTML=ze),rl=a(t),g=i(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-9yf9b5"&&(g.innerHTML=Ye),cl=a(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1gp19a6"&&(I.textContent=Se),ol=a(t),$=i(t,"UL",{"data-svelte-h":!0}),M($)!=="svelte-1c3r033"&&($.innerHTML=qe),yl=a(t),c(C.$$.fragment,t),ml=a(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1n1ipdx"&&(Z.innerHTML=Le),ul=a(t),c(k.$$.fragment,t),dl=a(t),c(_.$$.fragment,t),Jl=a(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1hjlj63"&&(G.innerHTML=Pe),Tl=a(t),c(R.$$.fragment,t),Ul=a(t),c(V.$$.fragment,t),jl=a(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1ep0nvn"&&(v.innerHTML=De),fl=a(t),N=i(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1n8ukrz"&&(N.innerHTML=Ke),wl=a(t),c(B.$$.fragment,t),hl=a(t),c(E.$$.fragment,t),bl=a(t),W=i(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-47nc0j"&&(W.innerHTML=Oe),gl=a(t),c(X.$$.fragment,t),Il=a(t),H=i(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-yseh4c"&&(H.innerHTML=ts),$l=a(t),A=i(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-10xr23t"&&(A.innerHTML=ls),Cl=a(t),c(F.$$.fragment,t),Zl=a(t),Q=i(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-752dpr"&&(Q.innerHTML=es),kl=a(t),c(x.$$.fragment,t),_l=a(t),z=i(t,"P",{"data-svelte-h":!0}),M(z)!=="svelte-xhrmy4"&&(z.innerHTML=ss),Gl=a(t),c(Y.$$.fragment,t),Rl=a(t),S=i(t,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1f0kh7c"&&(S.innerHTML=ns),Vl=a(t),c(q.$$.fragment,t),vl=a(t),L=i(t,"P",{"data-svelte-h":!0}),M(L)!=="svelte-f5okda"&&(L.textContent=as),Nl=a(t),P=i(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1ss4d6o"&&(P.innerHTML=ps),Bl=a(t),c(D.$$.fragment,t),El=a(t),K=i(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-fvdhv9"&&(K.textContent=is),Wl=a(t),c(O.$$.fragment,t),Xl=a(t),tt=i(t,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-1bqdmdo"&&(tt.textContent=Ms),Hl=a(t),c(lt.$$.fragment,t),Al=a(t),et=i(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-vs66mb"&&(et.textContent=rs),Fl=a(t),c(st.$$.fragment,t),Ql=a(t),nt=i(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1oaq5wg"&&(nt.innerHTML=cs),xl=a(t),c(at.$$.fragment,t),zl=a(t),pt=i(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-13soztx"&&(pt.textContent=os),Yl=a(t),it=i(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-l63hgy"&&(it.textContent=ys),Sl=a(t),c(Mt.$$.fragment,t),ql=a(t),rt=i(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-j98vag"&&(rt.innerHTML=ms),Ll=a(t),ct=i(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-1nqywqo"&&(ct.textContent=us),Pl=a(t),c(ot.$$.fragment,t),Dl=a(t),yt=i(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-17h25cv"&&(yt.innerHTML=ds),Kl=a(t),c(mt.$$.fragment,t),Ol=a(t),ut=i(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1uloopm"&&(ut.textContent=Js),te=a(t),c(dt.$$.fragment,t),le=a(t),Jt=i(t,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-1szcz78"&&(Jt.textContent=Ts),ee=a(t),c(Tt.$$.fragment,t),se=a(t),Ut=i(t,"PRE",{"data-svelte-h":!0}),M(Ut)!=="svelte-4uqjoq"&&(Ut.textContent=Us),ne=a(t),jt=i(t,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-z3edx7"&&(jt.textContent=js),ae=a(t),c(ft.$$.fragment,t),pe=a(t),wt=i(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1ld8ada"&&(wt.innerHTML=fs),ie=a(t),c(ht.$$.fragment,t),Me=a(t),bt=i(t,"P",{"data-svelte-h":!0}),M(bt)!=="svelte-1hua19a"&&(bt.textContent=ws),re=a(t),gt=i(t,"P",{"data-svelte-h":!0}),M(gt)!=="svelte-ouwihd"&&(gt.textContent=hs),ce=a(t),c(It.$$.fragment,t),oe=a(t),c($t.$$.fragment,t),ye=a(t),Ct=i(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-8920me"&&(Ct.textContent=bs),me=a(t),Zt=i(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-itxog8"&&(Zt.innerHTML=gs),ue=a(t),c(kt.$$.fragment,t),de=a(t),_t=i(t,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-1dz0sd2"&&(_t.innerHTML=Is),Je=a(t),Gt=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(Gt)!=="svelte-j08ax7"&&(Gt.innerHTML=$s),Te=a(t),c(Rt.$$.fragment,t),Ue=a(t),Vt=i(t,"P",{"data-svelte-h":!0}),M(Vt)!=="svelte-urgw7d"&&(Vt.textContent=Cs),je=a(t),c(vt.$$.fragment,t),fe=a(t),c(Nt.$$.fragment,t),we=a(t),Bt=i(t,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-1rt7xtt"&&(Bt.textContent=Zs),he=a(t),c(Et.$$.fragment,t),be=a(t),Wt=i(t,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-117eluo"&&(Wt.textContent=ks),ge=a(t),c(Xt.$$.fragment,t),Ie=a(t),Ht=i(t,"P",{"data-svelte-h":!0}),M(Ht)!=="svelte-1trqdgg"&&(Ht.textContent=_s),$e=a(t),c(At.$$.fragment,t),Ce=a(t),c(Ft.$$.fragment,t),Ze=a(t),Qt=i(t,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-1ohmwqx"&&(Qt.innerHTML=Gs),ke=a(t),xt=i(t,"P",{"data-svelte-h":!0}),M(xt)!=="svelte-4d0dji"&&(xt.textContent=Rs),_e=a(t),c(zt.$$.fragment,t),Ge=a(t),Yt=i(t,"P",{"data-svelte-h":!0}),M(Yt)!=="svelte-pyxaad"&&(Yt.textContent=Vs),Re=a(t),c(St.$$.fragment,t),Ve=a(t),qt=i(t,"P",{"data-svelte-h":!0}),M(qt)!=="svelte-1e9t1un"&&(qt.textContent=vs),ve=a(t),Lt=i(t,"P",{"data-svelte-h":!0}),M(Lt)!=="svelte-1isjfj4"&&(Lt.innerHTML=Ns),Ne=a(t),c(Pt.$$.fragment,t),Be=a(t),Dt=i(t,"P",{"data-svelte-h":!0}),M(Dt)!=="svelte-w8ou87"&&(Dt.textContent=Bs),Ee=a(t),Kt=i(t,"UL",{"data-svelte-h":!0}),M(Kt)!=="svelte-1h4ep75"&&(Kt.innerHTML=Es),We=a(t),c(Ot.$$.fragment,t),Xe=a(t),ll=i(t,"P",{}),Ws(ll).forEach(e),this.h()},h(){Xs(T,"name","hf:doc:metadata"),Xs(T,"content",Ps)},m(t,l){Ys(document.head,T),s(t,el,l),s(t,tl,l),s(t,sl,l),o(U,t,l),s(t,nl,l),o(j,t,l),s(t,al,l),s(t,f,l),s(t,pl,l),s(t,w,l),s(t,il,l),s(t,h,l),s(t,Ml,l),s(t,b,l),s(t,rl,l),s(t,g,l),s(t,cl,l),s(t,I,l),s(t,ol,l),s(t,$,l),s(t,yl,l),o(C,t,l),s(t,ml,l),s(t,Z,l),s(t,ul,l),o(k,t,l),s(t,dl,l),o(_,t,l),s(t,Jl,l),s(t,G,l),s(t,Tl,l),o(R,t,l),s(t,Ul,l),o(V,t,l),s(t,jl,l),s(t,v,l),s(t,fl,l),s(t,N,l),s(t,wl,l),o(B,t,l),s(t,hl,l),o(E,t,l),s(t,bl,l),s(t,W,l),s(t,gl,l),o(X,t,l),s(t,Il,l),s(t,H,l),s(t,$l,l),s(t,A,l),s(t,Cl,l),o(F,t,l),s(t,Zl,l),s(t,Q,l),s(t,kl,l),o(x,t,l),s(t,_l,l),s(t,z,l),s(t,Gl,l),o(Y,t,l),s(t,Rl,l),s(t,S,l),s(t,Vl,l),o(q,t,l),s(t,vl,l),s(t,L,l),s(t,Nl,l),s(t,P,l),s(t,Bl,l),o(D,t,l),s(t,El,l),s(t,K,l),s(t,Wl,l),o(O,t,l),s(t,Xl,l),s(t,tt,l),s(t,Hl,l),o(lt,t,l),s(t,Al,l),s(t,et,l),s(t,Fl,l),o(st,t,l),s(t,Ql,l),s(t,nt,l),s(t,xl,l),o(at,t,l),s(t,zl,l),s(t,pt,l),s(t,Yl,l),s(t,it,l),s(t,Sl,l),o(Mt,t,l),s(t,ql,l),s(t,rt,l),s(t,Ll,l),s(t,ct,l),s(t,Pl,l),o(ot,t,l),s(t,Dl,l),s(t,yt,l),s(t,Kl,l),o(mt,t,l),s(t,Ol,l),s(t,ut,l),s(t,te,l),o(dt,t,l),s(t,le,l),s(t,Jt,l),s(t,ee,l),o(Tt,t,l),s(t,se,l),s(t,Ut,l),s(t,ne,l),s(t,jt,l),s(t,ae,l),o(ft,t,l),s(t,pe,l),s(t,wt,l),s(t,ie,l),o(ht,t,l),s(t,Me,l),s(t,bt,l),s(t,re,l),s(t,gt,l),s(t,ce,l),o(It,t,l),s(t,oe,l),o($t,t,l),s(t,ye,l),s(t,Ct,l),s(t,me,l),s(t,Zt,l),s(t,ue,l),o(kt,t,l),s(t,de,l),s(t,_t,l),s(t,Je,l),s(t,Gt,l),s(t,Te,l),o(Rt,t,l),s(t,Ue,l),s(t,Vt,l),s(t,je,l),o(vt,t,l),s(t,fe,l),o(Nt,t,l),s(t,we,l),s(t,Bt,l),s(t,he,l),o(Et,t,l),s(t,be,l),s(t,Wt,l),s(t,ge,l),o(Xt,t,l),s(t,Ie,l),s(t,Ht,l),s(t,$e,l),o(At,t,l),s(t,Ce,l),o(Ft,t,l),s(t,Ze,l),s(t,Qt,l),s(t,ke,l),s(t,xt,l),s(t,_e,l),o(zt,t,l),s(t,Ge,l),s(t,Yt,l),s(t,Re,l),o(St,t,l),s(t,Ve,l),s(t,qt,l),s(t,ve,l),s(t,Lt,l),s(t,Ne,l),o(Pt,t,l),s(t,Be,l),s(t,Dt,l),s(t,Ee,l),s(t,Kt,l),s(t,We,l),o(Ot,t,l),s(t,Xe,l),s(t,ll,l),He=!0},p:As,i(t){He||(y(U.$$.fragment,t),y(j.$$.fragment,t),y(C.$$.fragment,t),y(k.$$.fragment,t),y(_.$$.fragment,t),y(R.$$.fragment,t),y(V.$$.fragment,t),y(B.$$.fragment,t),y(E.$$.fragment,t),y(X.$$.fragment,t),y(F.$$.fragment,t),y(x.$$.fragment,t),y(Y.$$.fragment,t),y(q.$$.fragment,t),y(D.$$.fragment,t),y(O.$$.fragment,t),y(lt.$$.fragment,t),y(st.$$.fragment,t),y(at.$$.fragment,t),y(Mt.$$.fragment,t),y(ot.$$.fragment,t),y(mt.$$.fragment,t),y(dt.$$.fragment,t),y(Tt.$$.fragment,t),y(ft.$$.fragment,t),y(ht.$$.fragment,t),y(It.$$.fragment,t),y($t.$$.fragment,t),y(kt.$$.fragment,t),y(Rt.$$.fragment,t),y(vt.$$.fragment,t),y(Nt.$$.fragment,t),y(Et.$$.fragment,t),y(Xt.$$.fragment,t),y(At.$$.fragment,t),y(Ft.$$.fragment,t),y(zt.$$.fragment,t),y(St.$$.fragment,t),y(Pt.$$.fragment,t),y(Ot.$$.fragment,t),He=!0)},o(t){m(U.$$.fragment,t),m(j.$$.fragment,t),m(C.$$.fragment,t),m(k.$$.fragment,t),m(_.$$.fragment,t),m(R.$$.fragment,t),m(V.$$.fragment,t),m(B.$$.fragment,t),m(E.$$.fragment,t),m(X.$$.fragment,t),m(F.$$.fragment,t),m(x.$$.fragment,t),m(Y.$$.fragment,t),m(q.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(lt.$$.fragment,t),m(st.$$.fragment,t),m(at.$$.fragment,t),m(Mt.$$.fragment,t),m(ot.$$.fragment,t),m(mt.$$.fragment,t),m(dt.$$.fragment,t),m(Tt.$$.fragment,t),m(ft.$$.fragment,t),m(ht.$$.fragment,t),m(It.$$.fragment,t),m($t.$$.fragment,t),m(kt.$$.fragment,t),m(Rt.$$.fragment,t),m(vt.$$.fragment,t),m(Nt.$$.fragment,t),m(Et.$$.fragment,t),m(Xt.$$.fragment,t),m(At.$$.fragment,t),m(Ft.$$.fragment,t),m(zt.$$.fragment,t),m(St.$$.fragment,t),m(Pt.$$.fragment,t),m(Ot.$$.fragment,t),He=!1},d(t){t&&(e(el),e(tl),e(sl),e(nl),e(al),e(f),e(pl),e(w),e(il),e(h),e(Ml),e(b),e(rl),e(g),e(cl),e(I),e(ol),e($),e(yl),e(ml),e(Z),e(ul),e(dl),e(Jl),e(G),e(Tl),e(Ul),e(jl),e(v),e(fl),e(N),e(wl),e(hl),e(bl),e(W),e(gl),e(Il),e(H),e($l),e(A),e(Cl),e(Zl),e(Q),e(kl),e(_l),e(z),e(Gl),e(Rl),e(S),e(Vl),e(vl),e(L),e(Nl),e(P),e(Bl),e(El),e(K),e(Wl),e(Xl),e(tt),e(Hl),e(Al),e(et),e(Fl),e(Ql),e(nt),e(xl),e(zl),e(pt),e(Yl),e(it),e(Sl),e(ql),e(rt),e(Ll),e(ct),e(Pl),e(Dl),e(yt),e(Kl),e(Ol),e(ut),e(te),e(le),e(Jt),e(ee),e(se),e(Ut),e(ne),e(jt),e(ae),e(pe),e(wt),e(ie),e(Me),e(bt),e(re),e(gt),e(ce),e(oe),e(ye),e(Ct),e(me),e(Zt),e(ue),e(de),e(_t),e(Je),e(Gt),e(Te),e(Ue),e(Vt),e(je),e(fe),e(we),e(Bt),e(he),e(be),e(Wt),e(ge),e(Ie),e(Ht),e($e),e(Ce),e(Ze),e(Qt),e(ke),e(xt),e(_e),e(Ge),e(Yt),e(Re),e(Ve),e(qt),e(ve),e(Lt),e(Ne),e(Be),e(Dt),e(Ee),e(Kt),e(We),e(Xe),e(ll)),e(T),u(U,t),u(j,t),u(C,t),u(k,t),u(_,t),u(R,t),u(V,t),u(B,t),u(E,t),u(X,t),u(F,t),u(x,t),u(Y,t),u(q,t),u(D,t),u(O,t),u(lt,t),u(st,t),u(at,t),u(Mt,t),u(ot,t),u(mt,t),u(dt,t),u(Tt,t),u(ft,t),u(ht,t),u(It,t),u($t,t),u(kt,t),u(Rt,t),u(vt,t),u(Nt,t),u(Et,t),u(Xt,t),u(At,t),u(Ft,t),u(zt,t),u(St,t),u(Pt,t),u(Ot,t)}}}const Ps='{"title":"⚖️ 创建一个合法偏好数据集","local":"-创建一个合法偏好数据集","sections":[{"title":"简介","local":"简介","sections":[{"title":"导入依赖项","local":"导入依赖项","sections":[],"depth":3},{"title":"环境变量","local":"环境变量","sections":[],"depth":3}],"depth":2},{"title":"使用 Notus 设置推理端点","local":"使用-notus-设置推理端点","sections":[{"title":"为 distilabel 流水线定义一个自定义生成任务","local":"为-distilabel-流水线定义一个自定义生成任务","sections":[],"depth":3}],"depth":2},{"title":"使用 Haystack 为欧洲人工智能法案创建 RAG 流水线","local":"使用-haystack-为欧洲人工智能法案创建-rag-流水线","sections":[{"title":"下载人工智能法案 PDF","local":"下载人工智能法案-pdf","sections":[],"depth":3}],"depth":2},{"title":"使用 SelfInstructTask 生成指令","local":"使用-selfinstructtask-生成指令","sections":[{"title":"将指令数据集推送到Argilla以进行可视化和注释。","local":"将指令数据集推送到argilla以进行可视化和注释","sections":[],"depth":3}],"depth":2},{"title":"使用 Ultrafeedback 文本质量任务生成偏好数据集","local":"使用-ultrafeedback-文本质量任务生成偏好数据集","sections":[],"depth":2},{"title":"使用 Argilla 进行人工反馈","local":"使用-argilla-进行人工反馈","sections":[],"depth":2},{"title":"结论","local":"结论","sections":[],"depth":2}],"depth":1}';function Ds(Ae){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends Qs{constructor(T){super(),xs(this,T,Ds,Ls,Hs,{})}}export{en as component};
