import{s as as,n as is,o as os}from"../chunks/scheduler.65852ee5.js";import{S as rs,i as ps,g as i,s as n,r as p,A as ms,h as o,f as l,c as a,j as ss,u as m,x as r,k as ns,y as hs,a as s,v as h,d as M,t as c,w as y}from"../chunks/index.aa74147d.js";import{D as Ms,C as d}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as g,E as cs}from"../chunks/EditOnGithub.4eda6a96.js";function ys(cl){let u,Le,Ne,Se,f,Qe,w,Fe,b,yl='<em>Authored by: <a href="https://github.com/sergiopaniego" rel="nofollow">Sergio Paniego</a></em>',Ee,T,dl="🚨 <strong>WARNING</strong>: This notebook is <strong>resource-intensive</strong> and requires substantial computational power. If you’re running this in <strong>Colab</strong>, it will utilize an <strong>A100 GPU</strong>.",Ye,qe,ze,J,gl='In this recipe, we’ll guide you through extending the inference time for an <strong>Instruct LLM system</strong> using <strong>test-time compute</strong> to solve more challenging problems, such as <strong>complex math problems</strong>. This approach, inspired by <a href="https://openai.com/index/learning-to-reason-with-llms/" rel="nofollow"><strong>OpenAI o1-o3 models</strong></a>, demonstrates that <strong>longer reasoning time</strong> during inference can enhance model performance.',Ae,U,ul='This technique builds on experiments shared in <a href="https://huggingface.co/spaces/HuggingFaceH4/blogpost-scaling-test-time-compute" rel="nofollow">this <strong>blog post</strong></a>, which show that smaller models, like the <strong>1B</strong> and <strong>3B Llama Instruct models</strong>, can outperform much larger ones on the <strong>MATH-500 benchmark</strong> when given enough <strong>“time to think”</strong>. Recent research from <a href="https://arxiv.org/abs/2408.03314" rel="nofollow">DeepMind</a> suggests that <strong>test-time compute</strong> can be scaled optimally through strategies like iterative self-refinement or using a reward model.',Pe,j,fl='The blog introduces a <a href="https://github.com/huggingface/search-and-learn" rel="nofollow"><strong>new repository</strong></a> for running these experiments. In this recipe, we’ll focus on building a <strong>small chatbot</strong> that engages in <strong>longer reasoning</strong> to tackle <strong>harder problems</strong> using small open models.',De,$,wl='<img src="https://huggingface.co/datasets/HuggingFaceH4/blogpost-images/resolve/main/methods-thumbnail.png" alt="Instruct LLM Methodology"/>',Ke,C,Oe,I,bl=`Let’s start by installing the <a href="https://github.com/huggingface/search-and-learn" rel="nofollow">search-and-learn</a> repository! 🚀<br/>
This repo is designed to replicate the experimental results and is not a Python pip package. However, we can still use it to generate our system. To do so, we’ll need to install it from source with the following steps:`,et,Z,tt,v,lt,k,Tl=`Log in to Hugging Face to access <a href="https://huggingface.co/meta-llama/Llama-3.2-1B-Instruct" rel="nofollow">meta-llama/Llama-3.2-1B-Instruct</a>, as it is a gated model! 🗝️<br/>
If you haven’t previously requested access, you’ll need to submit a request before proceeding.`,st,G,nt,B,at,R,Jl='As illustrated in the diagram, the system consists of an LLM that generates intermediate answers based on user input, a <a href="https://huggingface.co/papers/2211.14275" rel="nofollow">PRM model</a> that evaluates and scores these answers, and a search strategy that uses the PRM feedback to guide the subsequent steps in the search process until reaching the final answer.',it,_,Ul='Let’s begin by initializing each model. For the LLM, we’ll use the <a href="https://huggingface.co/meta-llama/Llama-3.2-1B-Instruct" rel="nofollow">meta-llama/Llama-3.2-1B-Instruct</a> model, and for the PRM, we’ll use the <a href="https://huggingface.co/RLHFlow/Llama3.1-8B-PRM-Deepseek-Data" rel="nofollow">RLHFlow/Llama3.1-8B-PRM-Deepseek-Data</a> model.',ot,x,jl='<img src="https://huggingface.co/datasets/HuggingFaceH4/blogpost-images/resolve/main/system.png" alt="system"/>',rt,W,pt,H,mt,X,$l="Now that we’ve set up the LLM and PRM, let’s proceed by defining the question, selecting a search strategy to retrieve relevant information, and calling the pipeline to process the question through the models.",ht,N,Cl='<li><p><strong>Instantiate the Question</strong>: In this step, we define the input question that the system will answer, considering the given context.</p></li> <li><p><strong>Search Strategy</strong>: The system currently supports the following search strategies: <code>best_of_n</code>, <code>beam_search</code>, and <code>dvts</code> (see diagram). For this example, we’ll use <code>best_of_n</code>, but you can easily switch to any of the other strategies based on your needs. We need to define some configuration parameters for the configuration of the search strategy. You can check the full list <a href="https://github.com/huggingface/search-and-learn/blob/main/src/sal/config.py" rel="nofollow">here</a>.</p></li> <li><p><strong>Call the Pipeline</strong>: With the question and search strategy in place, we’ll call the inference pipeline, processing the inputs through both the LLM and PRM to generate the final answer.</p></li>',Mt,V,Il='<img src="https://huggingface.co/datasets/HuggingFaceH4/blogpost-images/resolve/main/search-strategies.png"/>',ct,L,Zl="The first step is to clearly define the question that the system will answer. This ensures that we have a precise task for the model to tackle.",yt,S,dt,Q,vl="Next, we define the configuration, including parameters like the number of candidate answers <code>(N)</code>, and choose the search strategy that will be used. The search strategy dictates how we explore the potential answers. In this case, we’ll use <code>best_of_n</code>.",gt,F,kl="With the question and configuration in place, we use the selected search strategy to generate multiple candidate answers. These candidates are evaluated based on their relevance and quality and the final answer is returned.",ut,E,ft,Y,wt,q,Gl="Once the pipeline has processed the question through the LLM and PRM, we can display the final result. This result will be the model’s output after considering the intermediate answers and scoring them using the PRM.",bt,z,Bl="Here’s how to display the final answer:",Tt,A,Jt,P,Rl="The model’s output might include special tokens, such as <code>&lt;|start_header_id|&gt;</code> or <code>&lt;|end_header_id|&gt;</code>. To make the answer more readable, we can safely remove them before displaying it to the end user.",Ut,D,jt,K,_l="After removing any special tokens, we can display the final answer to the user. Since the answer is based on markdown, it can be rendered properly by displaying it as markdown.",$t,O,Ct,ee,It,te,xl="Now, let’s create a method that encapsulates the entire pipeline. This will allow us to easily reuse the process in future applications, making it efficient and modular.",Zt,le,Wl="By combining the LLM, PRM, search strategy, and result display, we can simplify the workflow and ensure that it’s reusable for other tasks or questions.",vt,se,Hl="We simplify the workflow, ensuring that it’s reusable for different tasks or questions. Additionally, we’ll track the time spent on each method so that we can <strong>understand the practical implications</strong> of using each strategy and configuration.",kt,ne,Xl="Here’s how we can structure the method:",Gt,ae,Bt,ie,Rt,oe,Nl="Let’s compare the <strong>thinking time</strong> of three methods: <code>best_of_n</code>, <code>beam_search</code>, and <code>dvts</code>. Each method is evaluated using the same number of answers during the search process, measuring the time spent thinking in seconds and the number of generated tokens.",_t,re,Vl="In the results below, the <code>best_of_n</code> method shows the least thinking time, while the <code>dvts</code> method takes the most time. However, <code>best_of_n</code> generates more tokens due to its simpler search strategy.",xt,pe,Ll="<thead><tr><th><strong>Method</strong></th> <th><strong>Number of Answers During Search</strong></th> <th><strong>Thinking Time (Seconds)</strong></th> <th><strong>Generated Tokens</strong></th></tr></thead> <tbody><tr><td><strong>best_of_n</strong></td> <td>8</td> <td>3.54</td> <td>3087</td></tr> <tr><td><strong>beam_search</strong></td> <td>8</td> <td>10.06</td> <td>2049</td></tr> <tr><td><strong>dvts</strong></td> <td>8</td> <td>8.46</td> <td>2544</td></tr></tbody>",Wt,me,Sl="This comparison illustrates the trade-offs between the strategies, balancing time spent thinking and the complexity of the search process.",Ht,he,Xt,Me,Ql="We’ll begin by using the <code>best_of_n</code> strategy. Here’s how to track the thinking time for this method:",Nt,ce,Vt,ye,Fl=`Finished in 3.54 seconds

Total tokens in all completions: 3087
`,Lt,de,St,ge,Qt,ue,El="Now, let’s try using the <code>beam_search</code> strategy.",Ft,fe,Et,we,Yl=`Finished in 10.06 seconds

Total tokens in all completions: 2049
`,Yt,be,qt,Te,zt,Je,ql="Finally, let’s try the <code>dvts</code> strategy.",At,Ue,Pt,je,zl=`Finished in 8.46 seconds

Total tokens in all completions: 2544
`,Dt,$e,Kt,Ce,Ot,Ie,Al="In this final example, we’ll test the system using a straightforward question to observe how it performs in simpler cases. This allows us to verify that the system works as expected even for basic queries.",el,Ze,Pl="Let’s try the following question:",tl,ve,ll,ke,Dl=`Finished in 1.03 seconds

Total tokens in all completions: 544
`,sl,Ge,nl,Be,Kl="Even though we set a larger number of candidate answers (<code>N</code>), the time spent thinking remains relatively small (1.03 seconds and 544 generated tokens). This demonstrates the system’s ability to efficiently handle easier problems, spending less time on them, while leveraging its enhanced capabilities for more complex questions.",al,Re,Ol="🏆 <strong>We now have a fully operational pipeline</strong> that leverages test-time compute, enabling the system to “think longer” for more complicated queries, while also maintaining fast response times for straightforward questions.",il,_e,es="This approach ensures the system can scale its thinking time based on the task’s complexity, offering an efficient and responsive solution for both simple and challenging problems.",ol,xe,rl,We,ts='If you’re eager to continue exploring, be sure to check out the original experimental <a href="https://huggingface.co/spaces/HuggingFaceH4/blogpost-scaling-test-time-compute" rel="nofollow">blog</a> and all the references mentioned within it. These resources will deepen your understanding of test-time compute, its benefits, and its applications in LLMs.',pl,He,ls="Happy learning and experimenting! 🚀",ml,Xe,hl,Ve,Ml;return f=new Ms({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/search_and_learn.ipynb"}]}}),w=new g({props:{title:"Scaling Test-Time Compute for Longer Thinking in LLMs",local:"scaling-test-time-compute-for-longer-thinking-in-llms",headingTag:"h1"}}),C=new g({props:{title:"1. Install Dependencies",local:"1-install-dependencies",headingTag:"h2"}}),Z=new d({props:{code:"IWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZzZWFyY2gtYW5kLWxlYXJu",highlighted:'!git clone https://github.com/huggingface/search-<span class="hljs-keyword">and</span>-learn',wrap:!1}}),v=new d({props:{code:"JTI1Y2QlMjBzZWFyY2gtYW5kLWxlYXJuJTBBIXBpcCUyMGluc3RhbGwlMjAtZSUyMCcuJTVCZGV2JTVEJw==",highlighted:`%cd search-<span class="hljs-keyword">and</span>-learn
!pip install -e <span class="hljs-string">&#x27;.[dev]&#x27;</span>`,wrap:!1}}),G=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),B=new g({props:{title:"2. Setup the Large Language Model (LLM) and the Process Reward Model (PRM) 💬",local:"2-setup-the-large-language-model-llm-and-the-process-reward-model-prm-",headingTag:"h2"}}),W=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdmxsbSUyMGltcG9ydCUyMExMTSUwQWZyb20lMjBzYWwubW9kZWxzLnJld2FyZF9tb2RlbHMlMjBpbXBvcnQlMjBSTEhGRmxvdyUwQSUwQW1vZGVsX3BhdGglMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTFCLUluc3RydWN0JTIyJTBBcHJtX3BhdGglMjAlM0QlMjAlMjJSTEhGbG93JTJGTGxhbWEzLjEtOEItUFJNLURlZXBzZWVrLURhdGElMjIlMEElMEFsbG0lMjAlM0QlMjBMTE0oJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbF9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwZ3B1X21lbW9yeV91dGlsaXphdGlvbiUzRDAuNSUyQyUyMCUyMCUyMyUyMFV0aWxpemUlMjA1MCUyNSUyMG9mJTIwR1BVJTIwbWVtb3J5JTBBJTIwJTIwJTIwJTIwZW5hYmxlX3ByZWZpeF9jYWNoaW5nJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyME9wdGltaXplJTIwcmVwZWF0ZWQlMjBwcmVmaXglMjBjb21wdXRhdGlvbnMlMEElMjAlMjAlMjAlMjBzZWVkJTNENDIlMkMlMjAlMjAlMjMlMjBTZXQlMjBzZWVkJTIwZm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBKSUwQSUwQXBybSUyMCUzRCUyMFJMSEZGbG93KHBybV9wYXRoKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> LLM
<span class="hljs-keyword">from</span> sal.models.reward_models <span class="hljs-keyword">import</span> RLHFFlow

model_path = <span class="hljs-string">&quot;meta-llama/Llama-3.2-1B-Instruct&quot;</span>
prm_path = <span class="hljs-string">&quot;RLHFlow/Llama3.1-8B-PRM-Deepseek-Data&quot;</span>

llm = LLM(
    model=model_path,
    gpu_memory_utilization=<span class="hljs-number">0.5</span>,  <span class="hljs-comment"># Utilize 50% of GPU memory</span>
    enable_prefix_caching=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Optimize repeated prefix computations</span>
    seed=<span class="hljs-number">42</span>,  <span class="hljs-comment"># Set seed for reproducibility</span>
)

prm = RLHFFlow(prm_path)`,wrap:!1}}),H=new g({props:{title:"2.1 Instantiate the Question, Search Strategy, and Call the Pipeline",local:"21-instantiate-the-question-search-strategy-and-call-the-pipeline",headingTag:"h3"}}),S=new d({props:{code:"cXVlc3Rpb25fdGV4dCUyMCUzRCUyMCUyMkNvbnZlcnQlMjB0aGUlMjBwb2ludCUyMCUyNCgwJTJDMyklMjQlMjBpbiUyMHJlY3Rhbmd1bGFyJTIwY29vcmRpbmF0ZXMlMjB0byUyMHBvbGFyJTIwY29vcmRpbmF0ZXMuJTIwJTIwRW50ZXIlMjB5b3VyJTIwYW5zd2VyJTIwaW4lMjB0aGUlMjBmb3JtJTIwJTI0KHIlMkMlNUN0aGV0YSklMkMlMjQlMjB3aGVyZSUyMCUyNHIlMjAlM0UlMjAwJTI0JTIwYW5kJTIwJTI0MCUyMCU1Q2xlJTIwJTVDdGhldGElMjAlM0MlMjAyJTIwJTVDcGkuJTI0JTIyJTBBaW5wdXRfYmF0Y2glMjAlM0QlMjAlN0IlMjJwcm9ibGVtJTIyJTNBJTIwJTVCcXVlc3Rpb25fdGV4dCU1RCU3RA==",highlighted:`question_text = <span class="hljs-string">&quot;Convert the point $(0,3)$ in rectangular coordinates to polar coordinates.  Enter your answer in the form $(r,\\theta),$ where $r &gt; 0$ and $0 \\le \\theta &lt; 2 \\pi.$&quot;</span>
input_batch = {<span class="hljs-string">&quot;problem&quot;</span>: [question_text]}`,wrap:!1}}),E=new d({props:{code:"ZnJvbSUyMHNhbC5jb25maWclMjBpbXBvcnQlMjBDb25maWclMEFmcm9tJTIwc2FsLnNlYXJjaCUyMGltcG9ydCUyMGJlYW1fc2VhcmNoJTJDJTIwYmVzdF9vZl9uJTJDJTIwZHZ0cyUwQSUwQWNvbmZpZyUyMCUzRCUyMENvbmZpZygpJTBBY29uZmlnLm4lMjAlM0QlMjAzMiUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwYW5zd2VycyUyMHRvJTIwZ2VuZXJhdGUlMjBkdXJpbmclMjB0aGUlMjBzZWFyY2glMEElMEFzZWFyY2hfcmVzdWx0JTIwJTNEJTIwYmVzdF9vZl9uKHglM0RpbnB1dF9iYXRjaCUyQyUyMGNvbmZpZyUzRGNvbmZpZyUyQyUyMGxsbSUzRGxsbSUyQyUyMHBybSUzRHBybSk=",highlighted:`<span class="hljs-keyword">from</span> sal.config <span class="hljs-keyword">import</span> Config
<span class="hljs-keyword">from</span> sal.search <span class="hljs-keyword">import</span> beam_search, best_of_n, dvts

config = Config()
config.n = <span class="hljs-number">32</span>  <span class="hljs-comment"># Number of answers to generate during the search</span>

search_result = best_of_n(x=input_batch, config=config, llm=llm, prm=prm)`,wrap:!1}}),Y=new g({props:{title:"2.2 Display the Final Result",local:"22-display-the-final-result",headingTag:"h3"}}),A=new d({props:{code:"c2VhcmNoX3Jlc3VsdCU1QiUyMnByZWQlMjIlNUQlNUIwJTVE",highlighted:'search_result[<span class="hljs-string">&quot;pred&quot;</span>][<span class="hljs-number">0</span>]',wrap:!1}}),D=new d({props:{code:"Zm9ybWF0dGVkX291dHB1dCUyMCUzRCUyMHNlYXJjaF9yZXN1bHQlNUIlMjJwcmVkJTIyJTVEJTVCMCU1RC5yZXBsYWNlKCUyMiUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRWFzc2lzdGFudCUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlNUNuJTVDbiUyMiUyQyUyMCUyMiUyMikuc3RyaXAoKSUwQWZvcm1hdHRlZF9vdXRwdXQ=",highlighted:`formatted_output = search_result[<span class="hljs-string">&quot;pred&quot;</span>][<span class="hljs-number">0</span>].replace(<span class="hljs-string">&quot;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>, <span class="hljs-string">&quot;&quot;</span>).strip()
formatted_output`,wrap:!1}}),O=new d({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMGRpc3BsYXklMkMlMjBNYXJrZG93biUwQSUwQWRpc3BsYXkoTWFya2Rvd24oZm9ybWF0dGVkX291dHB1dCkp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> display, Markdown

display(Markdown(formatted_output))`,wrap:!1}}),ee=new g({props:{title:"3. Assembling It All! 🧑‍🏭️",local:"3-assembling-it-all-",headingTag:"h2"}}),ae=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_with_search_and_learn</span>(<span class="hljs-params">question, config, llm, prm, method=<span class="hljs-string">&quot;best_of_n&quot;</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate an answer for a given question using the search-and-learn pipeline.

    Args:
    - question (str): The input question to generate an answer for.
    - config (Config): Configuration object containing parameters for search strategy.
    - llm (LLM): Pretrained large language model used for generating answers.
    - prm (RLHFFlow): Process reward model used for evaluating answers.
    - method (str): Search strategy to use. Options are &#x27;best_of_n&#x27;, &#x27;beam_search&#x27;, &#x27;dvts&#x27;. Default is &#x27;best_of_n&#x27;.

    Returns:
    - str: The formatted output after processing the question.
    &quot;&quot;&quot;</span>
    batch = {<span class="hljs-string">&quot;problem&quot;</span>: [question]}

    start_time = time.time()
    <span class="hljs-keyword">if</span> method == <span class="hljs-string">&quot;best_of_n&quot;</span>:
        result = best_of_n(x=batch, config=config, llm=llm, prm=prm)
    <span class="hljs-keyword">elif</span> method == <span class="hljs-string">&quot;beam_search&quot;</span>:
        result = beam_search(examples=batch, config=config, llm=llm, prm=prm)
    <span class="hljs-keyword">elif</span> method == <span class="hljs-string">&quot;dvts&quot;</span>:
        result = dvts(examples=batch, config=config, llm=llm, prm=prm)

    elapsed_time = time.time() - start_time
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nFinished in <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.2</span>f}</span> seconds\\n&quot;</span>)

    tokenizer = llm.get_tokenizer()
    total_tokens = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> result[<span class="hljs-string">&quot;completions&quot;</span>]:
        <span class="hljs-keyword">for</span> comp <span class="hljs-keyword">in</span> completion:
            output_tokens = tokenizer.encode(comp)
            total_tokens += <span class="hljs-built_in">len</span>(output_tokens)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total tokens in all completions: <span class="hljs-subst">{total_tokens}</span>&quot;</span>)

    formatted_output = result[<span class="hljs-string">&quot;pred&quot;</span>][<span class="hljs-number">0</span>].replace(<span class="hljs-string">&quot;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>, <span class="hljs-string">&quot;&quot;</span>).strip()
    <span class="hljs-keyword">return</span> formatted_output`,wrap:!1}}),ie=new g({props:{title:"⏳  3.1 Comparing Thinking Time for Each Strategy",local:"-31-comparing-thinking-time-for-each-strategy",headingTag:"h3"}}),he=new g({props:{title:"1. Best of n",local:"1-best-of-n",headingTag:"h4"}}),ce=new d({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJDb252ZXJ0JTIwdGhlJTIwcG9pbnQlMjAlMjQoMCUyQzMpJTI0JTIwaW4lMjByZWN0YW5ndWxhciUyMGNvb3JkaW5hdGVzJTIwdG8lMjBwb2xhciUyMGNvb3JkaW5hdGVzLiUyMCUyMEVudGVyJTIweW91ciUyMGFuc3dlciUyMGluJTIwdGhlJTIwZm9ybSUyMCUyNChyJTJDJTVDdGhldGEpJTJDJTI0JTIwd2hlcmUlMjAlMjRyJTIwJTNFJTIwMCUyNCUyMGFuZCUyMCUyNDAlMjAlNUNsZSUyMCU1Q3RoZXRhJTIwJTNDJTIwMiUyMCU1Q3BpLiUyNCUyMiUwQSUwQWNvbmZpZy5uJTIwJTNEJTIwOCUwQSUwQWZvcm1hdHRlZF9vdXRwdXQlMjAlM0QlMjBnZW5lcmF0ZV93aXRoX3NlYXJjaF9hbmRfbGVhcm4oJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0RxdWVzdGlvbiUyQyUyMGNvbmZpZyUzRGNvbmZpZyUyQyUyMGxsbSUzRGxsbSUyQyUyMHBybSUzRHBybSUyQyUyMG1ldGhvZCUzRCUyMmJlc3Rfb2ZfbiUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;Convert the point $(0,3)$ in rectangular coordinates to polar coordinates.  Enter your answer in the form $(r,\\theta),$ where $r &gt; 0$ and $0 \\le \\theta &lt; 2 \\pi.$&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>config.n = <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted_output = generate_with_search_and_learn(
<span class="hljs-meta">... </span>    question=question, config=config, llm=llm, prm=prm, method=<span class="hljs-string">&quot;best_of_n&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),de=new d({props:{code:"ZGlzcGxheShNYXJrZG93bihmb3JtYXR0ZWRfb3V0cHV0KSk=",highlighted:"display(Markdown(formatted_output))",wrap:!1}}),ge=new g({props:{title:"2. Beam Search",local:"2-beam-search",headingTag:"h4"}}),fe=new d({props:{code:"Y29uZmlnLm4lMjAlM0QlMjA4JTBBJTIzJTIwYmVhbSUyMHNlYXJjaCUyMHNwZWNpZmljJTBBY29uZmlnLnNvcnRfY29tcGxldGVkJTIwJTNEJTIwVHJ1ZSUwQWNvbmZpZy5maWx0ZXJfZHVwbGljYXRlcyUyMCUzRCUyMFRydWUlMEElMEFmb3JtYXR0ZWRfb3V0cHV0JTIwJTNEJTIwZ2VuZXJhdGVfd2l0aF9zZWFyY2hfYW5kX2xlYXJuKCUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNEcXVlc3Rpb24lMkMlMjBjb25maWclM0Rjb25maWclMkMlMjBsbG0lM0RsbG0lMkMlMjBwcm0lM0Rwcm0lMkMlMjBtZXRob2QlM0QlMjJiZWFtX3NlYXJjaCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>config.n = <span class="hljs-number">8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># beam search specific</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config.sort_completed = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config.filter_duplicates = <span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted_output = generate_with_search_and_learn(
<span class="hljs-meta">... </span>    question=question, config=config, llm=llm, prm=prm, method=<span class="hljs-string">&quot;beam_search&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),be=new d({props:{code:"ZGlzcGxheShNYXJrZG93bihmb3JtYXR0ZWRfb3V0cHV0KSk=",highlighted:"display(Markdown(formatted_output))",wrap:!1}}),Te=new g({props:{title:"3. Diverse Verifier Tree Search (DVTS)",local:"3-diverse-verifier-tree-search-dvts",headingTag:"h4"}}),Ue=new d({props:{code:"Y29uZmlnLm4lMjAlM0QlMjA4JTBBJTIzJTIwZHZ0cyUyMHNwZWNpZmljJTBBY29uZmlnLm5fYmVhbXMlMjAlM0QlMjBjb25maWcubiUyMCUyRiUyRiUyMGNvbmZpZy5iZWFtX3dpZHRoJTBBJTBBZm9ybWF0dGVkX291dHB1dCUyMCUzRCUyMGdlbmVyYXRlX3dpdGhfc2VhcmNoX2FuZF9sZWFybiglMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRHF1ZXN0aW9uJTJDJTIwY29uZmlnJTNEY29uZmlnJTJDJTIwbGxtJTNEbGxtJTJDJTIwcHJtJTNEcHJtJTJDJTIwbWV0aG9kJTNEJTIyZHZ0cyUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>config.n = <span class="hljs-number">8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># dvts specific</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config.n_beams = config.n // config.beam_width

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted_output = generate_with_search_and_learn(
<span class="hljs-meta">... </span>    question=question, config=config, llm=llm, prm=prm, method=<span class="hljs-string">&quot;dvts&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),$e=new d({props:{code:"ZGlzcGxheShNYXJrZG93bihmb3JtYXR0ZWRfb3V0cHV0KSk=",highlighted:"display(Markdown(formatted_output))",wrap:!1}}),Ce=new g({props:{title:"🙋 3.2 Testing the System with a Simple Question",local:"-32-testing-the-system-with-a-simple-question",headingTag:"h3"}}),ve=new d({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBTcGFpbiUzRiUyMiUwQSUwQWNvbmZpZy5uJTIwJTNEJTIwMzIlMEElMEFmb3JtYXR0ZWRfb3V0cHV0JTIwJTNEJTIwZ2VuZXJhdGVfd2l0aF9zZWFyY2hfYW5kX2xlYXJuKCUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNEcXVlc3Rpb24lMkMlMjBjb25maWclM0Rjb25maWclMkMlMjBsbG0lM0RsbG0lMkMlMjBwcm0lM0Rwcm0lMkMlMjBtZXRob2QlM0QlMjJiZXN0X29mX24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>config.n = <span class="hljs-number">32</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted_output = generate_with_search_and_learn(
<span class="hljs-meta">... </span>    question=question, config=config, llm=llm, prm=prm, method=<span class="hljs-string">&quot;best_of_n&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ge=new d({props:{code:"ZGlzcGxheShNYXJrZG93bihmb3JtYXR0ZWRfb3V0cHV0KSk=",highlighted:"display(Markdown(formatted_output))",wrap:!1}}),xe=new g({props:{title:"4. Continuing the Journey and Resources 🧑‍🎓️",local:"4-continuing-the-journey-and-resources-",headingTag:"h2"}}),Xe=new cs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/search_and_learn.md"}}),{c(){u=i("meta"),Le=n(),Ne=i("p"),Se=n(),p(f.$$.fragment),Qe=n(),p(w.$$.fragment),Fe=n(),b=i("p"),b.innerHTML=yl,Ee=n(),T=i("p"),T.innerHTML=dl,Ye=n(),qe=i("hr"),ze=n(),J=i("p"),J.innerHTML=gl,Ae=n(),U=i("p"),U.innerHTML=ul,Pe=n(),j=i("p"),j.innerHTML=fl,De=n(),$=i("p"),$.innerHTML=wl,Ke=n(),p(C.$$.fragment),Oe=n(),I=i("p"),I.innerHTML=bl,et=n(),p(Z.$$.fragment),tt=n(),p(v.$$.fragment),lt=n(),k=i("p"),k.innerHTML=Tl,st=n(),p(G.$$.fragment),nt=n(),p(B.$$.fragment),at=n(),R=i("p"),R.innerHTML=Jl,it=n(),_=i("p"),_.innerHTML=Ul,ot=n(),x=i("p"),x.innerHTML=jl,rt=n(),p(W.$$.fragment),pt=n(),p(H.$$.fragment),mt=n(),X=i("p"),X.textContent=$l,ht=n(),N=i("ol"),N.innerHTML=Cl,Mt=n(),V=i("p"),V.innerHTML=Il,ct=n(),L=i("p"),L.textContent=Zl,yt=n(),p(S.$$.fragment),dt=n(),Q=i("p"),Q.innerHTML=vl,gt=n(),F=i("p"),F.textContent=kl,ut=n(),p(E.$$.fragment),ft=n(),p(Y.$$.fragment),wt=n(),q=i("p"),q.textContent=Gl,bt=n(),z=i("p"),z.textContent=Bl,Tt=n(),p(A.$$.fragment),Jt=n(),P=i("p"),P.innerHTML=Rl,Ut=n(),p(D.$$.fragment),jt=n(),K=i("p"),K.textContent=_l,$t=n(),p(O.$$.fragment),Ct=n(),p(ee.$$.fragment),It=n(),te=i("p"),te.textContent=xl,Zt=n(),le=i("p"),le.textContent=Wl,vt=n(),se=i("p"),se.innerHTML=Hl,kt=n(),ne=i("p"),ne.textContent=Xl,Gt=n(),p(ae.$$.fragment),Bt=n(),p(ie.$$.fragment),Rt=n(),oe=i("p"),oe.innerHTML=Nl,_t=n(),re=i("p"),re.innerHTML=Vl,xt=n(),pe=i("table"),pe.innerHTML=Ll,Wt=n(),me=i("p"),me.textContent=Sl,Ht=n(),p(he.$$.fragment),Xt=n(),Me=i("p"),Me.innerHTML=Ql,Nt=n(),p(ce.$$.fragment),Vt=n(),ye=i("pre"),ye.textContent=Fl,Lt=n(),p(de.$$.fragment),St=n(),p(ge.$$.fragment),Qt=n(),ue=i("p"),ue.innerHTML=El,Ft=n(),p(fe.$$.fragment),Et=n(),we=i("pre"),we.textContent=Yl,Yt=n(),p(be.$$.fragment),qt=n(),p(Te.$$.fragment),zt=n(),Je=i("p"),Je.innerHTML=ql,At=n(),p(Ue.$$.fragment),Pt=n(),je=i("pre"),je.textContent=zl,Dt=n(),p($e.$$.fragment),Kt=n(),p(Ce.$$.fragment),Ot=n(),Ie=i("p"),Ie.textContent=Al,el=n(),Ze=i("p"),Ze.textContent=Pl,tl=n(),p(ve.$$.fragment),ll=n(),ke=i("pre"),ke.textContent=Dl,sl=n(),p(Ge.$$.fragment),nl=n(),Be=i("p"),Be.innerHTML=Kl,al=n(),Re=i("p"),Re.innerHTML=Ol,il=n(),_e=i("p"),_e.textContent=es,ol=n(),p(xe.$$.fragment),rl=n(),We=i("p"),We.innerHTML=ts,pl=n(),He=i("p"),He.textContent=ls,ml=n(),p(Xe.$$.fragment),hl=n(),Ve=i("p"),this.h()},l(e){const t=ms("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),Le=a(e),Ne=o(e,"P",{}),ss(Ne).forEach(l),Se=a(e),m(f.$$.fragment,e),Qe=a(e),m(w.$$.fragment,e),Fe=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1i2zwz9"&&(b.innerHTML=yl),Ee=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-10f9vjj"&&(T.innerHTML=dl),Ye=a(e),qe=o(e,"HR",{}),ze=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-8852nd"&&(J.innerHTML=gl),Ae=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-15rkks5"&&(U.innerHTML=ul),Pe=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-17mjvl5"&&(j.innerHTML=fl),De=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-7mv5ve"&&($.innerHTML=wl),Ke=a(e),m(C.$$.fragment,e),Oe=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-16fxmex"&&(I.innerHTML=bl),et=a(e),m(Z.$$.fragment,e),tt=a(e),m(v.$$.fragment,e),lt=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-10vy8e5"&&(k.innerHTML=Tl),st=a(e),m(G.$$.fragment,e),nt=a(e),m(B.$$.fragment,e),at=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1ses3rd"&&(R.innerHTML=Jl),it=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-bxlnst"&&(_.innerHTML=Ul),ot=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1pkwevp"&&(x.innerHTML=jl),rt=a(e),m(W.$$.fragment,e),pt=a(e),m(H.$$.fragment,e),mt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1ea8tja"&&(X.textContent=$l),ht=a(e),N=o(e,"OL",{"data-svelte-h":!0}),r(N)!=="svelte-b938qh"&&(N.innerHTML=Cl),Mt=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-o7doj"&&(V.innerHTML=Il),ct=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-jy1gvy"&&(L.textContent=Zl),yt=a(e),m(S.$$.fragment,e),dt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16kxf0u"&&(Q.innerHTML=vl),gt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-exqjjq"&&(F.textContent=kl),ut=a(e),m(E.$$.fragment,e),ft=a(e),m(Y.$$.fragment,e),wt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-qgh1h"&&(q.textContent=Gl),bt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-9g6ac8"&&(z.textContent=Bl),Tt=a(e),m(A.$$.fragment,e),Jt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1uk9mxl"&&(P.innerHTML=Rl),Ut=a(e),m(D.$$.fragment,e),jt=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-2etbr"&&(K.textContent=_l),$t=a(e),m(O.$$.fragment,e),Ct=a(e),m(ee.$$.fragment,e),It=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-yq317k"&&(te.textContent=xl),Zt=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-g8sp1x"&&(le.textContent=Wl),vt=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-19p4ebm"&&(se.innerHTML=Hl),kt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1l8se6d"&&(ne.textContent=Xl),Gt=a(e),m(ae.$$.fragment,e),Bt=a(e),m(ie.$$.fragment,e),Rt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1o1o7qu"&&(oe.innerHTML=Nl),_t=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-14olwev"&&(re.innerHTML=Vl),xt=a(e),pe=o(e,"TABLE",{"data-svelte-h":!0}),r(pe)!=="svelte-12x8exj"&&(pe.innerHTML=Ll),Wt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-3cgoag"&&(me.textContent=Sl),Ht=a(e),m(he.$$.fragment,e),Xt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-13krho7"&&(Me.innerHTML=Ql),Nt=a(e),m(ce.$$.fragment,e),Vt=a(e),ye=o(e,"PRE",{"data-svelte-h":!0}),r(ye)!=="svelte-xgcx5j"&&(ye.textContent=Fl),Lt=a(e),m(de.$$.fragment,e),St=a(e),m(ge.$$.fragment,e),Qt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-t74ywb"&&(ue.innerHTML=El),Ft=a(e),m(fe.$$.fragment,e),Et=a(e),we=o(e,"PRE",{"data-svelte-h":!0}),r(we)!=="svelte-1g4g5lj"&&(we.textContent=Yl),Yt=a(e),m(be.$$.fragment,e),qt=a(e),m(Te.$$.fragment,e),zt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-9uwez9"&&(Je.innerHTML=ql),At=a(e),m(Ue.$$.fragment,e),Pt=a(e),je=o(e,"PRE",{"data-svelte-h":!0}),r(je)!=="svelte-h9bqbg"&&(je.textContent=zl),Dt=a(e),m($e.$$.fragment,e),Kt=a(e),m(Ce.$$.fragment,e),Ot=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1i0kfzo"&&(Ie.textContent=Al),el=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-rdscea"&&(Ze.textContent=Pl),tl=a(e),m(ve.$$.fragment,e),ll=a(e),ke=o(e,"PRE",{"data-svelte-h":!0}),r(ke)!=="svelte-1fs64q8"&&(ke.textContent=Dl),sl=a(e),m(Ge.$$.fragment,e),nl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-q2ito7"&&(Be.innerHTML=Kl),al=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-q4zxvl"&&(Re.innerHTML=Ol),il=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1wyyft7"&&(_e.textContent=es),ol=a(e),m(xe.$$.fragment,e),rl=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1yzuydh"&&(We.innerHTML=ts),pl=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-uzbr78"&&(He.textContent=ls),ml=a(e),m(Xe.$$.fragment,e),hl=a(e),Ve=o(e,"P",{}),ss(Ve).forEach(l),this.h()},h(){ns(u,"name","hf:doc:metadata"),ns(u,"content",ds)},m(e,t){hs(document.head,u),s(e,Le,t),s(e,Ne,t),s(e,Se,t),h(f,e,t),s(e,Qe,t),h(w,e,t),s(e,Fe,t),s(e,b,t),s(e,Ee,t),s(e,T,t),s(e,Ye,t),s(e,qe,t),s(e,ze,t),s(e,J,t),s(e,Ae,t),s(e,U,t),s(e,Pe,t),s(e,j,t),s(e,De,t),s(e,$,t),s(e,Ke,t),h(C,e,t),s(e,Oe,t),s(e,I,t),s(e,et,t),h(Z,e,t),s(e,tt,t),h(v,e,t),s(e,lt,t),s(e,k,t),s(e,st,t),h(G,e,t),s(e,nt,t),h(B,e,t),s(e,at,t),s(e,R,t),s(e,it,t),s(e,_,t),s(e,ot,t),s(e,x,t),s(e,rt,t),h(W,e,t),s(e,pt,t),h(H,e,t),s(e,mt,t),s(e,X,t),s(e,ht,t),s(e,N,t),s(e,Mt,t),s(e,V,t),s(e,ct,t),s(e,L,t),s(e,yt,t),h(S,e,t),s(e,dt,t),s(e,Q,t),s(e,gt,t),s(e,F,t),s(e,ut,t),h(E,e,t),s(e,ft,t),h(Y,e,t),s(e,wt,t),s(e,q,t),s(e,bt,t),s(e,z,t),s(e,Tt,t),h(A,e,t),s(e,Jt,t),s(e,P,t),s(e,Ut,t),h(D,e,t),s(e,jt,t),s(e,K,t),s(e,$t,t),h(O,e,t),s(e,Ct,t),h(ee,e,t),s(e,It,t),s(e,te,t),s(e,Zt,t),s(e,le,t),s(e,vt,t),s(e,se,t),s(e,kt,t),s(e,ne,t),s(e,Gt,t),h(ae,e,t),s(e,Bt,t),h(ie,e,t),s(e,Rt,t),s(e,oe,t),s(e,_t,t),s(e,re,t),s(e,xt,t),s(e,pe,t),s(e,Wt,t),s(e,me,t),s(e,Ht,t),h(he,e,t),s(e,Xt,t),s(e,Me,t),s(e,Nt,t),h(ce,e,t),s(e,Vt,t),s(e,ye,t),s(e,Lt,t),h(de,e,t),s(e,St,t),h(ge,e,t),s(e,Qt,t),s(e,ue,t),s(e,Ft,t),h(fe,e,t),s(e,Et,t),s(e,we,t),s(e,Yt,t),h(be,e,t),s(e,qt,t),h(Te,e,t),s(e,zt,t),s(e,Je,t),s(e,At,t),h(Ue,e,t),s(e,Pt,t),s(e,je,t),s(e,Dt,t),h($e,e,t),s(e,Kt,t),h(Ce,e,t),s(e,Ot,t),s(e,Ie,t),s(e,el,t),s(e,Ze,t),s(e,tl,t),h(ve,e,t),s(e,ll,t),s(e,ke,t),s(e,sl,t),h(Ge,e,t),s(e,nl,t),s(e,Be,t),s(e,al,t),s(e,Re,t),s(e,il,t),s(e,_e,t),s(e,ol,t),h(xe,e,t),s(e,rl,t),s(e,We,t),s(e,pl,t),s(e,He,t),s(e,ml,t),h(Xe,e,t),s(e,hl,t),s(e,Ve,t),Ml=!0},p:is,i(e){Ml||(M(f.$$.fragment,e),M(w.$$.fragment,e),M(C.$$.fragment,e),M(Z.$$.fragment,e),M(v.$$.fragment,e),M(G.$$.fragment,e),M(B.$$.fragment,e),M(W.$$.fragment,e),M(H.$$.fragment,e),M(S.$$.fragment,e),M(E.$$.fragment,e),M(Y.$$.fragment,e),M(A.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(he.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(ge.$$.fragment,e),M(fe.$$.fragment,e),M(be.$$.fragment,e),M(Te.$$.fragment,e),M(Ue.$$.fragment,e),M($e.$$.fragment,e),M(Ce.$$.fragment,e),M(ve.$$.fragment,e),M(Ge.$$.fragment,e),M(xe.$$.fragment,e),M(Xe.$$.fragment,e),Ml=!0)},o(e){c(f.$$.fragment,e),c(w.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(v.$$.fragment,e),c(G.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(A.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(he.$$.fragment,e),c(ce.$$.fragment,e),c(de.$$.fragment,e),c(ge.$$.fragment,e),c(fe.$$.fragment,e),c(be.$$.fragment,e),c(Te.$$.fragment,e),c(Ue.$$.fragment,e),c($e.$$.fragment,e),c(Ce.$$.fragment,e),c(ve.$$.fragment,e),c(Ge.$$.fragment,e),c(xe.$$.fragment,e),c(Xe.$$.fragment,e),Ml=!1},d(e){e&&(l(Le),l(Ne),l(Se),l(Qe),l(Fe),l(b),l(Ee),l(T),l(Ye),l(qe),l(ze),l(J),l(Ae),l(U),l(Pe),l(j),l(De),l($),l(Ke),l(Oe),l(I),l(et),l(tt),l(lt),l(k),l(st),l(nt),l(at),l(R),l(it),l(_),l(ot),l(x),l(rt),l(pt),l(mt),l(X),l(ht),l(N),l(Mt),l(V),l(ct),l(L),l(yt),l(dt),l(Q),l(gt),l(F),l(ut),l(ft),l(wt),l(q),l(bt),l(z),l(Tt),l(Jt),l(P),l(Ut),l(jt),l(K),l($t),l(Ct),l(It),l(te),l(Zt),l(le),l(vt),l(se),l(kt),l(ne),l(Gt),l(Bt),l(Rt),l(oe),l(_t),l(re),l(xt),l(pe),l(Wt),l(me),l(Ht),l(Xt),l(Me),l(Nt),l(Vt),l(ye),l(Lt),l(St),l(Qt),l(ue),l(Ft),l(Et),l(we),l(Yt),l(qt),l(zt),l(Je),l(At),l(Pt),l(je),l(Dt),l(Kt),l(Ot),l(Ie),l(el),l(Ze),l(tl),l(ll),l(ke),l(sl),l(nl),l(Be),l(al),l(Re),l(il),l(_e),l(ol),l(rl),l(We),l(pl),l(He),l(ml),l(hl),l(Ve)),l(u),y(f,e),y(w,e),y(C,e),y(Z,e),y(v,e),y(G,e),y(B,e),y(W,e),y(H,e),y(S,e),y(E,e),y(Y,e),y(A,e),y(D,e),y(O,e),y(ee,e),y(ae,e),y(ie,e),y(he,e),y(ce,e),y(de,e),y(ge,e),y(fe,e),y(be,e),y(Te,e),y(Ue,e),y($e,e),y(Ce,e),y(ve,e),y(Ge,e),y(xe,e),y(Xe,e)}}}const ds='{"title":"Scaling Test-Time Compute for Longer Thinking in LLMs","local":"scaling-test-time-compute-for-longer-thinking-in-llms","sections":[{"title":"1. Install Dependencies","local":"1-install-dependencies","sections":[],"depth":2},{"title":"2. Setup the Large Language Model (LLM) and the Process Reward Model (PRM) 💬","local":"2-setup-the-large-language-model-llm-and-the-process-reward-model-prm-","sections":[{"title":"2.1 Instantiate the Question, Search Strategy, and Call the Pipeline","local":"21-instantiate-the-question-search-strategy-and-call-the-pipeline","sections":[],"depth":3},{"title":"2.2 Display the Final Result","local":"22-display-the-final-result","sections":[],"depth":3}],"depth":2},{"title":"3. Assembling It All! 🧑‍🏭️","local":"3-assembling-it-all-","sections":[{"title":"⏳  3.1 Comparing Thinking Time for Each Strategy","local":"-31-comparing-thinking-time-for-each-strategy","sections":[{"title":"1. Best of n","local":"1-best-of-n","sections":[],"depth":4},{"title":"2. Beam Search","local":"2-beam-search","sections":[],"depth":4},{"title":"3. Diverse Verifier Tree Search (DVTS)","local":"3-diverse-verifier-tree-search-dvts","sections":[],"depth":4}],"depth":3},{"title":"🙋 3.2 Testing the System with a Simple Question","local":"-32-testing-the-system-with-a-simple-question","sections":[],"depth":3}],"depth":2},{"title":"4. Continuing the Journey and Resources 🧑‍🎓️","local":"4-continuing-the-journey-and-resources-","sections":[],"depth":2}],"depth":1}';function gs(cl){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends rs{constructor(u){super(),ps(this,u,gs,ys,as,{})}}export{Ts as component};
