import{s as re,o as pe,n as xt}from"../chunks/scheduler.852ec091.js";import{S as me,i as fe,g as r,s as l,r as f,A as de,h as p,f as n,c as s,j as se,u as d,x as m,k as oe,y as ce,a,v as c,d as b,t as y,w as g}from"../chunks/index.28275fd3.js";import{T as Ht}from"../chunks/Tip.9f398c59.js";import{C as et}from"../chunks/CodeBlock.c3366071.js";import{H as U}from"../chunks/Heading.3b22a250.js";function be(M){let i,u='Learn more in the bitsandbytes Transformers integration <a href="https://huggingface.co/docs/transformers/quantization#bitsandbytes" rel="nofollow">guide</a>.';return{c(){i=r("p"),i.innerHTML=u},l(o){i=p(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1w7limx"&&(i.innerHTML=u)},m(o,h){a(o,i,h)},p:xt,d(o){o&&n(i)}}}function ye(M){let i,u='bfloat16 is the ideal <code>compute_dtype</code> if your hardware supports it. While the default <code>compute_dtype</code>, float32, ensures backward compatibility (due to wide-ranging hardware support) and numerical stability, it is large and slows down computations. In contrast, float16 is smaller and faster but can lead to numerical instabilities. bfloat16 combines the best aspects of both; it offers the numerical stability of float32 and the reduced memory footprint and speed of a 16-bit data type. Check if your hardware supports bfloat16 and configure it using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a>!';return{c(){i=r("p"),i.innerHTML=u},l(o){i=p(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-wrbsfd"&&(i.innerHTML=u)},m(o,h){a(o,i,h)},p:xt,d(o){o&&n(i)}}}function ge(M){let i,u='Learn more in the bitsandbytes PEFT integration <a href="https://huggingface.co/docs/peft/developer_guides/quantization#quantization" rel="nofollow">guide</a>.';return{c(){i=r("p"),i.innerHTML=u},l(o){i=p(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fb2nbh"&&(i.innerHTML=u)},m(o,h){a(o,i,h)},p:xt,d(o){o&&n(i)}}}function ue(M){let i,u='Learn more in the bitsandbytes Accelerate integration <a href="https://huggingface.co/docs/accelerate/usage_guides/quantization" rel="nofollow">guide</a>.';return{c(){i=r("p"),i.innerHTML=u},l(o){i=p(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-d2bgce"&&(i.innerHTML=u)},m(o,h){a(o,i,h)},p:xt,d(o){o&&n(i)}}}function he(M){let i,u,o,h,C,at,J,Ft="bitsandbytes is widely integrated with many of the libraries in the Hugging Face and wider PyTorch ecosystem. This guide provides a brief overview of the integrations and how to use bitsandbytes with them. For more details, you should refer to the linked documentation for each library.",it,v,lt,w,st,Z,At='With Transformers, it’s very easy to load any model in 4 or 8-bit and quantize them on the fly. To configure the quantization parameters, specify them in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class.',ot,j,Qt="For example, to load and quantize a model to 4-bits and use the bfloat16 data type for compute:",rt,$,pt,B,mt,X,ft,W,Vt='You can use any of the 8-bit or paged optimizers with Transformers by passing them to the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class on initialization. All bitsandbytes optimizers are supported by passing the correct string in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> <code>optim</code> parameter. For example, to load a <a href="/docs/bitsandbytes/main/en/reference/optim/adamw#bitsandbytes.optim.PagedAdamW32bit">PagedAdamW32bit</a> optimizer:',dt,k,ct,z,bt,T,yt,G,Et="PEFT builds on the bitsandbytes Transformers integration, and extends it for training with a few more steps. Let’s prepare the 4-bit model from the section above for training.",gt,L,Yt="Call the <code>~peft.prepare_model_for_kbit_training</code> method to prepare the model for training. This only works for Transformers models!",ut,R,ht,H,It="Setup a <code>~peft.LoraConfig</code> to use QLoRA:",Mt,x,wt,F,Nt="Now call the <code>~peft.get_peft_model</code> function on your model and config to create a trainable <code>PeftModel</code>.",$t,A,Tt,Q,_t,_,Ut,V,Pt='bitsandbytes is also easily usable from Accelerate and you can quantize any PyTorch model by passing a <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig" rel="nofollow">BnbQuantizationConfig</a> with your desired settings, and then calling the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.load_and_quantize_model" rel="nofollow">load_and_quantize_model</a> function to quantize it.',Ct,E,Jt,Y,vt,I,qt="bitsandbytes is available from:",Zt,N,St='<li><a href="https://lightning.ai/docs/pytorch/stable/" rel="nofollow">PyTorch Lightning</a>, a deep learning framework for professional AI researchers and machine learning engineers who need maximal flexibility without sacrificing performance at scale.</li> <li><a href="https://lightning.ai/docs/fabric/stable/" rel="nofollow">Lightning Fabric</a>, a fast and lightweight way to scale PyTorch models without boilerplate.</li>',jt,P,Dt='Learn more in the bitsandbytes PyTorch Lightning integration <a href="https://lightning.ai/docs/pytorch/stable/common/precision_intermediate.html#quantization-via-bitsandbytes" rel="nofollow">guide</a>.',Bt,q,Xt,S,Kt='bitsandbytes is integrated with <a href="https://github.com/Lightning-AI/lit-gpt" rel="nofollow">Lit-GPT</a>, a hackable implementation of state-of-the-art open-source large language models. Lit-GPT is based on Lightning Fabric, and it can be used for quantization during training, finetuning, and inference.',Wt,D,Ot='Learn more in the bitsandbytes Lit-GPT integration <a href="https://github.com/Lightning-AI/lit-gpt/blob/main/tutorials/quantize.md" rel="nofollow">guide</a>.',kt,K,zt,O,te="To learn in more detail about some of bitsandbytes integrations, take a look at the following blog posts:",Gt,tt,ee='<li><a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a></li> <li><a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">A Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes</a></li>',Lt,nt,Rt;return C=new U({props:{title:"Integrations",local:"integrations",headingTag:"h1"}}),v=new U({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),w=new Ht({props:{warning:!1,$$slots:{default:[be]},$$scope:{ctx:M}}}),$=new Ht({props:{warning:!0,$$slots:{default:[ye]},$$scope:{ctx:M}}}),B=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQW1vZGVsXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)
model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),X=new U({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h3"}}),k=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMnBhZ2VkX2FkYW13XzMyYml0JTIyJTJDJTBBKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTJDJTIwdHJhaW5pbmdfYXJncyUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

training_args = TrainingArguments(
    ...,
    optim=<span class="hljs-string">&quot;paged_adamw_32bit&quot;</span>,
)
trainer = Trainer(model, training_args, ...)
trainer.train()`,wrap:!1}}),z=new U({props:{title:"PEFT",local:"peft",headingTag:"h2"}}),T=new Ht({props:{warning:!1,$$slots:{default:[ge]},$$scope:{ctx:M}}}),R=new et({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMHByZXBhcmVfbW9kZWxfZm9yX2tiaXRfdHJhaW5pbmcobW9kZWxfNGJpdCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model_4bit = prepare_model_for_kbit_training(model_4bit)`,wrap:!1}}),x=new et({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTIyYWxsLWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),A=new et({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWxfNGJpdCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model_4bit, config)`,wrap:!1}}),Q=new U({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),_=new Ht({props:{warning:!1,$$slots:{default:[ue]},$$scope:{ctx:M}}}),E=new et({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyUyQyUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsJTBBZnJvbSUyMG1pbmdwdC5tb2RlbCUyMGltcG9ydCUyMEdQVCUwQSUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyMEdQVC5nZXRfZGVmYXVsdF9jb25maWcoKSUwQW1vZGVsX2NvbmZpZy5tb2RlbF90eXBlJTIwJTNEJTIwJ2dwdDIteGwnJTBBbW9kZWxfY29uZmlnLnZvY2FiX3NpemUlMjAlM0QlMjA1MDI1NyUwQW1vZGVsX2NvbmZpZy5ibG9ja19zaXplJTIwJTNEJTIwMTAyNCUwQSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMGVtcHR5X21vZGVsJTIwJTNEJTIwR1BUKG1vZGVsX2NvbmZpZyklMEElMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwJTIwJTIzJTIwb3B0aW9uYWwlMEElMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBKSUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKCUwQSUyMCUyMGVtcHR5X21vZGVsJTJDJTBBJTIwJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMEElMjAlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwZGV2aWNlX21hcCUyMCUzRCUyMCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig, load_and_quantize_model
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)

bnb_quantization_config = BnbQuantizationConfig(
  load_in_4bit=<span class="hljs-literal">True</span>,
  bnb_4bit_compute_dtype=torch.bfloat16,  <span class="hljs-comment"># optional</span>
  bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,         <span class="hljs-comment"># optional</span>
  bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>               <span class="hljs-comment"># optional</span>
)

quantized_model = load_and_quantize_model(
  empty_model,
  weights_location=weights_location,
  bnb_quantization_config=bnb_quantization_config,
  device_map = <span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Y=new U({props:{title:"PyTorch Lightning and Lightning Fabric",local:"pytorch-lightning-and-lightning-fabric",headingTag:"h2"}}),q=new U({props:{title:"Lit-GPT",local:"lit-gpt",headingTag:"h2"}}),K=new U({props:{title:"Blog posts",local:"blog-posts",headingTag:"h2"}}),{c(){i=r("meta"),u=l(),o=r("p"),h=l(),f(C.$$.fragment),at=l(),J=r("p"),J.textContent=Ft,it=l(),f(v.$$.fragment),lt=l(),f(w.$$.fragment),st=l(),Z=r("p"),Z.innerHTML=At,ot=l(),j=r("p"),j.textContent=Qt,rt=l(),f($.$$.fragment),pt=l(),f(B.$$.fragment),mt=l(),f(X.$$.fragment),ft=l(),W=r("p"),W.innerHTML=Vt,dt=l(),f(k.$$.fragment),ct=l(),f(z.$$.fragment),bt=l(),f(T.$$.fragment),yt=l(),G=r("p"),G.textContent=Et,gt=l(),L=r("p"),L.innerHTML=Yt,ut=l(),f(R.$$.fragment),ht=l(),H=r("p"),H.innerHTML=It,Mt=l(),f(x.$$.fragment),wt=l(),F=r("p"),F.innerHTML=Nt,$t=l(),f(A.$$.fragment),Tt=l(),f(Q.$$.fragment),_t=l(),f(_.$$.fragment),Ut=l(),V=r("p"),V.innerHTML=Pt,Ct=l(),f(E.$$.fragment),Jt=l(),f(Y.$$.fragment),vt=l(),I=r("p"),I.textContent=qt,Zt=l(),N=r("ul"),N.innerHTML=St,jt=l(),P=r("p"),P.innerHTML=Dt,Bt=l(),f(q.$$.fragment),Xt=l(),S=r("p"),S.innerHTML=Kt,Wt=l(),D=r("p"),D.innerHTML=Ot,kt=l(),f(K.$$.fragment),zt=l(),O=r("p"),O.textContent=te,Gt=l(),tt=r("ul"),tt.innerHTML=ee,Lt=l(),nt=r("p"),this.h()},l(t){const e=de("svelte-u9bgzb",document.head);i=p(e,"META",{name:!0,content:!0}),e.forEach(n),u=s(t),o=p(t,"P",{}),se(o).forEach(n),h=s(t),d(C.$$.fragment,t),at=s(t),J=p(t,"P",{"data-svelte-h":!0}),m(J)!=="svelte-17oloa0"&&(J.textContent=Ft),it=s(t),d(v.$$.fragment,t),lt=s(t),d(w.$$.fragment,t),st=s(t),Z=p(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-t09m1v"&&(Z.innerHTML=At),ot=s(t),j=p(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-fugr8i"&&(j.textContent=Qt),rt=s(t),d($.$$.fragment,t),pt=s(t),d(B.$$.fragment,t),mt=s(t),d(X.$$.fragment,t),ft=s(t),W=p(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-rupil2"&&(W.innerHTML=Vt),dt=s(t),d(k.$$.fragment,t),ct=s(t),d(z.$$.fragment,t),bt=s(t),d(T.$$.fragment,t),yt=s(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-945c4h"&&(G.textContent=Et),gt=s(t),L=p(t,"P",{"data-svelte-h":!0}),m(L)!=="svelte-16xvigi"&&(L.innerHTML=Yt),ut=s(t),d(R.$$.fragment,t),ht=s(t),H=p(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-xc51cl"&&(H.innerHTML=It),Mt=s(t),d(x.$$.fragment,t),wt=s(t),F=p(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-x8ok68"&&(F.innerHTML=Nt),$t=s(t),d(A.$$.fragment,t),Tt=s(t),d(Q.$$.fragment,t),_t=s(t),d(_.$$.fragment,t),Ut=s(t),V=p(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-wlkf6t"&&(V.innerHTML=Pt),Ct=s(t),d(E.$$.fragment,t),Jt=s(t),d(Y.$$.fragment,t),vt=s(t),I=p(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-zm0jix"&&(I.textContent=qt),Zt=s(t),N=p(t,"UL",{"data-svelte-h":!0}),m(N)!=="svelte-c4dddp"&&(N.innerHTML=St),jt=s(t),P=p(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-xrv468"&&(P.innerHTML=Dt),Bt=s(t),d(q.$$.fragment,t),Xt=s(t),S=p(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-jne5kj"&&(S.innerHTML=Kt),Wt=s(t),D=p(t,"P",{"data-svelte-h":!0}),m(D)!=="svelte-144d081"&&(D.innerHTML=Ot),kt=s(t),d(K.$$.fragment,t),zt=s(t),O=p(t,"P",{"data-svelte-h":!0}),m(O)!=="svelte-hhb45g"&&(O.textContent=te),Gt=s(t),tt=p(t,"UL",{"data-svelte-h":!0}),m(tt)!=="svelte-1opwyey"&&(tt.innerHTML=ee),Lt=s(t),nt=p(t,"P",{}),se(nt).forEach(n),this.h()},h(){oe(i,"name","hf:doc:metadata"),oe(i,"content",Me)},m(t,e){ce(document.head,i),a(t,u,e),a(t,o,e),a(t,h,e),c(C,t,e),a(t,at,e),a(t,J,e),a(t,it,e),c(v,t,e),a(t,lt,e),c(w,t,e),a(t,st,e),a(t,Z,e),a(t,ot,e),a(t,j,e),a(t,rt,e),c($,t,e),a(t,pt,e),c(B,t,e),a(t,mt,e),c(X,t,e),a(t,ft,e),a(t,W,e),a(t,dt,e),c(k,t,e),a(t,ct,e),c(z,t,e),a(t,bt,e),c(T,t,e),a(t,yt,e),a(t,G,e),a(t,gt,e),a(t,L,e),a(t,ut,e),c(R,t,e),a(t,ht,e),a(t,H,e),a(t,Mt,e),c(x,t,e),a(t,wt,e),a(t,F,e),a(t,$t,e),c(A,t,e),a(t,Tt,e),c(Q,t,e),a(t,_t,e),c(_,t,e),a(t,Ut,e),a(t,V,e),a(t,Ct,e),c(E,t,e),a(t,Jt,e),c(Y,t,e),a(t,vt,e),a(t,I,e),a(t,Zt,e),a(t,N,e),a(t,jt,e),a(t,P,e),a(t,Bt,e),c(q,t,e),a(t,Xt,e),a(t,S,e),a(t,Wt,e),a(t,D,e),a(t,kt,e),c(K,t,e),a(t,zt,e),a(t,O,e),a(t,Gt,e),a(t,tt,e),a(t,Lt,e),a(t,nt,e),Rt=!0},p(t,[e]){const ne={};e&2&&(ne.$$scope={dirty:e,ctx:t}),w.$set(ne);const ae={};e&2&&(ae.$$scope={dirty:e,ctx:t}),$.$set(ae);const ie={};e&2&&(ie.$$scope={dirty:e,ctx:t}),T.$set(ie);const le={};e&2&&(le.$$scope={dirty:e,ctx:t}),_.$set(le)},i(t){Rt||(b(C.$$.fragment,t),b(v.$$.fragment,t),b(w.$$.fragment,t),b($.$$.fragment,t),b(B.$$.fragment,t),b(X.$$.fragment,t),b(k.$$.fragment,t),b(z.$$.fragment,t),b(T.$$.fragment,t),b(R.$$.fragment,t),b(x.$$.fragment,t),b(A.$$.fragment,t),b(Q.$$.fragment,t),b(_.$$.fragment,t),b(E.$$.fragment,t),b(Y.$$.fragment,t),b(q.$$.fragment,t),b(K.$$.fragment,t),Rt=!0)},o(t){y(C.$$.fragment,t),y(v.$$.fragment,t),y(w.$$.fragment,t),y($.$$.fragment,t),y(B.$$.fragment,t),y(X.$$.fragment,t),y(k.$$.fragment,t),y(z.$$.fragment,t),y(T.$$.fragment,t),y(R.$$.fragment,t),y(x.$$.fragment,t),y(A.$$.fragment,t),y(Q.$$.fragment,t),y(_.$$.fragment,t),y(E.$$.fragment,t),y(Y.$$.fragment,t),y(q.$$.fragment,t),y(K.$$.fragment,t),Rt=!1},d(t){t&&(n(u),n(o),n(h),n(at),n(J),n(it),n(lt),n(st),n(Z),n(ot),n(j),n(rt),n(pt),n(mt),n(ft),n(W),n(dt),n(ct),n(bt),n(yt),n(G),n(gt),n(L),n(ut),n(ht),n(H),n(Mt),n(wt),n(F),n($t),n(Tt),n(_t),n(Ut),n(V),n(Ct),n(Jt),n(vt),n(I),n(Zt),n(N),n(jt),n(P),n(Bt),n(Xt),n(S),n(Wt),n(D),n(kt),n(zt),n(O),n(Gt),n(tt),n(Lt),n(nt)),n(i),g(C,t),g(v,t),g(w,t),g($,t),g(B,t),g(X,t),g(k,t),g(z,t),g(T,t),g(R,t),g(x,t),g(A,t),g(Q,t),g(_,t),g(E,t),g(Y,t),g(q,t),g(K,t)}}}const Me='{"title":"Integrations","local":"integrations","sections":[{"title":"Transformers","local":"transformers","sections":[{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[],"depth":3}],"depth":2},{"title":"PEFT","local":"peft","sections":[],"depth":2},{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Lightning and Lightning Fabric","local":"pytorch-lightning-and-lightning-fabric","sections":[],"depth":2},{"title":"Lit-GPT","local":"lit-gpt","sections":[],"depth":2},{"title":"Blog posts","local":"blog-posts","sections":[],"depth":2}],"depth":1}';function we(M){return pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Je extends me{constructor(i){super(),fe(this,i,we,he,re,{})}}export{Je as component};
