import{s as Co,o as jo,n as V}from"../chunks/scheduler.182ea377.js";import{S as Zo,i as Wo,g as r,s as i,r as h,A as Lo,h as l,f as d,c as s,j as M,u as _,x as u,k as P,y as n,a as y,v as b,d as v,t as w,w as x}from"../chunks/index.abf12888.js";import{T as Qn}from"../chunks/Tip.230e2334.js";import{D as S}from"../chunks/Docstring.93f6f462.js";import{C as He}from"../chunks/CodeBlock.57fe6e13.js";import{E as Re}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as St}from"../chunks/Heading.16916d63.js";function Go(D){let o,T='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',c,a,f='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){o=r("p"),o.innerHTML=T,c=i(),a=r("p"),a.innerHTML=f},l(t){o=l(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-1j961ct"&&(o.innerHTML=T),c=s(t),a=l(t,"P",{"data-svelte-h":!0}),u(a)!=="svelte-z4pn9c"&&(a.innerHTML=f)},m(t,$){y(t,o,$),y(t,c,$),y(t,a,$)},p:V,d(t){t&&(d(o),d(c),d(a))}}}function Fo(D){let o,T="Examples:",c,a,f;return a=new He({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){y(t,o,$),y(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(v(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Bo(D){let o,T=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=r("p"),o.innerHTML=T},l(c){o=l(c,"P",{"data-svelte-h":!0}),u(o)!=="svelte-ackzsn"&&(o.innerHTML=T)},m(c,a){y(c,o,a)},p:V,d(c){c&&d(o)}}}function No(D){let o,T="Examples:",c,a,f;return a=new He({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){y(t,o,$),y(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(v(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Vo(D){let o,T=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=r("p"),o.textContent=T},l(c){o=l(c,"P",{"data-svelte-h":!0}),u(o)!=="svelte-17p1lpg"&&(o.textContent=T)},m(c,a){y(c,o,a)},p:V,d(c){c&&d(o)}}}function Eo(D){let o,T="Examples:",c,a,f;return a=new He({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){y(t,o,$),y(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(v(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function zo(D){let o,T="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",c,a,f;return a=new He({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-1gc783q"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){y(t,o,$),y(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(v(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Ro(D){let o,T="locally:",c,a,f;return a=new He({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-4c75kq"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){y(t,o,$),y(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(v(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Ho(D){let o,T="Examples:",c,a,f;return a=new He({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){y(t,o,$),y(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(v(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Yo(D){let o,T="Examples:",c,a,f;return a=new He({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwcmV2aXNpb24lM0QlMjJiZjE2JTIyJTJDJTIwZHR5cGUlM0RqYXgubnVtcHkuYmZsb2F0MTYlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uUFJOR0tleSgwKSUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjA1MCUwQSUwQW51bV9zYW1wbGVzJTIwJTNEJTIwamF4LmRldmljZV9jb3VudCgpJTBBcHJvbXB0JTIwJTNEJTIwbnVtX3NhbXBsZXMlMjAqJTIwJTVCcHJvbXB0JTVEJTBBcHJvbXB0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLnByZXBhcmVfaW5wdXRzKHByb21wdCklMEElMEFwYXJhbXMlMjAlM0QlMjByZXBsaWNhdGUocGFyYW1zKSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocHJuZ19zZWVkJTJDJTIwamF4LmRldmljZV9jb3VudCgpKSUwQXByb21wdF9pZHMlMjAlM0QlMjBzaGFyZChwcm9tcHRfaWRzKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwYXJhbXMlMkMlMjBwcm5nX3NlZWQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwaml0JTNEVHJ1ZSkuaW1hZ2VzJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKG5wLmFzYXJyYXkoaW1hZ2VzLnJlc2hhcGUoKG51bV9zYW1wbGVzJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jax.numpy.bfloat16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = num_samples * [prompt]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipeline.prepare_inputs(prompt)
<span class="hljs-comment"># shard inputs and rng</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.split(prng_seed, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){o=r("p"),o.textContent=T,c=i(),h(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=s(t),_(a.$$.fragment,t)},m(t,$){y(t,o,$),y(t,c,$),b(a,t,$),f=!0},p:V,i(t){f||(v(a.$$.fragment,t),f=!0)},o(t){w(a.$$.fragment,t),f=!1},d(t){t&&(d(o),d(c)),x(a,t)}}}function Xo(D){let o,T,c,a,f,t,$,On='The Stable Diffusion model was created by researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://github.com/runwayml" rel="nofollow">Runway</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. The <a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> is capable of generating photorealistic images given any text input. It’s trained on 512x512 images from a subset of the LAION-5B dataset. This model uses a frozen CLIP ViT-L/14 text encoder to condition the model on text prompts. With its 860M UNet and 123M text encoder, the model is relatively lightweight and can run on consumer GPUs. Latent diffusion is the research on top of which Stable Diffusion was built. It was proposed in <a href="https://huggingface.co/papers/2112.10752" rel="nofollow">High-Resolution Image Synthesis with Latent Diffusion Models</a> by Robin Rombach, Andreas Blattmann, Dominik Lorenz, Patrick Esser, Björn Ommer.',Jt,fe,Kn="The abstract from the paper is:",kt,me,eo='<em>By decomposing the image formation process into a sequential application of denoising autoencoders, diffusion models (DMs) achieve state-of-the-art synthesis results on image data and beyond. Additionally, their formulation allows for a guiding mechanism to control the image generation process without retraining. However, since these models typically operate directly in pixel space, optimization of powerful DMs often consumes hundreds of GPU days and inference is expensive due to sequential evaluations. To enable DM training on limited computational resources while retaining their quality and flexibility, we apply them in the latent space of powerful pretrained autoencoders. In contrast to previous work, training diffusion models on such a representation allows for the first time to reach a near-optimal point between complexity reduction and detail preservation, greatly boosting visual fidelity. By introducing cross-attention layers into the model architecture, we turn diffusion models into powerful and flexible generators for general conditioning inputs such as text or bounding boxes and high-resolution synthesis becomes possible in a convolutional manner. Our latent diffusion models (LDMs) achieve a new state of the art for image inpainting and highly competitive performance on various tasks, including unconditional image generation, semantic scene synthesis, and super-resolution, while significantly reducing computational requirements compared to pixel-based DMs. Code is available at <a href="https://github.com/CompVis/latent-diffusion" rel="nofollow">https://github.com/CompVis/latent-diffusion</a>.</em>',It,R,Ut,ue,Ct,m,ge,Yt,Ye,to="Pipeline for text-to-image generation using Stable Diffusion.",Xt,Xe,no=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,At,Ae,oo="The pipeline also inherits the following loading methods:",qt,qe,io='<li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/v0.27.2/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Qt,F,he,Ot,Qe,so="The call function to the pipeline for generation.",Kt,H,en,U,_e,tn,Oe,ao=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,nn,Y,on,X,sn,A,be,an,Ke,ro=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,rn,q,ve,ln,et,lo=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,dn,Q,we,cn,tt,co=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,pn,C,xe,fn,nt,po=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,mn,O,un,K,gn,ee,ye,hn,ot,fo='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',_n,te,$e,bn,it,mo=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,vn,ne,Te,wn,st,uo=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,xn,J,Me,yn,at,go=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,$n,rt,ho="Example:",Tn,oe,Mn,lt,_o=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Pn,ie,Dn,B,Pe,Sn,dt,bo=`Instantiate a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,Jn,se,kn,k,De,In,ct,vo=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Un,pt,wo="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Cn,ft,xo='See <a href="/docs/diffusers/v0.27.2/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',jn,mt,yo=`See <a href="/docs/diffusers/v0.27.2/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Zn,ut,$o=`See <a href="/docs/diffusers/v0.27.2/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Wn,ae,Se,Ln,gt,To="Save the LoRA parameters corresponding to the UNet and text encoder.",Gn,re,Je,Fn,ht,Mo="Encodes the prompt into text encoder hidden states.",Bn,le,ke,Nn,_t,Po='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',jt,Ie,Zt,E,Ue,Vn,bt,Do="Output class for Stable Diffusion pipelines.",Wt,Ce,Lt,I,je,En,vt,So="Flax-based pipeline for text-to-image generation using Stable Diffusion.",zn,wt,Jo=`This model inherits from <a href="/docs/diffusers/v0.27.2/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Rn,N,Ze,Hn,xt,ko="The call function to the pipeline for generation.",Yn,de,Gt,We,Ft,W,Le,Xn,yt,Io="Output class for Flax-based Stable Diffusion pipelines.",An,ce,Ge,qn,$t,Uo="“Returns a new object replacing the specified fields with new values.",Bt,Dt,Nt;return f=new St({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h1"}}),R=new Qn({props:{$$slots:{default:[Go]},$$scope:{ctx:D}}}),ue=new St({props:{title:"StableDiffusionPipeline",local:"diffusers.StableDiffusionPipeline",headingTag:"h2"}}),ge=new S({props:{name:"class diffusers.StableDiffusionPipeline",anchor:"diffusers.StableDiffusionPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.27.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.27.2/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.27.2/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L117"}}),he=new S({props:{name:"__call__",anchor:"diffusers.StableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.27.2/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of IP-adapters.
Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding
if <code>do_classifier_free_guidance</code> is set to <code>True</code>.
If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L731",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),H=new Re({props:{anchor:"diffusers.StableDiffusionPipeline.__call__.example",$$slots:{default:[Fo]},$$scope:{ctx:D}}}),_e=new S({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/pipeline_utils.py#L1597"}}),Y=new Qn({props:{warning:!0,$$slots:{default:[Bo]},$$scope:{ctx:D}}}),X=new Re({props:{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[No]},$$scope:{ctx:D}}}),be=new S({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/pipeline_utils.py#L1637"}}),ve=new S({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/pipeline_utils.py#L1659"}}),we=new S({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/pipeline_utils.py#L1666"}}),xe=new S({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/pipeline_utils.py#L1536"}}),O=new Qn({props:{warning:!0,$$slots:{default:[Vo]},$$scope:{ctx:D}}}),K=new Re({props:{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Eo]},$$scope:{ctx:D}}}),ye=new S({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/pipeline_utils.py#L1571"}}),$e=new S({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/pipeline_utils.py#L1673"}}),Te=new S({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/pipeline_utils.py#L1681"}}),Me=new S({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/loaders/textual_inversion.py#L265"}}),oe=new Re({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example",$$slots:{default:[zo]},$$scope:{ctx:D}}}),ie=new Re({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example-2",$$slots:{default:[Ro]},$$scope:{ctx:D}}}),Pe=new S({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The path to the original config file that was used to train the model. If not provided, the config file
will be inferred from the checkpoint file.`,name:"original_config_file"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.model_type",description:`<strong>model_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of model to load. If not provided, the model type will be inferred from the checkpoint file.`,name:"model_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The size of the image output. It&#x2019;s used to configure the <code>sample_size</code> parameter of the UNet and VAE model.`,name:"image_size"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load the safety checker model or not. By default, the safety checker is not loaded unless a <code>safety_checker</code> component is passed to the <code>kwargs</code>.`,name:"load_safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Specify the number of input channels for the UNet model. Read more about how to configure UNet model with this parameter
<a href="https://huggingface.co/docs/diffusers/training/adapt_a_model#configure-unet2dconditionmodel-parameters" rel="nofollow">here</a>.`,name:"num_in_channels"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The scaling factor to use for the VAE model. If not provided, it is inferred from the config file first.
If the scaling factor is not found in the config file, the default value 0.18215 is used.`,name:"scaling_factor"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of scheduler to load. If not provided, the scheduler type will be inferred from the checkpoint file.`,name:"scheduler_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of prediction to load. If not provided, the prediction type will be inferred from the checkpoint file.`,name:"prediction_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/loaders/single_file.py#L159"}}),se=new Re({props:{anchor:"diffusers.StableDiffusionPipeline.from_single_file.example",$$slots:{default:[Ho]},$$scope:{ctx:D}}}),De=new S({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/v0.27.2/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/v0.27.2/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/loaders/lora.py#L80"}}),Se=new S({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/loaders/lora.py#L707"}}),Je=new S({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L287"}}),ke=new S({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Ie=new St({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),Ue=new S({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),Ce=new St({props:{title:"FlaxStableDiffusionPipeline",local:"diffusers.FlaxStableDiffusionPipeline",headingTag:"h2"}}),je=new S({props:{name:"class diffusers.FlaxStableDiffusionPipeline",anchor:"diffusers.FlaxStableDiffusionPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.2/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.2/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.39.0/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L81"}}),Ze=new S({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionPipeline.__call__",parameters:[{name:"prompt_ids",val:": array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"guidance_scale",val:": Union = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L310",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.2/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),de=new Re({props:{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.example",$$slots:{default:[Yo]},$$scope:{ctx:D}}}),We=new St({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),Le=new S({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),Ge=new S({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.27.2/src/flax/struct.py#L111"}}),{c(){o=r("meta"),T=i(),c=r("p"),a=i(),h(f.$$.fragment),t=i(),$=r("p"),$.innerHTML=On,Jt=i(),fe=r("p"),fe.textContent=Kn,kt=i(),me=r("p"),me.innerHTML=eo,It=i(),h(R.$$.fragment),Ut=i(),h(ue.$$.fragment),Ct=i(),m=r("div"),h(ge.$$.fragment),Yt=i(),Ye=r("p"),Ye.textContent=to,Xt=i(),Xe=r("p"),Xe.innerHTML=no,At=i(),Ae=r("p"),Ae.textContent=oo,qt=i(),qe=r("ul"),qe.innerHTML=io,Qt=i(),F=r("div"),h(he.$$.fragment),Ot=i(),Qe=r("p"),Qe.textContent=so,Kt=i(),h(H.$$.fragment),en=i(),U=r("div"),h(_e.$$.fragment),tn=i(),Oe=r("p"),Oe.textContent=ao,nn=i(),h(Y.$$.fragment),on=i(),h(X.$$.fragment),sn=i(),A=r("div"),h(be.$$.fragment),an=i(),Ke=r("p"),Ke.innerHTML=ro,rn=i(),q=r("div"),h(ve.$$.fragment),ln=i(),et=r("p"),et.textContent=lo,dn=i(),Q=r("div"),h(we.$$.fragment),cn=i(),tt=r("p"),tt.innerHTML=co,pn=i(),C=r("div"),h(xe.$$.fragment),fn=i(),nt=r("p"),nt.innerHTML=po,mn=i(),h(O.$$.fragment),un=i(),h(K.$$.fragment),gn=i(),ee=r("div"),h(ye.$$.fragment),hn=i(),ot=r("p"),ot.innerHTML=fo,_n=i(),te=r("div"),h($e.$$.fragment),bn=i(),it=r("p"),it.textContent=mo,vn=i(),ne=r("div"),h(Te.$$.fragment),wn=i(),st=r("p"),st.innerHTML=uo,xn=i(),J=r("div"),h(Me.$$.fragment),yn=i(),at=r("p"),at.innerHTML=go,$n=i(),rt=r("p"),rt.textContent=ho,Tn=i(),h(oe.$$.fragment),Mn=i(),lt=r("p"),lt.innerHTML=_o,Pn=i(),h(ie.$$.fragment),Dn=i(),B=r("div"),h(Pe.$$.fragment),Sn=i(),dt=r("p"),dt.innerHTML=bo,Jn=i(),h(se.$$.fragment),kn=i(),k=r("div"),h(De.$$.fragment),In=i(),ct=r("p"),ct.innerHTML=vo,Un=i(),pt=r("p"),pt.innerHTML=wo,Cn=i(),ft=r("p"),ft.innerHTML=xo,jn=i(),mt=r("p"),mt.innerHTML=yo,Zn=i(),ut=r("p"),ut.innerHTML=$o,Wn=i(),ae=r("div"),h(Se.$$.fragment),Ln=i(),gt=r("p"),gt.textContent=To,Gn=i(),re=r("div"),h(Je.$$.fragment),Fn=i(),ht=r("p"),ht.textContent=Mo,Bn=i(),le=r("div"),h(ke.$$.fragment),Nn=i(),_t=r("p"),_t.innerHTML=Po,jt=i(),h(Ie.$$.fragment),Zt=i(),E=r("div"),h(Ue.$$.fragment),Vn=i(),bt=r("p"),bt.textContent=Do,Wt=i(),h(Ce.$$.fragment),Lt=i(),I=r("div"),h(je.$$.fragment),En=i(),vt=r("p"),vt.textContent=So,zn=i(),wt=r("p"),wt.innerHTML=Jo,Rn=i(),N=r("div"),h(Ze.$$.fragment),Hn=i(),xt=r("p"),xt.textContent=ko,Yn=i(),h(de.$$.fragment),Gt=i(),h(We.$$.fragment),Ft=i(),W=r("div"),h(Le.$$.fragment),Xn=i(),yt=r("p"),yt.textContent=Io,An=i(),ce=r("div"),h(Ge.$$.fragment),qn=i(),$t=r("p"),$t.textContent=Uo,Bt=i(),Dt=r("p"),this.h()},l(e){const p=Lo("svelte-u9bgzb",document.head);o=l(p,"META",{name:!0,content:!0}),p.forEach(d),T=s(e),c=l(e,"P",{}),M(c).forEach(d),a=s(e),_(f.$$.fragment,e),t=s(e),$=l(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1prxt6"&&($.innerHTML=On),Jt=s(e),fe=l(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1cwsb16"&&(fe.textContent=Kn),kt=s(e),me=l(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1xoozhu"&&(me.innerHTML=eo),It=s(e),_(R.$$.fragment,e),Ut=s(e),_(ue.$$.fragment,e),Ct=s(e),m=l(e,"DIV",{class:!0});var g=M(m);_(ge.$$.fragment,g),Yt=s(g),Ye=l(g,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-35p306"&&(Ye.textContent=to),Xt=s(g),Xe=l(g,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-inq4do"&&(Xe.innerHTML=no),At=s(g),Ae=l(g,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-14s6m4u"&&(Ae.textContent=oo),qt=s(g),qe=l(g,"UL",{"data-svelte-h":!0}),u(qe)!=="svelte-1phzd7s"&&(qe.innerHTML=io),Qt=s(g),F=l(g,"DIV",{class:!0});var z=M(F);_(he.$$.fragment,z),Ot=s(z),Qe=l(z,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-50j04k"&&(Qe.textContent=so),Kt=s(z),_(H.$$.fragment,z),z.forEach(d),en=s(g),U=l(g,"DIV",{class:!0});var L=M(U);_(_e.$$.fragment,L),tn=s(L),Oe=l(L,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-10jaql7"&&(Oe.textContent=ao),nn=s(L),_(Y.$$.fragment,L),on=s(L),_(X.$$.fragment,L),L.forEach(d),sn=s(g),A=l(g,"DIV",{class:!0});var Fe=M(A);_(be.$$.fragment,Fe),an=s(Fe),Ke=l(Fe,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-1lh0nh5"&&(Ke.innerHTML=ro),Fe.forEach(d),rn=s(g),q=l(g,"DIV",{class:!0});var Be=M(q);_(ve.$$.fragment,Be),ln=s(Be),et=l(Be,"P",{"data-svelte-h":!0}),u(et)!=="svelte-14bnrb6"&&(et.textContent=lo),Be.forEach(d),dn=s(g),Q=l(g,"DIV",{class:!0});var Ne=M(Q);_(we.$$.fragment,Ne),cn=s(Ne),tt=l(Ne,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-1s3c06i"&&(tt.innerHTML=co),Ne.forEach(d),pn=s(g),C=l(g,"DIV",{class:!0});var G=M(C);_(xe.$$.fragment,G),fn=s(G),nt=l(G,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-e03q3e"&&(nt.innerHTML=po),mn=s(G),_(O.$$.fragment,G),un=s(G),_(K.$$.fragment,G),G.forEach(d),gn=s(g),ee=l(g,"DIV",{class:!0});var Ve=M(ee);_(ye.$$.fragment,Ve),hn=s(Ve),ot=l(Ve,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-1vfte1e"&&(ot.innerHTML=fo),Ve.forEach(d),_n=s(g),te=l(g,"DIV",{class:!0});var Ee=M(te);_($e.$$.fragment,Ee),bn=s(Ee),it=l(Ee,"P",{"data-svelte-h":!0}),u(it)!=="svelte-1xwrf7t"&&(it.textContent=mo),Ee.forEach(d),vn=s(g),ne=l(g,"DIV",{class:!0});var ze=M(ne);_(Te.$$.fragment,ze),wn=s(ze),st=l(ze,"P",{"data-svelte-h":!0}),u(st)!=="svelte-pkn4ui"&&(st.innerHTML=uo),ze.forEach(d),xn=s(g),J=l(g,"DIV",{class:!0});var j=M(J);_(Me.$$.fragment,j),yn=s(j),at=l(j,"P",{"data-svelte-h":!0}),u(at)!=="svelte-19ny2pw"&&(at.innerHTML=go),$n=s(j),rt=l(j,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-11lpom8"&&(rt.textContent=ho),Tn=s(j),_(oe.$$.fragment,j),Mn=s(j),lt=l(j,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-15d7mv5"&&(lt.innerHTML=_o),Pn=s(j),_(ie.$$.fragment,j),j.forEach(d),Dn=s(g),B=l(g,"DIV",{class:!0});var Tt=M(B);_(Pe.$$.fragment,Tt),Sn=s(Tt),dt=l(Tt,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-16uj2mx"&&(dt.innerHTML=bo),Jn=s(Tt),_(se.$$.fragment,Tt),Tt.forEach(d),kn=s(g),k=l(g,"DIV",{class:!0});var Z=M(k);_(De.$$.fragment,Z),In=s(Z),ct=l(Z,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-vs7s0z"&&(ct.innerHTML=vo),Un=s(Z),pt=l(Z,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-15b960v"&&(pt.innerHTML=wo),Cn=s(Z),ft=l(Z,"P",{"data-svelte-h":!0}),u(ft)!=="svelte-1ul3wg0"&&(ft.innerHTML=xo),jn=s(Z),mt=l(Z,"P",{"data-svelte-h":!0}),u(mt)!=="svelte-hr2cnp"&&(mt.innerHTML=yo),Zn=s(Z),ut=l(Z,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-kxjeyj"&&(ut.innerHTML=$o),Z.forEach(d),Wn=s(g),ae=l(g,"DIV",{class:!0});var Vt=M(ae);_(Se.$$.fragment,Vt),Ln=s(Vt),gt=l(Vt,"P",{"data-svelte-h":!0}),u(gt)!=="svelte-1ufq5ot"&&(gt.textContent=To),Vt.forEach(d),Gn=s(g),re=l(g,"DIV",{class:!0});var Et=M(re);_(Je.$$.fragment,Et),Fn=s(Et),ht=l(Et,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-16q0ax1"&&(ht.textContent=Mo),Et.forEach(d),Bn=s(g),le=l(g,"DIV",{class:!0});var zt=M(le);_(ke.$$.fragment,zt),Nn=s(zt),_t=l(zt,"P",{"data-svelte-h":!0}),u(_t)!=="svelte-vo59ec"&&(_t.innerHTML=Po),zt.forEach(d),g.forEach(d),jt=s(e),_(Ie.$$.fragment,e),Zt=s(e),E=l(e,"DIV",{class:!0});var Rt=M(E);_(Ue.$$.fragment,Rt),Vn=s(Rt),bt=l(Rt,"P",{"data-svelte-h":!0}),u(bt)!=="svelte-1qpjiuf"&&(bt.textContent=Do),Rt.forEach(d),Wt=s(e),_(Ce.$$.fragment,e),Lt=s(e),I=l(e,"DIV",{class:!0});var pe=M(I);_(je.$$.fragment,pe),En=s(pe),vt=l(pe,"P",{"data-svelte-h":!0}),u(vt)!=="svelte-d05p75"&&(vt.textContent=So),zn=s(pe),wt=l(pe,"P",{"data-svelte-h":!0}),u(wt)!=="svelte-1vpq8s"&&(wt.innerHTML=Jo),Rn=s(pe),N=l(pe,"DIV",{class:!0});var Mt=M(N);_(Ze.$$.fragment,Mt),Hn=s(Mt),xt=l(Mt,"P",{"data-svelte-h":!0}),u(xt)!=="svelte-50j04k"&&(xt.textContent=ko),Yn=s(Mt),_(de.$$.fragment,Mt),Mt.forEach(d),pe.forEach(d),Gt=s(e),_(We.$$.fragment,e),Ft=s(e),W=l(e,"DIV",{class:!0});var Pt=M(W);_(Le.$$.fragment,Pt),Xn=s(Pt),yt=l(Pt,"P",{"data-svelte-h":!0}),u(yt)!=="svelte-wzv2jc"&&(yt.textContent=Io),An=s(Pt),ce=l(Pt,"DIV",{class:!0});var Ht=M(ce);_(Ge.$$.fragment,Ht),qn=s(Ht),$t=l(Ht,"P",{"data-svelte-h":!0}),u($t)!=="svelte-5ihtpa"&&($t.textContent=Uo),Ht.forEach(d),Pt.forEach(d),Bt=s(e),Dt=l(e,"P",{}),M(Dt).forEach(d),this.h()},h(){P(o,"name","hf:doc:metadata"),P(o,"content",Ao),P(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){n(document.head,o),y(e,T,p),y(e,c,p),y(e,a,p),b(f,e,p),y(e,t,p),y(e,$,p),y(e,Jt,p),y(e,fe,p),y(e,kt,p),y(e,me,p),y(e,It,p),b(R,e,p),y(e,Ut,p),b(ue,e,p),y(e,Ct,p),y(e,m,p),b(ge,m,null),n(m,Yt),n(m,Ye),n(m,Xt),n(m,Xe),n(m,At),n(m,Ae),n(m,qt),n(m,qe),n(m,Qt),n(m,F),b(he,F,null),n(F,Ot),n(F,Qe),n(F,Kt),b(H,F,null),n(m,en),n(m,U),b(_e,U,null),n(U,tn),n(U,Oe),n(U,nn),b(Y,U,null),n(U,on),b(X,U,null),n(m,sn),n(m,A),b(be,A,null),n(A,an),n(A,Ke),n(m,rn),n(m,q),b(ve,q,null),n(q,ln),n(q,et),n(m,dn),n(m,Q),b(we,Q,null),n(Q,cn),n(Q,tt),n(m,pn),n(m,C),b(xe,C,null),n(C,fn),n(C,nt),n(C,mn),b(O,C,null),n(C,un),b(K,C,null),n(m,gn),n(m,ee),b(ye,ee,null),n(ee,hn),n(ee,ot),n(m,_n),n(m,te),b($e,te,null),n(te,bn),n(te,it),n(m,vn),n(m,ne),b(Te,ne,null),n(ne,wn),n(ne,st),n(m,xn),n(m,J),b(Me,J,null),n(J,yn),n(J,at),n(J,$n),n(J,rt),n(J,Tn),b(oe,J,null),n(J,Mn),n(J,lt),n(J,Pn),b(ie,J,null),n(m,Dn),n(m,B),b(Pe,B,null),n(B,Sn),n(B,dt),n(B,Jn),b(se,B,null),n(m,kn),n(m,k),b(De,k,null),n(k,In),n(k,ct),n(k,Un),n(k,pt),n(k,Cn),n(k,ft),n(k,jn),n(k,mt),n(k,Zn),n(k,ut),n(m,Wn),n(m,ae),b(Se,ae,null),n(ae,Ln),n(ae,gt),n(m,Gn),n(m,re),b(Je,re,null),n(re,Fn),n(re,ht),n(m,Bn),n(m,le),b(ke,le,null),n(le,Nn),n(le,_t),y(e,jt,p),b(Ie,e,p),y(e,Zt,p),y(e,E,p),b(Ue,E,null),n(E,Vn),n(E,bt),y(e,Wt,p),b(Ce,e,p),y(e,Lt,p),y(e,I,p),b(je,I,null),n(I,En),n(I,vt),n(I,zn),n(I,wt),n(I,Rn),n(I,N),b(Ze,N,null),n(N,Hn),n(N,xt),n(N,Yn),b(de,N,null),y(e,Gt,p),b(We,e,p),y(e,Ft,p),y(e,W,p),b(Le,W,null),n(W,Xn),n(W,yt),n(W,An),n(W,ce),b(Ge,ce,null),n(ce,qn),n(ce,$t),y(e,Bt,p),y(e,Dt,p),Nt=!0},p(e,[p]){const g={};p&2&&(g.$$scope={dirty:p,ctx:e}),R.$set(g);const z={};p&2&&(z.$$scope={dirty:p,ctx:e}),H.$set(z);const L={};p&2&&(L.$$scope={dirty:p,ctx:e}),Y.$set(L);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:e}),X.$set(Fe);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:e}),O.$set(Be);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),K.$set(Ne);const G={};p&2&&(G.$$scope={dirty:p,ctx:e}),oe.$set(G);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),ie.$set(Ve);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:e}),se.$set(Ee);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),de.$set(ze)},i(e){Nt||(v(f.$$.fragment,e),v(R.$$.fragment,e),v(ue.$$.fragment,e),v(ge.$$.fragment,e),v(he.$$.fragment,e),v(H.$$.fragment,e),v(_e.$$.fragment,e),v(Y.$$.fragment,e),v(X.$$.fragment,e),v(be.$$.fragment,e),v(ve.$$.fragment,e),v(we.$$.fragment,e),v(xe.$$.fragment,e),v(O.$$.fragment,e),v(K.$$.fragment,e),v(ye.$$.fragment,e),v($e.$$.fragment,e),v(Te.$$.fragment,e),v(Me.$$.fragment,e),v(oe.$$.fragment,e),v(ie.$$.fragment,e),v(Pe.$$.fragment,e),v(se.$$.fragment,e),v(De.$$.fragment,e),v(Se.$$.fragment,e),v(Je.$$.fragment,e),v(ke.$$.fragment,e),v(Ie.$$.fragment,e),v(Ue.$$.fragment,e),v(Ce.$$.fragment,e),v(je.$$.fragment,e),v(Ze.$$.fragment,e),v(de.$$.fragment,e),v(We.$$.fragment,e),v(Le.$$.fragment,e),v(Ge.$$.fragment,e),Nt=!0)},o(e){w(f.$$.fragment,e),w(R.$$.fragment,e),w(ue.$$.fragment,e),w(ge.$$.fragment,e),w(he.$$.fragment,e),w(H.$$.fragment,e),w(_e.$$.fragment,e),w(Y.$$.fragment,e),w(X.$$.fragment,e),w(be.$$.fragment,e),w(ve.$$.fragment,e),w(we.$$.fragment,e),w(xe.$$.fragment,e),w(O.$$.fragment,e),w(K.$$.fragment,e),w(ye.$$.fragment,e),w($e.$$.fragment,e),w(Te.$$.fragment,e),w(Me.$$.fragment,e),w(oe.$$.fragment,e),w(ie.$$.fragment,e),w(Pe.$$.fragment,e),w(se.$$.fragment,e),w(De.$$.fragment,e),w(Se.$$.fragment,e),w(Je.$$.fragment,e),w(ke.$$.fragment,e),w(Ie.$$.fragment,e),w(Ue.$$.fragment,e),w(Ce.$$.fragment,e),w(je.$$.fragment,e),w(Ze.$$.fragment,e),w(de.$$.fragment,e),w(We.$$.fragment,e),w(Le.$$.fragment,e),w(Ge.$$.fragment,e),Nt=!1},d(e){e&&(d(T),d(c),d(a),d(t),d($),d(Jt),d(fe),d(kt),d(me),d(It),d(Ut),d(Ct),d(m),d(jt),d(Zt),d(E),d(Wt),d(Lt),d(I),d(Gt),d(Ft),d(W),d(Bt),d(Dt)),d(o),x(f,e),x(R,e),x(ue,e),x(ge),x(he),x(H),x(_e),x(Y),x(X),x(be),x(ve),x(we),x(xe),x(O),x(K),x(ye),x($e),x(Te),x(Me),x(oe),x(ie),x(Pe),x(se),x(De),x(Se),x(Je),x(ke),x(Ie,e),x(Ue),x(Ce,e),x(je),x(Ze),x(de),x(We,e),x(Le),x(Ge)}}}const Ao='{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"StableDiffusionPipeline","local":"diffusers.StableDiffusionPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipeline","local":"diffusers.FlaxStableDiffusionPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function qo(D){return jo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ii extends Zo{constructor(o){super(),Wo(this,o,qo,Xo,Co,{})}}export{ii as component};
