import{s as en,o as tn,n as Ys}from"../chunks/scheduler.182ea377.js";import{S as sn,i as ln,g as i,s as n,p as d,A as nn,h as p,f as s,c as a,j as y,q as c,m as o,k as r,v as m,a as l,r as u,d as f,t as M,u as g}from"../chunks/index.008d68e4.js";import{T as Qs}from"../chunks/Tip.4f096367.js";import{I as P}from"../chunks/IconCopyLink.96bbb92b.js";import{C as v}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as an}from"../chunks/DocNotebookDropdown.bb388256.js";function pn(V){let h,U='💡 Read the <a href="https://huggingface.co/blog/stable_diffusion#how-does-stable-diffusion-work" rel="nofollow">How does Stable Diffusion work?</a> blog for more details about how the VAE, UNet, and text encoder models work.';return{c(){h=i("p"),h.innerHTML=U},l(b){h=p(b,"P",{"data-svelte-h":!0}),o(h)!=="svelte-14e2v6n"&&(h.innerHTML=U)},m(b,w){l(b,h,w)},p:Ys,d(b){b&&s(h)}}}function on(V){let h,U="💡 The <code>guidance_scale</code> parameter determines how much weight should be given to the prompt when generating an image.";return{c(){h=i("p"),h.innerHTML=U},l(b){h=p(b,"P",{"data-svelte-h":!0}),o(h)!=="svelte-vswzt8"&&(h.innerHTML=U)},m(b,w){l(b,h,w)},p:Ys,d(b){b&&s(h)}}}function rn(V){let h,U="💡 The height and width are divided by 8 because the <code>vae</code> model has 3 down-sampling layers. You can check by running the following:",b,w,T;return w=new v({props:{code:"MiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMjAlM0QlM0QlMjA4",highlighted:'<span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>) == <span class="hljs-number">8</span>'}}),{c(){h=i("p"),h.innerHTML=U,b=n(),d(w.$$.fragment)},l(j){h=p(j,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1c9k596"&&(h.innerHTML=U),b=a(j),c(w.$$.fragment,j)},m(j,q){l(j,h,q),l(j,b,q),u(w,j,q),T=!0},p:Ys,i(j){T||(f(w.$$.fragment,j),T=!0)},o(j){M(w.$$.fragment,j),T=!1},d(j){j&&(s(h),s(b)),g(w,j)}}}function hn(V){let h,U,b,w,T,j,q,st,Ds="Understanding pipelines, models and schedulers",yt,K,jt,O,Ps='🧨 Diffusers is designed to be a user-friendly and flexible toolbox for building diffusion systems tailored to your use-case. At the core of the toolbox are models and schedulers. While the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> bundles these components together for convenience, you can also unbundle the pipeline and use the models and schedulers separately to create new diffusion systems.',wt,ee,qs="In this tutorial, you’ll learn how to use models and schedulers to assemble a diffusion system for inference, starting with a basic pipeline and then progressing to the Stable Diffusion pipeline.",vt,J,W,ht,te,Xs,lt,Ks="Deconstruct a basic pipeline",Ut,se,Os="A pipeline is a quick and easy way to run a model for inference, requiring no more than four lines of code to generate an image:",Tt,le,Jt,G,el='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ddpm-cat.png" alt="Image of cat created from DDPMPipeline"/>',$t,ne,tl="That was super easy, but how did the pipeline do that? Let’s breakdown the pipeline and take a look at what’s happening under the hood.",Ct,ae,sl='In the example above, the pipeline contains a <a href="/docs/diffusers/v0.25.0/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> model and a <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>. The pipeline denoises an image by taking random noise the size of the desired output and passing it through the model several times. At each timestep, the model predicts the <em>noise residual</em> and the scheduler uses it to predict a less noisy image. The pipeline repeats this process until it reaches the end of the specified number of inference steps.',Zt,ie,ll="To recreate the pipeline with the model and scheduler separately, let’s write our own denoising process.",_t,pe,nl="<li>Load the model and scheduler:</li>",kt,oe,xt,I,al="<li>Set the number of timesteps to run the denoising process for:</li>",Vt,re,Wt,R,il="<li>Setting the scheduler timesteps creates a tensor with evenly spaced elements in it, 50 in this example. Each element corresponds to a timestep at which the model denoises an image. When you create the denoising loop later, you’ll iterate over this tensor to denoise an image:</li>",Gt,he,It,N,pl="<li>Create some random noise with the same shape as the desired output:</li>",Rt,me,Nt,S,ol='<li>Now write a loop to iterate over the timesteps. At each timestep, the model does a <a href="/docs/diffusers/v0.25.0/en/api/models/unet2d#diffusers.UNet2DModel.forward">UNet2DModel.forward()</a> pass and returns the noisy residual. The scheduler’s <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddpm#diffusers.DDPMScheduler.step">step()</a> method takes the noisy residual, timestep, and input and it predicts the image at the previous timestep. This output becomes the next input to the model in the denoising loop, and it’ll repeat until it reaches the end of the <code>timesteps</code> array.</li>',St,de,Bt,ce,rl="This is the entire denoising process, and you can use this same pattern to write any diffusion system.",Xt,B,hl="<li>The last step is to convert the denoised output into an image:</li>",Ht,ue,Et,fe,ml="In the next section, you’ll put your skills to the test and breakdown the more complex Stable Diffusion pipeline. The steps are more or less the same. You’ll initialize the necessary components, and set the number of timesteps to create a <code>timestep</code> array. The <code>timestep</code> array is used in the denoising loop, and for each element in this array, the model predicts a less noisy image. The denoising loop iterates over the <code>timestep</code>’s, and at each timestep, it outputs a noisy residual and the scheduler uses it to predict a less noisy image at the previous timestep. This process is repeated until you reach the end of the <code>timestep</code> array.",zt,Me,dl="Let’s try it out!",At,$,X,mt,ge,Hs,nt,cl="Deconstruct the Stable Diffusion pipeline",Ft,be,ul="Stable Diffusion is a text-to-image <em>latent diffusion</em> model. It is called a latent diffusion model because it works with a lower-dimensional representation of the image instead of the actual pixel space, which makes it more memory efficient. The encoder compresses the image into a smaller representation, and a decoder to convert the compressed representation back into an image. For text-to-image models, you’ll need a tokenizer and an encoder to generate text embeddings. From the previous example, you already know you need a UNet model and a scheduler.",Lt,ye,fl="As you can see, this is already more complex than the DDPM pipeline which only contains a UNet model. The Stable Diffusion model has three separate pretrained models.",Qt,H,Yt,je,Ml='Now that you know what you need for the Stable Diffusion pipeline, load all these components with the <a href="/docs/diffusers/v0.25.0/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method. You can find them in the pretrained <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> checkpoint, and each component is stored in a separate subfolder:',Dt,we,Pt,ve,gl='Instead of the default <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>, exchange it for the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> to see how easy it is to plug a different scheduler in:',qt,Ue,Kt,Te,bl="To speed up inference, move the models to a GPU since, unlike the scheduler, they have trainable weights:",Ot,Je,es,C,E,dt,$e,Es,at,yl="Create text embeddings",ts,Ce,jl="The next step is to tokenize the text to generate embeddings. The text is used to condition the UNet model and steer the diffusion process towards something that resembles the input prompt.",ss,z,ls,Ze,wl="Feel free to choose any prompt you like if you want to generate something else!",ns,_e,as,ke,vl="Tokenize the text and generate the embeddings from the prompt:",is,xe,ps,Ve,Ul="You’ll also need to generate the <em>unconditional text embeddings</em> which are the embeddings for the padding token. These need to have the same shape (<code>batch_size</code> and <code>seq_length</code>) as the conditional <code>text_embeddings</code>:",os,We,rs,Ge,Tl="Let’s concatenate the conditional and unconditional embeddings into a batch to avoid doing two forward passes:",hs,Ie,ms,Z,A,ct,Re,zs,it,Jl="Create random noise",ds,Ne,$l="Next, generate some initial random noise as a starting point for the diffusion process. This is the latent representation of the image, and it’ll be gradually denoised. At this point, the <code>latent</code> image is smaller than the final image size but that’s okay though because the model will transform it into the final 512x512 image dimensions later.",cs,F,us,Se,fs,_,L,ut,Be,As,pt,Cl="Denoise the image",Ms,Xe,Zl='Start by scaling the input with the initial noise distribution, <em>sigma</em>, the noise scale value, which is required for improved schedulers like <a href="/docs/diffusers/v0.25.0/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>:',gs,He,bs,Ee,_l="The last step is to create the denoising loop that’ll progressively transform the pure noise in <code>latents</code> to an image described by your prompt. Remember, the denoising loop needs to do three things:",ys,ze,kl="<li>Set the scheduler’s timesteps to use during denoising.</li> <li>Iterate over the timesteps.</li> <li>At each timestep, call the UNet model to predict the noise residual and pass it to the scheduler to compute the previous noisy sample.</li>",js,Ae,ws,k,Q,ft,Fe,Fs,ot,xl="Decode the image",vs,Le,Vl="The final step is to use the <code>vae</code> to decode the latent representation into an image and get the decoded output with <code>sample</code>:",Us,Qe,Ts,Ye,Wl="Lastly, convert the image to a <code>PIL.Image</code> to see your generated image!",Js,De,$s,Y,Gl='<img src="https://huggingface.co/blog/assets/98_stable_diffusion/stable_diffusion_k_lms.png"/>',Cs,x,D,Mt,Pe,Ls,rt,Il="Next steps",Zs,qe,Rl="From basic to complex pipelines, you’ve seen that all you really need to write your own diffusion system is a denoising loop. The loop should set the scheduler’s timesteps, iterate over them, and alternate between calling the UNet model to predict the noise residual and passing it to the scheduler to compute the previous noisy sample.",_s,Ke,Nl="This is really what 🧨 Diffusers is designed for: to make it intuitive and easy to write your own diffusion system using models and schedulers.",ks,Oe,Sl="For your next steps, feel free to:",xs,et,Bl='<li>Learn how to <a href="../using-diffusers/contribute_pipeline">build and contribute a pipeline</a> to 🧨 Diffusers. We can’t wait and see what you’ll come up with!</li> <li>Explore <a href="../api/pipelines/overview">existing pipelines</a> in the library, and see if you can deconstruct and build a pipeline from scratch using the models and schedulers separately.</li>',Vs;return j=new P({}),K=new an({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"}]}}),te=new P({}),le=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWRkcG0lMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBkZHBtKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>ddpm = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = ddpm(num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`}}),oe=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiklMEFtb2RlbCUyMCUzRCUyMFVOZXQyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNhdC0yNTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),re=new v({props:{code:"c2NoZWR1bGVyLnNldF90aW1lc3RlcHMoNTAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(<span class="hljs-number">50</span>)'}}),he=new v({props:{code:"c2NoZWR1bGVyLnRpbWVzdGVwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.timesteps
tensor([<span class="hljs-number">980</span>, <span class="hljs-number">960</span>, <span class="hljs-number">940</span>, <span class="hljs-number">920</span>, <span class="hljs-number">900</span>, <span class="hljs-number">880</span>, <span class="hljs-number">860</span>, <span class="hljs-number">840</span>, <span class="hljs-number">820</span>, <span class="hljs-number">800</span>, <span class="hljs-number">780</span>, <span class="hljs-number">760</span>, <span class="hljs-number">740</span>, <span class="hljs-number">720</span>,
    <span class="hljs-number">700</span>, <span class="hljs-number">680</span>, <span class="hljs-number">660</span>, <span class="hljs-number">640</span>, <span class="hljs-number">620</span>, <span class="hljs-number">600</span>, <span class="hljs-number">580</span>, <span class="hljs-number">560</span>, <span class="hljs-number">540</span>, <span class="hljs-number">520</span>, <span class="hljs-number">500</span>, <span class="hljs-number">480</span>, <span class="hljs-number">460</span>, <span class="hljs-number">440</span>,
    <span class="hljs-number">420</span>, <span class="hljs-number">400</span>, <span class="hljs-number">380</span>, <span class="hljs-number">360</span>, <span class="hljs-number">340</span>, <span class="hljs-number">320</span>, <span class="hljs-number">300</span>, <span class="hljs-number">280</span>, <span class="hljs-number">260</span>, <span class="hljs-number">240</span>, <span class="hljs-number">220</span>, <span class="hljs-number">200</span>, <span class="hljs-number">180</span>, <span class="hljs-number">160</span>,
    <span class="hljs-number">140</span>, <span class="hljs-number">120</span>, <span class="hljs-number">100</span>,  <span class="hljs-number">80</span>,  <span class="hljs-number">60</span>,  <span class="hljs-number">40</span>,  <span class="hljs-number">20</span>,   <span class="hljs-number">0</span>])`}}),me=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzYW1wbGVfc2l6ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5zYW1wbGVfc2l6ZSUwQW5vaXNlJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjAzJTJDJTIwc2FtcGxlX3NpemUlMkMlMjBzYW1wbGVfc2l6ZSklMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_size = model.config.sample_size
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, sample_size, sample_size), device=<span class="hljs-string">&quot;cuda&quot;</span>)`}}),de=new v({props:{code:"aW5wdXQlMjAlM0QlMjBub2lzZSUwQSUwQWZvciUyMHQlMjBpbiUyMHNjaGVkdWxlci50aW1lc3RlcHMlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc3lfcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChpbnB1dCUyQyUyMHQpLnNhbXBsZSUwQSUyMCUyMCUyMCUyMHByZXZpb3VzX25vaXN5X3NhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXN5X3Jlc2lkdWFsJTJDJTIwdCUyQyUyMGlucHV0KS5wcmV2X3NhbXBsZSUwQSUyMCUyMCUyMCUyMGlucHV0JTIwJTNEJTIwcHJldmlvdXNfbm9pc3lfc2FtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = noise

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> scheduler.timesteps:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noisy_residual = model(<span class="hljs-built_in">input</span>, t).sample
<span class="hljs-meta">... </span>    previous_noisy_sample = scheduler.step(noisy_residual, t, <span class="hljs-built_in">input</span>).prev_sample
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span> = previous_noisy_sample`}}),ue=new v({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjAoaW5wdXQlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkucm91bmQoKS50byh0b3JjaC51aW50OCkuY3B1KCkubnVtcHkoKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image = (<span class="hljs-built_in">input</span> / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`}}),ge=new P({}),H=new Qs({props:{$$slots:{default:[pn]},$$scope:{ctx:V}}}),we=new v({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFRleHRNb2RlbCUyQyUyMENMSVBUb2tlbml6ZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUyQyUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwUE5ETVNjaGVkdWxlciUwQSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ2YWUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwQ0xJUFRleHRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL, UNet2DConditionModel, PNDMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder = CLIPTextModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`}}),Ue=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = UniPCMultistepScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`}}),Je=new v({props:{code:"dG9yY2hfZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXZhZS50byh0b3JjaF9kZXZpY2UpJTBBdGV4dF9lbmNvZGVyLnRvKHRvcmNoX2RldmljZSklMEF1bmV0LnRvKHRvcmNoX2RldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch_device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet.to(torch_device)`}}),$e=new P({}),z=new Qs({props:{$$slots:{default:[on]},$$scope:{ctx:V}}}),_e=new v({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIyJTVEJTBBaGVpZ2h0JTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwZGVmYXVsdCUyMGhlaWdodCUyMG9mJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTBBd2lkdGglMjAlM0QlMjA1MTIlMjAlMjAlMjMlMjBkZWZhdWx0JTIwd2lkdGglMjBvZiUyMFN0YWJsZSUyMERpZmZ1c2lvbiUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyNSUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwZGVub2lzaW5nJTIwc3RlcHMlMEFndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDcuNSUyMCUyMCUyMyUyMFNjYWxlJTIwZm9yJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUyMCUyMCUyMyUyMFNlZWQlMjBnZW5lcmF0b3IlMjB0byUyMGNyZWF0ZSUyMHRoZSUyMGluaXRpYWwlMjBsYXRlbnQlMjBub2lzZSUwQWJhdGNoX3NpemUlMjAlM0QlMjBsZW4ocHJvbXB0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-number">512</span>  <span class="hljs-comment"># default height of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-number">512</span>  <span class="hljs-comment"># default width of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">25</span>  <span class="hljs-comment"># Number of denoising steps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">7.5</span>  <span class="hljs-comment"># Scale for classifier-free guidance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Seed generator to create the initial latent noise</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-built_in">len</span>(prompt)`}}),xe=new v({props:{code:"dGV4dF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0R0b2tlbml6ZXIubW9kZWxfbWF4X2xlbmd0aCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKHRleHRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_input = tokenizer(
<span class="hljs-meta">... </span>    prompt, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=tokenizer.model_max_length, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = text_encoder(text_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`}}),We=new v({props:{code:"bWF4X2xlbmd0aCUyMCUzRCUyMHRleHRfaW5wdXQuaW5wdXRfaWRzLnNoYXBlJTVCLTElNUQlMEF1bmNvbmRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyJTIyJTVEJTIwKiUyMGJhdGNoX3NpemUlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0RtYXhfbGVuZ3RoJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF1bmNvbmRfZW1iZWRkaW5ncyUyMCUzRCUyMHRleHRfZW5jb2Rlcih1bmNvbmRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>max_length = text_input.input_ids.shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_input = tokenizer([<span class="hljs-string">&quot;&quot;</span>] * batch_size, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=max_length, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_embeddings = text_encoder(uncond_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`}}),Ie=new v({props:{code:"dGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2guY2F0KCU1QnVuY29uZF9lbWJlZGRpbmdzJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.cat([uncond_embeddings, text_embeddings])'}}),Re=new P({}),F=new Qs({props:{$$slots:{default:[rn]},$$scope:{ctx:V}}}),Se=new v({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCUwQSUyMCUyMCUyMCUyMChiYXRjaF9zaXplJTJDJTIwdW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRHRvcmNoX2RldmljZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(
<span class="hljs-meta">... </span>    (batch_size, unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    device=torch_device,
<span class="hljs-meta">... </span>)`}}),Be=new P({}),He=new v({props:{code:"bGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwc2NoZWR1bGVyLmluaXRfbm9pc2Vfc2lnbWE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>latents = latents * scheduler.init_noise_sigma'}}),Ae=new v({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFzY2hlZHVsZXIuc2V0X3RpbWVzdGVwcyhudW1faW5mZXJlbmNlX3N0ZXBzKSUwQSUwQWZvciUyMHQlMjBpbiUyMHRxZG0oc2NoZWR1bGVyLnRpbWVzdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBleHBhbmQlMjB0aGUlMjBsYXRlbnRzJTIwaWYlMjB3ZSUyMGFyZSUyMGRvaW5nJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMjB0byUyMGF2b2lkJTIwZG9pbmclMjB0d28lMjBmb3J3YXJkJTIwcGFzc2VzLiUwQSUyMCUyMCUyMCUyMGxhdGVudF9tb2RlbF9pbnB1dCUyMCUzRCUyMHRvcmNoLmNhdCglNUJsYXRlbnRzJTVEJTIwKiUyMDIpJTBBJTBBJTIwJTIwJTIwJTIwbGF0ZW50X21vZGVsX2lucHV0JTIwJTNEJTIwc2NoZWR1bGVyLnNjYWxlX21vZGVsX2lucHV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHRpbWVzdGVwJTNEdCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwcmVkaWN0JTIwdGhlJTIwbm9pc2UlMjByZXNpZHVhbCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwdW5ldChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTNEdGV4dF9lbWJlZGRpbmdzKS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJmb3JtJTIwZ3VpZGFuY2UlMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkX3VuY29uZCUyQyUyMG5vaXNlX3ByZWRfdGV4dCUyMCUzRCUyMG5vaXNlX3ByZWQuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwbm9pc2VfcHJlZF91bmNvbmQlMjAlMkIlMjBndWlkYW5jZV9zY2FsZSUyMColMjAobm9pc2VfcHJlZF90ZXh0JTIwLSUyMG5vaXNlX3ByZWRfdW5jb25kKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjB0aGUlMjBwcmV2aW91cyUyMG5vaXN5JTIwc2FtcGxlJTIweF90JTIwLSUzRSUyMHhfdC0xJTBBJTIwJTIwJTIwJTIwbGF0ZW50cyUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXNlX3ByZWQlMkMlMjB0JTJDJTIwbGF0ZW50cykucHJldl9zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(num_inference_steps)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tqdm(scheduler.timesteps):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># expand the latents if we are doing classifier-free guidance to avoid doing two forward passes.</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    latent_model_input = scheduler.scale_model_input(latent_model_input, timestep=t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># predict the noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = scheduler.step(noise_pred, t, latents).prev_sample`}}),Fe=new P({}),Qe=new v({props:{code:"JTIzJTIwc2NhbGUlMjBhbmQlMjBkZWNvZGUlMjB0aGUlMjBpbWFnZSUyMGxhdGVudHMlMjB3aXRoJTIwdmFlJTBBbGF0ZW50cyUyMCUzRCUyMDElMjAlMkYlMjAwLjE4MjE1JTIwKiUyMGxhdGVudHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB2YWUuZGVjb2RlKGxhdGVudHMpLnNhbXBsZQ==",highlighted:`<span class="hljs-comment"># scale and decode the image latents with vae</span>
latents = <span class="hljs-number">1</span> / <span class="hljs-number">0.18215</span> * latents
<span class="hljs-keyword">with</span> torch.no_grad():
    image = vae.decode(latents).sample`}}),De=new v({props:{code:"aW1hZ2UlMjAlM0QlMjAoaW1hZ2UlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkudG8odG9yY2gudWludDgpLmNwdSgpLm51bXB5KCklMEFpbWFnZXMlMjAlM0QlMjAoaW1hZ2UlMjAqJTIwMjU1KS5yb3VuZCgpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>images = (image * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`}}),Pe=new P({}),{c(){h=i("meta"),U=n(),b=i("h1"),w=i("a"),T=i("span"),d(j.$$.fragment),q=n(),st=i("span"),st.textContent=Ds,yt=n(),d(K.$$.fragment),jt=n(),O=i("p"),O.innerHTML=Ps,wt=n(),ee=i("p"),ee.textContent=qs,vt=n(),J=i("h2"),W=i("a"),ht=i("span"),d(te.$$.fragment),Xs=n(),lt=i("span"),lt.textContent=Ks,Ut=n(),se=i("p"),se.textContent=Os,Tt=n(),d(le.$$.fragment),Jt=n(),G=i("div"),G.innerHTML=el,$t=n(),ne=i("p"),ne.textContent=tl,Ct=n(),ae=i("p"),ae.innerHTML=sl,Zt=n(),ie=i("p"),ie.textContent=ll,_t=n(),pe=i("ol"),pe.innerHTML=nl,kt=n(),d(oe.$$.fragment),xt=n(),I=i("ol"),I.innerHTML=al,Vt=n(),d(re.$$.fragment),Wt=n(),R=i("ol"),R.innerHTML=il,Gt=n(),d(he.$$.fragment),It=n(),N=i("ol"),N.innerHTML=pl,Rt=n(),d(me.$$.fragment),Nt=n(),S=i("ol"),S.innerHTML=ol,St=n(),d(de.$$.fragment),Bt=n(),ce=i("p"),ce.textContent=rl,Xt=n(),B=i("ol"),B.innerHTML=hl,Ht=n(),d(ue.$$.fragment),Et=n(),fe=i("p"),fe.innerHTML=ml,zt=n(),Me=i("p"),Me.textContent=dl,At=n(),$=i("h2"),X=i("a"),mt=i("span"),d(ge.$$.fragment),Hs=n(),nt=i("span"),nt.textContent=cl,Ft=n(),be=i("p"),be.innerHTML=ul,Lt=n(),ye=i("p"),ye.textContent=fl,Qt=n(),d(H.$$.fragment),Yt=n(),je=i("p"),je.innerHTML=Ml,Dt=n(),d(we.$$.fragment),Pt=n(),ve=i("p"),ve.innerHTML=gl,qt=n(),d(Ue.$$.fragment),Kt=n(),Te=i("p"),Te.textContent=bl,Ot=n(),d(Je.$$.fragment),es=n(),C=i("h3"),E=i("a"),dt=i("span"),d($e.$$.fragment),Es=n(),at=i("span"),at.textContent=yl,ts=n(),Ce=i("p"),Ce.textContent=jl,ss=n(),d(z.$$.fragment),ls=n(),Ze=i("p"),Ze.textContent=wl,ns=n(),d(_e.$$.fragment),as=n(),ke=i("p"),ke.textContent=vl,is=n(),d(xe.$$.fragment),ps=n(),Ve=i("p"),Ve.innerHTML=Ul,os=n(),d(We.$$.fragment),rs=n(),Ge=i("p"),Ge.textContent=Tl,hs=n(),d(Ie.$$.fragment),ms=n(),Z=i("h3"),A=i("a"),ct=i("span"),d(Re.$$.fragment),zs=n(),it=i("span"),it.textContent=Jl,ds=n(),Ne=i("p"),Ne.innerHTML=$l,cs=n(),d(F.$$.fragment),us=n(),d(Se.$$.fragment),fs=n(),_=i("h3"),L=i("a"),ut=i("span"),d(Be.$$.fragment),As=n(),pt=i("span"),pt.textContent=Cl,Ms=n(),Xe=i("p"),Xe.innerHTML=Zl,gs=n(),d(He.$$.fragment),bs=n(),Ee=i("p"),Ee.innerHTML=_l,ys=n(),ze=i("ol"),ze.innerHTML=kl,js=n(),d(Ae.$$.fragment),ws=n(),k=i("h3"),Q=i("a"),ft=i("span"),d(Fe.$$.fragment),Fs=n(),ot=i("span"),ot.textContent=xl,vs=n(),Le=i("p"),Le.innerHTML=Vl,Us=n(),d(Qe.$$.fragment),Ts=n(),Ye=i("p"),Ye.innerHTML=Wl,Js=n(),d(De.$$.fragment),$s=n(),Y=i("div"),Y.innerHTML=Gl,Cs=n(),x=i("h2"),D=i("a"),Mt=i("span"),d(Pe.$$.fragment),Ls=n(),rt=i("span"),rt.textContent=Il,Zs=n(),qe=i("p"),qe.textContent=Rl,_s=n(),Ke=i("p"),Ke.textContent=Nl,ks=n(),Oe=i("p"),Oe.textContent=Sl,xs=n(),et=i("ul"),et.innerHTML=Bl,this.h()},l(e){const t=nn("svelte-1phssyn",document.head);h=p(t,"META",{name:!0,content:!0}),t.forEach(s),U=a(e),b=p(e,"H1",{class:!0});var tt=y(b);w=p(tt,"A",{id:!0,class:!0,href:!0});var gt=y(w);T=p(gt,"SPAN",{});var bt=y(T);c(j.$$.fragment,bt),bt.forEach(s),gt.forEach(s),q=a(tt),st=p(tt,"SPAN",{"data-svelte-h":!0}),o(st)!=="svelte-18rt9y5"&&(st.textContent=Ds),tt.forEach(s),yt=a(e),c(K.$$.fragment,e),jt=a(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1p059wy"&&(O.innerHTML=Ps),wt=a(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-5khcjg"&&(ee.textContent=qs),vt=a(e),J=p(e,"H2",{class:!0});var Ws=y(J);W=p(Ws,"A",{id:!0,class:!0,href:!0});var Xl=y(W);ht=p(Xl,"SPAN",{});var Hl=y(ht);c(te.$$.fragment,Hl),Hl.forEach(s),Xl.forEach(s),Xs=a(Ws),lt=p(Ws,"SPAN",{"data-svelte-h":!0}),o(lt)!=="svelte-1pjkpli"&&(lt.textContent=Ks),Ws.forEach(s),Ut=a(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1o4pmop"&&(se.textContent=Os),Tt=a(e),c(le.$$.fragment,e),Jt=a(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(G)!=="svelte-ej6f4c"&&(G.innerHTML=el),$t=a(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-7b411q"&&(ne.textContent=tl),Ct=a(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-zb4cpr"&&(ae.innerHTML=sl),Zt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-mwr50"&&(ie.textContent=ll),_t=a(e),pe=p(e,"OL",{"data-svelte-h":!0}),o(pe)!=="svelte-g7uo25"&&(pe.innerHTML=nl),kt=a(e),c(oe.$$.fragment,e),xt=a(e),I=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(I)!=="svelte-o7kbas"&&(I.innerHTML=al),Vt=a(e),c(re.$$.fragment,e),Wt=a(e),R=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(R)!=="svelte-1jnsvh9"&&(R.innerHTML=il),Gt=a(e),c(he.$$.fragment,e),It=a(e),N=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(N)!=="svelte-1hrlquj"&&(N.innerHTML=pl),Rt=a(e),c(me.$$.fragment,e),Nt=a(e),S=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(S)!=="svelte-1ofaic1"&&(S.innerHTML=ol),St=a(e),c(de.$$.fragment,e),Bt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-sdv3mq"&&(ce.textContent=rl),Xt=a(e),B=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(B)!=="svelte-1du7raq"&&(B.innerHTML=hl),Ht=a(e),c(ue.$$.fragment,e),Et=a(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-t8ln8h"&&(fe.innerHTML=ml),zt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-tru974"&&(Me.textContent=dl),At=a(e),$=p(e,"H2",{class:!0});var Gs=y($);X=p(Gs,"A",{id:!0,class:!0,href:!0});var El=y(X);mt=p(El,"SPAN",{});var zl=y(mt);c(ge.$$.fragment,zl),zl.forEach(s),El.forEach(s),Hs=a(Gs),nt=p(Gs,"SPAN",{"data-svelte-h":!0}),o(nt)!=="svelte-1p25dcm"&&(nt.textContent=cl),Gs.forEach(s),Ft=a(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-hpeh95"&&(be.innerHTML=ul),Lt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1yb6q1d"&&(ye.textContent=fl),Qt=a(e),c(H.$$.fragment,e),Yt=a(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1gikhb9"&&(je.innerHTML=Ml),Dt=a(e),c(we.$$.fragment,e),Pt=a(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-wuj1q9"&&(ve.innerHTML=gl),qt=a(e),c(Ue.$$.fragment,e),Kt=a(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1tr4efr"&&(Te.textContent=bl),Ot=a(e),c(Je.$$.fragment,e),es=a(e),C=p(e,"H3",{class:!0});var Is=y(C);E=p(Is,"A",{id:!0,class:!0,href:!0});var Al=y(E);dt=p(Al,"SPAN",{});var Fl=y(dt);c($e.$$.fragment,Fl),Fl.forEach(s),Al.forEach(s),Es=a(Is),at=p(Is,"SPAN",{"data-svelte-h":!0}),o(at)!=="svelte-1uco8o0"&&(at.textContent=yl),Is.forEach(s),ts=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-ltx5oa"&&(Ce.textContent=jl),ss=a(e),c(z.$$.fragment,e),ls=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-z6gwd8"&&(Ze.textContent=wl),ns=a(e),c(_e.$$.fragment,e),as=a(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-q7skg3"&&(ke.textContent=vl),is=a(e),c(xe.$$.fragment,e),ps=a(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-e64ab9"&&(Ve.innerHTML=Ul),os=a(e),c(We.$$.fragment,e),rs=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-41mj23"&&(Ge.textContent=Tl),hs=a(e),c(Ie.$$.fragment,e),ms=a(e),Z=p(e,"H3",{class:!0});var Rs=y(Z);A=p(Rs,"A",{id:!0,class:!0,href:!0});var Ll=y(A);ct=p(Ll,"SPAN",{});var Ql=y(ct);c(Re.$$.fragment,Ql),Ql.forEach(s),Ll.forEach(s),zs=a(Rs),it=p(Rs,"SPAN",{"data-svelte-h":!0}),o(it)!=="svelte-1vaffhu"&&(it.textContent=Jl),Rs.forEach(s),ds=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1gyrog2"&&(Ne.innerHTML=$l),cs=a(e),c(F.$$.fragment,e),us=a(e),c(Se.$$.fragment,e),fs=a(e),_=p(e,"H3",{class:!0});var Ns=y(_);L=p(Ns,"A",{id:!0,class:!0,href:!0});var Yl=y(L);ut=p(Yl,"SPAN",{});var Dl=y(ut);c(Be.$$.fragment,Dl),Dl.forEach(s),Yl.forEach(s),As=a(Ns),pt=p(Ns,"SPAN",{"data-svelte-h":!0}),o(pt)!=="svelte-ckvk1a"&&(pt.textContent=Cl),Ns.forEach(s),Ms=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1yyo1ip"&&(Xe.innerHTML=Zl),gs=a(e),c(He.$$.fragment,e),bs=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-ul1wgx"&&(Ee.innerHTML=_l),ys=a(e),ze=p(e,"OL",{"data-svelte-h":!0}),o(ze)!=="svelte-ceuo6w"&&(ze.innerHTML=kl),js=a(e),c(Ae.$$.fragment,e),ws=a(e),k=p(e,"H3",{class:!0});var Ss=y(k);Q=p(Ss,"A",{id:!0,class:!0,href:!0});var Pl=y(Q);ft=p(Pl,"SPAN",{});var ql=y(ft);c(Fe.$$.fragment,ql),ql.forEach(s),Pl.forEach(s),Fs=a(Ss),ot=p(Ss,"SPAN",{"data-svelte-h":!0}),o(ot)!=="svelte-1klfar5"&&(ot.textContent=xl),Ss.forEach(s),vs=a(e),Le=p(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-rzriwa"&&(Le.innerHTML=Vl),Us=a(e),c(Qe.$$.fragment,e),Ts=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-6reqqn"&&(Ye.innerHTML=Wl),Js=a(e),c(De.$$.fragment,e),$s=a(e),Y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(Y)!=="svelte-1b0w6va"&&(Y.innerHTML=Gl),Cs=a(e),x=p(e,"H2",{class:!0});var Bs=y(x);D=p(Bs,"A",{id:!0,class:!0,href:!0});var Kl=y(D);Mt=p(Kl,"SPAN",{});var Ol=y(Mt);c(Pe.$$.fragment,Ol),Ol.forEach(s),Kl.forEach(s),Ls=a(Bs),rt=p(Bs,"SPAN",{"data-svelte-h":!0}),o(rt)!=="svelte-pr7lub"&&(rt.textContent=Il),Bs.forEach(s),Zs=a(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-9a4wlz"&&(qe.textContent=Rl),_s=a(e),Ke=p(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-u3h7jy"&&(Ke.textContent=Nl),ks=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-xe6tlx"&&(Oe.textContent=Sl),xs=a(e),et=p(e,"UL",{"data-svelte-h":!0}),o(et)!=="svelte-wmho1r"&&(et.innerHTML=Bl),this.h()},h(){r(h,"name","hf:doc:metadata"),r(h,"content",JSON.stringify(mn)),r(w,"id","understanding-pipelines-models-and-schedulers"),r(w,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(w,"href","#understanding-pipelines-models-and-schedulers"),r(b,"class","relative group"),r(W,"id","deconstruct-a-basic-pipeline"),r(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(W,"href","#deconstruct-a-basic-pipeline"),r(J,"class","relative group"),r(G,"class","flex justify-center"),r(I,"start","2"),r(R,"start","3"),r(N,"start","4"),r(S,"start","5"),r(B,"start","6"),r(X,"id","deconstruct-the-stable-diffusion-pipeline"),r(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(X,"href","#deconstruct-the-stable-diffusion-pipeline"),r($,"class","relative group"),r(E,"id","create-text-embeddings"),r(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(E,"href","#create-text-embeddings"),r(C,"class","relative group"),r(A,"id","create-random-noise"),r(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(A,"href","#create-random-noise"),r(Z,"class","relative group"),r(L,"id","denoise-the-image"),r(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(L,"href","#denoise-the-image"),r(_,"class","relative group"),r(Q,"id","decode-the-image"),r(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Q,"href","#decode-the-image"),r(k,"class","relative group"),r(Y,"class","flex justify-center"),r(D,"id","next-steps"),r(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(D,"href","#next-steps"),r(x,"class","relative group")},m(e,t){m(document.head,h),l(e,U,t),l(e,b,t),m(b,w),m(w,T),u(j,T,null),m(b,q),m(b,st),l(e,yt,t),u(K,e,t),l(e,jt,t),l(e,O,t),l(e,wt,t),l(e,ee,t),l(e,vt,t),l(e,J,t),m(J,W),m(W,ht),u(te,ht,null),m(J,Xs),m(J,lt),l(e,Ut,t),l(e,se,t),l(e,Tt,t),u(le,e,t),l(e,Jt,t),l(e,G,t),l(e,$t,t),l(e,ne,t),l(e,Ct,t),l(e,ae,t),l(e,Zt,t),l(e,ie,t),l(e,_t,t),l(e,pe,t),l(e,kt,t),u(oe,e,t),l(e,xt,t),l(e,I,t),l(e,Vt,t),u(re,e,t),l(e,Wt,t),l(e,R,t),l(e,Gt,t),u(he,e,t),l(e,It,t),l(e,N,t),l(e,Rt,t),u(me,e,t),l(e,Nt,t),l(e,S,t),l(e,St,t),u(de,e,t),l(e,Bt,t),l(e,ce,t),l(e,Xt,t),l(e,B,t),l(e,Ht,t),u(ue,e,t),l(e,Et,t),l(e,fe,t),l(e,zt,t),l(e,Me,t),l(e,At,t),l(e,$,t),m($,X),m(X,mt),u(ge,mt,null),m($,Hs),m($,nt),l(e,Ft,t),l(e,be,t),l(e,Lt,t),l(e,ye,t),l(e,Qt,t),u(H,e,t),l(e,Yt,t),l(e,je,t),l(e,Dt,t),u(we,e,t),l(e,Pt,t),l(e,ve,t),l(e,qt,t),u(Ue,e,t),l(e,Kt,t),l(e,Te,t),l(e,Ot,t),u(Je,e,t),l(e,es,t),l(e,C,t),m(C,E),m(E,dt),u($e,dt,null),m(C,Es),m(C,at),l(e,ts,t),l(e,Ce,t),l(e,ss,t),u(z,e,t),l(e,ls,t),l(e,Ze,t),l(e,ns,t),u(_e,e,t),l(e,as,t),l(e,ke,t),l(e,is,t),u(xe,e,t),l(e,ps,t),l(e,Ve,t),l(e,os,t),u(We,e,t),l(e,rs,t),l(e,Ge,t),l(e,hs,t),u(Ie,e,t),l(e,ms,t),l(e,Z,t),m(Z,A),m(A,ct),u(Re,ct,null),m(Z,zs),m(Z,it),l(e,ds,t),l(e,Ne,t),l(e,cs,t),u(F,e,t),l(e,us,t),u(Se,e,t),l(e,fs,t),l(e,_,t),m(_,L),m(L,ut),u(Be,ut,null),m(_,As),m(_,pt),l(e,Ms,t),l(e,Xe,t),l(e,gs,t),u(He,e,t),l(e,bs,t),l(e,Ee,t),l(e,ys,t),l(e,ze,t),l(e,js,t),u(Ae,e,t),l(e,ws,t),l(e,k,t),m(k,Q),m(Q,ft),u(Fe,ft,null),m(k,Fs),m(k,ot),l(e,vs,t),l(e,Le,t),l(e,Us,t),u(Qe,e,t),l(e,Ts,t),l(e,Ye,t),l(e,Js,t),u(De,e,t),l(e,$s,t),l(e,Y,t),l(e,Cs,t),l(e,x,t),m(x,D),m(D,Mt),u(Pe,Mt,null),m(x,Ls),m(x,rt),l(e,Zs,t),l(e,qe,t),l(e,_s,t),l(e,Ke,t),l(e,ks,t),l(e,Oe,t),l(e,xs,t),l(e,et,t),Vs=!0},p(e,[t]){const tt={};t&2&&(tt.$$scope={dirty:t,ctx:e}),H.$set(tt);const gt={};t&2&&(gt.$$scope={dirty:t,ctx:e}),z.$set(gt);const bt={};t&2&&(bt.$$scope={dirty:t,ctx:e}),F.$set(bt)},i(e){Vs||(f(j.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(he.$$.fragment,e),f(me.$$.fragment,e),f(de.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(H.$$.fragment,e),f(we.$$.fragment,e),f(Ue.$$.fragment,e),f(Je.$$.fragment,e),f($e.$$.fragment,e),f(z.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f(We.$$.fragment,e),f(Ie.$$.fragment,e),f(Re.$$.fragment,e),f(F.$$.fragment,e),f(Se.$$.fragment,e),f(Be.$$.fragment,e),f(He.$$.fragment,e),f(Ae.$$.fragment,e),f(Fe.$$.fragment,e),f(Qe.$$.fragment,e),f(De.$$.fragment,e),f(Pe.$$.fragment,e),Vs=!0)},o(e){M(j.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(he.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(ue.$$.fragment,e),M(ge.$$.fragment,e),M(H.$$.fragment,e),M(we.$$.fragment,e),M(Ue.$$.fragment,e),M(Je.$$.fragment,e),M($e.$$.fragment,e),M(z.$$.fragment,e),M(_e.$$.fragment,e),M(xe.$$.fragment,e),M(We.$$.fragment,e),M(Ie.$$.fragment,e),M(Re.$$.fragment,e),M(F.$$.fragment,e),M(Se.$$.fragment,e),M(Be.$$.fragment,e),M(He.$$.fragment,e),M(Ae.$$.fragment,e),M(Fe.$$.fragment,e),M(Qe.$$.fragment,e),M(De.$$.fragment,e),M(Pe.$$.fragment,e),Vs=!1},d(e){e&&(s(U),s(b),s(yt),s(jt),s(O),s(wt),s(ee),s(vt),s(J),s(Ut),s(se),s(Tt),s(Jt),s(G),s($t),s(ne),s(Ct),s(ae),s(Zt),s(ie),s(_t),s(pe),s(kt),s(xt),s(I),s(Vt),s(Wt),s(R),s(Gt),s(It),s(N),s(Rt),s(Nt),s(S),s(St),s(Bt),s(ce),s(Xt),s(B),s(Ht),s(Et),s(fe),s(zt),s(Me),s(At),s($),s(Ft),s(be),s(Lt),s(ye),s(Qt),s(Yt),s(je),s(Dt),s(Pt),s(ve),s(qt),s(Kt),s(Te),s(Ot),s(es),s(C),s(ts),s(Ce),s(ss),s(ls),s(Ze),s(ns),s(as),s(ke),s(is),s(ps),s(Ve),s(os),s(rs),s(Ge),s(hs),s(ms),s(Z),s(ds),s(Ne),s(cs),s(us),s(fs),s(_),s(Ms),s(Xe),s(gs),s(bs),s(Ee),s(ys),s(ze),s(js),s(ws),s(k),s(vs),s(Le),s(Us),s(Ts),s(Ye),s(Js),s($s),s(Y),s(Cs),s(x),s(Zs),s(qe),s(_s),s(Ke),s(ks),s(Oe),s(xs),s(et)),s(h),g(j),g(K,e),g(te),g(le,e),g(oe,e),g(re,e),g(he,e),g(me,e),g(de,e),g(ue,e),g(ge),g(H,e),g(we,e),g(Ue,e),g(Je,e),g($e),g(z,e),g(_e,e),g(xe,e),g(We,e),g(Ie,e),g(Re),g(F,e),g(Se,e),g(Be),g(He,e),g(Ae,e),g(Fe),g(Qe,e),g(De,e),g(Pe)}}}const mn={local:"understanding-pipelines-models-and-schedulers",sections:[{local:"deconstruct-a-basic-pipeline",title:"Deconstruct a basic pipeline"},{local:"deconstruct-the-stable-diffusion-pipeline",sections:[{local:"create-text-embeddings",title:"Create text embeddings"},{local:"create-random-noise",title:"Create random noise"},{local:"denoise-the-image",title:"Denoise the image"},{local:"decode-the-image",title:"Decode the image"}],title:"Deconstruct the Stable Diffusion pipeline"},{local:"next-steps",title:"Next steps"}],title:"Understanding pipelines, models and schedulers"};function dn(V){return tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends sn{constructor(h){super(),ln(this,h,dn,hn,en,{})}}export{yn as component};
