import{s as Om,n as xm,o as $m}from"../chunks/scheduler.9039eef2.js";import{S as Pm,i as wm,g as o,s as a,r as i,A as ym,h as r,f as l,c as n,j as _,u as d,x as s,k as h,y as t,a as v,v as c,d as m,t as p,w as g}from"../chunks/index.ded8f90d.js";import{D as f}from"../chunks/Docstring.a2ba2b54.js";import{H as N}from"../chunks/Heading.f027f30d.js";function Cm(yd){let ee,Jo,Yo,Qo,Xe,Xo,et,Cd=`At TRL we support PPO (Proximal Policy Optimisation) with an implementation that largely follows  the structure introduced in the paper “Fine-Tuning Language Models from Human Preferences” by D. Ziegler et al. [<a href="https://arxiv.org/pdf/1909.08593.pdf" rel="nofollow">paper</a>, <a href="https://github.com/openai/lm-human-preferences" rel="nofollow">code</a>].
The Trainer and model classes are largely inspired from <code>transformers.Trainer</code> and <code>transformers.AutoModel</code> classes and adapted for RL.
We also support a <code>RewardTrainer</code> that can be used to train a reward model.`,er,tt,tr,E,at,kl,Ra,kd='CPOConfig collects all training arguments related to the <a href="/docs/trl/v0.8.3/en/trainer#trl.CPOTrainer">CPOTrainer</a> class.',Dl,Ha,Dd=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ar,nt,nr,x,ot,Nl,Ua,Nd="Initialize CPOTrainer.",Fl,re,rt,Ll,Sa,Fd=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,zl,A,lt,Il,Aa,Ld="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",ql,Va,zd="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Ml,le,st,El,ja,Id="Concatenate the chosen and rejected inputs into a single tensor.",Rl,se,it,Hl,Ka,qd="Compute the CPO loss for a batch of policy and reference model log probabilities.",Ul,V,dt,Sl,Wa,Md=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Al,Ga,Ed="Works both with or without labels.",Vl,ie,ct,jl,Ba,Rd="Compute the log probabilities of the given labels under the given logits.",Kl,de,mt,Wl,Ya,Hd="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",Gl,ce,pt,Bl,Za,Ud="Generate samples from the model and reference model for the given batch of inputs.",Yl,me,gt,Zl,Ja,Sd="Log <code>logs</code> on the various objects watching training, including stored metrics.",Jl,L,_t,Ql,Qa,Ad="Tokenize a single row from a CPO specific dataset.",Xl,Xa,Vd=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,es,en,jd=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,or,ht,rr,te,ut,ts,tn,Kd="Configuration class for DDPOTrainer",lr,ft,sr,D,vt,as,an,Wd=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,ns,pe,bt,os,nn,Gd="Calculate the loss for a batch of an unpacked sample",rs,ge,Tt,ls,on,Bd="Creates and saves a model card for a TRL model.",ss,z,Ot,is,rn,Yd="Perform a single step of training.",ds,ln,Zd="Side Effects:",cs,sn,Jd="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",ms,_e,xt,ps,dn,Qd="Train the model for a given number of epochs",ir,$t,dr,b,Pt,gs,cn,Xd="Initialize DPOTrainer.",_s,he,wt,hs,mn,ec=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,us,ue,yt,fs,pn,tc="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",vs,j,Ct,bs,gn,ac="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Ts,_n,nc="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Os,fe,kt,xs,hn,oc="Concatenate the chosen and rejected inputs into a single tensor.",$s,ve,Dt,Ps,un,rc="Compute the DPO loss for a batch of policy and reference model log probabilities.",ws,K,Nt,ys,fn,lc=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Cs,vn,sc="Works both with or without labels.",ks,be,Ft,Ds,bn,ic="Compute the log probabilities of the given labels under the given logits.",Ns,Te,Lt,Fs,Tn,dc="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Ls,Oe,zt,zs,On,cc="Generate samples from the model and reference model for the given batch of inputs.",Is,W,It,qs,xn,mc="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Ms,$n,pc="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Es,G,qt,Rs,Pn,gc="Returns the training <code>~torch.utils.data.DataLoader</code>.",Hs,wn,_c="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Us,xe,Mt,Ss,yn,hc="Log <code>logs</code> on the various objects watching training, including stored metrics.",As,$e,Et,Vs,Cn,uc="Context manager for handling null reference model (that is, peft adapter manipulation).",js,I,Rt,Ks,kn,fc="Tokenize a single row from a DPO specific dataset.",Ws,Dn,vc=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Gs,Nn,bc=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,cr,Ht,mr,R,Ut,Bs,Fn,Tc="The IterativeSFTTrainer can be used to finetune models with methods that requires some steps between optimization.",Ys,Pe,St,Zs,Ln,Oc="Run an optimisation step given a list of input_ids, attention_mask, and labels or a list of text and text_labels.",pr,At,gr,H,Vt,Js,zn,xc='KTOConfig collects all training arguments related to the <a href="/docs/trl/v0.8.3/en/trainer#trl.KTOTrainer">KTOTrainer</a> class.',Qs,In,$c=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,_r,jt,hr,P,Kt,Xs,qn,Pc="Initialize KTOTrainer.",ei,we,Wt,ti,Mn,wc="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",ai,B,Gt,ni,En,yc=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,oi,Rn,Cc="Works both with or without labels.",ri,ye,Bt,li,Hn,kc="Compute the log probabilities of the given labels under the given logits.",si,Ce,Yt,ii,Un,Dc="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",di,ke,Zt,ci,Sn,Nc="Generate samples from the model and reference model for the given batch of inputs.",mi,Y,Jt,pi,An,Fc="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",gi,Vn,Lc="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",_i,Z,Qt,hi,jn,zc="Returns the training <code>~torch.utils.data.DataLoader</code>.",ui,Kn,Ic="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",fi,De,Xt,vi,Wn,qc="Compute the KTO loss for a batch of policy and reference model log probabilities.",bi,Ne,ea,Ti,Gn,Mc="Log <code>logs</code> on the various objects watching training, including stored metrics.",ur,ta,fr,U,aa,Oi,Bn,Ec='ORPOConfig collects all training arguments related to the <a href="/docs/trl/v0.8.3/en/trainer#trl.ORPOTrainer">ORPOTrainer</a> class.',xi,Yn,Rc=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,vr,na,br,$,oa,$i,Zn,Hc="Initialize ORPOTrainer.",Pi,Fe,ra,wi,Jn,Uc=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,yi,J,la,Ci,Qn,Sc="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",ki,Xn,Ac="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Di,Le,sa,Ni,eo,Vc="Concatenate the chosen and rejected inputs into a single tensor.",Fi,Q,ia,Li,to,jc=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,zi,ao,Kc="Works both with or without labels.",Ii,ze,da,qi,no,Wc="Compute the log probabilities of the given labels under the given logits.",Mi,Ie,ca,Ei,oo,Gc="Compute the ORPO loss and other metrics for the given batch of inputs for train or test.",Ri,qe,ma,Hi,ro,Bc="Generate samples from the model and reference model for the given batch of inputs.",Ui,Me,pa,Si,lo,Yc="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ai,Ee,ga,Vi,so,Zc="Compute ORPO’s odds ratio (OR) loss for a batch of policy and reference model log probabilities.",ji,q,_a,Ki,io,Jc="Tokenize a single row from a ORPO specific dataset.",Wi,co,Qc=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Gi,mo,Xc=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,Tr,ha,Or,ae,ua,Bi,po,em="Configuration class for PPOTrainer",xr,fa,$r,O,va,Yi,go,tm=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,Zi,Re,ba,Ji,_o,am="Calculate model outputs in multiple batches.",Qi,He,Ta,Xi,ho,nm="Compute per token rewards from scores and KL-penalty.",ed,Ue,Oa,td,uo,om="Creates and saves a model card for a TRL model.",ad,Se,xa,nd,fo,rm="Gather stats from all processes. Useful in the context of distributed training.",od,Ae,$a,rd,vo,lm=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,ld,Ve,Pa,sd,bo,sm="A function that logs all the training stats. Call it at the end of each epoch.",id,je,wa,dd,To,im="Calculate policy and value losses.",cd,Ke,ya,md,Oo,dm="Prepare the dataloader for training.",pd,We,Ca,gd,xo,cm="Record training step statistics.",_d,Ge,ka,hd,$o,mm="Run a PPO optimisation step given a list of queries, model responses, and rewards.",ud,Be,Da,fd,Po,pm="Train one PPO minibatch",Pr,Na,wr,S,Fa,vd,wo,gm='RewardConfig collects all training arguments related to the <a href="/docs/trl/v0.8.3/en/trainer#trl.RewardTrainer">RewardTrainer</a> class.',bd,yo,_m=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,yr,La,Cr,F,za,Td,Co,hm=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,Od,ko,um=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,xd,Do,fm="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",$d,No,vm=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,kr,Ia,Dr,ne,qa,Pd,Fo,bm=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Nr,Ma,Fr,oe,Ea,wd,Lo,Tm="Helper function for reproducible behavior to set the seed in <code>random</code>, <code>numpy</code>, and <code>torch</code>.",Lr,Zo,zr;return Xe=new N({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),tt=new N({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),at=new f({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in CPO loss.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>sigmoid</code>) &#x2014;
The type of loss to use. This argument is required if you want to use the default data collator.`,name:"loss_type"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_config.py#L20"}}),nt=new N({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),ot=new f({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L55"}}),rt=new f({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L304"}}),lt=new f({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L642"}}),st=new f({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L500",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),it=new f({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),dt=new f({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L834"}}),ct=new f({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L604",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),mt=new f({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L707"}}),pt=new f({props:{name:"get_batch_samples",anchor:"trl.CPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L769"}}),gt=new f({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L882"}}),_t=new f({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/cpo_trainer.py#L354"}}),ht=new N({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),ut=new f({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": Optional = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": Optional = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": Optional = ''"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ddpo_config.py#L11"}}),ft=new N({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),vt=new f({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": Callable"},{name:"prompt_function",val:": Callable"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ddpo_trainer.py#L55"}}),bt=new f({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ddpo_trainer.py#L340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),Tt=new f({props:{name:"create_model_card",anchor:"trl.DDPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL DDPO Model'"}],parametersDescription:[{anchor:"trl.DDPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.DDPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL DDPO Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ddpo_trainer.py#L606"}}),Ot=new f({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ddpo_trainer.py#L234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),xt=new f({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ddpo_trainer.py#L596"}}),$t=new N({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Pt=new f({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOTrainer.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOTrainer.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOTrainer.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOTrainer.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L65"}}),wt=new f({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L550"}}),yt=new f({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L758"}}),Ct=new f({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L961"}}),kt=new f({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L782",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Dt=new f({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L844",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Nt=new f({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L1182"}}),Ft=new f({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Lt=new f({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L1008"}}),zt=new f({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L1092"}}),It=new f({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v2.18.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L498"}}),qt=new f({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L455"}}),Mt=new f({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L1232"}}),Et=new f({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L746"}}),Rt=new f({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/dpo_trainer.py#L600"}}),Ht=new N({props:{title:"IterativeSFTTrainer",local:"trl.IterativeSFTTrainer",headingTag:"h2"}}),Ut=new f({props:{name:"class trl.IterativeSFTTrainer",anchor:"trl.IterativeSFTTrainer",parameters:[{name:"model",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"data_collator",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"truncation_mode",val:": Optional = 'keep_end'"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModel</code>) &#x2014; Model to be optimized, either an &#x2018;AutoModelForCausalLM&#x2019; or an &#x2018;AutoModelForSeq2SeqLM&#x2019;. &#x2014;
Check the documentation of <code>PreTrainedModel</code> for more details.`,name:"*model**"},{anchor:"trl.IterativeSFTTrainer.*args**",description:"*<strong>*args**</strong> (<code>transformers.TrainingArguments</code>) &#x2014; &#x2014; The arguments to use for training.",name:"*args**"},{anchor:"trl.IterativeSFTTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.IterativeSFTTrainer.*optimizers**",description:"*<strong>*optimizers**</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014; &#x2014; The optimizer and scheduler to use for training.",name:"*optimizers**"},{anchor:"trl.IterativeSFTTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (Union[DataCollatorForLanguageModeling, DataCollatorForSeq2Seq], <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader.`,name:"*data_collator**"},{anchor:"trl.IterativeSFTTrainer.*eval_dataset**",description:"*<strong>*eval_dataset**</strong> (<code>datasets.Dataset</code>) &#x2014; The dataset to use for evaluation.",name:"*eval_dataset**"},{anchor:"trl.IterativeSFTTrainer.*max_length**",description:"*<strong>*max_length**</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014; &#x2014; The maximum length of the input.",name:"*max_length**"},{anchor:"trl.IterativeSFTTrainer.*truncation_mode**",description:"*<strong>*truncation_mode**</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014; &#x2014; The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>.",name:"*truncation_mode**"},{anchor:"trl.IterativeSFTTrainer.*preprocess_logits_for_metrics**",description:"*<strong>*preprocess_logits_for_metrics**</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014; &#x2014; The function to use to preprocess the logits before computing the metrics.",name:"*preprocess_logits_for_metrics**"},{anchor:"trl.IterativeSFTTrainer.*compute_metrics**",description:"*<strong>*compute_metrics**</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014; &#x2014; The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return a dictionary string to metric values.",name:"*compute_metrics**"},{anchor:"trl.IterativeSFTTrainer.*optimize_device_cache",description:"*<strong>*optimize_device_cache</strong> *<em> (<code>bool</code>, </em>optional*, defaults to <code>False</code>) &#x2014; Optimize CUDA cache for slightly more memory-efficient training. &#x2014;",name:"*optimize_device_cache"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/iterative_sft_trainer.py#L39"}}),St=new f({props:{name:"step",anchor:"trl.IterativeSFTTrainer.step",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"texts",val:": Optional = None"},{name:"texts_labels",val:": Optional = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.step.input_ids",description:`<strong>input_ids</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the input_ids (if not provided, text will be used)`,name:"input_ids"},{anchor:"trl.IterativeSFTTrainer.step.attention_mask",description:`<strong>attention_mask</strong> (List<code>torch.LongTensor</code>, , <em>optional</em>) &#x2014;
List of tensors containing the attention_mask`,name:"attention_mask"},{anchor:"trl.IterativeSFTTrainer.step.labels",description:`<strong>labels</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of tensors containing the labels (if set to None, will default to input_ids)`,name:"labels"},{anchor:"trl.IterativeSFTTrainer.step.texts",description:`<strong>texts</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text input (if not provided, input_ids will directly be used)`,name:"texts"},{anchor:"trl.IterativeSFTTrainer.step.texts_labels",description:`<strong>texts_labels</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text labels (if set to None, will default to text)`,name:"texts_labels"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/iterative_sft_trainer.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),At=new N({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),Vt=new f({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_config.py#L20"}}),jt=new N({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),Kt=new f({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L224"}}),Wt=new f({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L774"}}),Gt=new f({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L1199"}}),Bt=new f({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L848",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Yt=new f({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L1004"}}),Zt=new f({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L1113"}}),Jt=new f({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v2.18.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L721"}}),Qt=new f({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L680"}}),Xt=new f({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),ea=new f({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/kto_trainer.py#L1255"}}),ta=new N({props:{title:"ORPOConfig",local:"trl.ORPOConfig",headingTag:"h2"}}),aa=new f({props:{name:"class trl.ORPOConfig",anchor:"trl.ORPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"disable_dropout",val:": bool = True"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.ORPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.ORPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the completions. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.ORPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in ORPO loss (lambda/alpha in paper/code) that is the weight of the relative loss ratio in the SFT loss.`,name:"beta"},{anchor:"trl.ORPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.ORPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.ORPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.ORPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.ORPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.ORPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.ORPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.ORPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_config.py#L20"}}),na=new N({props:{title:"ORPOTrainer",local:"trl.ORPOTrainer",headingTag:"h2"}}),oa=new f({props:{name:"class trl.ORPOTrainer",anchor:"trl.ORPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.ORPOTrainer.args",description:`<strong>args</strong> (<code>ORPOConfig</code>) &#x2014;
The ORPO config arguments to use for training.`,name:"args"},{anchor:"trl.ORPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.ORPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.ORPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.ORPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.ORPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.ORPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.ORPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.ORPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.ORPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.ORPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L62"}}),ra=new f({props:{name:"build_tokenized_answer",anchor:"trl.ORPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L334"}}),la=new f({props:{name:"concatenated_forward",anchor:"trl.ORPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L662"}}),sa=new f({props:{name:"concatenated_inputs",anchor:"trl.ORPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L530",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),ia=new f({props:{name:"evaluation_loop",anchor:"trl.ORPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L860"}}),da=new f({props:{name:"get_batch_logps",anchor:"trl.ORPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L624",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ca=new f({props:{name:"get_batch_loss_metrics",anchor:"trl.ORPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L731"}}),ma=new f({props:{name:"get_batch_samples",anchor:"trl.ORPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L795"}}),pa=new f({props:{name:"log",anchor:"trl.ORPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.ORPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L908"}}),ga=new f({props:{name:"odds_ratio_loss",anchor:"trl.ORPOTrainer.odds_ratio_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L592",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the ORPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The log odds ratio of the chosen responses over the rejected responses ratio for logging purposes.
The <code>log(sigmoid(log_odds_chosen))</code> for logging purposes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),_a=new f({props:{name:"tokenize_row",anchor:"trl.ORPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/orpo_trainer.py#L384"}}),ha=new N({props:{title:"PPOConfig",local:"trl.PPOConfig",headingTag:"h2"}}),ua=new f({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": Optional = 'gpt2'"},{name:"query_dataset",val:": Optional = 'imdb'"},{name:"reward_model",val:": Optional = 'sentiment-analysis:lvwerra/distilbert-imdb'"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1.41e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": Optional = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": Optional = 6"},{name:"horizon",val:": Optional = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 128"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 128"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Annotated = None"},{name:"global_batch_size",val:": Annotated = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_config.py#L34"}}),fa=new N({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),va=new f({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L114"}}),ba=new f({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L951",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),Ta=new f({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L1088",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Oa=new f({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L1396"}}),xa=new f({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L907",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),$a=new f({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Optional = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L436",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),Pa=new f({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": Iterable = ('query', 'response')"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L1323"}}),wa=new f({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L1170"}}),ya=new f({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),Ca=new f({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L1259",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),ka=new f({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L627",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Da=new f({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/ppo_trainer.py#L1042",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),Na=new N({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),Fa=new f({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/reward_config.py#L21"}}),La=new N({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),za=new f({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/reward_trainer.py#L36"}}),Ia=new N({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),qa=new f({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/v4.39.3/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/v2.18.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/v4.39.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets
eval_packing &#x2014; (<code>Optional[bool]</code>, <em>optional</em>):
Whether to pack the eval dataset as well. Defaults to <code>packing</code> if <code>None</code> is passed.`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/trainer/sft_trainer.py#L57"}}),Ma=new N({props:{title:"set_seed",local:"trl.set_seed",headingTag:"h2"}}),Ea=new f({props:{name:"trl.set_seed",anchor:"trl.set_seed",parameters:[{name:"seed",val:": int"}],parametersDescription:[{anchor:"trl.set_seed.seed",description:"<strong>seed</strong> (<code>int</code>) &#x2014; The seed to set.",name:"seed"}],source:"https://github.com/huggingface/trl/blob/v0.8.3/trl/core.py#L245"}}),{c(){ee=o("meta"),Jo=a(),Yo=o("p"),Qo=a(),i(Xe.$$.fragment),Xo=a(),et=o("p"),et.innerHTML=Cd,er=a(),i(tt.$$.fragment),tr=a(),E=o("div"),i(at.$$.fragment),kl=a(),Ra=o("p"),Ra.innerHTML=kd,Dl=a(),Ha=o("p"),Ha.innerHTML=Dd,ar=a(),i(nt.$$.fragment),nr=a(),x=o("div"),i(ot.$$.fragment),Nl=a(),Ua=o("p"),Ua.textContent=Nd,Fl=a(),re=o("div"),i(rt.$$.fragment),Ll=a(),Sa=o("p"),Sa.innerHTML=Fd,zl=a(),A=o("div"),i(lt.$$.fragment),Il=a(),Aa=o("p"),Aa.textContent=Ld,ql=a(),Va=o("p"),Va.textContent=zd,Ml=a(),le=o("div"),i(st.$$.fragment),El=a(),ja=o("p"),ja.textContent=Id,Rl=a(),se=o("div"),i(it.$$.fragment),Hl=a(),Ka=o("p"),Ka.textContent=qd,Ul=a(),V=o("div"),i(dt.$$.fragment),Sl=a(),Wa=o("p"),Wa.innerHTML=Md,Al=a(),Ga=o("p"),Ga.textContent=Ed,Vl=a(),ie=o("div"),i(ct.$$.fragment),jl=a(),Ba=o("p"),Ba.textContent=Rd,Kl=a(),de=o("div"),i(mt.$$.fragment),Wl=a(),Ya=o("p"),Ya.textContent=Hd,Gl=a(),ce=o("div"),i(pt.$$.fragment),Bl=a(),Za=o("p"),Za.textContent=Ud,Yl=a(),me=o("div"),i(gt.$$.fragment),Zl=a(),Ja=o("p"),Ja.innerHTML=Sd,Jl=a(),L=o("div"),i(_t.$$.fragment),Ql=a(),Qa=o("p"),Qa.textContent=Ad,Xl=a(),Xa=o("p"),Xa.textContent=Vd,es=a(),en=o("p"),en.textContent=jd,or=a(),i(ht.$$.fragment),rr=a(),te=o("div"),i(ut.$$.fragment),ts=a(),tn=o("p"),tn.textContent=Kd,lr=a(),i(ft.$$.fragment),sr=a(),D=o("div"),i(vt.$$.fragment),as=a(),an=o("p"),an.innerHTML=Wd,ns=a(),pe=o("div"),i(bt.$$.fragment),os=a(),nn=o("p"),nn.textContent=Gd,rs=a(),ge=o("div"),i(Tt.$$.fragment),ls=a(),on=o("p"),on.textContent=Bd,ss=a(),z=o("div"),i(Ot.$$.fragment),is=a(),rn=o("p"),rn.textContent=Yd,ds=a(),ln=o("p"),ln.textContent=Zd,cs=a(),sn=o("ul"),sn.innerHTML=Jd,ms=a(),_e=o("div"),i(xt.$$.fragment),ps=a(),dn=o("p"),dn.textContent=Qd,ir=a(),i($t.$$.fragment),dr=a(),b=o("div"),i(Pt.$$.fragment),gs=a(),cn=o("p"),cn.textContent=Xd,_s=a(),he=o("div"),i(wt.$$.fragment),hs=a(),mn=o("p"),mn.innerHTML=ec,us=a(),ue=o("div"),i(yt.$$.fragment),fs=a(),pn=o("p"),pn.textContent=tc,vs=a(),j=o("div"),i(Ct.$$.fragment),bs=a(),gn=o("p"),gn.textContent=ac,Ts=a(),_n=o("p"),_n.textContent=nc,Os=a(),fe=o("div"),i(kt.$$.fragment),xs=a(),hn=o("p"),hn.textContent=oc,$s=a(),ve=o("div"),i(Dt.$$.fragment),Ps=a(),un=o("p"),un.textContent=rc,ws=a(),K=o("div"),i(Nt.$$.fragment),ys=a(),fn=o("p"),fn.innerHTML=lc,Cs=a(),vn=o("p"),vn.textContent=sc,ks=a(),be=o("div"),i(Ft.$$.fragment),Ds=a(),bn=o("p"),bn.textContent=ic,Ns=a(),Te=o("div"),i(Lt.$$.fragment),Fs=a(),Tn=o("p"),Tn.textContent=dc,Ls=a(),Oe=o("div"),i(zt.$$.fragment),zs=a(),On=o("p"),On.textContent=cc,Is=a(),W=o("div"),i(It.$$.fragment),qs=a(),xn=o("p"),xn.innerHTML=mc,Ms=a(),$n=o("p"),$n.innerHTML=pc,Es=a(),G=o("div"),i(qt.$$.fragment),Rs=a(),Pn=o("p"),Pn.innerHTML=gc,Hs=a(),wn=o("p"),wn.innerHTML=_c,Us=a(),xe=o("div"),i(Mt.$$.fragment),Ss=a(),yn=o("p"),yn.innerHTML=hc,As=a(),$e=o("div"),i(Et.$$.fragment),Vs=a(),Cn=o("p"),Cn.textContent=uc,js=a(),I=o("div"),i(Rt.$$.fragment),Ks=a(),kn=o("p"),kn.textContent=fc,Ws=a(),Dn=o("p"),Dn.textContent=vc,Gs=a(),Nn=o("p"),Nn.textContent=bc,cr=a(),i(Ht.$$.fragment),mr=a(),R=o("div"),i(Ut.$$.fragment),Bs=a(),Fn=o("p"),Fn.textContent=Tc,Ys=a(),Pe=o("div"),i(St.$$.fragment),Zs=a(),Ln=o("p"),Ln.textContent=Oc,pr=a(),i(At.$$.fragment),gr=a(),H=o("div"),i(Vt.$$.fragment),Js=a(),zn=o("p"),zn.innerHTML=xc,Qs=a(),In=o("p"),In.innerHTML=$c,_r=a(),i(jt.$$.fragment),hr=a(),P=o("div"),i(Kt.$$.fragment),Xs=a(),qn=o("p"),qn.textContent=Pc,ei=a(),we=o("div"),i(Wt.$$.fragment),ti=a(),Mn=o("p"),Mn.textContent=wc,ai=a(),B=o("div"),i(Gt.$$.fragment),ni=a(),En=o("p"),En.innerHTML=yc,oi=a(),Rn=o("p"),Rn.textContent=Cc,ri=a(),ye=o("div"),i(Bt.$$.fragment),li=a(),Hn=o("p"),Hn.textContent=kc,si=a(),Ce=o("div"),i(Yt.$$.fragment),ii=a(),Un=o("p"),Un.textContent=Dc,di=a(),ke=o("div"),i(Zt.$$.fragment),ci=a(),Sn=o("p"),Sn.textContent=Nc,mi=a(),Y=o("div"),i(Jt.$$.fragment),pi=a(),An=o("p"),An.innerHTML=Fc,gi=a(),Vn=o("p"),Vn.innerHTML=Lc,_i=a(),Z=o("div"),i(Qt.$$.fragment),hi=a(),jn=o("p"),jn.innerHTML=zc,ui=a(),Kn=o("p"),Kn.innerHTML=Ic,fi=a(),De=o("div"),i(Xt.$$.fragment),vi=a(),Wn=o("p"),Wn.textContent=qc,bi=a(),Ne=o("div"),i(ea.$$.fragment),Ti=a(),Gn=o("p"),Gn.innerHTML=Mc,ur=a(),i(ta.$$.fragment),fr=a(),U=o("div"),i(aa.$$.fragment),Oi=a(),Bn=o("p"),Bn.innerHTML=Ec,xi=a(),Yn=o("p"),Yn.innerHTML=Rc,vr=a(),i(na.$$.fragment),br=a(),$=o("div"),i(oa.$$.fragment),$i=a(),Zn=o("p"),Zn.textContent=Hc,Pi=a(),Fe=o("div"),i(ra.$$.fragment),wi=a(),Jn=o("p"),Jn.innerHTML=Uc,yi=a(),J=o("div"),i(la.$$.fragment),Ci=a(),Qn=o("p"),Qn.textContent=Sc,ki=a(),Xn=o("p"),Xn.textContent=Ac,Di=a(),Le=o("div"),i(sa.$$.fragment),Ni=a(),eo=o("p"),eo.textContent=Vc,Fi=a(),Q=o("div"),i(ia.$$.fragment),Li=a(),to=o("p"),to.innerHTML=jc,zi=a(),ao=o("p"),ao.textContent=Kc,Ii=a(),ze=o("div"),i(da.$$.fragment),qi=a(),no=o("p"),no.textContent=Wc,Mi=a(),Ie=o("div"),i(ca.$$.fragment),Ei=a(),oo=o("p"),oo.textContent=Gc,Ri=a(),qe=o("div"),i(ma.$$.fragment),Hi=a(),ro=o("p"),ro.textContent=Bc,Ui=a(),Me=o("div"),i(pa.$$.fragment),Si=a(),lo=o("p"),lo.innerHTML=Yc,Ai=a(),Ee=o("div"),i(ga.$$.fragment),Vi=a(),so=o("p"),so.textContent=Zc,ji=a(),q=o("div"),i(_a.$$.fragment),Ki=a(),io=o("p"),io.textContent=Jc,Wi=a(),co=o("p"),co.textContent=Qc,Gi=a(),mo=o("p"),mo.textContent=Xc,Tr=a(),i(ha.$$.fragment),Or=a(),ae=o("div"),i(ua.$$.fragment),Bi=a(),po=o("p"),po.textContent=em,xr=a(),i(fa.$$.fragment),$r=a(),O=o("div"),i(va.$$.fragment),Yi=a(),go=o("p"),go.innerHTML=tm,Zi=a(),Re=o("div"),i(ba.$$.fragment),Ji=a(),_o=o("p"),_o.textContent=am,Qi=a(),He=o("div"),i(Ta.$$.fragment),Xi=a(),ho=o("p"),ho.textContent=nm,ed=a(),Ue=o("div"),i(Oa.$$.fragment),td=a(),uo=o("p"),uo.textContent=om,ad=a(),Se=o("div"),i(xa.$$.fragment),nd=a(),fo=o("p"),fo.textContent=rm,od=a(),Ae=o("div"),i($a.$$.fragment),rd=a(),vo=o("p"),vo.innerHTML=lm,ld=a(),Ve=o("div"),i(Pa.$$.fragment),sd=a(),bo=o("p"),bo.textContent=sm,id=a(),je=o("div"),i(wa.$$.fragment),dd=a(),To=o("p"),To.textContent=im,cd=a(),Ke=o("div"),i(ya.$$.fragment),md=a(),Oo=o("p"),Oo.textContent=dm,pd=a(),We=o("div"),i(Ca.$$.fragment),gd=a(),xo=o("p"),xo.textContent=cm,_d=a(),Ge=o("div"),i(ka.$$.fragment),hd=a(),$o=o("p"),$o.textContent=mm,ud=a(),Be=o("div"),i(Da.$$.fragment),fd=a(),Po=o("p"),Po.textContent=pm,Pr=a(),i(Na.$$.fragment),wr=a(),S=o("div"),i(Fa.$$.fragment),vd=a(),wo=o("p"),wo.innerHTML=gm,bd=a(),yo=o("p"),yo.innerHTML=_m,yr=a(),i(La.$$.fragment),Cr=a(),F=o("div"),i(za.$$.fragment),Td=a(),Co=o("p"),Co.innerHTML=hm,Od=a(),ko=o("p"),ko.innerHTML=um,xd=a(),Do=o("ul"),Do.innerHTML=fm,$d=a(),No=o("p"),No.innerHTML=vm,kr=a(),i(Ia.$$.fragment),Dr=a(),ne=o("div"),i(qa.$$.fragment),Pd=a(),Fo=o("p"),Fo.innerHTML=bm,Nr=a(),i(Ma.$$.fragment),Fr=a(),oe=o("div"),i(Ea.$$.fragment),wd=a(),Lo=o("p"),Lo.innerHTML=Tm,Lr=a(),Zo=o("p"),this.h()},l(e){const u=ym("svelte-u9bgzb",document.head);ee=r(u,"META",{name:!0,content:!0}),u.forEach(l),Jo=n(e),Yo=r(e,"P",{}),_(Yo).forEach(l),Qo=n(e),d(Xe.$$.fragment,e),Xo=n(e),et=r(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-dxrcnp"&&(et.innerHTML=Cd),er=n(e),d(tt.$$.fragment,e),tr=n(e),E=r(e,"DIV",{class:!0});var zo=_(E);d(at.$$.fragment,zo),kl=n(zo),Ra=r(zo,"P",{"data-svelte-h":!0}),s(Ra)!=="svelte-1x1068c"&&(Ra.innerHTML=kd),Dl=n(zo),Ha=r(zo,"P",{"data-svelte-h":!0}),s(Ha)!=="svelte-1xl7jqc"&&(Ha.innerHTML=Dd),zo.forEach(l),ar=n(e),d(nt.$$.fragment,e),nr=n(e),x=r(e,"DIV",{class:!0});var y=_(x);d(ot.$$.fragment,y),Nl=n(y),Ua=r(y,"P",{"data-svelte-h":!0}),s(Ua)!=="svelte-1qqtmoh"&&(Ua.textContent=Nd),Fl=n(y),re=r(y,"DIV",{class:!0});var Ir=_(re);d(rt.$$.fragment,Ir),Ll=n(Ir),Sa=r(Ir,"P",{"data-svelte-h":!0}),s(Sa)!=="svelte-mcz8nm"&&(Sa.innerHTML=Fd),Ir.forEach(l),zl=n(y),A=r(y,"DIV",{class:!0});var Io=_(A);d(lt.$$.fragment,Io),Il=n(Io),Aa=r(Io,"P",{"data-svelte-h":!0}),s(Aa)!=="svelte-16i1nac"&&(Aa.textContent=Ld),ql=n(Io),Va=r(Io,"P",{"data-svelte-h":!0}),s(Va)!=="svelte-tgti68"&&(Va.textContent=zd),Io.forEach(l),Ml=n(y),le=r(y,"DIV",{class:!0});var qr=_(le);d(st.$$.fragment,qr),El=n(qr),ja=r(qr,"P",{"data-svelte-h":!0}),s(ja)!=="svelte-1cvsgkk"&&(ja.textContent=Id),qr.forEach(l),Rl=n(y),se=r(y,"DIV",{class:!0});var Mr=_(se);d(it.$$.fragment,Mr),Hl=n(Mr),Ka=r(Mr,"P",{"data-svelte-h":!0}),s(Ka)!=="svelte-1l2rxe2"&&(Ka.textContent=qd),Mr.forEach(l),Ul=n(y),V=r(y,"DIV",{class:!0});var qo=_(V);d(dt.$$.fragment,qo),Sl=n(qo),Wa=r(qo,"P",{"data-svelte-h":!0}),s(Wa)!=="svelte-8qlty5"&&(Wa.innerHTML=Md),Al=n(qo),Ga=r(qo,"P",{"data-svelte-h":!0}),s(Ga)!=="svelte-1tyo99t"&&(Ga.textContent=Ed),qo.forEach(l),Vl=n(y),ie=r(y,"DIV",{class:!0});var Er=_(ie);d(ct.$$.fragment,Er),jl=n(Er),Ba=r(Er,"P",{"data-svelte-h":!0}),s(Ba)!=="svelte-4nmimv"&&(Ba.textContent=Rd),Er.forEach(l),Kl=n(y),de=r(y,"DIV",{class:!0});var Rr=_(de);d(mt.$$.fragment,Rr),Wl=n(Rr),Ya=r(Rr,"P",{"data-svelte-h":!0}),s(Ya)!=="svelte-4kzfyw"&&(Ya.textContent=Hd),Rr.forEach(l),Gl=n(y),ce=r(y,"DIV",{class:!0});var Hr=_(ce);d(pt.$$.fragment,Hr),Bl=n(Hr),Za=r(Hr,"P",{"data-svelte-h":!0}),s(Za)!=="svelte-18uwvbi"&&(Za.textContent=Ud),Hr.forEach(l),Yl=n(y),me=r(y,"DIV",{class:!0});var Ur=_(me);d(gt.$$.fragment,Ur),Zl=n(Ur),Ja=r(Ur,"P",{"data-svelte-h":!0}),s(Ja)!=="svelte-nqksfz"&&(Ja.innerHTML=Sd),Ur.forEach(l),Jl=n(y),L=r(y,"DIV",{class:!0});var Ye=_(L);d(_t.$$.fragment,Ye),Ql=n(Ye),Qa=r(Ye,"P",{"data-svelte-h":!0}),s(Qa)!=="svelte-1a53vwp"&&(Qa.textContent=Ad),Xl=n(Ye),Xa=r(Ye,"P",{"data-svelte-h":!0}),s(Xa)!=="svelte-1mn1gnw"&&(Xa.textContent=Vd),es=n(Ye),en=r(Ye,"P",{"data-svelte-h":!0}),s(en)!=="svelte-1xvpyih"&&(en.textContent=jd),Ye.forEach(l),y.forEach(l),or=n(e),d(ht.$$.fragment,e),rr=n(e),te=r(e,"DIV",{class:!0});var Sr=_(te);d(ut.$$.fragment,Sr),ts=n(Sr),tn=r(Sr,"P",{"data-svelte-h":!0}),s(tn)!=="svelte-2zpx1f"&&(tn.textContent=Kd),Sr.forEach(l),lr=n(e),d(ft.$$.fragment,e),sr=n(e),D=r(e,"DIV",{class:!0});var M=_(D);d(vt.$$.fragment,M),as=n(M),an=r(M,"P",{"data-svelte-h":!0}),s(an)!=="svelte-8q861t"&&(an.innerHTML=Wd),ns=n(M),pe=r(M,"DIV",{class:!0});var Ar=_(pe);d(bt.$$.fragment,Ar),os=n(Ar),nn=r(Ar,"P",{"data-svelte-h":!0}),s(nn)!=="svelte-1ag17u3"&&(nn.textContent=Gd),Ar.forEach(l),rs=n(M),ge=r(M,"DIV",{class:!0});var Vr=_(ge);d(Tt.$$.fragment,Vr),ls=n(Vr),on=r(Vr,"P",{"data-svelte-h":!0}),s(on)!=="svelte-3jfrz9"&&(on.textContent=Bd),Vr.forEach(l),ss=n(M),z=r(M,"DIV",{class:!0});var Ze=_(z);d(Ot.$$.fragment,Ze),is=n(Ze),rn=r(Ze,"P",{"data-svelte-h":!0}),s(rn)!=="svelte-r6y15n"&&(rn.textContent=Yd),ds=n(Ze),ln=r(Ze,"P",{"data-svelte-h":!0}),s(ln)!=="svelte-imqqfp"&&(ln.textContent=Zd),cs=n(Ze),sn=r(Ze,"UL",{"data-svelte-h":!0}),s(sn)!=="svelte-105j238"&&(sn.innerHTML=Jd),Ze.forEach(l),ms=n(M),_e=r(M,"DIV",{class:!0});var jr=_(_e);d(xt.$$.fragment,jr),ps=n(jr),dn=r(jr,"P",{"data-svelte-h":!0}),s(dn)!=="svelte-1an944l"&&(dn.textContent=Qd),jr.forEach(l),M.forEach(l),ir=n(e),d($t.$$.fragment,e),dr=n(e),b=r(e,"DIV",{class:!0});var T=_(b);d(Pt.$$.fragment,T),gs=n(T),cn=r(T,"P",{"data-svelte-h":!0}),s(cn)!=="svelte-n6cc8y"&&(cn.textContent=Xd),_s=n(T),he=r(T,"DIV",{class:!0});var Kr=_(he);d(wt.$$.fragment,Kr),hs=n(Kr),mn=r(Kr,"P",{"data-svelte-h":!0}),s(mn)!=="svelte-mcz8nm"&&(mn.innerHTML=ec),Kr.forEach(l),us=n(T),ue=r(T,"DIV",{class:!0});var Wr=_(ue);d(yt.$$.fragment,Wr),fs=n(Wr),pn=r(Wr,"P",{"data-svelte-h":!0}),s(pn)!=="svelte-10t1062"&&(pn.textContent=tc),Wr.forEach(l),vs=n(T),j=r(T,"DIV",{class:!0});var Mo=_(j);d(Ct.$$.fragment,Mo),bs=n(Mo),gn=r(Mo,"P",{"data-svelte-h":!0}),s(gn)!=="svelte-16i1nac"&&(gn.textContent=ac),Ts=n(Mo),_n=r(Mo,"P",{"data-svelte-h":!0}),s(_n)!=="svelte-tgti68"&&(_n.textContent=nc),Mo.forEach(l),Os=n(T),fe=r(T,"DIV",{class:!0});var Gr=_(fe);d(kt.$$.fragment,Gr),xs=n(Gr),hn=r(Gr,"P",{"data-svelte-h":!0}),s(hn)!=="svelte-1cvsgkk"&&(hn.textContent=oc),Gr.forEach(l),$s=n(T),ve=r(T,"DIV",{class:!0});var Br=_(ve);d(Dt.$$.fragment,Br),Ps=n(Br),un=r(Br,"P",{"data-svelte-h":!0}),s(un)!=="svelte-ymgxq7"&&(un.textContent=rc),Br.forEach(l),ws=n(T),K=r(T,"DIV",{class:!0});var Eo=_(K);d(Nt.$$.fragment,Eo),ys=n(Eo),fn=r(Eo,"P",{"data-svelte-h":!0}),s(fn)!=="svelte-8qlty5"&&(fn.innerHTML=lc),Cs=n(Eo),vn=r(Eo,"P",{"data-svelte-h":!0}),s(vn)!=="svelte-1tyo99t"&&(vn.textContent=sc),Eo.forEach(l),ks=n(T),be=r(T,"DIV",{class:!0});var Yr=_(be);d(Ft.$$.fragment,Yr),Ds=n(Yr),bn=r(Yr,"P",{"data-svelte-h":!0}),s(bn)!=="svelte-4nmimv"&&(bn.textContent=ic),Yr.forEach(l),Ns=n(T),Te=r(T,"DIV",{class:!0});var Zr=_(Te);d(Lt.$$.fragment,Zr),Fs=n(Zr),Tn=r(Zr,"P",{"data-svelte-h":!0}),s(Tn)!=="svelte-11q8u7l"&&(Tn.textContent=dc),Zr.forEach(l),Ls=n(T),Oe=r(T,"DIV",{class:!0});var Jr=_(Oe);d(zt.$$.fragment,Jr),zs=n(Jr),On=r(Jr,"P",{"data-svelte-h":!0}),s(On)!=="svelte-18uwvbi"&&(On.textContent=cc),Jr.forEach(l),Is=n(T),W=r(T,"DIV",{class:!0});var Ro=_(W);d(It.$$.fragment,Ro),qs=n(Ro),xn=r(Ro,"P",{"data-svelte-h":!0}),s(xn)!=="svelte-xesobz"&&(xn.innerHTML=mc),Ms=n(Ro),$n=r(Ro,"P",{"data-svelte-h":!0}),s($n)!=="svelte-qg43tm"&&($n.innerHTML=pc),Ro.forEach(l),Es=n(T),G=r(T,"DIV",{class:!0});var Ho=_(G);d(qt.$$.fragment,Ho),Rs=n(Ho),Pn=r(Ho,"P",{"data-svelte-h":!0}),s(Pn)!=="svelte-dkae9b"&&(Pn.innerHTML=gc),Hs=n(Ho),wn=r(Ho,"P",{"data-svelte-h":!0}),s(wn)!=="svelte-hmd5cw"&&(wn.innerHTML=_c),Ho.forEach(l),Us=n(T),xe=r(T,"DIV",{class:!0});var Qr=_(xe);d(Mt.$$.fragment,Qr),Ss=n(Qr),yn=r(Qr,"P",{"data-svelte-h":!0}),s(yn)!=="svelte-nqksfz"&&(yn.innerHTML=hc),Qr.forEach(l),As=n(T),$e=r(T,"DIV",{class:!0});var Xr=_($e);d(Et.$$.fragment,Xr),Vs=n(Xr),Cn=r(Xr,"P",{"data-svelte-h":!0}),s(Cn)!=="svelte-17kjsy4"&&(Cn.textContent=uc),Xr.forEach(l),js=n(T),I=r(T,"DIV",{class:!0});var Je=_(I);d(Rt.$$.fragment,Je),Ks=n(Je),kn=r(Je,"P",{"data-svelte-h":!0}),s(kn)!=="svelte-1861yti"&&(kn.textContent=fc),Ws=n(Je),Dn=r(Je,"P",{"data-svelte-h":!0}),s(Dn)!=="svelte-1mn1gnw"&&(Dn.textContent=vc),Gs=n(Je),Nn=r(Je,"P",{"data-svelte-h":!0}),s(Nn)!=="svelte-1xvpyih"&&(Nn.textContent=bc),Je.forEach(l),T.forEach(l),cr=n(e),d(Ht.$$.fragment,e),mr=n(e),R=r(e,"DIV",{class:!0});var Uo=_(R);d(Ut.$$.fragment,Uo),Bs=n(Uo),Fn=r(Uo,"P",{"data-svelte-h":!0}),s(Fn)!=="svelte-xqyw6w"&&(Fn.textContent=Tc),Ys=n(Uo),Pe=r(Uo,"DIV",{class:!0});var el=_(Pe);d(St.$$.fragment,el),Zs=n(el),Ln=r(el,"P",{"data-svelte-h":!0}),s(Ln)!=="svelte-v7dhdf"&&(Ln.textContent=Oc),el.forEach(l),Uo.forEach(l),pr=n(e),d(At.$$.fragment,e),gr=n(e),H=r(e,"DIV",{class:!0});var So=_(H);d(Vt.$$.fragment,So),Js=n(So),zn=r(So,"P",{"data-svelte-h":!0}),s(zn)!=="svelte-vemnqg"&&(zn.innerHTML=xc),Qs=n(So),In=r(So,"P",{"data-svelte-h":!0}),s(In)!=="svelte-1xl7jqc"&&(In.innerHTML=$c),So.forEach(l),_r=n(e),d(jt.$$.fragment,e),hr=n(e),P=r(e,"DIV",{class:!0});var k=_(P);d(Kt.$$.fragment,k),Xs=n(k),qn=r(k,"P",{"data-svelte-h":!0}),s(qn)!=="svelte-hyhzxp"&&(qn.textContent=Pc),ei=n(k),we=r(k,"DIV",{class:!0});var tl=_(we);d(Wt.$$.fragment,tl),ti=n(tl),Mn=r(tl,"P",{"data-svelte-h":!0}),s(Mn)!=="svelte-pt6g01"&&(Mn.textContent=wc),tl.forEach(l),ai=n(k),B=r(k,"DIV",{class:!0});var Ao=_(B);d(Gt.$$.fragment,Ao),ni=n(Ao),En=r(Ao,"P",{"data-svelte-h":!0}),s(En)!=="svelte-8qlty5"&&(En.innerHTML=yc),oi=n(Ao),Rn=r(Ao,"P",{"data-svelte-h":!0}),s(Rn)!=="svelte-1tyo99t"&&(Rn.textContent=Cc),Ao.forEach(l),ri=n(k),ye=r(k,"DIV",{class:!0});var al=_(ye);d(Bt.$$.fragment,al),li=n(al),Hn=r(al,"P",{"data-svelte-h":!0}),s(Hn)!=="svelte-4nmimv"&&(Hn.textContent=kc),al.forEach(l),si=n(k),Ce=r(k,"DIV",{class:!0});var nl=_(Ce);d(Yt.$$.fragment,nl),ii=n(nl),Un=r(nl,"P",{"data-svelte-h":!0}),s(Un)!=="svelte-db7iek"&&(Un.textContent=Dc),nl.forEach(l),di=n(k),ke=r(k,"DIV",{class:!0});var ol=_(ke);d(Zt.$$.fragment,ol),ci=n(ol),Sn=r(ol,"P",{"data-svelte-h":!0}),s(Sn)!=="svelte-18uwvbi"&&(Sn.textContent=Nc),ol.forEach(l),mi=n(k),Y=r(k,"DIV",{class:!0});var Vo=_(Y);d(Jt.$$.fragment,Vo),pi=n(Vo),An=r(Vo,"P",{"data-svelte-h":!0}),s(An)!=="svelte-xesobz"&&(An.innerHTML=Fc),gi=n(Vo),Vn=r(Vo,"P",{"data-svelte-h":!0}),s(Vn)!=="svelte-qg43tm"&&(Vn.innerHTML=Lc),Vo.forEach(l),_i=n(k),Z=r(k,"DIV",{class:!0});var jo=_(Z);d(Qt.$$.fragment,jo),hi=n(jo),jn=r(jo,"P",{"data-svelte-h":!0}),s(jn)!=="svelte-dkae9b"&&(jn.innerHTML=zc),ui=n(jo),Kn=r(jo,"P",{"data-svelte-h":!0}),s(Kn)!=="svelte-hmd5cw"&&(Kn.innerHTML=Ic),jo.forEach(l),fi=n(k),De=r(k,"DIV",{class:!0});var rl=_(De);d(Xt.$$.fragment,rl),vi=n(rl),Wn=r(rl,"P",{"data-svelte-h":!0}),s(Wn)!=="svelte-svckwe"&&(Wn.textContent=qc),rl.forEach(l),bi=n(k),Ne=r(k,"DIV",{class:!0});var ll=_(Ne);d(ea.$$.fragment,ll),Ti=n(ll),Gn=r(ll,"P",{"data-svelte-h":!0}),s(Gn)!=="svelte-nqksfz"&&(Gn.innerHTML=Mc),ll.forEach(l),k.forEach(l),ur=n(e),d(ta.$$.fragment,e),fr=n(e),U=r(e,"DIV",{class:!0});var Ko=_(U);d(aa.$$.fragment,Ko),Oi=n(Ko),Bn=r(Ko,"P",{"data-svelte-h":!0}),s(Bn)!=="svelte-2mpr6q"&&(Bn.innerHTML=Ec),xi=n(Ko),Yn=r(Ko,"P",{"data-svelte-h":!0}),s(Yn)!=="svelte-1xl7jqc"&&(Yn.innerHTML=Rc),Ko.forEach(l),vr=n(e),d(na.$$.fragment,e),br=n(e),$=r(e,"DIV",{class:!0});var C=_($);d(oa.$$.fragment,C),$i=n(C),Zn=r(C,"P",{"data-svelte-h":!0}),s(Zn)!=="svelte-1ggwo37"&&(Zn.textContent=Hc),Pi=n(C),Fe=r(C,"DIV",{class:!0});var sl=_(Fe);d(ra.$$.fragment,sl),wi=n(sl),Jn=r(sl,"P",{"data-svelte-h":!0}),s(Jn)!=="svelte-mcz8nm"&&(Jn.innerHTML=Uc),sl.forEach(l),yi=n(C),J=r(C,"DIV",{class:!0});var Wo=_(J);d(la.$$.fragment,Wo),Ci=n(Wo),Qn=r(Wo,"P",{"data-svelte-h":!0}),s(Qn)!=="svelte-16i1nac"&&(Qn.textContent=Sc),ki=n(Wo),Xn=r(Wo,"P",{"data-svelte-h":!0}),s(Xn)!=="svelte-tgti68"&&(Xn.textContent=Ac),Wo.forEach(l),Di=n(C),Le=r(C,"DIV",{class:!0});var il=_(Le);d(sa.$$.fragment,il),Ni=n(il),eo=r(il,"P",{"data-svelte-h":!0}),s(eo)!=="svelte-1cvsgkk"&&(eo.textContent=Vc),il.forEach(l),Fi=n(C),Q=r(C,"DIV",{class:!0});var Go=_(Q);d(ia.$$.fragment,Go),Li=n(Go),to=r(Go,"P",{"data-svelte-h":!0}),s(to)!=="svelte-8qlty5"&&(to.innerHTML=jc),zi=n(Go),ao=r(Go,"P",{"data-svelte-h":!0}),s(ao)!=="svelte-1tyo99t"&&(ao.textContent=Kc),Go.forEach(l),Ii=n(C),ze=r(C,"DIV",{class:!0});var dl=_(ze);d(da.$$.fragment,dl),qi=n(dl),no=r(dl,"P",{"data-svelte-h":!0}),s(no)!=="svelte-4nmimv"&&(no.textContent=Wc),dl.forEach(l),Mi=n(C),Ie=r(C,"DIV",{class:!0});var cl=_(Ie);d(ca.$$.fragment,cl),Ei=n(cl),oo=r(cl,"P",{"data-svelte-h":!0}),s(oo)!=="svelte-ndgk7s"&&(oo.textContent=Gc),cl.forEach(l),Ri=n(C),qe=r(C,"DIV",{class:!0});var ml=_(qe);d(ma.$$.fragment,ml),Hi=n(ml),ro=r(ml,"P",{"data-svelte-h":!0}),s(ro)!=="svelte-18uwvbi"&&(ro.textContent=Bc),ml.forEach(l),Ui=n(C),Me=r(C,"DIV",{class:!0});var pl=_(Me);d(pa.$$.fragment,pl),Si=n(pl),lo=r(pl,"P",{"data-svelte-h":!0}),s(lo)!=="svelte-nqksfz"&&(lo.innerHTML=Yc),pl.forEach(l),Ai=n(C),Ee=r(C,"DIV",{class:!0});var gl=_(Ee);d(ga.$$.fragment,gl),Vi=n(gl),so=r(gl,"P",{"data-svelte-h":!0}),s(so)!=="svelte-y2dr0o"&&(so.textContent=Zc),gl.forEach(l),ji=n(C),q=r(C,"DIV",{class:!0});var Qe=_(q);d(_a.$$.fragment,Qe),Ki=n(Qe),io=r(Qe,"P",{"data-svelte-h":!0}),s(io)!=="svelte-xlsvih"&&(io.textContent=Jc),Wi=n(Qe),co=r(Qe,"P",{"data-svelte-h":!0}),s(co)!=="svelte-1mn1gnw"&&(co.textContent=Qc),Gi=n(Qe),mo=r(Qe,"P",{"data-svelte-h":!0}),s(mo)!=="svelte-1xvpyih"&&(mo.textContent=Xc),Qe.forEach(l),C.forEach(l),Tr=n(e),d(ha.$$.fragment,e),Or=n(e),ae=r(e,"DIV",{class:!0});var _l=_(ae);d(ua.$$.fragment,_l),Bi=n(_l),po=r(_l,"P",{"data-svelte-h":!0}),s(po)!=="svelte-aondqr"&&(po.textContent=em),_l.forEach(l),xr=n(e),d(fa.$$.fragment,e),$r=n(e),O=r(e,"DIV",{class:!0});var w=_(O);d(va.$$.fragment,w),Yi=n(w),go=r(w,"P",{"data-svelte-h":!0}),s(go)!=="svelte-hys9rl"&&(go.innerHTML=tm),Zi=n(w),Re=r(w,"DIV",{class:!0});var hl=_(Re);d(ba.$$.fragment,hl),Ji=n(hl),_o=r(hl,"P",{"data-svelte-h":!0}),s(_o)!=="svelte-185nst0"&&(_o.textContent=am),hl.forEach(l),Qi=n(w),He=r(w,"DIV",{class:!0});var ul=_(He);d(Ta.$$.fragment,ul),Xi=n(ul),ho=r(ul,"P",{"data-svelte-h":!0}),s(ho)!=="svelte-3nt516"&&(ho.textContent=nm),ul.forEach(l),ed=n(w),Ue=r(w,"DIV",{class:!0});var fl=_(Ue);d(Oa.$$.fragment,fl),td=n(fl),uo=r(fl,"P",{"data-svelte-h":!0}),s(uo)!=="svelte-3jfrz9"&&(uo.textContent=om),fl.forEach(l),ad=n(w),Se=r(w,"DIV",{class:!0});var vl=_(Se);d(xa.$$.fragment,vl),nd=n(vl),fo=r(vl,"P",{"data-svelte-h":!0}),s(fo)!=="svelte-lcc1u3"&&(fo.textContent=rm),vl.forEach(l),od=n(w),Ae=r(w,"DIV",{class:!0});var bl=_(Ae);d($a.$$.fragment,bl),rd=n(bl),vo=r(bl,"P",{"data-svelte-h":!0}),s(vo)!=="svelte-1gqqzmu"&&(vo.innerHTML=lm),bl.forEach(l),ld=n(w),Ve=r(w,"DIV",{class:!0});var Tl=_(Ve);d(Pa.$$.fragment,Tl),sd=n(Tl),bo=r(Tl,"P",{"data-svelte-h":!0}),s(bo)!=="svelte-ffqz5"&&(bo.textContent=sm),Tl.forEach(l),id=n(w),je=r(w,"DIV",{class:!0});var Ol=_(je);d(wa.$$.fragment,Ol),dd=n(Ol),To=r(Ol,"P",{"data-svelte-h":!0}),s(To)!=="svelte-febvhf"&&(To.textContent=im),Ol.forEach(l),cd=n(w),Ke=r(w,"DIV",{class:!0});var xl=_(Ke);d(ya.$$.fragment,xl),md=n(xl),Oo=r(xl,"P",{"data-svelte-h":!0}),s(Oo)!=="svelte-1hbodkw"&&(Oo.textContent=dm),xl.forEach(l),pd=n(w),We=r(w,"DIV",{class:!0});var $l=_(We);d(Ca.$$.fragment,$l),gd=n($l),xo=r($l,"P",{"data-svelte-h":!0}),s(xo)!=="svelte-1hfgx92"&&(xo.textContent=cm),$l.forEach(l),_d=n(w),Ge=r(w,"DIV",{class:!0});var Pl=_(Ge);d(ka.$$.fragment,Pl),hd=n(Pl),$o=r(Pl,"P",{"data-svelte-h":!0}),s($o)!=="svelte-yrsdu6"&&($o.textContent=mm),Pl.forEach(l),ud=n(w),Be=r(w,"DIV",{class:!0});var wl=_(Be);d(Da.$$.fragment,wl),fd=n(wl),Po=r(wl,"P",{"data-svelte-h":!0}),s(Po)!=="svelte-3k7k5e"&&(Po.textContent=pm),wl.forEach(l),w.forEach(l),Pr=n(e),d(Na.$$.fragment,e),wr=n(e),S=r(e,"DIV",{class:!0});var Bo=_(S);d(Fa.$$.fragment,Bo),vd=n(Bo),wo=r(Bo,"P",{"data-svelte-h":!0}),s(wo)!=="svelte-1fh32pr"&&(wo.innerHTML=gm),bd=n(Bo),yo=r(Bo,"P",{"data-svelte-h":!0}),s(yo)!=="svelte-1xl7jqc"&&(yo.innerHTML=_m),Bo.forEach(l),yr=n(e),d(La.$$.fragment,e),Cr=n(e),F=r(e,"DIV",{class:!0});var X=_(F);d(za.$$.fragment,X),Td=n(X),Co=r(X,"P",{"data-svelte-h":!0}),s(Co)!=="svelte-qafafj"&&(Co.innerHTML=hm),Od=n(X),ko=r(X,"P",{"data-svelte-h":!0}),s(ko)!=="svelte-bkmbwh"&&(ko.innerHTML=um),xd=n(X),Do=r(X,"UL",{"data-svelte-h":!0}),s(Do)!=="svelte-1ytuxgw"&&(Do.innerHTML=fm),$d=n(X),No=r(X,"P",{"data-svelte-h":!0}),s(No)!=="svelte-18tbp4c"&&(No.innerHTML=vm),X.forEach(l),kr=n(e),d(Ia.$$.fragment,e),Dr=n(e),ne=r(e,"DIV",{class:!0});var yl=_(ne);d(qa.$$.fragment,yl),Pd=n(yl),Fo=r(yl,"P",{"data-svelte-h":!0}),s(Fo)!=="svelte-14oyph8"&&(Fo.innerHTML=bm),yl.forEach(l),Nr=n(e),d(Ma.$$.fragment,e),Fr=n(e),oe=r(e,"DIV",{class:!0});var Cl=_(oe);d(Ea.$$.fragment,Cl),wd=n(Cl),Lo=r(Cl,"P",{"data-svelte-h":!0}),s(Lo)!=="svelte-1aeuhep"&&(Lo.innerHTML=Tm),Cl.forEach(l),Lr=n(e),Zo=r(e,"P",{}),_(Zo).forEach(l),this.h()},h(){h(ee,"name","hf:doc:metadata"),h(ee,"content",km),h(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,u){t(document.head,ee),v(e,Jo,u),v(e,Yo,u),v(e,Qo,u),c(Xe,e,u),v(e,Xo,u),v(e,et,u),v(e,er,u),c(tt,e,u),v(e,tr,u),v(e,E,u),c(at,E,null),t(E,kl),t(E,Ra),t(E,Dl),t(E,Ha),v(e,ar,u),c(nt,e,u),v(e,nr,u),v(e,x,u),c(ot,x,null),t(x,Nl),t(x,Ua),t(x,Fl),t(x,re),c(rt,re,null),t(re,Ll),t(re,Sa),t(x,zl),t(x,A),c(lt,A,null),t(A,Il),t(A,Aa),t(A,ql),t(A,Va),t(x,Ml),t(x,le),c(st,le,null),t(le,El),t(le,ja),t(x,Rl),t(x,se),c(it,se,null),t(se,Hl),t(se,Ka),t(x,Ul),t(x,V),c(dt,V,null),t(V,Sl),t(V,Wa),t(V,Al),t(V,Ga),t(x,Vl),t(x,ie),c(ct,ie,null),t(ie,jl),t(ie,Ba),t(x,Kl),t(x,de),c(mt,de,null),t(de,Wl),t(de,Ya),t(x,Gl),t(x,ce),c(pt,ce,null),t(ce,Bl),t(ce,Za),t(x,Yl),t(x,me),c(gt,me,null),t(me,Zl),t(me,Ja),t(x,Jl),t(x,L),c(_t,L,null),t(L,Ql),t(L,Qa),t(L,Xl),t(L,Xa),t(L,es),t(L,en),v(e,or,u),c(ht,e,u),v(e,rr,u),v(e,te,u),c(ut,te,null),t(te,ts),t(te,tn),v(e,lr,u),c(ft,e,u),v(e,sr,u),v(e,D,u),c(vt,D,null),t(D,as),t(D,an),t(D,ns),t(D,pe),c(bt,pe,null),t(pe,os),t(pe,nn),t(D,rs),t(D,ge),c(Tt,ge,null),t(ge,ls),t(ge,on),t(D,ss),t(D,z),c(Ot,z,null),t(z,is),t(z,rn),t(z,ds),t(z,ln),t(z,cs),t(z,sn),t(D,ms),t(D,_e),c(xt,_e,null),t(_e,ps),t(_e,dn),v(e,ir,u),c($t,e,u),v(e,dr,u),v(e,b,u),c(Pt,b,null),t(b,gs),t(b,cn),t(b,_s),t(b,he),c(wt,he,null),t(he,hs),t(he,mn),t(b,us),t(b,ue),c(yt,ue,null),t(ue,fs),t(ue,pn),t(b,vs),t(b,j),c(Ct,j,null),t(j,bs),t(j,gn),t(j,Ts),t(j,_n),t(b,Os),t(b,fe),c(kt,fe,null),t(fe,xs),t(fe,hn),t(b,$s),t(b,ve),c(Dt,ve,null),t(ve,Ps),t(ve,un),t(b,ws),t(b,K),c(Nt,K,null),t(K,ys),t(K,fn),t(K,Cs),t(K,vn),t(b,ks),t(b,be),c(Ft,be,null),t(be,Ds),t(be,bn),t(b,Ns),t(b,Te),c(Lt,Te,null),t(Te,Fs),t(Te,Tn),t(b,Ls),t(b,Oe),c(zt,Oe,null),t(Oe,zs),t(Oe,On),t(b,Is),t(b,W),c(It,W,null),t(W,qs),t(W,xn),t(W,Ms),t(W,$n),t(b,Es),t(b,G),c(qt,G,null),t(G,Rs),t(G,Pn),t(G,Hs),t(G,wn),t(b,Us),t(b,xe),c(Mt,xe,null),t(xe,Ss),t(xe,yn),t(b,As),t(b,$e),c(Et,$e,null),t($e,Vs),t($e,Cn),t(b,js),t(b,I),c(Rt,I,null),t(I,Ks),t(I,kn),t(I,Ws),t(I,Dn),t(I,Gs),t(I,Nn),v(e,cr,u),c(Ht,e,u),v(e,mr,u),v(e,R,u),c(Ut,R,null),t(R,Bs),t(R,Fn),t(R,Ys),t(R,Pe),c(St,Pe,null),t(Pe,Zs),t(Pe,Ln),v(e,pr,u),c(At,e,u),v(e,gr,u),v(e,H,u),c(Vt,H,null),t(H,Js),t(H,zn),t(H,Qs),t(H,In),v(e,_r,u),c(jt,e,u),v(e,hr,u),v(e,P,u),c(Kt,P,null),t(P,Xs),t(P,qn),t(P,ei),t(P,we),c(Wt,we,null),t(we,ti),t(we,Mn),t(P,ai),t(P,B),c(Gt,B,null),t(B,ni),t(B,En),t(B,oi),t(B,Rn),t(P,ri),t(P,ye),c(Bt,ye,null),t(ye,li),t(ye,Hn),t(P,si),t(P,Ce),c(Yt,Ce,null),t(Ce,ii),t(Ce,Un),t(P,di),t(P,ke),c(Zt,ke,null),t(ke,ci),t(ke,Sn),t(P,mi),t(P,Y),c(Jt,Y,null),t(Y,pi),t(Y,An),t(Y,gi),t(Y,Vn),t(P,_i),t(P,Z),c(Qt,Z,null),t(Z,hi),t(Z,jn),t(Z,ui),t(Z,Kn),t(P,fi),t(P,De),c(Xt,De,null),t(De,vi),t(De,Wn),t(P,bi),t(P,Ne),c(ea,Ne,null),t(Ne,Ti),t(Ne,Gn),v(e,ur,u),c(ta,e,u),v(e,fr,u),v(e,U,u),c(aa,U,null),t(U,Oi),t(U,Bn),t(U,xi),t(U,Yn),v(e,vr,u),c(na,e,u),v(e,br,u),v(e,$,u),c(oa,$,null),t($,$i),t($,Zn),t($,Pi),t($,Fe),c(ra,Fe,null),t(Fe,wi),t(Fe,Jn),t($,yi),t($,J),c(la,J,null),t(J,Ci),t(J,Qn),t(J,ki),t(J,Xn),t($,Di),t($,Le),c(sa,Le,null),t(Le,Ni),t(Le,eo),t($,Fi),t($,Q),c(ia,Q,null),t(Q,Li),t(Q,to),t(Q,zi),t(Q,ao),t($,Ii),t($,ze),c(da,ze,null),t(ze,qi),t(ze,no),t($,Mi),t($,Ie),c(ca,Ie,null),t(Ie,Ei),t(Ie,oo),t($,Ri),t($,qe),c(ma,qe,null),t(qe,Hi),t(qe,ro),t($,Ui),t($,Me),c(pa,Me,null),t(Me,Si),t(Me,lo),t($,Ai),t($,Ee),c(ga,Ee,null),t(Ee,Vi),t(Ee,so),t($,ji),t($,q),c(_a,q,null),t(q,Ki),t(q,io),t(q,Wi),t(q,co),t(q,Gi),t(q,mo),v(e,Tr,u),c(ha,e,u),v(e,Or,u),v(e,ae,u),c(ua,ae,null),t(ae,Bi),t(ae,po),v(e,xr,u),c(fa,e,u),v(e,$r,u),v(e,O,u),c(va,O,null),t(O,Yi),t(O,go),t(O,Zi),t(O,Re),c(ba,Re,null),t(Re,Ji),t(Re,_o),t(O,Qi),t(O,He),c(Ta,He,null),t(He,Xi),t(He,ho),t(O,ed),t(O,Ue),c(Oa,Ue,null),t(Ue,td),t(Ue,uo),t(O,ad),t(O,Se),c(xa,Se,null),t(Se,nd),t(Se,fo),t(O,od),t(O,Ae),c($a,Ae,null),t(Ae,rd),t(Ae,vo),t(O,ld),t(O,Ve),c(Pa,Ve,null),t(Ve,sd),t(Ve,bo),t(O,id),t(O,je),c(wa,je,null),t(je,dd),t(je,To),t(O,cd),t(O,Ke),c(ya,Ke,null),t(Ke,md),t(Ke,Oo),t(O,pd),t(O,We),c(Ca,We,null),t(We,gd),t(We,xo),t(O,_d),t(O,Ge),c(ka,Ge,null),t(Ge,hd),t(Ge,$o),t(O,ud),t(O,Be),c(Da,Be,null),t(Be,fd),t(Be,Po),v(e,Pr,u),c(Na,e,u),v(e,wr,u),v(e,S,u),c(Fa,S,null),t(S,vd),t(S,wo),t(S,bd),t(S,yo),v(e,yr,u),c(La,e,u),v(e,Cr,u),v(e,F,u),c(za,F,null),t(F,Td),t(F,Co),t(F,Od),t(F,ko),t(F,xd),t(F,Do),t(F,$d),t(F,No),v(e,kr,u),c(Ia,e,u),v(e,Dr,u),v(e,ne,u),c(qa,ne,null),t(ne,Pd),t(ne,Fo),v(e,Nr,u),c(Ma,e,u),v(e,Fr,u),v(e,oe,u),c(Ea,oe,null),t(oe,wd),t(oe,Lo),v(e,Lr,u),v(e,Zo,u),zr=!0},p:xm,i(e){zr||(m(Xe.$$.fragment,e),m(tt.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(ot.$$.fragment,e),m(rt.$$.fragment,e),m(lt.$$.fragment,e),m(st.$$.fragment,e),m(it.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(mt.$$.fragment,e),m(pt.$$.fragment,e),m(gt.$$.fragment,e),m(_t.$$.fragment,e),m(ht.$$.fragment,e),m(ut.$$.fragment,e),m(ft.$$.fragment,e),m(vt.$$.fragment,e),m(bt.$$.fragment,e),m(Tt.$$.fragment,e),m(Ot.$$.fragment,e),m(xt.$$.fragment,e),m($t.$$.fragment,e),m(Pt.$$.fragment,e),m(wt.$$.fragment,e),m(yt.$$.fragment,e),m(Ct.$$.fragment,e),m(kt.$$.fragment,e),m(Dt.$$.fragment,e),m(Nt.$$.fragment,e),m(Ft.$$.fragment,e),m(Lt.$$.fragment,e),m(zt.$$.fragment,e),m(It.$$.fragment,e),m(qt.$$.fragment,e),m(Mt.$$.fragment,e),m(Et.$$.fragment,e),m(Rt.$$.fragment,e),m(Ht.$$.fragment,e),m(Ut.$$.fragment,e),m(St.$$.fragment,e),m(At.$$.fragment,e),m(Vt.$$.fragment,e),m(jt.$$.fragment,e),m(Kt.$$.fragment,e),m(Wt.$$.fragment,e),m(Gt.$$.fragment,e),m(Bt.$$.fragment,e),m(Yt.$$.fragment,e),m(Zt.$$.fragment,e),m(Jt.$$.fragment,e),m(Qt.$$.fragment,e),m(Xt.$$.fragment,e),m(ea.$$.fragment,e),m(ta.$$.fragment,e),m(aa.$$.fragment,e),m(na.$$.fragment,e),m(oa.$$.fragment,e),m(ra.$$.fragment,e),m(la.$$.fragment,e),m(sa.$$.fragment,e),m(ia.$$.fragment,e),m(da.$$.fragment,e),m(ca.$$.fragment,e),m(ma.$$.fragment,e),m(pa.$$.fragment,e),m(ga.$$.fragment,e),m(_a.$$.fragment,e),m(ha.$$.fragment,e),m(ua.$$.fragment,e),m(fa.$$.fragment,e),m(va.$$.fragment,e),m(ba.$$.fragment,e),m(Ta.$$.fragment,e),m(Oa.$$.fragment,e),m(xa.$$.fragment,e),m($a.$$.fragment,e),m(Pa.$$.fragment,e),m(wa.$$.fragment,e),m(ya.$$.fragment,e),m(Ca.$$.fragment,e),m(ka.$$.fragment,e),m(Da.$$.fragment,e),m(Na.$$.fragment,e),m(Fa.$$.fragment,e),m(La.$$.fragment,e),m(za.$$.fragment,e),m(Ia.$$.fragment,e),m(qa.$$.fragment,e),m(Ma.$$.fragment,e),m(Ea.$$.fragment,e),zr=!0)},o(e){p(Xe.$$.fragment,e),p(tt.$$.fragment,e),p(at.$$.fragment,e),p(nt.$$.fragment,e),p(ot.$$.fragment,e),p(rt.$$.fragment,e),p(lt.$$.fragment,e),p(st.$$.fragment,e),p(it.$$.fragment,e),p(dt.$$.fragment,e),p(ct.$$.fragment,e),p(mt.$$.fragment,e),p(pt.$$.fragment,e),p(gt.$$.fragment,e),p(_t.$$.fragment,e),p(ht.$$.fragment,e),p(ut.$$.fragment,e),p(ft.$$.fragment,e),p(vt.$$.fragment,e),p(bt.$$.fragment,e),p(Tt.$$.fragment,e),p(Ot.$$.fragment,e),p(xt.$$.fragment,e),p($t.$$.fragment,e),p(Pt.$$.fragment,e),p(wt.$$.fragment,e),p(yt.$$.fragment,e),p(Ct.$$.fragment,e),p(kt.$$.fragment,e),p(Dt.$$.fragment,e),p(Nt.$$.fragment,e),p(Ft.$$.fragment,e),p(Lt.$$.fragment,e),p(zt.$$.fragment,e),p(It.$$.fragment,e),p(qt.$$.fragment,e),p(Mt.$$.fragment,e),p(Et.$$.fragment,e),p(Rt.$$.fragment,e),p(Ht.$$.fragment,e),p(Ut.$$.fragment,e),p(St.$$.fragment,e),p(At.$$.fragment,e),p(Vt.$$.fragment,e),p(jt.$$.fragment,e),p(Kt.$$.fragment,e),p(Wt.$$.fragment,e),p(Gt.$$.fragment,e),p(Bt.$$.fragment,e),p(Yt.$$.fragment,e),p(Zt.$$.fragment,e),p(Jt.$$.fragment,e),p(Qt.$$.fragment,e),p(Xt.$$.fragment,e),p(ea.$$.fragment,e),p(ta.$$.fragment,e),p(aa.$$.fragment,e),p(na.$$.fragment,e),p(oa.$$.fragment,e),p(ra.$$.fragment,e),p(la.$$.fragment,e),p(sa.$$.fragment,e),p(ia.$$.fragment,e),p(da.$$.fragment,e),p(ca.$$.fragment,e),p(ma.$$.fragment,e),p(pa.$$.fragment,e),p(ga.$$.fragment,e),p(_a.$$.fragment,e),p(ha.$$.fragment,e),p(ua.$$.fragment,e),p(fa.$$.fragment,e),p(va.$$.fragment,e),p(ba.$$.fragment,e),p(Ta.$$.fragment,e),p(Oa.$$.fragment,e),p(xa.$$.fragment,e),p($a.$$.fragment,e),p(Pa.$$.fragment,e),p(wa.$$.fragment,e),p(ya.$$.fragment,e),p(Ca.$$.fragment,e),p(ka.$$.fragment,e),p(Da.$$.fragment,e),p(Na.$$.fragment,e),p(Fa.$$.fragment,e),p(La.$$.fragment,e),p(za.$$.fragment,e),p(Ia.$$.fragment,e),p(qa.$$.fragment,e),p(Ma.$$.fragment,e),p(Ea.$$.fragment,e),zr=!1},d(e){e&&(l(Jo),l(Yo),l(Qo),l(Xo),l(et),l(er),l(tr),l(E),l(ar),l(nr),l(x),l(or),l(rr),l(te),l(lr),l(sr),l(D),l(ir),l(dr),l(b),l(cr),l(mr),l(R),l(pr),l(gr),l(H),l(_r),l(hr),l(P),l(ur),l(fr),l(U),l(vr),l(br),l($),l(Tr),l(Or),l(ae),l(xr),l($r),l(O),l(Pr),l(wr),l(S),l(yr),l(Cr),l(F),l(kr),l(Dr),l(ne),l(Nr),l(Fr),l(oe),l(Lr),l(Zo)),l(ee),g(Xe,e),g(tt,e),g(at),g(nt,e),g(ot),g(rt),g(lt),g(st),g(it),g(dt),g(ct),g(mt),g(pt),g(gt),g(_t),g(ht,e),g(ut),g(ft,e),g(vt),g(bt),g(Tt),g(Ot),g(xt),g($t,e),g(Pt),g(wt),g(yt),g(Ct),g(kt),g(Dt),g(Nt),g(Ft),g(Lt),g(zt),g(It),g(qt),g(Mt),g(Et),g(Rt),g(Ht,e),g(Ut),g(St),g(At,e),g(Vt),g(jt,e),g(Kt),g(Wt),g(Gt),g(Bt),g(Yt),g(Zt),g(Jt),g(Qt),g(Xt),g(ea),g(ta,e),g(aa),g(na,e),g(oa),g(ra),g(la),g(sa),g(ia),g(da),g(ca),g(ma),g(pa),g(ga),g(_a),g(ha,e),g(ua),g(fa,e),g(va),g(ba),g(Ta),g(Oa),g(xa),g($a),g(Pa),g(wa),g(ya),g(Ca),g(ka),g(Da),g(Na,e),g(Fa),g(La,e),g(za),g(Ia,e),g(qa),g(Ma,e),g(Ea)}}}const km='{"title":"Trainer","local":"trainer","sections":[{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"IterativeSFTTrainer","local":"trl.IterativeSFTTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"ORPOConfig","local":"trl.ORPOConfig","sections":[],"depth":2},{"title":"ORPOTrainer","local":"trl.ORPOTrainer","sections":[],"depth":2},{"title":"PPOConfig","local":"trl.PPOConfig","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"set_seed","local":"trl.set_seed","sections":[],"depth":2}],"depth":1}';function Dm(yd){return $m(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Im extends Pm{constructor(ee){super(),wm(this,ee,Dm,Cm,Om,{})}}export{Im as component};
