import{s as Ue,n as Ce,o as Ie}from"../chunks/scheduler.85c25b89.js";import{S as Ne,i as Ee,g as a,s as i,u as c,A as Ze,h as n,f as e,c as o,j as h,v as d,y as m,k as p,o as r,a as l,w as f,d as u,t as g,x as w}from"../chunks/index.9633332f.js";import{I as dt}from"../chunks/IconCopyLink.a4acffac.js";import{C as nt}from"../chunks/CodeBlock.00597c71.js";function _e(Kt){let M,ft,it,ut,j,v,ot,C,Ft,tt,Ot="(Tensorflow) EfficientNet Lite",gt,I,te="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",wt,N,ee="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",Mt,E,se='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>.',jt,Z,le='EfficientNet-Lite makes EfficientNet more suitable for mobile devices by introducing <a href="https://paperswithcode.com/method/relu6" rel="nofollow">ReLU6</a> activation functions and removing <a href="https://paperswithcode.com/method/squeeze-and-excitation" rel="nofollow">squeeze-and-excitation blocks</a>.',yt,_,ae='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',Jt,y,x,pt,B,Lt,et,ne="How do I use this model on an image?",bt,W,ie="To load a pretrained model:",Tt,G,vt,A,oe="To load and preprocess the image:",xt,R,kt,Q,pe="To get the model predictions:",$t,V,Ut,X,re="To get the top-5 predictions class names:",Ct,S,It,H,me="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_lite0</code>. You can find the IDs in the model summaries at the top of this page.",Nt,Y,he='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Et,J,k,rt,z,Pt,st,ce="How do I finetune this model?",Zt,F,de="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",_t,L,Bt,P,fe=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Wt,b,$,mt,q,qt,lt,ue="How do I train this model?",Gt,D,ge='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',At,T,U,ht,K,Dt,at,we="Citation",Rt,O,Qt,ct,Vt;return C=new dt({}),B=new dt({}),G=new nt({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9saXRlMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_lite0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),R=new nt({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),V=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),S=new nt({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),z=new dt({}),L=new nt({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2xpdGUwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_lite0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),q=new dt({}),K=new dt({}),O=new nt({props:{code:"JTQwbWlzYyU3QnRhbjIwMjBlZmZpY2llbnRuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkVmZmljaWVudE5ldCUzQSUyMFJldGhpbmtpbmclMjBNb2RlbCUyMFNjYWxpbmclMjBmb3IlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA1LjExOTQ2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2020efficientnet,
      title={EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1905.11946}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`}}),{c(){M=a("meta"),ft=i(),it=a("p"),ut=i(),j=a("h1"),v=a("a"),ot=a("span"),c(C.$$.fragment),Ft=i(),tt=a("span"),tt.textContent=Ot,gt=i(),I=a("p"),I.innerHTML=te,wt=i(),N=a("p"),N.textContent=ee,Mt=i(),E=a("p"),E.innerHTML=se,jt=i(),Z=a("p"),Z.innerHTML=le,yt=i(),_=a("p"),_.innerHTML=ae,Jt=i(),y=a("h2"),x=a("a"),pt=a("span"),c(B.$$.fragment),Lt=i(),et=a("span"),et.textContent=ne,bt=i(),W=a("p"),W.textContent=ie,Tt=i(),c(G.$$.fragment),vt=i(),A=a("p"),A.textContent=oe,xt=i(),c(R.$$.fragment),kt=i(),Q=a("p"),Q.textContent=pe,$t=i(),c(V.$$.fragment),Ut=i(),X=a("p"),X.textContent=re,Ct=i(),c(S.$$.fragment),It=i(),H=a("p"),H.innerHTML=me,Nt=i(),Y=a("p"),Y.innerHTML=he,Et=i(),J=a("h2"),k=a("a"),rt=a("span"),c(z.$$.fragment),Pt=i(),st=a("span"),st.textContent=ce,Zt=i(),F=a("p"),F.textContent=de,_t=i(),c(L.$$.fragment),Bt=i(),P=a("p"),P.innerHTML=fe,Wt=i(),b=a("h2"),$=a("a"),mt=a("span"),c(q.$$.fragment),qt=i(),lt=a("span"),lt.textContent=ue,Gt=i(),D=a("p"),D.innerHTML=ge,At=i(),T=a("h2"),U=a("a"),ht=a("span"),c(K.$$.fragment),Dt=i(),at=a("span"),at.textContent=we,Rt=i(),c(O.$$.fragment),Qt=i(),ct=a("p"),this.h()},l(t){const s=Ze("svelte-1phssyn",document.head);M=n(s,"META",{name:!0,content:!0}),s.forEach(e),ft=o(t),it=n(t,"P",{}),h(it).forEach(e),ut=o(t),j=n(t,"H1",{class:!0});var Xt=h(j);v=n(Xt,"A",{id:!0,class:!0,href:!0});var Me=h(v);ot=n(Me,"SPAN",{});var je=h(ot);d(C.$$.fragment,je),je.forEach(e),Me.forEach(e),Ft=o(Xt),tt=n(Xt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1k6vp2n"&&(tt.textContent=Ot),Xt.forEach(e),gt=o(t),I=n(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1bwkfja"&&(I.innerHTML=te),wt=o(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-5z334a"&&(N.textContent=ee),Mt=o(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1ctfbzq"&&(E.innerHTML=se),jt=o(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1iy4wlm"&&(Z.innerHTML=le),yt=o(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-k8hpf1"&&(_.innerHTML=ae),Jt=o(t),y=n(t,"H2",{class:!0});var St=h(y);x=n(St,"A",{id:!0,class:!0,href:!0});var ye=h(x);pt=n(ye,"SPAN",{});var Je=h(pt);d(B.$$.fragment,Je),Je.forEach(e),ye.forEach(e),Lt=o(St),et=n(St,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-1c1hspn"&&(et.textContent=ne),St.forEach(e),bt=o(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-18ywhxh"&&(W.textContent=ie),Tt=o(t),d(G.$$.fragment,t),vt=o(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1c2ipa8"&&(A.textContent=oe),xt=o(t),d(R.$$.fragment,t),kt=o(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1n9qsq1"&&(Q.textContent=pe),$t=o(t),d(V.$$.fragment,t),Ut=o(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-19cnvx1"&&(X.textContent=re),Ct=o(t),d(S.$$.fragment,t),It=o(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1w44yho"&&(H.innerHTML=me),Nt=o(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1wmi3ea"&&(Y.innerHTML=he),Et=o(t),J=n(t,"H2",{class:!0});var Ht=h(J);k=n(Ht,"A",{id:!0,class:!0,href:!0});var be=h(k);rt=n(be,"SPAN",{});var Te=h(rt);d(z.$$.fragment,Te),Te.forEach(e),be.forEach(e),Pt=o(Ht),st=n(Ht,"SPAN",{"data-svelte-h":!0}),m(st)!=="svelte-1viv4qv"&&(st.textContent=ce),Ht.forEach(e),Zt=o(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-9sr7nh"&&(F.textContent=de),_t=o(t),d(L.$$.fragment,t),Bt=o(t),P=n(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1kguc51"&&(P.innerHTML=fe),Wt=o(t),b=n(t,"H2",{class:!0});var Yt=h(b);$=n(Yt,"A",{id:!0,class:!0,href:!0});var ve=h($);mt=n(ve,"SPAN",{});var xe=h(mt);d(q.$$.fragment,xe),xe.forEach(e),ve.forEach(e),qt=o(Yt),lt=n(Yt,"SPAN",{"data-svelte-h":!0}),m(lt)!=="svelte-1ce591d"&&(lt.textContent=ue),Yt.forEach(e),Gt=o(t),D=n(t,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1n0coha"&&(D.innerHTML=ge),At=o(t),T=n(t,"H2",{class:!0});var zt=h(T);U=n(zt,"A",{id:!0,class:!0,href:!0});var ke=h(U);ht=n(ke,"SPAN",{});var $e=h(ht);d(K.$$.fragment,$e),$e.forEach(e),ke.forEach(e),Dt=o(zt),at=n(zt,"SPAN",{"data-svelte-h":!0}),m(at)!=="svelte-15mb3gy"&&(at.textContent=we),zt.forEach(e),Rt=o(t),d(O.$$.fragment,t),Qt=o(t),ct=n(t,"P",{}),h(ct).forEach(e),this.h()},h(){p(M,"name","hf:doc:metadata"),p(M,"content",JSON.stringify(Be)),p(v,"id","tensorflow-efficientnet-lite"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#tensorflow-efficientnet-lite"),p(j,"class","relative group"),p(x,"id","how-do-i-use-this-model-on-an-image"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#how-do-i-use-this-model-on-an-image"),p(y,"class","relative group"),p(k,"id","how-do-i-finetune-this-model"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#how-do-i-finetune-this-model"),p(J,"class","relative group"),p($,"id","how-do-i-train-this-model"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#how-do-i-train-this-model"),p(b,"class","relative group"),p(U,"id","citation"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#citation"),p(T,"class","relative group")},m(t,s){r(document.head,M),l(t,ft,s),l(t,it,s),l(t,ut,s),l(t,j,s),r(j,v),r(v,ot),f(C,ot,null),r(j,Ft),r(j,tt),l(t,gt,s),l(t,I,s),l(t,wt,s),l(t,N,s),l(t,Mt,s),l(t,E,s),l(t,jt,s),l(t,Z,s),l(t,yt,s),l(t,_,s),l(t,Jt,s),l(t,y,s),r(y,x),r(x,pt),f(B,pt,null),r(y,Lt),r(y,et),l(t,bt,s),l(t,W,s),l(t,Tt,s),f(G,t,s),l(t,vt,s),l(t,A,s),l(t,xt,s),f(R,t,s),l(t,kt,s),l(t,Q,s),l(t,$t,s),f(V,t,s),l(t,Ut,s),l(t,X,s),l(t,Ct,s),f(S,t,s),l(t,It,s),l(t,H,s),l(t,Nt,s),l(t,Y,s),l(t,Et,s),l(t,J,s),r(J,k),r(k,rt),f(z,rt,null),r(J,Pt),r(J,st),l(t,Zt,s),l(t,F,s),l(t,_t,s),f(L,t,s),l(t,Bt,s),l(t,P,s),l(t,Wt,s),l(t,b,s),r(b,$),r($,mt),f(q,mt,null),r(b,qt),r(b,lt),l(t,Gt,s),l(t,D,s),l(t,At,s),l(t,T,s),r(T,U),r(U,ht),f(K,ht,null),r(T,Dt),r(T,at),l(t,Rt,s),f(O,t,s),l(t,Qt,s),l(t,ct,s),Vt=!0},p:Ce,i(t){Vt||(u(C.$$.fragment,t),u(B.$$.fragment,t),u(G.$$.fragment,t),u(R.$$.fragment,t),u(V.$$.fragment,t),u(S.$$.fragment,t),u(z.$$.fragment,t),u(L.$$.fragment,t),u(q.$$.fragment,t),u(K.$$.fragment,t),u(O.$$.fragment,t),Vt=!0)},o(t){g(C.$$.fragment,t),g(B.$$.fragment,t),g(G.$$.fragment,t),g(R.$$.fragment,t),g(V.$$.fragment,t),g(S.$$.fragment,t),g(z.$$.fragment,t),g(L.$$.fragment,t),g(q.$$.fragment,t),g(K.$$.fragment,t),g(O.$$.fragment,t),Vt=!1},d(t){t&&(e(ft),e(it),e(ut),e(j),e(gt),e(I),e(wt),e(N),e(Mt),e(E),e(jt),e(Z),e(yt),e(_),e(Jt),e(y),e(bt),e(W),e(Tt),e(vt),e(A),e(xt),e(kt),e(Q),e($t),e(Ut),e(X),e(Ct),e(It),e(H),e(Nt),e(Y),e(Et),e(J),e(Zt),e(F),e(_t),e(Bt),e(P),e(Wt),e(b),e(Gt),e(D),e(At),e(T),e(Rt),e(Qt),e(ct)),e(M),w(C),w(B),w(G,t),w(R,t),w(V,t),w(S,t),w(z),w(L,t),w(q),w(K),w(O,t)}}}const Be={local:"tensorflow-efficientnet-lite",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"(Tensorflow) EfficientNet Lite"};function We(Kt){return Ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends Ne{constructor(M){super(),Ee(this,M,We,_e,Ue,{})}}export{Ve as component};
