import{s as Ie,n as xe,o as Ne}from"../chunks/scheduler.85c25b89.js";import{S as $e,i as Ee,g as a,s as i,u as c,A as Be,h as n,f as e,c as o,j as h,v as M,y as m,k as p,o as r,a as l,w as d,d as y,t as w,x as u}from"../chunks/index.9633332f.js";import{I as Mt}from"../chunks/IconCopyLink.a4acffac.js";import{C as nt}from"../chunks/CodeBlock.00597c71.js";function _e(Kt){let f,dt,it,yt,J,U,ot,x,Ft,tt,Ot="(Tensorflow) EfficientNet CondConv",wt,N,te="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",ut,$,ee="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",ft,E,se='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>, in addition to squeeze-and-excitation blocks.',Jt,B,le='This collection of models amends EfficientNet by adding <a href="https://paperswithcode.com/method/condconv" rel="nofollow">CondConv</a> convolutions.',jt,_,ae='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',gt,j,C,pt,Z,Lt,et,ne="How do I use this model on an image?",Tt,W,ie="To load a pretrained model:",bt,A,Ut,R,oe="To load and preprocess the image:",Ct,Q,vt,G,pe="To get the model predictions:",kt,Y,It,S,re="To get the top-5 predictions class names:",xt,X,Nt,V,me="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_cc_b0_4e</code>. You can find the IDs in the model summaries at the top of this page.",$t,H,he='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Et,g,v,rt,z,Pt,st,ce="How do I finetune this model?",Bt,F,Me="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",_t,L,Zt,P,de=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Wt,T,k,mt,D,Dt,lt,ye="How do I train this model?",At,q,we='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Rt,b,I,ht,K,qt,at,ue="Citation",Qt,O,Gt,ct,Yt;return x=new Mt({}),Z=new Mt({}),A=new nt({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9jY19iMF80ZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_cc_b0_4e&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),Q=new nt({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),Y=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),X=new nt({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),z=new Mt({}),L=new nt({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2NjX2IwXzRlJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_cc_b0_4e&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),D=new Mt({}),K=new Mt({}),O=new nt({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNC0wNDk3MSUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkJyYW5kb24lMjBZYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR2FicmllbCUyMEJlbmRlciUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFF1b2MlMjBWLiUyMExlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSmlxdWFuJTIwTmdpYW0lN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QlNvZnQlMjBDb25kaXRpb25hbCUyMENvbXB1dGF0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA0LjA0OTcxJTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNC4wNDk3MSU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDQuMDQ5NzElN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JUaHUlMkMlMjAyNSUyMEFwciUyMDIwMTklMjAxMyUzQTU1JTNBMDElMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA0LTA0OTcxLmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1904</span>-<span class="hljs-number">04971</span>,
  author    = {Brandon Yang and
               Gabriel Bender and
               Quoc V. Le and
               Jiquan Ngiam},
  title     = {Soft Conditional Computation},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1904.04971</span>},
  year      = {<span class="hljs-number">2019</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1904.04971</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1904.04971</span>},
  timestamp = {Thu, <span class="hljs-number">25</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">13</span>:<span class="hljs-number">55</span>:<span class="hljs-number">01</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1904</span>-<span class="hljs-number">04971</span>.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`}}),{c(){f=a("meta"),dt=i(),it=a("p"),yt=i(),J=a("h1"),U=a("a"),ot=a("span"),c(x.$$.fragment),Ft=i(),tt=a("span"),tt.textContent=Ot,wt=i(),N=a("p"),N.innerHTML=te,ut=i(),$=a("p"),$.textContent=ee,ft=i(),E=a("p"),E.innerHTML=se,Jt=i(),B=a("p"),B.innerHTML=le,jt=i(),_=a("p"),_.innerHTML=ae,gt=i(),j=a("h2"),C=a("a"),pt=a("span"),c(Z.$$.fragment),Lt=i(),et=a("span"),et.textContent=ne,Tt=i(),W=a("p"),W.textContent=ie,bt=i(),c(A.$$.fragment),Ut=i(),R=a("p"),R.textContent=oe,Ct=i(),c(Q.$$.fragment),vt=i(),G=a("p"),G.textContent=pe,kt=i(),c(Y.$$.fragment),It=i(),S=a("p"),S.textContent=re,xt=i(),c(X.$$.fragment),Nt=i(),V=a("p"),V.innerHTML=me,$t=i(),H=a("p"),H.innerHTML=he,Et=i(),g=a("h2"),v=a("a"),rt=a("span"),c(z.$$.fragment),Pt=i(),st=a("span"),st.textContent=ce,Bt=i(),F=a("p"),F.textContent=Me,_t=i(),c(L.$$.fragment),Zt=i(),P=a("p"),P.innerHTML=de,Wt=i(),T=a("h2"),k=a("a"),mt=a("span"),c(D.$$.fragment),Dt=i(),lt=a("span"),lt.textContent=ye,At=i(),q=a("p"),q.innerHTML=we,Rt=i(),b=a("h2"),I=a("a"),ht=a("span"),c(K.$$.fragment),qt=i(),at=a("span"),at.textContent=ue,Qt=i(),c(O.$$.fragment),Gt=i(),ct=a("p"),this.h()},l(t){const s=Be("svelte-1phssyn",document.head);f=n(s,"META",{name:!0,content:!0}),s.forEach(e),dt=o(t),it=n(t,"P",{}),h(it).forEach(e),yt=o(t),J=n(t,"H1",{class:!0});var St=h(J);U=n(St,"A",{id:!0,class:!0,href:!0});var fe=h(U);ot=n(fe,"SPAN",{});var Je=h(ot);M(x.$$.fragment,Je),Je.forEach(e),fe.forEach(e),Ft=o(St),tt=n(St,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-74ubnl"&&(tt.textContent=Ot),St.forEach(e),wt=o(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1bwkfja"&&(N.innerHTML=te),ut=o(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-5z334a"&&($.textContent=ee),ft=o(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1lb2xzv"&&(E.innerHTML=se),Jt=o(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1gcdgqy"&&(B.innerHTML=le),jt=o(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-k8hpf1"&&(_.innerHTML=ae),gt=o(t),j=n(t,"H2",{class:!0});var Xt=h(j);C=n(Xt,"A",{id:!0,class:!0,href:!0});var je=h(C);pt=n(je,"SPAN",{});var ge=h(pt);M(Z.$$.fragment,ge),ge.forEach(e),je.forEach(e),Lt=o(Xt),et=n(Xt,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-1c1hspn"&&(et.textContent=ne),Xt.forEach(e),Tt=o(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-18ywhxh"&&(W.textContent=ie),bt=o(t),M(A.$$.fragment,t),Ut=o(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1c2ipa8"&&(R.textContent=oe),Ct=o(t),M(Q.$$.fragment,t),vt=o(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=pe),kt=o(t),M(Y.$$.fragment,t),It=o(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-19cnvx1"&&(S.textContent=re),xt=o(t),M(X.$$.fragment,t),Nt=o(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1ez17et"&&(V.innerHTML=me),$t=o(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1wmi3ea"&&(H.innerHTML=he),Et=o(t),g=n(t,"H2",{class:!0});var Vt=h(g);v=n(Vt,"A",{id:!0,class:!0,href:!0});var Te=h(v);rt=n(Te,"SPAN",{});var be=h(rt);M(z.$$.fragment,be),be.forEach(e),Te.forEach(e),Pt=o(Vt),st=n(Vt,"SPAN",{"data-svelte-h":!0}),m(st)!=="svelte-1viv4qv"&&(st.textContent=ce),Vt.forEach(e),Bt=o(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-9sr7nh"&&(F.textContent=Me),_t=o(t),M(L.$$.fragment,t),Zt=o(t),P=n(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1kguc51"&&(P.innerHTML=de),Wt=o(t),T=n(t,"H2",{class:!0});var Ht=h(T);k=n(Ht,"A",{id:!0,class:!0,href:!0});var Ue=h(k);mt=n(Ue,"SPAN",{});var Ce=h(mt);M(D.$$.fragment,Ce),Ce.forEach(e),Ue.forEach(e),Dt=o(Ht),lt=n(Ht,"SPAN",{"data-svelte-h":!0}),m(lt)!=="svelte-1ce591d"&&(lt.textContent=ye),Ht.forEach(e),At=o(t),q=n(t,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1n0coha"&&(q.innerHTML=we),Rt=o(t),b=n(t,"H2",{class:!0});var zt=h(b);I=n(zt,"A",{id:!0,class:!0,href:!0});var ve=h(I);ht=n(ve,"SPAN",{});var ke=h(ht);M(K.$$.fragment,ke),ke.forEach(e),ve.forEach(e),qt=o(zt),at=n(zt,"SPAN",{"data-svelte-h":!0}),m(at)!=="svelte-15mb3gy"&&(at.textContent=ue),zt.forEach(e),Qt=o(t),M(O.$$.fragment,t),Gt=o(t),ct=n(t,"P",{}),h(ct).forEach(e),this.h()},h(){p(f,"name","hf:doc:metadata"),p(f,"content",JSON.stringify(Ze)),p(U,"id","tensorflow-efficientnet-condconv"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#tensorflow-efficientnet-condconv"),p(J,"class","relative group"),p(C,"id","how-do-i-use-this-model-on-an-image"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#how-do-i-use-this-model-on-an-image"),p(j,"class","relative group"),p(v,"id","how-do-i-finetune-this-model"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#how-do-i-finetune-this-model"),p(g,"class","relative group"),p(k,"id","how-do-i-train-this-model"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#how-do-i-train-this-model"),p(T,"class","relative group"),p(I,"id","citation"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#citation"),p(b,"class","relative group")},m(t,s){r(document.head,f),l(t,dt,s),l(t,it,s),l(t,yt,s),l(t,J,s),r(J,U),r(U,ot),d(x,ot,null),r(J,Ft),r(J,tt),l(t,wt,s),l(t,N,s),l(t,ut,s),l(t,$,s),l(t,ft,s),l(t,E,s),l(t,Jt,s),l(t,B,s),l(t,jt,s),l(t,_,s),l(t,gt,s),l(t,j,s),r(j,C),r(C,pt),d(Z,pt,null),r(j,Lt),r(j,et),l(t,Tt,s),l(t,W,s),l(t,bt,s),d(A,t,s),l(t,Ut,s),l(t,R,s),l(t,Ct,s),d(Q,t,s),l(t,vt,s),l(t,G,s),l(t,kt,s),d(Y,t,s),l(t,It,s),l(t,S,s),l(t,xt,s),d(X,t,s),l(t,Nt,s),l(t,V,s),l(t,$t,s),l(t,H,s),l(t,Et,s),l(t,g,s),r(g,v),r(v,rt),d(z,rt,null),r(g,Pt),r(g,st),l(t,Bt,s),l(t,F,s),l(t,_t,s),d(L,t,s),l(t,Zt,s),l(t,P,s),l(t,Wt,s),l(t,T,s),r(T,k),r(k,mt),d(D,mt,null),r(T,Dt),r(T,lt),l(t,At,s),l(t,q,s),l(t,Rt,s),l(t,b,s),r(b,I),r(I,ht),d(K,ht,null),r(b,qt),r(b,at),l(t,Qt,s),d(O,t,s),l(t,Gt,s),l(t,ct,s),Yt=!0},p:xe,i(t){Yt||(y(x.$$.fragment,t),y(Z.$$.fragment,t),y(A.$$.fragment,t),y(Q.$$.fragment,t),y(Y.$$.fragment,t),y(X.$$.fragment,t),y(z.$$.fragment,t),y(L.$$.fragment,t),y(D.$$.fragment,t),y(K.$$.fragment,t),y(O.$$.fragment,t),Yt=!0)},o(t){w(x.$$.fragment,t),w(Z.$$.fragment,t),w(A.$$.fragment,t),w(Q.$$.fragment,t),w(Y.$$.fragment,t),w(X.$$.fragment,t),w(z.$$.fragment,t),w(L.$$.fragment,t),w(D.$$.fragment,t),w(K.$$.fragment,t),w(O.$$.fragment,t),Yt=!1},d(t){t&&(e(dt),e(it),e(yt),e(J),e(wt),e(N),e(ut),e($),e(ft),e(E),e(Jt),e(B),e(jt),e(_),e(gt),e(j),e(Tt),e(W),e(bt),e(Ut),e(R),e(Ct),e(vt),e(G),e(kt),e(It),e(S),e(xt),e(Nt),e(V),e($t),e(H),e(Et),e(g),e(Bt),e(F),e(_t),e(Zt),e(P),e(Wt),e(T),e(At),e(q),e(Rt),e(b),e(Qt),e(Gt),e(ct)),e(f),u(x),u(Z),u(A,t),u(Q,t),u(Y,t),u(X,t),u(z),u(L,t),u(D),u(K),u(O,t)}}}const Ze={local:"tensorflow-efficientnet-condconv",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"(Tensorflow) EfficientNet CondConv"};function We(Kt){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ye extends $e{constructor(f){super(),Ee(this,f,We,_e,Ie,{})}}export{Ye as component};
