import{s as Ie,n as xe,o as ke}from"../chunks/scheduler.85c25b89.js";import{S as $e,i as Ne,g as l,s as i,u as c,A as Ee,h as n,f as e,c as p,j as h,v as d,y as m,k as o,o as r,a as s,w as u,d as M,t as g,x as w}from"../chunks/index.9633332f.js";import{I as dt}from"../chunks/IconCopyLink.a4acffac.js";import{C as tt}from"../chunks/CodeBlock.00597c71.js";function Ze(Kt){let y,ut,it,Mt,f,v,pt,k,Ht,et,Ot="EfficientNet (Knapsack Pruned)",gt,$,te="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",wt,N,ee="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",yt,E,ae='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>, in addition to <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a>.',ft,Z,se="This collection consists of pruned EfficientNet models.",Jt,J,U,ot,W,Pt,at,le="How do I use this model on an image?",jt,B,ne="To load a pretrained model:",Tt,G,bt,_,ie="To load and preprocess the image:",vt,Q,Ut,A,pe="To get the model predictions:",Ct,V,It,R,oe="To get the top-5 predictions class names:",xt,X,kt,S,re="Replace the model name with the variant you want to use, e.g. <code>efficientnet_b1_pruned</code>. You can find the IDs in the model summaries at the top of this page.",$t,F,me='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Nt,j,C,rt,Y,Lt,st,he="How do I finetune this model?",Et,z,ce="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Zt,H,Wt,P,de=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Bt,T,I,mt,L,Dt,lt,ue="How do I train this model?",Gt,D,Me='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',_t,b,x,ht,q,qt,nt,ge="Citation",Qt,K,At,O,Vt,ct,Rt;return k=new dt({}),W=new dt({}),G=new tt({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VmZmljaWVudG5ldF9iMV9wcnVuZWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;efficientnet_b1_pruned&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),Q=new tt({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),V=new tt({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),X=new tt({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),Y=new dt({}),H=new tt({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZWZmaWNpZW50bmV0X2IxX3BydW5lZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;efficientnet_b1_pruned&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),L=new dt({}),q=new dt({}),K=new tt({props:{code:"JTQwbWlzYyU3QnRhbjIwMjBlZmZpY2llbnRuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkVmZmljaWVudE5ldCUzQSUyMFJldGhpbmtpbmclMjBNb2RlbCUyMFNjYWxpbmclMjBmb3IlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA1LjExOTQ2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2020efficientnet,
      title={EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1905.11946}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`}}),O=new tt({props:{code:"JTQwbWlzYyU3QmFmbGFsbzIwMjBrbmFwc2FjayUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCS25hcHNhY2slMjBQcnVuaW5nJTIwd2l0aCUyMElubmVyJTIwRGlzdGlsbGF0aW9uJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCWW9uYXRoYW4lMjBBZmxhbG8lMjBhbmQlMjBBc2FmJTIwTm95JTIwYW5kJTIwTWluZyUyMExpbiUyMGFuZCUyMEl0YW1hciUyMEZyaWVkbWFuJTIwYW5kJTIwTGloaSUyMFplbG5payU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMjAwMi4wODI1OCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkxHJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{aflalo2020knapsack,
      title={Knapsack Pruning with Inner Distillation}</span><span class="language-xml">,
      author=</span><span class="hljs-template-variable">{Yonathan Aflalo and Asaf Noy and Ming Lin and Itamar Friedman and Lihi Zelnik}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2002.08258}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`}}),{c(){y=l("meta"),ut=i(),it=l("p"),Mt=i(),f=l("h1"),v=l("a"),pt=l("span"),c(k.$$.fragment),Ht=i(),et=l("span"),et.textContent=Ot,gt=i(),$=l("p"),$.innerHTML=te,wt=i(),N=l("p"),N.textContent=ee,yt=i(),E=l("p"),E.innerHTML=ae,ft=i(),Z=l("p"),Z.textContent=se,Jt=i(),J=l("h2"),U=l("a"),ot=l("span"),c(W.$$.fragment),Pt=i(),at=l("span"),at.textContent=le,jt=i(),B=l("p"),B.textContent=ne,Tt=i(),c(G.$$.fragment),bt=i(),_=l("p"),_.textContent=ie,vt=i(),c(Q.$$.fragment),Ut=i(),A=l("p"),A.textContent=pe,Ct=i(),c(V.$$.fragment),It=i(),R=l("p"),R.textContent=oe,xt=i(),c(X.$$.fragment),kt=i(),S=l("p"),S.innerHTML=re,$t=i(),F=l("p"),F.innerHTML=me,Nt=i(),j=l("h2"),C=l("a"),rt=l("span"),c(Y.$$.fragment),Lt=i(),st=l("span"),st.textContent=he,Et=i(),z=l("p"),z.textContent=ce,Zt=i(),c(H.$$.fragment),Wt=i(),P=l("p"),P.innerHTML=de,Bt=i(),T=l("h2"),I=l("a"),mt=l("span"),c(L.$$.fragment),Dt=i(),lt=l("span"),lt.textContent=ue,Gt=i(),D=l("p"),D.innerHTML=Me,_t=i(),b=l("h2"),x=l("a"),ht=l("span"),c(q.$$.fragment),qt=i(),nt=l("span"),nt.textContent=ge,Qt=i(),c(K.$$.fragment),At=i(),c(O.$$.fragment),Vt=i(),ct=l("p"),this.h()},l(t){const a=Ee("svelte-1phssyn",document.head);y=n(a,"META",{name:!0,content:!0}),a.forEach(e),ut=p(t),it=n(t,"P",{}),h(it).forEach(e),Mt=p(t),f=n(t,"H1",{class:!0});var Xt=h(f);v=n(Xt,"A",{id:!0,class:!0,href:!0});var we=h(v);pt=n(we,"SPAN",{});var ye=h(pt);d(k.$$.fragment,ye),ye.forEach(e),we.forEach(e),Ht=p(Xt),et=n(Xt,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-clzius"&&(et.textContent=Ot),Xt.forEach(e),gt=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1bwkfja"&&($.innerHTML=te),wt=p(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-5z334a"&&(N.textContent=ee),yt=p(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1j8z7ka"&&(E.innerHTML=ae),ft=p(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-3a4dpz"&&(Z.textContent=se),Jt=p(t),J=n(t,"H2",{class:!0});var St=h(J);U=n(St,"A",{id:!0,class:!0,href:!0});var fe=h(U);ot=n(fe,"SPAN",{});var Je=h(ot);d(W.$$.fragment,Je),Je.forEach(e),fe.forEach(e),Pt=p(St),at=n(St,"SPAN",{"data-svelte-h":!0}),m(at)!=="svelte-1c1hspn"&&(at.textContent=le),St.forEach(e),jt=p(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-18ywhxh"&&(B.textContent=ne),Tt=p(t),d(G.$$.fragment,t),bt=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1c2ipa8"&&(_.textContent=ie),vt=p(t),d(Q.$$.fragment,t),Ut=p(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1n9qsq1"&&(A.textContent=pe),Ct=p(t),d(V.$$.fragment,t),It=p(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-19cnvx1"&&(R.textContent=oe),xt=p(t),d(X.$$.fragment,t),kt=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-9pmk5h"&&(S.innerHTML=re),$t=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1wmi3ea"&&(F.innerHTML=me),Nt=p(t),j=n(t,"H2",{class:!0});var Ft=h(j);C=n(Ft,"A",{id:!0,class:!0,href:!0});var je=h(C);rt=n(je,"SPAN",{});var Te=h(rt);d(Y.$$.fragment,Te),Te.forEach(e),je.forEach(e),Lt=p(Ft),st=n(Ft,"SPAN",{"data-svelte-h":!0}),m(st)!=="svelte-1viv4qv"&&(st.textContent=he),Ft.forEach(e),Et=p(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-9sr7nh"&&(z.textContent=ce),Zt=p(t),d(H.$$.fragment,t),Wt=p(t),P=n(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1kguc51"&&(P.innerHTML=de),Bt=p(t),T=n(t,"H2",{class:!0});var Yt=h(T);I=n(Yt,"A",{id:!0,class:!0,href:!0});var be=h(I);mt=n(be,"SPAN",{});var ve=h(mt);d(L.$$.fragment,ve),ve.forEach(e),be.forEach(e),Dt=p(Yt),lt=n(Yt,"SPAN",{"data-svelte-h":!0}),m(lt)!=="svelte-1ce591d"&&(lt.textContent=ue),Yt.forEach(e),Gt=p(t),D=n(t,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1n0coha"&&(D.innerHTML=Me),_t=p(t),b=n(t,"H2",{class:!0});var zt=h(b);x=n(zt,"A",{id:!0,class:!0,href:!0});var Ue=h(x);ht=n(Ue,"SPAN",{});var Ce=h(ht);d(q.$$.fragment,Ce),Ce.forEach(e),Ue.forEach(e),qt=p(zt),nt=n(zt,"SPAN",{"data-svelte-h":!0}),m(nt)!=="svelte-15mb3gy"&&(nt.textContent=ge),zt.forEach(e),Qt=p(t),d(K.$$.fragment,t),At=p(t),d(O.$$.fragment,t),Vt=p(t),ct=n(t,"P",{}),h(ct).forEach(e),this.h()},h(){o(y,"name","hf:doc:metadata"),o(y,"content",JSON.stringify(We)),o(v,"id","efficientnet-knapsack-pruned"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#efficientnet-knapsack-pruned"),o(f,"class","relative group"),o(U,"id","how-do-i-use-this-model-on-an-image"),o(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(U,"href","#how-do-i-use-this-model-on-an-image"),o(J,"class","relative group"),o(C,"id","how-do-i-finetune-this-model"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#how-do-i-finetune-this-model"),o(j,"class","relative group"),o(I,"id","how-do-i-train-this-model"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-train-this-model"),o(T,"class","relative group"),o(x,"id","citation"),o(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(x,"href","#citation"),o(b,"class","relative group")},m(t,a){r(document.head,y),s(t,ut,a),s(t,it,a),s(t,Mt,a),s(t,f,a),r(f,v),r(v,pt),u(k,pt,null),r(f,Ht),r(f,et),s(t,gt,a),s(t,$,a),s(t,wt,a),s(t,N,a),s(t,yt,a),s(t,E,a),s(t,ft,a),s(t,Z,a),s(t,Jt,a),s(t,J,a),r(J,U),r(U,ot),u(W,ot,null),r(J,Pt),r(J,at),s(t,jt,a),s(t,B,a),s(t,Tt,a),u(G,t,a),s(t,bt,a),s(t,_,a),s(t,vt,a),u(Q,t,a),s(t,Ut,a),s(t,A,a),s(t,Ct,a),u(V,t,a),s(t,It,a),s(t,R,a),s(t,xt,a),u(X,t,a),s(t,kt,a),s(t,S,a),s(t,$t,a),s(t,F,a),s(t,Nt,a),s(t,j,a),r(j,C),r(C,rt),u(Y,rt,null),r(j,Lt),r(j,st),s(t,Et,a),s(t,z,a),s(t,Zt,a),u(H,t,a),s(t,Wt,a),s(t,P,a),s(t,Bt,a),s(t,T,a),r(T,I),r(I,mt),u(L,mt,null),r(T,Dt),r(T,lt),s(t,Gt,a),s(t,D,a),s(t,_t,a),s(t,b,a),r(b,x),r(x,ht),u(q,ht,null),r(b,qt),r(b,nt),s(t,Qt,a),u(K,t,a),s(t,At,a),u(O,t,a),s(t,Vt,a),s(t,ct,a),Rt=!0},p:xe,i(t){Rt||(M(k.$$.fragment,t),M(W.$$.fragment,t),M(G.$$.fragment,t),M(Q.$$.fragment,t),M(V.$$.fragment,t),M(X.$$.fragment,t),M(Y.$$.fragment,t),M(H.$$.fragment,t),M(L.$$.fragment,t),M(q.$$.fragment,t),M(K.$$.fragment,t),M(O.$$.fragment,t),Rt=!0)},o(t){g(k.$$.fragment,t),g(W.$$.fragment,t),g(G.$$.fragment,t),g(Q.$$.fragment,t),g(V.$$.fragment,t),g(X.$$.fragment,t),g(Y.$$.fragment,t),g(H.$$.fragment,t),g(L.$$.fragment,t),g(q.$$.fragment,t),g(K.$$.fragment,t),g(O.$$.fragment,t),Rt=!1},d(t){t&&(e(ut),e(it),e(Mt),e(f),e(gt),e($),e(wt),e(N),e(yt),e(E),e(ft),e(Z),e(Jt),e(J),e(jt),e(B),e(Tt),e(bt),e(_),e(vt),e(Ut),e(A),e(Ct),e(It),e(R),e(xt),e(kt),e(S),e($t),e(F),e(Nt),e(j),e(Et),e(z),e(Zt),e(Wt),e(P),e(Bt),e(T),e(Gt),e(D),e(_t),e(b),e(Qt),e(At),e(Vt),e(ct)),e(y),w(k),w(W),w(G,t),w(Q,t),w(V,t),w(X,t),w(Y),w(H,t),w(L),w(q),w(K,t),w(O,t)}}}const We={local:"efficientnet-knapsack-pruned",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"EfficientNet (Knapsack Pruned)"};function Be(Kt){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends $e{constructor(y){super(),Ne(this,y,Be,Ze,Ie,{})}}export{Ve as component};
