import{s as Ks,o as eo,n as X}from"../chunks/scheduler.182ea377.js";import{S as to,i as no,g as l,s as o,r as g,A as so,h as r,f as i,c as a,j as x,u as f,x as y,k as C,y as t,a as m,v as u,d as h,t as _,w as b}from"../chunks/index.abf12888.js";import{T as Gt}from"../chunks/Tip.230e2334.js";import{D as J}from"../chunks/Docstring.93f6f462.js";import{C as Y}from"../chunks/CodeBlock.57fe6e13.js";import{E as St}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as nt}from"../chunks/Heading.16916d63.js";function oo(P){let n,v='For text-to-image we use <code>stabilityai/stable-diffusion-2-1-unclip-small</code> as it was trained on CLIP ViT-L/14 embedding, the same as the Karlo model prior. <a href="https://hf.co/stabilityai/stable-diffusion-2-1-unclip" rel="nofollow">stabilityai/stable-diffusion-2-1-unclip</a> was trained on OpenCLIP ViT-H, so we don’t recommend its use.';return{c(){n=l("p"),n.innerHTML=v},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1eqlm9k"&&(n.innerHTML=v)},m(d,c){m(d,n,c)},p:X,d(d){d&&i(n)}}}function ao(P){let n,v="Examples:",d,c,I;return c=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZ1c2luZyUyRnN0YWJsZS11bmNsaXAtMi0xLWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTIwJTIwJTIzJTIwVE9ETyUyMHVwZGF0ZSUyMG1vZGVsJTIwcGF0aCUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyYXN0cm9uYXV0X2hvcnNlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_horse.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=o(),g(c.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),f(c.$$.fragment,s)},m(s,w){m(s,n,w),m(s,d,w),u(c,s,w),I=!0},p:X,i(s){I||(h(c.$$.fragment,s),I=!0)},o(s){_(c.$$.fragment,s),I=!1},d(s){s&&(i(n),i(d)),b(c,s)}}}function io(P){let n,v=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=v},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ackzsn"&&(n.innerHTML=v)},m(d,c){m(d,n,c)},p:X,d(d){d&&i(n)}}}function lo(P){let n,v="Examples:",d,c,I;return c=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=o(),g(c.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),f(c.$$.fragment,s)},m(s,w){m(s,n,w),m(s,d,w),u(c,s,w),I=!0},p:X,i(s){I||(h(c.$$.fragment,s),I=!0)},o(s){_(c.$$.fragment,s),I=!1},d(s){s&&(i(n),i(d)),b(c,s)}}}function ro(P){let n,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=v},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-17p1lpg"&&(n.textContent=v)},m(d,c){m(d,n,c)},p:X,d(d){d&&i(n)}}}function po(P){let n,v="Examples:",d,c,I;return c=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=o(),g(c.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),f(c.$$.fragment,s)},m(s,w){m(s,n,w),m(s,d,w),u(c,s,w),I=!0},p:X,i(s){I||(h(c.$$.fragment,s),I=!0)},o(s){_(c.$$.fragment,s),I=!1},d(s){s&&(i(n),i(d)),b(c,s)}}}function co(P){let n,v="Examples:",d,c,I;return c=new Y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZnVzaW5nJTJGc3RhYmxlLXVuY2xpcC0yLTEtbC1pbWcyaW1nJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUyMCUyMCUyMyUyMFRPRE8lMjB1cGRhdGUlMjBtb2RlbCUyMHBhdGglMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNzY4JTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyQyUyMHRyZW5kaW5nJTIwb24lMjBhcnRzdGF0aW9uJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBpbml0X2ltYWdlKS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyZmFudGFzeV9sYW5kc2NhcGUucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l-img2img&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt, init_image).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=o(),g(c.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),f(c.$$.fragment,s)},m(s,w){m(s,n,w),m(s,d,w),u(c,s,w),I=!0},p:X,i(s){I||(h(c.$$.fragment,s),I=!0)},o(s){_(c.$$.fragment,s),I=!1},d(s){s&&(i(n),i(d)),b(c,s)}}}function mo(P){let n,v=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=v},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ackzsn"&&(n.innerHTML=v)},m(d,c){m(d,n,c)},p:X,d(d){d&&i(n)}}}function go(P){let n,v="Examples:",d,c,I;return c=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=o(),g(c.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),f(c.$$.fragment,s)},m(s,w){m(s,n,w),m(s,d,w),u(c,s,w),I=!0},p:X,i(s){I||(h(c.$$.fragment,s),I=!0)},o(s){_(c.$$.fragment,s),I=!1},d(s){s&&(i(n),i(d)),b(c,s)}}}function fo(P){let n,v=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=v},l(d){n=r(d,"P",{"data-svelte-h":!0}),y(n)!=="svelte-17p1lpg"&&(n.textContent=v)},m(d,c){m(d,n,c)},p:X,d(d){d&&i(n)}}}function uo(P){let n,v="Examples:",d,c,I;return c=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=v,d=o(),g(c.$$.fragment)},l(s){n=r(s,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=v),d=a(s),f(c.$$.fragment,s)},m(s,w){m(s,n,w),m(s,d,w),u(c,s,w),I=!0},p:X,i(s){I||(h(c.$$.fragment,s),I=!0)},o(s){_(c.$$.fragment,s),I=!1},d(s){s&&(i(n),i(d)),b(c,s)}}}function ho(P){let n,v,d,c,I,s,w,hs=`Stable unCLIP checkpoints are finetuned from <a href="./stable_diffusion/stable_diffusion_2">Stable Diffusion 2.1</a> checkpoints to condition on CLIP image embeddings.
Stable unCLIP still conditions on text embeddings. Given the two separate conditionings, stable unCLIP can be used
for text guided image variation. When combined with an unCLIP prior, it can also be used for full text to image generation.`,Bt,he,_s="The abstract from the paper is:",Vt,_e,bs="<em>Contrastive models like CLIP have been shown to learn robust representations of images that capture both semantics and style. To leverage these representations for image generation, we propose a two-stage model: a prior that generates a CLIP image embedding given a text caption, and a decoder that generates an image conditioned on the image embedding. We show that explicitly generating image representations improves image diversity with minimal loss in photorealism and caption similarity. Our decoders conditioned on image representations can also produce variations of an image that preserve both its semantics and style, while varying the non-essential details absent from the image representation. Moreover, the joint embedding space of CLIP enables language-guided image manipulations in a zero-shot fashion. We use diffusion models for the decoder and experiment with both autoregressive and diffusion models for the prior, finding that the latter are computationally more efficient and produce higher-quality samples.</em>",Nt,be,Xt,ye,ys=`Stable unCLIP takes  <code>noise_level</code> as input during inference which determines how much noise is added
to the image embeddings. A higher <code>noise_level</code> increases variation in the final un-noised images. By default,
we do not add any additional noise to the image embeddings (<code>noise_level = 0</code>).`,Ft,ve,Et,Ie,vs='Stable unCLIP can be leveraged for text-to-image generation by pipelining it with the prior model of KakaoBrain’s open source DALL-E 2 replication <a href="https://huggingface.co/kakaobrain/karlo-v1-alpha" rel="nofollow">Karlo</a>',zt,we,Rt,H,Yt,Te,Ht,$e,Qt,Me,Is="Optionally, you can also pass a prompt to <code>pipe</code> such as:",Dt,Ue,At,Pe,qt,T,xe,cn,st,ws="Pipeline for text-to-image generation using stable unCLIP.",mn,ot,Ts=`This model inherits from <a href="/docs/diffusers/v0.22.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,gn,F,Ce,fn,at,$s="The call function to the pipeline for generation.",un,Q,hn,W,Je,_n,it,Ms=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,bn,D,yn,A,vn,q,Le,In,lt,Us=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,wn,O,je,Tn,rt,Ps=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,$n,K,Ze,Mn,pt,xs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Un,S,We,Pn,dt,Cs=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,xn,ee,Cn,te,Jn,ne,Se,Ln,ct,Js='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',jn,se,ke,Zn,mt,Ls="Encodes the prompt into text encoder hidden states.",Wn,L,Ge,Sn,gt,js=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,kn,ft,Zs="The noise is applied in two ways:",Gn,ut,Ws="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",Bn,ht,Ss="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",Vn,_t,ks="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",Ot,Be,Kt,$,Ve,Nn,bt,Gs="Pipeline for text-guided image-to-image generation using stable unCLIP.",Xn,yt,Bs=`This model inherits from <a href="/docs/diffusers/v0.22.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Fn,E,Ne,En,vt,Vs="The call function to the pipeline for generation.",zn,oe,Rn,k,Xe,Yn,It,Ns=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Hn,ae,Qn,ie,Dn,le,Fe,An,wt,Xs=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,qn,re,Ee,On,Tt,Fs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Kn,pe,ze,es,$t,Es=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ts,G,Re,ns,Mt,zs=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,ss,de,os,ce,as,me,Ye,is,Ut,Rs='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',ls,ge,He,rs,Pt,Ys="Encodes the prompt into text encoder hidden states.",ps,j,Qe,ds,xt,Hs=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,cs,Ct,Qs="The noise is applied in two ways:",ms,Jt,Ds="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",gs,Lt,As="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",fs,jt,qs="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",en,De,tn,z,Ae,us,Zt,Os="Output class for image pipelines.",nn,kt,sn;return I=new nt({props:{title:"Stable unCLIP",local:"stable-unclip",headingTag:"h1"}}),be=new nt({props:{title:"Tips",local:"tips",headingTag:"h2"}}),ve=new nt({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h3"}}),we=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVW5DTElQU2NoZWR1bGVyJTJDJTIwRERQTVNjaGVkdWxlciUyQyUyMFN0YWJsZVVuQ0xJUFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy5tb2RlbHMlMjBpbXBvcnQlMjBQcmlvclRyYW5zZm9ybWVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBUb2tlbml6ZXIlMkMlMjBDTElQVGV4dE1vZGVsV2l0aFByb2plY3Rpb24lMEElMEFwcmlvcl9tb2RlbF9pZCUyMCUzRCUyMCUyMmtha2FvYnJhaW4lMkZrYXJsby12MS1hbHBoYSUyMiUwQWRhdGFfdHlwZSUyMCUzRCUyMHRvcmNoLmZsb2F0MTYlMEFwcmlvciUyMCUzRCUyMFByaW9yVHJhbnNmb3JtZXIuZnJvbV9wcmV0cmFpbmVkKHByaW9yX21vZGVsX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIycHJpb3IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRGRhdGFfdHlwZSklMEElMEFwcmlvcl90ZXh0X21vZGVsX2lkJTIwJTNEJTIwJTIyb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNCUyMiUwQXByaW9yX3Rva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHByaW9yX3RleHRfbW9kZWxfaWQpJTBBcHJpb3JfdGV4dF9tb2RlbCUyMCUzRCUyMENMSVBUZXh0TW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQocHJpb3JfdGV4dF9tb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEZGF0YV90eXBlKSUwQXByaW9yX3NjaGVkdWxlciUyMCUzRCUyMFVuQ0xJUFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocHJpb3JfbW9kZWxfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJwcmlvcl9zY2hlZHVsZXIlMjIpJTBBcHJpb3Jfc2NoZWR1bGVyJTIwJTNEJTIwRERQTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwcmlvcl9zY2hlZHVsZXIuY29uZmlnKSUwQSUwQXN0YWJsZV91bmNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLXVuY2xpcC1zbWFsbCUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVVbkNMSVBQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwc3RhYmxlX3VuY2xpcF9tb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEZGF0YV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEElMjAlMjAlMjAlMjBwcmlvcl90b2tlbml6ZXIlM0Rwcmlvcl90b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBwcmlvcl90ZXh0X2VuY29kZXIlM0Rwcmlvcl90ZXh0X21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwcHJpb3IlM0RwcmlvciUyQyUwQSUyMCUyMCUyMCUyMHByaW9yX3NjaGVkdWxlciUzRHByaW9yX3NjaGVkdWxlciUyQyUwQSklMEElMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXdhdmVfcHJvbXB0JTIwJTNEJTIwJTIyZHJhbWF0aWMlMjB3YXZlJTJDJTIwdGhlJTIwT2NlYW5zJTIwcm9hciUyQyUyMFN0cm9uZyUyMHdhdmUlMjBzcGlyYWwlMjBhY3Jvc3MlMjB0aGUlMjBvY2VhbnMlMjBhcyUyMHRoZSUyMHdhdmVzJTIwdW5mdXJsJTIwaW50byUyMHJvYXJpbmclMjBjcmVzdHMlM0IlMjBwZXJmZWN0JTIwd2F2ZSUyMGZvcm0lM0IlMjBwZXJmZWN0JTIwd2F2ZSUyMHNoYXBlJTNCJTIwZHJhbWF0aWMlMjB3YXZlJTIwc2hhcGUlM0IlMjB3YXZlJTIwc2hhcGUlMjB1bmJlbGlldmFibGUlM0IlMjB3YXZlJTNCJTIwd2F2ZSUyMHNoYXBlJTIwc3BlY3RhY3VsYXIlMjIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHdhdmVfcHJvbXB0KS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyd2F2ZXMucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UnCLIPScheduler, DDPMScheduler, StableUnCLIPPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> PriorTransformer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTokenizer, CLIPTextModelWithProjection

prior_model_id = <span class="hljs-string">&quot;kakaobrain/karlo-v1-alpha&quot;</span>
data_type = torch.float16
prior = PriorTransformer.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior&quot;</span>, torch_dtype=data_type)

prior_text_model_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
prior_tokenizer = CLIPTokenizer.from_pretrained(prior_text_model_id)
prior_text_model = CLIPTextModelWithProjection.from_pretrained(prior_text_model_id, torch_dtype=data_type)
prior_scheduler = UnCLIPScheduler.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior_scheduler&quot;</span>)
prior_scheduler = DDPMScheduler.from_config(prior_scheduler.config)

stable_unclip_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>

pipe = StableUnCLIPPipeline.from_pretrained(
    stable_unclip_model_id,
    torch_dtype=data_type,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    prior_tokenizer=prior_tokenizer,
    prior_text_encoder=prior_text_model,
    prior=prior,
    prior_scheduler=prior_scheduler,
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
wave_prompt = <span class="hljs-string">&quot;dramatic wave, the Oceans roar, Strong wave spiral across the oceans as the waves unfurl into roaring crests; perfect wave form; perfect wave shape; dramatic wave shape; wave shape unbelievable; wave; wave shape spectacular&quot;</span>

images = pipe(prompt=wave_prompt).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;waves.png&quot;</span>)`,wrap:!1}}),H=new Gt({props:{warning:!0,$$slots:{default:[oo]},$$scope:{ctx:P}}}),Te=new nt({props:{title:"Text guided Image-to-Image Variation",local:"text-guided-image-to-image-variation",headingTag:"h3"}}),$e=new Y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLXVuY2xpcCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhdGlvbiUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3RhYmxlX3VuY2xpcCUyRnRhcnNpbGFfZG9fYW1hcmFsLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKGluaXRfaW1hZ2UpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJ2YXJpYXRpb25faW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip&quot;</span>, torch_dtype=torch.float16, variation=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/stable_unclip/tarsila_do_amaral.png&quot;</span>
init_image = load_image(url)

images = pipe(init_image).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;variation_image.png&quot;</span>)`,wrap:!1}}),Ue=new Y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoaW5pdF9pbWFnZSUyQyUyMHByb21wdCUzRHByb21wdCkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMnZhcmlhdGlvbl9pbWFnZV90d28ucG5nJTIyKQ==",highlighted:`prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

images = pipe(init_image, prompt=prompt).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;variation_image_two.png&quot;</span>)`,wrap:!1}}),Pe=new nt({props:{title:"StableUnCLIPPipeline",local:"diffusers.StableUnCLIPPipeline",headingTag:"h2"}}),xe=new J({props:{name:"class diffusers.StableUnCLIPPipeline",anchor:"diffusers.StableUnCLIPPipeline",parameters:[{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior",val:": PriorTransformer"},{name:"prior_scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"prior_tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen <code>CLIPTextModelWithProjection</code> text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.StableUnCLIPPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Scheduler used in the prior denoising process.`,name:"prior_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen <code>CLIPTextModel</code> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.22.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L61"}}),Ce=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10.0"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"noise_level",val:": int = 0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps in the prior denoising process. More denoising steps usually lead to a
higher quality image at the expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"prior_guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_latents",description:`<strong>prior_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
embedding generation in the prior denoising process. Can be used to tweak the same generation with
different prompts. If not provided, a latents tensor is generated by sampling using the supplied random
<code>generator</code>.`,name:"prior_latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L652",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Q=new St({props:{anchor:"diffusers.StableUnCLIPPipeline.__call__.example",$$slots:{default:[ao]},$$scope:{ctx:P}}}),Je=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L2023"}}),D=new Gt({props:{warning:!0,$$slots:{default:[io]},$$scope:{ctx:P}}}),A=new St({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.example",$$slots:{default:[lo]},$$scope:{ctx:P}}}),Le=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L2063"}}),je=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L154"}}),Ze=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L162"}}),We=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L1962"}}),ee=new Gt({props:{warning:!0,$$slots:{default:[ro]},$$scope:{ctx:P}}}),te=new St({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[po]},$$scope:{ctx:P}}}),Se=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L1997"}}),ke=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L305"}}),Ge=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": typing.Optional[torch.FloatTensor] = None"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L606"}}),Be=new nt({props:{title:"StableUnCLIPImg2ImgPipeline",local:"diffusers.StableUnCLIPImg2ImgPipeline",headingTag:"h2"}}),Ve=new J({props:{name:"class diffusers.StableUnCLIPImg2ImgPipeline",anchor:"diffusers.StableUnCLIPImg2ImgPipeline",parameters:[{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
Feature extractor for image pre-processing before being encoded.`,name:"feature_extractor"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
CLIP vision model for encoding images.`,name:"image_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>~transformers.CLIPTokenizer</code>) &#x2014;
A [<code>~transformers.CLIPTokenizer</code>)].`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen <a href="https://huggingface.co/docs/transformers/v4.35.0/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.22.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.22.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L72"}}),Ne=new J({props:{name:"__call__",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__",parameters:[{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"noise_level",val:": int = 0"},{name:"image_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, either <code>prompt_embeds</code> will be
used or prompt is initialized to <code>&quot;&quot;</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code> or tensor representing an image batch. The image is encoded to its CLIP embedding which the
<code>unet</code> is conditioned on. The image is <em>not</em> encoded by the <code>vae</code> and then used as the latents in the
denoising process like it is in the standard Stable Diffusion text-guided image variation process.`,name:"image"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.22.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated CLIP embeddings to condition the <code>unet</code> on. These latents are not used in the denoising
process. If you want to provide pre-generated latents, pass them to <code>__call__</code> as <code>latents</code>.`,name:"image_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.22.0/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),oe=new St({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.example",$$slots:{default:[co]},$$scope:{ctx:P}}}),Xe=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L2023"}}),ae=new Gt({props:{warning:!0,$$slots:{default:[mo]},$$scope:{ctx:P}}}),ie=new St({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[go]},$$scope:{ctx:P}}}),Fe=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L2063"}}),Ee=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L155"}}),ze=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L163"}}),Re=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L1962"}}),de=new Gt({props:{warning:!0,$$slots:{default:[fo]},$$scope:{ctx:P}}}),ce=new St({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[uo]},$$scope:{ctx:P}}}),Ye=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L1997"}}),He=new J({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L259"}}),Qe=new J({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": typing.Optional[torch.FloatTensor] = None"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L572"}}),De=new nt({props:{title:"ImagePipelineOutput",local:"diffusers.ImagePipelineOutput",headingTag:"h2"}}),Ae=new J({props:{name:"class diffusers.ImagePipelineOutput",anchor:"diffusers.ImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.ImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/v0.22.0/src/diffusers/pipelines/pipeline_utils.py#L110"}}),{c(){n=l("meta"),v=o(),d=l("p"),c=o(),g(I.$$.fragment),s=o(),w=l("p"),w.innerHTML=hs,Bt=o(),he=l("p"),he.textContent=_s,Vt=o(),_e=l("p"),_e.innerHTML=bs,Nt=o(),g(be.$$.fragment),Xt=o(),ye=l("p"),ye.innerHTML=ys,Ft=o(),g(ve.$$.fragment),Et=o(),Ie=l("p"),Ie.innerHTML=vs,zt=o(),g(we.$$.fragment),Rt=o(),g(H.$$.fragment),Yt=o(),g(Te.$$.fragment),Ht=o(),g($e.$$.fragment),Qt=o(),Me=l("p"),Me.innerHTML=Is,Dt=o(),g(Ue.$$.fragment),At=o(),g(Pe.$$.fragment),qt=o(),T=l("div"),g(xe.$$.fragment),cn=o(),st=l("p"),st.textContent=ws,mn=o(),ot=l("p"),ot.innerHTML=Ts,gn=o(),F=l("div"),g(Ce.$$.fragment),fn=o(),at=l("p"),at.textContent=$s,un=o(),g(Q.$$.fragment),hn=o(),W=l("div"),g(Je.$$.fragment),_n=o(),it=l("p"),it.textContent=Ms,bn=o(),g(D.$$.fragment),yn=o(),g(A.$$.fragment),vn=o(),q=l("div"),g(Le.$$.fragment),In=o(),lt=l("p"),lt.innerHTML=Us,wn=o(),O=l("div"),g(je.$$.fragment),Tn=o(),rt=l("p"),rt.textContent=Ps,$n=o(),K=l("div"),g(Ze.$$.fragment),Mn=o(),pt=l("p"),pt.innerHTML=xs,Un=o(),S=l("div"),g(We.$$.fragment),Pn=o(),dt=l("p"),dt.innerHTML=Cs,xn=o(),g(ee.$$.fragment),Cn=o(),g(te.$$.fragment),Jn=o(),ne=l("div"),g(Se.$$.fragment),Ln=o(),ct=l("p"),ct.innerHTML=Js,jn=o(),se=l("div"),g(ke.$$.fragment),Zn=o(),mt=l("p"),mt.textContent=Ls,Wn=o(),L=l("div"),g(Ge.$$.fragment),Sn=o(),gt=l("p"),gt.innerHTML=js,kn=o(),ft=l("p"),ft.textContent=Zs,Gn=o(),ut=l("ol"),ut.innerHTML=Ws,Bn=o(),ht=l("p"),ht.innerHTML=Ss,Vn=o(),_t=l("p"),_t.textContent=ks,Ot=o(),g(Be.$$.fragment),Kt=o(),$=l("div"),g(Ve.$$.fragment),Nn=o(),bt=l("p"),bt.textContent=Gs,Xn=o(),yt=l("p"),yt.innerHTML=Bs,Fn=o(),E=l("div"),g(Ne.$$.fragment),En=o(),vt=l("p"),vt.textContent=Vs,zn=o(),g(oe.$$.fragment),Rn=o(),k=l("div"),g(Xe.$$.fragment),Yn=o(),It=l("p"),It.textContent=Ns,Hn=o(),g(ae.$$.fragment),Qn=o(),g(ie.$$.fragment),Dn=o(),le=l("div"),g(Fe.$$.fragment),An=o(),wt=l("p"),wt.innerHTML=Xs,qn=o(),re=l("div"),g(Ee.$$.fragment),On=o(),Tt=l("p"),Tt.textContent=Fs,Kn=o(),pe=l("div"),g(ze.$$.fragment),es=o(),$t=l("p"),$t.innerHTML=Es,ts=o(),G=l("div"),g(Re.$$.fragment),ns=o(),Mt=l("p"),Mt.innerHTML=zs,ss=o(),g(de.$$.fragment),os=o(),g(ce.$$.fragment),as=o(),me=l("div"),g(Ye.$$.fragment),is=o(),Ut=l("p"),Ut.innerHTML=Rs,ls=o(),ge=l("div"),g(He.$$.fragment),rs=o(),Pt=l("p"),Pt.textContent=Ys,ps=o(),j=l("div"),g(Qe.$$.fragment),ds=o(),xt=l("p"),xt.innerHTML=Hs,cs=o(),Ct=l("p"),Ct.textContent=Qs,ms=o(),Jt=l("ol"),Jt.innerHTML=Ds,gs=o(),Lt=l("p"),Lt.innerHTML=As,fs=o(),jt=l("p"),jt.textContent=qs,en=o(),g(De.$$.fragment),tn=o(),z=l("div"),g(Ae.$$.fragment),us=o(),Zt=l("p"),Zt.textContent=Os,nn=o(),kt=l("p"),this.h()},l(e){const p=so("svelte-u9bgzb",document.head);n=r(p,"META",{name:!0,content:!0}),p.forEach(i),v=a(e),d=r(e,"P",{}),x(d).forEach(i),c=a(e),f(I.$$.fragment,e),s=a(e),w=r(e,"P",{"data-svelte-h":!0}),y(w)!=="svelte-bd6hsa"&&(w.innerHTML=hs),Bt=a(e),he=r(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-1cwsb16"&&(he.textContent=_s),Vt=a(e),_e=r(e,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-ha34c8"&&(_e.innerHTML=bs),Nt=a(e),f(be.$$.fragment,e),Xt=a(e),ye=r(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-30kfzk"&&(ye.innerHTML=ys),Ft=a(e),f(ve.$$.fragment,e),Et=a(e),Ie=r(e,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-1i5fgej"&&(Ie.innerHTML=vs),zt=a(e),f(we.$$.fragment,e),Rt=a(e),f(H.$$.fragment,e),Yt=a(e),f(Te.$$.fragment,e),Ht=a(e),f($e.$$.fragment,e),Qt=a(e),Me=r(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-1mvqeru"&&(Me.innerHTML=Is),Dt=a(e),f(Ue.$$.fragment,e),At=a(e),f(Pe.$$.fragment,e),qt=a(e),T=r(e,"DIV",{class:!0});var M=x(T);f(xe.$$.fragment,M),cn=a(M),st=r(M,"P",{"data-svelte-h":!0}),y(st)!=="svelte-2c89j6"&&(st.textContent=ws),mn=a(M),ot=r(M,"P",{"data-svelte-h":!0}),y(ot)!=="svelte-cgt1gx"&&(ot.innerHTML=Ts),gn=a(M),F=r(M,"DIV",{class:!0});var R=x(F);f(Ce.$$.fragment,R),fn=a(R),at=r(R,"P",{"data-svelte-h":!0}),y(at)!=="svelte-50j04k"&&(at.textContent=$s),un=a(R),f(Q.$$.fragment,R),R.forEach(i),hn=a(M),W=r(M,"DIV",{class:!0});var V=x(W);f(Je.$$.fragment,V),_n=a(V),it=r(V,"P",{"data-svelte-h":!0}),y(it)!=="svelte-10jaql7"&&(it.textContent=Ms),bn=a(V),f(D.$$.fragment,V),yn=a(V),f(A.$$.fragment,V),V.forEach(i),vn=a(M),q=r(M,"DIV",{class:!0});var qe=x(q);f(Le.$$.fragment,qe),In=a(qe),lt=r(qe,"P",{"data-svelte-h":!0}),y(lt)!=="svelte-1lh0nh5"&&(lt.innerHTML=Us),qe.forEach(i),wn=a(M),O=r(M,"DIV",{class:!0});var Oe=x(O);f(je.$$.fragment,Oe),Tn=a(Oe),rt=r(Oe,"P",{"data-svelte-h":!0}),y(rt)!=="svelte-14bnrb6"&&(rt.textContent=Ps),Oe.forEach(i),$n=a(M),K=r(M,"DIV",{class:!0});var Ke=x(K);f(Ze.$$.fragment,Ke),Mn=a(Ke),pt=r(Ke,"P",{"data-svelte-h":!0}),y(pt)!=="svelte-1s3c06i"&&(pt.innerHTML=xs),Ke.forEach(i),Un=a(M),S=r(M,"DIV",{class:!0});var N=x(S);f(We.$$.fragment,N),Pn=a(N),dt=r(N,"P",{"data-svelte-h":!0}),y(dt)!=="svelte-e03q3e"&&(dt.innerHTML=Cs),xn=a(N),f(ee.$$.fragment,N),Cn=a(N),f(te.$$.fragment,N),N.forEach(i),Jn=a(M),ne=r(M,"DIV",{class:!0});var et=x(ne);f(Se.$$.fragment,et),Ln=a(et),ct=r(et,"P",{"data-svelte-h":!0}),y(ct)!=="svelte-1vfte1e"&&(ct.innerHTML=Js),et.forEach(i),jn=a(M),se=r(M,"DIV",{class:!0});var tt=x(se);f(ke.$$.fragment,tt),Zn=a(tt),mt=r(tt,"P",{"data-svelte-h":!0}),y(mt)!=="svelte-16q0ax1"&&(mt.textContent=Ls),tt.forEach(i),Wn=a(M),L=r(M,"DIV",{class:!0});var Z=x(L);f(Ge.$$.fragment,Z),Sn=a(Z),gt=r(Z,"P",{"data-svelte-h":!0}),y(gt)!=="svelte-1e71opl"&&(gt.innerHTML=js),kn=a(Z),ft=r(Z,"P",{"data-svelte-h":!0}),y(ft)!=="svelte-acyrt"&&(ft.textContent=Zs),Gn=a(Z),ut=r(Z,"OL",{"data-svelte-h":!0}),y(ut)!=="svelte-114uhci"&&(ut.innerHTML=Ws),Bn=a(Z),ht=r(Z,"P",{"data-svelte-h":!0}),y(ht)!=="svelte-46dthp"&&(ht.innerHTML=Ss),Vn=a(Z),_t=r(Z,"P",{"data-svelte-h":!0}),y(_t)!=="svelte-4ngutd"&&(_t.textContent=ks),Z.forEach(i),M.forEach(i),Ot=a(e),f(Be.$$.fragment,e),Kt=a(e),$=r(e,"DIV",{class:!0});var U=x($);f(Ve.$$.fragment,U),Nn=a(U),bt=r(U,"P",{"data-svelte-h":!0}),y(bt)!=="svelte-y15i80"&&(bt.textContent=Gs),Xn=a(U),yt=r(U,"P",{"data-svelte-h":!0}),y(yt)!=="svelte-cgt1gx"&&(yt.innerHTML=Bs),Fn=a(U),E=r(U,"DIV",{class:!0});var Wt=x(E);f(Ne.$$.fragment,Wt),En=a(Wt),vt=r(Wt,"P",{"data-svelte-h":!0}),y(vt)!=="svelte-50j04k"&&(vt.textContent=Vs),zn=a(Wt),f(oe.$$.fragment,Wt),Wt.forEach(i),Rn=a(U),k=r(U,"DIV",{class:!0});var fe=x(k);f(Xe.$$.fragment,fe),Yn=a(fe),It=r(fe,"P",{"data-svelte-h":!0}),y(It)!=="svelte-10jaql7"&&(It.textContent=Ns),Hn=a(fe),f(ae.$$.fragment,fe),Qn=a(fe),f(ie.$$.fragment,fe),fe.forEach(i),Dn=a(U),le=r(U,"DIV",{class:!0});var on=x(le);f(Fe.$$.fragment,on),An=a(on),wt=r(on,"P",{"data-svelte-h":!0}),y(wt)!=="svelte-1lh0nh5"&&(wt.innerHTML=Xs),on.forEach(i),qn=a(U),re=r(U,"DIV",{class:!0});var an=x(re);f(Ee.$$.fragment,an),On=a(an),Tt=r(an,"P",{"data-svelte-h":!0}),y(Tt)!=="svelte-14bnrb6"&&(Tt.textContent=Fs),an.forEach(i),Kn=a(U),pe=r(U,"DIV",{class:!0});var ln=x(pe);f(ze.$$.fragment,ln),es=a(ln),$t=r(ln,"P",{"data-svelte-h":!0}),y($t)!=="svelte-1s3c06i"&&($t.innerHTML=Es),ln.forEach(i),ts=a(U),G=r(U,"DIV",{class:!0});var ue=x(G);f(Re.$$.fragment,ue),ns=a(ue),Mt=r(ue,"P",{"data-svelte-h":!0}),y(Mt)!=="svelte-e03q3e"&&(Mt.innerHTML=zs),ss=a(ue),f(de.$$.fragment,ue),os=a(ue),f(ce.$$.fragment,ue),ue.forEach(i),as=a(U),me=r(U,"DIV",{class:!0});var rn=x(me);f(Ye.$$.fragment,rn),is=a(rn),Ut=r(rn,"P",{"data-svelte-h":!0}),y(Ut)!=="svelte-1vfte1e"&&(Ut.innerHTML=Rs),rn.forEach(i),ls=a(U),ge=r(U,"DIV",{class:!0});var pn=x(ge);f(He.$$.fragment,pn),rs=a(pn),Pt=r(pn,"P",{"data-svelte-h":!0}),y(Pt)!=="svelte-16q0ax1"&&(Pt.textContent=Ys),pn.forEach(i),ps=a(U),j=r(U,"DIV",{class:!0});var B=x(j);f(Qe.$$.fragment,B),ds=a(B),xt=r(B,"P",{"data-svelte-h":!0}),y(xt)!=="svelte-1e71opl"&&(xt.innerHTML=Hs),cs=a(B),Ct=r(B,"P",{"data-svelte-h":!0}),y(Ct)!=="svelte-acyrt"&&(Ct.textContent=Qs),ms=a(B),Jt=r(B,"OL",{"data-svelte-h":!0}),y(Jt)!=="svelte-114uhci"&&(Jt.innerHTML=Ds),gs=a(B),Lt=r(B,"P",{"data-svelte-h":!0}),y(Lt)!=="svelte-46dthp"&&(Lt.innerHTML=As),fs=a(B),jt=r(B,"P",{"data-svelte-h":!0}),y(jt)!=="svelte-4ngutd"&&(jt.textContent=qs),B.forEach(i),U.forEach(i),en=a(e),f(De.$$.fragment,e),tn=a(e),z=r(e,"DIV",{class:!0});var dn=x(z);f(Ae.$$.fragment,dn),us=a(dn),Zt=r(dn,"P",{"data-svelte-h":!0}),y(Zt)!=="svelte-19wetgi"&&(Zt.textContent=Os),dn.forEach(i),nn=a(e),kt=r(e,"P",{}),x(kt).forEach(i),this.h()},h(){C(n,"name","hf:doc:metadata"),C(n,"content",_o),C(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,n),m(e,v,p),m(e,d,p),m(e,c,p),u(I,e,p),m(e,s,p),m(e,w,p),m(e,Bt,p),m(e,he,p),m(e,Vt,p),m(e,_e,p),m(e,Nt,p),u(be,e,p),m(e,Xt,p),m(e,ye,p),m(e,Ft,p),u(ve,e,p),m(e,Et,p),m(e,Ie,p),m(e,zt,p),u(we,e,p),m(e,Rt,p),u(H,e,p),m(e,Yt,p),u(Te,e,p),m(e,Ht,p),u($e,e,p),m(e,Qt,p),m(e,Me,p),m(e,Dt,p),u(Ue,e,p),m(e,At,p),u(Pe,e,p),m(e,qt,p),m(e,T,p),u(xe,T,null),t(T,cn),t(T,st),t(T,mn),t(T,ot),t(T,gn),t(T,F),u(Ce,F,null),t(F,fn),t(F,at),t(F,un),u(Q,F,null),t(T,hn),t(T,W),u(Je,W,null),t(W,_n),t(W,it),t(W,bn),u(D,W,null),t(W,yn),u(A,W,null),t(T,vn),t(T,q),u(Le,q,null),t(q,In),t(q,lt),t(T,wn),t(T,O),u(je,O,null),t(O,Tn),t(O,rt),t(T,$n),t(T,K),u(Ze,K,null),t(K,Mn),t(K,pt),t(T,Un),t(T,S),u(We,S,null),t(S,Pn),t(S,dt),t(S,xn),u(ee,S,null),t(S,Cn),u(te,S,null),t(T,Jn),t(T,ne),u(Se,ne,null),t(ne,Ln),t(ne,ct),t(T,jn),t(T,se),u(ke,se,null),t(se,Zn),t(se,mt),t(T,Wn),t(T,L),u(Ge,L,null),t(L,Sn),t(L,gt),t(L,kn),t(L,ft),t(L,Gn),t(L,ut),t(L,Bn),t(L,ht),t(L,Vn),t(L,_t),m(e,Ot,p),u(Be,e,p),m(e,Kt,p),m(e,$,p),u(Ve,$,null),t($,Nn),t($,bt),t($,Xn),t($,yt),t($,Fn),t($,E),u(Ne,E,null),t(E,En),t(E,vt),t(E,zn),u(oe,E,null),t($,Rn),t($,k),u(Xe,k,null),t(k,Yn),t(k,It),t(k,Hn),u(ae,k,null),t(k,Qn),u(ie,k,null),t($,Dn),t($,le),u(Fe,le,null),t(le,An),t(le,wt),t($,qn),t($,re),u(Ee,re,null),t(re,On),t(re,Tt),t($,Kn),t($,pe),u(ze,pe,null),t(pe,es),t(pe,$t),t($,ts),t($,G),u(Re,G,null),t(G,ns),t(G,Mt),t(G,ss),u(de,G,null),t(G,os),u(ce,G,null),t($,as),t($,me),u(Ye,me,null),t(me,is),t(me,Ut),t($,ls),t($,ge),u(He,ge,null),t(ge,rs),t(ge,Pt),t($,ps),t($,j),u(Qe,j,null),t(j,ds),t(j,xt),t(j,cs),t(j,Ct),t(j,ms),t(j,Jt),t(j,gs),t(j,Lt),t(j,fs),t(j,jt),m(e,en,p),u(De,e,p),m(e,tn,p),m(e,z,p),u(Ae,z,null),t(z,us),t(z,Zt),m(e,nn,p),m(e,kt,p),sn=!0},p(e,[p]){const M={};p&2&&(M.$$scope={dirty:p,ctx:e}),H.$set(M);const R={};p&2&&(R.$$scope={dirty:p,ctx:e}),Q.$set(R);const V={};p&2&&(V.$$scope={dirty:p,ctx:e}),D.$set(V);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:e}),A.$set(qe);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),ee.$set(Oe);const Ke={};p&2&&(Ke.$$scope={dirty:p,ctx:e}),te.$set(Ke);const N={};p&2&&(N.$$scope={dirty:p,ctx:e}),oe.$set(N);const et={};p&2&&(et.$$scope={dirty:p,ctx:e}),ae.$set(et);const tt={};p&2&&(tt.$$scope={dirty:p,ctx:e}),ie.$set(tt);const Z={};p&2&&(Z.$$scope={dirty:p,ctx:e}),de.$set(Z);const U={};p&2&&(U.$$scope={dirty:p,ctx:e}),ce.$set(U)},i(e){sn||(h(I.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(H.$$.fragment,e),h(Te.$$.fragment,e),h($e.$$.fragment,e),h(Ue.$$.fragment,e),h(Pe.$$.fragment,e),h(xe.$$.fragment,e),h(Ce.$$.fragment,e),h(Q.$$.fragment,e),h(Je.$$.fragment,e),h(D.$$.fragment,e),h(A.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(Se.$$.fragment,e),h(ke.$$.fragment,e),h(Ge.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(oe.$$.fragment,e),h(Xe.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(Fe.$$.fragment,e),h(Ee.$$.fragment,e),h(ze.$$.fragment,e),h(Re.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(Ye.$$.fragment,e),h(He.$$.fragment,e),h(Qe.$$.fragment,e),h(De.$$.fragment,e),h(Ae.$$.fragment,e),sn=!0)},o(e){_(I.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(H.$$.fragment,e),_(Te.$$.fragment,e),_($e.$$.fragment,e),_(Ue.$$.fragment,e),_(Pe.$$.fragment,e),_(xe.$$.fragment,e),_(Ce.$$.fragment,e),_(Q.$$.fragment,e),_(Je.$$.fragment,e),_(D.$$.fragment,e),_(A.$$.fragment,e),_(Le.$$.fragment,e),_(je.$$.fragment,e),_(Ze.$$.fragment,e),_(We.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(Se.$$.fragment,e),_(ke.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(Ve.$$.fragment,e),_(Ne.$$.fragment,e),_(oe.$$.fragment,e),_(Xe.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(Fe.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(Re.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(Ye.$$.fragment,e),_(He.$$.fragment,e),_(Qe.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),sn=!1},d(e){e&&(i(v),i(d),i(c),i(s),i(w),i(Bt),i(he),i(Vt),i(_e),i(Nt),i(Xt),i(ye),i(Ft),i(Et),i(Ie),i(zt),i(Rt),i(Yt),i(Ht),i(Qt),i(Me),i(Dt),i(At),i(qt),i(T),i(Ot),i(Kt),i($),i(en),i(tn),i(z),i(nn),i(kt)),i(n),b(I,e),b(be,e),b(ve,e),b(we,e),b(H,e),b(Te,e),b($e,e),b(Ue,e),b(Pe,e),b(xe),b(Ce),b(Q),b(Je),b(D),b(A),b(Le),b(je),b(Ze),b(We),b(ee),b(te),b(Se),b(ke),b(Ge),b(Be,e),b(Ve),b(Ne),b(oe),b(Xe),b(ae),b(ie),b(Fe),b(Ee),b(ze),b(Re),b(de),b(ce),b(Ye),b(He),b(Qe),b(De,e),b(Ae)}}}const _o='{"title":"Stable unCLIP","local":"stable-unclip","sections":[{"title":"Tips","local":"tips","sections":[{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":3},{"title":"Text guided Image-to-Image Variation","local":"text-guided-image-to-image-variation","sections":[],"depth":3}],"depth":2},{"title":"StableUnCLIPPipeline","local":"diffusers.StableUnCLIPPipeline","sections":[],"depth":2},{"title":"StableUnCLIPImg2ImgPipeline","local":"diffusers.StableUnCLIPImg2ImgPipeline","sections":[],"depth":2},{"title":"ImagePipelineOutput","local":"diffusers.ImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function bo(P){return eo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Uo extends to{constructor(n){super(),no(this,n,bo,ho,Ks,{})}}export{Uo as component};
